import { Component, Input, OnChanges } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { Breadcrumb } from './breadcrumb.interface';

@Component({
  selector: 'bre-breadcrumbs',
  templateUrl: './breadcrumbs.component.html',
  styleUrls: ['./breadcrumbs.component.scss']
})
export class BreadcrumbsComponent implements OnChanges {
  @Input() breadcrumbs: Breadcrumb[];

  public prevBreadcrumbs: Breadcrumb[];
  public currentBreadcrumb: Breadcrumb;
  private _breadcrumbs: Breadcrumb[];

  constructor(private activatedRoute: ActivatedRoute) {
    this.activatedRoute?.url?.subscribe(() => {
      if (!this.breadcrumbs) {
        // initiate builder based on root route
        this._breadcrumbs = this.buildBreadCrumb(this.activatedRoute.root);

        // conditionally define previous and current breadcrumbs depending on length of total breadcrumbs
        if (this._breadcrumbs.length >= 1) {
          this.prevBreadcrumbs = this._breadcrumbs.slice(0, this._breadcrumbs.length - 1);
          this.currentBreadcrumb = this._breadcrumbs[this._breadcrumbs.length - 1];
        }
      }
    });
  }

  ngOnChanges(changes) {
    if (changes.breadcrumbs && this.breadcrumbs) {
      this.prevBreadcrumbs = this.breadcrumbs.slice(0, this.breadcrumbs.length - 1);
      this.currentBreadcrumb = this.breadcrumbs[this.breadcrumbs.length - 1];
    }
  }

  private buildBreadCrumb(route: ActivatedRoute, url: string = '', breadcrumbs: Breadcrumb[] = []): Breadcrumb[] {
    // use 'breadcrumb' value in route's data object for the label
    const label = route?.routeConfig?.data?.breadcrumb ? route.routeConfig.data.breadcrumb : '';
    const path = route?.snapshot?.url?.length > 0 ? route.snapshot.url.map(x => x.path).join('/') : '';

    const nextUrl = path ? `${url}/${path}` : url;

    const breadcrumb: Breadcrumb = {
      label: label,
      url: nextUrl,
    };

    // recursively generate breadcrumbs based upon child routes
    const newBreadcrumbs = breadcrumb.label ? [...breadcrumbs, breadcrumb] : [...breadcrumbs];
    if (route.firstChild) {
      return this.buildBreadCrumb(route.firstChild, nextUrl, newBreadcrumbs);
    }
    return newBreadcrumbs;
  }
}