import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { ActivatedRoute } from '@angular/router';
import { RouterTestingModule } from '@angular/router/testing';

import { BreadcrumbsComponent } from './breadcrumbs.component';
import { Component } from '@angular/core';

@Component({
  selector: 'bre-mock',
  template: '<p>Mock Component</p>'
})
class MockComponent { }

describe('BreadcrumbsComponent', () => {
  let component: BreadcrumbsComponent;
  let fixture: ComponentFixture<BreadcrumbsComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [
        RouterTestingModule.withRoutes([
          { path: 'test', component: MockComponent, data: { breadcrumb: 'Test 1' } }
        ]),
      ],
      providers: [
        {
          provide: ActivatedRoute,
          useValue: {
            root: {
              routeConfig: {
                data: { breadcrumb: 'Test 1' }
              },
              snapshot: {
                url: [{ path: 'foo' }]
              },
              firstChild: {
                routeConfig: {
                  data: { breadcrumb: 'Test 2' }
                },
                snapshot: {
                  url: [{ path: 'bar' }]
                },
                firstChild: {
                  routeConfig: {
                    data: { breadcrumb: 'Test 3' }
                  },
                  snapshot: {
                    url: [{ path: 'baz' }]
                  }
                }
              }
            },
            url: {
              subscribe: fn => fn()
            }
          },
        },
      ],
      declarations: [BreadcrumbsComponent, MockComponent]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(BreadcrumbsComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should have a current breadcrumb and previous crumbs based on the route', () => {
    expect(component.currentBreadcrumb).toBeDefined();
    expect(component.prevBreadcrumbs).toBeDefined();
    expect(component.currentBreadcrumb.label).toBe('Test 3');
    expect(component.prevBreadcrumbs).toEqual([{ label: 'Test 1', url: '/foo' }, { label: 'Test 2', url: '/foo/bar' }]);
  });

  it('should properly show input breadcrumbs', () => {
    component.breadcrumbs = [
      { label: 'Item 1', url: '/foo' },
      { label: 'Item 2', url: '/bar' },
      { label: 'Item 3', url: '/foobar' },
    ];
    component.ngOnChanges({ breadcrumbs: true });

    expect(component.currentBreadcrumb.label).toBe('Item 3');
    expect(component.prevBreadcrumbs).toEqual([{ label: 'Item 1', url: '/foo' }, { label: 'Item 2', url: '/bar' }]);
  });
});
