import { Component, OnInit } from '@angular/core';

@Component({
  selector: 'bre-basic-elements-page',
  templateUrl: './basic-elements-page.component.html',
  styleUrls: ['./basic-elements-page.component.scss']
})
export class BasicElementsPageComponent implements OnInit {
  checkboxDropdownWithPills = {
    placeholderText: "Search",
    labelText: "Search Items",
    checkboxList: [
      {
        label: "Red",
        checked: false,
        value: "Red",
        name: "Color",
      },
      {
        label: "Yellow",
        checked: false,
        value: "Yellow",
        name: "Color",
      },
      {
        label: "Green",
        checked: false,
        value: "Green",
        name: "Color",
      },
      {
        label: "Blue",
        checked: false,
        value: "Blue",
        name: "Color",
      },
      {
        label: "Black",
        checked: false,
        value: "Black",
        name: "Color",
      },
      {
        label: "White",
        checked: false,
        value: "White",
        name: "Color",
      },
    ],
    changeData: () => {
      this.checkboxDropdownWithPills.checkboxList = [
        {
          label: "Blue",
          checked: false,
          value: "Blue",
          name: "Color",
        },
        {
          label: "Black",
          checked: false,
          value: "Black",
          name: "Color",
        },
        {
          label: "White",
          checked: false,
          value: "White",
          name: "Color",
        },
      ];
    },
  };
  autoComplete = {
    options: [],
    selectedOptions: [],
    loadOptions: (query: string) => {
      this.autoComplete.options = [
        { label: "Item 1", value: "1" },
        { label: "Item 2", value: "2" },
      ].filter((x) => x.label.toLowerCase().includes(query.toLowerCase()));
    },
  };

  constructor() { }

  ngOnInit(): void {
    
  }

}
