import { Component, Input, Output, EventEmitter, OnChanges } from '@angular/core';
import { SelectItem } from 'primeng/api';
import {
  FilterChangeEvent,
  FilterOption
} from '../filter-group/filter.interface';

@Component({
  selector: 'bre-auto-complete',
  templateUrl: './auto-complete.component.html',
  styleUrls: ['./auto-complete.component.scss']
})
export class AutoCompleteComponent implements OnChanges {
  @Input() selected: any[];
  @Input() options: FilterOption[];
  @Input() placeholder: string;
  @Output() filterSelected: EventEmitter<FilterChangeEvent> = new EventEmitter();
  @Output() loadOptions: EventEmitter<string> = new EventEmitter();

  public selectedItems: SelectItem[] = [];

  constructor() { }

  ngOnChanges(changes): void {
    if (changes.options || changes.selected) {
      if (this.selected) {
        this.selectedItems = this.options?.filter(x => this.selected.indexOf(x.value) !== -1);
      }
    }
  }

  onComplete(event): void {
    this.loadOptions.emit(event.query);
  }

  isItemSelected(item: FilterOption): boolean {
    return !!this.selectedItems.find(el => el.value === item.value);
  }

  handleSelect(event): void {
    this.emitFilterSelected(event);
  }

  handleUnselect(event): void {
    this.emitFilterSelected(event);
  }

  private emitFilterSelected(event): void {
    this.filterSelected.emit({
      value: this.selectedItems.map(el => el.value)
    });
  }

  clearSelections(): void {
    this.selectedItems = [];
    this.emitFilterSelected({});
  }
}
