import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { FormsModule } from '@angular/forms';
import { ButtonModule } from 'primeng/button';
import { AutoCompleteComponent } from './auto-complete.component';
import { AutoCompleteModule } from 'primeng/autocomplete';
import { FilterOption } from '../filter-group/filter.interface';

describe('AutoCompleteComponent', () => {
  let component: AutoCompleteComponent;
  let fixture: ComponentFixture<AutoCompleteComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [FormsModule, ButtonModule, AutoCompleteModule],
      declarations: [AutoCompleteComponent]
    }).compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(AutoCompleteComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should filter options upon selection as selected items', () => {
    
    const item1: FilterOption = {label: '1', value: 1};
    const item2: FilterOption = {label: '2', value: 2};
    component.options = [item1, item2];
    component.selected = [item1];
    component.selectedItems = [];
    const testChanges1 = { selected: [item1] };
    const spy = spyOn(component.options, 'filter');

    component.ngOnChanges(testChanges1);
    expect(spy).toHaveBeenCalled();
  });

  it('should emit a load event on completion', () => {
    const event = {query: 'hello world!'};
    const spy = spyOn(component.loadOptions, 'emit');
    component.onComplete(event);
    expect(spy).toHaveBeenCalledWith(event.query);
  });

  it('should check if items are already selected', () => {
    const item1: FilterOption = {label: '1', value: 1};
    const item2: FilterOption = {label: '2', value: 2};
    component.selectedItems= [item1];

    expect(component.isItemSelected(item1)).toBeTruthy();
    expect(component.isItemSelected(item2)).toBeFalsy();
  });

  it('should emit a filter change event on selection and unselection', () => {
    const item1: FilterOption = {label: '1', value: 1};
    component.selectedItems = [item1];

    const spy = spyOn(component.filterSelected, 'emit');
    component.handleSelect({});
    expect(spy).toHaveBeenCalledWith({value: [1]});

    component.selectedItems = [];
    component.handleUnselect({});
    expect(spy).toHaveBeenCalledWith({value: []});
  });

  it('should emit a filter change event when clearing selections', () => {
    const item1: FilterOption = {label: '1', value: 1};
    component.selectedItems= [item1];
    const spy = spyOn(component.filterSelected, 'emit');
    component.clearSelections();
    expect(component.selectedItems).toEqual([]);
    expect(spy).toHaveBeenCalledWith({value: []});

  });
});
