import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { productResponse } from './add-product.interface';
import { ProductsService } from '../../services/products/products.service'

@Component({
  selector: 'bre-add-product-component',
  templateUrl: './add-product.component.html',
  styleUrls: ['./add-product.component.scss']
})
export class AddProductComponent implements OnInit {
  productListVersion = [];
  applicationVersions = [];
  selectedProducts = [];
  isProductValid = [];
  @Output() updateProductToServiceValue: EventEmitter<any> = new EventEmitter();
  showLoader: boolean = false;
  productList: productResponse[];

  constructor(private releasesApi: ProductsService) { }

  ngOnInit(): void {
    this.releasesApi.getProduct().then(response => {
      Promise.all(this.productList = response).then(() => {
        this.showLoader = false;
      })
    })
  }

  /**
   * This function gets called on selection of type product type to set up the product drop down
   * values
   * @param $event - event emitted from product-select component.
   */
  getProductDetails($event) {
    let event = $event.$event;
    let rowId = $event?.rowId;
    if (event?.value) {
      this.productListVersion[rowId] = null;
      if (this.selectedProducts && this.selectedProducts?.filter(item => item.productName === event.label).length > 0) {
        this.isProductValid[rowId] = false;
      } else if (this.productList?.filter(item => ((item?.value === event?.value) && (item?.label === event?.label))).length > 0) {
        this.showLoader = true;
        this.isProductValid[rowId] = true;
        this.releasesApi.getProductVersions(event.value).then(res => {
          this.productListVersion = [...this.productListVersion];
          this.productListVersion[rowId] = res;
          this.showLoader = false;
        }).catch(error => {
          console.error(error)
          this.showLoader = false;
        });
      }
    }
  }

  /**
  * 
  * @param $event - version change event from product-select component.
  */
  productVersionUpdate($event) {
    let event = $event?.$event;
    let rowId = $event?.rowId;
    if(event?.value?.length && event?.label?.length && this.productListVersion[rowId]?.filter(item => item.value === event?.value)?.length) {
      this.showLoader = true;
      this.releasesApi.getProductVersionApplications(event.value).then(response => {
        this.applicationVersions = [...this.applicationVersions];
        this.applicationVersions[rowId] = response;
        this.updateProductToService($event.releaseProductFrom);
        this.showLoader = false;
      });
    }
  }

   /**
   * 
   * @param releaseProductFrom 
   * Set selected products to service
   */
    updateProductToService(releaseProductFrom) {
      const products = [];
      for (let rowId in releaseProductFrom) {
        if (releaseProductFrom[rowId]?.value?.product && releaseProductFrom[rowId]?.value?.version) {
          products.push({
            productName: this.productList?.filter(item => item.value === releaseProductFrom[rowId]?.value?.product)[0]?.label,
            productId: releaseProductFrom[rowId]?.value?.product,
            proudctVersionValue: this.productListVersion[rowId]?.filter(item => item.value === releaseProductFrom[rowId]?.value?.version)[0]?.label,
            productVersionId: releaseProductFrom[rowId]?.value?.version,
            dockerApplications: this.applicationVersions[rowId]
          });
        }
      }
      this.selectedProducts = products;
      this.updateProductToServiceValue.emit(products);
    }

  /**
  * This function delete the row of the product
  * @param rowId of the product
  */
  deleteProducts(releaseForm) {
    this.updateProductToService(releaseForm)
  }

}
