import { HttpClient, HttpHandler } from '@angular/common/http';
import { HttpClientTestingModule } from '@angular/common/http/testing';
import { NO_ERRORS_SCHEMA, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { CoreModule } from '../../core.module';
import { ApiService } from '../../services/api/api.service';
import { ProductsService } from '../../services/products/products.service';

import { AddProductComponent } from './add-product.component';

describe('AddProductComponent', () => {
  let component: AddProductComponent;
  let fixture: ComponentFixture<AddProductComponent>;
  let mockService: ProductsService;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [AddProductComponent],
      imports: [HttpClientTestingModule],
      schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
      providers: [ProductsService, ApiService, HttpClient, HttpHandler]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    mockService = TestBed.inject(ProductsService);
    mockService.getProduct = jasmine.createSpy().and.returnValue(Promise.resolve({
      "data": [
        {
          "id": "5",
          "type": "products",
          "links": {
            "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/5"
          },
          "attributes": {
            "name": "aidt",
            "created": "2022-10-13T12:49:33.000+00:00",
            "updated": "2023-03-10T11:21:54.000+00:00"
          },
          "relationships": {
            "productVersions": {
              "links": {
                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/5/relationships/productVersions",
                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/5/productVersions"
              }
            }
          }
        },
        {
          "id": "6",
          "type": "products",
          "links": {
            "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/6"
          },
          "attributes": {
            "name": "bred",
            "created": "2022-10-14T06:23:37.000+00:00",
            "updated": "2023-03-10T09:15:27.000+00:00"
          },
          "relationships": {
            "productVersions": {
              "links": {
                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/6/relationships/productVersions",
                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/6/productVersions"
              }
            }
          }
        }
      ],
      "links": {
        "first": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products?page[limit]=-1",
        "next": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products?page[limit]=-1&page[offset]=-1",
        "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products?page[limit]=-1"
      },
      "meta": {
        "totalResourceCount": 2
      }
    }));
    mockService.getProductVersions = jasmine.createSpy().and.returnValue(Promise.resolve({
      "data": [
        {
          "id": "11",
          "type": "product_versions",
          "links": {
            "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11"
          },
          "attributes": {
            "versionName": "v1.6.1",
            "isDeployed": "true",
            "created": "2022-10-18T05:08:35.000+00:00",
            "updated": "2022-10-18T05:16:07.000+00:00"
          },
          "relationships": {
            "productApplications": {
              "links": {
                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/relationships/productApplications",
                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/productApplications"
              }
            },
            "bundleReleaseApp": {
              "links": {
                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/relationships/bundleReleaseApp",
                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/bundleReleaseApp"
              }
            },
            "products": {
              "links": {
                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/relationships/products",
                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/products"
              }
            },
            "deploymentHistory": {
              "links": {
                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/relationships/deploymentHistory",
                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/deploymentHistory"
              }
            }
          }
        },
        {
          "id": "34",
          "type": "product_versions",
          "links": {
            "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34"
          },
          "attributes": {
            "versionName": "v3.0.3",
            "isDeployed": "true",
            "created": "2022-10-20T09:06:40.000+00:00",
            "updated": "2022-10-20T09:16:10.000+00:00"
          },
          "relationships": {
            "productApplications": {
              "links": {
                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/relationships/productApplications",
                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/productApplications"
              }
            },
            "bundleReleaseApp": {
              "links": {
                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/relationships/bundleReleaseApp",
                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/bundleReleaseApp"
              }
            },
            "products": {
              "links": {
                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/relationships/products",
                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/products"
              }
            },
            "deploymentHistory": {
              "links": {
                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/relationships/deploymentHistory",
                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/deploymentHistory"
              }
            }
          }
        }
      ],
      "links": {
        "first": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions?page[limit]=-1&filter[products.id]=5",
        "next": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions?page[limit]=-1&page[offset]=-1&filter[products.id]=5",
        "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions?page[limit]=-1&filter[products.id]=5"
      },
      "meta": {
        "totalResourceCount": 2
      }
    }))
    mockService.getProductVersionApplications = jasmine.createSpy().and.returnValue(Promise.resolve({ "data": [{ "id": "181", "type": "product_applications", "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/181" }, "attributes": { "applicationName": "aidt-asrservice", "applicationVersion": "1.14.0", "applicationType": "docker", "applicationUrl": "mcd.jfrog.io/brep-docker/aidt-asrservice:1.14.0", "created": "2022-10-31T11:48:52.000+00:00", "updated": "2023-02-09T08:25:37.000+00:00" }, "relationships": { "productVersions": { "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/181/relationships/productVersions", "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/181/productVersions" } } } }, { "id": "182", "type": "product_applications", "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/182" }, "attributes": { "applicationName": "aiidt-cmservice", "applicationVersion": "1.14.1", "applicationType": "docker", "applicationUrl": "mcd.jfrog.io/brep-docker/aiidt-cmservice:1.14.1", "created": "2022-10-31T11:48:52.000+00:00", "updated": "2023-02-09T08:25:37.000+00:00" }, "relationships": { "productVersions": { "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/182/relationships/productVersions", "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/182/productVersions" } } } }, { "id": "183", "type": "product_applications", "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/183" }, "attributes": { "applicationName": "aidt-ttsservice", "applicationVersion": "1.14.3", "applicationType": "docker", "applicationUrl": "mcd.jfrog.io/brep-docker/aidt-ttsservice:1.14.3", "created": "2022-10-31T11:48:52.000+00:00", "updated": "2023-02-09T08:25:37.000+00:00" }, "relationships": { "productVersions": { "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/183/relationships/productVersions", "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/183/productVersions" } } } }], "links": { "first": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications?page[limit]=20&filter[productVersions.id]=75", "last": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications?page[limit]=20&filter[productVersions.id]=75", "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications?filter[productVersions.id]=75" }, "meta": { "totalResourceCount": 3 } }))
    fixture = TestBed.createComponent(AddProductComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should call ngOnit', () => {
    let app = fixture.debugElement.componentInstance;
    let dataService = fixture.debugElement.injector.get(ProductsService);
    component.ngOnInit();
    fixture.detectChanges();
    expect(component.productList).toBeTruthy();;
  })

  it('should call getProductDetails', () => {
    spyOn(component, 'getProductDetails').and.callThrough();
    component.productList = [{
      label: 'aidt',
      value: '5'
    }]
    component.getProductDetails({$event: {value: '5', label : 'aidt'}, rowId: 0});
    fixture.detectChanges();
    expect(component.getProductDetails).toBeCalled();;
  })

  it('should call productVersionUpdate', () => {
    spyOn(component, 'productVersionUpdate').and.callThrough();
    component.productListVersion[0] = [{
      label : "Version",
      value: '9'
    }]
    component.productVersionUpdate({$event: {label: 'Version', value: '9' }, rowId: 0});
    fixture.detectChanges();
    expect(component.productVersionUpdate).toBeCalled();;
  })

  it('should call deleteProducts', () => {
    spyOn(component, 'deleteProducts').and.callThrough();
    component.deleteProducts({});
    fixture.detectChanges();
    expect(component.deleteProducts).toBeCalled();;
  })
});
