import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { FormBuilder } from "@angular/forms";

@Component({
  selector: 'bre-add-product-select',
  templateUrl: './add-product-select.component.html',
  styleUrls: ['./add-product-select.component.scss']
})
export class AddProductSelectComponent implements OnInit {
  @Input() productList;
  @Input() versions = [];
  @Input() applicationVersions;
  @Input() selectedProducts;
  @Input() isProductValid = [];
  @Input() buttonVariant;

  releaseProductFrom = [];
  nextProductRowIdIndex = 0;
  showHideArrow = [];

  @Output() productDropDownChange = new EventEmitter();
  @Output() versionDropDownChange = new EventEmitter();
  @Output() deleteProductTriggered = new EventEmitter();

  constructor(private fb: FormBuilder) { }

  ngOnInit(): void {
    this.insertNewProductType();
  }

/**
* Get the row id
* this function is called to get all the store ids
*/
  getAddedProductsRowIds() {
    this.releaseProductFrom?.forEach((key, index) => {
      key.controls.product.markAsTouched();
      key.controls.version.markAsTouched();
    });
    return Object.keys(this.releaseProductFrom);
  }

  /**
 * This function inserts new set of releases by adding
 * a value to the form
 */
  async insertNewProductType() {
    const rowId = this.nextProductRowIdIndex++;
    this.releaseProductFrom.push(
      this.fb.group({
        product: null,
        version: null
      }));
    this.showHideArrow[rowId] = false;
    this.isProductValid.push(true);
  }
  /**
     * Function close the accordian if it is opened
     * @param event On click event
     */
  onTabClose(event) {
    this.showHideArrow[event] = false;
  }

  /**
   * Function openes the accordian on click
   * @param event Click event
   */
  onTabOpen(event) {
    this.showHideArrow = this.showHideArrow?.map(item => item = false);
    this.showHideArrow[event] = true;
  }

  /**
   * 
   * @param $event 
   * @param rowId 
   * Triggered on product selection , sets formgroup values and emits event to parent component.
   */
  fetchProductDetails($event, rowId){
    this.applicationVersions[rowId] = null;
    this.releaseProductFrom[rowId]?.patchValue({
      product: $event?.value,
      version: null
    });
    this.productDropDownChange.emit({$event, rowId});
  }
/**
 * 
 * @param $event 
 * @param rowId 
 * Triggered on version change ,sets formgroup values and emits event to parent component.
 */
  versionChange($event, rowId){
    this.releaseProductFrom[rowId]?.patchValue({
      version: $event.value
    });
    this.versionDropDownChange.emit({$event, rowId, releaseProductFrom:this.releaseProductFrom});
    this.onTabOpen(rowId);
  }

  /**
   * 
   * @param rowId 
   * Triggered on delete click
   */
  deleteProducts(rowId){
      if (this.getAddedProductsRowIds()?.length === 1) {
        this.releaseProductFrom[rowId]?.setValue({
          product: null,
          version: null
        });       
        this.versions = [];
        this.isProductValid[rowId] = [false];
      } else {
        delete this.isProductValid[rowId];
        delete this.releaseProductFrom[rowId];
        delete this.applicationVersions[rowId];
        delete this.versions[rowId];
      }    
      this.deleteProductTriggered.emit(this.releaseProductFrom);
  }
}
