import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { CoreModule } from '../../core.module';
import { AddProductSelectComponent } from './add-product-select.component';
import { FormsModule, FormBuilder } from '@angular/forms';
import { CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA } from '@angular/core';
import { ProductsService } from '../../services/products/products.service';
import { ApiService } from '../../services/api/api.service';
import { HttpClientTestingModule } from '@angular/common/http/testing';

describe('AddProductSelectComponent', () => {
  let component: AddProductSelectComponent;
  let fixture: ComponentFixture<AddProductSelectComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ AddProductSelectComponent ],
      imports: [HttpClientTestingModule],
      schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
      providers: [FormBuilder, ProductsService, ApiService]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(AddProductSelectComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should call ngOnit', () => {
    let app = fixture.debugElement.componentInstance;
    let dataService = fixture.debugElement.injector.get(ProductsService);
    spyOn(component, 'insertNewProductType').and.callThrough();
    component.ngOnInit();
    fixture.detectChanges();
    expect(component.insertNewProductType).toBeCalled();;
  });

  it('should call getAddedProductsRowIds', () => {
    spyOn(component, 'getAddedProductsRowIds').and.callThrough();
    component.getAddedProductsRowIds();
    fixture.detectChanges();
    expect(component.getAddedProductsRowIds).toBeCalled();;
  })

  it('should call onTabClose', () => {
    spyOn(component, 'onTabClose').and.callThrough();
    component.onTabClose(0);
    fixture.detectChanges();
    expect(component.onTabClose).toBeCalled();
    expect(component.showHideArrow[0]).toBe(false)
  })

  it('should call onTabOpen', () => {
    spyOn(component, 'onTabOpen').and.callThrough();
    component.onTabOpen(0);
    fixture.detectChanges();
    expect(component.onTabOpen).toBeCalled();
    expect(component.showHideArrow[0]).toBe(true)
  })

  it('should call fetchProductDetails', () => {
    spyOn(component, 'fetchProductDetails').and.callThrough();
    component.applicationVersions = [];
    component.fetchProductDetails({},0);
    fixture.detectChanges();
    expect(component.fetchProductDetails).toBeCalled();
    expect(component.applicationVersions[0]).toBeNull();
  })

  it('should call versionChange', () => {
    spyOn(component, 'versionChange').and.callThrough();
    spyOn(component, 'onTabOpen').and.callThrough();
    component.versionChange({},0);
    fixture.detectChanges();
    expect(component.versionChange).toBeCalled();
    expect(component.onTabOpen).toBeCalled();
  })

  it('should call deleteProducts', () => {
    spyOn(component, 'deleteProducts').and.callThrough();
    component.deleteProducts(0);
    fixture.detectChanges();
    expect(component.deleteProducts).toBeCalled();
  })
});
