import { Component, OnInit, Input, Output, EventEmitter, ViewEncapsulation, ViewChild } from '@angular/core';
import { MatAccordion, MatExpansionPanel } from '@angular/material/expansion';

@Component({
    selector: 'bre-accordion-menu',
    templateUrl: './accordion-menu.component.html',
    styleUrls: ['./accordion-menu.component.scss'],
    encapsulation: ViewEncapsulation.None
})
export class AccordionMenuComponent implements OnInit {
    @Input() items: AccordionMenuItem[];
    @Output() itemSelected: EventEmitter<any> = new EventEmitter();

    selectedItem: AccordionMenuItem;

    ngOnInit(): void {}

    incrementLevel(level: number): number {
        return level + 1;
    }

    setExpandedValue(item: AccordionMenuItem, value: boolean) {
        item.expanded = value;
    }

    selectItem(item: AccordionMenuItem) {
        if(this.selectedItem !== item) {
            this.selectedItem = item;
            this.itemSelected.emit(item.value);
        }
    }
}

export interface AccordionMenuItem {
    value: string,
    label: string;
    disabled?: boolean;
    expanded?: boolean;
    children?: AccordionMenuItem[];
}