import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { AccordionMenuComponent, AccordionMenuItem } from '../accordion-menu/accordion-menu.component';
import { MatExpansionModule } from '@angular/material/expansion';
import { MatListModule } from '@angular/material/list';


describe('AccordionMenuComponent', () => {
  let component: AccordionMenuComponent;
  let fixture: ComponentFixture<AccordionMenuComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
        imports: [ MatExpansionModule, MatListModule ],
        declarations: [ AccordionMenuComponent],
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(AccordionMenuComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should increment level on request', () => {
    const level: number = 1;
    const newLevel = component.incrementLevel(level);
    expect(newLevel).toBe(level + 1);
  });

  it('should expand accordion menu items', () => {
    const item: AccordionMenuItem = {value: 'test', label: 'Test', expanded: false };
    component.setExpandedValue(item, true);
    expect(item.expanded).toBe(true);
  });

  it('should emit an event when an item is selected, but only if that item is not already selected', () => {
    const item: AccordionMenuItem = {value: 'test', label: 'Test', expanded: false };
    const spy = spyOn(component.itemSelected, 'emit');
    component.selectItem(item);
    expect(component.selectedItem).toBe(item);
    expect(spy).toHaveBeenCalledWith(item.value);

    spy.calls.reset()
    component.selectItem(item);
    expect(spy).not.toHaveBeenCalled();
  });


});