# Pipeline Breakdown

## **Description**

Image caching lambda performs creation/updation/deletion of tags on "brep-imagecache-baseline" repo whenever a Release Bundle is created/updated/deleted.

## **Usage**

Payload to manually test lambda:
If you want to test the process to create a tag for release bundle - 
```
{
"body":{
  "releaseName": "R2022-669",
  "apps": [
    "mcd.jfrog.io/brep-docker/bred-helloworld/88",
    "mcd.jfrog.io/brep-docker/aidt-aotqe/1.7.0",
    "mcd.jfrog.io/brep-docker/aidt-asrservice/1.1.2"
  ]
},
"httpMethod": "POST"
}
```
If you want to test the process to update a tag for release bundle - 
```
{
"body":{
  "releaseName": "R2022-669",
  "apps": [
    "mcd.jfrog.io/brep-docker/bred-helloworld/88",
    "mcd.jfrog.io/brep-docker/aidt-aotqe/1.7.0",
    "mcd.jfrog.io/brep-docker/aidt-asrservice/1.1.2"
  ]
},
"httpMethod": "PUT"
}
```
If you want to test the process to delete a tag for release bundle - 
```
{
"body":{
  "releaseName": "R2022-669"
},
"httpMethod": "DELETE"
}


## **Additional Notes**

Dev - deployment should be done through feature/master branch Int/Stage - deployment should only be done through master branch Production - Cut the release tag and deployment should be done only though tags pipeline

Update Changelog file with the exact functionality enhancement done on the latest release tag.

# GitOps Development Guide

**Confluence**: https://us-confluence.mcd.com/display/BTP/GitOps%3A+Development+standards+and+higher-env+release

**Terraform Pipeline**

* Uses our `build-tools` container to run the terraform script.
* User selects name of config tfvars file and Terraform action (plan, apply, destroy) before the pipeline is kicked off. 
* Pipeline does a GIT checkout of the Terraform repo.
* Pipeline will run the init.sh script to initialize Terraform.
* Regardless of Terraform action selected, all pipelines will run a `terraform validate` command.
* If user selects a Terraform action of `plan` the pipeline will only run the `terraform plan` command and then exit the pipeline.
* If user selects a Terraform action of `apply` the pipeline will run the `terraform apply` command with an auto approve, and then exit the pipeline.
* If user selects a Terraform action of `destroy` the pipeline will run the `terraform destroy` command with an auto approve, and then exit the pipeline.

# Pipeline Guide

**Confluence**: https://us-confluence.mcd.com/pages/viewpage.action?pageId=140347235

# Development Guidelines

**Confluence**: https://us-confluence.mcd.com/pages/viewpage.action?spaceKey=BREP&title=Development+Guidelines
