resource "aws_lambda_function" "deploy_device_message_lambda" {
    
    function_name    = "DEPLOY-DEVICE-MESSAGE-LAMBDA"
    role             = aws_iam_role.lambda_role.arn
    handler          = "main.handler"
    
    runtime          = "nodejs12.x"
    timeout          = 120
    filename         = data.archive_file.lambda_zip.output_path
    source_code_hash = data.archive_file.lambda_zip.output_base64sha256

    environment {
      variables = {
        TOPIC_ARN = "arn:aws:sns:${var.region}:${data.aws_caller_identity.current.account_id}:${var.sns_topic_name}",
        ASSET_URL = var.asset_url,
        REGION = var.region
        ENVIRONMENT = var.environment
      }
    }
}

resource "aws_lambda_function" "multi_device_message_lambda" {
    
    function_name    = "MULTI-DEVICE-MESSAGE-LAMBDA"
    role             = aws_iam_role.multi_lambda_role.arn
    handler          = "multi/multiDeploy.handler"
    
    runtime          = "nodejs12.x"
    timeout          = 120
    filename         = data.archive_file.lambda_multi_zip.output_path
    source_code_hash = data.archive_file.lambda_multi_zip.output_base64sha256

    environment {
      variables = {
        TOPIC_ARN = "arn:aws:sns:${var.region}:${data.aws_caller_identity.current.account_id}:${var.sns_topic_name}",
        ASSET_URL = var.asset_url,
        REGION = var.region
        ENVIRONMENT = var.environment
      }
    }
}

resource "aws_lambda_function" "schedule_device_message_lambda" {
    
    function_name    = "SCHEDULE-DEVICE-MESSAGE-LAMBDA"
    role             = aws_iam_role.schedule_lambda_role.arn
    handler          = "schedule/scheduleDeploy.handler"
    
    runtime          = "nodejs12.x"
    timeout          = 120
    filename         = data.archive_file.lambda_schedule_zip.output_path
    source_code_hash = data.archive_file.lambda_schedule_zip.output_base64sha256

    environment {
      variables = {
        ASSET_URL = var.asset_url,
        REGION = var.region
        ENVIRONMENT = var.environment
      }
    }
}

resource "aws_iam_role" "lambda_role" {
  name = "DEPLOY-DEVICE-MESSAGE-LAMBDA-IAM-ROLE"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "lambda.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role" "multi_lambda_role" {
  name = "MULTI-DEVICE-MESSAGE-LAMBDA-IAM-ROLE"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "lambda.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role" "schedule_lambda_role" {
  name = "SCHEDULE-DEVICE-MESSAGE-LAMBDA-IAM-ROLE"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "lambda.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

 

resource "aws_iam_role_policy_attachment" "AWSLambdaBasicExecutionRole" {
  role       = aws_iam_role.lambda_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole"
}

resource "aws_iam_role_policy_attachment" "AWSLambdaBasicExecutionRoleMulti" {
  role       = aws_iam_role.multi_lambda_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole"
}

resource "aws_iam_role_policy_attachment" "AWSLambdaBasicExecutionRole1" {
  role       = aws_iam_role.schedule_lambda_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole"
}

resource "aws_iam_role_policy_attachment" "invoke_services_apis_policy_arn" {
  role       = aws_iam_role.lambda_role.name
  policy_arn = var.invoke_services_apis_policy_arn
}

resource "aws_iam_role_policy_attachment" "multi_invoke_services_apis_policy_arn" {
  role       = aws_iam_role.multi_lambda_role.name
  policy_arn = var.invoke_services_apis_policy_arn
}

resource "aws_iam_role_policy_attachment" "schedule_invoke_services_apis_policy_arn" {
  role       = aws_iam_role.schedule_lambda_role.name
  policy_arn = var.invoke_services_apis_policy_arn
}

data "aws_iam_policy_document" "sns_publish" {
  statement {
    sid = "1"

    actions = [
      "sns:publish",
    ]

    resources = [
      "arn:aws:sns:${var.region}:${data.aws_caller_identity.current.account_id}:${var.sns_topic_name}",
    ]
  }
}



resource "aws_iam_policy" "sns_publish" {
  name   = "DEPLOY-DEVICE-MESSAGE-LAMBDA_SNS_PUBLISH_POLICY"
  path   = "/"
  policy = data.aws_iam_policy_document.sns_publish.json
}

resource "aws_iam_policy" "sns_publish_multi" {
  name   = "MULTI-DEPLOY-DEVICE-MESSAGE-LAMBDA_SNS_PUBLISH_POLICY"
  path   = "/"
  policy = data.aws_iam_policy_document.sns_publish.json
}

resource "aws_iam_role_policy_attachment" "sns_publish_policy_attachment" {
  role       = aws_iam_role.lambda_role.name
  policy_arn = aws_iam_policy.sns_publish.arn
}

resource "aws_iam_role_policy_attachment" "sns_publish_policy_attachment_multi" {
  role       = aws_iam_role.multi_lambda_role.name
  policy_arn = aws_iam_policy.sns_publish_multi.arn
}

