const AWS = require("aws-sdk");
const domain = process.env.ASSET_URL;
const region = process.env.REGION;


var self = {

    assetServiceRequest: (method, path, body) => new Promise((resolve, reject)=>{
        AWS.config.getCredentials(function (err) {
            if (err) {
                console.log('Failed while getting AWS config : ', err.stack);
                reject(err);
            }
            else {
                const endpoint = new AWS.Endpoint(domain);
                let request = new AWS.HttpRequest(endpoint, region);
                // make sure to not add / in the path as it is appended automatically.
                request.path += path;
                request.headers['host'] = domain;
                request.method = method;

                if (method === 'POST') {
                    request.body = JSON.stringify(body);
                    request.headers['Content-Type'] = 'application/vnd.api+json';
                    request.headers['Content-Length'] = Buffer.byteLength(request.body);
                }

                let signer = new AWS.Signers.V4(request, 'execute-api');
                signer.addAuthorization(AWS.config.credentials, new Date());

                let client = new AWS.HttpClient();
                client.handleRequest(request, null, function (response) {
                    console.log("passed request");
                    console.log(response.statusCode + ' ' + response.statusMessage);
                    let buffer = "";
        
                    response.on('data', chunk => buffer += chunk)
                    response.on('end', () => resolve(JSON.parse(buffer)))
                }, function(error) {
                    console.log('Error: ' + error);
                    reject(error);
                });

            }
        })
    }),

};
module.exports = self;