const {
  deployFirmwareRelease,
  deployDockerRelease
} = require("../common.deploy");

exports.handler = async (event) => {
  console.log("In handler...");
  console.log("ENVIRONMENT VARIABLES: " + JSON.stringify(process.env, null, 2));
  console.info("EVENT: " + JSON.stringify(event, null, 2));
  let body = event.body ? JSON.parse(event.body) : event;
  if (event.deploymentType === "firmware") {
    return await deployFirmwareRelease(body);
  } else {
    return await deployDockerRelease(body);
  }
};
