const {
  deployFirmwareRelease,
  deployDockerRelease
} = require("../common.deploy");
const { makeResponse, makeErrorResponse } = require("../utility");

const multiDeploy = async (deploymentType, applications) => {
  const published = [];
  const failed = [];
  let response = "";
  try {
    // Select deploy method based on deployment type
    const deploy =
      deploymentType === "firmware"
        ? deployFirmwareRelease
        : deployDockerRelease;

    for (let application of applications) {
      const deployResponse = await deploy(application);
      if (deployResponse.statusCode === 200) {
        published.push(deployResponse);
      } else {
        failed.push(deployResponse);
      }
    }
    response = makeResponse({
      data: published,
      errors: failed
    });
    return response;
  } catch (err) {
    response = makeErrorResponse("Error while deploying applications.", err);
  }
  return response;
};

exports.handler = async (event) => {
  console.log("ENVIRONMENT VARIABLES: " + JSON.stringify(process.env, null, 2));
  console.info("EVENT: " + JSON.stringify(event, null, 2));
  let body = event.body ? JSON.parse(event.body) : event;
  // Attribute - 'applications' has list of multiple applications selected by user for deployment
  return await multiDeploy(event.deploymentType, body.applications);
};
