"use strict";

var AWS = require("aws-sdk");

exports.handler = function(event, context) {
    var podName = event.podname;
    var deploymentType = event.deploymenttype;
    var deploymentUrl = event.deploymentUrl;
    var replaceVersion = event.replaceVersion;
    var deployVersion = event.deployVersion;
    var restaurants = event.restaurantId;
    var hardwareVersion = event.hardwareVersion;
    var deviceType = event.deviceType;
    var vendor = event.vendor;

    var sns = new AWS.SNS();
    var messageAttributes;

    if(event.deploymentType == 'firmware') {
        messageAttributes = {
            "componentName": {
                "Type": "String",
                "Value": podName
            },
            "podName": {
                "Type": "String",
                "Value": podName
            },
            "deploymentType": {
                "Type": "String",
                "Value": deploymentType
            },
            "imageURL": {
                "Type": "String",
                "Value": deploymentUrl
            },
            "replaceVersion": {
                "Type": "String",
                "Value": replaceVersion
            },
            "buildNumber": {
                "Type": "String",
                "Value": deployVersion
            },
            "hardwareVersion": {
                "Type": "String",
                "Value": hardwareVersion
            },
            "deviceType": {
                "Type": "String",
                "Value": deviceType
            },
            "vendor": {
                "Type": "String",
                "Value": vendor
            },
            "restaurantId": {
                "Type": "String.Array",
                "Value": JSON.stringify(restaurants) // need to stringify for SNS
            }
        };
    } else {
        messageAttributes = {
            "componentName": {
                "Type": "String",
                "Value": podName
            },
            "podName": {
                "Type": "String",
                "Value": podName
            },
            "deploymentType": {
                "Type": "String",
                "Value": deploymentType
            },
            "imageURL": {
                "Type": "String",
                "Value": deploymentUrl
            },
            "replaceVersion": {
                "Type": "String",
                "Value": replaceVersion
            },
            "buildNumber": {
                "Type": "String",
                "Value": deployVersion
            },
            "restaurantId": {
                "Type": "String.Array",
                "Value": JSON.stringify(restaurants) // need to stringify for SNS
            }
        };
    }
    var params = {
        Message: "Deployment was triggered through the deployment message service", 
        Subject: `${deploymentType}-"deployment"-${podName}`,
        TopicArn: "arn:aws:sns:us-east-1:524430043955:US-EAST-PROD-BRE-ARCH-BRE-DEPLOYMENTGENERATOR-MASTER-SNS",
        MessageAttributes: messageAttributes
    };
    sns.publish(params, context.done);
};