variable "region" {
  default     = "us-east-1"
  description = "The name of the region"
}

variable "asset_url" {
  description = "asset service url to be invoked"
}

variable "sqs_policy_arn" {
  default = "arn:aws:iam::aws:policy/service-role/AWSLambdaSQSQueueExecutionRole"
}

variable "environment" {
  default = "dev"
}

variable "tags" {
  type = map(any)
}

variable "gitopsRepoAccessSecret" {
  default     = "github/bre-cloud-git-reconcile"
  description = "The name of the secret which contains bitbucket auth details"
}
variable "branch" {
  default     = "main"
  description = "Remote branch gitops uses for deployment"
}

variable "lambdagitlayer" {
  default     = "arn:aws:lambda:us-east-1:553035198032:layer:git-lambda2:8"
  description = "layer that allows aws lambda to access git via http/ssh"
}

variable "gitopsRepoAccessSecretArn" {
  description = "arn for gitops repo access secret "
  default     = "arn:aws:secretsmanager:us-east-1:283388140277:secret:gitops-repo-access-creds-c696ti"
}

variable "vpc_id" {}

variable worker_subnet_type {}

variable "gitops_deadletter_queue" {
  default = "gitops-deadletter-queue.fifo"
}

variable "gitops_queue" {
  default = "gitops-queue.fifo"
}

variable "artifactoryURL" {
  default = "mcd.jfrog.io/brep-docker/"
}

variable "invoke_services_apis_policy_arn" {
  type = string
  default = ""
}

variable "eventBridgeTime" {
  default = "24"
}

variable "gitopsSQSQueueURL" {
  description = "The URL for the gitops SQS queue"
}

variable "gitopsMessageGroup" {
  description = "The name of the message group for gitops messages"
  default     = "gitops"
}

variable "gitops_SQS_name"{
  description = "The name of the SQS queue for gitops messages"
  default     = "gitops-queue.fifo"
}