//Groovy script to pull the image list from the artifactory. GitOps pipeline is working with the code.

import org.apache.commons.httpclient.HttpClient
import org.apache.commons.httpclient.methods.GetMethod
import org.apache.commons.httpclient.Header
import groovy.json.JsonSlurper
import org.apache.commons.httpclient.methods.StringRequestEntity
import org.apache.commons.codec.DecoderException

import jenkins.*
import jenkins.model.* 
import hudson.*
import hudson.model.*
def jenkinsCredentials = com.cloudbees.plugins.credentials.CredentialsProvider.lookupCredentials(
  com.cloudbees.plugins.credentials.Credentials.class,
  Jenkins.instance,
  null,
  null
);

def username
def password
//Read credential from Jenkins configuration
for (creds in jenkinsCredentials) {
  if(creds.id == "artifactory"){
    username = creds.username
    password = creds.password
  }
}
//Encode artifactory crerdentials in base64 format
def credentials = username+":"+password
def encoded = credentials.bytes.encodeBase64().toString()
def authorization_header = "Basic "+encoded

//URL to fetch list of docker images on artifactory
def endpoint = "https://${artifactoryUrl}/artifactory/api/docker/docker/v2/_catalog/"
def httpClient = new HttpClient()
method_set = new GetMethod(endpoint)
method_set.setRequestHeader(new Header("Authorization", authorization_header))
statusCode = httpClient.executeMethod(method_set)
//println statusCode

//Get Response from artifactory URL and parse
def slurper = new JsonSlurper() 
def response = slurper.parseText(method_set.getResponseBodyAsString()) 
image_list = []
image_list = response.repositories
return image_list
