package com.bre

import javaposse.jobdsl.dsl.DslFactory
import hudson.plugins.git.*
import hudson.*
import hudson.security.*
import java.util.*
import jenkins.model.*

def createNewMultibranchPipelineJob(String sourceView, String pipelineName) {
    jobDsl additionalParameters: [
        sourceView: sourceView,
        pipelineName: pipelineName
    ], scriptText: '''
    multibranchPipelineJob("${sourceView}/${pipelineName}") {
    branchSources {
        github {
            id('34343434') // IMPORTANT: use a constant and unique identifier
            scanCredentialsId('BREP-GitHubApp')
            repoOwner('bre-org')
            repository("${pipelineName}")
            includes("master feature/* bugfix/* hotfix/* release/*")
            excludes("donotbuild/*")
        }
         configure {
         def traits = it / 'sources' / 'data' / 'jenkins.branch.BranchSource' / 'source' / 'traits'
         traits << 'org.jenkinsci.plugins.github__branch__source.BranchDiscoveryTrait' {
         strategyId(3)
         }
         traits << 'org.jenkinsci.plugins.github__branch__source.OriginPullRequestDiscoveryTrait' {
         strategyId(1)
         }
         traits << 'org.jenkinsci.plugins.github__branch__source.TagDiscoveryTrait'()
       }
    }
    factory {
        workflowBranchProjectFactory {
            scriptPath("jenkinsFile.groovy")
        }
      }
    triggers {
        periodicFolderTrigger {
            interval("2m")
        }
    }
    orphanedItemStrategy {
        discardOldItems {
            numToKeep(10)
        }
    }
}
'''
}

def deletejob(String name){
    def matchedJobs = Jenkins.instance.getItemByFullName(name)
    matchedJobs.each { job ->
        println job.name
        job.delete()
    }
}

return this
