import javax.crypto.Mac
import javax.crypto.spec.SecretKeySpec
import java.security.InvalidKeyException
import java.security.MessageDigest

import org.apache.commons.httpclient.HttpClient
import org.apache.commons.httpclient.methods.GetMethod
import org.apache.commons.httpclient.methods.DeleteMethod
import org.apache.commons.httpclient.Header
import groovy.json.JsonSlurper
import org.apache.http.client.methods.HttpPatch

import java.text.SimpleDateFormat
import org.apache.commons.httpclient.methods.PostMethod
import org.apache.commons.httpclient.methods.StringRequestEntity
import org.apache.http.entity.StringEntity
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper

import org.slf4j.*;

def hmac_sha256(secretKey, data) {
    Mac mac = Mac.getInstance("HmacSHA256")
    SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, "HmacSHA256")
    mac.init(secretKeySpec)
    byte[] digest = mac.doFinal(data.getBytes())
    return digest
}
def hmac_sha256Hex(secretKey, data) {
    def result = hmac_sha256(secretKey, data)
    return result.encodeHex()
}
def getSignatureKey(key, dateStamp, regionName, serviceName){
    def kDate = hmac_sha256(("AWS4" + key).getBytes(), dateStamp)
    def kRegion = hmac_sha256(kDate, regionName)
    def kService = hmac_sha256(kRegion, serviceName)
    def kSigning = hmac_sha256(kService, "aws4_request")
    return kSigning
}
def getHexDigest(text){
    def md = MessageDigest.getInstance("SHA-256")
    md.update(text.getBytes())
    return md.digest().encodeHex()
}

// method to call API Gateway endpoint and use IAM authorization
def callAPIGatewayEndpoint(hostname,canonical_uri,method_type, query_parameters,body){
  if (hostname.toLowerCase().contains("dev".toLowerCase())) {
      credentialsId = "edge-dev";
  }
  else if (hostname.toLowerCase().contains("int".toLowerCase())) {
      credentialsId = "edge-int";
  }
  else if (hostname.toLowerCase().contains("stg".toLowerCase())) {
      credentialsId = "edge-stg";
  }
  else if (hostname.toLowerCase().contains("prod".toLowerCase())) {
      credentialsId = "edge-prod";
  }
  //credentialsId = "edge-dev";
  //method to fetch AWS Credentials
  credentials = AWSCredentialsHelper.getCredentials(credentialsId, Jenkins.get());
  def access_key = credentials.getAccessKey()
  def secret_key = credentials.getSecretKey()

  // to enable logger for troubleshooting
  //def logger = LoggerFactory.getLogger('logger');

  def method = method_type
  def service = "execute-api"
  def host = hostname
  def region = "us-east-1"
  def endpoint = "https://${hostname}${canonical_uri}"
  def request_parameters = query_parameters
  // add formatted date according to AWS SigV4 authentication mechanism
  def now = new Date()
  def amzFormat = new SimpleDateFormat( "yyyyMMdd'T'HHmmss'Z'" )
  def stampFormat = new SimpleDateFormat( "yyyyMMdd" )
  def amzDate = amzFormat.format(now)
  def dateStamp = stampFormat.format(now)
  //create canonical request
  def canonical_headers = "host:" + host + "\n" + "x-amz-date:" + amzDate + "\n"
  def signed_headers = "host;x-amz-date"

  def payload_hash = getHexDigest(body)
  def canonical_request = method + "\n" + canonical_uri + "\n" + request_parameters + "\n" + canonical_headers + "\n" + signed_headers + "\n" + payload_hash

  def algorithm = "AWS4-HMAC-SHA256"
  def credential_scope = dateStamp + "/" + region + "/" + service + "/" + "aws4_request"
  def hash_canonical_request = getHexDigest(canonical_request)
  //create signing key and signature
  def string_to_sign = algorithm + "\n" +  amzDate + "\n" +  credential_scope + "\n" +  hash_canonical_request
  def signing_key = getSignatureKey(secret_key, dateStamp, region, service)
  def signature = hmac_sha256Hex(signing_key, string_to_sign)
  def authorization_header = algorithm + " " + "Credential=" + access_key + "/" + credential_scope + ", " +  "SignedHeaders=" + signed_headers + ", " + "Signature=" + signature
  
  def statusCode
  def method_set
  def httpClient = new HttpClient()
  // create request based on method type
  if(method_type=="GET"){
    method_set = new GetMethod(endpoint+"?"+query_parameters)
  }
  else if(method_type=="POST"){
    method_set = new PostMethod(endpoint);
    StringRequestEntity requestEntity = new StringRequestEntity(
    body,
    "application/vnd.api+json","UTF-8")
    method_set.setRequestEntity(requestEntity)
  
  }
  else if(method_type=="DELETE"){
    method_set = new DeleteMethod(endpoint+"/"+query_parameters)
  }

    //set request headers
    method_set.setRequestHeader(new Header("Content-Type", "application/json"))
    method_set.setRequestHeader(new Header("Host", host))
    method_set.setRequestHeader(new Header("X-Amz-Date", amzDate))
    method_set.setRequestHeader(new Header("Authorization", authorization_header))
    statusCode = httpClient.executeMethod(method_set)

  // validate the response after executing the call
  if(statusCode >= 200 && statusCode < 300){ 
      println "statusCode"
      println statusCode
      def slurper = new JsonSlurper() 
      def response = slurper.parseText(method_set.getResponseBodyAsString()) 
      //logger.debug response
      println response
      return response
  }else{
      println "statusCode"
      println statusCode
      def slurper = new JsonSlurper()
      def response = slurper.parseText(method_set.getResponseBodyAsString()) 
      //logger.debug response
      println response
      return "Error"
  }

  }

// method to get market id based on hostname and market name
def getMarketScopeId(hostname,marketName){
    def marketScopeId = "-1"
    def query_param="scope_code=${marketName}&scope_level=1"
    def canonical_uri = "/v1/scope"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"GET",query_param,"")
    println responseFromRequest
    if(responseFromRequest!="Error"){
      println responseFromRequest.data.id
      marketScopeId = responseFromRequest.data.id
    }
    return marketScopeId
}

// method to get scope id based on restaurant name and hostname
def getScopeByScopeCode(hostname,restaurantName,marketName){
    def finalResponse = "-1"
    def query_param="market=${marketName}&scope_code=${restaurantName}"
    def canonical_uri = "/v1/scope"
    println query_param
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"GET",query_param,"")
    if(responseFromRequest!="Error"){
      println responseFromRequest.data
      return [responseFromRequest.data.id, responseFromRequest.data.name, responseFromRequest.data.networkinfo, responseFromRequest.data.region_scope, responseFromRequest.data.coop_scope]
    }
    return [finalResponse, "", "", "", ""]
}

// method to call CM Basic Setup Services that will create default profiles.
def basiCmSetup(hostname,marketName,restaurantName,region,coop,description,networkinfo){
  def finalResponse = "-1"
  StringBuilder entity = new StringBuilder()
          entity.append("{")
          entity.append("\"storeNo\":\"${restaurantName}\",")
          entity.append("\"networkinfo\":\"${networkinfo}\",")
          entity.append("\"market\":\"${marketName}\",")
          entity.append("\"region\":\"${region}\",")
          entity.append("\"coop\":\"${coop}\",")
          entity.append("\"storeName\":\"${description}\"")
          entity.append("}")
    println entity.toString()
    def canonical_uri = "/basic-setup"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"POST",'',entity.toString())
    if(responseFromRequest!="Error"){
      println responseFromRequest.body.status
      return responseFromRequest.body.status
    }
    return finalResponse
}


// method to add restaurant based on restaurant name, market id and hostname
def addScope(hostname,restaurantName,marketName,region,coop,description){
  def finalResponse = "-1"
  StringBuilder entity = new StringBuilder()
          entity.append("{")
          entity.append("\"scope_code\":\"${restaurantName}\",")
          entity.append("\"scope_level\": 1000,")
          entity.append("\"market_scope_code\":\"${marketName}\",")
          entity.append("\"region_scope_code\":\"${region}\",")
          entity.append("\"coop_scope_code\":\"${coop}\",")
          entity.append("\"name\":\"${description}\"")
          entity.append("}")
    println entity.toString()
    def canonical_uri = "/v1/scope"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"POST",'',entity.toString())
    if(responseFromRequest!="Error"){
      println responseFromRequest.data.id
      finalResponse = responseFromRequest.data.id
    }
      return finalResponse
}

// method to delete scope based on scope id 
def deleteScope(hostname, scopeId){ 
    def finalResponse = "-1"  
    def query_param=scopeId 
    //println query_param.getClass()  
    def responseFromRequest =callAPIGatewayEndpoint(hostname,"DELETE",query_param,"")
    if(responseFromRequest!="Error"){ 
      println responseFromRequest.status  
      finalResponse = responseFromRequest.status
    } 
    return finalResponse  
} 

return this 