import javax.crypto.Mac
import javax.crypto.spec.SecretKeySpec
import java.security.InvalidKeyException
import java.security.MessageDigest
import java.text.SimpleDateFormat

import org.apache.commons.httpclient.HttpClient
import org.apache.commons.httpclient.methods.GetMethod
import org.apache.http.client.methods.HttpPatch
import org.apache.commons.httpclient.methods.PostMethod
import org.apache.commons.httpclient.methods.DeleteMethod
import org.apache.commons.httpclient.Header
import org.apache.commons.codec.DecoderException
import org.apache.commons.httpclient.methods.StringRequestEntity
import org.apache.http.entity.StringEntity
import org.apache.http.client.methods.HttpPatch

import jenkins.*
import jenkins.model.*
import hudson.*
import groovy.json.JsonSlurper
import com.cloudbees.groovy.cps.NonCPS

import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper

import org.slf4j.*;

def hmac_sha256(secretKey, data) {
    Mac mac = Mac.getInstance("HmacSHA256")
    SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, "HmacSHA256")
    mac.init(secretKeySpec)
    byte[] digest = mac.doFinal(data.getBytes())
    return digest
}
def hmac_sha256Hex(secretKey, data) {
    def result = hmac_sha256(secretKey, data)
    return result.encodeHex()
}
def getSignatureKey(key, dateStamp, regionName, serviceName){
    def kDate = hmac_sha256(("AWS4" + key).getBytes(), dateStamp)
    def kRegion = hmac_sha256(kDate, regionName)
    def kService = hmac_sha256(kRegion, serviceName)
    def kSigning = hmac_sha256(kService, "aws4_request")
    return kSigning
}
def getHexDigest(text){
    def md = MessageDigest.getInstance("SHA-256")
    md.update(text.getBytes())
    return md.digest().encodeHex()
}

// method to call API Gateway endpoint and use IAM authorization
def callAPIGatewayEndpoint(hostname,canonical_uri,method_type, query_parameters,body){
  if (hostname.toLowerCase().contains("dev".toLowerCase())) {
      credentialsId = "edge-dev";
  }
  else if (hostname.toLowerCase().contains("int".toLowerCase())) {
      credentialsId = "edge-int";
  }
  else if (hostname.toLowerCase().contains("stg".toLowerCase())) {
      credentialsId = "edge-stg";
  }
  else if (hostname.toLowerCase().contains("prod".toLowerCase())) {
      credentialsId = "edge-prod";
  }
  //credentialsId = "edge-dev";
  //method to fetch AWS Credentials
  credentials = AWSCredentialsHelper.getCredentials(credentialsId, Jenkins.get());
  def access_key = credentials.getAccessKey()
  def secret_key = credentials.getSecretKey()

  // to enable logger for troubleshooting
  //def logger = LoggerFactory.getLogger('logger');

  def method = method_type
  def service = "execute-api"
  def host = hostname
  def region = "us-east-1"
  def endpoint = "https://${hostname}${canonical_uri}"
  def request_parameters = query_parameters
  // add formatted date according to AWS SigV4 authentication mechanism
  def now = new Date()
  def amzFormat = new SimpleDateFormat( "yyyyMMdd'T'HHmmss'Z'" )
  def stampFormat = new SimpleDateFormat( "yyyyMMdd" )
  def amzDate = amzFormat.format(now)
  def dateStamp = stampFormat.format(now)
  //create canonical request
  def canonical_headers = "host:" + host + "\n" + "x-amz-date:" + amzDate + "\n"
  def signed_headers = "host;x-amz-date"

  def payload_hash = getHexDigest(body)
  def canonical_request = method + "\n" + canonical_uri + "\n" + request_parameters + "\n" + canonical_headers + "\n" + signed_headers + "\n" + payload_hash

  def algorithm = "AWS4-HMAC-SHA256"
  def credential_scope = dateStamp + "/" + region + "/" + service + "/" + "aws4_request"
  def hash_canonical_request = getHexDigest(canonical_request)
  //create signing key and signature
  def string_to_sign = algorithm + "\n" +  amzDate + "\n" +  credential_scope + "\n" +  hash_canonical_request
  def signing_key = getSignatureKey(secret_key, dateStamp, region, service)
  def signature = hmac_sha256Hex(signing_key, string_to_sign)
  def authorization_header = algorithm + " " + "Credential=" + access_key + "/" + credential_scope + ", " +  "SignedHeaders=" + signed_headers + ", " + "Signature=" + signature
  
  def statusCode
  def method_set
  def httpClient = new HttpClient()
  // create request based on method type
  if(method_type=="GET"){
    method_set = new GetMethod(endpoint+"?"+query_parameters)
    
  }
  else if(method_type=="POST"){
    method_set = new PostMethod(endpoint);
    StringRequestEntity requestEntity = new StringRequestEntity(
    body,
    "application/vnd.api+json","UTF-8")
    method_set.setRequestEntity(requestEntity)
  
  }
   else if(method_type=="PATCH"){
    method_set = new PostMethod(endpoint){
      @NonCPS
      public String getName()
      {
        return "PATCH"
        }
    }

    StringRequestEntity requestEntity = new StringRequestEntity(
    body,
    "application/vnd.api+json","UTF-8")
    method_set.setRequestEntity(requestEntity)
  }
  else if(method_type=="DELETE"){
    method_set = new DeleteMethod(endpoint+"/"+query_parameters)
  }

    //set request headers
    method_set.setRequestHeader(new Header("Content-Type", "application/json"))
    method_set.setRequestHeader(new Header("Host", host))
    method_set.setRequestHeader(new Header("X-Amz-Date", amzDate))
    method_set.setRequestHeader(new Header("Authorization", authorization_header))
    statusCode = httpClient.executeMethod(method_set)

  // validate the response after executing the call
  if(statusCode >= 200 && statusCode < 300){ 
      echo "statusCode:${statusCode}"
      def slurper = new JsonSlurper() 
      def response = slurper.parseText(method_set.getResponseBodyAsString()) 
      //logger.debug response
      println response
      return response
  }else{
      def slurper = new JsonSlurper()
      def response = slurper.parseText(method_set.getResponseBodyAsString()) 
      //logger.debug response
      println response
      return "Error"
  }
  }

// Product Asset Api get product ID 
def getproductsId(hostname,productName){
    def canonical_uri = "/restaurant_assets/products"
    def query_param="filter%5Bname%5D=${productName}"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"GET",query_param,"")
    productid = "Error"
    if (responseFromRequest != Error){
    echo "responseFromRequest: ${responseFromRequest}"
    if (responseFromRequest.meta.totalResourceCount != 0){
      productidlist =responseFromRequest.data.id[0]
      productid = productidlist
    }
    else{
      productid = "none"
      }
  }
    return productid
}


// POST Asset Api gateway
def productsPOST(hostname,productName,applicationslist){
  def finalResponse = "-1"
  // converted string to list 
  applicationVersions = []
  applicationVersions= applicationslist
  echo applicationVersions
  def appName = []
  def appVersion =[]
  def av = []              
  // loop based on list applicationVersions
  list = applicationVersions.split(",")
  for (int i = 0; i < list.size(); i++) {
    keyvalue = list[i]
    def (keyName, keyVersion) = keyvalue.split(':')
    appName.add(keyName);
    appVersion.add(keyVersion);

    // loop to append length of applicationNames
    StringBuilder entitys = new StringBuilder()
    entitys.append("{")
    entitys.append("\"applicationName\":\"${appName[i]}\",")
    entitys.append("\"applicationVersion\":\"${appVersion[i]}\",")
    entitys.append("\"type\":\"docker\"")
    entitys.append("}")
    av.add(entitys)
  }
    echo "appnames: ${appName}"
    echo "appVersion:${appVersion}"
                    
    // StringBuilder for json fixed part
    StringBuilder first = new StringBuilder()
        first.append("{")
        first.append("\"productName\":\"${productName}\",")
        first.append("\"applications\":")
    
    // StringBuilder for json for closing json
    StringBuilder second = new StringBuilder()
        second.append("}")

    // added StringBuilder to make request body for api
    def body = first+av+second
    echo "body: ${body}"
    def canonical_uri = "/products/records"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"POST",'',body.toString())
    if (responseFromRequest!="Error"){
      finalResponse = responseFromRequest.toString()
      return finalResponse
    }
    return finalResponse
}

// PATCH Asset Api gateway
def productsPatch(hostname,productId,productversion,applicationslist){
  def finalResponse = "-1"
  // converted string to list 
  applicationVersions = []
  applicationVersions= applicationslist
  echo applicationVersions
  def appName = []
  def appVersion =[]
  def av = []              
  // loop based on list applicationVersions
  list = applicationVersions.split(",")
  for (int i = 0; i < list.size(); i++) {
    keyvalue = list[i]
    def (keyName, keyVersion) = keyvalue.split(':')
    appName.add(keyName);
    appVersion.add(keyVersion);

    // loop to append length of applicationNames
    StringBuilder entitys = new StringBuilder()
    entitys.append("{")
    entitys.append("\"applicationName\":\"${appName[i]}\",")
    entitys.append("\"applicationVersion\":\"${appVersion[i]}\",")
    entitys.append("\"type\":\"docker\"")
    entitys.append("}")
    av.add(entitys)
  }
    echo "appnames:"+ appName
    echo "appVersion:" + appVersion
                    
    // StringBuilder for json fixed part
    StringBuilder first = new StringBuilder()
        first.append("{")
        first.append("\"productId\":\"${productId}\",")
        first.append("\"versionName\":\"${productversion}\",")
        first.append("\"applications\":")
    
    // StringBuilder for json for closing json
    StringBuilder second = new StringBuilder()
        second.append("}")

    // added StringBuilder to make request body for api
    def body = first+av+second
    echo  "request body is: ${body}"

    def canonical_uri = "/products/records"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"PATCH",'',body.toString())
    if (responseFromRequest!="Error"){
      finalResponse = responseFromRequest.toString()
      return finalResponse
    }
    return finalResponse
}

//  Api gateway  delete the version details only if version is not deployed
def versionDetailsDelete(hostname,productVersionId,productId){
    def finalResponse = "-1"
    def canonical_uri = "/products/versions"
    def query_param="productVersionId=${productVersionId}&productId=${productId}"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"DELETE",query_param,'')
    if(responseFromRequest!="Error"){
      finalResponse = responseFromRequest.toString()
      return responseFromRequest
    }
    return finalResponse
}


//deploygroupid for Application patch 

def postDeploymentGroupApplication(hostname,tagName,imageName,imageVersion,storeNo,deployedBy){

  def finalResponse = "-1"
  StringBuilder entity = new StringBuilder()
      entity.append("{")
      entity.append("\"tagName\":\"${tagName}\",")
      entity.append("\"deployComponents\":[{")
      entity.append("\"componentName\":\"${imageName}\",")
      entity.append("\"updateToVersion\": \"${imageVersion}\"}],")
      entity.append("\"isProductDeployment\": \"false\",")
      entity.append("\"restaurantIds\":[")
      entity.append("\"${storeNo}\"")
      entity.append("],")
      entity.append("\"deployedBy\": \"${deployedBy}\",")
      entity.append("\"deploymentType\": \"docker\"")
      entity.append("}")
                    
    println entity
                    
    println entity

    def canonical_uri = "/deployment/records"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"POST",'',entity.toString())
    if (responseFromRequest!="Error"){
      finalResponse = responseFromRequest.data.deploymentIds[0].deploymentId
      return finalResponse
    }
    return finalResponse
}

//deploygroupid for product Release

def postDeploymentGroupProduct(hostname,tagName,productVersionId,storeNo,deployedBy){

  def finalResponse = "-1"
  
  StringBuilder entity = new StringBuilder()
      entity.append("{")
      entity.append("\"tagName\":\"${tagName}\",")
      entity.append("\"deployProducts\":[")
      entity.append("\"${productVersionId}\"],")
      entity.append("\"isProductDeployment\": \"true\",")
      entity.append("\"restaurantIds\":[")
      entity.append("\"${storeNo}\"")
      entity.append("],")
      entity.append("\"deployedBy\": \"${deployedBy}\",")
      entity.append("\"deploymentType\": \"docker\"")
      entity.append("}")

    println entity

    def canonical_uri = "/deployment/records"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"POST",'',entity.toString())
    if (responseFromRequest!="Error"){
      finalResponse = responseFromRequest.data.deploymentIds[0].deploymentId 
      return finalResponse
    }
    return finalResponse
}


// To productReleaseId
def productReleaseId(hostname,productValue,productVersion){
    def finalResponse = "-1"

    def canonical_uri = "/restaurant_assets/product_versions"
    def firstvalue    = "filter%5Bproducts.id%5D=${productValue}"
    def secondvalue   = "include=productApplications"
    def thirdvalue    = "filter%5BversionName%5D=${productVersion}"

    def query_param="${firstvalue}&${thirdvalue}&${secondvalue}"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"GET",query_param,'')
    if (responseFromRequest!="Error"){
      finalResponse = responseFromRequest.data[0].id
      return finalResponse
    }
    return finalResponse
}


// To call product_version_api from post Method with request body
def product_version_api(hostname,product_name,tag_name,action){

  def finalResponse = "-1"
  
  StringBuilder entity = new StringBuilder()
      entity.append("{")
      entity.append("\"product_name\":\"${product_name}\",")
      entity.append("\"tag_name\":\"${tag_name}\",")
      entity.append("\"action\": \"${action}\"")
      entity.append("}")

    println entity

    def canonical_uri = "/product_tag_creation"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"POST",'',entity.toString())
    if (responseFromRequest != "Error"){
      finalResponse = responseFromRequest.status
      return finalResponse.toString()
    }
    return finalResponse
}


// POST Asset Api gateway to add New product & applications
def addNewproduct(hostname,productName,applicationslist){
  def finalResponse = "-1"
  // converted string to list 
  applicationImages = []
  applicationImages= applicationslist
  echo applicationImages
  def applicationNames = []                 

  // loop based on list applicationimages to add in Json String
  list =  applicationImages.split(",")
  for (int i = 0; i < list.size(); i++) {
  applicationImagesNames = list[i]

    // loop to append length of applicationNames
    StringBuilder entitys = new StringBuilder()
    entitys.append("{")
    entitys.append("\"applicationName\":\"${applicationImagesNames}\",")
    entitys.append("\"applicationVersion\":\"1.0.0\",")
    entitys.append("\"applicationURL\":\"${SaaSartifactoryUrl}/brep-docker/${applicationImagesNames}:1.0.0\"")
    entitys.append("}")
    applicationNames.add(entitys)
  }
                    
    // StringBuilder for json fixed part
    StringBuilder first = new StringBuilder()
        first.append("{")
        first.append("\"productName\":\"${productName}\",")
        first.append("\"applications\":")
    
    // StringBuilder for json for closing json
    StringBuilder second = new StringBuilder()
        second.append("}")

    // added StringBuilder to make request body for api
    def body = first+applicationNames+second
    echo "body: ${body}"
    def canonical_uri = "/products/records"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,canonical_uri,"POST",'',body.toString())
    if (responseFromRequest!="Error"){
      finalResponse = responseFromRequest.toString()
      return finalResponse
    }
    return finalResponse
}