
import javax.crypto.Mac
import javax.crypto.spec.SecretKeySpec
import java.security.InvalidKeyException
import java.security.MessageDigest

import org.apache.commons.httpclient.HttpClient
import org.apache.commons.httpclient.methods.GetMethod
import org.apache.commons.httpclient.Header
import groovy.json.JsonSlurper
import org.apache.http.client.methods.HttpPatch

import java.text.SimpleDateFormat
import org.apache.commons.httpclient.methods.PostMethod
import org.apache.commons.httpclient.methods.StringRequestEntity
import org.apache.http.entity.StringEntity
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper



def hmac_sha256(secretKey, data) {
    Mac mac = Mac.getInstance("HmacSHA256")
    SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, "HmacSHA256")
    mac.init(secretKeySpec)
    byte[] digest = mac.doFinal(data.getBytes())
    return digest
}
def hmac_sha256Hex(secretKey, data) {
    def result = hmac_sha256(secretKey, data)
    return result.encodeHex()
}
def getSignatureKey(key, dateStamp, regionName, serviceName){
    def kDate = hmac_sha256(("AWS4" + key).getBytes(), dateStamp)
    def kRegion = hmac_sha256(kDate, regionName)
    def kService = hmac_sha256(kRegion, serviceName)
    def kSigning = hmac_sha256(kService, "aws4_request")
    return kSigning
}
def getHexDigest(text){
    def md = MessageDigest.getInstance("SHA-256")
    md.update(text.getBytes())
    return md.digest().encodeHex()
}

// method to call API Gateway endpoint and use IAM authorization
def callAPIGatewayEndpoint(hostname,endpoint_url,method_type,uri, query_parameters,body){
  if (hostname.toLowerCase().contains("dev".toLowerCase())) {
      credentialsId = "edge-dev";
  }
  else if (hostname.toLowerCase().contains("int".toLowerCase())) {
      credentialsId = "edge-int";
  }
  else if (hostname.toLowerCase().contains("stg".toLowerCase())) {
      credentialsId = "edge-stg";
  }
  else if (hostname.toLowerCase().contains("prod".toLowerCase())) {
      credentialsId = "edge-prod";
  }
  //credentialsId = "edge-dev";
  //method to fetch AWS Credentials
  credentials = AWSCredentialsHelper.getCredentials(credentialsId, Jenkins.get());
  def access_key = credentials.getAccessKey()
  def secret_key = credentials.getSecretKey()

  def method = method_type
  def service = "execute-api"
  def host = hostname
  def region = "us-east-1"
  def endpoint = "https://${hostname}/restaurant_assets/"+endpoint_url
  def request_parameters = query_parameters
  // add formatted date according to AWS SigV4 authentication mechanism
  def now = new Date()
  def amzFormat = new SimpleDateFormat( "yyyyMMdd'T'HHmmss'Z'" )
  def stampFormat = new SimpleDateFormat( "yyyyMMdd" )
  def amzDate = amzFormat.format(now)
  def dateStamp = stampFormat.format(now)
  //create canonical request
  def canonical_uri = "/restaurant_assets/"+uri
  def canonical_headers = "host:" + host + "\n" + "x-amz-date:" + amzDate + "\n"
  def signed_headers = "host;x-amz-date"

  def payload_hash = getHexDigest(body)
  def canonical_request = method + "\n" + canonical_uri + "\n" + request_parameters + "\n" + canonical_headers + "\n" + signed_headers + "\n" + payload_hash

  def algorithm = "AWS4-HMAC-SHA256"
  def credential_scope = dateStamp + "/" + region + "/" + service + "/" + "aws4_request"
  def hash_canonical_request = getHexDigest(canonical_request)
  //create signing key and signature
  def string_to_sign = algorithm + "\n" +  amzDate + "\n" +  credential_scope + "\n" +  hash_canonical_request
  def signing_key = getSignatureKey(secret_key, dateStamp, region, service)
  def signature = hmac_sha256Hex(signing_key, string_to_sign)
  def authorization_header = algorithm + " " + "Credential=" + access_key + "/" + credential_scope + ", " +  "SignedHeaders=" + signed_headers + ", " + "Signature=" + signature

  def statusCode
  def method_set
  def httpClient = new HttpClient()
  // create request based on method type
  if(method_type=="GET"){
    method_set = new GetMethod(endpoint+"?"+query_parameters)
  }
  else if(method_type=="POST"){
    method_set = new PostMethod(endpoint);
    StringRequestEntity requestEntity = new StringRequestEntity(
    body,
    "application/vnd.api+json","UTF-8")
    method_set.setRequestEntity(requestEntity)
  
  }
  else if(method_type=="PATCH"){
    method_set = new PostMethod(endpoint){
      @NonCPS
      public String getName()
      {
        return "PATCH"
        }
    }

    StringRequestEntity requestEntity = new StringRequestEntity(
    body,
    "application/vnd.api+json","UTF-8")
    method_set.setRequestEntity(requestEntity)
  }
    //set request headers
    method_set.setRequestHeader(new Header("Content-Type", "application/vnd.api+json"))
    method_set.setRequestHeader(new Header("Host", host))
    method_set.setRequestHeader(new Header("X-Amz-Date", amzDate))
    method_set.setRequestHeader(new Header("Authorization", authorization_header))
    statusCode = httpClient.executeMethod(method_set)

  // validate the response after executing the call
  if(statusCode >= 200 && statusCode < 300){ 
      println "statusCode"
      println statusCode
      def slurper = new JsonSlurper() 
      def response = slurper.parseText(method_set.getResponseBodyAsString()) 
      //logger.debug response
      println response
      return response
  }else{
      println "statusCode"
      println statusCode
      def slurper = new JsonSlurper()
      def response = slurper.parseText(method_set.getResponseBodyAsString()) 
      println response
      return "Error"
  }

  }

// method to check if restaurant id is present on hierarchy_nodes
def getHierarchyNodesId(hostname,restaurantName,marketId){
    String url="hierarchy_nodes"
    def finalResponse = "-1"
    //query_param order is important otherwise 403 error
    def query_param="filter%5BhierarchyLevel.marketId%5D=${marketId}&filter%5BmcdRestaurantId%5D=${restaurantName}"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,url,"GET",url,query_param,"")
    if(responseFromRequest!="Error"){
      if(responseFromRequest.meta.totalResourceCount==1){
        println responseFromRequest.data[0].id
        finalResponse = responseFromRequest.data[0].id
      }
    }
    return finalResponse
}

// method to get restaurant id based on restaurant name, market name and hostname
def getRestaurantId(hostname,restaurantName,marketName){
    String url="restaurants"
    def finalResponse = "-1"
    
    def query_param="filter%5Bmarket.name%5D=${marketName}&filter%5Bname%5D=${restaurantName}"
    def responseFromRequest =callAPIGatewayEndpoint(hostname,url,"GET",url,query_param,"")
    if(responseFromRequest!="Error"){
      if(responseFromRequest.meta.totalResourceCount==1){
        println responseFromRequest.data[0].id
        finalResponse = responseFromRequest.data[0].id
      }
    }
    return finalResponse
}

// method to get market id based on market name and hostname
def getMarketId(hostname,marketName){
  String url="markets"
  def finalResponse = "-1"
  def query_param="filter%5Bname%5D=${marketName}"
  def responseFromRequest =callAPIGatewayEndpoint(hostname,url,"GET",url,query_param,"")
  if(responseFromRequest!="Error"){
    if(responseFromRequest.meta.totalResourceCount==1){
        println responseFromRequest.data[0].id
        finalResponse = responseFromRequest.data[0].id
      }
  }
  return finalResponse
}

// method to get component type id based on component type and hostname
def getComponentTypeID(hostname,componentType){
  String url="component_type"
  def finalResponse = "-1"
  def query_param="filter%5Bname%5D=${componentType}"
  def responseFromRequest =callAPIGatewayEndpoint(hostname,url,"GET",url,query_param,"")
  if(responseFromRequest!="Error"){
    if(responseFromRequest.meta.totalResourceCount==1){
        println responseFromRequest.data[0].id
        finalResponse = responseFromRequest.data[0].id
      }
  }
  return finalResponse
}

// method to get component id based on restaurant id, component name and hostname
def getComponent(hostname,restaurantID, componentName){
  String url="restaurants/${restaurantID}/components"
  def finalResponse = "-1"
  def query_param="filter%5Bname%5D=${componentName}"
  def responseFromRequest =callAPIGatewayEndpoint(hostname,url,"GET",url,query_param,"")
  if(responseFromRequest!="Error"){
    if(responseFromRequest.meta.totalResourceCount==1){
        println responseFromRequest.data[0].id
        finalResponse = responseFromRequest.data[0].id
      }
  }
  return finalResponse
}

// method to add restaurant based on restaurant name, market id and hostname
def postRestaurant(hostname,restaurantName,marketId, getHierarchyNodesId){
  String url="restaurants"
  def finalResponse = "-1"
  StringBuilder entity = new StringBuilder()
  // getHierarchyNodesId!="-1", when restaurant is present on hierarchy_nodes
  if(getHierarchyNodesId!="-1"){
    entity.append("{")
    entity.append("\"data\":{")
    entity.append("\"type\":\"restaurants\",")
    entity.append("\"attributes\":{")
    entity.append("\"name\": \"${restaurantName}\"")
    entity.append("},")
    entity.append("\"relationships\":{")
    entity.append("\"market\":{")
    entity.append("\"data\":{")
    entity.append("\"id\":\"${marketId}\",")
    entity.append("\"type\":\"markets\"")
    entity.append("}")
    entity.append("},")
    entity.append("\"hierarchyNode\":{")
    entity.append("\"data\":{")
    entity.append("\"id\":\"${getHierarchyNodesId}\",")
    entity.append("\"type\":\"hierarchy_nodes\"")
    entity.append("}")
    entity.append("}")
    entity.append("}")
    entity.append("}")
    entity.append("}")
  }
  else{
    entity.append("{")
    entity.append("\"data\":{")
    entity.append("\"type\":\"restaurants\",")
    entity.append("\"attributes\":{")
    entity.append("\"name\": \"${restaurantName}\"")
    entity.append("},")
    entity.append("\"relationships\":{")
    entity.append("\"market\":{")
    entity.append("\"data\":{")
    entity.append("\"id\":\"${marketId}\",")
    entity.append("\"type\":\"markets\"")
    entity.append("}")
    entity.append("}")
    entity.append("}")
    entity.append("}")
    entity.append("}")
  }
  println entity
  def responseFromRequest =callAPIGatewayEndpoint(hostname,url,"POST",url,'',entity.toString())
  if(responseFromRequest!="Error"){
    println responseFromRequest.data.id
    finalResponse = responseFromRequest.data.id
  } 
  return finalResponse
}

// method to add component based on restaurant id, component name, install date ,tag version and hostname
def postComponent(hostname,componentName,installDate,tagVersion,restaurantId,componentTypeID){
  String url="components"
  def finalResponse = "-1"
  StringBuilder entity = new StringBuilder()
          entity.append("{")
          entity.append("\"data\":{")
          entity.append("\"type\":\"components\",")
          entity.append("\"attributes\":{")
          entity.append("\"name\": \"${componentName}\",")
          entity.append("\"installDate\": \"${installDate}\",")
          entity.append("\"reportedVersion\": \"${tagVersion}\"")
          entity.append("},")
          entity.append("\"relationships\":{")
          entity.append("\"restaurant\":{")
          entity.append("\"data\":{")
          entity.append("\"id\":\"${restaurantId}\",")
          entity.append("\"type\":\"restaurants\"")
          entity.append("}")
          entity.append("},")
          entity.append("\"type\":{")
          entity.append("\"data\":{")
          entity.append("\"id\":\"${componentTypeID}\",")
          entity.append("\"type\":\"component_type\"")
          entity.append("}")
          entity.append("}")
          entity.append("}")
          entity.append("}")
          entity.append("}")
  def responseFromRequest =callAPIGatewayEndpoint(hostname,url,"POST",url,'',entity.toString())
  if(responseFromRequest!="Error"){
    println responseFromRequest.data.id
    finalResponse = responseFromRequest.data.id
  }
    return finalResponse
}

// method to update version of component based on component id, new version and hostname
def patchComponent(hostname,tagVersion,componentId){
  String url="components/${componentId}"
  def finalResponse = "-1"
  StringBuilder entity = new StringBuilder()
          entity.append("{")
          entity.append("\"data\":{")
          entity.append("\"type\":\"components\",")
          entity.append("\"attributes\":{")
          entity.append("\"reportedVersion\": \"${tagVersion}\"")
          entity.append("}")
          entity.append("}")
          entity.append("}")
  def responseFromRequest =callAPIGatewayEndpoint(hostname,url,"PATCH",url,"",entity.toString())
  if(responseFromRequest!="Error"){
    println responseFromRequest.data.id
    finalResponse = responseFromRequest.data.id
  }
    return finalResponse

}

// method to add deployment group based on type, tag version and hostname
def postDeploymentGroup(hostname,type,tagVersion){
  String url="deployment_groups"
  def finalResponse = "-1"
  StringBuilder entity = new StringBuilder()
          entity.append("{")
          entity.append("\"data\":{")
          entity.append("\"type\":\"deployment_groups\",")
          entity.append("\"attributes\":{")
          entity.append("\"deployedVersion\": \"${tagVersion}\",")
          entity.append("\"type\": \"${type.toLowerCase()}\"")
          entity.append("}")
          entity.append("}")
          entity.append("}")
  def responseFromRequest =callAPIGatewayEndpoint(hostname,url,"POST",url,'',entity.toString())
  if(responseFromRequest!="Error"){
    println responseFromRequest.data.id
    finalResponse = responseFromRequest.data.id
  }
    return finalResponse

}

// method to create deployment history based on restaurant id, component id, deployment group id and hostname
def postDeploymentHistory(hostname,restaurantId,componentId,groupId){
  String url="deployment_history"
  def finalResponse = "-1"
  StringBuilder entity = new StringBuilder()
          entity.append("{")
          entity.append("\"data\":{")
          entity.append("\"type\":\"deployment_history\",")
          entity.append("\"attributes\":{")
          entity.append("\"status\": \"In-Progress\"")
          entity.append("},")
          entity.append("\"relationships\":{")
          entity.append("\"restaurant\":{")
          entity.append("\"data\":{")
          entity.append("\"id\":\"${restaurantId}\",")
          entity.append("\"type\":\"restaurants\"")
          entity.append("}")
          entity.append("},")
          entity.append("\"component\":{")
          entity.append("\"data\":{")
          entity.append("\"id\":\"${componentId}\",")
          entity.append("\"type\":\"components\"")
          entity.append("}")
          entity.append("},")
          entity.append("\"deployment_group\":{")
          entity.append("\"data\":{")
          entity.append("\"id\":\"${groupId}\",")
          entity.append("\"type\":\"deployment_groups\"")
          entity.append("}")
          entity.append("}")
          entity.append("}")
          entity.append("}")
          entity.append("}")
  def responseFromRequest =callAPIGatewayEndpoint(hostname,url,"POST",url,'',entity.toString())
  if(responseFromRequest!="Error"){
    println responseFromRequest.data.id
    finalResponse = responseFromRequest.data.id
  }
    return finalResponse

}

return this
