package com.mcd

import java.io.ByteArrayOutputStream
import hudson.util.StreamTaskListener
import hudson.model.AbstractBuild
import hudson.tasks.Mailer
import hudson.model.User
import org.xml.sax.InputSource
import java.io.StringReader

import hudson.plugins.emailext.ExtendedEmailPublisher
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials
import com.cloudbees.plugins.credentials.CredentialsProvider
import hudson.util.Secret

import org.apache.commons.jelly.JellyContext
import org.apache.commons.jelly.JellyException
import org.apache.commons.jelly.JellyTagException
import org.apache.commons.jelly.Script
import org.apache.commons.jelly.XMLOutput

import jenkins.model.Jenkins

// Get the email address of the person who last committed
def getGitCommitter() {
    def email = ""
    try {
        email = sh (
            script: 'git --no-pager show -s --format=\'%ae\'',
            returnStdout: true
        ).trim()
    } catch (e) {}
    if (!email) { return "" }
    return email
}

// Get the email address of the person who last ran the job
def getJobSubmitter() {
    def email = ""
    try {
        def build = manager.build
        def cause = build.getCause(hudson.model.Cause.UserIdCause.class)

		if (cause != null) {
            def id = cause.getUserId()
            User user = User.get(id)
            email = user.getProperty(Mailer.UserProperty.class).getAddress();
        }
        if (!email) {
	        // Find if job was triggered by an upstream and get that user email
	        def upstreamCause = build.getCause(hudson.model.Cause.UpstreamCause.class)
			if (upstreamCause != null) {
			    println "Build Triggered from an Upstream Job"
				def upstreamProject = Jenkins.getInstance().getItemByFullName(upstreamCause.getUpstreamProject(), hudson.model.Job.class)
				if (upstreamProject != null) {
				    println "Located Upstream Project - Now finding specific Build"
					def upstreamBuild = upstreamProject.getBuildByNumber(upstreamCause.getUpstreamBuild())
					if (upstreamBuild != null) {
					    println "Found the specific Upstream Build"
						def upstreamUserCause = upstreamBuild.getCause(hudson.model.Cause.UserIdCause.class)
						if (upstreamUserCause != null) {
						    def upstreamId = upstreamUserCause.getUserId()
							if (upstreamId != null) {
							    println "Found Upstream User"
								User upstreamUser = User.get(upstreamId)
								email = upstreamUser.getProperty(Mailer.UserProperty.class).getAddress();
								println "Found User email of Upstream Job : ${email}"
							}
						}
					}
				}
			}
	    }
	} catch (e) {
	    println e
	}
	if (!email) { return "" }
    return email
}

// Get the email email
def getEmailDistList() {
    def email = ""
    try {
		tmpEmaildata = readYaml file: "build.yaml"
        email = tmpEmaildata.emaildistributionlist;

    } catch (e) {}
    if (!email) { return "" }
    return email
}



// Send an email using the default plugin
def sendEmail(String emailto, String subject, String body, Boolean attachBuildLog) {

    // Set the SMTP settings
    ExtendedEmailPublisherDescriptor descriptor = Jenkins.getActiveInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class)

    // MCD settings aren't working
    /*
    descriptor.setSmtpServer("smtprelay.mcd.com")
    descriptor.setSmtpPort("25")
    descriptor.setSmtpUsername("")
    descriptor.setSmtpPassword("")
    */
    descriptor.setSmtpServer("email-smtp.us-east-1.amazonaws.com")
    descriptor.setSmtpPort("587")


    StandardUsernamePasswordCredentials creds = CredentialsProvider.findCredentialById("SMTP_ACCESS",
            StandardUsernamePasswordCredentials.class, currentBuild.rawBuild)
    descriptor.setSmtpUsername(creds.getUsername())
    descriptor.setSmtpPassword(Secret.toString(creds.getPassword()))

    // In case we need some advanced settings
    //descriptor.setAdvProperties("mail.smtp.ssl.trust=test0.com")

    descriptor.setUseSsl(false)
    descriptor.setCharset("UTF-8")

    // Free the memory, causes fault if absent
    descriptor = null

    emailext (
        to: emailto,
        mimeType: 'text/html',
        subject: subject,
        body: body,
        attachLog: attachBuildLog,
        attachmentsPattern: "**/email_attachments/*.*",
        compressLog: true
    )

}

// Send an email to the email address of the person who last committed
def sendToGitCommitter(String subject, String body, Boolean attachBuildLog) {
    def committer = getGitCommitter()
    if (!committer) {
        println "Email not found in git commit, not sending."
        return false
    }
    if (committer.endsWith('@us.mcd.com') ||
        committer.endsWith('@service-now.com') ||
        committer.endsWith('@capgemini.com') ||
        committer.endsWith('@publicisgroupe.net') ||
        committer.endsWith('@slalom.com') ||
        committer.endsWith('@sapient.com') ||
        committer.endsWith('@sapientrazorfish.com') ||
        emailaddress.endsWith('@codagami.com') ||
        committer.endsWith('@smith.co')
    ) {
        return sendEmail(committer, subject, body, attachBuildLog)
    } else {
        println "Email ${committer} not found in whitelist."
        return false
    }
}

// Send an email to the email address of the person ran the job
def sendToJobSubmitter(String subject, String body, Boolean attachBuildLog) {
    def committer = getJobSubmitter()
    if (!committer) {
        println "Email not found in jenkins job, not sending."
        return false
    }
    if (committer.endsWith('@us.mcd.com') ||
        committer.endsWith('@service-now.com') ||
        committer.endsWith('@capgemini.com') ||
        committer.endsWith('@publicisgroupe.net') ||
        committer.endsWith('@slalom.com') ||
        committer.endsWith('@sapient.com') ||
        committer.endsWith('@sapientrazorfish.com') ||
        emailaddress.endsWith('@codagami.com') ||
        committer.endsWith('@smith.co')
    ) {
        return sendEmail(committer, subject, body, attachBuildLog)
    } else {
        println "Email ${committer} not found in whitelist."
        return false
    }
}

// Send an email to the distribution list for the job (set in build.yaml, added for VET-652)
def sendToJobDistList(String subject, String body, Boolean attachBuildLog) {
    def committer = getEmailDistList()
    if (!committer) {
        println "Email distribution list not found, not sending."
        return false
    }
	// Split and validate each address in the list against whitelisted domains
	def tempemaillist = committer.split(';')
	tempemaillist.each { emailaddress ->
		if (emailaddress.endsWith('@us.mcd.com') ||
			emailaddress.endsWith('@service-now.com') ||
			emailaddress.endsWith('@capgemini.com') ||
      emailaddress.endsWith('@publicisgroupe.net') ||
			emailaddress.endsWith('@slalom.com') ||
			emailaddress.endsWith('@sapient.com') ||
			emailaddress.endsWith('@sapientrazorfish.com') ||
            emailaddress.endsWith('@codagami.com') ||
			emailaddress.endsWith('@smith.co')
    ) {
        // valid email address - do nothing and move onto next email
    } else {
        println "Email ${emailaddress} not found in whitelist."
        return false
		}
	}

	// if all emails are valid then send email
	return sendEmail(committer, subject, body, attachBuildLog)
}

// Load jelly file from shared library
def loadTemplate(String filename) {
    def tplfile = libraryResource "com/mcd/${filename}"
    def build = currentBuild.rawBuild
    ByteArrayOutputStream stream = new ByteArrayOutputStream()
    StreamTaskListener listener = new StreamTaskListener(stream)

    JellyContext context = new JellyContext()
    ExtendedEmailPublisherDescriptor descriptor = Jenkins.getActiveInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class)
    context.setVariable("it", new Object())
    context.setVariable("build", build)
    context.setVariable("project", build.getParent())
    context.setVariable("logger", listener.getLogger())
    context.setVariable("rooturl", descriptor.getHudsonUrl())

    Script script = context.compileScript(new InputSource(new StringReader(tplfile)))
    if (script != null) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(16 * 1024)
        XMLOutput xmlOutput = XMLOutput.createXMLOutput(output)
        script.run(context, xmlOutput)
        xmlOutput.flush()
        xmlOutput.close()
        output.close()
        return output.toString(ExtendedEmailPublisher.descriptor().getCharset())
    }
    return null
}

// Send build email to the email address of the person who last committed
def sendBuildToGitCommitter() {
    def result = currentBuild.currentResult.toString()
    def attachBuildLog = (result == 'FAILURE') ? true : false
    try {
        sendToGitCommitter("Build Job '${env.JOB_NAME} [${env.BUILD_NUMBER}]' ${result}", loadTemplate('jenkins-email.jelly'), attachBuildLog)
    } catch (e) {
        println "Sending Email failed"
    }
}
// Send deployment email to the email address of the person running the job
def sendDeployToJobSubmitter() {
    def result = currentBuild.currentResult.toString()
    def attachBuildLog = (result == 'FAILURE') ? true : false
    try {
        sendToJobSubmitter("Deploy Job '${env.JOB_NAME} [${env.BUILD_NUMBER}]' ${result}", loadTemplate('jenkins-email.jelly'), attachBuildLog)
    } catch (e) {
        println "Sending Email failed"
        println e
    }
}

// Send build email to the optional distribution list in build.yaml (added for VET-652)
def sendBuildToDistList() {
    def result = currentBuild.currentResult.toString()
	def attachBuildLog = (result == 'FAILURE') ? true : false
    try {
        sendToJobDistList("Build Job '${env.JOB_NAME} [${env.BUILD_NUMBER}]' ${result}", loadTemplate('jenkins-email.jelly'), attachBuildLog)
    } catch (e) {
        println "Sending Email to distribution list failed"
    }
}


// Send email to VET team
def sendEmailToUsVetTeam() {
    def result = currentBuild.currentResult.toString()
	  def attachBuildLog = (result == 'FAILURE') ? true : false
    def committer = 'US-VET-INFRASUPPORT@us.mcd.com'
    try {
        subject = "Build Job '${env.JOB_NAME} [${env.BUILD_NUMBER}]' ${result}"
        return sendEmail(committer, subject, loadTemplate('jenkins-email.jelly'), attachBuildLog)
    } catch (e) {
        println "Sending Email to US-VET-INFRASUPPORT list failed"
    }
}

// Send deployment email to the optional distribution list in build.yaml (added for VET-652)
def sendDeployToDistList() {
    def result = currentBuild.currentResult.toString()
    try {
        sendToJobDistList("Deploy Job '${env.JOB_NAME} [${env.BUILD_NUMBER}]' ${result}", loadTemplate('jenkins-email.jelly'))
    } catch (e) {
        println "Sending Email to distribution list failed"
        println e
    }
}

// Sending notification to webex teams if jobs is base
def commonSendWebexAlertBaseJobs(String baseName, String jobName) {
  if (baseName.contains('base') ) {
    if (jobName == 'master' || jobName.contains('develop') ) {
      def body= """{
            "name": "${baseName}",
            "url": "${JOB_URL}",
            "build": {
                "full_url": "${BUILD_URL}",
                "number": "${BUILD_NUMBER}",
                "phase": "COMPLETED",
                "status": "FAILURE",
                "url": "${BUILD_URL}"
            }
        }"""
        sh  "curl -X POST -H 'Content-Type: application/json' 'https://botworkflows.webex.com/embed/run/99602d28c0d16bae0f21b2' -d '${body}'"
    }
  } else {
    println("This jenkins job is not base. ${baseName}, ${jobName}")
  }
}


return this
