# CHANGELOG

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [release/1.24.2] - 2022-12-20

#### Added New UpdateNewProductDetails Pipeline
  - pipeline to make DB entries for new product / new application


## [release/1.24.0] - 2022-12-20

### Docker pipelines

#### Added
  - Removed prisma components

## [release/1.23.0] - 2022-12-20

### Docker pipelines

#### Added
  - Xray and build publish integration




### Release New Product Version

#### Added
  - updated Release New Product Version pipeline workflow starts from the stage environment to create new product version, once it needs to be released to the live stores/canary stores please choose promote version which eventually promote the version to the Production Environment.

### Cloud EKS Deployment & Edge Restaurant Pipeline Gitops v3 Pipeline 

#### Added
  - Updated asset Api's

### Release New Product Version

#### Added
  - updated Release New Product Version pipeline workflow starts from the stage environment to create new product version, once it needs to be released to the live stores/canary stores please choose promote version which eventually promote the version to the Production Environment.

## [release/1.21.0] - 2022-11-16

### NpmBuilderPipeline & ContainerBuilderMenu 

#### Added
  - automatically fetch .npmrc file from artifactory while the build pipeline is running.

## [release/1.20.99] - 2022-11-11

### Cloud EKS Deployment Pipeline

#### Added
  - point to the new asset API.

### BatchDeployEdgeRestaurantPipeline

#### Added
  - updated Descriptions and updated conditions.

## [release/1.20.98] - 2022-11-09

### Pipeline Edge Restaurant Pipeline Gitops v3

#### Added
  - Updated Edge Restaurant Gitops v3 Pipeline to add the data to asset db which will help to generat deployment Group ID by calling Rest Api's and which makes gitops deployment in sync with proper imageNames and versions for ApplicationPatch and ProductRelease

### Release New Product Version

#### Added
  - update Asset DB during product release tag creation

## [release/1.20.96] - 2022-09-30

### EdgeRestaurantPipeline

#### Added
  - New stage added to trigger Mqtt lambda present in ioT for onboarding new resturants .

## [release/1.20.95] - 2022-09-27

### BatchDeployEdgeRestaurantPipeline

#### Added
  - New pipeline developed to trigger existing Edge Restaurant Pipeline for each store
  

## [release/1.20.94] - 2022-09-07

### BaseLine Update

#### Added
  - New Script that automated the release tag creation and changelog updation process for Baseline apps

## [release/1.20.93] - 2022-08-22

### Edge Restartant

#### Added
  - Updated Onboarding EdgeRestaurantPipeline suppourt to Updated TF Version of SQS


## [release/1.20.90] - 2022-05-24

### ContainerBuilder && ContainerBuilderMenu

#### Added
  - Intermediate branch support for Stg enviornment to be used by FE/UI team

## [release/1.20.85] - 2022-04-12

### RepoPipelineCreate

#### Added
  - New script to automate the entire repo creation and multibranch pipeline via jenkins

## [release/1.20.83] - 2022-04-11

### NoSonarFlag

#### Added
  - Changed docker container to run on same network host


## [release/1.20.79] - 2022-04-29

### TerraformJenkinsPipeline.groovy

#### Added
  - Enabled coverage report for nodejs and python lambda's

## [release/1.20.78] - 2022-03-24

### NoSonarFlag.groovy

#### Added
  - Added new pipeline without sonarqube flag for CM & EVD teams


## [release/1.20.75] - 2022-03-10

### OpenTAestUI pipeline

#### Added
  - Template name changed for open tests to run.

## [release/1.20.74] - 2022-03-09

### OpenTAestUI pipeline

#### Added
  - Disabled docker container ls for pipeline to run .


## [release/1.20.72] - 2022-03-02

### GitOpsOnboardingPipeline 
### configManagementCall Groovy

#### Added
  - API call to config-management Basic lambda for automate the default profile creation 
  - Instead of user input, pipeline will fetch networkInfo, regionScope and coopScope from config-mgmt system

## [release/1.20.70] - 2021-08-12

### OpenTestUI Pipeline
### Repo Builder pipeline

#### Added
  - Upgraded repo builder pipeline with new build type 
  - Added new script 'opentestUI' to common library

## [release/1.20.69] - 2021-07-27

### GitOps Pipeline

#### Added
  - Upgraded GitOPs Onboarding Pipeline to support Multienvironment, onboard to assset and config-management service and provision SQS queue in respective environment.

## [release/1.20.68] - 2021-07-21

### RestaurantOnboarding Pipeline

#### Added
  - Upgraded Restaurant Onboarding Pipeline in-order to link hierarchy node to restaurant when posting restaurant details to asset service.

## [release/1.20.67] - 2021-07-19

### RestaurantOnboarding Pipeline

#### Added
  - Introduced configmanagement onboarding with SQS queue based on ScopeId

## [release/1.20.63] - 2021-06-10

### ContainerBuilderMenu

#### Added
  - Intermediate branch and Bugfix branch support

## [release/1.20.60] - 2021-05-05

### OpenTestSelenium

#### Added
  - Added support for disabling parallel jobs and Increased timeout and Attempts to CuRl the server

## [release/1.20.59] - 2021-05-04

### ContainerMenuBuilder

#### Added
  - Increased timeout and Attempts to CuRl the server



## [release/1.20.58] - 2021-04-26

### GitOps Deployment

#### Added
  - New Script and Pipeline created to support GitOps flow



## [release/1.20.57] - 2021-04-08

### ContainerBuilder && MenuLambda pipeline

#### Added
  - SonarQube Enterprise integration



## [release/1.20.54] - 2021-04-05

### RepoBuilder pipeline

#### Added
  - Added new parameter for SRE team to create and manage the Code/Artifacts


## [release/1.20.53] - 2021-27-03

### ResturantOnboarding pipeline

#### Added
  - Added AOT deployment support 

## [release/1.20.52] - 2021-24-03

### ResturantOnboarding pipeline

#### Added
  - Added SQS support for CM team

## [release/1.20.51] - 2021-18-03

### SonarGroovy

#### Added
  - Fixed gradle issue

## [release/1.20.50] - 2021-10-03

### Artifact ingestion Pipeline & ContainerBuilderMenu.groovy

#### Added
  - PIP package support
  - Email recipients for Menu team 

## [release/1.20.47] - 2021-01-02

### ContainerBuilder.groovy

#### Added
  - Sonar coverage dependency

## [release/1.20.46] - 2021-28-01

### TerraformJenkins & TerraformNoSonar

#### Added
  -  Added New groovy for Menu team without Sonar stage
  - Enabled SOnarstage back for platform team



## [release/1.20.45] - 2021-13-01

### ContainerBuilder Pipeline

#### Added
  -  Email notification stage ADDED



## [release/1.20.45] - 2021-13-01

### ContainerBuilder Pipeline

#### Added
  -  Email notification stage ADDED

## [release/1.20.44] - 2021-10-01

### Resturant onboarding pipeline

#### Added
  - Added AssetSvcCall global library  in src/com/bre

## [release/1.20.43] - 2021-06-01

### ContainerBuilder Pipeline & Terraform Pipeline

#### Added
  - Added OPen test logging for Container builder && Removed sonarstage for terraform pipeline


## [release/1.20.42] - 2020-19-12

### OPenTestSelenium Pipeline

#### Added
  - Added New buildType



## [release/1.20.41] - 2020-14-12

### NPM Builder and Terraform pipeline

#### Added
  - Added Sonar scanning capability




## [release/1.20.34] - 2020-14-09

### ContainerBuilder Pipeline

#### Added

- Added Tpescript coverage report option for Sonar

## [release/1.20.33] - 2020-10-09

### ContainerBuilder Pipeline

#### Added

- Added Env varaible opetion to Run Ng build & Ng serve Dynamically 

## [release/1.20.32] - 2020-09-17

### Restaurant onboarding pipeline

#### Added

- Added restaurantName parameter to SNS publish payload

## [release/1.20.31] - 2020-09-16
### Restaurant onboarding pipeline

#### Added
- Query Dev asset service endpoint for dev environment deployment

## [release/1.20.30] - 2020-09-14

### Restaurant onboarding pipeline

#### Added
- SQS queue changes to get created in specific environment. SQS TF Modules updated with sample tfvars file to create queue with specific naming convention.

## [release/1.20.29] - 2020-09-10

### ContainerBuilder Pipeline

#### Added
- Add maven goals for coverage report to be in sonar
#### Changed
- Move the install dependencies step before the docker build step

## [release/1.20.28] - 2020-09-01

### ContainerBuilder Pipeline

#### Changed
- Set the sonar.sources parameter dynamically

## [release/1.20.27] - 2020-09-01

### ContainerBuilder Pipeline

#### Added
- Add sonar.sources and sonar.exclusions parameters for python sonar scans

## [release/1.20.26] - 2020-08-28

### ContainerBuilder Pipeline

#### Changed
- Updated maven goals for coverage report to be published to sonarqube
- Add debug flag to maven package command

## [release/1.20.25] - 2020-08-24

### ContainerBuilder Pipeline

#### Changed
- Run the when check before the agent for the 'Run testing suite' stage

## [release/1.20.24] - 2020-08-21

### ContainerBuilder Pipeline

#### Changed
- Added a conditional for the Modify Kubernetes Opentest Pod to be skipped if opentest file doesn't exist
- The above will allow applications not having use cases for functional tests to skip the stage as it is not needed

## [release/1.20.23] - 2020-08-18

### ContainerBuilder Pipeline

#### Changed

- Moved the Build Image stage before the Sonarqube Scan stage
- Updated the Build Image stage to build a `Dockerfile.test` file if one is found and export the outputs
- Updated the Sonarqube Scan stage to set the python coverage path if a `coverage.xml` file is found

## [release/1.20.22] - 2020-08-12

### JarBuilder pipeline

#### Changed

- Fix Java build type not being set if Sonarqube does not run.

## [release/1.20.21] - 2020-08-12

### ContainerBuilder Pipeline

#### Changed

- Install dependencies by running `install_deps.sh` script if it exists in root directory.

## [release/1.20.20] - 2020-08-06

### Restaurant Onboarding Pipeline

#### Changed

- Fixed issue where request to asset service failed which caused entire CURL response to be passed into tfvars.

## [release/1.20.19] - 2020-08-06

### Restaurant Onboarding Pipeline

#### Changed

- Added market.name to Assets Service Query

## [release/1.20.18] - 2020-07-17

### Long Lived Virtual K3s Restaurant Pipeline

#### Changed

- Updated code to add AWS profile
- Updated code to pass the selected region to the generated AWS profile
- Updated the virtual restaurant tfvars to include more values such as region and environment

## [release/1.20.17] - 2020-07-17

### ContainerBuilder

#### Changed

- Revert changes made as part of release 1.20.15

## [release/1.20.16] - 2020-07-21

### RepoBuilder

#### Changed

- Updating RepoBuilderPipeline.groovy parameters to support Audio Capture project name "AC"

## [release/1.20.15] - 2020-07-17

### ContainerBuilder

#### Changed

- Updating BASE_URL reference to "https" from "http" for the opentest tests

## [release/1.20.14] - 2020-07-15

### NPM Builder Pipeline

#### Changed

- updated NPM registry to a new key of `npm-local`
- Updated npm publish to publish to HTTPs instead of HTTP

## [release/1.20.13] - 2020-07-16

### Terraform Builder Pipeline
### Jar Builder Pipeline


#### Changed

- Added jenkins environment buildToolsLambdaAppImageVersion to manage docker tag for bre-lambda-app-builder

## [release/1.20.12] - 2020-07-07

### Long Lived Restaurant Pipeline

#### Changed

- Changed casing to lowercase

## [release/1.20.11] - 2020-07-13

### Restaurant Onboarding Pipeline

#### Added

- Added market name parameter
- Added component type parameter

#### Changed

- Updated restaurant payload to include market relationship
- Updated component POST payload to include new component_type table
- Updated restaurant POST payload to include market relationship

## [release/1.20.10] - 2020-07-07

### ContainerBuilder & JarBuilder

#### Changed

- Fixed naming of Gradle-built projects in sonar

## [release/1.20.9] - 2020-06-19

### ContainerBuilder & JarBuilder

#### Changed

- Only run sonar scan on master branches

## [release/1.20.8] - 2020-06-15

### Repo Builder Pipeline

#### Added

- Added new BB projects

## [release/1.20.7] - 2020-06-11

### ContainerBuilder

#### Changed

- Added sonar scan for all project types.

## [release/1.20.6] - 2020-06-09

### Artifactory Cleaner

#### Added

- Added artifactory cleaner job to clean artifacts older than x days.

## [release/1.20.5] - 2020-06-04

### Container Builder Pipeline

#### Changed

- Copy `.m2` directory into working directory, so we can use it in docker image for caching

## [release/1.20.4] - 2020-06-04

#### Changed

- use host directory for caching maven dependencies in build-tools image

## [release/1.20.3] - 2020-06-04

#### Changed

- Use variable for `lambda app builder image`
- Add flags to mvn to retry and disable keepalive
- use host directory for caching maven dependencies

## [release/1.20.2] - 2020-06-02

#### Changed

- Modified JarBuilder pipeline to include config injection for Artifactory server credentials for Maven build
- Modified ContainerBuilder pipeline to Docker login before container build so we can pull down base images on artifactory

## [release/1.20.1] - 2020-05-29

#### Added

- Adding OpenTest to NPM Builder Pipeline

## [release/1.20.0] - 2020-05-20

#### Added

- Added artifact ingestion pipeline

## [release/1.19.0] - 2020-05-18

#### Added

- Added virtual restaurant long lived cluster pipeline

## [release/1.18.0] - 2020-05-12

#### Added

- Added new NPM Builder Pipeline

#### Changed

- Modified the repo builder pipeline to support a new `npm-module` project type

## [release/1.17.3] - 2020-05-14

### Jar Builder Pipeline

#### Fixed

- fixed file check, check for pom.xml for maven

## [release/1.17.2] - 2020-05-14

### Container Builder Pipeline

#### Fixed

- fixed `imageSha` curl command. Add ignore case

## [release/1.17.1] - 2020-05-13

### Restaurant Onboarding Pipeline

#### Changed

- Hardcoded s3 bucket env for KMS
- Changed `Restaurant ID` to `Restaurant Name` as this was causing some confusion

## [release/1.17.0] - 2020-05-04

### Container Builder Pipeline

#### Added

- Added env variables for application container
- Added validation of `dependencies.yml`
- Added running opentest tests if `opentest` folder exists
  - Added if `opentest` folder exists but `dependencies.yml` does not exist, it will fail the build and give information
- Added if db type and schema_path specified in `dependencies.yml` it will import database
- Added basic info about `dependencies.yml` at https://us-confluence.mcd.com/pages/editpage.action?pageId=151436351
- Added removal of `docker image tag` from artifactory if `opentest` tests fail or if the build was aborted

#### Changed

- Updated `containerbuilder-opentest-pod.yaml` template to include database container
- Modified `dependencies-schema.yaml`
  - Application `port` is now required
  - Database information is not required
- Use latest successful build instead of just previous build

#### Todo

- Todo, fix postgresql syntax, for now we only have usecase for mysql

## [release/1.16.5] - 2020-04-30

### BRED Charts Helm Pipeline

#### Added

- Added region parameter for ansible-playbook

## [release/1.16.4] - 2020-04-30

### Repo Builder Pipeline

#### Added

- Added `nobuild` parameter to `Build Type`
- Do not create jenkins job when `nobuild` build type specified

#### Fixed

- Fixed `pre-check` stage

## [release/1.16.3] - 2020-04-16

### Ansible Chart Helm Pipeline

#### Added

- Added functionality to allow for the pipeline to be used against multiple tooling accounts

#### Changed

- Renamed pipeline from `AnsibleJenkinsPipeline` to `AnsibleChartsHelmPipeline`

## [release/1.16.2] - 2020-04-21

### Container Builder Pipeline

#### Changed

- Changed `docker rmi` do `docker prune` instead because we want to cache the image and use it in nested-pods

## [release/1.16.1] - 2020-04-21

### Container Builder Pipeline

#### Changed

- Added if statement if there is no opentest folder

## [release/1.16.0] - 2020-04-16

### Container Builder Pipeline

#### Added

- Added containerbuilder-opentest-pod.yaml pod template file
- Added boolean parameter to use docker cache or not, default `true`
- Added creation of nested pod to run tests against built application
  - if opentest fails against the application it will remove the docker image from artifactory and fail the build, but preserving junit report

#### Changed

- Changed env variables in pipeline to uppercase
- Changed imagePullSecret to `image-pull-secret` from `artifactory`
- Fixed git extraction
- Moved `artifactory` credentials to `environment variables` instead of using `withCredentials` in every step

#### Misc

- Added step to modify pod template for opentest with latest app build tag for testing

## [release/1.15.8] - 2020-04-16

### Repo Builder Pipeline

#### Added

- Added `MENU` project

## [release/1.15.7] - 2020-04-08

### Repo Builder Pipeline

#### Changed

- Added Regex validator object that will make it so the pipeline run will fail if there are illegal characters used in the `Application Name` input
- Updated `destProject` replaceall method to include underscores
- Added `BREF` project to Repo Builder

## [release/1.15.6] - 2020-04-01

### Restaurant Onboarding Pipeline

#### Changed

- Added .trim() for the shell result

## [release/1.15.5] - 2020-03-31

### Restaurant Onboarding Pipeline

#### Changed

- Added escaping for \ character

## [release/1.15.4] - 2020-03-31

### Restaurant Onboarding Pipeline

#### Changed

- Updated to use shortRegion variable for S3 bucket name generation in tfvar file

## [release/1.15.3] - 2020-03-31

### Restaurant Onboarding Pipeline

#### Changed

- Updated to use SHORT_REGION for S3 bucket name generation in tfvar file

## [release/1.15.2] - 2020-03-26

### Virtual Restaurant Short Lived Pipeline

#### Added

- Added support to run tests and dependencies from respective docker image branch instead of always using master

## [release/1.15.1] - 2020-03-25

### Virtual Restaurant Short Lived Pipeline

#### Added

- Added support for specifying name of MySQL database to create on chart install.

## [release/1.15.0] - 2020-03-24

### Virtual Restaurant Short Lived Pipeline

#### Added

- Added support for Opentest tests
- Pull tests and dependency.yaml from corresponding docker image's bitbucket repo.

## [release/1.14.2] - 2020-03-23

### Restaurant Onboarding Pipeline

#### Changed

- Added remote state s3 bucket information in restaurant_N.tfvars to be used to get key information from tf-kms-terraform remote state.

## [release/1.14.1] - 2020-03-19

### Restaurant Onboarding Pipeline

#### Changed

- Changed component type from `docker` to `DOCKER` to keep consistent naming in asset service

## [release/1.14.0] - 2020-03-11

### Jar Builder Pipeline

#### Added

- Jar builder pipeline will build maven and gradel apps and push them to artifactory
- Pipline uses the artifactory plugin to push jar files to the artifactory repo
- Master branch apps will be tagged witha release number

## [release/1.13.0] - 2020-03-09

### Virtual Restaurant Pipeline

#### Added

- Virtual Restaurant (VR) pipeline is modified to prompt for parameters (application name, image tag)
  - Add a prompt that asks "What application do you want to test?"
- Add ability to generate/apply deployment, ingress, service to shortlived restaurant pipeline
- VR pipeline is able to deploy the application to k3s cluster that is being created as a part of the pipeline

## [release/1.12.1] - 2020-03-06

### Restaurant Onboarding Pipeline

#### Changed

- Changed component type to `docker` from `COMPONENT_TYPE1` this will be more useful for querying assets service

## [release/1.12.0] - 2020-03-05

### Virtual Restaurant Pipeline

#### Added

- Added ability to install dependencies before application install
- Added verification check of dependencies yml

#### Changed

- Terraform destroy of cluster moved to post -> always block to ensure cluster is always destroyed.

## [release/1.11.3] - 2020-03-03

### Terraform Pipeline

#### Changed

- added `and` to `if` statement to check if `configuration file` is set to default value

## [release/1.11.2] - 2020-03-02

### Virtual Restaurant Pipeline

#### Changed

- En-dash in docker build pipeline changed to regular hyphen

## [release/1.11.1] - 2020-02-27

### Virtual Restaurant Pipeline

#### Added

- Added virtual restaurant kubeconfig retrieval functionality to `Create Cluster` stage
  - Kubeconfig is retrieved from S3 using the build-tools container role and is stored in the containers home directory

## [release/1.11.0] - 2020-02-19

### Virtual Restaurant Pipeline

#### Added

- Added initial Virtual Restaurant Pipeline for shortlived clusters.

## [release/1.10.2] - 2020-02-14

### Admin Pipeline

#### Added

- Add Ansible as an option to build pipeline parameters.

## [release/1.10.1] - 2020-02-14

### Admin Pipeline

#### Added

- Additional error checking when the pipeline does not have appropriate parameters available.

#### Changed

- Moved variable assignment dependent on parameter to Pre-check stage to allow for declarative parameter functionality.

## [release/1.10.0] - 2020-02-10

### Restaurant Onboarding Pipeline

#### Added

- Added Restaurant Onboarding Pipeline
  - When `Restaurant ID` != `empty`:
    - When `Action` = `create`
      - Pipeline creates SQS for specified restaurant
      - Pipeline adds specified restaurant to asset service
      - Pipeline has ability to add components to specified restaurant
        - Pipeline triggers deployment when component is added to restaurant
    - When `Action` = `create` && `component` = `true`
      - Pipeline creates SQS for specified restaurant
      - Pipeline adds specified restaurant to asset service
      - Pipeline prompts you to pick docker image
      - Pipeline prompts you to pick docker image tag
      - Pipeline pushes SNS message to deploy application using `onboarding lambda`
    - When `Action` = `destroy`
      - Pipeline will delete all components associated with that restaurant
      - Pipeline will delete SQS and remove restaurant from asset service
    - When `Action` = `none` && `component` is `true` it will:
      - Pipeline will prompt you to pick docker image
      - Pipeline will prompt you to pick docker image tag
      - Pipeline will push SNS message to deploy application
    - When `Action` = `none`
      - nothing will happen

### Terraform Pipeline

#### Added

- Added `plan -destroy` to see what resources will be deleted before running terraform destroy

## [release/1.9.4] - 2020-02-05

### Terraform Pipeline

#### Added

- Added support for multi accounts
  - Account ID is being taken from configuration File path

#### Removed

- Removed dynamic AWS Account ID retrieval

## [release/1.9.3] - 2020-02-04

### Terraform Pipeline

#### Added

- Added `lambda-app-builder` docker container
- Added checks if `gradle` or `install_deps.sh` script exists
  - if yes then it will run `gradle build` or `install_deps` in root directories

## [release/1.9.2] - 2020-02-04

### Ansible Pipeline

#### Changed

- Moved AWS_REGION from outside of ansible-playbook environment variable to global variable
- Renamed `bre-testing` to `bre-tooling` for default parameter

## [release/1.9.1] - 2020-01-31

### Terraform Pipeline

#### Added

- Added AWS_REGION to module validation, otherwise `terraform validate` fails

## [release/1.9.0] - 2020-01-24

### Common Pipelines

#### Changed

- Use variable when it comes to `build-tools` image version

### Terraform Pipeline

#### Added

- Added `lambda` and `terraform-module` build types
- Terraform pipeline now downloads `tf_init.sh` script from Artifactory, no needs to include it in repository anymore

#### Changed

- Terraform pipeline is now able to run `lambda` pipeline based on repository `extension`
- Terraform pipeline is now able to run `terraform-module` pipeline based on repository `extension`
- Terraform pipeline is now able to run `terraform` pipeline based on repository `extension`

## [release/1.8.0] - 2020-01-24

### Artifactory Jenkins Pipeline

#### Added

- Pushes files from local GIT to Artifactory

## [release/1.7.4] - 2020-01-24

### Container Builder Pipeline

#### Added

- Added additional parameter to RepoBuilder Pipeline. This parameter will allow us to choose if we would like to make a repository in Bitbucket or just a Jenkins job

## [release/1.7.3] - 2020-01-22

### Container Builder Pipeline

#### Changed

- Updated SNS Push message logic to include additional information when pushing messages for feature & hotfix branches

## [release/1.7.2] - 2020-01-22

### Admin Pipeline

#### Changed

- Renamed parameters

#### Removed

- Removed ECR repo creation as we moved to artifactory

## [release/1.7.1] - 2020-01-21

### Admin Pipeline

#### Added

- Added `periodicFolderTrigger` to a 2 minute interval to replace deprecated function

#### Changed

- Switched all hard-coded URLs to use HTTPS

#### Removed

- Deprecated `periodic` pipeline DSL

## [release/1.7.0] - 2020-01-20

### Common Pipelines

#### Added

- Added artifactory secret

#### Changed

- Use artifactory instead of ECR
- Formatting fixes, use 2 spaces instead of 4 for tab

#### Removed

- Removed creation of ECR repository

### Helm Pipeline

#### Changed

- Removed docker helm image and use `build-tools` image

## [release/1.6.0] - 2020-01-13

#### Added

- Added RepoBuilderPipeline to our jenkins-global-lib

## [release/1.5.2] - 2020-01-13

#### Added

- ContainerBuilder pipeline now supports the tagging and pushing of feature and hotfix branches

#### Changed

- Updated releasetag tag & replaceversion variable to be env's as opposed to just jenkins variables. This was needed because our pipeline was updated to run native docker commands as of release `1.5.0`

## [release/1.5.1] - 2020-01-08

### Terraform Pipeline

#### Added

- Get AWS account ID from metadata and use that in default configuration file for terraform

#### Changed

- Split `plan & apply` to plan and apply steps

### Ansible Pipeline

#### Changed

- Fixed ansible-playbook tags

## [release/1.5.0] - 2020-01-07

### Ansible Pipeline

Added a new Ansible pipeline that will run our ansible-playbook located at `bred-charts-helm`. Pipeline takes the paramteters of `REGION` & `CLUSTER_NAME`

#### Added

- Added Run Ansible Playbook stage
- Added code to make a parameterized pipeline, so we can choose what region and cluster to run the playbook against

### Container Builder Pipeline

#### Changed

- Updated container version to release tag 1.4.0
- Changed container that pipeline runs as from `docker` to `build-tools`
- Changed pipeline to use native docker commands instead of the jenkins docker plugin. This was done because the jenkins docker plugin does not work when we're using kube2iam

## [release/1.4.0] - 2020-01-07

### Terraform Pipeline

By default the terraform pipeline only runs terraform validate
If you want to apply or destroy infrastructure using terraform you will need go to jenkins job and click `build with parameters` and pick `apply` or `destroy` option.

#### Added

- Added terraform init step
- Added terraform validate step
- Added terraform apply step
- Added terraform destroy step
- Added jenkins slave role to pod template

#### Changed

- Added some git config with password and username for downloading modules.

## [release/1.3.1] - 2020-01-06

### Container Pipeline

#### Added

- Use aws cli for pushing SNS notifications
- Added jenkins slave role to pod template

#### Changed

- Updated build-tools image to 1.3.0

### Removed

- Removed aws plugin from SNS notifications

## [release/1.3.0] - 2019-12-18

### Terraform Pipeline

#### Added

- Added terraform pipeline to verify terraform code

## [release/1.2.0] - 2019-12-18

### Consul Pipeline

#### Added

- Use `yaml-to-consul` docker image
- `yaml-to-consul` container is parsing consul configuration files and pushes them to `consul`

#### Changed

- Use `jenkins secrets` for storing consul token

#### Removed

- Removed snakeyaml libraries
- Removed docker in docker image from pod template
- Removed groovy code to parse yaml files

## [release/1.1.0] - 2019-12-12

### Added

- Get previous build for master branch

### Changed

- Renamed variables

## [release/1.0.0] - 2019-12-11

Initial release.

### General Pipeline

#### Added

- Bitbucket Multi-branch Pipelines are now supported.
- Trunk-based Development is partially enforced by the pipeline now.
- Helm pipeline is now available for use.
- Pipeline now determines project name and app name based on naming of the job and folder.

### Container Pipeline

#### Added

- `releaseTag` and `replaceVersion` are now pulled from tag messages.
- The pipeline how outputs more helpful build error messages.

#### Changed

- `info.yml` is deprecated.
- Distinctions between release as regular master branch builds are now noted. Separate SQS queues are now notified.
