## Source : https://github.com/RenpyRemix/multi-notify

## To view example in your game add
##
##  call multi_notify_example
##
## somewhere in your running label script

###########################################
#                                         #
#           To use in your game           #
#                                         #
#    Uncomment the following line and     #
#    maybe delete the example label at    #
#    the end of this file                 #
#                                         #
###########################################

define config.notify = add_notify_message


# Global list of notifications
default notify_messages = []

# Duration the full ATL takes
default notify_duration = 4.0

# Max number we store for reviewing in the history screen
default notify_history_length = 20

init python early:

    import time

    def add_notify_message(msg=None):

        if not msg:
            return

        global notify_messages

        add_time = time.time()

        # Just in case multiple notifications are added really really 
        # fast, this gives them minorly different time values so they 
        # do not steal displayables meant for other notifications
        if notify_messages and notify_messages[-1][1] >= add_time:

            add_time = notify_messages[-1][1] + 0.01

        notify_messages.append((msg, add_time))

        # just keep notify_history_length number of messages
        notify_messages = notify_messages[-notify_history_length:]

        renpy.show_screen("notify_container")
        renpy.restart_interaction()


    def finish_notify(trans, st, at):

        max_start = time.time() - notify_duration

        if not [k for k in notify_messages if k[1] > max_start]:

            # If the notification list is now empty, hide the screen
            renpy.hide_screen("notify_container")
            renpy.restart_interaction()

        return None


style notify_item_frame:

    #background Frame("images/notify_frame_background.png", 10, 10)
    background Frame(AlphaMask("gui/frame.png", "gui/frame-mask.png"))#Frame(im.AlphaMask("gui/frame.png", "gui/frame-mask.png"))#im.AlphaMask("gui/navi-base.jpg", "gui/navi-mask.png") 

    padding (20, 10)#(16, 2, 16, 2)
    minimum (20,20)

    #xanchor 0.5


style notify_item_text:

    xsize None 
    align (0.5,0.5) 

    # just standard font specific stuff
    color "#FFF"
    #outlines [(abs(2), "#000", abs(0), abs(0))]
    # font ""
    size 20


transform notify_appear():

    yzoom 0.0 alpha 0.5

    linear 1.0 yzoom 1.0 alpha 1.0

    pause 2.0

    linear 1.0 yzoom 0.0 alpha 0.0

    function finish_notify


screen notify_item(msg, use_atl=True):

    style_prefix "notify_item"

    frame:

        if use_atl: # ATL not used for history

            at notify_appear

        # else:
        #     xpos 0.5

        text str(msg)


screen notify_container():
    zorder 100
    fixed:

        pos (20, 50)

        vbox:

            xmaximum 300
            spacing 5

            # We index on the time the notification was added as that
            # is unique. Using index helps manage the ATL nicely
            for msg_info index msg_info[1] in notify_messages:

                if msg_info[1] > time.time() - notify_duration:

                    use notify_item(msg_info[0])


screen notify_history():

    viewport:
        area (5, 50, 320, 380)
        # scrollbars "vertical"
        draggable True
        mousewheel True
        yinitial 1.0

        vbox:
            xfill True
            spacing 5

            for msg_info in notify_messages:

                use notify_item(msg_info[0], False)