screen merchantScreen:
    transform:
        pos (1250, 5)
        image "UI/LustCrystal.png"
        text "[lustCrystals]":
            style "nightText"
            pos (100, 20)

    button at topright:
        image "UI/Exit.png"
        action Call("leaveMerchant")

    $i = 0
    for succubus, level in merchantOffers:
        if succubus:
            $abi = pAbilityDB[succubus.playerAbility]
            transform:
                xysize(300,462)
                anchor (.5, .5)
                ypos .4
                xpos .2 * i + .2

                if lustCrystals < level:
                    matrixcolor SaturationMatrix(0.25)

                image "Card/card_char_bg.png"
                image AlphaMask (abi.imagePath, "Card/card_mask.png")
                image "Card/card_char_borders.png"

                fixed:
                    ypos .5
                    image "Card/card_char_title.png"
                    text abi.name:
                        style "cardName"
                        ypos 17
                fixed:
                    xysize (250, 100)
                    xalign .5
                    ypos 310
                    text abi.description:
                        style "cardDescription"
                    
                if abi.uses > 1:
                    fixed:
                        xysize (100, 100)
                        image "Card/orb_red.png"
                        text str(abi.uses):
                            style "cardNumbers"

                if abi.countMax != None:
                    fixed:
                        xpos 1.0
                        xanchor 1.0
                        xysize (100, 100)
                        image "Card/orb_blue.png"
                        text str(abi.countMax):
                            style "cardNumbers"

                hbox:
                    ypos 400
                    xalign .5
                    
                    for die in abi.abilityDice:
                        fixed:
                            xysize(50, 50)
                            image "Dice/C0.png"
                            text "[die.diceText]":
                                style "diceText"

                #if abi.tooltip:
                imagebutton idle "UI/MiniHelp.png":
                    align (1.0, .5)
                    action NullAction()
                    tooltip abi.tooltip
            
            if i > 1:
                textbutton "Buy for [level][i_crystal]\n& [20][i_lust]":
                    text_text_align .5
                    anchor (.5, .5)
                    ypos .65
                    xpos .2 * i + .2
                    if lustCrystals >= level:
                        action Call("buyCard", i, abi, succubus, level, 20)
            else:
                textbutton "Buy for [level][i_crystal]":
                    anchor (.5, .5)
                    ypos .65
                    xpos .2 * i + .2
                    if lustCrystals >= level:
                        action Call("buyCard", i, abi, succubus, level, 0)
        $i += 1
        
    $tooltip = GetTooltip()
    if tooltip:
        frame:
            padding (150, 50)
            xalign 0.5
            yalign 0.5
            text "[tooltip]"