screen dreamDiveScreen:
    text "Succubi : ":
        pos (20, 50)
        style "nightText"
    if battlesRemaining > 0:
        hbox:
            pos (180, 50)
            for i in range(0, battlesRemaining):
                image "UI/SuccubusIcon.png":
                    size (75, 75)
    else:
        image "UI/BossIcon.png":
            pos (180, 20)
            size (150, 150)


    #text "Dive depth : [diveLevel]":
    #    pos(20, 20)
    #    style "nightText"
    text "[currentDream.name]":
        ypos 20
        style "nightText"
        xalign .5
        text_align .5
        size 80
    
    
    hbox:
        xalign 1.0
        button:
            image "UI/Abilities.png"
            action Call("showAbilities")
        if renpy.variant("touch"):
            button:
                image "UI/Save.png"
                action ShowMenu("save")
        if config.developer:
            button:
                image "UI/WakeUp.png"
                action Jump("wakeUp")
    transform:
        pos (1250, 5)
        image "UI/LustCrystal.png"
        text "[lustCrystals]":
            style "nightText"
            pos (100, 20)


    $i = 0
    for evnt in dreamEvents:
        $i += 1
        
        transform:
            xsize 450
            ysize 700
            xanchor 0.5
            xpos i * 0.3 - 0.1
            yanchor 0.5
            ypos 0.6
            fit "contain"
            button:         
                xanchor 0.5
                yanchor 0.5
                image evnt.image
                action Function(evnt.play)
        image evnt.imageType:
            xsize 250
            ysize 250
            xanchor 0.5
            xpos i * 0.3 - 0.1
            yanchor 0.5
            ypos 0.5

    transform:
        xysize(600,100)
        xpos .5
        ypos .1
        xanchor .5
        text "{image=Effects/Arouse.png}  Arousal  {image=Effects/Arouse.png}":
            style "nightText"
            xalign 0.5
            text_align 0.5
        bar:
            style "arousal_bar"
            value playerHP
            range playerBattle.maxHP
            xpos 0.5
            xanchor 0.5
            ypos 80
        text "[playerHP]/[playerBattle.maxHP]":
            style "hpText"
            ypos 88

screen abilityScreen(trading = False):
    button at topright:
        image "UI/Exit.png"
        if trading:
            action Call("cancelTrade")
        else:
            action Call("backToDive")

    draggroup:
        #Current Abilities
        for i in range(0, len(currentAbilities)):
            $abi = currentAbilities[i]

            drag:
                drag_name i
                draggable False
                droppable True
                dropped swapAbility
                child "Card/NoCard.png"
                xpos 460 + 350 * (i % 3) + 250
                ypos 78 + 487 * int(i / 3)

            if abi != None:
                drag:
                    drag_name i
                    draggable True
                    droppable True
                    dropped swapAbility
                    xysize(300,437)
                    xpos 460 + 350 * (i % 3) + 250
                    ypos 78 + 487 * int(i / 3)

                    transform:
                        xysize(300,462)
                        xanchor 0.5
                        yanchor 0.5
                        xpos 0.5
                        ypos 0.5

                        image "Card/card_char_bg.png"
                        image AlphaMask (abi.imagePath, "Card/card_mask.png")
                        image "Card/card_char_borders.png"

                        fixed:
                            ypos .5
                            image "Card/card_char_title.png"
                            text abi.name:
                                style "cardName"
                                ypos 17
                        fixed:
                            xysize (250, 100)
                            xalign .5
                            ypos 310
                            text abi.description:
                                style "cardDescription"
                            
                        if abi.uses > 1:
                            fixed:
                                xysize (100, 100)
                                image "Card/orb_red.png"
                                text str(abi.uses):
                                    style "cardNumbers"

                        hbox:
                            ypos 400
                            xalign .5
                            
                            for die in abi.abilityDice:
                                fixed:
                                    xysize(50, 50)
                                    image "Dice/C0.png"
                                    text "[die.diceText]":
                                        style "diceText"
                                        
                        if abi.tooltip:
                            imagebutton idle "UI/MiniHelp.png":
                                align (1.0, .5)
                                action NullAction()
                                tooltip abi.tooltip

        #Backup Abilities
        for i in range(0, min(9, len(backupAbilities) - 9 * abilityPage)):

            $abi = backupAbilities[9 * abilityPage + i]
            if abi != None:
                drag:
                    drag_name i + 6
                    droppable False
                    draggable True
                    #dragged moveCard

                    xysize(300,437)
                    xpos 80 + (i % 3) * 200
                    ypos 98 + int(i / 3) * 283

                    transform:
                        xysize(300,462)
                        xanchor 0.5
                        yanchor 0.5
                        xpos 0.5
                        ypos 0.5
                        zoom .6

                        image "Card/card_char_bg.png"
                        image AlphaMask (abi.imagePath, "Card/card_mask.png")
                        image "Card/card_char_borders.png"

                        fixed:
                            ypos .5
                            image "Card/card_char_title.png"
                            text abi.name:
                                style "cardName"
                                ypos 17
                        fixed:
                            xysize (250, 100)
                            xalign .5
                            ypos 310
                            text abi.description:
                                style "cardDescription"
                            
                        if abi.uses > 1:
                            fixed:
                                xysize (100, 100)
                                image "Card/orb_red.png"
                                text str(abi.uses):
                                    style "cardNumbers"

                        hbox:
                            ypos 400
                            xalign .5
                            
                            for die in abi.abilityDice:
                                fixed:
                                    xysize(50, 50)
                                    image "Dice/C0.png"
                                    text "[die.diceText]":
                                        style "diceText"
        
        #Dropout
        drag:
            drag_name "dropout"
            draggable False
            droppable True
            dropped removeAbility
            xpos 60
            ypos 78
            image "Card/CardDump.png"
        
        #Trade/Discard
        if trading:
            drag:
                drag_name "remove"
                droppable True
                draggable False
                dropped tradeAbility
                xpos 1.01
                ypos 0.5
                xanchor 1.0
                yanchor 0.5
                image "UI/Exchange.png"
        else:
            drag:
                drag_name "remove"
                droppable True
                draggable False
                dropped deleteAbility
                xpos 1.01
                ypos 0.5
                xanchor 1.0
                yanchor 0.5
                image "UI/Discard.png"

    if len(backupAbilities) > 9 or abilityPage:
        hbox:
            pos (60, 930)
            xsize 620
            button:
                image "UI/Previous.png"
                action Function(previousPage)
                xalign .0
                yalign .5
            text "[abilityPage + 1]":
                font fancyFont
                size 80  
                xalign .5         
                yalign .5
            button:
                image "UI/NextTurn.png"
                action Function(nextPage)
                xalign 1.0
                yalign .5
                
    $tooltip = GetTooltip()
    if tooltip:
        frame:
            padding (150, 50)
            xalign 0.5
            yalign 0.5
            text "[tooltip]"
