image player portrait = "[playerBattle.image]"
transform playerTrans:
    size (450,650)
    xpos 225
    ypos 755
    xanchor 0.5
    yanchor 0.5
    fit "contain"
image opponent portrait = "[opponentBattle.image]"
transform opponentTrans:
        size (450,650)
        xpos 1695
        ypos 325
        xanchor 0.5
        yanchor 0.5
        xzoom -1.0
        fit "contain"

transform diceRoll:
    zoom 1.5
    easeout .3 rotate 360 zoom 1

transform hovering:
    ease 10 ypos -20
    ease 10 ypos 0    
    repeat
    
screen battleScreen:
    #player infos
    vpgrid : #Effects
        cols 5
        spacing 15
        xsize 430
        ysize 630
        xpos 225
        ypos 755
        xanchor 0.5
        yanchor 0.5
        for efct, amnt in pAutoEffects.items():
            transform:
                frame
                size (70, 70)
                imagebutton idle efct.image:
                    action Return(efct.name)
                    tooltip "Each round{}:\n{}".format(i_infinite, efct.description)
                text "[amnt]" style "statusText"
                image "UI/infinite.png":
                    size (30, 30)
                    anchor (1.0, 1.0)
                    pos (1.0, 1.0)
        for efct, amnt in pEffects.items():
            transform:
                xsize 70
                ysize 70
                imagebutton idle efct.image:
                    action Return(efct.name)
                    tooltip efct.description
                text "[amnt]" style "statusText"

    transform:
        xysize(400,100)
        xpos 20
        ypos 320
        bar:
            style "arousal_bar"
            value playerHP
            range playerBattle.maxHP
            ypos 50
        text "[playerHP]/[playerBattle.maxHP]":
            style "hpText"
            ypos 58
        text "[playerBattle.name]":
            style "combatName"

    #Opponent infos
    vpgrid : #Effects
        cols 5
        spacing 15
        xsize 430
        ysize 630
        xpos 1695
        ypos 325
        xanchor 0.5
        yanchor 0.5
        for efct, amnt in oAutoEffects.items():
            transform:
                frame
                size (70, 70)
                imagebutton idle efct.image:
                    action Return(efct.name)
                    tooltip "{} Each round :\n {}".format(i_infinite, efct.description)
                text "[amnt]"
                image "UI/infinite.png":
                    size (30, 30)
                    anchor (1.0, 1.0)
                    pos (1.0, 1.0)
        for efct, amnt in oEffects.items():
            transform:
                xsize 70
                ysize 70
                imagebutton idle efct.image:
                    action Return(efct.name)
                    tooltip efct.description
                text "[amnt]"

    transform:
        xalign 1.0
        xysize(400,100)
        pos (1880, 650)
        bar:
            style "arousal_bar"
            value opponentHP
            range opponentBattle.maxHP
            #xysize(400,50)
            ypos 50
        text "[opponentHP]/[opponentBattle.maxHP]":
            style "hpText"
            ypos 58
        text "[opponentBattle.name]":
            style "combatName"

    #Opponent ability
    fixed:
        pos (1890, 1080)
        anchor (1.0, 1.0)
        
        xsize 420
        ysize 332
        image "Card/card_enemy_bg.png"
        #image "Card/card_enemy_inner_glow.png"
        image "Card/card_enemy_borders.png"

        fixed:
            xysize (420, 165)
            xalign 0.5
            yalign 0.08
            image "Card/card_enemy_title.png"
            text oAbility.name:
                style "oCardName"
                text_align 0.5
                ypos 30
                
        #if oAbility.count:
        #    text oAbility.countStr:
        #        xalign 0.9
        #        yalign 0.08
        #        text_align 0.5
        #        color "#FFFFFF"
        if oAbility.count != None:
            fixed:
                xpos 1.0
                ypos 25
                xanchor 1.0
                xysize (100, 100)
                image "Card/orb_blue.png"
                text str(oAbility.count):
                    style "cardNumbers"

        fixed:
            xysize (300, 150)
            xalign .5
            ypos .6
            yanchor .5
            text oAbility.description:
                style "cardDescription"
                size 24
        vpgrid:
            cols 5
            ypos 260
            xalign .5
            for roll in oppRolls:
                image roll.combatImagePath:
                    if roll.color:
                        matrixcolor TintMatrix(roll.color)

        if oAbility.tooltip:
            imagebutton idle "UI/MiniHelp.png":
                align (1.0, .5)
                action NullAction()
                tooltip oAbility.tooltip

    #Top Screen
    if config.developer:
        button:
            pos (150, 20)
            image "UI/Fairy.png"
            action Call("combatCheat")
    button:
        pos (50, 20)
        image "UI/Help.png"
        action Help()

    text "Luck : [luck]":
        pos (50, 140)
        style "combatText"
    if luck > 0 or config.developer:
        button:
            pos (250, 120)
            image "UI/Luck.png"
            action SetVariable("luckDice", not luckDice)

    text "Turn : [turnCount]":
        pos (50, 240)
        style "combatText"
    button:
        pos (250, 220)
        image "UI/NextTurn.png"
        action Jump("nextTurn")
    


    draggroup:
        #Abilities
        for i in range(0, len(combatAbilities)):
            $abi = combatAbilities[i]
            if abi != None:
                drag:
                    drag_name abi
                    draggable False
                    droppable abi.usable
                    dropped dieOnAbility

                    xysize(300,437)
                    xpos abi.xpos
                    ypos abi.ypos
                    transform:
                        xysize(300,462)
                        xpos abi.xpos
                        ypos abi.ypos

                        if not abi.usable:
                            matrixcolor SaturationMatrix(0.25)

                        image "Card/card_char_bg.png"
                        image AlphaMask (abi.imagePath, "Card/card_mask.png")
                        if len(abi.dice) > 0:
                            image "Card/card_char_inner_glow.png"
                        image "Card/card_char_borders.png"

                        fixed:
                            ypos .5
                            image "Card/card_char_title.png"
                            text abi.name:
                                style "cardName"
                                ypos 17
                        fixed:
                            xysize (250, 100)
                            xalign .5
                            ypos 310
                            text abi.description:
                                style "cardDescription"
                            
                        if abi.maxUses > 1:
                            fixed:
                                xysize (100, 100)
                                image "Card/orb_red.png"
                                text str(abi.uses):
                                    style "cardNumbers"

                        if abi.count != None:
                            fixed:
                                xpos 1.0
                                xanchor 1.0
                                xysize (100, 100)
                                image "Card/orb_blue.png"
                                text str(abi.count):
                                    style "cardNumbers"

                        hbox:
                            ypos 400
                            xalign .5
                            
                            for die in abi.abilityDice:
                                fixed:
                                    xysize(50, 50)
                                    image "Dice/C0.png"
                                    text "[die.diceText]":
                                        style "diceText"

                        if abi.tooltip:
                            imagebutton idle "UI/MiniHelp.png":
                                align (1.0, .5)
                                action NullAction()
                                tooltip abi.tooltip

            else:
                drag:
                    drag_name None
                    draggable False
                    droppable False
                    child "Card/NoCard.png"
                    xpos 460 + 350 * (i % 3)
                    ypos 20 + 580 * int(i / 3)
        

        #Dice
        for roll in playerRolls:
            if roll.usable:
                drag:
                    drag_name roll
                    xpos roll.pxpos
                    ypos roll.pypos
                    draggable roll.draggable
                    droppable False
                    
                    image roll.imagePath at diceRoll:
                        if roll.color:
                            matrixcolor TintMatrix(roll.color)
                        elif dreamDiver:
                            matrixcolor TintMatrix(dreamDiver.color)

        #Luck         
        if luckDice:
            drag:   
                xsize 430
                ysize 630
                xpos 225
                ypos 755
                xanchor 0.5
                yanchor 0.5
                #xpos 480
                #ypos 30
                #xsize 750
                #ysize 440
                draggable False
                droppable True
                frame:
                    background Frame(AlphaMask("gui/frame.png", "gui/frame-mask.png"))    #dynFrame()
                text "Place your dice":
                    style "combatText"
                    vertical True
                    xpos 30
                    ypos 12
                    xanchor .5
                    text_align 0.5
                    size 36
            
            drag:
                drag_name 1
                xpos 140
                ypos 540
                xanchor 0.5
                yanchor 0.5
                droppable True
                dropped dieOnLuck
                image "UI/Luck1.png"
            drag:
                drag_name 2
                xpos 310
                ypos 540
                xanchor 0.5
                yanchor 0.5
                droppable True
                dropped dieOnLuck
                image "UI/Luck2.png"
            drag:
                drag_name 3
                xpos 140
                ypos 730
                xanchor 0.5
                yanchor 0.5
                droppable True
                dropped dieOnLuck
                image "UI/Luck3.png"
            drag:
                drag_name 4
                xpos 310
                ypos 730
                xanchor 0.5
                yanchor 0.5
                droppable True
                dropped dieOnLuck
                image "UI/Luck4.png"
            drag:
                drag_name 5
                xpos 140
                ypos 920
                xanchor 0.5
                yanchor 0.5
                droppable True
                dropped dieOnLuck
                image "UI/Luck5.png"
            drag:
                drag_name 6
                xpos 310
                ypos 920
                xanchor 0.5
                yanchor 0.5
                droppable True
                dropped dieOnLuck
                image "UI/Luck6.png"
    
    $tooltip = GetTooltip()
    if tooltip:
        frame:
            padding (150, 50)
            xalign 0.5
            yalign 0.5
            text "[tooltip]"

screen edgeWinCard:
    transform:
        xysize(300,462)
        xanchor 0.5
        yanchor 0.5
        xpos 0.5
        ypos 0.5

        image "Card/card_char_bg.png"
        image AlphaMask (abi.imagePath, "Card/card_mask.png")
        image "Card/card_char_borders.png"

        fixed:
            ypos .5
            image "Card/card_char_title.png"
            text abi.name:
                style "cardName"
                ypos 17
        fixed:
            xysize (250, 100)
            xalign .5
            ypos 310
            text abi.description:
                style "cardDescription"
            
        if abi.uses > 1:
            fixed:
                xysize (100, 100)
                image "Card/orb_red.png"
                text str(abi.uses):
                    style "cardNumbers"

        if abi.countMax != None:
            fixed:
                xpos 1.0
                xanchor 1.0
                xysize (100, 100)
                image "Card/orb_blue.png"
                text str(abi.countMax):
                    style "cardNumbers"
                    
        if abi.tooltip:
            imagebutton idle "UI/MiniHelp.png":
                align (1.0, .5)
                action NullAction()
                tooltip abi.tooltip

        hbox:
            ypos 400
            xalign .5
            
            for die in abi.abilityDice:
                fixed:
                    xysize(50, 50)
                    image "Dice/C0.png"
                    text "[die.diceText]":
                        style "diceText"