init 9 python:
    location("Coffee", 1150, 300, "locCoffee", "B57204", "Hot Brewnette")
    
label locCoffee:
    menu:
        "Take a break at the coffee shop? (Friendship increase & Dice ability)"
        "Yes [i_time]":
            pass
        "No":
            jump dayTown
    menu:
        "Do you invite someone?"
        "Evelyn":
            show evelyn
            $eveC.increaseMod(0, 5)
            eve "Okay, Mom is covering my shift. But we shouldn't take too long."
        "Melody" if story >= 12:
            show melody
            $melC.increaseMod(0, 5)
            mel "Hey, [pName]! Thanks for inviting me."
        "[hName]" if story >= 23:
            show hilda
            $hilC.increaseMod(0, 5)
            hil "Good idea, some oxygen and coffee would help me stay focused later."
        "[dName]" if story >= 31:
            show debora
            $debC.increaseMod(0, 5)
            deb "Oh, I like this place, I bought it a few years back. Thank you for your patronage."
        "Alone":
            "You take a seat on the terrace and browse the menu."

    menu:
        "What do you want?"
        "Coffee (Die +1)":
            $dayBonuses.addBonusAbility("Hot Stuff")
        "Soda (Die -1)":
            $dayBonuses.addBonusAbility("Sugar Low")
        "Milkshake (Flip Die)":
            $dayBonuses.addBonusAbility("Milky Shake")
        "Fruit Juice (Add Dice)":
            $dayBonuses.addBonusAbility("Fruity Mix")
        "Tea (Split Dice)":
            $dayBonuses.addBonusAbility("Tea")
    
    "That was relaxing."
    jump advanceTime

init 9 python:
    class abiCoffee(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Hot Stuff", "Cards/CCoffee.png", "[i_dice]+1", [abilityDie(5, "-")], 1)

        def playAbility(self, dice, card):
            rerollDie(dice[0], dice[0].value + 1, False)
    abiCoffee()
    class abiSoda(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Sugar Low", "Cards/CCoffee.png", "[i_dice]-1", [abilityDie(2, "+")], 1)

        def playAbility(self, dice, card):
            rerollDie(dice[0], dice[0].value - 1, False)
    abiSoda()
    class abiMilkshake(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Milky Shake", "Cards/CCoffee.png", "[i_dice] Flipped", [abilityDie()], 1)

        def playAbility(self, dice, card):
            rerollDie(dice[0], 7 - dice[0].value, False)
    abiMilkshake()
    class abiJuice(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Fruity Mix", "Cards/CCoffee.png", "[i_dice]+[i_dice]", [abilityDie(), abilityDie()], 1)

        def playAbility(self, dice, card):
            tmp = dice[0].value + dice[1].value
            if tmp > 6:
                rerollDie(dice[0], 6, False)
                rerollDie(dice[0], tmp - 6, False)
            else:
                rerollDie(dice[0], tmp, False)
    abiJuice()
    class abiTea(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Tea", "Cards/CCoffee.png", "[i_dice] Split", [abilityDie(2, "+")], 1)

        def playAbility(self, dice, card):
            tmp = renpy.random.randint(1,dice[0].value - 1)
            rollNewDie(tmp, playSound = False)
            rerollDie(dice[0], dice[0].value - tmp, False)            
    abiTea()