init 10 python:
    #Adventurers : https://www.hentai-foundry.com/pictures/user/Samasan/410698/The-Sorceress-and-The-Fighter-grind-for-EXP-and-CUM


    #Cow
    def opponentFocusCount():
        global tmp
        if oEffects.has_key(focusEff):
            tmp = oEffects[focusEff]
        else:
            tmp = 0

    class asBullRush(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Bull rush",
                description = "([i_dmax] + [i_focus]) [i_arouse]",
                rolls = 2,
                effects = ["Focus"])

        @property
        def description(self):
            return "Mess with the cow...\n(" + diceToText() + " + [i_focus]) [i_arouse]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice) + tmp)
            return            
    asBullRush()
    
    class asSelfMilking(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Self milking",
                description = "[i_d1][i_d2][i_calm]\n[i_dmax][i_focus]",
                rolls = 4,
                diceGroups = [0, 0, 1],
                effects = ["Calm", "Focus"])

        @property
        def description(self):
            return "Fresh from the teat\n" + diceToText(0, 2) + "[i_calm]\n" + diceToText(2, -1, color = 1) + "[i_focus]"

        def playAbility(self, dice):
            if len(dice) == 1:
                addEffectToOpponent("Calm", dice.pop(0).value)
            elif len(dice) > 1:
                addEffectToOpponent("Calm", dice.pop(0).value + dice.pop(0).value)
                addEffectToOpponent("Focus", self.diceValue(dice))
            return            
    asSelfMilking()
        
    class abiBullRush(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Bull rush", 
                "Cards/CCow.webp", 
                "[i_focus] [i_arouse]", 
                [abilityDie(type = "Even")],
                1,
                effects = ["Focus"])

        def playAbility(self, dice, card):
            if pEffects.has_key(focusEff):
                hpToOpponent(pEffects[focusEff])
    abiBullRush()

    opponentSuccubus("Cow",
        "Cow",
        "Succubi/Cow.webp",
        52,
        ["Bull rush", "Self milking"],
        "Bull rush",
        onStart = opponentFocusCount)
        
    #Centaur
    class asWindup(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Windup",
                description = "[i_dice][i_vigor]",
                rolls = 1,
                effects = ["Vigor"])

        @property
        def description(self):
            return "She's getting ready for it\n" + diceToText() + "[i_vigor]"

        def playAbility(self, dice):
            addEffectToOpponent("Vigor", self.diceValue(dice))
            return 
    asWindup()

    class asPound(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Pound",
                description = "[i_dice][i_arouse]",
                rolls = 1)

        @property
        def description(self):
            return "She's quite massive\n" + diceToText() + "[i_arouse]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))
            return  
    asPound() 

    class abiWindup(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Windup", 
                "Cards/CCentaur.webp", 
                "1 [i_vigor]\n1 [i_zeal]", 
                [abilityDie()],
                1,
                effects = ["Vigor", "Zeal"])

        def playAbility(self, dice, card):
            addEffectToPlayer("Vigor", 1)
            addEffectToPlayer("Zeal", 1)
    abiWindup()

    opponentSuccubus("Centaur",
        "Centaur",
        "Succubi/Centaur.webp",
        49,
        ["Windup", "Pound"],
        "Windup")
        
    #Harpy
    #Smitting song
    class asSmittingSong(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Smitting song",
                description = "[i_dmax][i_arouse]\n10[i_smitten]",
                rolls = 2,
                effects = ["Smitten"])

        @property
        def description(self):
            return "La♩la♪la♫la♬\n" + diceToText() + "[i_arouse]\n10[i_smitten]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))
            addEffectToPlayer("Smitten", 10)
            return            
    asSmittingSong()

    class abiCatchyTune(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Catchy tune", 
                "Cards/CHarpy.webp", 
                "All dice +1", 
                [abilityDie()],
                3)

        def playAbility(self, dice, card):
            for roll in playerRolls:
                if roll.value < 6:
                    roll.value += 1
    abiCatchyTune()

    opponentSuccubus("Harpy",
        "Harpy",
        "Succubi/Harpy.webp",
        38,
        ["Smitting song"],
        "Catchy tune")
        
    #Bunny
    class asRabbitRun(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Rabbit run",
                description = "[i_dmax][i_arouse]\nIf she's above 35[i_arouse], she'll flee...",
                rolls = 2)

        @property
        def description(self):
            return "She's playing hard to get\n" + diceToText() + "[i_arouse]\nIf she's above 35[i_arouse], she'll flee..."

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))   
            if opponentHP > 35:
                unplayedEvents.append(succubusDreamEvent("Bunny"))
                renpy.jump("bunnyRuns")
            return            
    asRabbitRun()

    class abiMultiply(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Multiply", 
                "Cards/CBunny.webp", 
                "Roll 0 to 4 new dice", 
                [abilityDie(), abilityDie()],
                2)

        def playAbility(self, dice, card):
            for roll in range(0, renpy.random.randint(0, 4)):
                rollNewDie()
    abiMultiply()
    
    opponentSuccubus("Bunny",
        "Bunny",
        "Succubi/Bunny.webp",
        48,
        ["Rabbit run"],
        "Multiply")
        
    #Alraune
    class asEnflower(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Enflower",
                description = "Even [i_dice] [i_phero]\nOdd : [i_dice] [i_aphro]",
                rolls = 3,
                effects = ["Pheromones", "Aphrodisiac"])

        @property
        def description(self):
            return "That smell is captivating\n" + evenAndOdd(i_phero, i_aphro, diceColors[0], diceColors[1])

        def playAbility(self, dice):
            for die in dice:
                if die.isEven:
                    addEffectToOpponent("Pheromones", die.value)
                else:
                    addEffectToPlayer("Aphrodisiac", die.value)
            return         
    asEnflower()
        
    class abiEnflower(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Enflower", 
                "Cards/CAlraune.webp", 
                "Even [i_dice] [i_phero]\nOdd : [i_dice] [i_aphro]", 
                [abilityDie()],
                1,
                effects = ["Pheromones", "Aphrodisiac"])

        def playAbility(self, dice, card):
            for die in dice:
                if die.isEven:
                    addEffectToPlayer("Pheromones", die.value)
                else:
                    addEffectToOpponent("Aphrodisiac", die.value)
            return         
    abiEnflower()   
    
    opponentSuccubus("Alraune",
        "Alraune",
        "Succubi/Alraune.webp",
        44,
        ["Enflower"],
        "Enflower")
        
    #Cat
    class asOverwhelm(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Overwhelm",
                description = "[i_dice][i_arouse] as separate attacks",
                rolls = 5)

        @property
        def description(self):
            global oppRolls
            txt = "Nya :3\n"

            for roll in range(0, len(oppRolls)):
                txt += "{u}" + str(oppRolls[roll].value) + "{/u} / "

            return txt[:-2] + "[i_arouse] as separate attacks"

        def playAbility(self, dice):
            for die in dice:
                hpToPlayer(die.value)
            return            
    asOverwhelm()
        
    class abiOverwhelm(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Overwhelm", 
                "Cards/CCat.webp", 
                "[i_dice] * 1 [i_arouse]", 
                [abilityDie()],
                1)

        def playAbility(self, dice, card):
            for i in range(0, self.diceValue(dice)):
                hpToOpponent(1)
            return         
    abiOverwhelm()   

    opponentSuccubus("Cat",
        "Cat",
        "Succubi/Cat.webp",
        42,
        ["Overwhelm"],
        "Overwhelm")
        
    #Dog
    class asIntenseLicking(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Intense licking",
                description = "[i_d1][i_sticky]\n[i_dmax] [i_arouse]",
                rolls = 2,
                diceGroups = [1, 0],
                effects = ["Sticky"])

        @property
        def description(self):
            return "She's happy to see you\n" + diceToText(0, 1, color = 1) + "[i_sticky]\n" + diceToText(1, -1) + " [i_arouse]"

        def playAbility(self, dice):
            if len(dice) > 0:
                addEffectToPlayer("Sticky", dice.pop(0).value)
                hpToPlayer(self.diceValue(dice))
            return
    asIntenseLicking()

    class abiGentleLicking(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Gentle licking", 
                "Cards/CDog.webp", 
                "1 [i_sticky]", 
                [abilityDie(value = 1)],
                3,
                effects = ["Sticky"])

        def playAbility(self, dice, card):
            addEffectToOpponent("Sticky", 1)
            return         
    abiGentleLicking()   
    
    opponentSuccubus("Dog",
        "Dog",
        "Succubi/Dog.webp",
        39,
        ["Intense licking"],
        "Gentle licking")
        
    #Hippy
    #Pheromones & Insensitive    
    class asHerbalMedicine(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Herbal medicine",
                description = "[i_dice][i_phero]\n1 [i_infinite][i_focus]",
                rolls = 5,
                effects = ["Pheromones", "Focus"])

        @property
        def description(self):
            return "Puff Puff\n" + diceToText() + "[i_phero]\n1 [i_infinite][i_focus]"

        def playAbility(self, dice):
            addEffectToOpponent("Pheromones", self.diceValue(dice))
            addEffectToOpponent("Focus", 1, True)
            return            
    asHerbalMedicine()

    class abiDubiousRemedy(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Dubious remedy", 
                "Cards/CHippy.webp", 
                "[i_dice] [i_calm]\n[i_dice]/2 [i_aphro] to self", 
                [abilityDie(type = "Even")],
                3,
                effects = ["Calm", "Aphrodisiac"])

        def playAbility(self, dice, card):
            val = self.diceValue(dice)
            addEffectToPlayer("Calm", val)
            addEffectToPlayer("Aphrodisiac", val/2)
            return         
    abiDubiousRemedy()   

    opponentSuccubus("Hippy",
        "Hippy",
        "Succubi/Hippy.webp",
        33,
        ["Herbal medicine"],
        "Dubious remedy")
       

    #BOSS : Wolf
    #Relentless attacks gives Exhaution & Big attack
    class asRelentlessBrawl(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Relentless brawl",
                description = "[i_dmax] [i_arouse]\n1 [i_exhaustion]",
                rolls = 2,
                effects = ["Exhaustion"])

        @property
        def description(self):
            return "Completely overwhelmed\n" + diceToText() + "[i_arouse]\n1 [i_exhaustion]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))
            addEffectToPlayer("Exhaustion", 1)
            return
    asRelentlessBrawl()
    
    class asPinDown(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Pin down",
                description = "[i_dmax][i_arouse]",
                rolls = 5)

        @property
        def description(self):
            return "A rough breeding\n" + diceToText() + "[i_arouse]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))
            return
    asPinDown()

    class abiAllIn(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "All in", 
                "Cards/CWolf.webp", 
                "[i_dice] + 5 [i_arouse]", 
                [abilityDie(), abilityDie(), abilityDie(), abilityDie()],
                1)

        def playAbility(self, dice, card):
            hpToOpponent(self.diceValue(dice) + 5)
            return         
    abiAllIn()   

    opponentSuccubus("Wolf",
        "Wolf",
        "Succubi/Wolf.webp",
        70,
        ["Relentless brawl", "Pin down"],
        "All in")


    #Dream
    #TODO : change background
    dream("Park",
        5,
        "Wolf",
        ["Cow", "Centaur", "Harpy", "Bunny", "Alraune", "Cat", "Dog", "Hippy"],
        [],
        "park")

    addDreamLink("Town", "Park", lambda: story > 22)

define cow = Character("Cow Succubus", callback = name_callback, cb_name = "cow")
image cowS:
    "cow"
    function SpriteFocus("cow")
define cen = Character("Centaur Succubus", callback = name_callback, cb_name = "centaur")
image centaurS:
    "centaur"
    function SpriteFocus("centaur")
define har = Character("Harpy Succubus", callback = name_callback, cb_name = "harpy")
image harpyS:
    "harpy"
    function SpriteFocus("harpy")
define bun = Character("Bunny Succubus", callback = name_callback, cb_name = "bunny")
image bunnyS:
    "bunny"
    function SpriteFocus("bunny")
define alr = Character("Alraune Succubus", callback = name_callback, cb_name = "alraune")
image alrauneS:
    "alraune"
    function SpriteFocus("alraune")
define cat = Character("Cat Succubus", callback = name_callback, cb_name = "cat")
image catS:
    "cat"
    function SpriteFocus("cat")
define dog = Character("Dog Succubus", callback = name_callback, cb_name = "dog")
image dogS:
    "dog"
    function SpriteFocus("dog")
define hip = Character("Hippy Succubus", callback = name_callback, cb_name = "hippy")
image hippyS:
    "hippy"
    function SpriteFocus("hippy")
define wol = Character("Wolf Succubus", callback = name_callback, cb_name = "wolf")
image wolfS:
    "wolf"
    function SpriteFocus("wolf")

label bunnyRuns:
    hide opponent portrait with moveoutright
    "The bunnygirl flees..."
    call nextDreamStage from _call_nextDreamStage_4