define melPromise = False
define melNTR = False

define mel = Character("Melody", color="#F7F2A0", callback = name_callback, cb_name = "melody")
layeredimage melody:
    at sprite_highlight('melody')

    group main:
        attribute base default:
            "melody b"
        attribute naked:
            "melody n"
define pix = Character("Pixie", color="#F7F2A0", callback = name_callback, cb_name = "pixie")
image pixieS:
    "pixie"
    function SpriteFocus("pixie")
define grl = Character("Girl", color="#000000")
default melC = playChara("Melody")
define pCharaDB["Melody"] = playableChara("Melody", mel, "melody", "Pixie", 700, 200, "#CDD760", "Audio/Music/NoGoodLayabout.mp3",
[
    [None, None, None, None, None, None, "Meet Mel during the evening", None, None, None],
    ["She's a good Friend, but... (Friendship 4)", None, "Now's not the time... (Continue the story)", None, None],
    ["Does she even Love you? (Love 1)", None, None, None, "Evening only"]
])

init 10 python:
    class abiPixiePlay(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Pixie Play", 
                "Cards/CPixie.webp", 
                "[i_dice][i_arouse]\nHalf of [i_tease] => [i_aphro]", 
                [abilityDie(4, "-")],
                3, effects = ["Tease", "Aphrodisiac"])

        def playAbility(self, dice, card):
            hpToOpponent(self.diceValue(dice))
            if pEffects.has_key(teaseEff):
                tease = int(pEffects[teaseEff] / 2 + .5)
                addEffectToOpponent("Aphrodisiac", tease)
                addEffectToPlayer("Tease", -tease)
    abiPixiePlay()
    
    class abiFairyFlutter(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Fairy Flutter", 
                "Cards/CPixie.webp",
                "[i_dice][i_focus]\nHalf of [i_tease] => [i_calm]",
                [abilityDie(type = "Odd")],
                2, effects = ["Tease", "Calm"])

        def playAbility(self, dice, card):
            addEffectToPlayer("Focus", self.diceValue(dice))
            if pEffects.has_key(teaseEff):
                tease = int(pEffects[teaseEff] / 2 + .5)
                addEffectToPlayer("Calm", tease)
                addEffectToPlayer("Tease", -tease)
    abiFairyFlutter()
    
    class abiChaoticMagic(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Chaotic Magic", 
                "Cards/CPixie.webp", 
                "[i_dice]/2[i_tease]\nReroll ALL [i_dice] and gives you a [i_1]\n[i_6] : +1 use", 
                [abilityDie()],
                1, effects = ["Tease"])

        def playAbility(self, dice, card):
            addEffectToPlayer("Tease", self.diceValue(dice)/2)
            reroll = [d for d in playerRolls if d.usable]
            for die in reroll:
                if die != dice[0]:
                    rerollDie(die, playSound = False)
            if dice[0].value == 6:
                card.uses = 2
            rerollDie(dice[0], 1, False)

            reroll = list(oppRolls)
            for die in reroll:
                rerollOpponentDie(die)
            
            playDiceRoll()
    abiChaoticMagic()

    playerSuccubus("Pixie", "Melody",
        "Succubi/Pixie.webp", 
        18, 
        3, 
        ["Pixie Play", "Fairy Flutter", "Chaotic Magic"])
    
    class asPixiePlay(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Pixie Play",
                description = "All in good fun\n[i_dice][i_arouse]\n1-3[i_smitten].",
                rolls = 2,
                effects = ["Smitten"])

        @property
        def description(self):
            return "All in good fun\n" + diceToText() + "[i_arouse]\n1-3[i_smitten]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))
            addEffectToPlayer("Smitten", renpy.random.randint(1,3))
    asPixiePlay()

    opponentSuccubus("Pixie",
        "Pixie",
        "Succubi/Pixie.webp",
        18,
        ["Pixie Play"],
        None)

    newEvent("MelodyGreeting", "Melody_Greeting")
    newEvent("MelodySpendTime", "Melody_SpendTime")

    newEvent("MelodyIntro", "Inn_End", condition = "story < 12")
    
    newEvent("MelodyFriendship1", "Melody_Friendship_0")
    newEvent("MelodyFriendship2", "Melody_Friendship_1")
    newEvent("MelodyFriendship3", "Melody_Friendship_2")
    newEvent("MelodyFriendship4", "Melody_Friendship_3")
    newEvent("MelodyFriendship5", "Melody_Friendship_4")
    newEvent("MelodyFriendship6", "Melody_Friendship_5")
    newEvent("MelodyFriendship7", "Melody_Friendship_6", condition = "dayTime == 2")
    newEvent("MelodyFriendship8", "Melody_Friendship_7")
    newEvent("MelodyFriendship9", "Melody_Friendship_8")
    newEvent("MelodyFriendship10", "Melody_Friendship_9")

    newEvent("MelodyLove1", "Melody_Love_0", condition = "melC and melC.friendship >= 4")
    newEvent("MelodyLove2", "Melody_Love_1")
    newEvent("MelodyLove3", "Melody_Love_2", condition = "story < 20 or story >= 23")
    newEvent("MelodyLove4", "Melody_Love_3")
    newEvent("MelodyLove5", "Melody_Love_4")
    
    newEvent("MelodyLust1", "Melody_Lust_0", condition = "melC and melC.love >= 1")
    newEvent("MelodyLust2", "Melody_Lust_1")
    newEvent("MelodyLust3", "Melody_Lust_2")
    newEvent("MelodyLust4", "Melody_Lust_3")
    newEvent("MelodyLust5", "Melody_Lust_4", condition = "dayTime == 2")
    
    newEvent("MelodyLust5Morning", "Morning", repeat = False, condition = "melNTR")