define deb = Character("Lady Azure", color="#0069DB", callback = name_callback, cb_name = "debora")
layeredimage debora:
    at sprite_highlight('debora')

    group main:
        attribute base default:
            "debora b"
        attribute naked:
            "debora n"
        attribute dragon:
            "debora d"

define pCharaDB["Debora"] = playableChara("Debora", deb, "debora", "Dragon", 1650, 260, "#0069DB", "Audio/Music/Opportunity Walks.mp3",
[
    [None, None, None, None, None, None, None, None, None, None],
    ["Become closer (Friendship 2)", None, None, "Needs Lucia", "In the evening after you got to know her (Friendship 5), needs Lucia"],
    ["Become her lover (Love 1)", "Needs Lucia", None, "Get to know her (Friendship 5)", "Maybe wait a couple of days..."]
])
default debC = playChara("Debora")
default dName = "Lady Azure"

define dra = Character("Dragon", color="#0069DB", callback = name_callback, cb_name = "dragon")
image dragonS:
    "dragon"
    function SpriteFocus("dragon")

define luc = Character("Maid", color="#959ef1", callback = name_callback, cb_name = "lucia")
layeredimage lucia:
    at sprite_highlight('lucia')

    group main:
        attribute base default:
            "lucia b"
        attribute naked:
            "lucia n"

default luciaPresent = True
default deb5LustIntro = False

init 10 python:
    #Claw : 1 Ar + [] Foc, 3-, 3*
    class abiClaw(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Claw", "Cards/CDragon.webp", "You : [i_dice][i_focus]\nOpponent : 1[i_arouse]", [abilityDie(3, "-")], 3, effects = ["Focus"])

        def playAbility(self, dice, card):
            addEffectToPlayer("Focus", self.diceValue(dice))
            for i in range(0, len(dice)):
                hpToOpponent(1)
    abiClaw()

    #Flame Breath : X Ar, On 6 : + 4 Sen
    class abiFlameBreath(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Flame Breath", "Cards/CDragon.webp", "[i_dice][i_arouse]\nOn 6 : 4[i_sensitive]", [abilityDie()], effects = ["Sensitive"])

        def playAbility(self, dice, card):
            val = dice[0].value
            hpToOpponent(val)
            renpy.notify(val)
            if val == 6:
                addEffectToOpponent("Sensitive", 4)
    abiFlameBreath()

    #Bulk Up : Fuse 2 dice, 3*
    class abiBulkUp(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Bulk Up", "Cards/CDragon.webp", "Fuse two [i_dice]", [abilityDie(), abilityDie()])

        def playAbility(self, dice, card):
            val = self.diceValue(dice)
            if val <= 6:
                rerollDie(dice[0], val)
            else:
                rerollDie(dice[0], 6)
                rerollDie(dice[1], val - 6)
    abiBulkUp()

    playerSuccubus("Dragon", "Debora",
        "Succubi/Dragon.webp", 
        25, 
        3, 
        ["Claw", "Flame Breath", "Bulk Up"])

    #Claw : 1 Ar / Die + [] Foc
    class asClaw(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Claw",
                description = "I'll slice you!\n[i_dice][i_focus]\n1[i_arouse] per die",
                rolls = 3,
                effects = ["Focus"])

        @property
        def description(self):
            return "I'll slice you!\n" + diceToText() + "[i_dice][i_focus]\n" + str(len(oppRolls)) + "[i_arouse] (1 per die)"

        def playAbility(self, dice):
            addEffectToOpponent("Focus", self.diceValue(dice))
            for i in range(0, len(dice)):
                hpToPlayer(1)
    asClaw()

    #Brun Up : [1] Sen & Self Ar, [] Ar 
    class asBrunUp(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Brun Up",
                description = "Burn!\n[i_d1][i_sensitive] & self [i_arouse]\n[i_dmax][i_arouse]",
                rolls = 2,
                diceGroups = [1, 0],
                effects = ["Sensitive"])
                
        @property
        def description(self):
            return "Burn!\n" + diceToText(0, 1, color = 1) + "[i_sensitive] & self [i_arouse]\n" + diceToText(1, -1) + "[i_arouse]"

        def playAbility(self, dice):
            val = dice.pop().value
            addEffectToOpponent("Sensitive", val)
            hpToOpponent(val)
            hpToPlayer(self.diceValue(dice))
    asBrunUp()

    #Enrage : 1 IVig per 10 missing HP
    class asEnrage(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Enrage",
                description = "Fuck you!",
                rolls = 1,
                effects = ["Vigor"])

        @property
        def description(self):
            return "Fuck you!\n" + diceToText() + "[i_arouse] to you and her\nSet 1[i_infinite][i_vigor] per 10 missing health"

        def playAbility(self, dice):
            val = self.diceValue(dice)
            hpToPlayer(val)
            hpToOpponent(val)
            val = int(opponentHP / 10)
            addEffectToOpponent("Vigor", -100, True)
            addEffectToOpponent("Vigor", val, True)
    asEnrage()

    opponentSuccubus("Dragon",
        "Dragon",
        "Succubi/Dragon.webp",
        100,
        ["Claw", "Brun Up", "Enrage"],
        None)


        
    newEvent("DeboraIntro", "Park_End", condition = "story < 30 and otherStory == 3")
    
    newEvent("DeboraGreeting", "Debora_Greeting")
    newEvent("DeboraSpendTime", "Debora_SpendTime")

    newEvent("DeboraFriendship1", "Debora_Friendship_0")
    newEvent("DeboraFriendship2", "Debora_Friendship_1")
    newEvent("DeboraFriendship3", "Debora_Friendship_2")
    newEvent("DeboraFriendship4", "Debora_Friendship_3")
    newEvent("DeboraFriendship5", "Debora_Friendship_4")
    newEvent("DeboraFriendship6", "Debora_Friendship_5")
    newEvent("DeboraFriendship7", "Debora_Friendship_6")
    newEvent("DeboraFriendship8", "Debora_Friendship_7")
    newEvent("DeboraFriendship9", "Debora_Friendship_8")
    newEvent("DeboraFriendship10", "Debora_Friendship_9")
    
    newEvent("DeboraLove1", "Debora_Love_0", condition = "debC and debC.friendship >= 2")
    newEvent("DeboraLove2", "Debora_Love_1")
    newEvent("DeboraLove3", "Debora_Love_2")
    newEvent("DeboraLove4", "Debora_Love_3", condition = "luciaPresent")
    newEvent("DeboraLove5", "Debora_Love_4", condition = "luciaPresent and dayTime == 2 and debC.friendship >= 5")

    newEvent("DeboraLust1", "Debora_Lust_0", condition = "debC and debC.love >= 1")
    newEvent("DeboraLust2", "Debora_Lust_1", condition = "luciaPresent")
    newEvent("DeboraLust3", "Debora_Lust_2")
    newEvent("DeboraLust4", "Debora_Lust_3", condition = "debC.friendship >= 5")
    newEvent("DeboraLust5", "Debora_Lust_4", condition = "deb5LustIntro")

    newEvent("DeboraLust5Intro", "Night", condition = "debC and debC.lust >= 4 and debC.canProgress(2)")