#Labels needed for each character (*** = character name):
# ***Greeting : seen before interaction menu on town map. Should be single line, but can have exceptions
# ***SpendTime : seen when selecting "Spend Time"
# ***FriendshipX, ***LoveX and ***LustX : relationship events, where X is the level of the relationship (1-10)

init -1 python:    
    class playableChara():
        def __init__(self, name, character, image, succubus, xpos, ypos, color, music = None, notes = []):
            self.name = name
            self.character = character
            self.image = image
            self.succubus = succubus
            self.xpos = xpos
            self.ypos = ypos
            self.color = color
            self.music = music
            self.notes = notes

    class playChara():
        def __init__(self, name):
            self.name = name
            self.screenName = name

            self.friendship = 0
            self.frPoints = 0
            self.frMod = 1
            self.love = 0
            self.lvPoints = 0
            self.lvMod = 1
            self.lust = 0
            self.lsPoints = 0
            self.lsMod = 1

        @property
        def character(self):
            global pCharaDB
            return pCharaDB[self.name].character

        @property
        def image(self):
            global pCharaDB
            return pCharaDB[self.name].image
            
        @property
        def succubus(self):
            global pCharaDB
            return pCharaDB[self.name].succubus
            
        @property
        def xpos(self):
            global pCharaDB
            return pCharaDB[self.name].xpos
            
        @property
        def ypos(self):
            global pCharaDB
            return pCharaDB[self.name].ypos
            
        @property
        def color(self):
            global pCharaDB
            return pCharaDB[self.name].color
                
        @property
        def lower(self):
            return self.name.lower()
        
        @property
        def frBonus(self):
            return int(self.frMod * 100)
            
        @property
        def lvBonus(self):
            return int(self.lvMod * 100)
            
        @property
        def lsBonus(self):
            return int(self.lsMod * 100)
        
        @property
        def frPointsInt(self):
            return int(self.frPoints)
            
        @property
        def lvPointsInt(self):
            return int(self.lvPoints)
            
        @property
        def lsPointsInt(self):
            return int(self.lsPoints)
        
        @property
        def frNext(self):
            return int((self.friendship + 1) * 50)
            
        @property
        def lvNext(self):
            return int((self.love + 1) * 100)
            
        @property
        def lsNext(self):
            return int((self.lust + 1) * 100)
            
        @property
        def music(self):
            return pCharaDB[self.name].music
            
        @property
        def notes(self):
            return pCharaDB[self.name].notes


        def canProgress(self, relation):
            if relation == 0:
                return self.friendship < 10 and self.frPoints >= self.frNext
            elif relation == 1:
                return self.love >= 0 and self.love < 5 and self.lvPoints >= self.lvNext
            else:
                return self.lust >= 0 and self.lust < 5 and self.lsPoints >= self.lsNext
        
        def addPoints(self, relation, amount):
            if relation == 0:
                if self.frMod > 0:
                    amount *= self.frMod
                    amount = int(amount)
                    self.frPoints += amount 
                    renpy.notify("{} : {}{}".format(self.name, amount, i_friendship))
            elif relation == 1:
                if self.lvMod > 0:
                    amount *= self.lvMod
                    amount = int(amount)
                    self.lvPoints += amount 
                    renpy.notify("{} : {}{}".format(self.name, amount, i_love))
            else:
                if self.lsMod > 0:
                    amount *= self.lsMod
                    amount = int(amount)
                    self.lsPoints += amount 
                    renpy.notify("{} : {}{}".format(self.name, amount, i_lust))

        def increaseMod(self, relation, amount, display = True):
            sign = "+" if amount >= 0 else ""
            if relation == 0:
                self.frMod += amount / 100.0
                if display:
                    renpy.notify("{}\n{} {}{}% \n(total : {}%)".format(self.name, i_friendship, sign, amount, int(self.frMod * 100)))
            elif relation == 1:
                self.lvMod += amount / 100.0
                if display:
                    renpy.notify("{}\n{} {}{}% \n(total : {}%)".format(self.name, i_love, sign, amount, int(self.lvMod * 100)))
            else:
                self.lsMod += amount / 100.0
                if display:
                    renpy.notify("{}\n{} {}{}% \n(total : {}%)".format(self.name, i_lust, sign, amount, int(self.lsMod * 100)))
        
        def increaseRelation(self, relation):
            if relation == 0:
                self.friendship += 1
                self.frPoints -= self.friendship * 50.0
                txt = "Friendship => {} {}".format(self.friendship, i_friendship)
                if self.friendship == 1 or self.friendship == 4 or self.friendship == 7:
                    txt += "\nAbility slots +1"
                if self.friendship % 2 == 0:
                    txt += "\nLuck +1"
                renpy.notify(txt)
                key = self.name + "_friendship"
                val = self.friendship
            elif relation == 1:
                self.love += 1
                self.lvPoints -= self.love * 100.0
                txt = "Love => {} {}".format(self.love, i_love)
                txt += "\nMax Arousal increased by 20%"
                txt += "\nLuck +1"
                renpy.notify(txt)
                key = self.name + "_love"
                val = self.love
            else:
                self.lust += 1
                self.lsPoints -= self.lust * 100.0
                txt = "Lust => {} {}".format(self.lust, i_lust)
                if self.lust == 1 or self.lust == 3 or self.lust == 5:
                    txt += "\nDice +1"
                txt += "\nLuck +1"
                renpy.notify(txt)
                key = self.name + "_lust"
                val = self.lust
            
            if not persistent.relations.has_key(key) or persistent.relations[key] < val:
                persistent.relations[key] = val

        
        def playGreeting(self):
            event = getEvent(self.name + "_Greeting")
            if event:
                renpy.call(event)
            else:
                renpy.call("defaultGreeting")
        
        def getImportantTalk(self):
            if self.canProgress(2):
                event = self.getNextEvent(2)
                if event: 
                    return (event, i_lust)

            if self.canProgress(0):
                event = self.getNextEvent(0)
                if event: 
                    return (event, i_friendship)
                
            if self.canProgress(1):
                event = self.getNextEvent(1)
                if event: 
                    return (event, i_love)

            evnt = getEvent(self.name + "_Talk")
            if evnt:
                return (evnt, i_smallHeart)
            else:
                return None
                
        def playSpendTime(self):
            event = getEvent(self.name + "_SpendTime")
            if event:
                renpy.call(event)
            else:
                renpy.call("defaultSpendTime")

        def checkSpendTime(self):
            if self.canProgress(0):
                self.playRelationship(0)
            elif self.canProgress(1):
                self.playRelationship(1)
            elif self.canProgress(2):
                self.playRelationship(2)
            else:
                self.playSpendTime()        

        def playRelationship(self, relation):
            if relation == 0:
                charaLabel = "{0}Friendship{1}".format(self.name, self.friendship + 1)
            elif relation == 1:
                charaLabel = "{0}Love{1}".format(self.name, self.love + 1)
            else:
                charaLabel = "{0}Lust{1}".format(self.name, self.lust + 1)

            #charaLabel = self.name + relation
            #renpy.hide("dayScreen")
            if renpy.has_label(charaLabel):
                renpy.call(charaLabel)
            else:
                if relation == 0:
                    renpy.call("defaultFriendship")
                elif relation == 1:
                    renpy.call("defaultLove")
                else:
                    renpy.call("defaultLust")
        
        def getNextEvent(self, relation):
            if relation == 0:
                return getEvent(self.name + "_Friendship_" + str(self.friendship))
            elif relation == 1:
                return getEvent(self.name + "_Love_" + str(self.love))
            else:
                return getEvent(self.name + "_Lust_" + str(self.lust))
                

        def unlock(self):
            global characters
            characters[self.name] = self
            
            persistent.relations[self.name + "_friendship"] = 0
            persistent.relations[self.name + "_love"] = 0
            persistent.relations[self.name + "_lust"] = 0

label defaultGreeting:
    "I have no greeting"
    return

label defaultSpendTime:
    "You spent some time with [shownChara.name]"
    return

label defaultFriendship:
    "Next Friendship event for [shownChara.name] not done yet"
    $shownChara.playSpendTime()
    return

label defaultLove:
    "Next Love event for [shownChara.name] not done yet"
    $shownChara.playSpendTime()
    return

label defaultLust:
    "Next Lust event for [shownChara.name] not done yet"
    $shownChara.playSpendTime()
    return