init 2 python:
    class abilityEffect:
        def __init__(self, name, description, image, icon, priority = 0, targetsUser = False):
            self.name = name
            self.descr = description
            self.image = image
            self.icon = icon
            self.priority = priority
            self.targetsUser = targetsUser

            abiEffects[name] = self

        def onCleanup(self, isPlayer):
            pass

        def onTurnStart(self, isPlayer):
            pass
        
        def onApplied(self, isPlayer):
            pass

        def onTurnEnd(self, isPlayer):
            pass

        def onInflictDamage(self, amount, isPlayer, isReaction):
            return amount

        def onDamaged(self, amount, isPlayer, isReaction):
            return amount

        @property
        def description(self):
            return "{} {}:\n{}".format(self.name, self.icon, self.descr)

    #Simple Ar
    class effArouse(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Arouse", "Gains {}\nMax out {} and you lose".format(i_arouse, i_arouse), "Effects/Arouse.png", "{image=Icons/Arouse.png}")

        def onApplied(self, isPlayer):
            if isPlayer:
                hpToPlayer(pEffects[self])
                pEffects.pop(self)
            else:
                hpToOpponent(oEffects[self])
                oEffects.pop(self)
    effArouse()
    
    #True Ar
    class effArouse2(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "❤ Arouse ❤", "Gains {}\nCan't be increased or reduced by other effects".format(i_arouse, i_focus), "Effects/Arouse2.png", "{image=Icons/Arouse2.png}")

        def onApplied(self, isPlayer):
            if isPlayer:
                hpToPlayer(pEffects[self], self.image, False, False)
                pEffects.pop(self)
            else:
                hpToOpponent(oEffects[self], self.image, False, False)
                oEffects.pop(self)
    effArouse2()

    #Reduces incoming Ar
    class effFocus(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Focus", "Reduces incoming damage for this turn\nClears at the end of turn", "Effects/Focus.png", "{image=Icons/Focus.png}", -5, True)
                            
        def onCleanup(self, isPlayer):
            if isPlayer:
                if pEffects.has_key(self):
                    if pEffects.has_key(shieldingEff):
                        pEffects[shieldingEff] -= 1
                    else:
                        pEffects.pop(self)
            else:
                if oEffects.has_key(self):
                    if oEffects.has_key(shieldingEff):
                        oEffects[shieldingEff] -= 1
                    else:
                        oEffects.pop(self)
        
        def onDamaged(self, amount, isPlayer, isReaction):
            if isPlayer:
                global pEffects
                if amount >= pEffects[self]:
                    amount -= pEffects[self]
                    pEffects.pop(self)
                else:
                    pEffects[self] -= amount
                    amount = 0
            else:
                global oEffects
                if amount >= oEffects[self]:
                    amount -= oEffects[self]
                    oEffects.pop(self)
                else:
                    oEffects[self] -= amount
                    amount = 0
            
            return amount
    focusEff = effFocus()
    
    #Keeps Focus
    class effShielding(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Shielding", ";)", "Effects/Shielding.png", "{image=Icons/Shielding.png}")
    shieldingEff = effShielding()

    #Lose Ar
    class effCalm(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Calm", "Lose {}".format(i_arouse), "Effects/Calm.png", "{image=Icons/Calm.png}", True)

        def onApplied(self, isPlayer):
            if isPlayer:
                if pEffects:
                    hpToPlayer(-pEffects[self], None, False, False)
                    pEffects.pop(self)
            else:
                if oEffects:
                    hpToOpponent(-oEffects[self], None, False, False)
                    oEffects.pop(self)
    effCalm()

    #Die => 1
    class effSticky(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Sticky", "Die becomes 1", "Effects/Sticky.png", "{image=Icons/Sticky.png}")
            
        def onTurnStart(self, isPlayer):
            if isPlayer:
                if pEffects[self] > len(playerRolls):
                    pEffects[self] = len(playerRolls)
                dice = renpy.random.sample(playerRolls, pEffects[self])
                pEffects.pop(self)
                
                for die in dice:
                    die.rollValue(1)
                    die.color = "#AAA"
            else:
                dice = renpy.random.sample(oppRolls, oEffects[self])   
                oEffects.pop(self)  
                    
                for die in dice:
                    die.rollValue(1)
                    die.color = "#AAA"
                
        def onApplied(self, isPlayer):
            if playerTurn:
                dice = renpy.random.sample(oppRolls, oEffects[self])   
                oEffects.pop(self)  
                    
                for die in dice:
                    die.rollValue(1)
                    die.color = "#AAA"
    effSticky()

    #Die unavailable
    class effLocked(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Locked", "Die unavailable", "Effects/Locked.png", "{image=Icons/Locked.png}")
            
        def onTurnStart(self, isPlayer):
            if isPlayer:
                dice = renpy.random.sample(playerRolls, pEffects[self])
                pEffects.pop(self)
                
                for die in dice:
                    die.locked = True
                    die.color = "#333"
            else:
                dice = renpy.random.sample(oppRolls, oEffects[self])   
                oEffects.pop(self)   
                    
                for die in dice:
                    die.locked = True
                    die.color = "#333"
                
        def onApplied(self, isPlayer):
            if playerTurn:
                dice = renpy.random.sample(oppRolls, oEffects[self])   
                oEffects.pop(self)   
                    
                for die in dice:
                    die.locked = True
                    die.color = "#333"
    effLocked()

    #Die hidden
    class effSmitten(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Smitten", "Die's value becomes hidden", "Effects/Smitten.png", "{image=Icons/Smitten.png}")
            
        def onTurnStart(self, isPlayer):
            if isPlayer:
                d = pEffects[self]
                if d > len(playerRolls):
                    d = len(playerRolls)
                dice = renpy.random.sample(playerRolls, d)
                pEffects.pop(self)
                
                for die in dice:
                    die.hidden = True
                    die.color = "#FFF"
            else:
                d = oEffects[self]
                if d > len(oppRolls):
                    d = len(oppRolls)
                dice = renpy.random.sample(oppRolls, d)   
                oEffects.pop(self)   
                    
                for die in dice:
                    die.hidden = True
                    die.color = "#FFF"
                
        def onApplied(self, isPlayer):
            if playerTurn:
                d = oEffects[self]
                if d > len(oppRolls):
                    d = len(oppRolls)
                dice = renpy.random.sample(oppRolls, d)   
                oEffects.pop(self)   
                    
                for die in dice:
                    die.hidden = True
                    die.color = "#FFF"
    effSmitten()

    #AoT
    class effAprho(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Aphrodisiac", "Gains arousal every turn\nDecreases by 1 each turn", "Effects/Aphro.png", "{image=Icons/Aprho.png}")
            
        def onTurnEnd(self, isPlayer):
            if isPlayer:
                hpToPlayer(pEffects[self], self.image, False, False)
                if pEffects[self] == 1:
                    pEffects.pop(self)
                else:
                    pEffects[self] -= 1
            else:
                hpToOpponent(oEffects[self], self.image, False, False)
                if oEffects[self] == 1:
                    oEffects.pop(self)
                else:
                    oEffects[self] -= 1
    effAprho()

    #HoT
    class effAnaphro(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Anaphrodisiac", "Lose arousal every turn\nSlowly decreases", "Effects/Anaphro.png", "{image=Icons/Anaphro.png}", True)
            
        def onTurnStart(self, isPlayer):
            if isPlayer:
                hpToPlayer(- pEffects[self], False, False)
                if pEffects[self] == 1:
                    pEffects.pop(self)
                else:
                    pEffects[self] -= 1
            else:
                hpToOpponent(- oEffects[self], False, False)
                if oEffects[self] == 1:
                    oEffects.pop(self)
                else:
                    oEffects[self] -= 1
    effAnaphro()

    #All dice +1, -1 each turn
    class effBless(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Blessed", "All dice +1 next turn\nSlowly decreases", "Effects/Blessed.png", "{image=Icons/Blessed.png}", True)
            
        def onTurnStart(self, isPlayer):
            if isPlayer:
                for die in playerRolls:
                    die.increaseValue(1)
                    die.color = "#fff9a4"
                addEffectToPlayer(self, -1, True)
            else:
                for die in oppRolls:
                    die.increaseValue(1)
                    die.color = "#fff9a4"
                addEffectToOpponent(self, -1, True)
        def onApplied(self, isPlayer):
            if playerTurn and not isPlayer:
                for die in oppRolls:
                    die.increaseValue(1)
                    die.color = "#fff9a4"
                addEffectToOpponent(self, -1, True)
    effBless()

    #All dice -1, -1 each turn
    class effCurse(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Cursed", "All dice -1 next turn\nSlowly decreases", "Effects/Cursed.png", "{image=Icons/Cursed.png}")
            
        def onTurnStart(self, isPlayer):
            if isPlayer:
                for die in playerRolls:
                    die.increaseValue(-1)
                    die.color = "#920000"
                addEffectToPlayer(self, -1, True)
            else:
                for die in oppRolls:
                    die.increaseValue(-1)
                    die.color = "#920000"
                addEffectToOpponent(self, -1, True)
        def onApplied(self, isPlayer):
            if playerTurn and not isPlayer:
                for die in oppRolls:
                    die.increaseValue(-1)
                    die.color = "#920000"
                addEffectToOpponent(self, -1, True)
    effCurse()

    #Dmg on attacked
    class effPhero(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Pheromones", "Inflicts X arousal when attacked\nDecreases by half when attacked or Clears next turn", "Effects/Phero.png", "{image=Icons/Phero.png}", True)
                            
        def onCleanup(self, isPlayer):
            if isPlayer:
                pEffects.pop(self)
            if not isPlayer:
                oEffects.pop(self)
        
        def onDamaged(self, amount, isPlayer, isReaction):
            if isReaction:
                return amount
            if isPlayer:
                hpToOpponent(pEffects[self], self.image, False, isReaction = True)
                pEffects[self] -= int (pEffects[self]/2 + .5)
            else:
                hpToPlayer(oEffects[self], self.image, False, isReaction = True)
                oEffects[self] -= int (oEffects[self]/2 + .5)
            return amount
    effPhero()

    #All dice +1, reset each turn
    class effZeal(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Zeal", "All dice +X next turn\nClears next turn", "Effects/Zeal.png", "{image=Icons/Zeal.png}", True)
            
        def onTurnEnd(self, isPlayer):
            if isPlayer:
                amount = pEffects[self]
                for die in playerRolls:
                    die.increaseValue(amount)
                    die.color = "#fff9a4"
                pEffects.pop(self)
            else:
                amount = oEffects[self]
                for die in oppRolls:
                    die.increaseValue(amount)
                    die.color = "#fff9a4"
                oEffects.pop(self)
    effZeal()

    #Ability Ar +
    class effArdor(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Ardor", "Increases arousal inflicted by your abilities\nSlowly decreases", "Effects/Ardor.png", "{image=Icons/Ardor.png}", True)
            
        def onInflictDamage(self, amount, isPlayer, isReaction):
            if isPlayer:
                return amount + pEffects[self]
            else:
                return amount + oEffects[self]
                
        def onCleanup(self, isPlayer):
            if isPlayer:
                addEffectToPlayer(self, -1, True)
            else:
                addEffectToOpponent(self, -1, True)
    effArdor()

    #Ability Ar -
    class effTired(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Tired", "Reduces arousal inflicted by your abilities\nSlowly decreases", "Effects/Tired.png", "{image=Icons/Tired.png}")
            
        def onInflictDamage(self, amount, isPlayer, isReaction):
            if isPlayer:
                return amount - pEffects[self]
            else:
                return amount - oEffects[self]
                
        def onCleanup(self, isPlayer):
            if isPlayer:
                addEffectToPlayer(self, -1, True)
            else:
                addEffectToOpponent(self, -1, True)
    effTired()

    #Ar recieved +
    class effSensitive(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Sensitive", "Increases arousal received by abilities\nDecreases by half", "Effects/Sensitive.png", "{image=Icons/Sensitive.png}")
            
        def onDamaged(self, amount, isPlayer, isReaction):
            if isPlayer:
                return amount + pEffects[self]
            else:
                return amount + oEffects[self]
                
        def onCleanup(self, isPlayer):
            if isPlayer:
                addEffectToPlayer(self.name, -pEffects[self] / 2)
            else:
                addEffectToOpponent(self.name, -oEffects[self] / 2)
    effSensitive()

    #Ar recieved -
    class effInsensitive(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Insensitive", "Reduces arousal received by abilities\nDecreases by half", "Effects/Insensitive.png", "{image=Icons/Insensitive.png}", True)
            
        def onDamaged(self, amount, isPlayer, isReaction):
            if isPlayer:
                amount -= pEffects[self]
            else:
                amount -= oEffects[self]

            if amount < 0:
                return 0
            else:
                return amount
                
        def onCleanup(self, isPlayer):
            if isPlayer:
                addEffectToPlayer(self.name, -pEffects[self] / 2)
            else:
                addEffectToOpponent(self.name, -oEffects[self] / 2)
    effInsensitive()

    #More dice
    class effVigor(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Vigor", "More dice next turn", "Effects/Vigor.png", "{image=Icons/Vigor.png}", True)
            
        def onApplied(self, isPlayer):
            if isPlayer:
                if pEffects.has_key(exhaustionEff):
                    i = min(pEffects[self], pEffects[exhaustionEff]) 
                    addEffectToPlayer(self, -i, True)
                    addEffectToPlayer(exhaustionEff, -i, True)
            else:
                if oEffects.has_key(exhaustionEff):
                    i = min(oEffects[self], oEffects[exhaustionEff]) 
                    addEffectToOpponent(self, -i, True)
                    addEffectToOpponent(exhaustionEff, -i, True)
    vigorEff = effVigor()

    #Less dice
    class effExhaustion(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Exhaustion", "Less dice next turn", "Effects/Exhaustion.png", "{image=Icons/Exhaustion.png}", True)
            
        def onApplied(self, isPlayer):
            if isPlayer:
                if pEffects.has_key(vigorEff) and pEffects.has_key(self):
                    i = min(pEffects[self], pEffects[vigorEff]) 
                    addEffectToPlayer(self, -i, True)
                    addEffectToPlayer(vigorEff, -i, True)
            else:
                if oEffects.has_key(vigorEff) and oEffects.has_key(self):
                    i = min(oEffects[self], oEffects[vigorEff]) 
                    addEffectToOpponent(self, -i, True)
                    addEffectToOpponent(vigorEff, -i, True)
    exhaustionEff = effExhaustion()
    
    #Used in combos
    class effTease(abilityEffect):
        def __init__(self):
            abilityEffect.__init__(self, "Tease", ";)", "Effects/Tease.png", "{image=Icons/Tease.png}")
    teaseEff = effTease()