﻿# Character state initialization
default char_states = {
   "victor": CharState.NORMAL,
   "scarlett": CharState.NORMAL,
   "swift": CharState.NORMAL,
   "azami": CharState.NORMAL,
   "adriana": CharState.NORMAL,
   "kira": CharState.NORMAL,
   "sophia": CharState.NORMAL,
   "mayor": CharState.NORMAL,
   "maya": CharState.NORMAL,
   "jake": CharState.NORMAL,
}

# Make outfit states persistent so selections survive game restarts
default persistent.outfit_states = {
   "victor": "normal",
   "scarlett": "normal",
   "swift": "normal",
   "azami": "normal",
   "adriana": "normal",
   "kira": "normal",
   "sophia": "normal",
   "mayor": "normal",
   "maya": "normal",
   "jake": "normal",
}

# Initialize outfit_states immediately to prevent display issues
default outfit_states = {
    "victor": OutfitState.TORN_CLOTHES,  # Victor starts in torn clothes from shipwreck
    "scarlett": OutfitState.NORMAL,
    "swift": OutfitState.NORMAL,
    "azami": OutfitState.NORMAL,
    "adriana": OutfitState.NORMAL,
    "kira": OutfitState.NORMAL,
    "sophia": OutfitState.NORMAL,
    "mayor": OutfitState.NORMAL,
    "maya": OutfitState.NORMAL,
    "jake": OutfitState.NORMAL,
}

init python:
    def update_character_state(character_name, new_state):
        if character_name in char_states:
            char_states[character_name] = new_state
        else:
            raise ValueError(f"Character '{character_name}' not found in char_states.")

    def update_outfit_state(character_name, new_outfit_state):
        if character_name in persistent.outfit_states:
            # Update both persistent and runtime states
            outfit_name = new_outfit_state.value if hasattr(new_outfit_state, 'value') else new_outfit_state
            persistent.outfit_states[character_name] = outfit_name
            outfit_states[character_name] = new_outfit_state

label start:
    jump prologue_start
