# Lewd Island - Prologue V2: First Contact
# A different approach to the dark paradise story

# Love system (only point system in the game)
default scarlett_love = 0
default azami_love = 0
default adriana_love = 0
default kira_love = 0
default sophia_love = 0
default swift_sabotage = 0

# Story tracking variables
default maya_jake_seen = False
default scarlett_met = False
default mayor_met = False
default family_threatened = False

# Character definitions are now in utils/characters.rpy
# Using the advanced character system with expressions and outfits

# Transform definitions
transform bg_zoom:
    zoom 0.72

# Character position transforms (closer to center)
transform left_close:
    xalign 0.3
    yoffset 300

transform right_close:
    xalign 0.7
    yoffset 300

transform center_close:
    xalign 0.5
    yoffset 300

transform mayor_close:
    xalign 0.5
    yoffset 300
    zoom 0.72

# Image definitions
image black = "#000000"
image white = "#FFFFFF"

# Character images are now handled by the advanced character system in utils/characters.rpy
# Using proper character names for better organization
image azami = "images/characters/Azami_Vantaris.png"
image adriana = "images/characters/Character_32360.png"
image kira = "images/characters/Character_43563.png"
image sophia = "images/characters/Character_77739.png"
image maya = "images/characters/Character_16899.png"  
image jake = "images/characters/Character_15713.png"

# Scene definitions are now in scenes.rpy following reference game pattern

label prologue_start:
    # Initialize ambient shore sounds and mysterious island atmosphere
    play sound "audio/sound_effects/shore_night_ambient.mp3" loop
    play music "audio/sound_effects/mysterious_island_ambient.mp3" loop
    
    scene shore_night at bg_zoom
    with fade
    
    # Storm aftermath thunder
    play audio "audio/sound_effects/storm_aftermath_thunder.mp3"
    
    narrator "Consciousness returns slowly, salt water burning your throat."

    # Victor waking up sounds - heavy breathing and groaning
    play audio "audio/sound_effects/victor_waking_up.mp3"
    
    show victor at center_close
    $ update_character_state("victor", CharState.NORMAL)
    with dissolve
    
    v "What... where am I?"
    v "The storm... the boat... oh god, my head..."
    v "Am I alive? This pain... this has to mean I'm alive."
    v "But where the hell am I?"
    
    # Scene: Waking up on beach
    # Add scene transition sound
    play audio "audio/sound_effects/scene_transition.mp3"
    
    v "Sand... I'm on sand. A beach."
    v "My clothes are completely destroyed. Torn to shreds."
    
    # Footsteps as Victor starts exploring
    play audio "audio/sound_effects/footsteps_wet_sand.mp3"
    
    v "How long was I unconscious? Hours? Days?"
    v "I need to find help. Civilization. Anyone."
    
    # First choice - immediate direction
    menu wake_up_choice:
        "Call out for help immediately":
            v "HELP! SOMEONE HELP ME!"
            v "PLEASE! IS ANYONE THERE?"
            v "I'M HURT! I NEED ASSISTANCE!"
            $ swift_sabotage += 5
            jump discover_sounds
            
        "Explore quietly to assess the situation":
            v "I should be careful. Don't know what kind of place this is."
            v "Let me look around first, see what I'm dealing with."
            $ scarlett_love += 5
            jump discover_sounds
            
        "Try to salvage belongings from the wreckage":
            v "My camera bag... where is it?"
            v "Maybe something survived. I need supplies."
            v "Can't survive with just torn clothes."
            jump discover_sounds

label discover_sounds:
    
    # Add distant voices sound
    play audio "audio/sound_effects/distant_voices.mp3"
    
    v "Wait... I hear something. Voices?"
    v "Human voices. Thank god, there are people here."
    v "But they're... they sound..."
    
    # Discovery of Maya and Jake
    v "Those aren't distress calls. They're..."
    v "Oh. OH. They're having sex."
    v "Should I interrupt? That would be awkward as hell."
    v "But I need help. I'm literally shipwrecked."
    
    menu voyeur_discovery:
        "Approach quietly and wait for them to finish":
            # Being respectful and cautious - good choice
            $ scarlett_love += 5
            # Sneaking through grass sounds
            play audio "audio/sound_effects/grass_rustling_sneak.mp3"
            v "I'll wait nearby. Don't want to interrupt, but I need help."
            v "Maybe I can get their attention when they're done."
            jump first_voyeur_scene
            
        "Make noise to alert them of your presence":
            v "Hey! Sorry to interrupt, but I need help!"
            v "I was in a boat accident! Please!"
            jump interrupted_couple
            
        "Try to find another way around them":
            v "I'll go around. Find another path."
            v "There has to be other people on this island."
            jump direct_to_scarlett
    
label first_voyeur_scene:
    # First Maya and Jake scene with explicit dialog
    scene scene_0
    with fade
    
    v "I can see them now. A couple on the beach."
    v "They're... really going at it."
    v "I should look away, but... where else can I go?"
    
    $ update_character_state("victor", CharState.AROUSED)

    maya "Oh god... Jake... right there... deeper..."
    jake "Maya... you're so wet for me... so tight..."
    maya "I love feeling you inside me... stretching me..."
    jake "You're taking me so well, baby..."
    
    v "They're not just having sex. They're talking dirty."
    v "Really dirty. Like they're performing or something."
    
    maya "The cameras are getting every angle, aren't they?"
    jake "Always. Every moment. They love watching me fill you."
    maya "Sometimes I forget we're performing. Your cock feels so real inside me."
    jake "It IS real. Even if it's also a show. You make me so hard."
    
    v "Cameras? Show? What the hell are they talking about?"
    v "This is getting weirder by the minute."
    
    menu voyeur_reaction:
        "Keep watching - this is clearly important information":
            # Learning about the island's secrets - excellent choice
            $ scarlett_love += 50
            $ maya_jake_seen = True
            
            v "Something's not right here. They mentioned cameras and shows."
            v "This might be more than just a random couple."
            
            maya "Fuck me harder... make me scream for the cameras..."
            jake "You want them to hear how good I make you feel?"
            maya "Yes... let them hear me cum on your cock..."
            jake "That's my dirty girl... taking me so deep..."
            
            maya "I'm close... the viewers love synchronized finishes..."
            jake "Forget the viewers. This is for us."
            maya "Nothing here is just for us anymore."
            jake "Then let's pretend. Just for this moment."
            maya "Yes... fuck yes... your cock is driving me crazy..."
            jake "Cum for me, baby... let me feel you squeeze around me..."
            maya "Jake... I'm cumming... oh god I'm cumming so hard..."
            jake "Maya... I love you... despite everything..."
            
            v "Viewers? What kind of place is this?"
            v "This is clearly more than just a private moment."
            
            jump return_to_shore
            
        "Look away and wait respectfully":
            v "This is private. I shouldn't be watching."
            v "I need to leave them alone and find help elsewhere."
            $ swift_sabotage += 5
            
            maya "Yes... yes... Jake!"
            jake "Maya... I love you..."
            
            v "They sound like they care about each other."
            v "But I can't interrupt such an intimate moment."
            
            jump return_to_shore
            
        "Clear your throat to announce your presence":
            v "Ahem... excuse me? Sorry to interrupt..."
            v "Wait, no. That would be awkward. Let me just wait."
            
            jump first_voyeur_scene

label return_to_shore:

    scene shore_night at bg_zoom
    show victor at center_close
    with fade
    
    narrator "You quietly retreat from the dunes back to the shore."
    
    v "That was... intense. And strange."
    v "They kept talking about cameras and viewers."
    v "What kind of place is this?"
    v "I need to process what I just witnessed."
    v "But first, I need to find help. Someone who can explain what's happening."
    
    jump find_help_elsewhere

label interrupted_couple:
    maya "WHAT THE HELL?!"
    jake "WHO'S THERE?! GET AWAY FROM US!"
    
    v "I'm sorry! I didn't mean to! I need help!"
    v "My boat crashed! I'm injured!"
    
    maya "GET OUT OF HERE! PERVERT!"
    jake "GO AWAY! LEAVE US ALONE!"
    maya "SECURITY! SOMEONE HELP!"
    
    v "Please, I just need..."
    
    jake "I SAID GET LOST!"
    maya "GET THE FUCK AWAY FROM US!"
    
    v "Okay, okay! I'm leaving!"
    v "Jesus, they're screaming like I'm a serial killer."
    v "I'll find help somewhere else."
    
    jump find_help_elsewhere

label find_help_elsewhere:
    v "I need to find help, but approaching that couple would be too awkward."
    v "Let me explore the island and see if there are other people."
    v "There has to be a town or village somewhere."
    
    jump direct_to_scarlett

label direct_to_scarlett:
    v "I need to get away from here before they notice me."
    v "There has to be a path through these dunes to find civilization."
    v "My legs are barely holding me up, but I need to keep moving."
    
    narrator "You stumble through the sand dunes, exhausted and disoriented."
    
    v "I can't go much further. Need to rest."
    v "But I have to find help. Can't survive alone."
    v "Wait... is that someone coming this way?"
    
    jump meet_scarlett

label meet_scarlett:
    # Scene: Scarlett discovers Victor
    # Stop ambient shore sounds, transition to hopeful music
    stop sound fadeout 2.0
    play sound "audio/sound_effects/relief_victory_theme.mp3"
    
    show scarlett at left_close
    $ update_character_state("scarlett", CharState.NORMAL)
    show victor at right_close
    $ update_character_state("victor", CharState.NORMAL)
    with fade
    
    
    scarlett "Oh my god! Are you alright?"
    
    narrator "A beautiful woman with flowing honey blonde hair approaches, concern evident in her voice."
    
    $ update_character_state("victor", CharState.HAPPY)
    
    v "I... I need help. Boat accident. Been unconscious on the beach."
    
    scarlett "Your clothes are destroyed! And you're covered in cuts!"
    scarlett "We need to get you medical attention immediately!"
    scarlett "Can you walk? My cottage isn't far."
    
    v "I think so. Just barely."
    v "Thank you. I thought I was going to die here."
    
    scarlett "Not on my watch. I'm Scarlett, by the way."
    scarlett "I live on the island. I'll take care of you."
    
    v "Victor. And I can't thank you enough."
    
    menu first_scarlett_interaction:
        "Ask about the island and its inhabitants":
            $ swift_sabotage += 5
            v "How many people live on this island?"
            v "Is there a doctor? A way to contact the mainland?"
            scarlett "Let's focus on getting you patched up first."
            scarlett "Questions can wait until you're stable."
            scarlett "But yes, we have medical supplies and a doctor."
            jump to_cottage
            
        "Express gratitude and follow her lead":
            # Building trust with Scarlett - excellent choice
            $ scarlett_love += 50
            v "You're an angel. I don't know what I would have done."
            v "I was starting to panic that I was completely alone."
            scarlett "You're safe now. That's what matters."
            scarlett "I couldn't live with myself if I left someone suffering."
            scarlett "It's what anyone would do."
            jump to_cottage
            
        "Ask about the couple you saw on the beach":
            # Showing awareness and intelligence - good choice
            $ scarlett_love += 5
            v "I saw a couple on the beach. They were... intimate."
            v "But they mentioned something about cameras and viewers."
            scarlett "You saw Maya and Jake? From a distance?"
            scarlett "They're... well, they're complicated."
            scarlett "Let's get you safe first, then we can talk about island politics."
            jump to_cottage

label to_cottage:

    scarlett "Here, lean on me. My cottage is just up this path."
    scarlett "I have a first aid kit and clean clothes you can borrow."
    scarlett "You're about my size, maybe a little broader in the shoulders."
    
    v "I feel terrible imposing on you like this."
    
    scarlett "Nonsense. I've been alone on this island for two years."
    scarlett "It's nice to have someone to help for a change."
    scarlett "Someone who actually needs help, I mean."
    
    v "Two years? You've been here alone for two years?"
    
    scarlett "Not alone, exactly. There are other residents."
    scarlett "But it's... complicated. You'll understand eventually."
    scarlett "For now, let's just focus on getting you healthy."
    
label scarletts_cottage:
    # Scene: At Scarlett's place
    # Cottage atmosphere - fireplace crackling and door opening
    stop music fadeout 2.0
    play sound "audio/sound_effects/cottage_fireplace.mp3" loop
    play audio "audio/sound_effects/cottage_door_open.mp3"
    
    scene cottage_night at bg_zoom

    show scarlett at left_close
    show victor at right_close
    $ update_character_state("victor", CharState.NORMAL)
    
    with Fade(1.0, 0.5, 1.0)
    
    # Cottage footsteps
    play audio "audio/sound_effects/cottage_footsteps.mp3"
    
    scarlett "Here we are. It's not much, but it's comfortable."
    scarlett "Bathroom's through there. There should be hot water."
    scarlett "I'll lay out some clean clothes for you."
    
    v "This place is beautiful. You've made it really homey."
    v "Are you sure you're okay with me staying here?"
    
    scarlett "Of course. Where else would you go?"
    scarlett "The alternative accommodations on this island are..."
    scarlett "Well, let's just say you wouldn't be comfortable there."
    
    v "What do you mean by that?"
    
    scarlett "Victor, can I be honest with you?"
    scarlett "This island isn't what it appears to be."
    scarlett "But right now, you need rest and medical attention."
    scarlett "Tomorrow, I'll show you around and explain everything."
    scarlett "For tonight, just focus on recovering."
    
    menu cottage_conversation:
        "Insist on knowing the truth now":
            $ swift_sabotage += 10
            v "I need to know what I'm dealing with. What's wrong with this place?"
            scarlett "Victor, you're exhausted and probably have a concussion."
            scarlett "Trust me, this conversation is better had when you're thinking clearly."
            scarlett "Some truths are easier to handle when you're physically stronger."
            v "That's not comforting at all."
            scarlett "It's not meant to be. But it's honest."
            jump cottage_care
            
        "Trust her judgment and rest":
            # Trusting Scarlett's wisdom - excellent choice
            $ scarlett_love += 50
            v "You're right. I can barely think straight right now."
            v "Thank you for looking out for me."
            scarlett "That's what neighbors do."
            scarlett "Get cleaned up, get some food in you, and sleep."
            scarlett "Tomorrow will make more sense, I promise."
            jump cottage_care
            
        "Ask about her personal story":
            $ scarlett_love += 5
            v "How did you end up on this island? You mentioned two years."
            scarlett "That's a long story. One for tomorrow as well."
            scarlett "But I will tell you. You deserve to know what you're dealing with."
            scarlett "And what might happen to you if you're not careful."
            jump cottage_care

label cottage_care:
    
    scarlett "The shower's through there. Towels are in the cabinet."
    scarlett "I'll make us some dinner while you clean up."
    scarlett "When you're ready, we'll eat and then you can sleep."
    scarlett "Real sleep, in a real bed. You've earned it."
    
    v "Scarlett... why are you being so kind to me?"
    v "You don't even know me."
    
    scarlett "Because kindness is rare here."
    scarlett "And because I remember what it was like to be new and scared."
    scarlett "Someone helped me once. Now it's my turn."
    
    v "Someone helped you when you arrived?"
    
    scarlett "She's not around anymore."
    scarlett "That's part of what we need to discuss tomorrow."
    scarlett "But for now, just accept that you're safe."
    scarlett "At least for tonight."

    jump first_night
    
label first_night:
    # Scene: Evening at cottage
    narrator "After a shower and a hot meal, you feel almost human again."
    
    v "That food was incredible. Thank you."
    v "I don't remember the last time I felt this... normal."
    
    scarlett "You were probably dehydrated and malnourished."
    scarlett "Salt water and unconsciousness will do that to you."
    scarlett "How are your injuries feeling?"
    
    v "Much better. Still sore, but the cuts have stopped bleeding."
    v "Your first aid skills are impressive."
    
    scarlett "You learn to be self-sufficient on this island."
    scarlett "Medical emergencies don't wait for convenient timing."
    
    v "Scarlett, I have to ask. Are we completely alone right now?"
    
    scarlett "What do you mean?"
    
    v "That couple, Maya and Jake, they mentioned cameras. Viewers."
    v "Is someone watching us right now?"
    
    scarlett "..."
    scarlett "Not in my cottage. This is one of the few private spaces left."
    scarlett "But Victor, tomorrow is going to be overwhelming."
    scarlett "Get some rest while you still can."
    
    menu evening_conversation:
        "Push for more information":
            $ swift_sabotage += 5
            v "I need to know what I'm walking into tomorrow."
            v "People don't just mention cameras and viewers casually."
            scarlett "You're right. They don't."
            scarlett "This island is a stage, Victor. And everyone on it is performing."
            scarlett "Whether they want to or not."
            v "Performing for whom?"
            scarlett "People with a lot of money and very specific tastes."
            jump clothing_exchange
            
        "Accept her advice to rest":
            $ scarlett_love += 5
            v "You're right. I'm exhausted and my head is still fuzzy."
            v "Tomorrow I'll be better equipped to handle whatever this is."
            scarlett "That's wise. And I'll be with you every step of the way."
            scarlett "You don't have to face this alone."
            jump clothing_exchange
            
        "Ask about her feelings on the situation":
            v "How do you cope with... whatever this is?"
            scarlett "Some days better than others."
            scarlett "Having a purpose helps. Taking care of my cottage, my pottery."
            scarlett "And now, taking care of you."
            v "I don't want to be a burden."
            scarlett "You're not. You're giving me something real to focus on."
            jump clothing_exchange

label clothing_exchange:
    # Scene: Scarlett provides clothes for Victor
    
    # Rustling through closet/drawers sounds
    play audio "audio/sound_effects/cottage_door_open.mp3"
    
    narrator "Scarlett moves to a wooden chest in the corner of the room."
    narrator "She opens it and begins sorting through folded clothes."
    
    scarlett "Now, about getting you properly dressed for tomorrow."
    scarlett "Your clothes are completely destroyed - salt water, tears, blood..."
    scarlett "They're beyond salvaging in their current state."
    
    v "I really appreciate the offer, but I can't take your clothes."
    v "You've already done so much for me."
    
    scarlett "Nonsense. These will work perfectly for you."
    
    narrator "She holds up a crisp white button-up shirt and white pants."
    
    scarlett "I used to wear these when I worked in town, before..."
    scarlett "Well, before things changed. They're more your size anyway."
    scarlett "I was going through a... masculine fashion phase when I bought them."
    
    show victor at right_close
    $ update_character_state("victor", CharState.HAPPY)
    
    v "Are you sure? These look expensive."
    
    scarlett "I insist. And look, there's even a woven leather belt that should fit."
    scarlett "Brown leather - it'll go perfectly with the white."
    scarlett "You'll look quite handsome, actually."
    
    $ scarlett_love += 10
    
    v "Scarlett, this is incredibly generous of you."
    v "What about my old clothes? Are they really unsalvageable?"
    
    scarlett "Let me take a look at them after you change."
    scarlett "I'm pretty handy with a needle and thread."
    scarlett "If there's enough fabric left, I might be able to repair them."
    scarlett "It'll give me something to do while you sleep."
    
    menu clothing_response:
        "Accept gracefully and thank her":
            $ scarlett_love += 15
            v "I don't know what to say. Thank you doesn't seem like enough."
            v "You're saving my life in more ways than one."
            scarlett "That's what friends do, Victor."
            scarlett "And something tells me we're going to need each other on this island."
            
        "Insist on finding another solution":
            v "There has to be something else I can wear."
            v "I feel terrible taking your clothes."
            scarlett "Victor, look at me."
            scarlett "On this island, we help each other survive."
            scarlett "Pride is a luxury we can't afford here."
            scarlett "Let me help you."
            $ scarlett_love += 5
            
        "Ask about her sewing skills":
            v "You really think you can repair my original clothes?"
            v "They looked pretty torn up."
            scarlett "I've been mending clothes for two years here."
            scarlett "You learn to make things last when replacements are... complicated."
            scarlett "I can't promise they'll look perfect, but they'll be wearable."
            v "That would be amazing. Thank you."
            $ scarlett_love += 10
    
    scarlett "Go ahead and change. I'll start examining your old clothes."
  
    scene black
    scarlett "There's a privacy screen in the bedroom if you need it."
    
    # Character state change to represent Victor now wearing the white casual outfit
    $ update_outfit_state("victor", OutfitState.WHITE_CASUAL)
    scene cottage_night at bg_zoom
    show scarlett at left_close
    show victor at right_close
    with Fade(1.0, 0.5, 1.0)
    
    narrator "You change into Scarlett's clothes. They fit surprisingly well."
    narrator "The white shirt is comfortable, and the pants are just the right length."
    narrator "The brown leather belt completes the outfit perfectly."
    
    v "These fit perfectly. How did you know?"
    
    scarlett "I have a good eye for sizes. Plus, I mentioned you were about my build."
    scarlett "The white looks good on you - brings out your eyes."
    
    narrator "Scarlett examines your torn clothes, spreading them out on the table."
    
    scarlett "Well, the good news is there's enough fabric to work with."
    scarlett "The bad news is it's going to take most of the night."
    scarlett "But I don't mind. I often have trouble sleeping anyway."
    
    v "I can't ask you to stay up all night sewing for me."
    
    scarlett "You're not asking. I'm offering."
    scarlett "Besides, like I said, it gives me something useful to focus on."
    scarlett "Something real and immediate, rather than... other things."
    
    $ scarlett_love += 5
    
    jump bedtime_setup

label bedtime_setup:
    
    # Bedsheet rustling and intimate bedroom sounds
    play audio "audio/sound_effects/bedsheet_rustling.mp3"
    
    scarlett "The bedroom is through there. I'll take the couch."
    scarlett "If you need anything during the night, just wake me."
    scarlett "And Victor? Don't try to leave during the night."
    scarlett "The island can be dangerous in the dark."
    scarlett "Not because of wild animals."
    scarlett "Because of the people."
    
    v "What people?"
    
    scarlett "Get some sleep. All will be revealed tomorrow."
    
label second_morning:
    # Scene: Next morning
    # Morning transition - stop fireplace, add birds and breakfast sounds
    stop sound fadeout 3.0
    play sound "audio/sound_effects/morning_birds_tropical.mp3" loop
    play audio "audio/sound_effects/morning_breakfast_sounds.mp3"
    
    scene cottage_day at bg_zoom
    with Fade(1.0, 0.5, 1.0)
    
    narrator "You wake to the smell of coffee and the sound of gentle humming."
    
    show scarlett at left_close
    show victor at right_close
    with dissolve
    
    v "Scarlett? That smells amazing."
    
    scarlett "Good morning! You look much better."
    scarlett "Color's back in your cheeks, and you're moving without wincing."
    scarlett "How do you feel?"
    
    v "Like a human being again. Thank you."
    v "Did you sleep okay on the couch?"
    
    scarlett "I've slept in worse places."
    scarlett "Besides, I wanted to keep an ear out in case you had nightmares."
    scarlett "Trauma manifests in sleep sometimes."
    
    v "You really are something special, aren't you?"
    
    scarlett "I'm just someone who remembers what it's like to be helpless."
    scarlett "Now, are you ready for that tour I promised?"
    scarlett "Fair warning - it's going to challenge everything you think you know."
    
    menu morning_readiness:
        "I'm ready for whatever this island has to show me":
            $ scarlett_love += 5
            v "I've been through hell already. I can handle the truth."
            scarlett "I admire your courage. You'll need it."
            scarlett "But remember, knowledge comes with responsibility here."
            scarlett "Once you know, you can't unknow."
            jump morning_tour
            
        "I'm nervous but I trust you":
            $ scarlett_love += 10
            v "I don't know what's coming, but I know you'll help me through it."
            scarlett "That means more to me than you know."
            scarlett "Having someone trust you here... it's precious."
            scarlett "I won't let you down."
            jump morning_tour
            
        "Can we start slowly? I'm still processing yesterday":
            $ swift_sabotage += 5
            v "Maybe we can ease into this? I'm still recovering mentally."
            scarlett "Of course. We'll take it at your pace."
            scarlett "But Victor, delaying knowledge can be more dangerous than having it."
            scarlett "The island doesn't pause for our comfort."
            jump morning_tour

label morning_tour:
    
    scarlett "First stop is the town center. You need to meet the Mayor."
    scarlett "He's... well, he's the closest thing to authority we have here."
    scarlett "And he needs to know about new arrivals."
    
    v "Is that normal protocol?"
    
    scarlett "Nothing here is normal, but yes, it's required."
    scarlett "New people upset the balance. The Mayor likes to assess threats."
    scarlett "Don't take it personally. He's suspicious of everyone."
    
    v "Threats? What kind of threats could I possibly pose?"
    
    scarlett "You'd be surprised what the wrong person can do to a delicate ecosystem."
    scarlett "This island runs on very specific rules."
    scarlett "Break them, and everyone suffers."


    jump town_tour
    
label town_tour:
    # Scene: Walking through the town
    # Town center ambience
    play sound "audio/sound_effects/town_center_ambient.mp3" loop
    
    scene town_center_day at bg_zoom
    
    show scarlett at left_close
    show victor at right_close
    $ update_character_state("victor", CharState.NORMAL)
    $ update_character_state("scarlett", CharState.HAPPY)
    with Fade(1.0, 0.5, 1.0)
    
    v "This place is beautiful. It looks like a resort town."
    v "But something feels... artificial. Staged."
    
    scarlett "Good eye. Everything here is carefully designed."
    scarlett "Every building, every garden, every street corner."
    scarlett "Nothing is accidental."
    
    v "Designed for what purpose?"
    
    scarlett "Entertainment. Specifically, the entertainment of people who pay enormous amounts of money."
    scarlett "People who have very specific desires."
    
    v "What kind of desires?"
    
    scarlett "The kind that involve watching other people live their lives."
    scarlett "Intimate lives. Private moments. Personal relationships."
    scarlett "All broadcast live to paying subscribers."
    
    $ update_character_state("victor", CharState.ANGRY)
    
    v "Are you telling me this is some kind of reality show?"
    
    $ update_character_state("scarlett", CharState.HAPPY)
    
    scarlett "The most exclusive reality show in the world."
    scarlett "Where the participants never agreed to participate."
    scarlett "And leaving isn't an option."
    
    menu town_reaction:
        "That's impossible. This has to be illegal":
            $ swift_sabotage += 10
            v "You can't just kidnap people and force them to perform!"
            v "There are laws! International authorities!"
            scarlett "Laws require enforcement. Authorities require jurisdiction."
            scarlett "This island exists in legal gray areas."
            scarlett "And the people who run it have very powerful friends."
            jump mayors_building
            
        "How many people know about this?":
            $ scarlett_love += 5
            v "How big is this operation? How many viewers?"
            scarlett "Millions of subscribers worldwide."
            scarlett "Premium memberships cost six figures annually."
            scarlett "The revenue is... substantial."
            v "And nobody reports it?"
            scarlett "Who would they report it to? Half the subscribers are politicians and judges."
            jump mayors_building
            
        "How did you find out?":
            $ scarlett_love += 5
            v "When did you realize what this place really was?"
            scarlett "About three weeks after I arrived."
            scarlett "Same as everyone else. They let you settle in first."
            scarlett "Make you comfortable. Give you hope."
            scarlett "Then they explain your new reality."
            jump mayors_building

label mayors_building:
    
    # Official building entrance
    play audio "audio/sound_effects/official_building_door.mp3"
    
    scarlett "That building there is the Mayor's office."
    scarlett "He's probably expecting us. News travels fast on a small island."
    scarlett "Remember, be respectful but not submissive."
    scarlett "He respects strength but punishes defiance."
    
    v "What's he like?"
    
    scarlett "Imagine a small-town politician with absolute power."
    scarlett "Charming when he needs to be, ruthless when he doesn't."
    scarlett "He's been here longer than anyone except the original staff."
    
    v "How long?"
    
    scarlett "Seven years. He was one of the first 'guests.'"
    scarlett "Now he helps run the place."
    scarlett "It's called Stockholm Syndrome when you start identifying with your captors."
    
label meeting_mayor:
    # Scene: Mayor's office
    scene mayor_office_day at bg_zoom
    with Fade(1.0, 0.5, 1.0)
    
    show mayor at mayor_close
    $ update_character_state("mayor", CharState.NORMAL)
    with dissolve
    
    mayor "Scarlett, my dear! And you must be our shipwrecked photographer."
    
    narrator "A man in his 50s rises from behind an ornate desk, extending his hand with practiced charm."
    
    v "How did you know I was a photographer?"
    
    mayor "Your camera bag washed up about a mile down the beach."
    mayor "Waterproof, excellent equipment. Professional grade."
    mayor "We always research our new arrivals thoroughly."
    
    v "New arrivals? How often do people wash up here?"
    
    mayor "More frequently than you might expect."
    mayor "The shipping lanes around this island are surprisingly treacherous."
    mayor "Storms, equipment failures, navigational errors..."
    mayor "All very tragic. All very convenient."
    
    scarlett "Mayor Richardson, Victor needs to understand his situation."
    
    mayor "All in good time, Scarlett. No need to overwhelm our guest."
    mayor "Victor, isn't it? Pleasure to meet you."
    mayor "I'm Mayor Richardson, elected representative of our little community."
    
    v "Elected by whom?"
    
    mayor "By the residents, of course. Democratic process."
    mayor "Though I admit the voter pool is somewhat limited."
    mayor "And the elections are more... performative than competitive."
    
    menu mayor_interaction:
        "Challenge his authority directly":
            $ swift_sabotage += 10
            v "What gives you the right to govern people who never agreed to live here?"
            mayor "Ah, a rebel. The viewers do enjoy a good uprising arc."
            mayor "But Victor, rights are a luxury here. Survival is the priority."
            mayor "I help people survive. That gives me all the authority I need."
            jump mayor_dismissal
            
        "Play along with his charade":
            $ scarlett_love += 5
            v "Well, thank you for your hospitality, Mayor Richardson."
            v "I'm grateful for the warm welcome."
            mayor "Excellent attitude! You'll do well here, Victor."
            mayor "Adaptability is the key to longevity on our island."
            jump mayor_dismissal
            
        "Ask about leaving the island":
            v "What are the procedures for departing? My family will be worried."
            mayor "Family? How interesting. Tell me about them."
            mayor "Wife? Children? Parents who might come looking?"
            v "Why do you need to know that?"
            mayor "Security reasons, of course. We can't have unauthorized searches disrupting our community."
            jump mayor_dismissal

label mayor_dismissal:
    
    mayor "Scarlett, you've done excellent work with our new arrival."
    mayor "I can see he's been well cared for."
    mayor "Continue to show him around. Help him understand our... unique culture."
    
    scarlett "Of course, Mayor. We'll visit the market next."
    scarlett "Victor should meet more of the residents."
    
    mayor "Wonderful idea. Victor, you'll find our community very welcoming."
    mayor "We're all one big family here."
    mayor "Whether we like it or not."
    
    v "What did you mean by that?"
    
    mayor "Just that family relationships can be... complicated sometimes."
    mayor "But we always look out for each other."
    mayor "Because we're all we have."
    
label exploring_together:
    # Scene: Continuing the tour with Scarlett
    narrator "As you leave the Mayor's office, Scarlett takes your arm."

    scene town_center_day at bg_zoom

    show scarlett at left_close
    show victor at right_close
    $ update_character_state("victor", CharState.ANGRY)
    $ update_character_state("scarlett", CharState.HAPPY)

    with Fade(1.0, 0.5, 1.0)

    
    scarlett "How are you feeling after that?"
    
    v "Like I just met a shark in a three-piece suit."
    v "He was friendly, but there was something predatory about him."
    
    scarlett "That's exactly what he is. Perfectly described."
    scarlett "He's been the Mayor for three years now."
    scarlett "The previous Mayor tried to organize an escape."
    scarlett "She disappeared one night. Boat accident, they said."
    
    v "They killed her?"
    
    scarlett "They don't have to kill anyone directly."
    scarlett "The island is surrounded by strong currents and aggressive sharks."
    scarlett "Very dangerous waters. Easy to have accidents."
    
    v "This is insane. How do you live with this knowledge?"
    
    scarlett "By focusing on what I can control."
    scarlett "My cottage, my pottery, my relationships with people I trust."
    scarlett "Like you."

    $ update_character_state("victor", CharState.NORMAL)
    
    menu relationship_development:
        "I trust you too, Scarlett":
            $ scarlett_love += 10
            v "You've been incredible to me. I can't imagine facing this alone."
            scarlett "You don't have to. We'll figure this out together."
            scarlett "Having someone to share the burden makes it bearable."
            v "Is that what we're doing? Sharing the burden?"
            scarlett "Among other things. I hope."
            jump amanda_story
            
        "What makes you think you can trust me?":
            $ swift_sabotage += 5
            v "How do you know I'm not working for them? Some kind of plant?"
            scarlett "Your injuries were real. Your confusion is real."
            scarlett "And I've gotten good at reading people over the last two years."
            scarlett "You're genuinely lost and scared. Just like I was."
            jump amanda_story
            
        "Tell me more about the other residents":
            v "What are the people here like? How many are there?"
            scarlett "About forty residents total. All ages, but mostly young adults."
            scarlett "All attractive, all with specific skills or backgrounds."
            scarlett "Artists, athletes, musicians, intellectuals."
            scarlett "People who make interesting television."
            jump amanda_story

label amanda_story:
    
    scarlett "Let's sit here for a bit. I want to tell you something important."
    
    narrator "She leads you to a bench overlooking the ocean."
    
    scarlett "Victor, I need you to understand something about me."
    scarlett "About why I'm helping you."
    
    v "What is it?"
    
    scarlett "I was a medical student when I came here."
    scarlett "Three months away from graduating. I had my whole life planned out."
    scarlett "Then my plane crashed during a medical mission to Central America."
    scarlett "Sole survivor. Or so they told me."
    
    v "They told you?"
    
    scarlett "The people who rescued me. Who brought me here."
    scarlett "They said the other passengers and crew died in the crash."
    scarlett "But now I wonder if that was true."
    scarlett "Or if they were taken somewhere else."
    
    v "Jesus, Scarlett. I'm so sorry."
    
    scarlett "The first person who helped me here was named Amanda."
    scarlett "She'd been here for six months. Knew the ropes."
    scarlett "Took me under her wing, just like I'm doing with you."
    
    v "What happened to her?"
    
    scarlett "She fell in love."
    scarlett "Real love, with another resident named Marcus."
    scarlett "They tried to keep it secret, but the cameras saw everything."
    scarlett "The viewers loved their romance. Ratings went through the roof."
    
    v "That sounds positive."
    
    scarlett "It was, until they decided to escape together."
    scarlett "They had a plan. A boat they'd been secretly repairing."
    scarlett "They almost made it off the island."
    
    v "Almost?"
    
    scarlett "Their escape attempt became the season finale."
    scarlett "Live broadcast to millions of viewers."
    scarlett "The boat explosion was spectacular, apparently."
    scarlett "Amazing television."
    
    menu amanda_story_reaction:
        "That's horrible. I'm so sorry for your loss":
            $ scarlett_love += 10
            v "No wonder you understood what I was going through."
            v "You've lost so much already."
            scarlett "But I've gained something too. Perspective."
            scarlett "And now, hopefully, a real friend."
            v "You definitely have that."
            jump family_questions
            
        "Do you think they actually died?":
            $ swift_sabotage += 5
            v "Could they have survived the explosion? Made it look realistic?"
            scarlett "I want to believe that. But I saw the wreckage."
            scarlett "There wasn't much left to identify."
            scarlett "I think they really tried to escape, and it really killed them."
            jump family_questions
            
        "Why are you telling me this?":
            v "This is a lot of heavy information. Why share it with me?"
            scarlett "Because if we're going to be more than acquaintances..."
            scarlett "You need to know what you're dealing with."
            scarlett "And what could happen if we're not careful."
            jump family_questions

label family_questions:
    
    scarlett "Victor, I need to ask you something personal."
    scarlett "Do you have family back home? People who would come looking for you?"
    
    v "I have a mother. Sarah Morrison. She lives in Seattle."
    v "We're close. She'll definitely report me missing if I don't come home."
    
    scarlett "Morrison... that's your last name?"
    
    v "Yes. Why?"
    
    scarlett "The Mayor's name is Richardson. But when I first met him..."
    scarlett "Someone called him Mayor Morrison."
    scarlett "Could be a coincidence."
    
    v "Or it could be something else entirely."
    v "You think there's a connection?"
    
    scarlett "I don't know. But Victor, you need to be very careful."
    scarlett "If someone specifically arranged for you to crash here..."
    scarlett "This could all be more personal than you think."
    
label evening_together:
    # Scene: Back at Scarlett's cottage for dinner
    # Evening transition with crickets and romantic atmosphere
    stop sound fadeout 2.0
    play sound "audio/sound_effects/evening_crickets.mp3" loop
    play music "audio/sound_effects/romantic_intimacy.mp3"
    
    scene cottage_night at bg_zoom
    show scarlett at left_close
    show victor at right_close
    $ update_character_state("victor", CharState.NORMAL)
    $ update_character_state("scarlett", CharState.NORMAL)

     
    with Fade(1.0, 0.5, 1.0)
    
    narrator "The evening finds you back at Scarlett's cottage, sharing another meal."
    
    v "Thank you for showing me around today. And for telling me about Amanda."
    v "I know that couldn't have been easy."
    
    scarlett "It wasn't. But you deserved to know what you're dealing with."
    scarlett "And honestly? It felt good to talk about her."
    scarlett "I haven't been able to do that with anyone."
    
    v "Tell me more about her. What was she like?"
    
    scarlett "Brilliant. Kind. Funny when she wanted to be."
    scarlett "She had this way of making even the worst situations bearable."
    scarlett "Kind of like what you're doing for me right now."
    
    v "I'm not doing anything special."
    
    scarlett "You're being human. You're treating me like a person."
    scarlett "Do you know how rare that is here?"
    scarlett "Most people become so focused on survival that they forget how to connect."
    
    v "Is that what happened to the Mayor?"
    
    scarlett "Exactly. He used to be like us. Scared, confused, desperate to escape."
    scarlett "But over time, the island changed him."
    scarlett "Now he's part of the system instead of fighting it."
    
    menu evening_intimacy:
        "I don't want that to happen to us":
            $ scarlett_love += 10
            v "Promise me something, Scarlett. Promise we won't lose ourselves here."
            v "Whatever it takes, we stay human."
            scarlett "I promise. As long as we have each other, we remember who we are."
            scarlett "That's what Amanda would have wanted."
            jump evening_warning
            
        "How do we avoid becoming like him?":
            v "What's the key to maintaining our identity here?"
            scarlett "Connection. Real connection with people we trust."
            scarlett "The island wants to isolate us, make us dependent."
            scarlett "Having genuine relationships is an act of rebellion."
            jump evening_warning
            
        "Do you think we could escape like Amanda tried?":
            $ swift_sabotage += 5
            v "If we planned it better, do you think we could make it off the island?"
            scarlett "Maybe. But Victor, that kind of thinking is dangerous."
            scarlett "The walls have ears here. Even in my cottage."
            scarlett "Some conversations are better saved for another time."
            jump evening_warning

label evening_warning:
    
    scarlett "It's getting late. You should get some rest."
    scarlett "Tomorrow might be... challenging."
    
    v "What happens tomorrow?"
    
    scarlett "I'm not sure. But new arrivals usually get a more thorough orientation."
    scarlett "The Mayor was being gentle today. Testing you."
    scarlett "Tomorrow, they'll want to see how you handle pressure."
    
    v "What kind of pressure?"
    
    scarlett "The kind that determines whether you're suitable for their purposes."
    scarlett "Or whether you need to be... redirected."
    
    v "Scarlett, will you stay close tomorrow? Whatever happens?"
    
    scarlett "Of course. We're a team now."
    scarlett "You don't have to face this alone."
    
label second_night:
    # Scene: Second night, threat arrives
    scene cottage_night at bg_zoom
    with fade
    
    narrator "You fall asleep more easily this time, exhaustion overcoming anxiety."
    narrator "But your rest is interrupted by a sound that doesn't belong."

    show victor at center_close
    
    v "What... what time is it?"
    v "Did I hear something?"
    
    narrator "A figure stands silhouetted in the doorway."
    
    show swift at left_close
    $ update_character_state("swift", CharState.NORMAL)
    show victor at right_close
    $ update_character_state("victor", CharState.ANGRY)
    with dissolve
    
    swift "Hello, Victor. Time for a private conversation."
    
    $ update_character_state("victor", CharState.ANGRY)
    
    v "Who are you? How did you get in here?"
    
    swift "I'm Swift. And I have keys to everything on this island."
    swift "Including Scarlett's cottage."
    
    v "Scarlett! SCARLETT!"
    
    swift "She can't hear you. Special tea in her evening drink."
    swift "Nothing harmful. Just ensures privacy for our chat."
    
    v "What do you want?"
    
    swift "To discuss your future here. And your mother's future back home."
    
    $ update_character_state("victor", CharState.SAD)
    
    v "My mother? What about my mother?"
    
    swift "Sarah Morrison, 1247 Pine Street, Seattle. Apartment 3B."
    swift "Lovely woman. Takes her morning walk at 6 AM sharp."
    swift "Very predictable routine. Easy to intercept."
    
    menu swift_threat_response:
        "You're lying. You don't know anything about my mother":
            # Denying Swift's power - bad choice, increases her sabotage
            $ swift_sabotage += 5
            swift "She has a small scar on her left wrist from a kitchen accident when you were twelve."
            swift "She calls you 'Vicky' when she's worried about you."
            swift "She keeps your first published photograph on her refrigerator."
            
            $ update_character_state("victor", CharState.SAD)
            
            v "How could you possibly know that?"
            swift "We know everything about everyone, Victor. It's what we do."
            jump swift_demands
            
        "If you hurt her, I'll kill you":
            # Threatening Swift - bad choice, increases her sabotage significantly  
            $ swift_sabotage += 50
            $ update_character_state("victor", CharState.ANGRY)
            
            swift "Such passion! The viewers will love that intensity."
            swift "But threats are unnecessary. Your mother's safety depends on your cooperation."
            swift "Cooperate, and she continues her peaceful retirement."
            swift "Resist, and she might have an unfortunate accident."
            jump swift_demands
            
        "What do you want me to do?":
            $ swift_sabotage += 5
            swift "Smart man. Cutting straight to the negotiations."
            swift "I want you to become a willing participant in our little show."
            swift "No more questions about escape. No more rebellion."
            swift "Just acceptance of your new reality."
            jump swift_demands

label swift_demands:
    
    # Tension and threat music - Swift's menacing presence
    stop sound fadeout 1.0
    play sound "audio/sound_effects/tension_rising_drama.mp3"
    
    swift "Let me be very clear, Victor. Your mother has no idea where you are."
    swift "As far as she knows, you're on assignment in a remote location."
    swift "We've been sending emails from your account. Very touching correspondence."
    
    # Phone notification sound for email mentions
    play audio "audio/sound_effects/phone_notification.mp3"
    swift "She's not worried about you. Yet."
    
    v "You've been impersonating me?"
    
    swift "For three days now. Professional work, if I say so myself."
    swift "Your writing style is quite distinctive. Easy to mimic."
    
    v "What exactly do you want from me?"
    
    swift "Tomorrow, you'll have another conversation with the Mayor."
    swift "This time, you'll be enthusiastic about staying on the island."
    swift "You'll express gratitude for the rescue and excitement about the opportunities here."
    
    v "What opportunities?"
    
    swift "Photography opportunities. Very exclusive assignments."
    swift "Documenting the intimate lives of our residents."
    swift "Creating content for our discerning viewers."
    
    v "You want me to photograph people without their consent?"
    
    swift "I want you to photograph people who have already given their consent."
    swift "Whether they remember giving it is irrelevant."
    
    menu swift_negotiation:
        "I won't exploit people like that":
            $ swift_sabotage += 5
            swift "Even if refusing means your mother pays the price?"
            swift "She's quite frail, Victor. Heart condition, I believe?"
            swift "Would be tragic if she had a cardiac episode during a mugging."
            v "You're a monster."
            swift "I'm a businesswoman. There's a difference."
            jump maya_jake_assignment
            
        "How do I know you'll keep your word?":
            swift "You don't. But you know what happens if you refuse."
            swift "Your mother's safety is directly tied to your performance."
            swift "Excel, and she lives comfortably. Resist, and she suffers."
            swift "Simple equation."
            jump maya_jake_assignment
            
        "What kind of photography are we talking about?":
            swift "Nothing too invasive at first. Lifestyle shots."
            swift "Residents at work, at play, in their living spaces."
            swift "As you prove trustworthy, assignments become more... intimate."
            swift "Eventually, you'll document their most private moments."
            jump maya_jake_assignment

label maya_jake_assignment:
    
    swift "Oh, and Victor? That lovely couple you witnessed yesterday?"
    swift "Maya and Jake? They're going to be your first assignment."
    
    v "Assignment?"
    
    swift "You're going to photograph them again. Tomorrow night."
    swift "But this time, you'll understand what you're really documenting."
    swift "Their story is central to our island's entertainment value."
    swift "And you're going to help tell it."
    
    v "What's so special about them?"
    
    swift "Maya and Jake represent the ultimate success story of our island."
    swift "They arrived as strangers, fell in love under our cameras, and chose to stay."
    swift "Their relationship is completely genuine. No coercion necessary."
    swift "They're proof that love can flourish even in captivity."
    swift "Very inspiring. Very profitable."
    
    v "And if I refuse to photograph them?"
    
    swift "Then your mother receives a visit from some very unfriendly people."
    swift "And Scarlett learns what happens to residents who harbor fugitive thoughts."
    
    v "Fugitive thoughts?"
    
    swift "Escape fantasies. Rebellion planning. Unauthorized emotional connections."
    swift "She's been walking a very dangerous line since you arrived."
    swift "Helping you could be seen as conspiracy against the island."
    
    menu final_swift_choice:
        "Fine. I'll do what you want":
            $ family_threatened = True
            $ swift_sabotage += 5
            v "I'll cooperate. But I want proof my mother is safe."
            swift "You'll receive regular updates. As long as you perform."
            swift "Welcome to the team, Victor."
            jump swift_explanation
            
        "There has to be another way":
            v "Can't we work out some kind of compromise?"
            swift "The only compromise is the speed of your compliance."
            swift "Immediate cooperation, or gradual coercion."
            swift "Either way, you end up in the same place."
            jump swift_explanation
            
        "How do I know any of this is real?":
            swift "You don't. But are you willing to bet your mother's life on it?"
            swift "Some risks aren't worth taking, Victor."
            swift "Especially when cooperation costs you so little."
            jump swift_explanation

label swift_explanation:
    
    swift "Tomorrow evening, you and I will return to observe Maya and Jake."
    swift "I'll explain their significance in more detail."
    swift "And you'll begin to understand your role in our operation."
    
    v "What is my role, exactly?"
    
    # Camera-related scene
    play audio "audio/sound_effects/camera_shutter.mp3"
    
    swift "You're going to be our new documentary photographer."
    swift "Capturing authentic moments of love, lust, heartbreak, and hope."
    swift "All for the viewing pleasure of people who pay extraordinary amounts."
    swift "People who can make problems disappear. Including your mother."
    
    # Danger reveal - dramatic realization moment
    play audio "audio/sound_effects/danger_reveal_chord.mp3"
    
    v "This is blackmail."
    
    swift "This is business. Very lucrative business."
    swift "And you're now a part of it."
    
label swifts_departure:
    swift "Get some sleep, Victor. Tomorrow is a big day."
    swift "And remember - Scarlett doesn't need to know about our conversation."
    swift "Her ignorance protects her. Knowledge makes her a liability."
    swift "Liabilities have a way of disappearing on this island."
    
    narrator "Swift exits as silently as she entered, leaving you alone with your racing thoughts."
    
    # Anxious heartbeat during psychological tension
    play audio "audio/sound_effects/anxious_heartbeat.mp3"
    
    v "My mother... they really have surveillance on her."
    v "That scar detail... no one else would know that."
    v "God, what have I gotten myself into?"
    v "And what's going to happen to Scarlett if she finds out?"
    
    narrator "Sleep doesn't return easily, but eventually exhaustion wins."
    
label third_morning:
    # Scene transition to morning
    play audio "audio/sound_effects/scene_transition.mp3"
    # Scene: Morning after Swift's visit
    scene cottage_day at bg_zoom
    with fade
    
    narrator "You wake to find Scarlett making breakfast, humming softly."
    
    show scarlett at left_close
    show victor at right_close
    $ update_character_state("victor", CharState.NORMAL)
    $ update_character_state("scarlett", CharState.HAPPY)
    with dissolve
    
    scarlett "Good morning! You look tired. Bad dreams?"
    
    v "Something like that. How are you feeling?"
    
    scarlett "Wonderful, actually. I slept more deeply than I have in months."
    scarlett "Must be the company. Having someone to care for."
    
    v "Scarlett, do you remember anything strange from last night?"
    
    scarlett "Strange how? I remember making tea and going to bed."
    scarlett "Then sleeping like a baby until sunrise."
    scarlett "Why? Did something happen?"
    
    menu morning_scarlett_interaction:
        "Tell her about Swift's visit":
            $ scarlett_love += 5
            v "Someone came to see me last night. A woman named Swift."
            scarlett "Swift was HERE? In my cottage?"
            scarlett "Victor, that's very bad. Very, very bad."
            scarlett "She drugged me. Had to, for me not to wake up."
            v "She threatened my mother. Wants me to work for them."
            scarlett "Of course she did. That's her specialty."
            jump scarlett_concern
            
        "Keep Swift's visit secret":
            $ swift_sabotage += 5
            v "No, nothing happened. Just nightmares about the boat crash."
            scarlett "Trauma can manifest in sleep. That's normal."
            scarlett "But Victor, you seem more than just tired."
            scarlett "You seem... frightened. About something specific."
            jump scarlett_concern
            
        "Ask if she's ever met Swift":
            v "Do you know someone on the island named Swift?"
            scarlett "Rachel Sterling. She's... she's dangerous, Victor."
            scarlett "Works directly for management. Specializes in coercion."
            scarlett "Why do you ask? Has she approached you?"
            jump scarlett_concern

label scarlett_concern:
    
    scarlett "Victor, I need you to be completely honest with me."
    scarlett "Did Swift threaten you? Or someone you care about?"
    
    v "She knows about my mother. Specific details."
    v "Said if I don't cooperate, something might happen to her."
    
    scarlett "Oh, Victor. I'm so sorry."
    scarlett "That's how they get everyone eventually."
    scarlett "The threats against family back home."
    
    v "Has she threatened your family?"
    
    scarlett "I don't have family left. Parents died before I came here."
    scarlett "Made me less useful for leveraging."
    scarlett "But also made me more expendable."
    
    v "What did she want from you when you first arrived?"
    
    scarlett "To become a romantic interest for the other residents."
    scarlett "Create drama, break hearts, generate content."
    scarlett "I refused. Spent a week in isolation as punishment."
    scarlett "Eventually, they decided I was more useful as a caretaker type."
    
    v "What does that mean?"
    
    scarlett "I help new arrivals adjust. Provide emotional support."
    scarlett "Makes the transition smoother. Less resistance."
    scarlett "More profitable in the long run."
    
    v "So helping me... that's part of your assignment?"
    
    scarlett "It was. Initially."
    scarlett "But Victor, what I feel for you now... that's real."
    scarlett "The island doesn't create genuine connection. It just exploits it."
    
label final_preparation:
    narrator "The day passes with a strange normalcy, but tension underlies everything."
    
    scarlett "You've been quiet today. Are you okay?"
    
    v "Just thinking about what Swift wants me to do."
    v "She wants me to photograph Maya and Jake tonight."
    
    scarlett "Their story is tragic, Victor."
    scarlett "They genuinely fell in love here, but their relationship exists for entertainment."
    scarlett "Every intimate moment broadcast to millions."
    
    v "How do they cope with that?"
    
    scarlett "They've convinced themselves they're in control."
    scarlett "That their love is real despite the circumstances."
    scarlett "Maybe it is. Maybe that's what makes it so valuable to the viewers."
    
    v "Swift said they chose to stay."
    
    scarlett "They did. After their first escape attempt failed."
    scarlett "They were given a choice: separate punishment, or accept their roles as permanent residents."
    scarlett "They chose to stay together."
    
    v "What kind of punishment?"
    
    scarlett "The kind that makes staying seem merciful."
    scarlett "Victor, tonight when you're with Swift..."
    scarlett "Remember that you're not just documenting their relationship."
    scarlett "You're documenting what we all might become."
    
label evening_with_swift:
    # Scene: Swift returns for the final voyeur scene
    # Ominous threat presence - Swift's return
    play sound "audio/sound_effects/ominous_threat_presence.mp3"
    
    scene cottage_night at bg_zoom
    with fade
    
    narrator "As darkness falls, Swift appears at the cottage door."

    show swift at left_close
    show victor at right_close
    $ update_character_state("victor", CharState.NORMAL)
    $ update_character_state("swift", CharState.NORMAL)
    with dissolve

    
    swift "Time for your education, Victor."
    swift "Scarlett, thank you for preparing him so well."
    
    scarlett "Swift."
    scarlett "Victor, remember what we talked about."
    
    swift "Oh, you've been talking about me? How flattering."
    swift "Come along, Victor. Your real education begins now."

    scene shore_night at bg_zoom
    show swift at left_close
    show victor at right_close
    $ update_character_state("victor", CharState.NORMAL)
    $ update_character_state("swift", CharState.NORMAL)
    with fade
    
    narrator "Swift leads you through the darkening streets toward the beach."
    
    swift "Maya and Jake perform their evening ritual at the same time every night."
    swift "Consistency is important for our viewers. They know when to tune in."
    
    v "How long have they been doing this?"
    
    swift "Three years. Every single night without fail."
    swift "Rain or shine, sick or well. The show must go on."
    swift "It's quite romantic, actually. In a completely fucked up way."
    
    v "Don't they ever want privacy?"
    
    swift "Privacy is a luxury they traded for survival."
    swift "Besides, they've been performing so long, I doubt they remember how to be intimate without an audience."
    
label final_voyeur_scene:
    # Scene: The climactic Maya and Jake scene with Swift's commentary

    scene scene_1
    with fade

    narrator "You arrive at the familiar spot behind the dunes."
    
    swift "There they are. Our star couple."
    swift "Watch carefully, Victor. This is what success looks like on our island."
    
    # Maya and Jake's second scene - even more explicit
    maya "Same position, different angle. You ready?"
    jake "The things we do for ratings..."
    maya "For survival. There's a difference."
    
    swift "Notice how they justify it to themselves?"
    swift "Survival, not performance. Love, not commerce."
    swift "The human capacity for self-deception is remarkable."
    
    jake "Gentle... it's been a while since we did this..."
    maya "Always, my love. Tell me if it's too much."
    maya "I want to feel you in my ass... nice and slow..."
    
    maya "Tell me if it's too much. We can stop."
    jake "Since when can we stop? The viewers paid for this."
    maya "I can always say you're not ready. I still have some control."
    jake "No... it's okay. I want your tight ass around my cock."
    
    swift "See how they negotiate consent within coercion?"
    swift "It's beautiful, really. The illusion of choice."
    
    jake "Oh... Maya... that's incredible..."
    maya "You like my tight ass squeezing your cock?"
    jake "So good... you're so fucking tight back there..."
    maya "Because I love you. Every part of you inside me."
    
    swift "True intimacy, manufactured for mass consumption."
    swift "They really do love each other, Victor. That's what makes it so valuable."
    
    maya "I love you. You know that, right? Despite all this?"
    jake "I know. It's the only thing keeping me sane."
    maya "We'll get through this. Together."
    jake "Three years and counting. How much longer?"
    maya "Until we're not profitable. Or until we die."
    jake "Cheerful thought. Let's focus on this instead."
    
    jake "Do you think anyone's watching? The cameras?"
    maya "Probably. They always watch."
    jake "Let them watch me fuck your perfect ass..."
    maya "Shh. Don't think about that. Just feel how tight I am."
    jake "You're right. This moment. Your ass feels so good around me."
    maya "Even if 'us' includes a million viewers watching you pound me."
    
    swift "And there it is. The acknowledgment of their audience."
    swift "They know they're being watched. They know they're performing."
    swift "But they've found a way to make it meaningful anyway."
    
    jake "Maya... I'm going to cum in your ass..."
    maya "Yes, baby. Fill my ass with your cum. I want it all."
    jake "Fuck... your ass is milking my cock..."
    maya "Cum for me, Jake. Give me every drop."
    jake "The cameras... they're watching me fill you..."
    maya "Let them watch. I want them to see you claim my ass."
    jake "I love you. God, I love fucking you."
    maya "I love you too. Now cum deep in my ass."
    
    swift "Perfect finish. The viewers will eat this up."
    swift "Love and lust, intimacy and exhibition, all wrapped up in one gorgeous package."
    
    narrator "As Maya and Jake recover, Swift turns to you."
    
    swift "Your job, Victor, is to capture moments like this."
    swift "The complexity, the contradiction, the raw human emotion."
    swift "Can you do that?"
    
    menu final_choice:
        "Yes, I understand what you want":
            $ family_threatened = True
            v "I'll document their story. And others like it."
            swift "Excellent. Your mother will be so proud of your new career."
            swift "Welcome to the team, photographer."
            jump meet_maya_jake
            
        "This feels wrong, but I don't have a choice":
            v "If it keeps my mother safe, I'll do what you ask."
            swift "Pragmatic. I respect that."
            swift "You'll find that moral flexibility is essential here."
            jump meet_maya_jake
            
        "What happens to people who refuse?":
            v "Just hypothetically, what if someone couldn't do this?"
            swift "Then they become subjects instead of documentarians."
            swift "Much less comfortable position, I assure you."
            swift "Would you like a demonstration?"
            jump meet_maya_jake

label meet_maya_jake:
    
    swift "Maya and Jake represent our success story."
    swift "They don't know about you yet, but you'll be documenting them."
    swift "From a distance. Invisibly. Like a nature photographer."
    swift "That's the beauty of your role - you capture without interfering."
    
    v "So I never actually meet them?"
    
    swift "Not directly. You're the invisible eye, Victor."
    swift "Documenting authentic moments requires authenticity."
    swift "If they know they're being specifically photographed, it changes the dynamic."
    swift "We want natural behavior, unguarded moments."
    
    v "But they mentioned cameras and viewers earlier."
    
    swift "The automatic surveillance, yes. They're aware of that."
    swift "But personal documentation? That's different."
    swift "More intimate. More valuable."
    
label prologue_conclusion:
    # Final scene - back at cottage
    scene cottage_night at bg_zoom
    show swift at left_close
    show victor at right_close
    $ update_character_state("victor", CharState.NORMAL)
    $ update_character_state("swift", CharState.NORMAL)
    with fade
    
    narrator "Swift escorts you back to Scarlett's cottage."
    
    swift "Remember, Victor. Your success here determines your mother's wellbeing."
    swift "But also remember - this can be a good life if you let it."
    swift "Many residents have found happiness here."
    swift "In their own way."
    
    v "What about Scarlett? What's her role in all this?"
    
    swift "Scarlett is your anchor. Your connection to humanity."
    swift "Cherish that relationship. It's rarer than you know."
    swift "But don't let it make you stupid."
    swift "Stupid people don't last long on this island."

    hide swift
    hide victor
    with dissolve
    
    narrator "Swift disappears into the night, leaving you at Scarlett's door."

    scene cottage_night at bg_zoom
    show scarlett at left_close
    show victor at right_close
    $ update_character_state("victor", CharState.NORMAL)
    $ update_character_state("scarlett", CharState.HAPPY)
    with dissolve
    
    $ update_character_state("scarlett", CharState.HAPPY)
    
    scarlett "How was it?"
    
    $ update_character_state("victor", CharState.SAD)
    
    v "Educational. Horrifying. Eye-opening."
    v "I understand now why you wanted to prepare me slowly."
        
    scarlett "What happens next?"
    
    v "I become their photographer. Document the residents' lives."
    v "Create content for people who pay to watch other people suffer."
    
    $ update_character_state("scarlett", CharState.HAPPY)
    
    scarlett "Victor, I need you to know something."
    scarlett "Whatever you have to do to survive here... I understand."
    scarlett "And I'll help you maintain your humanity through it."
    
    $ update_character_state("victor", CharState.HAPPY)
    
    v "How do you do that? Maintain humanity in a place like this?"
    
    $ update_character_state("scarlett", CharState.HAPPY)
    
    scarlett "By remembering what love feels like."
    scarlett "By protecting the people who matter."
    scarlett "By finding moments of genuine connection despite the circumstances."
    
    $ update_character_state("victor", CharState.AROUSED)
    
    v "Is that what we have? Genuine connection?"
    
    $ update_character_state("scarlett", CharState.AROUSED)
    
    scarlett "I hope so. It's the most valuable thing on this island."
    scarlett "And the most dangerous."
    
    narrator "As you prepare for sleep, you reflect on everything that's changed."
    narrator "Three days ago, you were a free man with a simple life."
    narrator "Now you're trapped on an island, blackmailed into compliance, but not entirely alone."
    
    v "Whatever happens next, at least I have Scarlett."
    v "And maybe that's enough to keep me human."
    v "Maybe that's enough to survive."
    
    scene black
    with fade
    
    narrator "Your new life begins tomorrow."
    narrator "The island is waiting."
    
    return
