# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [7.1.1-36](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-35...7.1.1-36) - 2024-07-27

### Merged

- Silence warning when freetype delegate is disabled. [`#7515`](https://github.com/ImageMagick/ImageMagick/pull/7515)
- Fixed typo in documentation of MagickAdaptiveBlurImage [`#7500`](https://github.com/ImageMagick/ImageMagick/pull/7500)
- uhdr.c: default initialize range field for hdr/sdr intent inputs to enc [`#7482`](https://github.com/ImageMagick/ImageMagick/pull/7482)

### Commits

- beta release [`8c7c516`](https://github.com/ImageMagick/ImageMagick/commit/8c7c516574691aec1500ffac0fdfbac87e292aea)
- Code style changes. [`ed85e19`](https://github.com/ImageMagick/ImageMagick/commit/ed85e19963029d6c80849ff12376c2ede791c954)
- Code style changes. [`22e268e`](https://github.com/ImageMagick/ImageMagick/commit/22e268e52b4bdb20f2079cff402dd5341ee6dd33)
- Code style changes. [`2892b76`](https://github.com/ImageMagick/ImageMagick/commit/2892b76495ad3de301d4dcf2ae0fb2a745c02bad)
- Code style changes. [`2ef6fca`](https://github.com/ImageMagick/ImageMagick/commit/2ef6fcac18ba3a859c412f900d50e3aa30b5fa8c)
- Code style changes. [`e496826`](https://github.com/ImageMagick/ImageMagick/commit/e49682682974f16581e6262dfc44b6df5c810398)
- point to the correct ImageMagick-7.?.? path [`4f6a116`](https://github.com/ImageMagick/ImageMagick/commit/4f6a1160936ecfa4b89388977d24a63dca073a97)
- configure AppRun to reflect the correct configure and library paths [`efc2676`](https://github.com/ImageMagick/ImageMagick/commit/efc26763e989c1facdcc6ae115de4488a1ff677f)
- do not append empty paths [`72c5594`](https://github.com/ImageMagick/ImageMagick/commit/72c559456b60900ba4b77f32d6ac44f58e1e581e)
- Only request a unique file name when system:shred is not set. [`bc3df5d`](https://github.com/ImageMagick/ImageMagick/commit/bc3df5d42dbb7952b427d5d77a44bbca942a56ac)
- Improved error message (#7491) [`67cadcb`](https://github.com/ImageMagick/ImageMagick/commit/67cadcbb1c5caf0cc28f842cc3c8ce70c29e5cf9)
- ensure no empty paths in the environment [`6526a2b`](https://github.com/ImageMagick/ImageMagick/commit/6526a2b28510ead6a3e14de711bb991ad9abff38)
- Removed check for ancient Visual Studio version. [`9291449`](https://github.com/ImageMagick/ImageMagick/commit/9291449dd1afc3bdcb719fdf66853f45479f1293)
- correct link [`1066464`](https://github.com/ImageMagick/ImageMagick/commit/106646455b486eed479a5b26bdab55a0f9c7a3be)
- The -format option is hybrid operator and info operator [`fbc6695`](https://github.com/ImageMagick/ImageMagick/commit/fbc6695d8edfa7362cbdd7312b1c82e74b4bd601)
- cosmetic [`41db2bf`](https://github.com/ImageMagick/ImageMagick/commit/41db2bfaa65ec61a542ce18efd7454539741ac23)
- bounds check [`9a743b9`](https://github.com/ImageMagick/ImageMagick/commit/9a743b9290998355439cd33944aa1a46dc23e940)
- set image orientation on write [`32591b8`](https://github.com/ImageMagick/ImageMagick/commit/32591b858b7e9d73c00fd69a7d6ea9bf299b7d31)
- support 12 & 16 bit JPEG images [`da58a80`](https://github.com/ImageMagick/ImageMagick/commit/da58a8015dbae423ebf7ecc66c8aa613627f9bef)
- don't scale 8-bit pixels [`da451cc`](https://github.com/ImageMagick/ImageMagick/commit/da451cc15500afc70cfd332c68c81c990ea6379f)
- don't ping for -format option [`7caf7a2`](https://github.com/ImageMagick/ImageMagick/commit/7caf7a27ed4ed6436cb96d8efb1bbb9e98306f0a)
- fix grayscale images [`7aae5ff`](https://github.com/ImageMagick/ImageMagick/commit/7aae5ff96590e0f1624810e67cf8a4bd2c0bab08)
- Fixed build on Windows. [`00ac8d0`](https://github.com/ImageMagick/ImageMagick/commit/00ac8d0cbc3dc4c4ff7f145b7f44f2309fb1f57f)
- Another fix for grayscale images. [`42c30be`](https://github.com/ImageMagick/ImageMagick/commit/42c30be7ef6a5d272d2a21dedce23f5023cb5723)
- restore JPEG grayscale colormap [`c0b1d44`](https://github.com/ImageMagick/ImageMagick/commit/c0b1d4491339de1be231d169029d8e44bfd91d40)
- default to channels other than 1 & 4 [`2245dd6`](https://github.com/ImageMagick/ImageMagick/commit/2245dd61e0393170fde8272e6871b6710a5a66e1)
- interpret EMF documents under Linux [`f288420`](https://github.com/ImageMagick/ImageMagick/commit/f28842046f0f78d06e85baafe1d3f648c8befc36)
- support WMF delegate [`8f26c46`](https://github.com/ImageMagick/ImageMagick/commit/8f26c4633b660fcdeb6f280b5a9baca2c73b7f07)
- release [`852a4e9`](https://github.com/ImageMagick/ImageMagick/commit/852a4e91b1cdb0c055a27dae956f130941e66ac0)

## [7.1.1-35](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-34...7.1.1-35) - 2024-07-14

### Commits

- beta release [`b6647e5`](https://github.com/ImageMagick/ImageMagick/commit/b6647e5ffc664a65b4dca826ed3f5cc49677933b)
- Also set dpi-x and dpi-y when running rsvg-convert. [`eac001f`](https://github.com/ImageMagick/ImageMagick/commit/eac001fbba9ce5497010f575987489a577f4109c)
- `convert` sub-command is deprecated [`d67039e`](https://github.com/ImageMagick/ImageMagick/commit/d67039ed4ba75286208afd263b751c631a8e26a3)
- only operators should disable "identify ping" (https://github.com/ImageMagick/ImageMagick/issues/7441) [`a262192`](https://github.com/ImageMagick/ImageMagick/commit/a262192e38e5f4af52f93accd3dc96e65c0c9300)
- cosmetic [`e3558d2`](https://github.com/ImageMagick/ImageMagick/commit/e3558d23e797ecf082f15c8432629f7942a91464)
- fix compiler error [`ecc21c7`](https://github.com/ImageMagick/ImageMagick/commit/ecc21c7db48c63cc9d93c131ae4d453f55f0c573)
- -outdir deprecated [`9980efa`](https://github.com/ImageMagick/ImageMagick/commit/9980efa871fd0661fa06e458e9d3bac8a1490c8d)
- Get the correct width and height when heic:preserve-orientation is set to true. [`ed3a0dd`](https://github.com/ImageMagick/ImageMagick/commit/ed3a0dd1d3a5459cf435d8ce979feda247bb27b9)
- Set heic image orientation using transform information. [`ba470aa`](https://github.com/ImageMagick/ImageMagick/commit/ba470aad4e47dacfee152ca7296e590d75aea86b)
- Exit earlier when the symlink could not be created when invoking the svg:decode delegate. [`8a48edd`](https://github.com/ImageMagick/ImageMagick/commit/8a48eddf90d5c885c14125ecca95edab098eceac)
- Fixed MSYS2 build error. [`3b22378`](https://github.com/ImageMagick/ImageMagick/commit/3b22378a23d59d7517c43b65b1822f023df357a0)
- Also set the DNG properties when pinging the image. [`fc1c61b`](https://github.com/ImageMagick/ImageMagick/commit/fc1c61baf0b08951b08ee24150a2e3964f655e05)
- Silence warning when lqr delegate is disabled. [`ae0d69a`](https://github.com/ImageMagick/ImageMagick/commit/ae0d69a53f0c172b683410c219e53066ce57be6b)
- Added version check for the heif_properties.h include. [`656b4d2`](https://github.com/ImageMagick/ImageMagick/commit/656b4d231cc6e135de6b5199b446a7353f82a4a8)
- Make sure we always use the i64 version of the "file methods" on Windows. [`b3e8a78`](https://github.com/ImageMagick/ImageMagick/commit/b3e8a7800de47af50bdd344ecd059b5481c054f7)
- Changed defines to use method instead of a define. [`75b66c4`](https://github.com/ImageMagick/ImageMagick/commit/75b66c456a19527e322741326615d664de60789c)
- Changes due to upgrade of libheif. [`841f033`](https://github.com/ImageMagick/ImageMagick/commit/841f033f09ee8c04d7b06c6b6157f152a05897f7)
- smooth the rendering of an ellipse (https://github.com/ImageMagick/ImageMagick/issues/7465) [`1bfce2a`](https://github.com/ImageMagick/ImageMagick/commit/1bfce2a62739ca8506ff696171acdfd6d15345af)
- release [`d775d2a`](https://github.com/ImageMagick/ImageMagick/commit/d775d2ac6fc0ca1790ec9a248b34b8c3bd391566)

## [7.1.1-34](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-33...7.1.1-34) - 2024-06-23

### Merged

- Updated FontConfig query to include font index, fixing (#7374) [`#7409`](https://github.com/ImageMagick/ImageMagick/pull/7409)
- Bump azure/trusted-signing-action from 0.3.19 to 0.3.20 [`#7388`](https://github.com/ImageMagick/ImageMagick/pull/7388)
- Fix a typo in `convert` deprecation warning [`#7383`](https://github.com/ImageMagick/ImageMagick/pull/7383)
- Bump azure/trusted-signing-action from 0.3.18 to 0.3.19 [`#7348`](https://github.com/ImageMagick/ImageMagick/pull/7348)

### Commits

- beta release [`0ae65ef`](https://github.com/ImageMagick/ImageMagick/commit/0ae65ef83b6452495a05f9452bcf7f0ad7822a51)
- create inline pixel colorspace conversion methods [`50b0bcb`](https://github.com/ImageMagick/ImageMagick/commit/50b0bcb450469d5f25dd42c3c1b3125d6b3a5522)
- generic colorspace conversion is too complex to inline, make them private instead [`4341e45`](https://github.com/ImageMagick/ImageMagick/commit/4341e45bca85315dc208a0c7f4e446b58968aea3)
- support compose:colorspace define for -compose colorize operation [`2e7c091`](https://github.com/ImageMagick/ImageMagick/commit/2e7c091a583ec0dda6f05edd46dd8a6435dde4d5)
- eliminate compiler exception [`3140c78`](https://github.com/ImageMagick/ImageMagick/commit/3140c78018fd03b0aad571a84bafb881cb4eae6c)
- Fixed build. [`e8a7193`](https://github.com/ImageMagick/ImageMagick/commit/e8a7193381a43e6bf596c4bb5b5a81186f024fac)
- Use an environment for the federated credential of Azure because there is no support for wildcards of tags in Azure. [`71a955a`](https://github.com/ImageMagick/ImageMagick/commit/71a955a5fb273c02ec00d69043b5f23861e19703)
- Removed define declaration. [`f228650`](https://github.com/ImageMagick/ImageMagick/commit/f2286509e8f61bd9e3210b07f776dbfee6d16235)
- Simply checks for readability. [`486c5d7`](https://github.com/ImageMagick/ImageMagick/commit/486c5d72e5b5de5d6e2a5f79016df655a346c8f5)
- correct comment [`1160213`](https://github.com/ImageMagick/ImageMagick/commit/1160213dc6a3a80aafbb346562dfd615b33b6c35)
- update image signature (https://github.com/ImageMagick/ImageMagick/issues/7344) [`ea1ecf5`](https://github.com/ImageMagick/ImageMagick/commit/ea1ecf5d8b9b457164d94c964dbf33e1ac78c00e)
- No longer use the error_code of the picture when WebPEncode was not called. [`a199044`](https://github.com/ImageMagick/ImageMagick/commit/a199044245a62633fead3fec9b79ae8641078add)
- Only set the progress_hook in the webp coder when the progress_monitor of the image is set. [`04122fa`](https://github.com/ImageMagick/ImageMagick/commit/04122faaf5a5a0ea6dec0b32745479c99b325471)
- Some more tweaks to improve error reporting in the webp coder. [`ccb1984`](https://github.com/ImageMagick/ImageMagick/commit/ccb198483227bd479efb3b1cd61679f2af1d6f8d)
- Also check for mmap with AC_CHECK_FUNCS to fix detecting it when cross compiling MacOS arm64. [`bfe87ed`](https://github.com/ImageMagick/ImageMagick/commit/bfe87ed968c43de584b34fe66c903ffec3705881)
- Correct rounding error when setting the frame delay in the webp decoder (#7371) [`b39c9bc`](https://github.com/ImageMagick/ImageMagick/commit/b39c9bcd38962d65299cc83686f2ebc2fda8853f)
- Improved magick convert deprecation warning. [`ec17fd0`](https://github.com/ImageMagick/ImageMagick/commit/ec17fd0d45ed510d2d846676944487bb76d6256b)
- The solution name of Windows now contains the name of the platform. [`8ced53c`](https://github.com/ImageMagick/ImageMagick/commit/8ced53c4e6416192e1a0302a2f6f51008bce6a9f)
- Fixed issue where the color profile was not copied to all the images that would cause issues when converting from PSD to PSD and changing the colorspace with a profile. [`efb2442`](https://github.com/ImageMagick/ImageMagick/commit/efb2442c1ddb22cf17e7106b9edae7fdd09f7257)
- Correct overwriting read_info-&gt;filename to make sure we don't leave temporary files behind (#7389). [`6f5ae64`](https://github.com/ImageMagick/ImageMagick/commit/6f5ae6476e211b049ed347f70c5e6ac002a73525)
- latest autoconf update [`33119d9`](https://github.com/ImageMagick/ImageMagick/commit/33119d988baaa0e4d4df00c041cb6b9b8a411f94)
- No longer pass the commit when cloning the repositories in the Windows build. [`6aa212b`](https://github.com/ImageMagick/ImageMagick/commit/6aa212bdc7d1dd72e2e4fba1686aae6179a5d76f)
- No longer install libraqm in the macos-13 build. [`0da13f2`](https://github.com/ImageMagick/ImageMagick/commit/0da13f25ff85762d0d507b73bd12a50c2c23a918)
- There is no need to format the weight in a separate buffer. [`9fec829`](https://github.com/ImageMagick/ImageMagick/commit/9fec82991a3fdc88f51057bfa1e6c1305d4c329e)
- Corrected setting the offset for the seek operation to fix issue when reading xbm files with information between the width/height define and data (#7406) [`5fcf6ae`](https://github.com/ImageMagick/ImageMagick/commit/5fcf6ae2a93af8771b6a407eb8e14a27ced54bc2)
- fix boundary condition when resampling pixel color (https://github.com/ImageMagick/ImageMagick/issues/7415) [`3eb67c6`](https://github.com/ImageMagick/ImageMagick/commit/3eb67c6227ff7d5dee46ba111183fc0b2808eb2a)
- initialize average interpolation sum (https://github.com/ImageMagick/ImageMagick/discussions/7401) [`06c6e9f`](https://github.com/ImageMagick/ImageMagick/commit/06c6e9f354a322c0495de7e8e9dc4b067deda44e)
- only enable the alpha channel when the compression is BI_BITFIELDS or BI_ALPHABITFIELDS [`bdc6c09`](https://github.com/ImageMagick/ImageMagick/commit/bdc6c09cec64fd8e1570ee3edf5647acde336272)
- cosmetic [`d986b01`](https://github.com/ImageMagick/ImageMagick/commit/d986b0115ba076cec1b81f96e553395c8e23c71d)
- fix signature for BMP unit tests [`498877a`](https://github.com/ImageMagick/ImageMagick/commit/498877a3d1012d3af87ccc6f697d7bc9c9b49f32)
- Report error when the input file does not contain enough data instead of failing silently. (#7422) [`188378f`](https://github.com/ImageMagick/ImageMagick/commit/188378f2dd91765e3164209ab14b532c6eb53cac)
- re-enable sparse pixels (https://github.com/ImageMagick/ImageMagick/issues/7422) [`2873224`](https://github.com/ImageMagick/ImageMagick/commit/287322445a0fd1b535b328d1bb8884db803db06a)
- re-enable sparse pixels [`39a4f1c`](https://github.com/ImageMagick/ImageMagick/commit/39a4f1cb246c09c54b5acf86b83f1d5b647313ec)
- release [`b0b7b17`](https://github.com/ImageMagick/ImageMagick/commit/b0b7b1730ab858513ae99294f167a6eb0cbb745e)

## [7.1.1-33](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-32...7.1.1-33) - 2024-05-25

### Merged

- Bump caphyon/advinst-github-action from 1.1 to 2.0 [`#7326`](https://github.com/ImageMagick/ImageMagick/pull/7326)
- Bump azure/trusted-signing-action from 0.3.16 to 0.3.18 [`#7325`](https://github.com/ImageMagick/ImageMagick/pull/7325)
- Fix typo [`#7294`](https://github.com/ImageMagick/ImageMagick/pull/7294)

### Fixed

- Combine the logic of stroke-opacity and fill-opacity in opacity to resolve #7301. [`#7301`](https://github.com/ImageMagick/ImageMagick/issues/7301)

### Commits

- beta release [`2b42fc1`](https://github.com/ImageMagick/ImageMagick/commit/2b42fc1ef20606f8208463b5d97ded1ed2e9cc36)
- Set the parameters to NAN inside GetImageMean when GetImageStatistics returns null. [`ea84110`](https://github.com/ImageMagick/ImageMagick/commit/ea841107d6aa00b71e512960c8cb38774f0a0fa5)
- Made ConvertImageCommand deprecated. [`75a5c6d`](https://github.com/ImageMagick/ImageMagick/commit/75a5c6d168379dd6e74f207468444cb2cff11720)
- ping_trans_alpha should have the same size as palette. [`f95e6e4`](https://github.com/ImageMagick/ImageMagick/commit/f95e6e4a9d1129a0d2caa838fd3fb293665ed02e)
- No longer change image_colors and stop using image-&gt;colors to resolve the issue reported in #7298. [`d0c0939`](https://github.com/ImageMagick/ImageMagick/commit/d0c09390bc654d9c449f8f209a2350bfeeaa4451)
- autoconf/automake configuration update [`b9dc200`](https://github.com/ImageMagick/ImageMagick/commit/b9dc200cf91cb11044dae3cac2fa62054a243bcb)
- Updated cloning of the security Dockerfile. [`8361158`](https://github.com/ImageMagick/ImageMagick/commit/8361158ed4d1f7d229c241e3862f354392d9c898)
- Copy the bogus binary to $OUT to make sure the executable ends up in the path. [`b7af434`](https://github.com/ImageMagick/ImageMagick/commit/b7af434d6a202903b6d0cb6f60a57d05b4e2a3c3)
- Corrected oss-fuzz patch. [`77425c4`](https://github.com/ImageMagick/ImageMagick/commit/77425c48e491594f36f0e956c01ebfbc621ac96f)
- Fixed build of the security devcontainer. [`f4c70e2`](https://github.com/ImageMagick/ImageMagick/commit/f4c70e234853a0e6c04015424e62e287ca6b4f97)
- Made oss-fuzz files executable instead. [`f2d9799`](https://github.com/ImageMagick/ImageMagick/commit/f2d97999528073364296bc495120f4fde3ed0d3b)
- Build the dependencies again. [`be22d59`](https://github.com/ImageMagick/ImageMagick/commit/be22d59c1436a904ae026ee8bc114343db4e4b83)
- Set the double* arguments to NAN in case of a failure to avoid uninitialized values. [`e2f0f4c`](https://github.com/ImageMagick/ImageMagick/commit/e2f0f4c8aa5e4710c20b93ed9bcfb7f8047e5783)
- avoid text truncation for captions (https://github.com/ImageMagick/ImageMagick/issues/7304) [`2622d08`](https://github.com/ImageMagick/ImageMagick/commit/2622d08c113e1972a7adc3c7891452d19c3bf0e6)
- avoid text truncation for captions (https://github.com/ImageMagick/ImageMagick/issues/7304) [`d66f096`](https://github.com/ImageMagick/ImageMagick/commit/d66f096274e8501def25000a6ab76da7e4bc29a3)
- return artifacts, not properties (https://github.com/ImageMagick/ImageMagick/issues/7309) [`738d434`](https://github.com/ImageMagick/ImageMagick/commit/738d434e105c42d8612dd0af90a73d0266f43bd0)
- Revert patch to allow support for compilers that don't support C++11 (#7322) [`eee94e6`](https://github.com/ImageMagick/ImageMagick/commit/eee94e6199481529cffc92d2e91542b505845830)
- Use the same notation of the header in the TIFF and DNG coder. [`77cd98c`](https://github.com/ImageMagick/ImageMagick/commit/77cd98cbd82a57be4d892ed146d2f87d60efdaee)
- Whitespace... [`f559cf3`](https://github.com/ImageMagick/ImageMagick/commit/f559cf33dffb595529115d2d5ab6029e1892b4c2)
- No longer mark the dng coder as an explicit format, this will allow use to detect the format from the header of the file. [`b534afa`](https://github.com/ImageMagick/ImageMagick/commit/b534afa8cbc6a4a971ab84641873b670af3d6dca)
- Added Apple ProRAW header. [`570ea66`](https://github.com/ImageMagick/ImageMagick/commit/570ea6664ed96510c01c9a919377b2ca8c68e463)
- Still set the ExplicitFormatType flag when build without libraw. [`188888e`](https://github.com/ImageMagick/ImageMagick/commit/188888ef080dd5d2cd50d1d9cd40b2688bfee9b4)
- Revert earlier patches because of conflicts with the tiff header format. [`a25deb9`](https://github.com/ImageMagick/ImageMagick/commit/a25deb984e0fbb73ac3894523871756fa49ad57a)
- Corrected patch. [`43fd722`](https://github.com/ImageMagick/ImageMagick/commit/43fd7227e8505c6f2d16b2b633b0a9c2b210a158)
- correct spelling (https://github.com/ImageMagick/Website/discussions/100) [`d652d27`](https://github.com/ImageMagick/ImageMagick/commit/d652d274ac95b30a84e51e07332ffe235efcc569)
- alpha channel if alpha mask or 32-bit uncompressed [`87dabd9`](https://github.com/ImageMagick/ImageMagick/commit/87dabd9187010fe63f942fb84396b23e6b9e7179)
- Switch to federated credential with Trusted Signing. [`519ed4e`](https://github.com/ImageMagick/ImageMagick/commit/519ed4ea419d8b3e8f30d638e94446b6432f44a0)
- Only set the write permissions on the job that needs it. [`8dff82e`](https://github.com/ImageMagick/ImageMagick/commit/8dff82e4260fa69da169eb507316df9241544c15)
- Print error's when running the fuzzers locally. [`b5efe03`](https://github.com/ImageMagick/ImageMagick/commit/b5efe03958f16c7cf82ff5977c25825e565a81cb)
- Removed fuzzers that check a specific method because they only tend to find issues in decoders. [`ed9e302`](https://github.com/ImageMagick/ImageMagick/commit/ed9e30205d31c21bb26dc0af94a44aceb0c570f1)
- Also remove the enhance fuzzer. [`dc89aad`](https://github.com/ImageMagick/ImageMagick/commit/dc89aad244d133cf099f406d2a4767d482abbb05)
- Skip Azure CLI login in pull requests. [`0704825`](https://github.com/ImageMagick/ImageMagick/commit/0704825d8ac253c3795550e584203463a754543d)
- Corrected scene number of the images. [`89dc52c`](https://github.com/ImageMagick/ImageMagick/commit/89dc52cbb9b87d96d44280c985688996cb8d85f8)
- Removed bits_per_pixel from IconInfo. [`cc4eeb1`](https://github.com/ImageMagick/ImageMagick/commit/cc4eeb1ac351c0da97945cfc7b8a0c9dbe6b8c8e)
- Removed planes from IconInfo. [`2edf9a1`](https://github.com/ImageMagick/ImageMagick/commit/2edf9a148789f5831c8ef521b635d9f2f5c848c6)
- Removed size from IconInfo. [`9a66eaf`](https://github.com/ImageMagick/ImageMagick/commit/9a66eaf3c95d946ed4a43172b9d94ce86f4b8d07)
- Removed number_colors from IconInfo. [`68b549e`](https://github.com/ImageMagick/ImageMagick/commit/68b549ea20ef2ab067542f75a9f4966b2f785986)
- Removed colors_important from IconInfo. [`582ec1a`](https://github.com/ImageMagick/ImageMagick/commit/582ec1a1fce74598c743e6f1e54de8eab62a99bc)
- Removed width and height from IconInfo. [`44dba7c`](https://github.com/ImageMagick/ImageMagick/commit/44dba7c06feaa15d7befa391e95e92aec0ef1361)
- Removed x_pixels and y_pixels from IconInfo. [`0b11c10`](https://github.com/ImageMagick/ImageMagick/commit/0b11c1031292141aa8d86851baea6a78d8338c36)
- Removed image_size from IconInfo. [`446710f`](https://github.com/ImageMagick/ImageMagick/commit/446710f1b32325df08f32781e43eced8544a247a)
- Removed compression from IconInfo. [`bb48004`](https://github.com/ImageMagick/ImageMagick/commit/bb4800471629e7e7d4c7651677723a1c9a45b6ee)
- Removed IconInfo struct [`a53e06d`](https://github.com/ImageMagick/ImageMagick/commit/a53e06dc8ad590092489fa0631ad73f0ee0fbc06)
- Revert patch to move allocation of IconFile to the heap to reduce the size of the stack. [`750fad2`](https://github.com/ImageMagick/ImageMagick/commit/750fad260911d4bfc4e571dc4d3e58951e9f6e89)
- Removed reserved and resource_type from IconFile. [`bc58e20`](https://github.com/ImageMagick/ImageMagick/commit/bc58e20dfcb204da0bd540415c32ee9818146e5d)
- No longer allocate 1024 icon entries for all images. [`4111001`](https://github.com/ImageMagick/ImageMagick/commit/4111001795fceb3113cf6672cbc7098bc85ef016)
- Moved determining the width and height of an icon to a separate method. [`e6a0d95`](https://github.com/ImageMagick/ImageMagick/commit/e6a0d958aa071e2608d0ec42f21e328c218d854e)
- Fixed method that determines the width and height of an icon (#7341) [`cf4c1b4`](https://github.com/ImageMagick/ImageMagick/commit/cf4c1b48006ea3087ccb4001983751e1b9cceda2)
- Added missing typecast. [`0c7207d`](https://github.com/ImageMagick/ImageMagick/commit/0c7207d7982078d42fb7b92bad9760b047713ba4)
- Removed unused variables. [`e31ad51`](https://github.com/ImageMagick/ImageMagick/commit/e31ad5194bfb3618297aaa72c03bf3a549844497)
- Revert patch that was unnecessary (#7311) [`c7aa13e`](https://github.com/ImageMagick/ImageMagick/commit/c7aa13ea48301d88b71783423eaa6465183e6f6c)
- release [`057259c`](https://github.com/ImageMagick/ImageMagick/commit/057259c12960243cf55899ead99a6dc80d300a7b)

## [7.1.1-32](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-31...7.1.1-32) - 2024-05-05

### Merged

- uhdr.c: add support for rgb inputs [`#7273`](https://github.com/ImageMagick/ImageMagick/pull/7273)
- Fix GIF ICC profile reading. (https://github.com/ImageMagick/ImageMagick/issues/7281) [`#7282`](https://github.com/ImageMagick/ImageMagick/pull/7282)

### Commits

- beta release [`b71d98e`](https://github.com/ImageMagick/ImageMagick/commit/b71d98e188896982c47ea294d0a52a7fbb2c5873)
- Fixed implementation of setting the max-profile-size. [`af81e16`](https://github.com/ImageMagick/ImageMagick/commit/af81e160ce5780fed0f9cee6229cda48c47b9818)
- Update winget manifest after creating the release. [`391e6db`](https://github.com/ImageMagick/ImageMagick/commit/391e6db82aaf237e184569eaa1aba7cbe3c48811)
- Use &gt;= instead to work around precision limitations of a double. [`148a485`](https://github.com/ImageMagick/ImageMagick/commit/148a485b6bfdb557e3e40e2d04ebad9f89d01a86)
- Make it more clear we ignore the return value. [`9d3def5`](https://github.com/ImageMagick/ImageMagick/commit/9d3def5d53532c79681184b10c96f768dcb2f771)
- There is no need to throw an exception when the profile could not be added. [`9b8d9fc`](https://github.com/ImageMagick/ImageMagick/commit/9b8d9fc09a44bce8847e880b8ae5f84d10d645c3)
- Ignore the fact that the profile could not be added to the image. [`8739df5`](https://github.com/ImageMagick/ImageMagick/commit/8739df52c886e5c2c3974fd1e87852e95379c515)
- cosmetic [`116f48c`](https://github.com/ImageMagick/ImageMagick/commit/116f48cd6d67aea4d2c7d9f2232d3768e7691bb3)
- protect backslash write writing properties to MIFF (https://github.com/ImageMagick/ImageMagick/issues/7270) [`6adffe2`](https://github.com/ImageMagick/ImageMagick/commit/6adffe23652002cf0c4c6feebc018b77a3ff61bb)
- Removed beta url for Advanced Installer. [`f34d293`](https://github.com/ImageMagick/ImageMagick/commit/f34d293102cd21ca29f4cc557ce0ff756bfb6803)
- Install libtool on macos agent. [`ba03497`](https://github.com/ImageMagick/ImageMagick/commit/ba03497a583d8ecbe9f23f9a659810de0a02756b)
- Use macos-13 for the MacOS build. [`ffc2a68`](https://github.com/ImageMagick/ImageMagick/commit/ffc2a688a75f00e53484f5717d9c875a783af50a)
- Updated CFLAGS to fix the macos-13 build. [`fd0227e`](https://github.com/ImageMagick/ImageMagick/commit/fd0227e4a5d5144d1e23ff5602312d5f8517973e)
- Added version checks for itxt_length in the png coder (#7275) [`77b3f47`](https://github.com/ImageMagick/ImageMagick/commit/77b3f47a5892cada0c81f65628677746adffec6d)
- Also check the limits for the width and height of the reference grid. [`61a4517`](https://github.com/ImageMagick/ImageMagick/commit/61a4517bf38bcbeade949430e1d2dbedbb075d8d)
- respect gradient bounding box [`a9926f1`](https://github.com/ImageMagick/ImageMagick/commit/a9926f1d21a8b0b64cb2dd4a98f0c603c4d788d2)
- Removed unused or unnecessary defines for the Windows build. [`4588780`](https://github.com/ImageMagick/ImageMagick/commit/4588780a777328a661b26c4b1082230317234d37)
- Removed unnecessary check. [`d68e9d2`](https://github.com/ImageMagick/ImageMagick/commit/d68e9d242c463e758a504551bb24a4a661f623c2)
- Moved defines that are only used by our windows build to the private header file. [`625f7be`](https://github.com/ImageMagick/ImageMagick/commit/625f7beeeab8f2fd512fc14f9ec16f0a6f7465ab)
- Removed __BORLANDC__ checks [`be5b6cc`](https://github.com/ImageMagick/ImageMagick/commit/be5b6cc8f0321df39eda0adeb89cbd355037d154)
- Added missing include. [`760db30`](https://github.com/ImageMagick/ImageMagick/commit/760db30bc5b97460ffaf9567742e952a31788ddf)
- Use workarounds to silence warnings in the MSYS2 build. [`eb39a44`](https://github.com/ImageMagick/ImageMagick/commit/eb39a4405700044d02998719268c7e465512db58)
- Silence MSYS2 warning. [`8a0be27`](https://github.com/ImageMagick/ImageMagick/commit/8a0be279323da6d5dfae125f01271d9250722663)
- Corrected fix. [`865dd6b`](https://github.com/ImageMagick/ImageMagick/commit/865dd6b0948ca1507ac1661f198670ba95ce1c26)
- Moved locale specific defines for the Windows build to locale.c [`42ab959`](https://github.com/ImageMagick/ImageMagick/commit/42ab959417062c306a9a8f95964e3180a59fb2ae)
- Moved mime specific define for the Windows build to mime.c [`d98a6dc`](https://github.com/ImageMagick/ImageMagick/commit/d98a6dc1a4bbf0a2872255944588344a293613d1)
- Moved blob specific defines for the Windows build to blob.c [`a4c84b6`](https://github.com/ImageMagick/ImageMagick/commit/a4c84b6484c3107d385cf0cf924724b65d8e2350)
- eliminate compiler warnings [`b9d4839`](https://github.com/ImageMagick/ImageMagick/commit/b9d4839103be547f696f8bf0c68e113eda9b50f7)
- Use the new OpenEXRCore api that allows meta channel support when reading exr files (only when OpenEXR is version 3.1.0 or higher) [`662ee5a`](https://github.com/ImageMagick/ImageMagick/commit/662ee5a445a160575fb67e5b333ea6b760169f19)
- Disable -Werror for the macos-13 build. [`80b7ad5`](https://github.com/ImageMagick/ImageMagick/commit/80b7ad564764ee0a24994c4c2feabf145a3eeb89)
- Added hack for bugged OPENEXR_VERSION_HEX. [`3570e33`](https://github.com/ImageMagick/ImageMagick/commit/3570e33f1f56c6d67c05c9997915e757792fe362)
- Use our own version of half to float to avoid using the half.h headerfile [`c50fb81`](https://github.com/ImageMagick/ImageMagick/commit/c50fb81ceb350aebb66447a010d723a74465af7d)
- Fix to enable the alpha channel with the OpenEXRCore api. [`87e13b5`](https://github.com/ImageMagick/ImageMagick/commit/87e13b597729b81085e90395b47e73e8e8e2232c)
- Added check for the number of layers to the jp2 coder. [`9cf8cc5`](https://github.com/ImageMagick/ImageMagick/commit/9cf8cc5b583b12d6ab9d3eea9f5e39cded360284)
- Fixed possible memory leak. [`56c6052`](https://github.com/ImageMagick/ImageMagick/commit/56c6052605ff19c5616ad90c1ce84e1eb1dc34f8)
- restore ImageMagick RPM builds [`3404101`](https://github.com/ImageMagick/ImageMagick/commit/3404101ec00456879e736943ac6825fb90d1eeb3)
- revert [`4ec73e1`](https://github.com/ImageMagick/ImageMagick/commit/4ec73e1693687b8e51e677ad9ed5b78aa6c92e3a)
- restore PerlMagick build [`f48af39`](https://github.com/ImageMagick/ImageMagick/commit/f48af39436775e913bba4bd4b4a1fbedf0b38f21)
- cosmetic [`345cd90`](https://github.com/ImageMagick/ImageMagick/commit/345cd9022e008d692b5140254d3ff8bdc9c88d91)
- No longer allow unlimited sizes for certain fuzzing targets. [`7b47774`](https://github.com/ImageMagick/ImageMagick/commit/7b47774cbd4a7061a150f87063f0ffc693f35585)
- Improve readability of the code. [`2924538`](https://github.com/ImageMagick/ImageMagick/commit/292453847a6575d052f2a0de2a552152203e9312)
- Use to_string instead of our custom implementation. [`af2139c`](https://github.com/ImageMagick/ImageMagick/commit/af2139ce1c38bee8827770889cc8f136e7fe3b68)
- Added missing calls to opj_destroy_cstr_info. [`86dba81`](https://github.com/ImageMagick/ImageMagick/commit/86dba813fe00787f42806e07cb037e3e41ff7e21)
- Allow a larger buffer to make it possible to overflow our MagickPathExtent buffers in oss-fuzz. [`dde3fb3`](https://github.com/ImageMagick/ImageMagick/commit/dde3fb325d18097cff3a8f3af40e935278d1bc98)
- Simplify length checks. [`3e010ee`](https://github.com/ImageMagick/ImageMagick/commit/3e010ee937315fe7bb108cb66d07be9566131293)
- Reduce size of label to avoid timeouts. [`1fe8d52`](https://github.com/ImageMagick/ImageMagick/commit/1fe8d529324fdd1a40baff52848a6f59e4704c48)
- Added early exits when a too large image size is specified. [`dca3b9a`](https://github.com/ImageMagick/ImageMagick/commit/dca3b9a25b4c41411a2c631ceb68f507cc3475cb)
- Removed call to DestroyStringInfo that should not be done when using SetImageProfilePrivate. [`7b5cf98`](https://github.com/ImageMagick/ImageMagick/commit/7b5cf98a62896386ba7a473f18ca0e0c94902236)
- There is no need to do the for loop in a reverse order. [`ce02c1d`](https://github.com/ImageMagick/ImageMagick/commit/ce02c1d1914a488a4c014e0931dcf565b8a6c387)
- Create bogus Ghostscript command to fix incorrect Command injection oss-fuzz issues. [`066ead9`](https://github.com/ImageMagick/ImageMagick/commit/066ead938b553e6ee2bd5d6a9c19a8875da867db)
- Require index channel when PSD mode is IndexMode. [`3a1925f`](https://github.com/ImageMagick/ImageMagick/commit/3a1925fe03ef2d93e9387264e387106df80ec673)
- Made it easier to get an image when debugging some of our fuzzers. [`610020e`](https://github.com/ImageMagick/ImageMagick/commit/610020e50fc6bb409303136bef0ef0102c1f07f9)
- Use if defined instead. [`416faeb`](https://github.com/ImageMagick/ImageMagick/commit/416faeb3cff074a2aad2fa008fedb75252ea84e9)
- Use if defined for all the other checks also. [`bacef9e`](https://github.com/ImageMagick/ImageMagick/commit/bacef9eb7565b34b1c4c9a8fa5ceccbc4fc5b6b2)
- Corrected patch that was added for #6538 to make sure we only free the memory when the blob was never used. [`6e39633`](https://github.com/ImageMagick/ImageMagick/commit/6e39633bb7784f49eacbe7fa72dc57298ba5b6ee)
- Cosmetic. [`e1de8c5`](https://github.com/ImageMagick/ImageMagick/commit/e1de8c5eb9cdd29e943ce494cb25272f0a74d0c8)
- release [`178bb32`](https://github.com/ImageMagick/ImageMagick/commit/178bb329c7b80314711b036bd1c37107df76a6bc)

## [7.1.1-31](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-30...7.1.1-31) - 2024-04-21

### Merged

- Convert big PDF documents is slow [`#7263`](https://github.com/ImageMagick/ImageMagick/pull/7263)
- ci: fix git version [`#7260`](https://github.com/ImageMagick/ImageMagick/pull/7260)
- Update release.yml [`#7258`](https://github.com/ImageMagick/ImageMagick/pull/7258)
- Update README.md [`#7245`](https://github.com/ImageMagick/ImageMagick/pull/7245)
- uhdr.c: verify the availability of error message before accessing it [`#7229`](https://github.com/ImageMagick/ImageMagick/pull/7229)
- Bump caphyon/advinst-github-action from 1.0 to 1.1 [`#7227`](https://github.com/ImageMagick/ImageMagick/pull/7227)

### Commits

- beta release [`72f0e8c`](https://github.com/ImageMagick/ImageMagick/commit/72f0e8cad9277855e0cafdc7c3db7158952bb6fb)
- Don't create the msixbundle in a pull request. [`68b628a`](https://github.com/ImageMagick/ImageMagick/commit/68b628af7741f439ccffbc760a59d007cd868aa0)
- Register format in uppercase. [`5feb82d`](https://github.com/ImageMagick/ImageMagick/commit/5feb82d4e618ec6cbafcc7cc8207fc0569589905)
- set perl install base to that of ImageMagick's [`2d5edb2`](https://github.com/ImageMagick/ImageMagick/commit/2d5edb26e22dd34ac1e43936b5c461bf0dbdb03a)
- Corrected check for warning when png:compression-filter is invalid (#7236). [`e64520d`](https://github.com/ImageMagick/ImageMagick/commit/e64520d2a0aa25901f3e3c09fcd6ab56609cec7d)
- Code cleanup. [`e25ee03`](https://github.com/ImageMagick/ImageMagick/commit/e25ee0389412f6db88db5e0c447f49fa4670a842)
- Call heif_context_set_maximum_image_size_limit to limit high dimensions earlier. [`5dda16b`](https://github.com/ImageMagick/ImageMagick/commit/5dda16b02c247c070e501841ff2a4c1bcc3ec834)
- Removed outdated files. [`f71ca65`](https://github.com/ImageMagick/ImageMagick/commit/f71ca6525321b33c818859d16b5d75e475531445)
- Removed outdated files. [`5e2c1c8`](https://github.com/ImageMagick/ImageMagick/commit/5e2c1c8624530bbea89da85d171a4f2678b4c631)
- compare SSIM score of 1 indicates perfect structural similarity [`c2e7eb3`](https://github.com/ImageMagick/ImageMagick/commit/c2e7eb348f5e65fa979d3e25a34c45e935ef5068)
- Also allow tiff:assume-alpha when there is more than one meta channel (#7247). [`5e6b281`](https://github.com/ImageMagick/ImageMagick/commit/5e6b281598c43a0500ff99951fa920f96e113138)
- Removed unused advinst-enable-automation setting. [`d920185`](https://github.com/ImageMagick/ImageMagick/commit/d9201854c9634a8c358b309ed755f13153cca83b)
- Code cleanup. [`263349c`](https://github.com/ImageMagick/ImageMagick/commit/263349c71d7bedac439b718f21a4c2730ebb61c5)
- Switch to the new action. [`e8443b8`](https://github.com/ImageMagick/ImageMagick/commit/e8443b8182c6c96db670b8b23389995f2ece959c)
- latest autoconf/automake [`36a4d10`](https://github.com/ImageMagick/ImageMagick/commit/36a4d10803a2b0f2bfb5779939e1200d9e71528a)
- fix missing C++ pop (https://github.com/ImageMagick/ImageMagick/issues/7230) [`ad3fbfc`](https://github.com/ImageMagick/ImageMagick/commit/ad3fbfc1ff4af00e25ee48fd7205a7e3f21f65c9)
- Added new security policy setting called max-profile-size that can be used to limit the size of a profile. [`8cadb7b`](https://github.com/ImageMagick/ImageMagick/commit/8cadb7b5eb419b92ed9aa25d0b6bd78791c03664)
- Added new private method AcquireProfileStringInfo that should be used when a StringInfo is created for a profile. [`e84be98`](https://github.com/ImageMagick/ImageMagick/commit/e84be98a67e7c78f68dd7307301946f4fb84bf20)
- Added SetImageProfilePrivate that won't make a copy of the StringInfo but adds it to the profiles of the image directly. [`8ff39f2`](https://github.com/ImageMagick/ImageMagick/commit/8ff39f2d925f0e75a4cac2aaf4d6f7d929c21dad)
- Also check the max profile size when it's being added to the image profiles. [`534b3de`](https://github.com/ImageMagick/ImageMagick/commit/534b3dec06f4135bed129c761ebec80cff0e1925)
- Use AcquireProfileStringInfo in Wand where possible. [`52958ec`](https://github.com/ImageMagick/ImageMagick/commit/52958ec705815bbc7e923288bfe046c205d9253f)
- Silenced warning. [`44ff5ea`](https://github.com/ImageMagick/ImageMagick/commit/44ff5ea80f373d16e51194bf3f8b12e213275a63)
- Added extra checks for empty or null profile. [`429586e`](https://github.com/ImageMagick/ImageMagick/commit/429586e3266e38ac249173a7b49e1e10011eed87)
- Added BlobToProfileStringInfo that should be used instead of BlobToStringInfo when the StringInfo will be used to add a profile to an image. [`5dd1365`](https://github.com/ImageMagick/ImageMagick/commit/5dd136542ce0f7297a0a6bc06a4b7b6a522b5a5d)
- Only create the profile when we need to and refactored the code to simply it. [`9609c83`](https://github.com/ImageMagick/ImageMagick/commit/9609c83885736214d16bd1d5e6eafdfb50639ba7)
- Added name argument to AcquireProfileStringInfo and BlobToProfileStringInfo. [`9e32ee2`](https://github.com/ImageMagick/ImageMagick/commit/9e32ee298955f113b2dba3398323fc43aa574781)
- Restore check because it is possible that the StringInfo gets resized. [`3e53d72`](https://github.com/ImageMagick/ImageMagick/commit/3e53d721f7093b46725507baf1b78c8f2acc1e5b)
- Reverted incorrect patch. [`87346c9`](https://github.com/ImageMagick/ImageMagick/commit/87346c9a34cb2e018585e96a06dbf70825d3b211)
- Added missing call to DestroyStringInfo. [`99f8ac8`](https://github.com/ImageMagick/ImageMagick/commit/99f8ac8d0fb8c0a20312648d3f5beccce159d7da)
- Fixed rare memory leak. [`c8622bf`](https://github.com/ImageMagick/ImageMagick/commit/c8622bfb37bc88a6e3377af47421adc5c76cfa92)
- Minor refactoring. [`ab6a6ba`](https://github.com/ImageMagick/ImageMagick/commit/ab6a6ba6560d08aabfef9826c46f8874cf2fcdad)
- Use the new StringInfo method for profiles in the coders. [`2a29ced`](https://github.com/ImageMagick/ImageMagick/commit/2a29ced3a534fab10fb332c4d61f726252050fb3)
- Added missing null check and require a minimum size of 6 when reading the png exif profile (#7252). [`790ee7e`](https://github.com/ImageMagick/ImageMagick/commit/790ee7e1f2b3cb263cb072f32fed23f0446c4d09)
- Set the jp2_image to NULl before passing it to opj_read_header because this expects that the pointer is set to null (#7253). [`a98abb9`](https://github.com/ImageMagick/ImageMagick/commit/a98abb9d9ea4ae80ecf3f88763ad49eafcdbebda)
- Moved warning to the correct spot and added french translation. [`a1474ba`](https://github.com/ImageMagick/ImageMagick/commit/a1474ba20f829f7c0ddc129bdf477870a87aa9af)
- Added extra checks for when the call to SetPixelMetaChannels fails. [`ddbfee9`](https://github.com/ImageMagick/ImageMagick/commit/ddbfee9e8809dab174585da6f93021b5ec49585e)
- throw warning if too many meta channels [`d215531`](https://github.com/ImageMagick/ImageMagick/commit/d21553188af7ee735b31a45b1bb74801c1876af4)
- check for possible range error (#https://github.com/ImageMagick/ImageMagick/issues/6341) [`5ab109d`](https://github.com/ImageMagick/ImageMagick/commit/5ab109d03847f8b4c6401a34cffa833c0e1a09c7)
- latest documentation [`58e7ea2`](https://github.com/ImageMagick/ImageMagick/commit/58e7ea218aa1852bcd103893e350d7951a07cde3)
- Add an extra call CastDoubleToUnsigned to address the possible range issue from #6341. [`46564e7`](https://github.com/ImageMagick/ImageMagick/commit/46564e756c98059544dc0f344855eb7a6a15fd9d)
- ensure number of meta channels does not exceed maximum [`ddeb6f3`](https://github.com/ImageMagick/ImageMagick/commit/ddeb6f3b9a58858add6f4d51089c72c1c64a781c)
- improved range checking (https://github.com/ImageMagick/ImageMagick/issues/6341) [`ae164b0`](https://github.com/ImageMagick/ImageMagick/commit/ae164b0c76ac3a23dfdb5416c8882c3e936d652f)
- check for value &lt; 0, ceil() not required (https://github.com/ImageMagick/ImageMagick/issues/6341) [`bb947bd`](https://github.com/ImageMagick/ImageMagick/commit/bb947bd9a78bcac7e9ce9781fbf10ecb2e1ab662)
- fix undefined behaviors when casting double to size_t (https://github.com/ImageMagick/ImageMagick/issues/6341) [`88ffe46`](https://github.com/ImageMagick/ImageMagick/commit/88ffe46c8e964f0172b9a9520a39157b4bb928de)
- initialize decompression before importing profiles [`eb224a5`](https://github.com/ImageMagick/ImageMagick/commit/eb224a5545ba0e11a04dcb45b7a3abceeba3ec45)
- Do the ceil first to make sure we return a floored instead of ceiled value. [`edfe245`](https://github.com/ImageMagick/ImageMagick/commit/edfe245498b9f6cf11882d6f8b5be72b222099f4)
- Use a different path for positive and negative values. [`df115fe`](https://github.com/ImageMagick/ImageMagick/commit/df115fe7144419eba02292b4dc5991182b680cb6)
- corrected connected components labeling perimeter and circularity calculation (https://github.com/ImageMagick/ImageMagick/issues/7259) [`f500892`](https://github.com/ImageMagick/ImageMagick/commit/f5008929ac1cf4e37530da8e357f27879d773891)
- Corrected code style and fixed the option check. [`918fa66`](https://github.com/ImageMagick/ImageMagick/commit/918fa669dcf22745e8114898eca0f5089897316f)
- Corrected value of recursive argument. [`94e295b`](https://github.com/ImageMagick/ImageMagick/commit/94e295b8210c7302b7892455d22b48dfe5e2ced9)
- Corrected reading nested profiles. [`203d7f5`](https://github.com/ImageMagick/ImageMagick/commit/203d7f56934dad2e02f478d6d6bc24a75f4842d4)
- Revert "initialize decompression before importing profiles" [`7524992`](https://github.com/ImageMagick/ImageMagick/commit/7524992e5bf690925ddc31f1aee28b485041c2ee)
- Refactor cleanup code in the jpeg decoder. [`f484898`](https://github.com/ImageMagick/ImageMagick/commit/f4848985cea26d2c193ebb763a534342243eeef3)
- Use AcquireStringInfo instead. [`4b107c8`](https://github.com/ImageMagick/ImageMagick/commit/4b107c821596f778cf20bb8cf73ea6572d293946)
- Make it more clear we don't use the return value of jpeg_read_header. [`46db807`](https://github.com/ImageMagick/ImageMagick/commit/46db807b1152b69466a53b7ac771bed62819bb5e)
- release [`2f6d2de`](https://github.com/ImageMagick/ImageMagick/commit/2f6d2de838390a054af74822e80d74b7799633cb)

## [7.1.1-30](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-29...7.1.1-30) - 2024-04-07

### Merged

- Updates to uhdr.c [`#7217`](https://github.com/ImageMagick/ImageMagick/pull/7217)
- Bump azure/azure-code-signing-action from 0.3.0 to 0.3.1 [`#7206`](https://github.com/ImageMagick/ImageMagick/pull/7206)
- add support for encoding/decoding ultrahdr images [`#7198`](https://github.com/ImageMagick/ImageMagick/pull/7198)
- Fix bmp option to bypass file size check [`#7194`](https://github.com/ImageMagick/ImageMagick/pull/7194)
- install perl module into user-specified prefix [`#7192`](https://github.com/ImageMagick/ImageMagick/pull/7192)
- Bump softprops/action-gh-release from 1 to 2 [`#7160`](https://github.com/ImageMagick/ImageMagick/pull/7160)

### Commits

- beta release [`960fe0e`](https://github.com/ImageMagick/ImageMagick/commit/960fe0e30ffc7c2dea56a6f58733f630ca02530a)
- just a template for now [`f6dbdc7`](https://github.com/ImageMagick/ImageMagick/commit/f6dbdc7bc868108ef3542882e4e31d517a970e45)
- documentation update [`7da27c3`](https://github.com/ImageMagick/ImageMagick/commit/7da27c379bb7e7936cdc4bd0810d2843f58506b1)
- latest documentation [`da00ea1`](https://github.com/ImageMagick/ImageMagick/commit/da00ea1b75f7f74bec685af7f8010e4c39c67537)
- Minor improvement. [`b0edc6e`](https://github.com/ImageMagick/ImageMagick/commit/b0edc6e9f02484127706a56e10d668d1cd9929e3)
- eliminate rare memory leak [`e287a71`](https://github.com/ImageMagick/ImageMagick/commit/e287a71bfb1c1d5ce467525bc08b5ed6e0d80503)
- Correct null reference that was introduced in the previous patch. [`a7ccfab`](https://github.com/ImageMagick/ImageMagick/commit/a7ccfaba1985580cb76c2f307a96e89088979544)
- Moved allocation of IconFile to the heap to reduce the size of the stack. [`f7e336f`](https://github.com/ImageMagick/ImageMagick/commit/f7e336fc2a68166431098a51b3664123ba35cbaf)
- Added arm64 MacOS build. [`53bbd00`](https://github.com/ImageMagick/ImageMagick/commit/53bbd00260c7176e8898af1bfae3e87ee63c7611)
- Removed part that was no longer used. [`49526d4`](https://github.com/ImageMagick/ImageMagick/commit/49526d48cf59b5c53c1b391af280a9fc6cfd29a4)
- respect gradient:bounding-box define (https://github.com/ImageMagick/ImageMagick/issues/7143) [`eefb558`](https://github.com/ImageMagick/ImageMagick/commit/eefb55819568b7ce48adaa0c34421bcf5238e88d)
- threading issue with identifying grayscale (https://github.com/ImageMagick/ImageMagick/issues/7152) [`ba7883b`](https://github.com/ImageMagick/ImageMagick/commit/ba7883baf9adb715bd1e12554f6565abcd53e789)
- transient off-by-one [`c6e3741`](https://github.com/ImageMagick/ImageMagick/commit/c6e3741492d4de2e380cdb72a95538c428e567ed)
- update [`2f0e05d`](https://github.com/ImageMagick/ImageMagick/commit/2f0e05d509ed39cfd337743694accdb5ab3745ed)
- respect TIFF orientation tag (https://github.com/ImageMagick/ImageMagick/issues/7147) [`9892ad7`](https://github.com/ImageMagick/ImageMagick/commit/9892ad7a778ec31abe118585aaafb1a42bd5ff01)
- revert [`d3678bd`](https://github.com/ImageMagick/ImageMagick/commit/d3678bd5b8f25846037f00d21aa6a75a3e8f5e87)
- Switch to windows-latest [`676ba55`](https://github.com/ImageMagick/ImageMagick/commit/676ba55c79d0128e33570c7cad0a5060d52c7344)
- No longer redirect the output with inkscape because this causes issues on Windows. [`f32f8bc`](https://github.com/ImageMagick/ImageMagick/commit/f32f8bc8d042253303d08b38889520fb4b7d798b)
- validate the level argument of the -posterize option (https://github.com/ImageMagick/ImageMagick/issues/7181) [`977511b`](https://github.com/ImageMagick/ImageMagick/commit/977511beedb466ea54946df2bc2f090d40dedb02)
- change threshold [`b41bdbb`](https://github.com/ImageMagick/ImageMagick/commit/b41bdbb44c0fa96eb0d827c3f095294e7e3e3ef4)
- possible temporary pixel cache leak if resources exhausted (https://github.com/ImageMagick/ImageMagick/discussions/7167) [`e716f9e`](https://github.com/ImageMagick/ImageMagick/commit/e716f9e16e66f79294cb0f32870d1aee851846ff)
- CloneRepositories.cmd now requires a commit date instead. [`d56b22b`](https://github.com/ImageMagick/ImageMagick/commit/d56b22b347bde254f7314bfb92f2dd293dfeeedd)
- Use double quotes because the script is executed inside a batch file. [`090dafa`](https://github.com/ImageMagick/ImageMagick/commit/090dafa972f04398366d56b80817a3bd9f76b473)
- The ImageMagick repository should also be checked out to get the commit date. [`4b36b77`](https://github.com/ImageMagick/ImageMagick/commit/4b36b77496ab5c75402cc7ce90a512926de3fe54)
- Moved include of OpenCL header files to opencl-private.h [`166e5a6`](https://github.com/ImageMagick/ImageMagick/commit/166e5a618271ea84409179a25d67900859d81384)
- Added helper method because there as so many aliases with the same options. [`c396b8b`](https://github.com/ImageMagick/ImageMagick/commit/c396b8b809808a5730f2a725e164f3e113146f73)
- Added more raw formats. [`936802f`](https://github.com/ImageMagick/ImageMagick/commit/936802fa2de19af548e70847b730216e6b5d738b)
- Minor refactoring of the ignore filesize checks. [`75f9a51`](https://github.com/ImageMagick/ImageMagick/commit/75f9a5120deaf02a7a6211986d5efd6dc702df4d)
- latest autoconf/automake updates [`36d01b6`](https://github.com/ImageMagick/ImageMagick/commit/36d01b6d1ca5d3a51c55e8a760008b040fc5c5ff)
- latest autoconf/automake updates [`6c5df9e`](https://github.com/ImageMagick/ImageMagick/commit/6c5df9e5f88437cd12f2a92c93ecc16e60c1854f)
- do not round off density (https://github.com/ImageMagick/ImageMagick/issues/7203) [`460ab77`](https://github.com/ImageMagick/ImageMagick/commit/460ab772adaa6164e2344ea43ab0429d09525f41)
- Corrected initial implementation of the uhdr coder. [`f54e1ee`](https://github.com/ImageMagick/ImageMagick/commit/f54e1ee14e6d5b7193f009246003305b29822a9e)
- Corrected copy/paste mistake [`b3f3c56`](https://github.com/ImageMagick/ImageMagick/commit/b3f3c56d94f8947cfdfce11642cd0c09bc43200d)
- Patches because of changes in the ImageMagick-Windows repository. [`f017f7a`](https://github.com/ImageMagick/ImageMagick/commit/f017f7a7461af66bfba4f78e296d3d135c20c427)
- Corrected patch. [`6b67512`](https://github.com/ImageMagick/ImageMagick/commit/6b675124319ce9646cb7966bf010908cea6cf437)
- Added missing cd. [`9f738ff`](https://github.com/ImageMagick/ImageMagick/commit/9f738ffd639721bba73b6deba082a9dd03d1d65f)
- add UHDR to coder list [`a907d3b`](https://github.com/ImageMagick/ImageMagick/commit/a907d3b55965cf7980d719fbcfff30d2c0af3fce)
- declar UHDR headers [`c5643c2`](https://github.com/ImageMagick/ImageMagick/commit/c5643c2224022340838cc97fed0adefe5ceb1b3b)
- declare UHDR as a static coder [`d2f5fae`](https://github.com/ImageMagick/ImageMagick/commit/d2f5faee5a24c4888fe4c51e7adf2dce6c36cfce)
- eliminate compiler exceptions [`e3ed50f`](https://github.com/ImageMagick/ImageMagick/commit/e3ed50fee28a3a3f8224caf9d5a8f48c382a4dd4)
- don't call UHDR from JPEG [`2d47425`](https://github.com/ImageMagick/ImageMagick/commit/2d47425e9002a370a5921b2e609d52e755162769)
- make compatible with older compilers [`d3acfa1`](https://github.com/ImageMagick/ImageMagick/commit/d3acfa1f617fa442f7a9488282c51a1c9cdd14f7)
- Removed unnecessary extern declaration. [`985601e`](https://github.com/ImageMagick/ImageMagick/commit/985601e5742480baf2ce6eeaae0bea6025142122)
- channel statistics index updated to channel rather than offset [`5e12138`](https://github.com/ImageMagick/ImageMagick/commit/5e1213806ac762b1cfe7f5b2708235fcf864ae62)
- offset channel statistics by channel rather than by offset [`d5771c3`](https://github.com/ImageMagick/ImageMagick/commit/d5771c32c4c54835bdf1f0692cb517d2d898c4f0)
- Updated daily build due to changes in the ImageMagick-Windows repository. [`2f10614`](https://github.com/ImageMagick/ImageMagick/commit/2f106146a2744b77d8676a5d635b11b6077b9364)
- Renamed solution files. [`a87e60b`](https://github.com/ImageMagick/ImageMagick/commit/a87e60b5db580a30a8786b98ce04ea7b4b03e9df)
- cosmetic [`c347980`](https://github.com/ImageMagick/ImageMagick/commit/c3479802eb76269cbdcb7c05f53e8d68d72e2924)
- Also run daily build when the file is changed. [`1a68427`](https://github.com/ImageMagick/ImageMagick/commit/1a684272154469b2100424786516232cba947c12)
- Patches due to changes in the ImageMagick-Windows repository. [`4b40a3b`](https://github.com/ImageMagick/ImageMagick/commit/4b40a3bc2a069854c0633896c8960b2d097b3eb0)
- Corrected path for MSYS2 build [`107cfc1`](https://github.com/ImageMagick/ImageMagick/commit/107cfc1dee9e4e8e13e2b4f6b49f00b88329af71)
- Corrected path for MSYS2 build [`8b13c46`](https://github.com/ImageMagick/ImageMagick/commit/8b13c4679bef1c960602adc22d04c69470c14fda)
- Updated release because of the changes in the ImageMagick-Windows repository. [`c054eb0`](https://github.com/ImageMagick/ImageMagick/commit/c054eb05627201360342b1633852f45fd8bfe057)
- Corrected path for the .iss file. [`f89519e`](https://github.com/ImageMagick/ImageMagick/commit/f89519ef5e6261370dad2aa8308342c3d15de003)
- Corrected copy of the portable files. [`ea471d1`](https://github.com/ImageMagick/ImageMagick/commit/ea471d11f09121ce2b23b838eeffb4b633849ffa)
- Corrected bug mentioned in #7208. [`93cd0c9`](https://github.com/ImageMagick/ImageMagick/commit/93cd0c9a08326bef46c347896686beb92f2f5ddd)
- on exception, return the exception message detail [`eb3e060`](https://github.com/ImageMagick/ImageMagick/commit/eb3e0606771ab52ea5db52ca9aea72bae1f0f5dd)
- Restored setting the CoderAdjoinFlag flag. [`400673c`](https://github.com/ImageMagick/ImageMagick/commit/400673cdc99ca759e6be27fc2e3dda737928736e)
- Updated comments and order. [`cb76151`](https://github.com/ImageMagick/ImageMagick/commit/cb761513948aae492622365ac4ee55707473ffd9)
- throw exception if UltraHDR API call fails [`7e175d4`](https://github.com/ImageMagick/ImageMagick/commit/7e175d4d9290049f88330ed0b3c1d6d5be72021a)
- latest autoconf update [`6d348db`](https://github.com/ImageMagick/ImageMagick/commit/6d348dbb67ac8c3a7667c0f13743d1a09a2cee1c)
- Use (PixelInfo *)NULL instead of nullptr. [`9cf419c`](https://github.com/ImageMagick/ImageMagick/commit/9cf419c6eb5e64b3571d98938a4a6627ac55be42)
- Corrected README. [`274dcc7`](https://github.com/ImageMagick/ImageMagick/commit/274dcc7657880df3bcaeaee173d79d8a1dcf1047)
- cosmetic [`d71f0ab`](https://github.com/ImageMagick/ImageMagick/commit/d71f0ab4cd8b5bf8cf988fa09deeada32a9397e0)
- cosmetic [`dba80b3`](https://github.com/ImageMagick/ImageMagick/commit/dba80b3b22f115b5e6c6451042c0111469fed4c0)
- cosmetic [`55c6ab9`](https://github.com/ImageMagick/ImageMagick/commit/55c6ab9b4f08cd7bffba0164e70fabc5c0757bea)
- Renamed workflow. [`c3b55b9`](https://github.com/ImageMagick/ImageMagick/commit/c3b55b9e7750ad4abd4457003c563ac88f99d1aa)
- Changed name [`5127c7e`](https://github.com/ImageMagick/ImageMagick/commit/5127c7e5272b9cf20fbfb632f2b16422ee2d18b3)
- Renamed workflow. [`d740855`](https://github.com/ImageMagick/ImageMagick/commit/d740855d8f3cd8d652ae34efe48fc54762cdcc68)
- Changed name. [`152eefa`](https://github.com/ImageMagick/ImageMagick/commit/152eefa2be0e43e928e9f8d5a0243829aa6ef17f)
- Also run workflow then file is changed. [`f8eab58`](https://github.com/ImageMagick/ImageMagick/commit/f8eab58f50843897a355f11bc81fcbbbd79289e3)
- Removed path filter. [`40b6087`](https://github.com/ImageMagick/ImageMagick/commit/40b608757e66eed2a76918c44bcc0a9cf773238f)
- Removed old Makefile.nt file. [`89e34d7`](https://github.com/ImageMagick/ImageMagick/commit/89e34d7f69f3ce89fe95dc1094d743ebdcd217ec)
- Removed VisualMagick reference from Makefile.am [`a9e4974`](https://github.com/ImageMagick/ImageMagick/commit/a9e4974a54e2cbc77e37dc65efcc57f4ad592c63)
- Added build job that creates an msixbundle. [`cb45f37`](https://github.com/ImageMagick/ImageMagick/commit/cb45f3769b2505cc2d0b2cab5f0aeca8e8077e5a)
- latest autoconf/automake [`999dd6e`](https://github.com/ImageMagick/ImageMagick/commit/999dd6e3734130daf913860ff12a44cdbdc49f92)
- updated documentation [`5624989`](https://github.com/ImageMagick/ImageMagick/commit/562498905842c106f57569424a265476cdece18e)
- git add  images/affine.png images/annotate.png images/bitcoin.svg images/black.png images/convex-hull-blocks-closure.png images/convex-hull-blocks.png images/gaussian-blur.png images/granite.png images/logo-sm-flop.png images/logo-sm-fx.png images/logo-sm.png images/logo.png images/objects.png images/patterns/bricks.png images/patterns/circles.png images/patterns/crosshatch.png images/patterns/crosshatch30.png images/patterns/crosshatch45.png images/patterns/fishscales.png images/patterns/gray10.png images/patterns/gray100.png images/patterns/gray15.png images/patterns/gray20.png images/patterns/gray25.png images/patterns/gray30.png images/patterns/gray35.png images/patterns/gray40.png images/patterns/gray45.png images/patterns/gray5.png images/patterns/gray50.png images/patterns/gray55.png images/patterns/gray60.png images/patterns/gray65.png images/patterns/gray70.png images/patterns/gray75.png images/patterns/gray80.png images/patterns/gray85.png images/patterns/gray90.png images/patterns/gray95.png images/patterns/hexagons.png images/patterns/horizontal.png images/patterns/horizontal2.png images/patterns/horizontal3.png images/patterns/horizontalsaw.png images/patterns/hs_bdiagonal.png images/patterns/hs_cross.png images/patterns/hs_diagcross.png images/patterns/hs_fdiagonal.png images/patterns/hs_horizontal.png images/patterns/hs_vertical.png images/patterns/left30.png images/patterns/left45.png images/patterns/leftshingle.png images/patterns/octagons.png images/patterns/right30.png images/patterns/right45.png images/patterns/rightshingle.png images/patterns/smallfishscales.png images/patterns/vertical.png images/patterns/vertical2.png images/patterns/vertical3.png images/patterns/verticalbricks.png images/patterns/verticalleftshingle.png images/patterns/verticalrightshingle.png images/patterns/verticalsaw.png images/red-circle.png images/rose.png images/wand.png images/wizard.png www/Magick++/index.html www/api/MagickCache/index.html [`4871634`](https://github.com/ImageMagick/ImageMagick/commit/4871634bd634cb48da1bcd2c8c20e562eb8c6c14)
- update the documentation [`08bc95b`](https://github.com/ImageMagick/ImageMagick/commit/08bc95b7cb14a3e97732a53abf33f7ec01f8ac12)
- release [`961f9f4`](https://github.com/ImageMagick/ImageMagick/commit/961f9f4d02e0f5979a2c4cf8cb4a03c6d44f1fa5)
- documentation update [`c12280f`](https://github.com/ImageMagick/ImageMagick/commit/c12280f78c47b804d963106e48cbdacdbbe406fc)
- release [`e3694e5`](https://github.com/ImageMagick/ImageMagick/commit/e3694e554502f8e37f9a1d2618c978eb9d516717)
- latest documentation update [`5683521`](https://github.com/ImageMagick/ImageMagick/commit/568352145a413e44cf3fdd6234a9dad864c216bb)
- ... [`f3fe1f7`](https://github.com/ImageMagick/ImageMagick/commit/f3fe1f752d564972c70cfcc3bbc2a84bf8104952)
- update year [`ad8b3da`](https://github.com/ImageMagick/ImageMagick/commit/ad8b3dabc8a5d63fb925647aa521e07644a2154a)
- update webpage [`9708fad`](https://github.com/ImageMagick/ImageMagick/commit/9708fad42bc32548a2df37d2f7b1b1ada6394655)
- include color mode asset [`babe7ad`](https://github.com/ImageMagick/ImageMagick/commit/babe7ad2fabe324800a21b53bd83ac5c69461dc0)
- latest documentation [`62070f6`](https://github.com/ImageMagick/ImageMagick/commit/62070f604df7d28e7ee85c7d9cd487c346be163c)
- release (updated) [`dd459b0`](https://github.com/ImageMagick/ImageMagick/commit/dd459b01fd3dba99a5190aaca458c628293de0a3)

## [7.1.1-29](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-28...7.1.1-29) - 2024-02-25

### Merged

- Enable new libheif chroma subsampling options. [`#7095`](https://github.com/ImageMagick/ImageMagick/pull/7095)

### Commits

- beta release [`35bf3bc`](https://github.com/ImageMagick/ImageMagick/commit/35bf3bcfc69a0ce6b1561f7d7c17ceac932ce522)
- respect base64 encoding @ https://github.com/ImageMagick/ImageMagick/issues/7102 [`cd9b4bd`](https://github.com/ImageMagick/ImageMagick/commit/cd9b4bdafeb0d4ac7572e2c467a93a9b005c2475)
- Append signature when possible. [`477fda0`](https://github.com/ImageMagick/ImageMagick/commit/477fda06cc37979cd5c4e65f7960000059ba3944)
- Code style changes. [`7aa16ea`](https://github.com/ImageMagick/ImageMagick/commit/7aa16ea6411ec8ccd74961c9a0043f86dbbe41ed)
- leverage darktable delegate if libraw is not available [`3132d78`](https://github.com/ImageMagick/ImageMagick/commit/3132d78847feb10d7056696ed53744e2f0f2fc79)
- locate darktable [`71bf5d4`](https://github.com/ImageMagick/ImageMagick/commit/71bf5d45ca43198da7421385cd59faf120d4c53d)
- capture stdout [`9a09f84`](https://github.com/ImageMagick/ImageMagick/commit/9a09f84b27c597f1be3dadb6761be9d811493a1c)
- free image info struct [`4e37947`](https://github.com/ImageMagick/ImageMagick/commit/4e37947fc65ba2fc380edccecdcca7165c806afd)
- Call CoalesceImages inside the webp coder when the image dimensions are not the same to improve the patch that was made for #5542. [`bc11c2a`](https://github.com/ImageMagick/ImageMagick/commit/bc11c2a8d582b60dd3c1ae1d96c019c0bd6a3b59)
- Added extra option (tiff:assume-alpha) that can be used to assume that a single extra sample is an alpha channel. [`b209bb5`](https://github.com/ImageMagick/ImageMagick/commit/b209bb52fb843cb6ceb44afe082cf353fd2957c5)
- cosmetic [`92d5f8e`](https://github.com/ImageMagick/ImageMagick/commit/92d5f8e36afc5474e9aa2b3dd9c349522ea7e05d)
- adjust browser spacing between buttons [`4f65015`](https://github.com/ImageMagick/ImageMagick/commit/4f65015618022492c670b2a7cfc8e26307abbb22)
- uncontrolled format string [`d20d38b`](https://github.com/ImageMagick/ImageMagick/commit/d20d38bf9e90153824486e9b73e80d2195de3875)
- restore [`2359440`](https://github.com/ImageMagick/ImageMagick/commit/23594407823c5e8108fdcb6794bd62ca1a7f2331)
- Only write density values higher than zero in a jpeg file (#7120). [`43fccd5`](https://github.com/ImageMagick/ImageMagick/commit/43fccd5be9822fd648eb453cf6f3a680aeaa240e)
- use radians macro [`255a53c`](https://github.com/ImageMagick/ImageMagick/commit/255a53c59e249a805d832d17dd7dbc0eaad35284)
- more work on LCH colorspace [`eee1286`](https://github.com/ImageMagick/ImageMagick/commit/eee1286fa508fd042d20c4c1ec464af0dd69dd30)
- final corrections to LCH colorspace formula [`78c2592`](https://github.com/ImageMagick/ImageMagick/commit/78c25922dcd67c34ea9e812e52ca6fc7689ef082)
- Silence warnings. [`5f6704b`](https://github.com/ImageMagick/ImageMagick/commit/5f6704b404644027d00f3900052405f1a3c7fafd)
- Removed NTGetLastError from the private header file because it is not exported. [`908f39a`](https://github.com/ImageMagick/ImageMagick/commit/908f39aab2d445a15f16f8ca9315e9d117ef4a92)
- Return a different error code when the file could not be found on Windows to have the same behavior as on other platforms. [`7f61c5a`](https://github.com/ImageMagick/ImageMagick/commit/7f61c5a9c3466b7b0a22bde7174d07b05dd5185b)
- Fix for appending pixels that don't have the sRGBColorspace. [`cfc71f0`](https://github.com/ImageMagick/ImageMagick/commit/cfc71f0aa1bcdd8781b77197114a9e9d80ef483c)
- release [`0deac72`](https://github.com/ImageMagick/ImageMagick/commit/0deac72ed480ac2ec8e9d766c15ddb3bca055952)

## [7.1.1-28](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-27...7.1.1-28) - 2024-02-11

### Merged

- fix misleading comment in dds.c [`#7075`](https://github.com/ImageMagick/ImageMagick/pull/7075)

### Commits

- beta release [`868642e`](https://github.com/ImageMagick/ImageMagick/commit/868642e2b0e69a974e4ad6022c1d2050660c1aa5)
- Bump azure/azure-code-signing-action from 0.2.22 to 0.2.26 [`1aa50ea`](https://github.com/ImageMagick/ImageMagick/commit/1aa50ea3c7683c40b5ccd6af308d40d7dca04e15)
- updated link [`f69389a`](https://github.com/ImageMagick/ImageMagick/commit/f69389a3d88902af267e71ef362ea24b2f56e85b)
- eliminate extraneous EXIF comma [`c4b3e14`](https://github.com/ImageMagick/ImageMagick/commit/c4b3e141a764ff1f638aa5ac19033dc573451978)
- Do not leak memory when throwing in the constructor [`aa4afc5`](https://github.com/ImageMagick/ImageMagick/commit/aa4afc5f21f1e90c0ad63897ca7afbd7fa43b93e)
- escape { when writing MIFF images (https://github.com/ImageMagick/ImageMagick/issues/7071) [`97432f1`](https://github.com/ImageMagick/ImageMagick/commit/97432f116c035162c390f72a602d5c7470b8d871)
- protect '{' in MIFF key/value pairs [`dd171d1`](https://github.com/ImageMagick/ImageMagick/commit/dd171d11795db16461fe4835603c4aecbab1a09d)
- ... [`52c0001`](https://github.com/ImageMagick/ImageMagick/commit/52c00019117c4e2169d996544eaefbac8b6bf147)
- set visible image artifac [`2c6c09d`](https://github.com/ImageMagick/ImageMagick/commit/2c6c09d2121c6386728a0f52410026c300e8aab3)
- include version header [`be0f61a`](https://github.com/ImageMagick/ImageMagick/commit/be0f61a0d4ca4852a29cf08f74e7790803d649ac)
- Bump azure/azure-code-signing-action from 0.2.26 to 0.3.0 [`438b9ab`](https://github.com/ImageMagick/ImageMagick/commit/438b9ab56b18dd9ddc55dcb80298127d30e8b537)
- extent buffer by the maximum field size [`ce9b069`](https://github.com/ImageMagick/ImageMagick/commit/ce9b069cc1ad9748e91b9d37be54cfbb6a714ac5)
- enable error diffusion for -posterize (https://github.com/ImageMagick/ImageMagick/issues/7079) [`b103653`](https://github.com/ImageMagick/ImageMagick/commit/b103653db62f8822ed0d2c9823a706f423d1de97)
- refactor posterize macro [`122a1f6`](https://github.com/ImageMagick/ImageMagick/commit/122a1f65891eefb4c090cdf076182bcee11eda44)
- improve posterize algorithm [`92c93c3`](https://github.com/ImageMagick/ImageMagick/commit/92c93c30aded7dbdbc1e5f2ec9b9774da0bf20b9)
- refactor posterize pixel macro [`114f958`](https://github.com/ImageMagick/ImageMagick/commit/114f95804df810185bb85b1351d2effbc1bbc47e)
- eliminate compiler warning [`79f137d`](https://github.com/ImageMagick/ImageMagick/commit/79f137d994c26d536f84a6a5e89d8fd07dbf5f48)
- support setting the image registry [`73e6f63`](https://github.com/ImageMagick/ImageMagick/commit/73e6f632643bba977a2ec7acf68f148f26c9e3d2)
- modify posterize algorithm (https://github.com/ImageMagick/ImageMagick/issues/7079) [`4b6843d`](https://github.com/ImageMagick/ImageMagick/commit/4b6843d535c89685d7321842b161c3914b38a20e)
- eliminate compiler warning [`03af658`](https://github.com/ImageMagick/ImageMagick/commit/03af6588de05f797b72677ce79f9f142e1c444ab)
- eliminate compiler warning [`e73215c`](https://github.com/ImageMagick/ImageMagick/commit/e73215c0466584e9388841b48a11fd1497b23cac)
- check for class recursion [`5a549df`](https://github.com/ImageMagick/ImageMagick/commit/5a549df7f79c7cb4dbf6c876d520ba3ad275075c)
- Raise warning instead of error when xmp profile can not be validated. [`832aabf`](https://github.com/ImageMagick/ImageMagick/commit/832aabf16bad64a0e9cb6221012af33192e47f84)
- Fixed running identify one dds files with a cubemap. [`e9702b4`](https://github.com/ImageMagick/ImageMagick/commit/e9702b43fc502d70de2ba19ccce9282445d31a03)
- Renamed method that skips the mipmaps. [`c317606`](https://github.com/ImageMagick/ImageMagick/commit/c3176066365ceb3cc7688c7ff76f04104000d99a)
- Corrected check for width and height when skipping the mipmaps. [`59fa6fd`](https://github.com/ImageMagick/ImageMagick/commit/59fa6fd75bf87ba4b17ca24c86fa71a7edd7726a)
- Set ttl to time when the image will expire instead of the duration that the image can be used. [`d3735ed`](https://github.com/ImageMagick/ImageMagick/commit/d3735ede7bc83d6d6087425d804642fc38bdc3b2)
- improve time-to-live formatting [`12b1e53`](https://github.com/ImageMagick/ImageMagick/commit/12b1e53ffcf6d4fddfb7222b981bb8324c9b9a97)
- Added HEIC_COMPUTE_NUMERIC_VERSION to make the version checks more readable. [`0c0f0a4`](https://github.com/ImageMagick/ImageMagick/commit/0c0f0a4e832271a1a37b872e8b76c100e81945c2)
- fix incorrect stroke opacity (https://github.com/ImageMagick/ImageMagick/issues/7097) [`fab46a4`](https://github.com/ImageMagick/ImageMagick/commit/fab46a4620a761feae2b4771f7d57257f06e3fb5)
- correct pixel offset validation method [`3be0fa7`](https://github.com/ImageMagick/ImageMagick/commit/3be0fa779c1f00049ca3582601740e124208322b)
- if resampling fails, replace with invalid pixel [`b0f6c05`](https://github.com/ImageMagick/ImageMagick/commit/b0f6c05f67435016568ee24ed4a07f72a0e0e677)
- Also allow invalid length where 8 was added to the header size. [`5c7fbe3`](https://github.com/ImageMagick/ImageMagick/commit/5c7fbe3922c2300521fd3d30faa484f8a8f78fa2)
- release [`b206758`](https://github.com/ImageMagick/ImageMagick/commit/b20675898a9e4b5972e56c368ca5f04a017a99ef)
- release [`365d9b6`](https://github.com/ImageMagick/ImageMagick/commit/365d9b6f698234093d7a919f090bd5ce87b2104a)

## [7.1.1-27](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-26...7.1.1-27) - 2024-01-21

### Merged

- fix PKG_CONFIG_LIBDIR [`#7013`](https://github.com/ImageMagick/ImageMagick/pull/7013)

### Commits

- beta release [`3042ca2`](https://github.com/ImageMagick/ImageMagick/commit/3042ca2cbe31db8f9b4ac26949aa9dedc7984e3b)
- Use constImage instead. [`b449e0f`](https://github.com/ImageMagick/ImageMagick/commit/b449e0fec6cc439edfe1aadc2a247a59ec9fb013)
- export an exception when functions do not include an enclosing parenthesis (https://github.com/ImageMagick/ImageMagick/discussions/4533) [`ea0ea9c`](https://github.com/ImageMagick/ImageMagick/commit/ea0ea9cd9838645b8485d4757cf2944fa9adaa07)
- check maximum number of meta channels [`c099a19`](https://github.com/ImageMagick/ImageMagick/commit/c099a19f0faed7001051dafe366477cd6de145ea)
- fix compiler exception [`f76166c`](https://github.com/ImageMagick/ImageMagick/commit/f76166c0b5e19aed12b2ea97dc9a33ccf27da726)
- deprecate InitializePixelCacheMap() and introduce ResetPixelCacheMap() [`35ba540`](https://github.com/ImageMagick/ImageMagick/commit/35ba5404dc50ccae946d6763f2a946356111b1a6)
- prevent possible integer overflow [`7ae3b4b`](https://github.com/ImageMagick/ImageMagick/commit/7ae3b4b4940cd7375bdda0a24256819427228660)
- cosmetic [`1db97cd`](https://github.com/ImageMagick/ImageMagick/commit/1db97cd4b3ac30c0d2a8b52cc8ba4a0fd7c9ea1e)
- fix compiler exception [`c02ab48`](https://github.com/ImageMagick/ImageMagick/commit/c02ab48cf61dfcc3a3c1af44a55c0730fce9bc4d)
- eliminate compiler warning [`eaa6f6c`](https://github.com/ImageMagick/ImageMagick/commit/eaa6f6c1670972fac0a43a9b624ef58099092a41)
- move check for excessive meta channels [`2133d30`](https://github.com/ImageMagick/ImageMagick/commit/2133d3026b34c7ec2dac120343a64e72eb8016d4)
- Corrected setting the quantum_type for the red channel that caused issues with multi spectral images. [`906758c`](https://github.com/ImageMagick/ImageMagick/commit/906758cb8df3ae53c317d58df393b632ed906200)
- fix scaling of {display-p3,pro-photo,adobe-98} colorspace (https://github.com/ImageMagick/ImageMagick/issues/7038) [`35e6851`](https://github.com/ImageMagick/ImageMagick/commit/35e685142fcdd18fee4f35314ebaa15c33dc8eb7)
- adjust copyright year [`bc88c69`](https://github.com/ImageMagick/ImageMagick/commit/bc88c690ddf8447b9b48b0d5baa5a7fe824c5894)
- Corrected patch to fix reading multi spectral images. [`9c64c66`](https://github.com/ImageMagick/ImageMagick/commit/9c64c662f40793ae2a6fb8d0569cb613957cb918)
- release [`0225ac4`](https://github.com/ImageMagick/ImageMagick/commit/0225ac41a47ab0aaa7ea1098b036d5546eb61663)

## [7.1.1-26](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-25...7.1.1-26) - 2024-01-07

### Merged

- Make Magick++-config work from non-standard places [`#7008`](https://github.com/ImageMagick/ImageMagick/pull/7008)

### Fixed

- Make Magick++-config work from non-standard places (#7008) [`#7007`](https://github.com/ImageMagick/ImageMagick/issues/7007)

### Commits

- beta release [`15b1a5d`](https://github.com/ImageMagick/ImageMagick/commit/15b1a5d99d742c4a8254ccbe6b2e6d42b73be675)
- Improved name of installer artifacts [`2d36d1a`](https://github.com/ImageMagick/ImageMagick/commit/2d36d1af07e9bcc5d0a43584d61210781affec8a)
- Trim version to avoid trailing - [`6c76d71`](https://github.com/ImageMagick/ImageMagick/commit/6c76d71a80d50a389f89905c86bd54e7f6e2d2ee)
- support -alpha remove-opaque option [`0ce621f`](https://github.com/ImageMagick/ImageMagick/commit/0ce621fe81bbfb2087e4deaef1992b3815e4a221)
- Reverted incorrect patch. [`3ee902d`](https://github.com/ImageMagick/ImageMagick/commit/3ee902d23a43f2fd91eb92676280e76642675d17)
- reduce # threads for -alpha option [`8876f13`](https://github.com/ImageMagick/ImageMagick/commit/8876f135a90ba2e1d5621a3239a21fc02e0e0c07)
- -alpha deactivate-if-opaque disables the alpha channel if and only if its entirely opaque [`66ef758`](https://github.com/ImageMagick/ImageMagick/commit/66ef7585ed386af240f24495507168e6e2d2cd54)
- -alpha off-if-opaque turns off the alpha channel if its entirely opaque [`e9a68f0`](https://github.com/ImageMagick/ImageMagick/commit/e9a68f03e4955058218da7f2d5df659812270c26)
- slight optimization [`e6f0530`](https://github.com/ImageMagick/ImageMagick/commit/e6f053085447e82657755b44e53c27059f5eca6c)
- fix error: 'libraw_data_t' has no member named 'rawparams' [`1294dac`](https://github.com/ImageMagick/ImageMagick/commit/1294dac3875b26c40f4701c9d5d5ffc39c22ecac)
- thread tuning [`c29cf7f`](https://github.com/ImageMagick/ImageMagick/commit/c29cf7f1135c297bd9c30caf1c9ae446980ae784)
- Silenced warning. [`b8fd1e7`](https://github.com/ImageMagick/ImageMagick/commit/b8fd1e7af732289c62019fe573c2c1515ce63e28)
- thread tunuing [`80cb07d`](https://github.com/ImageMagick/ImageMagick/commit/80cb07da4df28677c8069082ab39fb222c98e0b3)
- optimize HDRI detection [`f8ba278`](https://github.com/ImageMagick/ImageMagick/commit/f8ba2781a6fbe9c7a8b0568f461ee1c5b1e43b1d)
- factor is a const argument [`3e2879e`](https://github.com/ImageMagick/ImageMagick/commit/3e2879ec690b83698490fff33a8aef00da459dd2)
- Fixed build on Windows. [`0f0ccfd`](https://github.com/ImageMagick/ImageMagick/commit/0f0ccfd9d44c9f36d174b066b15db563af332eec)
- Removed duplicate define. [`79e742a`](https://github.com/ImageMagick/ImageMagick/commit/79e742a3369add2e236f0f9a7bb1f64a7bfa3146)
- The CheckPSDChannels method should not check empty layers. [`e5162e6`](https://github.com/ImageMagick/ImageMagick/commit/e5162e69d945d81405687f4fc773863c49ba9168)
- Use consistent casing of method names. [`cbf79ad`](https://github.com/ImageMagick/ImageMagick/commit/cbf79ad2000805a25ebe72d91604cd7831905946)
- Allow invalid webp files that incorrectly include the size of the header in the length. [`99c9ee4`](https://github.com/ImageMagick/ImageMagick/commit/99c9ee4b03571e10348c96b5923e01cdb4f67820)
- https://github.com/ImageMagick/ImageMagick/issues/7006 [`8e1b405`](https://github.com/ImageMagick/ImageMagick/commit/8e1b405179adee514f178c911a1ca20060a1125f)
- cosmetic [`9033dea`](https://github.com/ImageMagick/ImageMagick/commit/9033dea0ff8e5694e70d2a6a11f29407a0e4c85d)
- improve RSVG exception checking (https://github.com/ImageMagick/ImageMagick/issues/7005) [`802ffae`](https://github.com/ImageMagick/ImageMagick/commit/802ffae7781dd635e25edef86e8357c93b17bf5a)
- fix off-by-one issue for captions/labels (https://github.com/ImageMagick/ImageMagick/issues/7004) [`e80133b`](https://github.com/ImageMagick/ImageMagick/commit/e80133bc76f549156e3437b62c3699850e020a16)
- fix caption sizing issue (https://github.com/ImageMagick/ImageMagick/issues/7004) [`2d24367`](https://github.com/ImageMagick/ImageMagick/commit/2d24367dc971dcf61afe65dc65aba4519ea1d20f)
- correct off by one issue [`90ac70a`](https://github.com/ImageMagick/ImageMagick/commit/90ac70a9b725aee99b62851b5927429a66c68d80)
- correct usage [`a5dbba6`](https://github.com/ImageMagick/ImageMagick/commit/a5dbba6494663c3d067e7eb1f2fdf3a776acfb07)
- fix off-by-one error [`a12f6d1`](https://github.com/ImageMagick/ImageMagick/commit/a12f6d128f807e5f9704efb15353f8fbc58b72a2)
- release [`83eefaf`](https://github.com/ImageMagick/ImageMagick/commit/83eefaf2aab871d4e12e7f70901d9785b4f0ea01)

## [7.1.1-25](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-24...7.1.1-25) - 2023-12-30

### Merged

- When writing BMP to v3 or lower, ignore the ICC profile. [`#6979`](https://github.com/ImageMagick/ImageMagick/pull/6979)
- configure.ac: fixup LFS check for autoconf-2.72 [`#6978`](https://github.com/ImageMagick/ImageMagick/pull/6978)

### Commits

- beta release [`3e8b0fa`](https://github.com/ImageMagick/ImageMagick/commit/3e8b0fa1cf084ac5073d5249bd7c702b1b7ae5f8)
- beta release [`0930653`](https://github.com/ImageMagick/ImageMagick/commit/093065376493d981efd758d971026da40fbffc52)
- Correct flags for jpeg-xl build. [`87f4a62`](https://github.com/ImageMagick/ImageMagick/commit/87f4a6266e1e910050d2c62d057332edb9c083f7)
- Include deflate in the security/oss-fuzz build. [`26e6cf7`](https://github.com/ImageMagick/ImageMagick/commit/26e6cf7d59b07d3d7920b476665f5637c2e330cd)
- Include more features in the tiff build. [`0d36830`](https://github.com/ImageMagick/ImageMagick/commit/0d36830878bb55fe7dbd7f7f4150f343b108fab9)
- check for version 0.20 instead [`f5329ad`](https://github.com/ImageMagick/ImageMagick/commit/f5329add7450ed188e96d957bd0933efa7c81ebe)
- Also include -ldeflate in the LIBS for the oss-fuzz build. [`a29b58c`](https://github.com/ImageMagick/ImageMagick/commit/a29b58cb7b9870cb1912ba10921871d11b14903b)
- Corrected oss-fuzz build. [`c02326b`](https://github.com/ImageMagick/ImageMagick/commit/c02326baa4de3736341092e2d17002c0c6475ed0)
- display hidden image [`1dfcae1`](https://github.com/ImageMagick/ImageMagick/commit/1dfcae1472e77a77dc118ecc90ffe6639dd5aba1)
- Start of moving the oss-fuzz files. [`b333c1a`](https://github.com/ImageMagick/ImageMagick/commit/b333c1aa4561f058383d386b836fbc4f46e33598)
- cosmetic [`1cec932`](https://github.com/ImageMagick/ImageMagick/commit/1cec9327e53b3c3ffbc51023cf3540c0b5da676f)
- latest autoconf/automake [`44ca83b`](https://github.com/ImageMagick/ImageMagick/commit/44ca83b1d91d2a87d9c07e8869de350fed970678)
- latest autoconf/automake update [`fd412d1`](https://github.com/ImageMagick/ImageMagick/commit/fd412d124db9f9236755b3aed8bb26bce73c01c1)
- identify image time-to-live [`6aac882`](https://github.com/ImageMagick/ImageMagick/commit/6aac88223316abe5a699a22c9657074809e7bd21)
- set errno if time-to-live exceeded [`a8a6a61`](https://github.com/ImageMagick/ImageMagick/commit/a8a6a61f9118b76d87b9fce6c6cce12ef1379977)
- cosmetic [`c59b334`](https://github.com/ImageMagick/ImageMagick/commit/c59b33446da2debdd67f550dfd8513ce98c0d571)
- conditionally set errno to ESTALE [`43a44ea`](https://github.com/ImageMagick/ImageMagick/commit/43a44ea57e3c89b96139153fc297e74f9397bab4)
- cosmetic [`371c8da`](https://github.com/ImageMagick/ImageMagick/commit/371c8da8d6a58f5d6a955f6230160f327e4ebf41)
- Moved oss-fuzz files to a different folder. [`75c72e1`](https://github.com/ImageMagick/ImageMagick/commit/75c72e1a91ccbfd726fff2fcaa0a3965d118b338)
- Changes due to moving the oss-fuzz files. [`abc23f1`](https://github.com/ImageMagick/ImageMagick/commit/abc23f11bacbc4dc498eaabfbc02e965ced60825)
- ensure video can be read from stdin (https://github.com/ImageMagick/ImageMagick/issues/6980) [`9a7e87a`](https://github.com/ImageMagick/ImageMagick/commit/9a7e87a89f92ee525c4e2c077a8a128e7796c897)
- ignore SyncBlob() status in CloseBlob() (https://github.com/ImageMagick/ImageMagick/issues/6984) [`30274e5`](https://github.com/ImageMagick/ImageMagick/commit/30274e544e79ab2a53a95b1a9ad6d52cec314220)
- repo change [`ca392c7`](https://github.com/ImageMagick/ImageMagick/commit/ca392c79e28778606e2a0e0fb2c2d5bc38e58f8e)
- update manifest [`d4298ea`](https://github.com/ImageMagick/ImageMagick/commit/d4298eab18d1d39d80a32f983ed99b5443ad5fe5)
- release [`054b98c`](https://github.com/ImageMagick/ImageMagick/commit/054b98c80fe9b5d09db095f8a4e03586f0ef6e31)
- release [`98e7513`](https://github.com/ImageMagick/ImageMagick/commit/98e7513a5b28adb5f39855a27108fd9a2a01c202)

## [7.1.1-24](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-23...7.1.1-24) - 2023-12-25

### Merged

- configure: drop backported ac_func_fseeko.m4 for autoconf-2.72 compat… [`#6970`](https://github.com/ImageMagick/ImageMagick/pull/6970)
- Add Panasonic Raw v2 (RW2) as mime type [`#6967`](https://github.com/ImageMagick/ImageMagick/pull/6967)
- Add Canon Raw v2 (CR2) as mime type [`#6968`](https://github.com/ImageMagick/ImageMagick/pull/6968)

### Commits

- beta release [`9e5eb3a`](https://github.com/ImageMagick/ImageMagick/commit/9e5eb3a099cab17e895a55a53df2fb01610e299a)
- ... [`22ca517`](https://github.com/ImageMagick/ImageMagick/commit/22ca5177369707d7eaf56c311643ecce704e6910)
- cosmetic [`8d015de`](https://github.com/ImageMagick/ImageMagick/commit/8d015de00c3e98f648b74f9a72233daa03319947)
- Added extra check for rare case when ImageMagick is build without any delegates. [`8d08f85`](https://github.com/ImageMagick/ImageMagick/commit/8d08f856456e57ab2ec72b19860e6dc2364e555d)
- Corrected order to fix invalid matches. [`935f2c2`](https://github.com/ImageMagick/ImageMagick/commit/935f2c288173117ed2d71e991db641512ded381a)
- b10 should also be moved. [`cf821b1`](https://github.com/ImageMagick/ImageMagick/commit/cf821b18cc6ac2230b5e7c36c7e0d0e566b3f864)
- only fill the alpha channel for `alpha` floodfill [`ef87dfd`](https://github.com/ImageMagick/ImageMagick/commit/ef87dfdf18acd1b017e02b5f55e4c8d1b716d1b4)
- Make sure we use the lt_ methods like we do elsewhere. [`da099f2`](https://github.com/ImageMagick/ImageMagick/commit/da099f2d2f62613644a942a8369bf986d9bfdf09)
- support dng:max-raw-memory define (https://github.com/ImageMagick/ImageMagick/discussions/6922) [`1b042b2`](https://github.com/ImageMagick/ImageMagick/commit/1b042b26bd0ef575906c93079c5686bc9eb7ef23)
- cosmetic [`8365814`](https://github.com/ImageMagick/ImageMagick/commit/8365814e48d92a9974d19311652cf2d042e95583)
- properly export YUV JP2 images (https://github.com/ImageMagick/ImageMagick/issues/6943) [`804e2b7`](https://github.com/ImageMagick/ImageMagick/commit/804e2b73a400d77270a0912f6f63a6f4fecf5dc4)
- use `:` specifier [`66a3868`](https://github.com/ImageMagick/ImageMagick/commit/66a3868a4da949aff7b65b6f7e480f09a9fd7464)
- correct display program name [`a0aca55`](https://github.com/ImageMagick/ImageMagick/commit/a0aca550b2d02a901759ba8a048a51985be3b789)
- check for corrupt DJVU images (https://github.com/ImageMagick/ImageMagick/security/advisories/GHSA-wv9p-78jx-g7fv) [`f65eba2`](https://github.com/ImageMagick/ImageMagick/commit/f65eba252e3aa387bd99297a750a2ee250664f8c)
- support UTF-8 comments (https://github.com/ImageMagick/ImageMagick/issues/6949) [`e46e2ef`](https://github.com/ImageMagick/ImageMagick/commit/e46e2eff03cbf5780a0e169ea187348b7799674f)
- do not prefix iTxt key with 'png:' [`558e255`](https://github.com/ImageMagick/ImageMagick/commit/558e25579012caa4113c559a86a8e8374c9bbc08)
- latest autoconf update [`640af74`](https://github.com/ImageMagick/ImageMagick/commit/640af74bfc5091496d16f446e659276e949d2867)
- enhance sampling factor parser (https://github.com/ImageMagick/ImageMagick/issues/6943) [`4011e63`](https://github.com/ImageMagick/ImageMagick/commit/4011e631b0c9c168a875a170b3a5e286ddcbbc2c)
- Corrected length check. [`6c52fda`](https://github.com/ImageMagick/ImageMagick/commit/6c52fda2bdcc2a4a27640495f5f24e7020e553f7)
- Bump actions/download-artifact from 3 to 4 [`ed5ac6d`](https://github.com/ImageMagick/ImageMagick/commit/ed5ac6d69c2f54af6b0371e7021aae4c32623548)
- Bump actions/upload-artifact from 3 to 4 [`be19e35`](https://github.com/ImageMagick/ImageMagick/commit/be19e3573735f66762b577805b59fd04c9feb452)
- Bump github/codeql-action from 2 to 3 [`b85f143`](https://github.com/ImageMagick/ImageMagick/commit/b85f14385a84e52e045148e4393d951a9c4e3483)
- Give artifacts a unique name. [`1c229f2`](https://github.com/ImageMagick/ImageMagick/commit/1c229f2ec7338c1ee1633b0ac837a866b91449cd)
- Use different name for the installers. [`0813103`](https://github.com/ImageMagick/ImageMagick/commit/08131032a7008c31eb41463963caa0b37ae80dd3)
- Also include type in artifact name. [`7d907ea`](https://github.com/ImageMagick/ImageMagick/commit/7d907ea75a2731ad3479f55ac4f14dbecd77cd2d)
- Swap order. [`490e9ab`](https://github.com/ImageMagick/ImageMagick/commit/490e9ab40877f716225c2404d1c4d275093e2172)
- Switch to ubuntu 20.04 in the app-image build. [`7f8aab2`](https://github.com/ImageMagick/ImageMagick/commit/7f8aab2eb90354bd87943652813a5a197ef3d8c0)
- Revert path filter. [`94d5512`](https://github.com/ImageMagick/ImageMagick/commit/94d5512c66fb4c30c9e67c77ea39b6da7683da01)
- Corrected packages that need to be install due to ubuntu upgrade. [`12ecacf`](https://github.com/ImageMagick/ImageMagick/commit/12ecacf95ecd4140ddef23b85e4a3162b5838e25)
- Removed duplicate if statement. [`092b8fa`](https://github.com/ImageMagick/ImageMagick/commit/092b8fa848f0c6c9ba34c0af6dd5e60f722893a5)
- Bump actions/checkout from 3 to 4 [`854b3a4`](https://github.com/ImageMagick/ImageMagick/commit/854b3a4a449cba3666a752b0dd33e2e6b2ae2368)
- Silence warning [`d1cd21c`](https://github.com/ImageMagick/ImageMagick/commit/d1cd21ccc0db09020ef2333cc6040fe4b7b6010e)
- improve accuracy of image statistics (https://github.com/ImageMagick/ImageMagick/issues/6924) [`1f241fd`](https://github.com/ImageMagick/ImageMagick/commit/1f241fd314bd03acdfe58bab13f85e3c757feeb9)
- fx calculations of skewness and kurtosis (https://github.com/ImageMagick/ImageMagick/issues/6964) [`fffda83`](https://github.com/ImageMagick/ImageMagick/commit/fffda833e847732654d54b823267204b1e24a1d1)
- Only write comments as itxt when the string contains non ansi chars. [`f21cd54`](https://github.com/ImageMagick/ImageMagick/commit/f21cd542a989a6e6a973752f1a41b40afd1c8297)
- check if the string contains non-Latin1 characters [`a07eac1`](https://github.com/ImageMagick/ImageMagick/commit/a07eac13c12b2498c37eda7a9c6cbc13c3d716c6)
- Corrected patch to check for non-Latin1 characters. [`73ad1b7`](https://github.com/ImageMagick/ImageMagick/commit/73ad1b7524219babcc7a811e3a631a3f973f2198)
- invalid JSON with -ping (https://github.com/ImageMagick/ImageMagick/issues/6966) [`7ccf6e8`](https://github.com/ImageMagick/ImageMagick/commit/7ccf6e87e53dd42b9eeed62a223fd65f72e8b769)
- throw exception if # of meta channels exceed max (https://github.com/ImageMagick/ImageMagick/security/advisories/GHSA-hx5j-pxvh-rj7r) [`9c85f8f`](https://github.com/ImageMagick/ImageMagick/commit/9c85f8f8282c10214b3cd7e8504e8ee9c891ab42)
- https://github.com/ImageMagick/ImageMagick/security/advisories/GHSA-hx5j-pxvh-rj7r [`8284632`](https://github.com/ImageMagick/ImageMagick/commit/828463261d0b3c4d67fb0f9c2b2c829dde82eb8b)
- multiplication result converted to larger type [`c3bb6f6`](https://github.com/ImageMagick/ImageMagick/commit/c3bb6f6c4a2d87942c31087e774571fdcffc3a0a)
- invalid HTTPS certificates are no longer ignored (https://github.com/ImageMagick/ImageMagick/security/advisories/GHSA-3r24-6m6q-vxmr) [`62e67a2`](https://github.com/ImageMagick/ImageMagick/commit/62e67a265a8ec9f272fe50fdc313ec07c7dad9a3)
- multiplication result converted to larger type [`0882713`](https://github.com/ImageMagick/ImageMagick/commit/0882713cebb0ace6965a2f56664b5f931f2c607f)
- eliminate compiler warning [`e88b9aa`](https://github.com/ImageMagick/ImageMagick/commit/e88b9aa79fb8fad0b2677104f6713d51907bb9a5)
- don't include the index channel in the overall image statistics [`4e1feed`](https://github.com/ImageMagick/ImageMagick/commit/4e1feed86220638b3ec296ef99605587e90da245)
- multiplication result converted to larger type [`91d8a32`](https://github.com/ImageMagick/ImageMagick/commit/91d8a329a02883d4f7c2e7a180a2d3fedfcea295)
- release [`1c14ca3`](https://github.com/ImageMagick/ImageMagick/commit/1c14ca384e60cc203c1c72fa0a5721a68c2c5afe)
- no member named 'rawparams' (https://github.com/ImageMagick/ImageMagick/issues/6969) [`57ff827`](https://github.com/ImageMagick/ImageMagick/commit/57ff82753e8de6eff1b2143dcd24f7613a448a2f)
- release [`883eaa2`](https://github.com/ImageMagick/ImageMagick/commit/883eaa2b457dab61e1decaf99d13931acf1ddaf5)
- release [`963f5fa`](https://github.com/ImageMagick/ImageMagick/commit/963f5fa2a3c87b362e2b6b29a31bff447b75925b)

## [7.1.1-23](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-22...7.1.1-23) - 2023-12-10

### Merged

- Fix zstd not being listed under GetMagickDelegates() [`#6934`](https://github.com/ImageMagick/ImageMagick/pull/6934)
- configure.ac: Fix bashism [`#6931`](https://github.com/ImageMagick/ImageMagick/pull/6931)

### Commits

- beta release [`e1ff620`](https://github.com/ImageMagick/ImageMagick/commit/e1ff62030d783d4efc24919effaa8b7bf5a84dc3)
- set time_t maximum (https://github.com/ImageMagick/ImageMagick/issues/6891) [`5fa5898`](https://github.com/ImageMagick/ImageMagick/commit/5fa58982eb65273f08318fc53028e389fa9b2aa7)
- cosmetic [`dce5f10`](https://github.com/ImageMagick/ImageMagick/commit/dce5f102ca7a2d4cbe0bb6d50125800de4ef7067)
- support Visio vector files [`51291ec`](https://github.com/ImageMagick/ImageMagick/commit/51291ec84b5c88d3e72578895189acf9771e4ce3)
- correct display and mogrify commands [`35c97bd`](https://github.com/ImageMagick/ImageMagick/commit/35c97bd51d0155b7ff8bca8876f1cb3cc802e82e)
- upgrade shadow signatures [`9e4f5fc`](https://github.com/ImageMagick/ImageMagick/commit/9e4f5fcb54cd103f1ae497140533ee5a9f4d714d)
- detected memory leaks [`f2ce071`](https://github.com/ImageMagick/ImageMagick/commit/f2ce071308224315000624a141058583baf0c58e)
- detected memory leaks [`364e573`](https://github.com/ImageMagick/ImageMagick/commit/364e57315ea756d28e94991f39283c50fb180de8)
- xc: code is not always guarenteed to return an image (https://github.com/ImageMagick/ImageMagick/issues/6917) [`e8b7974`](https://github.com/ImageMagick/ImageMagick/commit/e8b7974e8756fb278ec85d896065a1b96ed85af9)
- Set ttl to time when the image will expire instead of the duration that the image can be used. [`4b744eb`](https://github.com/ImageMagick/ImageMagick/commit/4b744eba5edbca8db76c3df3f95e30c21085517c)
- lastest documentation update [`8fccfab`](https://github.com/ImageMagick/ImageMagick/commit/8fccfabce117fb9e30eb7d12d5ed008c25e74490)
- update link [`a726df9`](https://github.com/ImageMagick/ImageMagick/commit/a726df99b2e5f7ceeb4ab31129cd757a7fda89d7)
- latest autoconf update [`4f42f63`](https://github.com/ImageMagick/ImageMagick/commit/4f42f631bdd43738db92f1fbc72e4a9f34eae462)
- add link to license [`2c87d7d`](https://github.com/ImageMagick/ImageMagick/commit/2c87d7da1b1db4573a37bd7933dfbf772ac3eecf)
- normalize pixel sum to reduce numerical instability (https://github.com/ImageMagick/ImageMagick/issues/6924) [`94cc881`](https://github.com/ImageMagick/ImageMagick/commit/94cc8810cb1f78549548c88dd3e87f14a3c5b1a0)
- update links [`7abd15b`](https://github.com/ImageMagick/ImageMagick/commit/7abd15bb1d25e8ef95bd98a06ff53b91cfa3feb5)
- inadvertedly scaled the histogram pixel, revert [`dade20d`](https://github.com/ImageMagick/ImageMagick/commit/dade20d5a15cb6918b23ca41cd8ef2b6a3849a40)
- Patch to avoid trailing whitespace in delegates. [`bd6ff11`](https://github.com/ImageMagick/ImageMagick/commit/bd6ff11f03455128220d91fb892f29154b4bcd5f)
- Fixed patch for non windows platform. [`c5567ea`](https://github.com/ImageMagick/ImageMagick/commit/c5567ea1c23d6bd7dd41c6b7fb7660c5245bdf19)
- release [`b135bac`](https://github.com/ImageMagick/ImageMagick/commit/b135bacc69df9f1de0b71cf3638f7e8296bbfb57)
- beta release [`e6cfc7c`](https://github.com/ImageMagick/ImageMagick/commit/e6cfc7cb4cbd6c2b5c3ffd01774b07712bdef25e)
- release [`54b13e9`](https://github.com/ImageMagick/ImageMagick/commit/54b13e91d262b1083e27fc8c02532c89d3ff649c)

## [7.1.1-22](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-21...7.1.1-22) - 2023-12-03

### Commits

- beta release [`a042cc4`](https://github.com/ImageMagick/ImageMagick/commit/a042cc470d3e4d3918a6cea95aa49f3c36872be1)
- check maximum coordinates along an arc [`24a44cd`](https://github.com/ImageMagick/ImageMagick/commit/24a44cd467af639ee8cd4f3d9eeef78f29b44943)
- https://github.com/ImageMagick/ImageMagick/issues/6623 [`7142d5e`](https://github.com/ImageMagick/ImageMagick/commit/7142d5e0affb21d628d8a59801f234c41fb4950d)
- eliminate redundent pixel offset check [`022c0ed`](https://github.com/ImageMagick/ImageMagick/commit/022c0ed2fcc82ecf9da8244b9383a28b044846d7)
- correct valid pixel offset [`aecbbb5`](https://github.com/ImageMagick/ImageMagick/commit/aecbbb5fa28551b33ef8b9ec5f1fa29233b86ea5)
- correct pixel offset [`bf6e0df`](https://github.com/ImageMagick/ImageMagick/commit/bf6e0df43ee455afd7a116598b3872503ca60b4e)
- correct pixel offset [`a56ae29`](https://github.com/ImageMagick/ImageMagick/commit/a56ae291467151b04e26915ad4379593035f9102)
- check for out-of-bounds implode factor [`acaffeb`](https://github.com/ImageMagick/ImageMagick/commit/acaffeb8e496ab23f6b56f3411ff8e69c7ff2fe3)
- eliminate redundant null check [`7f67079`](https://github.com/ImageMagick/ImageMagick/commit/7f67079d3453e5de2b6ebe7ebafa2bd98404a394)
- No longer disable NVIDIA devices because we disable OpenCL by default. [`9b10973`](https://github.com/ImageMagick/ImageMagick/commit/9b109732da21e1604ec28d32926c176bffb9d3e2)
- Added missing null check (#6811). [`4d18167`](https://github.com/ImageMagick/ImageMagick/commit/4d18167db34ea2fd199acd99420d61192d708f06)
- cosmetic [`5294889`](https://github.com/ImageMagick/ImageMagick/commit/5294889f22b818a9d861da04daa007d9f0d987ba)
- cosmetic [`39137b5`](https://github.com/ImageMagick/ImageMagick/commit/39137b55ba2e272857d2d594c8e772023ed8c402)
- respect max-memory-request user policy [`8944309`](https://github.com/ImageMagick/ImageMagick/commit/8944309b0c33d43255ed54235351767cca965933)
- support precision user policy [`0729cc4`](https://github.com/ImageMagick/ImageMagick/commit/0729cc47063624f7edc586e5fc2b0c80436ebb90)
- new default time to live [`8f3c56f`](https://github.com/ImageMagick/ImageMagick/commit/8f3c56fabc619c1672865257e5aafe33cbfaaf3e)
- unlimited is INT_MAX [`3a7b915`](https://github.com/ImageMagick/ImageMagick/commit/3a7b915d9a810ce742987b37c935f6ae8b36df10)
- Removed code signing because the certificate expired and will not be renewed. [`82cbd8d`](https://github.com/ImageMagick/ImageMagick/commit/82cbd8d354011c980a3c728aab02f070ec7f6e79)
- release [`71dd750`](https://github.com/ImageMagick/ImageMagick/commit/71dd750c2f4994609e2bc8316d777e2742b72acb)
- eliminate compiler warning [`8bb6d1d`](https://github.com/ImageMagick/ImageMagick/commit/8bb6d1d7aa539cf2183330bc6d4c56b074e0fa3c)
- https://github.com/ImageMagick/ImageMagick/issues/2756 [`d55384f`](https://github.com/ImageMagick/ImageMagick/commit/d55384f5631382b91f628f8af1563bf5cfdbc58a)
- support ODG vector format (https://github.com/ImageMagick/ImageMagick/issues/6827) [`374f6bd`](https://github.com/ImageMagick/ImageMagick/commit/374f6bd97930deeae777c96aaa097b5c1e31ea6a)
- support EPUB format [`ad66448`](https://github.com/ImageMagick/ImageMagick/commit/ad664483ae7a3da7428a7baae1cf7d7175b77ac0)
- headless is implied [`537cff7`](https://github.com/ImageMagick/ImageMagick/commit/537cff789bbe186b4b5435af6a17fd9d126a0b39)
- each image has its own time to live [`e621797`](https://github.com/ImageMagick/ImageMagick/commit/e621797fd9e1d880f3402a759701b66d12a6d6c6)
- Changed titles to subheadings [`b125e60`](https://github.com/ImageMagick/ImageMagick/commit/b125e60bbb66970fe6cfac2df6c3c812bb94e8cf)
- Also run release build when the files is changed in the main branch or through a PR. [`cd5eb99`](https://github.com/ImageMagick/ImageMagick/commit/cd5eb99c3bf9d6fc4a280baa918f0b48c4e4092c)
- Change Linux build to use ubuntu 20.04 instead. [`bab5eea`](https://github.com/ImageMagick/ImageMagick/commit/bab5eea76549ccbc1e4a3cbc00e908081bf23a3e)
- Also test daily build when it is changed in a pull request. [`69cfc00`](https://github.com/ImageMagick/ImageMagick/commit/69cfc0068bb2872e05bec9de1e14d6ff34b4dabe)
- Make sure apt doesn't require user input. [`a05211e`](https://github.com/ImageMagick/ImageMagick/commit/a05211ea58f893d9dd360a47a6c61bed7ee549ae)
- Make sure apt doesn't require user input. [`4c99663`](https://github.com/ImageMagick/ImageMagick/commit/4c9966315443fd431642fdb27541474467297204)
- Also install make. [`3f3ed88`](https://github.com/ImageMagick/ImageMagick/commit/3f3ed880558597b48d904ae47dffc79ab7a09b8e)
- Make sure the correct packages are installed. [`daf6ef0`](https://github.com/ImageMagick/ImageMagick/commit/daf6ef068d2a6b11e5607fe8f709f94cc09ee275)
- https://github.com/ImageMagick/ImageMagick/discussions/6833 [`c491b73`](https://github.com/ImageMagick/ImageMagick/commit/c491b73f2b63011142d0484c25df81f56e066ef2)
- https://github.com/ImageMagick/ImageMagick/discussions/6833 [`6b00651`](https://github.com/ImageMagick/ImageMagick/commit/6b00651f5d9342d91a9978660a21d5a99f0c4540)
- latest autoconf update [`1613e5e`](https://github.com/ImageMagick/ImageMagick/commit/1613e5eb55cb81024d98067bd0ec9e5e9c46e25d)
- Sign executable and libraries with Azure Code Signing. [`dd1190b`](https://github.com/ImageMagick/ImageMagick/commit/dd1190b90f86c9a7521e1ccbcbe06e3dd640e394)
- Removed old .swp file. [`af998d6`](https://github.com/ImageMagick/ImageMagick/commit/af998d612b6ddab6decde476029b90d6738567e9)
- Increase timeout for signing because we sign a lot of files. [`fb02f76`](https://github.com/ImageMagick/ImageMagick/commit/fb02f76da911581ad728cb830f5ebb1660692879)
- Switch to using GetEnvironmentVariableW on Windows (#6843). [`8a69bfb`](https://github.com/ImageMagick/ImageMagick/commit/8a69bfb2f151f9e15cd2c02288b85eb91d522732)
- cosmetic [`c0a6f22`](https://github.com/ImageMagick/ImageMagick/commit/c0a6f2204fd4a669980c17d592a0e99f33081cb1)
- compute statistics for all channels (https://github.com/ImageMagick/ImageMagick/issues/6859) [`75dd448`](https://github.com/ImageMagick/ImageMagick/commit/75dd44883fae0a3f9d05d387fbb242446f11a4c4)
- revert [`08a5dff`](https://github.com/ImageMagick/ImageMagick/commit/08a5dff205905159f1fad597d7884ac47c3b8ee5)
- support channel selection for channel statistics (https://github.com/ImageMagick/ImageMagick/issues/6859) [`b700d0c`](https://github.com/ImageMagick/ImageMagick/commit/b700d0cad67593d6eaa1a509456b4f073f8f95a1)
- Disable code signing in a pull request. [`fe407b4`](https://github.com/ImageMagick/ImageMagick/commit/fe407b420ca536183970e157828d376973de907a)
- Bump azure/azure-code-signing-action from 0.2.21 to 0.2.22 [`9b12430`](https://github.com/ImageMagick/ImageMagick/commit/9b12430c39c52c1da87c75254bbe4a5fdb88cdc9)
- output correct security policy when configuring (https://github.com/ImageMagick/ImageMagick/issues/6863) [`d05b4a4`](https://github.com/ImageMagick/ImageMagick/commit/d05b4a40d6f01adc64fb6627938195f72c2ef122)
- flush any potential write exceptions [`6d5984e`](https://github.com/ImageMagick/ImageMagick/commit/6d5984e1aa9839b9cac3818ed99e24e1a76f6461)
- improve I/O exception checking [`fd06abe`](https://github.com/ImageMagick/ImageMagick/commit/fd06abe79e71ec3166936622d520e5abf621a46f)
- eliminate compiler warnings [`5a50bce`](https://github.com/ImageMagick/ImageMagick/commit/5a50bce3eb509b21bf8a25de8ec22392bb56ab4f)
- improve I/O exception checking [`802ec4d`](https://github.com/ImageMagick/ImageMagick/commit/802ec4dc5ca2ebb14b726011682e95b4bcb12841)
- improve I/O exception handling [`6914a63`](https://github.com/ImageMagick/ImageMagick/commit/6914a6317b1db4f764b947b09437639864e9dd19)
- miscellaneous nit fixes [`ecdb266`](https://github.com/ImageMagick/ImageMagick/commit/ecdb266542fb91d8e9f7a127a6f070361f8ce01b)
- spelling nit [`1fd48ba`](https://github.com/ImageMagick/ImageMagick/commit/1fd48bab5f79bbe43b60e5eae781fbadd86aa1b7)
- the -map option is deprecated (https://github.com/ImageMagick/ImageMagick/issues/6872) [`9d7e276`](https://github.com/ImageMagick/ImageMagick/commit/9d7e276dbb7b623611c3d2058eedbc87235c9d3d)
- blob status is a boolean [`136084e`](https://github.com/ImageMagick/ImageMagick/commit/136084e7dcad88e7e195c50a034571a2b0cce9d8)
- blob status: 0 on success, -1 on exception [`9035e0f`](https://github.com/ImageMagick/ImageMagick/commit/9035e0fc0f4edd922fb468915af4956ba50459f1)
- eliminate compiler warning [`63e9e9b`](https://github.com/ImageMagick/ImageMagick/commit/63e9e9b23efcf7203f2b7ecf0b3a087587b1742f)
- ensure JPEG size is always less than the jpeg:extent value [`43e09d6`](https://github.com/ImageMagick/ImageMagick/commit/43e09d6f1aa3a775ac52e6104bbab14b6de48621)
- cosmetic [`caad14a`](https://github.com/ImageMagick/ImageMagick/commit/caad14a36f150e9501e6f02c877d0d33238d251c)
- need to sync blob before we export its size [`d8b38c2`](https://github.com/ImageMagick/ImageMagick/commit/d8b38c26fcd7df5c82aa457ecf7903079399a2da)
- restore sync to CloseBlob() [`86d2efb`](https://github.com/ImageMagick/ImageMagick/commit/86d2efbbb413c758a0f9c26a9c9c4b88df549a96)
- valid blob size only if there are no I/O exceptions [`f9d3b21`](https://github.com/ImageMagick/ImageMagick/commit/f9d3b2177565c6d5614126b6102b0e65abc7317d)
- No longer include ffmpeg in our installer and portable. [`0c1f0b3`](https://github.com/ImageMagick/ImageMagick/commit/0c1f0b3eb662a208f051f41f501eb3cb9052a95b)
- can't write 8 bit floating-point pixels [`482584c`](https://github.com/ImageMagick/ImageMagick/commit/482584c34f29ab6f7b78d7d5804003e34be1af6a)
- latest autoconf/automake updates [`21fd17a`](https://github.com/ImageMagick/ImageMagick/commit/21fd17aac56320887b4af5d1f21d0683628eb32c)
- latest autoconf/automake updates [`1a9ada9`](https://github.com/ImageMagick/ImageMagick/commit/1a9ada9a3a98dfd2c78ed4f6ca523095a4b1968a)
- some delegates require c++ [`2ed06c8`](https://github.com/ImageMagick/ImageMagick/commit/2ed06c8266e2d4389398e17283e8d25708b03e45)
- throw exception if discovered when syncing a blob [`5fd75c5`](https://github.com/ImageMagick/ImageMagick/commit/5fd75c5566a2bea52e661937d87dbc3397e874f5)
- check external delegate exit code [`7fdd3e5`](https://github.com/ImageMagick/ImageMagick/commit/7fdd3e526c7c19279093a53293cb5c2612b81012)
- flush stdout [`0cbe84e`](https://github.com/ImageMagick/ImageMagick/commit/0cbe84ee77b2de686b19c4fe5c88ea7feef68114)
- eliminate compiler warnings [`898f26c`](https://github.com/ImageMagick/ImageMagick/commit/898f26ce6b1997bdcec0ac5cc8791eff14e9ebb5)
- eliminate compiler warnings [`e83f962`](https://github.com/ImageMagick/ImageMagick/commit/e83f96208419773fae41c72cea7768725805ff8a)
- Enums that are not flags should not be plural. [`8a226d6`](https://github.com/ImageMagick/ImageMagick/commit/8a226d6fdfd782278397493d3b490f47f49b1afd)
- revert [`f79ef2c`](https://github.com/ImageMagick/ImageMagick/commit/f79ef2c823ba89bd69284d970f7f4d74e5956b38)
- MSYS build does not support %zu format specifier [`1d9e98b`](https://github.com/ImageMagick/ImageMagick/commit/1d9e98b6946e8c56940ffa62defde9bed6ab4184)
- export OpenMP library [`4206ff6`](https://github.com/ImageMagick/ImageMagick/commit/4206ff6b7ee3567665f9760e2072f1a31bb2000d)
- cosmetic [`d55033b`](https://github.com/ImageMagick/ImageMagick/commit/d55033b60385eae3e8a95842b13c5d914b976dfb)
- workaround as gcc -x is not reliable in the autoconf/automake environment [`022b98c`](https://github.com/ImageMagick/ImageMagick/commit/022b98c9362e0238b460b397d34d607b4c0e824c)
- cosmetic [`1fcd646`](https://github.com/ImageMagick/ImageMagick/commit/1fcd646540ad8b494a38a246539024e28508d0fa)
- cosmetic [`8d94e5a`](https://github.com/ImageMagick/ImageMagick/commit/8d94e5a8301f25377cd826d0cff511ef107370d7)
- display then write [`e06a8ef`](https://github.com/ImageMagick/ImageMagick/commit/e06a8efe013948bd7e731b724b675b2d6f5e798a)
- clone image list to prevent any possible image side-effects [`a0720c6`](https://github.com/ImageMagick/ImageMagick/commit/a0720c6696b9902fad07a0553a93a872071d6d11)
- ignore gzflush() status [`dd0ee21`](https://github.com/ImageMagick/ImageMagick/commit/dd0ee21097a93e4835aa4bc01db610e4640f1cbe)
- Reverted patch where we switched to from size_t to double and use an unsigned long instead. [`89a94af`](https://github.com/ImageMagick/ImageMagick/commit/89a94af1319a50c2b20add083d944fba3e3e22f3)
- detect libgomp when compiling with C++ [`264c11a`](https://github.com/ImageMagick/ImageMagick/commit/264c11a32ef40adbfd3363ae90dd57fae5c18417)
- corrdct openmp detection [`06011b9`](https://github.com/ImageMagick/ImageMagick/commit/06011b94dbadd8fbf7918d2599a4526b52ba5222)
- Added extra option (--enable-force-cpp) to allow support for 64 bit channels by using a C++ compiler. [`d46f014`](https://github.com/ImageMagick/ImageMagick/commit/d46f0142e5958bf2ee434e043bca30d83ab8665b)
- detect 64-bit channels with c++ compiler [`da2c681`](https://github.com/ImageMagick/ImageMagick/commit/da2c681a868a8f5b7cd23dd77017e1b90cc6aeaf)
- inform if the omp.h header cannot be found [`a373b1f`](https://github.com/ImageMagick/ImageMagick/commit/a373b1fd3978ddca8e2591177280a98210f8fc7f)
- OPENMP fix [`3f09b2c`](https://github.com/ImageMagick/ImageMagick/commit/3f09b2caa5527c1baa63a1cf44674768a62d2f5d)
- Corrected the patch that was made earlier. [`36a6d63`](https://github.com/ImageMagick/ImageMagick/commit/36a6d6379c4e109075ab93189e554677c4d04920)
- revert cloning of image list on write() [`705aef3`](https://github.com/ImageMagick/ImageMagick/commit/705aef3e4f5e6bccec6b543ee088869f7d56d447)
- latest autoconf update [`4aa5d47`](https://github.com/ImageMagick/ImageMagick/commit/4aa5d47a9d081c0920aa8c02406b0507e67a85f3)
- use a portable format as not all installations support JPEG/PNG [`ad861ab`](https://github.com/ImageMagick/ImageMagick/commit/ad861ab4d97ed4783432f1f75b4dd5943543b31b)
- Moving 64 bit channel depth checks back down again because adding the CFLAGS early can break checks for available delegate on MacOS. [`f6ec798`](https://github.com/ImageMagick/ImageMagick/commit/f6ec798cca9496cded119dfe6632053a2cee1a20)
- don't proactively set a floating point MIFF image [`cf9cf47`](https://github.com/ImageMagick/ImageMagick/commit/cf9cf47d078de76fe31f7f46b26672ac95791a13)
- support title attribute [`63b4c12`](https://github.com/ImageMagick/ImageMagick/commit/63b4c12baf9fbf05641efef8a438c9fee1ffdee3)
- support getting title attribute [`c166def`](https://github.com/ImageMagick/ImageMagick/commit/c166def817b44e6e82f9e9723c406894ff68d5f7)
- update demo titles [`2c4205d`](https://github.com/ImageMagick/ImageMagick/commit/2c4205d20c5495f15d706c26084eb327d4b859bb)
- clean up ImageMagick configuration results [`ed06066`](https://github.com/ImageMagick/ImageMagick/commit/ed06066387dd3f97cac876d8e52fdb28596f00db)
- Updated version of ubuntu in the devcontainer. [`2ee2615`](https://github.com/ImageMagick/ImageMagick/commit/2ee26153271b31e72390f9f8257b813a36e2dddf)
- don't sync blob when getting blob (https://github.com/ImageMagick/ImageMagick/issues/6899) [`2c31190`](https://github.com/ImageMagick/ImageMagick/commit/2c311906a233970c909afd9bba99f792774075ee)
- cosmetic [`eec76f4`](https://github.com/ImageMagick/ImageMagick/commit/eec76f4069235e689b355178f45180d1dcb5cbd4)
- respect --disable-openmp [`2fb9b44`](https://github.com/ImageMagick/ImageMagick/commit/2fb9b441b2998336b3f02526d938dc46b554eda5)
- correct signature [`2762497`](https://github.com/ImageMagick/ImageMagick/commit/2762497e9ce8f4dc163b8ba4dc94f82f4d105b33)
- release [`1603187`](https://github.com/ImageMagick/ImageMagick/commit/1603187732acba11ad1cdd6acb0febae7d9184b8)
- Fixed reading Windows 1.x icon file format (#6670) [`592e1e8`](https://github.com/ImageMagick/ImageMagick/commit/592e1e87b05373e808f7af3abce1c9a7a406c4ad)
- cosmetic [`b5350ad`](https://github.com/ImageMagick/ImageMagick/commit/b5350adcb65b31e14afe647bcaec1fa93e196fcc)
- release [`0a4cc80`](https://github.com/ImageMagick/ImageMagick/commit/0a4cc800d0c1308d348ab81c744369443e362212)
- release [`699352e`](https://github.com/ImageMagick/ImageMagick/commit/699352ebed659da36b9aa9ffa21e906766076abc)
- release [`f3bacd1`](https://github.com/ImageMagick/ImageMagick/commit/f3bacd19f67c81cdc764bf95ee3e55a526fccbf9)

## [7.1.1-21](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-20...7.1.1-21) - 2023-10-21

### Merged

- honor pkg-config when searching for bzip2 [`#6785`](https://github.com/ImageMagick/ImageMagick/pull/6785)
- honor pkg-config when searching for libjpeg [`#6784`](https://github.com/ImageMagick/ImageMagick/pull/6784)
- Add the up to date "Artifex" name to Ghostscript list [`#6779`](https://github.com/ImageMagick/ImageMagick/pull/6779)
- Define quantum depth for PerlMagick on windows [`#6770`](https://github.com/ImageMagick/ImageMagick/pull/6770)

### Commits

- beta release [`dc87568`](https://github.com/ImageMagick/ImageMagick/commit/dc87568a6ef9ed3c182d6f69b5f508bb3abdfd9e)
- time-to-live returned incorrect results when SOURCE_DATE_EPOCH set (https://github.com/ImageMagick/ImageMagick6/issues/278) [`3c72750`](https://github.com/ImageMagick/ImageMagick/commit/3c727503c6ae449160dc92cf6222ebe28ef8fb52)
- https://github.com/ImageMagick/ImageMagick/issues/6775 [`bd0fae8`](https://github.com/ImageMagick/ImageMagick/commit/bd0fae83078076f8d4c8a4a2427a5ae59f949253)
- eliminate compiler error [`cc0553c`](https://github.com/ImageMagick/ImageMagick/commit/cc0553cac6045966c7cf7db9908dc0473c95ee8b)
- eliminate compiler warnings [`72cad57`](https://github.com/ImageMagick/ImageMagick/commit/72cad57188ce00369eec4914bfb41e42414ce67a)
- Only use the recent names to do the Ghostscript registry lookup and search for the commercial version first. [`be84f21`](https://github.com/ImageMagick/ImageMagick/commit/be84f21bf3bc98ad68f225532a4e69c769e0c404)
- eliminate rare small memory leak [`199d056`](https://github.com/ImageMagick/ImageMagick/commit/199d056cd2e47d4f2ff3552451fbc4aaccc9d383)
- support time to live neumonics, e.g. 2 minutes [`cdaebe9`](https://github.com/ImageMagick/ImageMagick/commit/cdaebe9fdc663536996fe62abee315ca6818fb34)
- remove private method GetMagickTTL() [`3576c62`](https://github.com/ImageMagick/ImageMagick/commit/3576c625c6f3363ca05fa6adc5119ba087f0d36d)
- moderate the CPU delay [`60bffdb`](https://github.com/ImageMagick/ImageMagick/commit/60bffdba835e7000a0ed710fbb542d53991c571f)
- cosmetic [`23a0ef4`](https://github.com/ImageMagick/ImageMagick/commit/23a0ef433ff5ab8e60aa53b990cf69f1aeda6cc5)
- format time to live [`0d72e02`](https://github.com/ImageMagick/ImageMagick/commit/0d72e02b5f9c4088f1e7e984a0662eef55e490ad)
- cosmetic [`47885ab`](https://github.com/ImageMagick/ImageMagick/commit/47885abe63e80eb48068c125fe8cbd10aeb67265)
- correct # of seconds in month [`d6aa83c`](https://github.com/ImageMagick/ImageMagick/commit/d6aa83c30cd9bab5182f541f54dd2a5d6c932936)
- fix formatting time-to-live [`646c6bd`](https://github.com/ImageMagick/ImageMagick/commit/646c6bdf5af16a9675b98d9e5b2a9ac41cb1ca64)
- clarify time to live [`8845a13`](https://github.com/ImageMagick/ImageMagick/commit/8845a13d77ad9f6784742161e9c4d88491b2ba79)
- utilize difftime() to subtract time to live [`63d39da`](https://github.com/ImageMagick/ImageMagick/commit/63d39da917a7ad4d47f76b1d5c57f9f716cb8246)
- utilize difftime() to subtract time to live [`9bf4b05`](https://github.com/ImageMagick/ImageMagick/commit/9bf4b0542be63e47b8209b66e476be535c92c99e)
- convert source epoch to unsigned long [`623ca54`](https://github.com/ImageMagick/ImageMagick/commit/623ca5491e5035268730055efcd5b76cc07a1c26)
- time to live default is infinity [`e3e9c86`](https://github.com/ImageMagick/ImageMagick/commit/e3e9c86465362ae51942009b2e8eacded8e1b4bf)
- latest autoconf/automake [`dae5e42`](https://github.com/ImageMagick/ImageMagick/commit/dae5e42c83aab2cbe86ce4950edee9c6e07d75dc)
- latest autoconf/automake updates [`207fcee`](https://github.com/ImageMagick/ImageMagick/commit/207fceebae39bb82c0c1897d2708a4c9138f294f)
- assume time_t is signed [`df62446`](https://github.com/ImageMagick/ImageMagick/commit/df6244652acd3453000ece0336db68a5e367a95b)
- largest value is MAGICK_SIZE_MAX [`2d6e79f`](https://github.com/ImageMagick/ImageMagick/commit/2d6e79fab8d9e9aa67d31e22a1aab84dda015312)
- prevent possible integer overlflow [`18fd355`](https://github.com/ImageMagick/ImageMagick/commit/18fd355028e3204cdb993e130e3b10e3d8d37054)
- SetMagickSecurityPolicy() permits user policies to comingle with system policies (https://github.com/ImageMagick/ImageMagick6/issues/279) [`a9d8a08`](https://github.com/ImageMagick/ImageMagick/commit/a9d8a08d4dd87a79adaa5ac3a987997f865033d5)
- eliminate compiler warning [`dd60508`](https://github.com/ImageMagick/ImageMagick/commit/dd60508db0e55dbcea8958a050e97cf07bbddc93)
- eliminate compiler exception [`89c0484`](https://github.com/ImageMagick/ImageMagick/commit/89c04840173945bb336170c35991e7cca650c696)
- permit all user policies [`30906ff`](https://github.com/ImageMagick/ImageMagick/commit/30906fff50cf1aad7f06834ee0ad2cb6304e3b69)
- convert -help should return a success status (https://github.com/ImageMagick/ImageMagick/issues/6797) [`3c559c8`](https://github.com/ImageMagick/ImageMagick/commit/3c559c82c910242c08697f8f515b20ab6fcd1e99)
- -help option now returns a success status [`adbaabf`](https://github.com/ImageMagick/ImageMagick/commit/adbaabfc60f1861402f18c749543dc5a388caefb)
- allow user to comingle with system policies [`ce7a64e`](https://github.com/ImageMagick/ImageMagick/commit/ce7a64e2aa04e000dd12a0ea89a1a430e2f8917b)
- find minimum policy value [`7d0858d`](https://github.com/ImageMagick/ImageMagick/commit/7d0858d996a8a2d4fec808dbe027a55d97da359c)
- find minimum policy value [`f81cd05`](https://github.com/ImageMagick/ImageMagick/commit/f81cd0502b846696e11d9c30522f84911752cfcf)
- revert [`8d94c78`](https://github.com/ImageMagick/ImageMagick/commit/8d94c782a3be825585995f2036c1555b260a8acc)
- eliminate compiler warning [`ecc1473`](https://github.com/ImageMagick/ImageMagick/commit/ecc1473c9ba14cae0587260295b281536ef905b7)
- off by one exception [`8eb046d`](https://github.com/ImageMagick/ImageMagick/commit/8eb046dbf6bad8d2752a7465d17637ce68245712)
- correct bytes per line calculation [`61f444e`](https://github.com/ImageMagick/ImageMagick/commit/61f444e5457e4e506c73f18460133c80c235ebb6)
- revert [`ff50d9a`](https://github.com/ImageMagick/ImageMagick/commit/ff50d9adacce58f6c0edf7c059e9e4f65ea0a95b)
- use PNG default for maximum chunk size [`6408a69`](https://github.com/ImageMagick/ImageMagick/commit/6408a69a2c63953ea2204d19ee89b4a6f5d17f4f)
- clarify SetMagickSecurityPolicy() [`dcffc2d`](https://github.com/ImageMagick/ImageMagick/commit/dcffc2de39b9d7a614b7cf9eb1d427de08f7b5ff)
- release [`58d86e4`](https://github.com/ImageMagick/ImageMagick/commit/58d86e4e107603a95f2f35da99540a2eb69b458d)

## [7.1.1-20](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-19...7.1.1-20) - 2023-10-08

### Commits

- beta release [`59f8951`](https://github.com/ImageMagick/ImageMagick/commit/59f8951c62e6ad32fb71d8fa9027c0fe98f33193)
- ... [`a21e310`](https://github.com/ImageMagick/ImageMagick/commit/a21e31074803bfce4ff4e0c964f3d49007fb98b3)
- support Windows 1.0 Icon format (https://github.com/ImageMagick/ImageMagick/discussions/6670) [`bdc2c9f`](https://github.com/ImageMagick/ImageMagick/commit/bdc2c9f313174fd41d9482b45c6fa6c459c7f245)
- Code cleanup. [`476a094`](https://github.com/ImageMagick/ImageMagick/commit/476a09402f1ee01c13ad0e75b68768a581720c71)
- support GetMagickTTL() method (https://github.com/ImageMagick/ImageMagick/discussions/4533) [`66c30fc`](https://github.com/ImageMagick/ImageMagick/commit/66c30fc2233a187e1e8eacb94b82b9f8523c3d2b)
- fix time-to-live deadlock [`c3d651e`](https://github.com/ImageMagick/ImageMagick/commit/c3d651e8eb0b6e72f69d200064e70997158abdd0)
- improve time-to-live timer [`4727c5e`](https://github.com/ImageMagick/ImageMagick/commit/4727c5e4f6b7178a77699dbf3ccb2de587842fa9)
- prevent integer overflow [`fa9c969`](https://github.com/ImageMagick/ImageMagick/commit/fa9c9690d42dab2d768a63be3b1242b5fceeca80)
- wrong argument type [`bfcdb1e`](https://github.com/ImageMagick/ImageMagick/commit/bfcdb1e02bab99cfb711fe9bb2c927e3f1d855ab)
- respect time to live for Fx option [`b56a48e`](https://github.com/ImageMagick/ImageMagick/commit/b56a48eb78a10063c308120302f2496db6488369)
- let cache throttle the CPU [`6d9069d`](https://github.com/ImageMagick/ImageMagick/commit/6d9069d69eac01d91744035fe6e10049ada9e332)
- Fix indentation. [`47af159`](https://github.com/ImageMagick/ImageMagick/commit/47af15992f62f17d1638ad202baac3ef94040038)
- Added check for MaxPixelChannels. [`8126bac`](https://github.com/ImageMagick/ImageMagick/commit/8126bac76de34b9ac7195623d022904eff544229)
- Added support for reading meta channels when reading a jpeg2000 image. [`3541957`](https://github.com/ImageMagick/ImageMagick/commit/35419576856550c67a4f790ecfadb1f0c053bc5a)
- Added jp2:assume-alpha option that will the always enable the alpha channel when the jpeg2000 image has 2 or 4 channels. [`07fd761`](https://github.com/ImageMagick/ImageMagick/commit/07fd7618bd405b1751eb8d248ccdbd1dbaa38213)
- Corrected check for single channel. [`43f6ada`](https://github.com/ImageMagick/ImageMagick/commit/43f6ada28c0302e44ba1f893ef68a25df1d13909)
- support xmp:validate define to choose performance over security [`c4f9927`](https://github.com/ImageMagick/ImageMagick/commit/c4f9927616a4243314d9e5a798c780a41c4ff27e)
- protect against DOS for FX do, while, for loops [`2cfa8d1`](https://github.com/ImageMagick/ImageMagick/commit/2cfa8d113ad8a7858e61f4294aa9fb032a4714ee)
- Added new deflate library to the pragma lib list. [`ac00eb2`](https://github.com/ImageMagick/ImageMagick/commit/ac00eb297b948a70bc7622062efeb21f1aae5f3f)
- release [`98bb1d4`](https://github.com/ImageMagick/ImageMagick/commit/98bb1d41472d57fb11819a17f5f35c1de0b62bb4)

## [7.1.1-19](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-18...7.1.1-19) - 2023-09-30

### Merged

- Fix building with OpenCL [`#6743`](https://github.com/ImageMagick/ImageMagick/pull/6743)

### Commits

- beta release [`6f91d59`](https://github.com/ImageMagick/ImageMagick/commit/6f91d59440627c50563a24c0c34372239608e949)
- eliminate Coverity warnings [`c9e40fe`](https://github.com/ImageMagick/ImageMagick/commit/c9e40fecef5b7d299cb91330f45b7ea79f35c5d5)
- max result is SIZE_MAX [`a0b5ea7`](https://github.com/ImageMagick/ImageMagick/commit/a0b5ea709626bd9054dca75bc02de461f69410c1)
- check for BMP file size, poc provided by Hardik Shah of Vehere (Dawn Treaders team) [`aa673b2`](https://github.com/ImageMagick/ImageMagick/commit/aa673b2e4defc7cad5bec16c4fc8324f71e531f1)
- throw exception but do not close/destroy image inside ReadEmbedImage() [`43003ed`](https://github.com/ImageMagick/ImageMagick/commit/43003ed37ee2103c050af4d9630198bcf936d12d)
- cosmetic [`047e363`](https://github.com/ImageMagick/ImageMagick/commit/047e36325f3ff8419c01dd6c31bb36c10dcdee38)
- don't trust XMP profile if its not validated [`7e068bb`](https://github.com/ImageMagick/ImageMagick/commit/7e068bb11691bce8cb80a15c02459b6097a84fad)
- don't trust XMP profiles unless they are validated [`25e3a4f`](https://github.com/ImageMagick/ImageMagick/commit/25e3a4f3845f59536d19aba0ac0580aa6715147f)
- eliminate compiler warnings [`1c02b9c`](https://github.com/ImageMagick/ImageMagick/commit/1c02b9cbcdc56e24e8b17b6228b56cafc21ecd32)
- eliminate compiler warnings [`627681b`](https://github.com/ImageMagick/ImageMagick/commit/627681bc193375cba4c3800c81621c61f5f5d71b)
- fix building with OpenCL (#6743) [`086a539`](https://github.com/ImageMagick/ImageMagick/commit/086a53922ac6c661a286363423f8108710c16cff)
- correct exit code (https://github.com/ImageMagick/ImageMagick/issues/6744) [`ffe9809`](https://github.com/ImageMagick/ImageMagick/commit/ffe980977cbae8fb556be9b765a217e3986a9aef)
- Fixed build. [`57db683`](https://github.com/ImageMagick/ImageMagick/commit/57db683e045e02ad5f2fc8d40840a5ae2db82318)
- Don't add svg:decode to the list of build in delegates when librsvg was enabled. [`acb653d`](https://github.com/ImageMagick/ImageMagick/commit/acb653d32fe38c8aeb830f938c1a0f76656d3cbf)
- fix compose dissolve issue (https://github.com/ImageMagick/ImageMagick/issues/6738) [`e31a28a`](https://github.com/ImageMagick/ImageMagick/commit/e31a28ac725b97c3333e1f8fc8209d19f7372f49)
- move check for number of colors [`eec0cf0`](https://github.com/ImageMagick/ImageMagick/commit/eec0cf02851e346d958212a56bb407344c6cdc82)
- release [`ff509f4`](https://github.com/ImageMagick/ImageMagick/commit/ff509f4c0be1dd04e9e930e801bb29871ce0b83f)
- release [`99da019`](https://github.com/ImageMagick/ImageMagick/commit/99da019efe78c44808f2a1c88684e7822a1fd692)

## [7.1.1-18](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-17...7.1.1-18) - 2023-09-23

### Commits

- beta release [`1d60af9`](https://github.com/ImageMagick/ImageMagick/commit/1d60af938761e2a6e85c3c13f6201571d752da76)
- eliminate static analyzer issues [`d26323c`](https://github.com/ImageMagick/ImageMagick/commit/d26323ca2085e8ca5827b483ac81905e4084effe)
- eliminate static analyzer issue [`3b1c29d`](https://github.com/ImageMagick/ImageMagick/commit/3b1c29dd5c53c4ad12404df19c1861d448aa4fc3)
- properly extract EXIF GPS fractions [`66ceff0`](https://github.com/ImageMagick/ImageMagick/commit/66ceff0fde288813570dfb8da5c1cfa647e999d5)
- revert typecast [`2f9247f`](https://github.com/ImageMagick/ImageMagick/commit/2f9247f0af135aab6f5360b461149158c613a8e2)
- eliminate compiler warnings [`839b763`](https://github.com/ImageMagick/ImageMagick/commit/839b76391f17e464bb57509efaf6cc8fac3390d9)
- eliminate compiler warning [`cad0080`](https://github.com/ImageMagick/ImageMagick/commit/cad008045938c07c51e6aa85eb12efc636ccda86)
- eliminiate compiler warnings [`3a04434`](https://github.com/ImageMagick/ImageMagick/commit/3a04434f59dd0711cf614436ea9285a0616975ef)
- set windows to NULL [`a9ff2e4`](https://github.com/ImageMagick/ImageMagick/commit/a9ff2e491e726b3a03f1511b2b4d5bd6364caf3e)
- revert [`ea98b2a`](https://github.com/ImageMagick/ImageMagick/commit/ea98b2a00c742f3a2a9a1c4deb5f02eb54cd5a78)
- Fixed building fourier.c on Windows with Visual Studio (#6667) [`5d732c1`](https://github.com/ImageMagick/ImageMagick/commit/5d732c14f0ea49c3143aabbcaf3e644f184b03b9)
- cosmetic [`8c6cdf5`](https://github.com/ImageMagick/ImageMagick/commit/8c6cdf58eabd7bbbc8e6efe135692da2e65f1568)
- release [`44b2ac8`](https://github.com/ImageMagick/ImageMagick/commit/44b2ac8c0326c895a1663071e129d01cc221bc79)

## [7.1.1-17](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-16...7.1.1-17) - 2023-09-19

### Commits

- beta release [`4b5d266`](https://github.com/ImageMagick/ImageMagick/commit/4b5d2668d6a6d18d1d8f71cb6012b2adb0cff0d4)
- remove absolute path [`fad55f1`](https://github.com/ImageMagick/ImageMagick/commit/fad55f18c1e4b23e20fb05466b96b8026d58ceef)
- validate security policy [`269b573`](https://github.com/ImageMagick/ImageMagick/commit/269b5732cb491f854c9c4ad9f7cc8bc3061e6d64)
- eliminate compiler warning [`5e52c7d`](https://github.com/ImageMagick/ImageMagick/commit/5e52c7d5fc9901dc1fbc6af9ddd34e7a7c480268)
- eliminate compiler warnings [`ebeaa7d`](https://github.com/ImageMagick/ImageMagick/commit/ebeaa7d611436ada0bd81a605f0296656c17d468)
- cosmetic [`f5116ea`](https://github.com/ImageMagick/ImageMagick/commit/f5116ea31571ad7c983b01d144105066d3104df8)
- eliminate compiler warning [`bcd824a`](https://github.com/ImageMagick/ImageMagick/commit/bcd824a06d51757de27c5bb47da31e2d10512092)
- validate policy before we set it [`354c3e4`](https://github.com/ImageMagick/ImageMagick/commit/354c3e45e9a1f9c787c7e2d4bc09f013efe26270)
- release [`44a26b1`](https://github.com/ImageMagick/ImageMagick/commit/44a26b16717b8aa93d42419b1637ed6f6af38b5b)

## [7.1.1-16](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-15...7.1.1-16) - 2023-09-17

### Merged

- Add JPEG-2000 support to AppImage release (Partially solve #4666) [`#6630`](https://github.com/ImageMagick/ImageMagick/pull/6630)

### Commits

- beta release [`922dd8d`](https://github.com/ImageMagick/ImageMagick/commit/922dd8dd3f9c562c2081acaaf9610f9889649b50)
- option to display build compiler [`cf690f5`](https://github.com/ImageMagick/ImageMagick/commit/cf690f5f2a6772609817aa4b976489dcf1a41afe)
- Correct error message. [`23d31cb`](https://github.com/ImageMagick/ImageMagick/commit/23d31cbf2741657e526101b97de973162162cdc6)
- eliminate compiler warnings [`2686655`](https://github.com/ImageMagick/ImageMagick/commit/268665556631a759e63890fd7948f4306903ddb0)
- Fix possible memory leak when format doesn't support encoding (#6538). [`d551c5e`](https://github.com/ImageMagick/ImageMagick/commit/d551c5ed4fa9c40d9aa22875a56eb104b14fb374)
- validate the maximum meta channels in an image [`72228b5`](https://github.com/ImageMagick/ImageMagick/commit/72228b560c4c044645fcc7c07ad8255c6262a1f6)
- eliminate compiler warnings [`7275424`](https://github.com/ImageMagick/ImageMagick/commit/7275424444884c346169dfaa9beb383e5edb966a)
- read APNG losslessly [`1b95976`](https://github.com/ImageMagick/ImageMagick/commit/1b9597600eba7f2909b9024e00947c6031707e13)
- eliminate compiler warnings [`88ff143`](https://github.com/ImageMagick/ImageMagick/commit/88ff143a5192424a0ffc4ce10cbd62a68ac52058)
- eliminate compiler warning [`5e2b42a`](https://github.com/ImageMagick/ImageMagick/commit/5e2b42a023701f4bcc13a3d6ae87d7f2f9ce0638)
- eliminate compiler warnings [`9cd23d1`](https://github.com/ImageMagick/ImageMagick/commit/9cd23d18e9d81103580d8417be57dd529a3a58bf)
- eliminate compiler warnings [`3e4f327`](https://github.com/ImageMagick/ImageMagick/commit/3e4f327d44acc41538b86c1386048d8e489d9c7c)
- Refactored reading of the optional header. [`d8b7400`](https://github.com/ImageMagick/ImageMagick/commit/d8b7400a0ed79c95797312f1e8251d8fa3a95675)
- Write optional TGA header that seems to be required by Autodesk MotionBuilder (#6543) [`8de013f`](https://github.com/ImageMagick/ImageMagick/commit/8de013fbba4f57ac813ca983dd4550ddeab0e992)
- limit the number of XCF layers [`d994be8`](https://github.com/ImageMagick/ImageMagick/commit/d994be84980d38ff3ff56889b60e663307844249)
- OpenMP advisement [`b826502`](https://github.com/ImageMagick/ImageMagick/commit/b826502646db4c97ca2334d244f04d17900f6f81)
- eliminate compiler warnings [`ed6b79c`](https://github.com/ImageMagick/ImageMagick/commit/ed6b79c7e33818c52b418871c4cb1d05db461f02)
- check the image list length [`4c3e20c`](https://github.com/ImageMagick/ImageMagick/commit/4c3e20c95caeb161e97b83bb34816dd405a423d5)
- eliminate compiler warnings [`36a7ca0`](https://github.com/ImageMagick/ImageMagick/commit/36a7ca0c414865bd42ba14b313dbf2db558c31da)
- eliminate compiler warnings [`f0cb789`](https://github.com/ImageMagick/ImageMagick/commit/f0cb789245a17a06595cad5b88c070d2a44f59ed)
- eliminate compiler warnings [`bc26662`](https://github.com/ImageMagick/ImageMagick/commit/bc26662a2369f984cae997113b39553cfda280b3)
- Removed the size_t overload of roll and only use the ssize_t variant. [`7bc8813`](https://github.com/ImageMagick/ImageMagick/commit/7bc8813726f7b124863124bbaefa032870634333)
- eliminate compiler warnings [`8cc8fff`](https://github.com/ImageMagick/ImageMagick/commit/8cc8fff59abaaf22760587c3284b1b30fe115ed1)
- Fixed memory leak in AcquireDrawingWand that occurs when image is null (#6544) [`e2cc296`](https://github.com/ImageMagick/ImageMagick/commit/e2cc29636f63f7cf8133f7f4c17812069ac08fe9)
- Fixed build. [`5d325ea`](https://github.com/ImageMagick/ImageMagick/commit/5d325ea4370130f4acb4fe2a2a051d606b379366)
- Correct writing of the last zero byte. [`a6dc5c1`](https://github.com/ImageMagick/ImageMagick/commit/a6dc5c1f3b3a8569017bbbdfe243253ddf38b6ea)
- Initialize gamma and chromaticity with a double instead. [`fefcddc`](https://github.com/ImageMagick/ImageMagick/commit/fefcddcd76b689354a29cf73be2f0f77cd4156d7)
- eliminate compiler warnings [`24abe7b`](https://github.com/ImageMagick/ImageMagick/commit/24abe7b432d9dd967a951bf453b1d2138520304b)
- support new configure script option: --with-security-policy={open,limited,secure,web-safe} [`8ada13b`](https://github.com/ImageMagick/ImageMagick/commit/8ada13b51a7639fbe4fcc347e3a4e0cc79059d7f)
- eliminate compiler warnings [`d33cf20`](https://github.com/ImageMagick/ImageMagick/commit/d33cf20b17676a665fba6934fa95430175ca1eac)
- update documentation [`53a44eb`](https://github.com/ImageMagick/ImageMagick/commit/53a44ebc648416a4157319747769aa870ce485f8)
- eliminate compiler warnings [`a64496f`](https://github.com/ImageMagick/ImageMagick/commit/a64496fc632caf60326c8f2b0d61417dd0d25c76)
- security policy configuration [`8aaf660`](https://github.com/ImageMagick/ImageMagick/commit/8aaf66058490b248e347a65134cd66787ba9bb76)
- eliminate compiler warnings [`9a41b2d`](https://github.com/ImageMagick/ImageMagick/commit/9a41b2d55e29dd9a91cb63a13c1c45cdc7f1699f)
- baseline security policies [`d2f093c`](https://github.com/ImageMagick/ImageMagick/commit/d2f093cfd9e8da22d1f096c3da17e553662e294f)
- security policy patch [`d2f0a47`](https://github.com/ImageMagick/ImageMagick/commit/d2f0a474c60075812d75a3e8c495d482ee23411c)
- update security policy variants [`dd30f68`](https://github.com/ImageMagick/ImageMagick/commit/dd30f68fd48a7cbdd1668836c75d64145513afd0)
- eliminate compiler warnings [`7b9b4ae`](https://github.com/ImageMagick/ImageMagick/commit/7b9b4ae386431a6af28114d2ac29a37f6845fe0d)
- eliminate compiler warnings [`86bd75b`](https://github.com/ImageMagick/ImageMagick/commit/86bd75b7ce8694f34302f207c2d5afe2295623e4)
- ... [`b2834ac`](https://github.com/ImageMagick/ImageMagick/commit/b2834acb08a2818138de2ca9d42483fe381d14f1)
- ... [`53a3f17`](https://github.com/ImageMagick/ImageMagick/commit/53a3f17a1e025844a4d6d6802608e3e9c7e9609b)
- eliminate compiler warnings [`1c7a0f6`](https://github.com/ImageMagick/ImageMagick/commit/1c7a0f63db8bd56af21618fa54fbd1bb32b884ac)
- ... [`98d4a72`](https://github.com/ImageMagick/ImageMagick/commit/98d4a7247d00d29258b178e9056ff4646f8e623b)
- Removed incorrect typecast. [`76b7dfa`](https://github.com/ImageMagick/ImageMagick/commit/76b7dfa5fa60bbb582f9ba362e05034f5980485f)
- Fixed another typecast. [`931761e`](https://github.com/ImageMagick/ImageMagick/commit/931761ea1b563aef5576728029faeec24d177591)
- eliminate compiler warnings [`4a3f1cb`](https://github.com/ImageMagick/ImageMagick/commit/4a3f1cb05ca2d4d007c6cd18672bbc6e4022e39a)
- eliminate compiler warnings [`f5bdfdd`](https://github.com/ImageMagick/ImageMagick/commit/f5bdfdd62af7109ad105f8af4e28111e353edecd)
- Added missing typecasts. [`0bb4b07`](https://github.com/ImageMagick/ImageMagick/commit/0bb4b0781f78a7af484ebc0e727ab4ff6ac8e6f5)
- ... [`fd5261b`](https://github.com/ImageMagick/ImageMagick/commit/fd5261bd9a946ad01bc03a4626d2f747a569e812)
- eliminate compiler warnings [`13a8403`](https://github.com/ImageMagick/ImageMagick/commit/13a8403d6422d092273ba880467c101703823f11)
- ... [`e26986e`](https://github.com/ImageMagick/ImageMagick/commit/e26986e721ace46e9ea66cad10a3ab7b0cb86b8c)
- eliminate compiler warnings [`f12d5cd`](https://github.com/ImageMagick/ImageMagick/commit/f12d5cd3ba39f59f04cbbe3acafbaf09891d782c)
- eliminate compiler warnings [`704a3bd`](https://github.com/ImageMagick/ImageMagick/commit/704a3bd26f5a544af32dbed75866ca1f24c64f10)
- Use the correct abs method instead. [`a844266`](https://github.com/ImageMagick/ImageMagick/commit/a844266dbfd274c75bcc8c66d7a06e51afb48184)
- eliminate compiler warnings [`20fbdea`](https://github.com/ImageMagick/ImageMagick/commit/20fbdeaa82bc6b67ddebe85a46650b3906b77031)
- eliminate compiler warnings [`bca743b`](https://github.com/ImageMagick/ImageMagick/commit/bca743becfa97355f3905eab6e68ecc8b91300d9)
- eliminate compiler warnings [`4b84297`](https://github.com/ImageMagick/ImageMagick/commit/4b842975d3519079d7348886951f86638c93d51b)
- eliminate compiler warnings [`78aa540`](https://github.com/ImageMagick/ImageMagick/commit/78aa5404db70a4366b0fe2972a62b30edcdcd6cb)
- eliminate compiler warnings [`e53e985`](https://github.com/ImageMagick/ImageMagick/commit/e53e9859aa6e03d0d65213428287400373320f44)
- Fixed windows build. [`a896e77`](https://github.com/ImageMagick/ImageMagick/commit/a896e779eb104cfacf566d3408882a70a54bff6f)
- Removed NTUserTime method because we stopped supporting WindowsNT a while ago. [`bc70f31`](https://github.com/ImageMagick/ImageMagick/commit/bc70f3119cdbb6ae8a69ed2763fbf8c0785114be)
- Corrected type of extent. [`566c63f`](https://github.com/ImageMagick/ImageMagick/commit/566c63fcb0909f6540178040738593c2ebd11bc0)
- Added missing typecast. [`4b93217`](https://github.com/ImageMagick/ImageMagick/commit/4b9321756d3b135bf4c27eb13bc69b3758d5fa76)
- eliminate compiler warnings [`3349f50`](https://github.com/ImageMagick/ImageMagick/commit/3349f50cc26ee0469ac1d2ea065eb92e07b2d9a9)
- eliminate compiler warnings [`efcc0e3`](https://github.com/ImageMagick/ImageMagick/commit/efcc0e38e35da115571f6e96a34b16020815e4cf)
- Removed broken OpenCL AddNoiseImage implementation. [`85657bc`](https://github.com/ImageMagick/ImageMagick/commit/85657bc9e27c06e0680692e62a019b336b290196)
- Removed broken OpenCL ConvolveImage implementation. [`ed6c2fc`](https://github.com/ImageMagick/ImageMagick/commit/ed6c2fca6e84ce92bc8a59aba06dc91c6107653a)
- Added missing comment. [`ac6826c`](https://github.com/ImageMagick/ImageMagick/commit/ac6826c2ee9a801eb89b05656355db75c3bf9103)
- Fixed the Windows build. [`0d42a10`](https://github.com/ImageMagick/ImageMagick/commit/0d42a10e3a0b5c82bd9ae041bcb5d12582db4133)
- Added missing typecast. [`de79a6f`](https://github.com/ImageMagick/ImageMagick/commit/de79a6f95aa03a6e29f07190799213597f27de6f)
- Moved include to the correct file. [`20c88c2`](https://github.com/ImageMagick/ImageMagick/commit/20c88c2d46f6b823b7ff32e74b26b726b428a5e1)
- Only call SetPixelMetaChannels once and only when we need to. [`21c3aab`](https://github.com/ImageMagick/ImageMagick/commit/21c3aab7cb15722a9b07785b71411fc9bfefec55)
- Use the association of the first extra sample that is an alpha channel. [`58a3b36`](https://github.com/ImageMagick/ImageMagick/commit/58a3b36f73058ba5ad4fbc590cc739312de073ef)
- support 64-bit channel masks [`226a66f`](https://github.com/ImageMagick/ImageMagick/commit/226a66f51e53a39beceb49fa7f29bd0c1ff53155)
- Added extra check. [`9d4a494`](https://github.com/ImageMagick/ImageMagick/commit/9d4a4949fe73fb9a269ebddb6d3232449ae16438)
- Removed assert from header files to try to fix the build. [`537a5a5`](https://github.com/ImageMagick/ImageMagick/commit/537a5a5eb3448ec033d52897ed5c71f3883976b9)
- Correct previous patch to replace HDRI_ENABLE_OBSOLETE_IN_H with MAGICKCORE_CHANNEL_MASK_DEPTH. [`209043d`](https://github.com/ImageMagick/ImageMagick/commit/209043de2ac24cec6d6d8431fff4ed94b604cf4b)
- support MAGICKCORE_64BIT_CHANNEL_MASK_SUPPORT define [`f5abb90`](https://github.com/ImageMagick/ImageMagick/commit/f5abb90e2b7ca0de1bc6be85938c33052d7fc857)
- add channel mask value to configure output [`30b278e`](https://github.com/ImageMagick/ImageMagick/commit/30b278e3e418bcfa28ec88df6ddd2e6f2e68f31d)
- eliminate compiler warnings [`803391d`](https://github.com/ImageMagick/ImageMagick/commit/803391ddaefd0b019f4ca0ad11bd42cad3e6fccb)
- eliminate compiler warning [`5254e93`](https://github.com/ImageMagick/ImageMagick/commit/5254e93c6a8c244c51b3fb15feaa480697c34d39)
- fix comparison of integers of different signs issue [`3ceb89e`](https://github.com/ImageMagick/ImageMagick/commit/3ceb89e4a1caa12ab36f6573a5f54471acdfd2bf)
- fix comparison of integers of different signs [`9ee489c`](https://github.com/ImageMagick/ImageMagick/commit/9ee489c19a8dea7949ff4082c2c2189b85872abe)
- fix comparison of integers of different signs [`2abeeac`](https://github.com/ImageMagick/ImageMagick/commit/2abeeac952a5947a9c1193d509b372c6f3b077bc)
- check against valid chunk sizes [`dd5c065`](https://github.com/ImageMagick/ImageMagick/commit/dd5c0652442310342d837004ed1e64545ed3a490)
- eliminate compiler warnings [`b4f7aa8`](https://github.com/ImageMagick/ImageMagick/commit/b4f7aa8372a8fac1e5d7061345cd1a8a400887a3)
- fix comparison of integers of different signs [`557db5d`](https://github.com/ImageMagick/ImageMagick/commit/557db5de50bffe969f133be81531812463a41018)
- fix comparison of unsigned expression &lt; 0 [`54387bf`](https://github.com/ImageMagick/ImageMagick/commit/54387bf1f9455881670223b2b88ec9e704110a3a)
- fix comparison of unsigned expression [`f550f1a`](https://github.com/ImageMagick/ImageMagick/commit/f550f1adb3d0926c7d8459c3b45ffd7028254e1c)
- fix comparison of unsigned expression [`8c4f48c`](https://github.com/ImageMagick/ImageMagick/commit/8c4f48c5764a904b4a17b97a24cc3dc39c71dac6)
- fix comparison of unsigned expression [`cb564ee`](https://github.com/ImageMagick/ImageMagick/commit/cb564ee134f563d9bc2feaf5abd4d78ae02bc76d)
- support for 64-bit channel masks [`6812621`](https://github.com/ImageMagick/ImageMagick/commit/68126210ec6d42a607db1dc56f02cd80aad5c127)
- eliminate compiler warnings [`a184aad`](https://github.com/ImageMagick/ImageMagick/commit/a184aad94c9592188e351c6f62bd2a3e67278950)
- eliminate compiler warnings [`c590841`](https://github.com/ImageMagick/ImageMagick/commit/c590841f61f69c4d97536aed34444689e9949758)
- eliminate compiler warnings [`8140fde`](https://github.com/ImageMagick/ImageMagick/commit/8140fdeb2c4aa0d95be8929cfbc0fdd6778699cc)
- eliminate compiler warnings [`cae92e5`](https://github.com/ImageMagick/ImageMagick/commit/cae92e576a1dc1c70b17f61c5460ee2dd1d7421f)
- more accurate PI [`f4eb5db`](https://github.com/ImageMagick/ImageMagick/commit/f4eb5dbcfb226856d449372c53808da2bde3bb56)
- check for 64-bit channel mask support [`3d27129`](https://github.com/ImageMagick/ImageMagick/commit/3d271292ef3949ac3077ad8b7bf791cdef0df160)
- 64-bit channel mask support [`a2f3026`](https://github.com/ImageMagick/ImageMagick/commit/a2f302686c3ca088f3e297fb7a475f00b21ee695)
- check stat() status [`a75951b`](https://github.com/ImageMagick/ImageMagick/commit/a75951bbdc81c1bfe1c7a17202f9b94948075aa4)
- fix comparison of integers of different signs [`8e56810`](https://github.com/ImageMagick/ImageMagick/commit/8e56810412e5b53d0308d09cad7aaacd96f74b23)
- fix comparison of integers of different signs [`dea2fc6`](https://github.com/ImageMagick/ImageMagick/commit/dea2fc650c20aa4512ba8a4d19bdd968b3ff7c6d)
- fix comparison of integers of different signs [`239fad2`](https://github.com/ImageMagick/ImageMagick/commit/239fad2c98197f5ef3f0aa55db741576571e0e1e)
- eliminate compiler warning [`a7c894f`](https://github.com/ImageMagick/ImageMagick/commit/a7c894f54f8d12af4d831e8b85b6d20563df05fa)
- eliminate compiler warnings [`c3b30d2`](https://github.com/ImageMagick/ImageMagick/commit/c3b30d2bee2163a551b77e055004aafa24c5dbc0)
- fix possible loss of data issue [`5bf8645`](https://github.com/ImageMagick/ImageMagick/commit/5bf8645839cda5279063710409c435f0b5b757f6)
- Corrected checks for defines. [`3e8325b`](https://github.com/ImageMagick/ImageMagick/commit/3e8325b376987098362030453e9e87c72ac2610b)
- use libraw’s camera white balance adjustment as default, use dng:use-camera-wb=false to disable [`80436de`](https://github.com/ImageMagick/ImageMagick/commit/80436de0e99f6a6186de5205501e483920ee61f5)
- eliminate compiler warnings [`f8dcef2`](https://github.com/ImageMagick/ImageMagick/commit/f8dcef24e898cad1f20b84282f7fdeeccda283b8)
- fix comparison of integers of different signs [`b0f0b93`](https://github.com/ImageMagick/ImageMagick/commit/b0f0b93649ff2e24119dfe6313416244828b74ad)
- Added missing typecast. [`a3a1903`](https://github.com/ImageMagick/ImageMagick/commit/a3a19039476387a1ddc2e45fc1365c03fc822620)
- Added missing braces. [`7575db0`](https://github.com/ImageMagick/ImageMagick/commit/7575db0d421595702ed08b8893be8e5f547cfaad)
- Use if statement instead of switch. [`551b0cd`](https://github.com/ImageMagick/ImageMagick/commit/551b0cd213c87dad28e640681a295caa5de62584)
- eliminate compiler warnings [`39fbfed`](https://github.com/ImageMagick/ImageMagick/commit/39fbfedd86de66b01d62fb1bbbc59cc5b93bbeac)
- eliminate compiler warnings [`5384a8f`](https://github.com/ImageMagick/ImageMagick/commit/5384a8ff090b8a61b3a36d9f6c2c0b8d0e416d90)
- adjust shave thresholds [`2d04ce5`](https://github.com/ImageMagick/ImageMagick/commit/2d04ce5423b80777f42be5de02ea5c9666cf3746)
- restore crop transform [`7a159d6`](https://github.com/ImageMagick/ImageMagick/commit/7a159d69b9908128ae38545041b89211ad1a3828)
- Corrected typecast. [`bfe52fa`](https://github.com/ImageMagick/ImageMagick/commit/bfe52fa28d406b513c28acd096f9a34192085887)
- Corrected type casts. [`695a4a5`](https://github.com/ImageMagick/ImageMagick/commit/695a4a5133f24c613a42cfe8ce16e846b8f1127f)
- Removed incorrect type. [`510923d`](https://github.com/ImageMagick/ImageMagick/commit/510923d4b653d9b64dfa998cbbe85cd2872c12b1)
- eliminate compiler warning [`66185e4`](https://github.com/ImageMagick/ImageMagick/commit/66185e4b8581ff23f5823189a1fb3479ca73a6b2)
- eliminate compiler warnings [`796631d`](https://github.com/ImageMagick/ImageMagick/commit/796631d9e029f61a86b3bec01154b81c6160f182)
- fix comparison of integers of different signs issue [`3ea656f`](https://github.com/ImageMagick/ImageMagick/commit/3ea656f181f29252158023e2b4a9c952dd019098)
- eliminate compiler warnings [`a69c64e`](https://github.com/ImageMagick/ImageMagick/commit/a69c64eb7a4d5ebaca6dd96de67548e246d27479)
- fix comparison of integers of different signs [`bc0db50`](https://github.com/ImageMagick/ImageMagick/commit/bc0db5020df03181afe48d4c2904d81feb3d4348)
- Added missing typecast. [`33b968c`](https://github.com/ImageMagick/ImageMagick/commit/33b968c2f4baac0daa92bbe7cb9548dfdb17b974)
- prevent possible signed integer overflow [`e265602`](https://github.com/ImageMagick/ImageMagick/commit/e265602bdb29697cf45604e44ac5c2e72e2c2899)
- eliminate compiler warnings [`3526338`](https://github.com/ImageMagick/ImageMagick/commit/3526338382bd4ae21c62a612d553b30dfb5158a4)
- signed overflow check [`8e0458d`](https://github.com/ImageMagick/ImageMagick/commit/8e0458d154deda252a46db4ccb9b5cb8057b8cbc)
- signed overflow check [`71daf53`](https://github.com/ImageMagick/ImageMagick/commit/71daf5391e6cdf2ea1938634632eff9acb7d2723)
- Removed switch statements that only have a default case. [`77708ef`](https://github.com/ImageMagick/ImageMagick/commit/77708ef3d462aa4a7c4ed1560f43bd7b32535d5a)
- WEBP now respects ping (https://github.com/ImageMagick/ImageMagick/issues/6572) [`8582026`](https://github.com/ImageMagick/ImageMagick/commit/858202643f9348d4148b4e3dc4b6d9ebbe2b440d)
- egrep is deprecated [`0ca2131`](https://github.com/ImageMagick/ImageMagick/commit/0ca2131d15f8d8ce5c975f3308e181e5be72b70d)
- fix bug report address [`f226dcf`](https://github.com/ImageMagick/ImageMagick/commit/f226dcf87c0bdd197841750491e8fb3d410b193d)
- eliminate compiler warnings [`bb7e9d3`](https://github.com/ImageMagick/ImageMagick/commit/bb7e9d310e9e194aa573e31dbe8645d82c7b833a)
- eliminarte compiler warnings [`3e9a05a`](https://github.com/ImageMagick/ImageMagick/commit/3e9a05a0243c6870cdac9dd38b74c7839267235e)
- eliminate compile warnings [`2b42758`](https://github.com/ImageMagick/ImageMagick/commit/2b4275854b36f7393cc6590e13430b7fa96f8f3f)
- Corrected name of library. [`ded0dbc`](https://github.com/ImageMagick/ImageMagick/commit/ded0dbca617e436c02597afa310fa2a8d7f95a59)
- eliminate compiler warnings [`b0299c2`](https://github.com/ImageMagick/ImageMagick/commit/b0299c286d4776a34cf17c48b767a5d1a9e7ddb9)
- document each policy [`d2f76aa`](https://github.com/ImageMagick/ImageMagick/commit/d2f76aa8fd739da09750c087734824cfcf528b6b)
- tweaks to default security policies [`851cb59`](https://github.com/ImageMagick/ImageMagick/commit/851cb5957cff37f0de7a139b5fa063477e558d04)
- validate policies @ https://imagemagick-secevaluator.doyensec.com/ [`daf5574`](https://github.com/ImageMagick/ImageMagick/commit/daf5574904f9e0d390b27e8127deef186cfe1532)
- Silence warnings for when MAGICKCORE_ZERO_CONFIGURATION_SUPPORT is enabled. [`07cf50a`](https://github.com/ImageMagick/ImageMagick/commit/07cf50abda3617b82cad37966c491e227380f50f)
- we broke exif parser, fixed [`aa85ee9`](https://github.com/ImageMagick/ImageMagick/commit/aa85ee954d238594c1cd7f91dade557b300f657d)
- silence compiler warning [`67e39d5`](https://github.com/ImageMagick/ImageMagick/commit/67e39d5b42146fa606ac0b3ff583156e09a6a681)
- respect `ping` when reading DJVU images (https://github.com/ImageMagick/ImageMagick/issues/6584) [`b114ea4`](https://github.com/ImageMagick/ImageMagick/commit/b114ea41095707bda4da852900abecc109920bc1)
- prevent signed overflow [`4ffab22`](https://github.com/ImageMagick/ImageMagick/commit/4ffab22113e853e6c57f8fb881fc9edd66b40125)
- properly extract EXIF multiple values [`4804d61`](https://github.com/ImageMagick/ImageMagick/commit/4804d612486db0be8941b89ce93890e9d6eb61c7)
- check for 4 channel image with alpha (https://github.com/ImageMagick/ImageMagick/issues/6507) [`cc548c7`](https://github.com/ImageMagick/ImageMagick/commit/cc548c7ff96d381605d68c3156d5baa35f2d8afa)
- three channels switch is now the default [`43b7c06`](https://github.com/ImageMagick/ImageMagick/commit/43b7c06db0dd8f2b528e56670b5bdb5245d21a7a)
- eliminate possible integer overflow [`e9b0df0`](https://github.com/ImageMagick/ImageMagick/commit/e9b0df0a7d71dd3ecb56db398a3c3a79456d49a9)
- Added missing typecasts. [`72b9385`](https://github.com/ImageMagick/ImageMagick/commit/72b93852dfcecfcc40fb4f6496d169697f7aea80)
- silence compiler warnings [`4ba41bb`](https://github.com/ImageMagick/ImageMagick/commit/4ba41bb1103c335448b4919be8e187bdfc8bc8de)
- mention the security policy validator [`04607c0`](https://github.com/ImageMagick/ImageMagick/commit/04607c09dd5eb8f7396e90c4d8eeda5d88d38923)
- set max pixel width/height to 4K [`d3b520e`](https://github.com/ImageMagick/ImageMagick/commit/d3b520e5499f13faf74f1f9bd397d8e5e74d5898)
- correct spelling error [`d39cfc7`](https://github.com/ImageMagick/ImageMagick/commit/d39cfc7ab541f5ec74428e9d1439823aaa3cec1b)
- Removed volatile keyword. [`76fe200`](https://github.com/ImageMagick/ImageMagick/commit/76fe2006217d8b3fbbdb59a1904919910ce26fac)
- improve policy description [`d947a26`](https://github.com/ImageMagick/ImageMagick/commit/d947a26aeae75cd48057acafe190b2e9af0de9b1)
- Added missing comma. [`f44c0d8`](https://github.com/ImageMagick/ImageMagick/commit/f44c0d8ba7b7dbed7d82a8191129692f44617c04)
- Switch to uppercase. [`1bca2e1`](https://github.com/ImageMagick/ImageMagick/commit/1bca2e1a28bbc36143d4d39d7ead62928be04db1)
- Minor cleanup. [`a4a3a03`](https://github.com/ImageMagick/ImageMagick/commit/a4a3a03b8b5bdb118ebb688f409af5303044946a)
- Corrected values for meta channel bits. [`f8f72a0`](https://github.com/ImageMagick/ImageMagick/commit/f8f72a0ecef70723916157de0ac11ba733686a81)
- Group policy files together. [`2e529f6`](https://github.com/ImageMagick/ImageMagick/commit/2e529f63e1f4ef548de956d99fc8aa76e7bd1685)
- latest automake/autoconf [`33b7e73`](https://github.com/ImageMagick/ImageMagick/commit/33b7e73d85a8d0b7d98abfa2fa4ef39343dc7fb1)
- fix HSL modulation when hue is 60 (https://github.com/ImageMagick/ImageMagick/issues/6602) [`458321d`](https://github.com/ImageMagick/ImageMagick/commit/458321d723a193a9821fdb7ed82560e79af8c68d)
- limit the number of unit test threads [`d031f9d`](https://github.com/ImageMagick/ImageMagick/commit/d031f9d32ed364736fcf7d3e2956848693441ce7)
- Removed unused define. [`4245260`](https://github.com/ImageMagick/ImageMagick/commit/42452607d7f410d99dc956fed15998eb2e1013fb)
- Moved Debug back to the start of the feature list. [`dcf9558`](https://github.com/ImageMagick/ImageMagick/commit/dcf95586d9ff7b9c8661665efb350b8b3103c6b1)
- proper check if maximum channels are exceeded [`840e345`](https://github.com/ImageMagick/ImageMagick/commit/840e3454e5415a45ecb4e6befb4f9a068b863731)
- support LERC compression [`dbeaafc`](https://github.com/ImageMagick/ImageMagick/commit/dbeaafc95605660aedea7014ad4eed0e23ff0142)
- more support for 64-bit channel masks [`3327dda`](https://github.com/ImageMagick/ImageMagick/commit/3327dda5b795a403f91202db74706c988ae84019)
- support for 64-bit channel masks [`c37f121`](https://github.com/ImageMagick/ImageMagick/commit/c37f121ea1cd67b8d38ab3827b6f5ca5ab402ba8)
- improve security policy docs [`70907a9`](https://github.com/ImageMagick/ImageMagick/commit/70907a91bfaa2a2a022254febd4ff4bff358fede)
- support 64-bit channel masks [`eaef272`](https://github.com/ImageMagick/ImageMagick/commit/eaef272ff0b7207a664e5a4fb0b0d2be9ae5a7b5)
- Corrected option values. [`b70969e`](https://github.com/ImageMagick/ImageMagick/commit/b70969e6e4af76fd1bd3f0c8240ed39f850b339d)
- Corrected settings the define for CHANNEL_MASK_DEPTH (MAGICKCORE will already be added) [`cb3f98c`](https://github.com/ImageMagick/ImageMagick/commit/cb3f98c519a86333ba08eaff20dc17ccce94d30d)
- Make sure the value is zero padded. [`d99cdd4`](https://github.com/ImageMagick/ImageMagick/commit/d99cdd4ffe6b049a22f63580d9315506555e9ee2)
- lastest autoconf/automake updates [`54c41b4`](https://github.com/ImageMagick/ImageMagick/commit/54c41b4d202c9d673476dcca97426a8582a74518)
- Try to force the use of a C++ compiler for the PerlMagick windows build. [`61d02ae`](https://github.com/ImageMagick/ImageMagick/commit/61d02aebf33792021e5125bd7271768b5fb6824a)
- account for extra bytes at end of a DICOM image (https://github.com/ImageMagick/ImageMagick/issues/6566) [`4cf2892`](https://github.com/ImageMagick/ImageMagick/commit/4cf2892d069ad67e59d2759661bed6e71d91185f)
- Added missing typecast. [`1e30a4b`](https://github.com/ImageMagick/ImageMagick/commit/1e30a4be13e550cd6858129c7f4828b7544d3915)
- Added missing typecast. [`6f9eed9`](https://github.com/ImageMagick/ImageMagick/commit/6f9eed9d8b835b9cb479d62b590fdd59bcfa0762)
- comparison of integers of different signs [`11d8425`](https://github.com/ImageMagick/ImageMagick/commit/11d84251e428036999c01f9cd2e355f300fd1f8a)
- remove compiler warnings [`afd5c67`](https://github.com/ImageMagick/ImageMagick/commit/afd5c67d7b1a1c85c9d5963c61e6d9149422400b)
- improved C++ support [`1fbce73`](https://github.com/ImageMagick/ImageMagick/commit/1fbce730ea928ba33f048bde35031a97b2c3c5ba)
- eliminate compiler warning [`1b7b305`](https://github.com/ImageMagick/ImageMagick/commit/1b7b305b38c26a9acdf8099dc0c13ba4d7fe5647)
- prevent a possible double link free [`9b22513`](https://github.com/ImageMagick/ImageMagick/commit/9b2251346a2fea508ce2faef5b99a47b9c39b877)
- cosmetic [`ffbaae2`](https://github.com/ImageMagick/ImageMagick/commit/ffbaae2a580f16f5b0d7818b21a9f9a4adb17de3)
- allow MPC images [`c343dce`](https://github.com/ImageMagick/ImageMagick/commit/c343dcedf137e7cc3889c6874c064e1990680ccc)
- improve CPU throttle check [`3f204af`](https://github.com/ImageMagick/ImageMagick/commit/3f204afc79f97fe9460ec313532a8723b7d1e8e9)
- some say BMP and TIFF images "web safe" [`dec92bf`](https://github.com/ImageMagick/ImageMagick/commit/dec92bf703ae73b86a6599e74dfd80a1edd702fe)
- allow writing of JSON images [`9147b17`](https://github.com/ImageMagick/ImageMagick/commit/9147b17c38a01aa38d8baa249050018a020c36a0)
- Disable check for function that break delegate detection when building with a C++ compiler. [`781d94f`](https://github.com/ImageMagick/ImageMagick/commit/781d94f0ddfd2d61a20ca31ebb8b264cb3ff31c0)
- Removed checks for functions that we don't need. [`1b96ac2`](https://github.com/ImageMagick/ImageMagick/commit/1b96ac256c8a5e0dd393e20ccaad6228cb3af938)
- Stop using the deprecated ::set-output. [`4c7f5cd`](https://github.com/ImageMagick/ImageMagick/commit/4c7f5cde5c8bf0f9b00ce357f52107685c9c6725)
- remove ABI suffice symbol [`84c1817`](https://github.com/ImageMagick/ImageMagick/commit/84c181798983ad30834adc5c1b0eadbacb1ecc86)
- lastest autoconf/automake update [`6c64544`](https://github.com/ImageMagick/ImageMagick/commit/6c64544d1c0876f732fcd618b87eb41842325a74)
- more transparent shadow [`a44e75c`](https://github.com/ImageMagick/ImageMagick/commit/a44e75c796c39e88f32569bb9c196b94be4a54c2)
- 64-bit channel masks requires the C++ lang when evalulating autoconf macros [`2f14769`](https://github.com/ImageMagick/ImageMagick/commit/2f14769ce34fc64553822fd7184fdc171a0e9e54)
- prevent implode from blowing up (https://github.com/ImageMagick/ImageMagick/issues/6623) [`e7c6c1e`](https://github.com/ImageMagick/ImageMagick/commit/e7c6c1e0cf7be41e37308109a79ce25ea8b8ab75)
- Added the generated policy.xml file to .gitignore [`7ca7c3c`](https://github.com/ImageMagick/ImageMagick/commit/7ca7c3c277028a0a59fc0db8f27a19d8c09b5ff5)
- Make sure we also set AC_LANG([C]) for the 32-bit channel [`58fc88c`](https://github.com/ImageMagick/ImageMagick/commit/58fc88cbc8603ec8ae2a3a41cf8ed13cd5b11d65)
- latest autoconf update [`56d2222`](https://github.com/ImageMagick/ImageMagick/commit/56d2222e87ec5200882a758a9b14a3ba66a06057)
- eliminate compiler error [`77d50b6`](https://github.com/ImageMagick/ImageMagick/commit/77d50b6c5152041f716036d32a0a81937aaf85e9)
- Update SECURITY.md [`03a92b7`](https://github.com/ImageMagick/ImageMagick/commit/03a92b7a99e7da7a8026cfb0d25183f5ec2bc9b2)
- Update SECURITY.md [`964a761`](https://github.com/ImageMagick/ImageMagick/commit/964a76169702143801ecf71e327877edacb1f278)
- doc update [`c3a8569`](https://github.com/ImageMagick/ImageMagick/commit/c3a8569860b454bae32ce9888b1156dd5b235908)
- check for cache offset boundaries [`8ca44d0`](https://github.com/ImageMagick/ImageMagick/commit/8ca44d0e6f3fd376d52e7061cdecee88c068f1f6)
- Added support for writing the alpha channel when the output format is indexed (#6629). [`833d1fa`](https://github.com/ImageMagick/ImageMagick/commit/833d1fa4b41b433c498f8eb565074e1b5b86eb48)
- Corrected return value. [`4cd4def`](https://github.com/ImageMagick/ImageMagick/commit/4cd4defc14fe04e88c5d1804325000a025612202)
- Added missing typecast. [`3140f84`](https://github.com/ImageMagick/ImageMagick/commit/3140f84c9bc462fee45e7bbc8b4a62154bef4aff)
- Patches to make sure OpenCL acceleration still works with 64-bit channel mask. [`03a44aa`](https://github.com/ImageMagick/ImageMagick/commit/03a44aa92586c4d1392db30a4fd1d211fad08d38)
- account for boundary condition [`40b280d`](https://github.com/ImageMagick/ImageMagick/commit/40b280da5815c75eb5d68209ac2cc64e73eab4ac)
- Redefine QuantumScale to avoid double cast that results in odd issues (#6631). [`c6e3796`](https://github.com/ImageMagick/ImageMagick/commit/c6e379602d2263ca50940148624d666ab65b009c)
- update temporary path [`b4e5a90`](https://github.com/ImageMagick/ImageMagick/commit/b4e5a9005709d547f9ec864919bce41daa9565d4)
- read multiline comments [`7747cb8`](https://github.com/ImageMagick/ImageMagick/commit/7747cb8382a1a87acb313449ae4935dbc8fb4e02)
- cosmetic [`c4e8f80`](https://github.com/ImageMagick/ImageMagick/commit/c4e8f8039c2fe6282ab95b0d787d5926c193d65d)
- cosmetic [`e632bf2`](https://github.com/ImageMagick/ImageMagick/commit/e632bf21f70dda6d66cbacfc215e54ad2d3855e3)
- eliminate compiler exception [`6307013`](https://github.com/ImageMagick/ImageMagick/commit/63070133f6b6da6d2771328de680efded43be01f)
- support emedded images [`85319f7`](https://github.com/ImageMagick/ImageMagick/commit/85319f713a98a89cfd0452829f239e355c144fe6)
- support alpha mask [`fde3d56`](https://github.com/ImageMagick/ImageMagick/commit/fde3d56de76622803da0f859ad79a02f66bc53ab)
- Corrected implementation of reading the alpha mask when the compression is BI_ALPHABITFIELDS. [`4d91bac`](https://github.com/ImageMagick/ImageMagick/commit/4d91bac9b713c8bb7314c362f9d600f4a1ca47b5)
- We no longer need to throw an exception. [`ffb4f49`](https://github.com/ImageMagick/ImageMagick/commit/ffb4f4905febf48dd2e0c4522933d8524c13f3b0)
- Add option called tga:write-footer that can be used to write the optional footer (#6543). [`1eaa7d6`](https://github.com/ImageMagick/ImageMagick/commit/1eaa7d69cec959313fc2a484813f38a9a4f6e7b7)
- use virtual memory allocator [`88abbe1`](https://github.com/ImageMagick/ImageMagick/commit/88abbe116af57516eb6544a5b0279b8b4186bfc2)
- detect math library under C++ [`58c954b`](https://github.com/ImageMagick/ImageMagick/commit/58c954bc9b175de0686136f2ec1b2e2d4d0481d1)
- Revert recent changes that break compilation with a C++ compiler on MacOS. [`9962e58`](https://github.com/ImageMagick/ImageMagick/commit/9962e5872a6914befbd16f72f9751748dfe0c6fa)
- latest autoconf update [`b682537`](https://github.com/ImageMagick/ImageMagick/commit/b682537d3a35e1e6ae7b743c90e64f14fe2224d7)
- check for math library [`6d18857`](https://github.com/ImageMagick/ImageMagick/commit/6d1885768b3b8b4e9e4c9646c839ce6ed65ea743)
- remove C++ as a prerequisite for 64-bit channel masks [`6608547`](https://github.com/ImageMagick/ImageMagick/commit/6608547b71a5a9be9fe40e017a122cde82643bca)
- revised 64-bit channel masks [`50084ca`](https://github.com/ImageMagick/ImageMagick/commit/50084cacb838266678b37ea2691bdb73321ea1c4)
- Added missing typecast. [`1c5fa8d`](https://github.com/ImageMagick/ImageMagick/commit/1c5fa8d48edfbb7e75607b66553065554556dda6)
- Added another missing typecast. [`52eff1d`](https://github.com/ImageMagick/ImageMagick/commit/52eff1d17269a9a3ec5b452af481953a31ff23c6)
- check for insufficient image data [`0f22c43`](https://github.com/ImageMagick/ImageMagick/commit/0f22c438ace6a3c9ce3d3a7a1b5e578f48fd6895)
- support -x compiler option [`76cd9b1`](https://github.com/ImageMagick/ImageMagick/commit/76cd9b1bb3403c9200a8accdee8008a58454e82d)
- ... [`3f9fcad`](https://github.com/ImageMagick/ImageMagick/commit/3f9fcad06cf988187110ece33f6ea1a6262ff63a)
- initalize locale [`17adcaa`](https://github.com/ImageMagick/ImageMagick/commit/17adcaad771348f7ca63ee135a66abe9c513c42f)
- Reverted incorrect patch. [`9b8ff67`](https://github.com/ImageMagick/ImageMagick/commit/9b8ff67d5e7451a8f7efbcce8bd0afb22ef0e97a)
- Added missing includes. [`2b54153`](https://github.com/ImageMagick/ImageMagick/commit/2b541530d7fc2ebb8a7538db867240448269bf6a)
- latest documentation [`a6f96bf`](https://github.com/ImageMagick/ImageMagick/commit/a6f96bfad6a0294f15f54450c982668fdbfd1e4a)
- check for underflow [`f210e55`](https://github.com/ImageMagick/ImageMagick/commit/f210e5548888f5c0dea40ffd1f541640ad394203)
- check for underflow [`3a7c11d`](https://github.com/ImageMagick/ImageMagick/commit/3a7c11dacdf2886c6db017b12779c6638daedcd0)
- set initial pixel width/height based in INT_MAX [`c65c72d`](https://github.com/ImageMagick/ImageMagick/commit/c65c72dafc56c7fc38cc75856df661b8f94645c2)
- eliminate compiler warnings [`3829ba3`](https://github.com/ImageMagick/ImageMagick/commit/3829ba32727f8b040e0b0eb1027d5de97c1dfa4d)
- latest autoconf update [`0debebb`](https://github.com/ImageMagick/ImageMagick/commit/0debebb4d38200e81c17e964743f3085bc724837)
- eliminate compiler warnings [`be9eabf`](https://github.com/ImageMagick/ImageMagick/commit/be9eabf305e9e51fc961facd43cd217d2036f6b4)
- eliminate compiler warnings [`c93f8d2`](https://github.com/ImageMagick/ImageMagick/commit/c93f8d241c102cb33488a5db06ac743c1b42f519)
- restore [`3e20e19`](https://github.com/ImageMagick/ImageMagick/commit/3e20e19c9156f9e7df82903071f1a69c1786ac3d)
- eliminate compiler warning [`fd1ee51`](https://github.com/ImageMagick/ImageMagick/commit/fd1ee517b9767c06c05fccdd0184565aa8611300)
- improve exception message [`07e8e9c`](https://github.com/ImageMagick/ImageMagick/commit/07e8e9cd7334c442178b83b460c427ef8bb15851)
- Corrected typo. [`50cbfe0`](https://github.com/ImageMagick/ImageMagick/commit/50cbfe01fdaee53ab478bd6b634b71377c38ef8d)
- eliminate compiler warning [`c31c793`](https://github.com/ImageMagick/ImageMagick/commit/c31c793ab7bbfd6eccd3665819e154f4f03be0d6)
- latest auotconf update [`eeede01`](https://github.com/ImageMagick/ImageMagick/commit/eeede019cc80af5b586811ede19c77d777e7500d)
- cosmetic [`4988d7f`](https://github.com/ImageMagick/ImageMagick/commit/4988d7fa816abda77b5269e1d20e2047edd5153a)
- use TIFF as our intermediate format to minimize distortion [`3a17ddd`](https://github.com/ImageMagick/ImageMagick/commit/3a17dddba802f02ef5b0fc68cbd942e07150ab8b)
- support 10-bit JXR images [`0053d46`](https://github.com/ImageMagick/ImageMagick/commit/0053d46612fce0410f2757269dd397bb1b6e1205)
- support 10-bit JXR images [`3f1131b`](https://github.com/ImageMagick/ImageMagick/commit/3f1131b2b4e59b2751bde4a46710627325b19947)
- improved a bit [`7d8bd55`](https://github.com/ImageMagick/ImageMagick/commit/7d8bd55f8039cc8ef7616f8abc9f39c626408858)
- revert [`abf800e`](https://github.com/ImageMagick/ImageMagick/commit/abf800ea66f7e39ad481137968af5a6819ba502f)
- eliminate compiler warning [`b9b52c9`](https://github.com/ImageMagick/ImageMagick/commit/b9b52c9ea7dc67ddfc303acef21776b6a54ea8ef)
- release [`15caf7d`](https://github.com/ImageMagick/ImageMagick/commit/15caf7dc7c898f85438ab8e4cbd95b8207b4988e)

## [7.1.1-15](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-14...7.1.1-15) - 2023-07-30

### Commits

- beta release [`edf7a2a`](https://github.com/ImageMagick/ImageMagick/commit/edf7a2a8c7f5aa698f07ee93dfe09463bdeb27a5)
- Make sure the correct image properties are set before calling SetImageExtent. [`c18f8c5`](https://github.com/ImageMagick/ImageMagick/commit/c18f8c55e36e4d77ccee6f4c854289b43a4203fb)
- Corrected setting the quantum_type for rgba images. [`be52c60`](https://github.com/ImageMagick/ImageMagick/commit/be52c60c8bd1f441b47e29786dc23abb1e60c9f4)
- enable entitiy substitution per local parser (https://github.com/ImageMagick/ImageMagick/security/advisories/GHSA-v9p9-6pmh-r6rm) [`0a87eaf`](https://github.com/ImageMagick/ImageMagick/commit/0a87eaf381b46feb720022a444375122077881c1)
- The -fx option, no long applied twice (https://github.com/ImageMagick/ImageMagick/discussions/6518) [`fac094a`](https://github.com/ImageMagick/ImageMagick/commit/fac094a007be57f2df02568e88286a121590c0cd)
- ensure FL32 test suite properly survives a round trip (https://github.com/ImageMagick/ImageMagick/issues/6507) [`bfc9231`](https://github.com/ImageMagick/ImageMagick/commit/bfc923108e9294c1c2e7e2852ce93fa8247e7800)
- Use AllChannels instead of DefaultChannels. [`c328565`](https://github.com/ImageMagick/ImageMagick/commit/c328565bec51fb2b907c9d4c7c7c904260da4350)
- eliminate possible integer overflow [`b3881dc`](https://github.com/ImageMagick/ImageMagick/commit/b3881dc50aca2c7c6fa3c464b0ab5184ee7d187e)
- images must be sRGB compatible to write FL32 [`ce38645`](https://github.com/ImageMagick/ImageMagick/commit/ce386456d51f5eb488c0da5d223aeca29ecc566f)
- Update SECURITY.md [`f952997`](https://github.com/ImageMagick/ImageMagick/commit/f95299783498b93bcec75fb7605fcc38e1e401ec)
- check for valid bits-per-pixel [`98eceff`](https://github.com/ImageMagick/ImageMagick/commit/98eceff6a30217804764705f2ba8f29df2934160)
- release [`a0a5f3d`](https://github.com/ImageMagick/ImageMagick/commit/a0a5f3da4cd07919dd2d1bbae121e590b5f105e2)

## [7.1.1-14](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-13...7.1.1-14) - 2023-07-22

### Commits

- beta release [`e799547`](https://github.com/ImageMagick/ImageMagick/commit/e799547419e63780039bae9be9931b2c64612870)
- No longer download build_dependencies.sh [`f5d0480`](https://github.com/ImageMagick/ImageMagick/commit/f5d048073412c7c704842dd3686608ef7f5df1c9)
- support abbreviations for RTL and LTR text direction [`4a8152b`](https://github.com/ImageMagick/ImageMagick/commit/4a8152b806103335bab736c2fec41ce9c50fcee1)
- note y_advance, implement top-to-bottom in the future [`01b0544`](https://github.com/ImageMagick/ImageMagick/commit/01b05442f67c26e89a7c4657681bb83196a06141)
- prep for top-to-bottom rendering of text [`3911d74`](https://github.com/ImageMagick/ImageMagick/commit/3911d747b8e4279e2d8430bfd1f576ae6b6207c8)
- alpha gradient fade now works with grayscale images (https://github.com/ImageMagick/ImageMagick/issues/6495) [`53f2595`](https://github.com/ImageMagick/ImageMagick/commit/53f259582d6d0acd4eff6ad771c42579b9c6f537)
- check for possible IPTC overrun [`e284d83`](https://github.com/ImageMagick/ImageMagick/commit/e284d8387e728499435dbf8e6b694a21cbb906f6)
- release [`15c472d`](https://github.com/ImageMagick/ImageMagick/commit/15c472d758e594246f26d3a7b9402a5aad627b0c)
- account for hidden colormap index channel (https://github.com/ImageMagick/ImageMagick/issues/6507) [`af228bb`](https://github.com/ImageMagick/ImageMagick/commit/af228bb8bf2da5bda0410707656f45d3151e2079)
- release [`562a80c`](https://github.com/ImageMagick/ImageMagick/commit/562a80c6d23910a20cf964a105c729d94307ca16)

## [7.1.1-13](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-12...7.1.1-13) - 2023-07-16

### Merged

- Add Canon Raw v3 (CR3) as mime type [`#6450`](https://github.com/ImageMagick/ImageMagick/pull/6450)

### Commits

- beta release [`56f4789`](https://github.com/ImageMagick/ImageMagick/commit/56f4789405ac2d3abe23cb5dad3d9ccd383ab626)
- beta release [`63e2617`](https://github.com/ImageMagick/ImageMagick/commit/63e261708a8e791ef5922a3da45aba3a6ff781b4)
- MetaPixelChannel is no longer used, MetaPixelChannels should be used instead. [`237b8ec`](https://github.com/ImageMagick/ImageMagick/commit/237b8ec913113a6c1dfd0a413438005c2f810607)
- heap-buffer-overflow in ImageMagick &lt;= 7.1.1-12, contributed by Hardik shah of Vehere (Dawn Treaders team) [`a531d28`](https://github.com/ImageMagick/ImageMagick/commit/a531d28e31309676ce8168c3b6dbbb5374b78790)
- Corrected patch for heap-buffer-overflow reported by Hardik shah of Vehere. [`ac1f7ca`](https://github.com/ImageMagick/ImageMagick/commit/ac1f7ca1d88e14d30e5ae9bd30aad150bdbec20e)
- Correct type of return value for TIFFReadTile and added more checks. [`6213344`](https://github.com/ImageMagick/ImageMagick/commit/6213344a66d69c6bb551e5bf7c521822daf42600)
- Added extra for when TIFFReadEncodedStrip returns -1. [`0aea35f`](https://github.com/ImageMagick/ImageMagick/commit/0aea35f2adc3f6af7bfc687d923a56d92671bd97)
- Code style changes. [`264acfc`](https://github.com/ImageMagick/ImageMagick/commit/264acfcdc3227ad6406bfd39b95af9f85b409024)
- Reverted patch that broke SeparateImages. [`a765e3c`](https://github.com/ImageMagick/ImageMagick/commit/a765e3c502bac6fed9b9d929213ba124dbbe4465)
- memory library with reduced synchronization overhead [`88e3964`](https://github.com/ImageMagick/ImageMagick/commit/88e39641b2e71e94a77cefdf4c9186543975931d)
- fix proper scaling of Oklab colorspace [`d0f208b`](https://github.com/ImageMagick/ImageMagick/commit/d0f208b966c0fdbd32b94d86bef37928293e04ba)
- We now need to build xz --disable-ifunc or otherwise this will result in a segfault. [`e5061bc`](https://github.com/ImageMagick/ImageMagick/commit/e5061bcdaba9efcb0319add0fe8c7d5d98eb9fc1)
- cosmetic [`a8de149`](https://github.com/ImageMagick/ImageMagick/commit/a8de149e1aca79836319b31c8881537115e478ff)
- Simplify check. [`3afd4ac`](https://github.com/ImageMagick/ImageMagick/commit/3afd4ac26938930cbd4be6c967381a47d3d60d53)
- Corrected checks [`ee1c3af`](https://github.com/ImageMagick/ImageMagick/commit/ee1c3af7175a952eb00fca99a450da1b1403a65a)
- Corrected declaration. [`ec470f3`](https://github.com/ImageMagick/ImageMagick/commit/ec470f33f6234bd176f7e8deaa5f417615b8a69f)
- missing cast to `(int)` for PixelChannel [`920b778`](https://github.com/ImageMagick/ImageMagick/commit/920b778ffb9b0452821ba83305ac50516f1b02cb)
- No longer use heic_corpus. [`317c022`](https://github.com/ImageMagick/ImageMagick/commit/317c022098804a23234c5ef9a3cd0b42a12da3f8)
- cosmetic [`8ff0561`](https://github.com/ImageMagick/ImageMagick/commit/8ff0561d4eda90a3f3b0360bca51dfda1037cfae)
- Store additional information when dng:read-thumbnail is specified so the user knows how to read the thumbnail data. [`9d79979`](https://github.com/ImageMagick/ImageMagick/commit/9d79979e795ad69fd7774afa72ddbed841eb5ddc)
- support -reshape option [`4c104d0`](https://github.com/ImageMagick/ImageMagick/commit/4c104d03943a49de7ebdd427e09acb5d8bc37631)
- check for insufficient image data in file [`3af9aa1`](https://github.com/ImageMagick/ImageMagick/commit/3af9aa1a1bccd673f589e813d980a57e515a06fa)
- silence unsigned overflow [`a1d2267`](https://github.com/ImageMagick/ImageMagick/commit/a1d2267f0bc0155457603defeb0f32deadc23316)
- Added missing typecast. [`b2199fa`](https://github.com/ImageMagick/ImageMagick/commit/b2199fa662b20c6679a53ceba8e7f9805a360d9d)
- support &gt; 10 meta channel mnemonics [`ebeb132`](https://github.com/ImageMagick/ImageMagick/commit/ebeb1323065a9ca66e140e992394c9a1d468f83f)
- Correct addition to resolve issue with negative interline_spacing values. [`ba0479f`](https://github.com/ImageMagick/ImageMagick/commit/ba0479f710ba98fe1305befe35ae62a9a51ebc8f)
- https://github.com/ImageMagick/ImageMagick/issues/6476 [`5b3b6c2`](https://github.com/ImageMagick/ImageMagick/commit/5b3b6c27bc1b084a6e30fbf101a8eacaecabff89)
- preferred unwinding order [`15efb42`](https://github.com/ImageMagick/ImageMagick/commit/15efb4222779fc61dd02832c00700fccd510f16b)
- Minor tweaks. [`d339bed`](https://github.com/ImageMagick/ImageMagick/commit/d339bedcd606a39efba5dd7fa3f19521cc5617e2)
- Fixed reading MPO image (#6475) [`2366b76`](https://github.com/ImageMagick/ImageMagick/commit/2366b767cf711753328944f082376bdfd916d8e8)
- Make the MPO format explicit. [`650ef27`](https://github.com/ImageMagick/ImageMagick/commit/650ef2710f5f69605f82fde2c37e90a3337f5378)
- Corrected types. [`51d16a0`](https://github.com/ImageMagick/ImageMagick/commit/51d16a0ce34d9f19d2a8ae9f7530ff75584dea48)
- eliminate improbable integer overflow [`b939fa1`](https://github.com/ImageMagick/ImageMagick/commit/b939fa13bc23169514cc4aa34ceaf87fdccd4c20)
- cosmetic [`f2bea15`](https://github.com/ImageMagick/ImageMagick/commit/f2bea15606cf1117e6e228f6c252eee0f1c2148f)
- Fixed memory leak. [`491d1bf`](https://github.com/ImageMagick/ImageMagick/commit/491d1bf1c371746c781d811e0c721fade0b1c710)
- release [`d5974ce`](https://github.com/ImageMagick/ImageMagick/commit/d5974ce50c84bee43731270a899d7a4a9500cc17)

## [7.1.1-12](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-11...7.1.1-12) - 2023-06-25

### Merged

- Add support for DXGI_FORMAT_R10G10B10A2_UNORM [`#6423`](https://github.com/ImageMagick/ImageMagick/pull/6423)

### Commits

- beta release [`3c43475`](https://github.com/ImageMagick/ImageMagick/commit/3c43475bb5dc7eec9af3babc789bf8bf65677e90)
- default colorspaces are xyY and HSB [`f45cb56`](https://github.com/ImageMagick/ImageMagick/commit/f45cb56383bda833708f08d6f8a580c833ffd1c9)
- Check for _MSC_VER instead. [`cd00c90`](https://github.com/ImageMagick/ImageMagick/commit/cd00c904f9d6c01371b5d3451eaf23072c0cdd9d)
- Changed options for heif build. [`3f9df4f`](https://github.com/ImageMagick/ImageMagick/commit/3f9df4fd698ca93b304dee4691d7f98e1a99ffc4)
- check geometry boundaries [`a6f4445`](https://github.com/ImageMagick/ImageMagick/commit/a6f4445f6c559756066d102c25ade248f62742bf)
- eliminate unintialized value [`1a9bd29`](https://github.com/ImageMagick/ImageMagick/commit/1a9bd29227753059ee7580168f5aa5f8020cb664)
- multi-picture support (future) [`81c214c`](https://github.com/ImageMagick/ImageMagick/commit/81c214c7fba3d0086b07ad52057bdeea3ca270d8)
- reject invalid BMP image @ https://github.com/ImageMagick/ImageMagick/issues/6393 [`cd6b437`](https://github.com/ImageMagick/ImageMagick/commit/cd6b43771b82392decefecadc86a9ba6fd30cad3)
- support -define ptif:pyramid define [`3030b16`](https://github.com/ImageMagick/ImageMagick/commit/3030b16bc61b6216e6b0901dceb296f09a37a3ac)
- eliminate OMP error (https://github.com/ImageMagick/ImageMagick/discussions/6399) [`6afa456`](https://github.com/ImageMagick/ImageMagick/commit/6afa45658ef7bbe6c8d3fa1655de822b385b380b)
- separate all channels, not just one marked for update (#https://github.com/ImageMagick/ImageMagick/issues/6400) [`f6673cb`](https://github.com/ImageMagick/ImageMagick/commit/f6673cbe55664739b178a51daeacc6c7d104f17c)
- cosmetic [`360fba4`](https://github.com/ImageMagick/ImageMagick/commit/360fba409cf552e3758163a3758e748c8ba0fcab)
- cosmetic [`c29baa2`](https://github.com/ImageMagick/ImageMagick/commit/c29baa214d591de9f1045a8782361fef0d7efdd4)
- move OMP guard inside conditional [`82c7014`](https://github.com/ImageMagick/ImageMagick/commit/82c701463f1ab5d89345397d0acce5ae78b08d14)
- Fixed build. [`8926ea9`](https://github.com/ImageMagick/ImageMagick/commit/8926ea965803bdf47321cb02b5b16a3860bc7067)
- latest CSS [`195a191`](https://github.com/ImageMagick/ImageMagick/commit/195a19168f8dfbfedc21b20a1ca3515bac96f524)
- check the precision of the alpha channel [`d04a472`](https://github.com/ImageMagick/ImageMagick/commit/d04a47227637dbb3af9231b0107ccf9677bf985e)
- support the MPO image format [`46985ca`](https://github.com/ImageMagick/ImageMagick/commit/46985cabc38b49e8b962b66ecb999a70e26b1963)
- Fixed build on Windows. [`905b2d2`](https://github.com/ImageMagick/ImageMagick/commit/905b2d26e9e1c1fff6045916c2f0e0bb5c2fee02)
- support JPEG alt signature [`593902e`](https://github.com/ImageMagick/ImageMagick/commit/593902e0fcd1b1323ea660496f55b2a299786a6e)
- eliminate ANSI compiler warning [`12792bf`](https://github.com/ImageMagick/ImageMagick/commit/12792bf6f75addad5ef489d62c0c0673f87f1732)
- There is no need to also code WebPEncode when WebPAnimEncoderAdd is used (#6415). [`f3ea247`](https://github.com/ImageMagick/ImageMagick/commit/f3ea247017fb3ac4b28201231109f8720ca84811)
- https://github.com/ImageMagick/ImageMagick/issues/6422 [`efc1c0e`](https://github.com/ImageMagick/ImageMagick/commit/efc1c0e71755b5762e734e50e82a9be2f694382e)
- update Linux built documentation [`2cc67c3`](https://github.com/ImageMagick/ImageMagick/commit/2cc67c37aa03cb574f317793ad27f7736cba140d)
- Improved check when setting mem-&gt;max_memory_to_use. [`1242ca5`](https://github.com/ImageMagick/ImageMagick/commit/1242ca52b2e91ef80abc6d42a61ced65e0b90fbd)
- Use the correct macro instead. [`a11148a`](https://github.com/ImageMagick/ImageMagick/commit/a11148a0dfa270c0b9f5073da7ca9e7f35a2edd3)
- Turns out we already get the include from studio.h. [`3f6161b`](https://github.com/ImageMagick/ImageMagick/commit/3f6161b9cb1e64abc67ce066c819cad27d32e51b)
- Added missing check to test if the blob could be opened (#6429) [`9fbd8f8`](https://github.com/ImageMagick/ImageMagick/commit/9fbd8f822ced6947d7558ff255d48e091a71477f)
- Added extra flag for xz build. [`49b8727`](https://github.com/ImageMagick/ImageMagick/commit/49b8727c605a6c62b6a718778aaa40228a439609)
- Patches for upcoming breaking changes in the jxl library. [`9db502e`](https://github.com/ImageMagick/ImageMagick/commit/9db502e6a70ca2534dfc78c09f156aa55f88dcfb)
- Disable the jpeg encoder and decoder of libheif to work around linking issues in the oss-fuzz build. [`b3f8ed7`](https://github.com/ImageMagick/ImageMagick/commit/b3f8ed7a71896159804fecc16b5d35701807844e)
- release [`a09d8dd`](https://github.com/ImageMagick/ImageMagick/commit/a09d8dd5e3a92362cf70c184670b23163587e6f8)

## [7.1.1-11](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-10...7.1.1-11) - 2023-05-29

### Merged

- Optimize image and vector files to minimize filesizes and page loads [`#6352`](https://github.com/ImageMagick/ImageMagick/pull/6352)

### Fixed

- Swap order to fix #6347. [`#6347`](https://github.com/ImageMagick/ImageMagick/issues/6347)

### Commits

- beta release [`375e71b`](https://github.com/ImageMagick/ImageMagick/commit/375e71b67686549c4f5866d0b50db9ab20b324f8)
- list compression options [`dc491e2`](https://github.com/ImageMagick/ImageMagick/commit/dc491e2ef06bfc266d7dcb396703e046f838c485)
- cosmetic [`069ac80`](https://github.com/ImageMagick/ImageMagick/commit/069ac80cc234207edea3c64ced5c9ba84a91b71f)
- build failure with --without-threads option [`4ea685b`](https://github.com/ImageMagick/ImageMagick/commit/4ea685bd83890ce2b9ab3a9606d460b41a895eec)
- ensure mutex is initialized [`4553068`](https://github.com/ImageMagick/ImageMagick/commit/4553068cc7e1ffdf501702e173610d32d404a99c)
- cosmetic [`b7c1554`](https://github.com/ImageMagick/ImageMagick/commit/b7c1554c60a54a9a37ec848d87870f4331d72ae8)
- costmetic [`013d523`](https://github.com/ImageMagick/ImageMagick/commit/013d523d4cb28f3469a44062b6da6488b62c1c62)
- eliminate compiler exception [`e771f13`](https://github.com/ImageMagick/ImageMagick/commit/e771f13799c66f7e4fe3645bd68b4e8a2b80903b)
- eliminate compiler exception [`bb3d969`](https://github.com/ImageMagick/ImageMagick/commit/bb3d969bf6b8db382b6e066c12a8680f8c993b28)
- Fixed the calculation of the clut_size to resolve the issue reported in: https://github.com/ImageMagick/ImageMagick/security/advisories/GHSA-xfwq-qg5m-83xr. [`fac0ea8`](https://github.com/ImageMagick/ImageMagick/commit/fac0ea8011704c675f65152a161427621cf07917)
- cosmetic [`fd09cf9`](https://github.com/ImageMagick/ImageMagick/commit/fd09cf94aab30f3ad600e5bc3a6c61410a4d0d5b)
- make sure count is not equal to zero when reading TIFF fields [`bea09ba`](https://github.com/ImageMagick/ImageMagick/commit/bea09ba258631cf7747aed1f434c5a56fa7876a3)
- check colorspace before setting primaries [`fd736b6`](https://github.com/ImageMagick/ImageMagick/commit/fd736b6e8203bb3c642f21b95baac3285b15d693)
- eliminate compiler exception [`e549f31`](https://github.com/ImageMagick/ImageMagick/commit/e549f311fb2dc3453df91caae5bf7933a3a65557)
- Revert back to earlier version. [`241ceb0`](https://github.com/ImageMagick/ImageMagick/commit/241ceb06a4c4bc177e9f6358845ddd3f32d68e21)
- Rename defines. [`ddb6b02`](https://github.com/ImageMagick/ImageMagick/commit/ddb6b02d8fa5756366553d9780687b57c7c216b8)
- Added missing define and corrected MAGICKCORE_DPC_SUPPORT checks. [`3f81630`](https://github.com/ImageMagick/ImageMagick/commit/3f81630d1b9a56acd83435b548196a46eb85b906)
- Refactor code to silence warnings. [`af284ad`](https://github.com/ImageMagick/ImageMagick/commit/af284ad66a65f0fc8721a750ccda12d5abf3930b)
- Use num_threads instead because the number of threads is not related to images. [`442144c`](https://github.com/ImageMagick/ImageMagick/commit/442144c976cad2a2966a0b92a50f58862055aedd)
- Silence warning when threading is disabled. [`8d0daa2`](https://github.com/ImageMagick/ImageMagick/commit/8d0daa252d9ca45c154243c44c5bdde4cb4720dc)
- Added support for reading grayscale images. [`cffd9de`](https://github.com/ImageMagick/ImageMagick/commit/cffd9de73622c540b0e0e889c32445cef20c5a1c)
- cosmetic [`bf6c895`](https://github.com/ImageMagick/ImageMagick/commit/bf6c8959e96b0e6874460c690572e1b108c9cc2c)
- cosmetic [`54eeadf`](https://github.com/ImageMagick/ImageMagick/commit/54eeadf2989a835b24d66eec58dabc813099b6a6)
- cosmetic [`0bede66`](https://github.com/ImageMagick/ImageMagick/commit/0bede6611e845be6b017b7c56d815f6598d27d90)
- prevent possible integer overflow [`f04a7eb`](https://github.com/ImageMagick/ImageMagick/commit/f04a7eb3331672906bcae1be337c0ba0a4e8cbc1)
- release [`11ffa6e`](https://github.com/ImageMagick/ImageMagick/commit/11ffa6eb4548644a718158daa286295ed3174054)

## [7.1.1-10](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-9...7.1.1-10) - 2023-05-21

### Commits

- beta release [`e31343f`](https://github.com/ImageMagick/ImageMagick/commit/e31343f0153b3871985aa1deaab446d8d58197f2)
- carefully crafted image files (TIM2, JPEG) no longer overflow buffer nor use heap after free (thanks to Juzhi Lu, Zhen Zhou, Likang Luo of NSFOCUS Security Team) [`1061db7`](https://github.com/ImageMagick/ImageMagick/commit/1061db7f80fdc9ef572ac60b55f408f7bab6e1b0)
- cosmetic [`bbf3966`](https://github.com/ImageMagick/ImageMagick/commit/bbf396695bf678c0e39986d34f02fba3735b61a6)
- Tweaks to devcontainer to also make it possible to run it locally [`dfb0b6e`](https://github.com/ImageMagick/ImageMagick/commit/dfb0b6e2c957269ef858e1858c806372c46945ae)
- Switch to regular Ubuntu image instead. [`b1ea9fe`](https://github.com/ImageMagick/ImageMagick/commit/b1ea9fef2059c0f4e88a4084a4139b049c3219c4)
- Make sure options are properly quoted to resolve the issue reported in #6338. [`d31c80d`](https://github.com/ImageMagick/ImageMagick/commit/d31c80d15a2c82fc1dd8e889e0f97b0219079a57)
- Mark argument as unused. [`43e2cb6`](https://github.com/ImageMagick/ImageMagick/commit/43e2cb6e3004dec4a866ac5dd6b3122b4d0abf90)
- possible RCE vulnerability (https://github.com/ImageMagick/ImageMagick/issues/6339) [`17c4859`](https://github.com/ImageMagick/ImageMagick/commit/17c4859bf4b1551185ab0b296e61b60b13969917)
- properly cast double to size_t (https://github.com/ImageMagick/ImageMagick/issues/6341) [`3d6d98d`](https://github.com/ImageMagick/ImageMagick/commit/3d6d98d8a2be30d74172ab43b5b8e874d2deb158)
- cosmetic [`8ce0403`](https://github.com/ImageMagick/ImageMagick/commit/8ce0403420cdb0bf492990d8a53fad3a8fa691c0)
- Fixed MSYS2 build error. [`f9c9da1`](https://github.com/ImageMagick/ImageMagick/commit/f9c9da14cf2cb97ad0d0f8dc54ca40e36b25c7c4)
- Forgot to save file before commit. [`7566fdd`](https://github.com/ImageMagick/ImageMagick/commit/7566fdd5913b8b01ed3c7446bc2da6807a118133)
- Reverted the patch of https://github.com/ImageMagick/ImageMagick/issues/6339. [`99b72d8`](https://github.com/ImageMagick/ImageMagick/commit/99b72d81a3370a966a52ec2fa88dacda3f5b028e)
- add caution when enabling pipe support [`1ff6dd4`](https://github.com/ImageMagick/ImageMagick/commit/1ff6dd499f53cd06a01a10e3da95cdb08db6c99a)
- eliminate compiler warning [`4873197`](https://github.com/ImageMagick/ImageMagick/commit/4873197d1419d1b7e86598d5cd06bed4e20c6aef)
- do not initialize structures on stack [`7c7d2fd`](https://github.com/ImageMagick/ImageMagick/commit/7c7d2fd59ffe88442660486f8235df854441c58b)
- Use memset to initialize structures. [`68148d5`](https://github.com/ImageMagick/ImageMagick/commit/68148d54d18c90fa5d6fe383f9a2bb7d7dbec392)
- incompatible function pointer types passing (https://github.com/ImageMagick/ImageMagick/issues/6347) [`2fbf938`](https://github.com/ImageMagick/ImageMagick/commit/2fbf9383c574d08327f7e41db50d613003857604)
- Fixed Windows build. [`3b5d986`](https://github.com/ImageMagick/ImageMagick/commit/3b5d98645499de4d777e7d6e65d0be7966d9986e)
- release [`fa1d7e6`](https://github.com/ImageMagick/ImageMagick/commit/fa1d7e6f1d026d1d70072b04a57857afdb47c29a)

## [7.1.1-9](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-8...7.1.1-9) - 2023-05-14

### Merged

- Add support for Oklab [`#6309`](https://github.com/ImageMagick/ImageMagick/pull/6309)

### Commits

- beta release [`0bb7454`](https://github.com/ImageMagick/ImageMagick/commit/0bb745472aaa2f3f658cd4e327d59acc4d1bd990)
- Code cleanup of the fuzzers and silence warnings. [`d636ff4`](https://github.com/ImageMagick/ImageMagick/commit/d636ff40b511276949d85001a6dbf39652095fb6)
- update autoconf configuration file [`699085f`](https://github.com/ImageMagick/ImageMagick/commit/699085f91e996e19c92e2da4fff3952ab19d0a4a)
- framework for magick cache repository coder [`46fe429`](https://github.com/ImageMagick/ImageMagick/commit/46fe429c07fe2fd6a9533ed1de131907a12cf7d8)
- support digital media repository [`0a439ab`](https://github.com/ImageMagick/ImageMagick/commit/0a439abbf12035b3d55ea214d1c36d8fa6a788c0)
- check for NaN values [`c5762cc`](https://github.com/ImageMagick/ImageMagick/commit/c5762cc9ca05cdb28dddde2d2d395925f871722d)
- alpha release of the digital media repository coder [`1b82a1d`](https://github.com/ImageMagick/ImageMagick/commit/1b82a1db1da3710d3de8a0be31c40fd3c5a7d798)
- eliminate memory leak [`514070c`](https://github.com/ImageMagick/ImageMagick/commit/514070c6d818ba6d31a2ef68e8c4899dc0320b35)
- bump minimum MagickCache version [`6f00ac4`](https://github.com/ImageMagick/ImageMagick/commit/6f00ac46abfc42e1ec0e4f5ba2490550e65495cc)
- get the width of the main channel [`d4ac19b`](https://github.com/ImageMagick/ImageMagick/commit/d4ac19b2ea6451fad453f680e246d0eabafa6f23)
- Use autoreconf -fiv instead. [`fb1e259`](https://github.com/ImageMagick/ImageMagick/commit/fb1e259f33582fcc630b5a66927d6b922253e011)
- support meta resource type [`be401fb`](https://github.com/ImageMagick/ImageMagick/commit/be401fbdca6ee64d0266a2ce78486c8174047129)
- The libheif project switched to cmake. [`6b76461`](https://github.com/ImageMagick/ImageMagick/commit/6b764618635898b86aed962ce18aba1722de9a94)
- account for # channels in image [`402c32d`](https://github.com/ImageMagick/ImageMagick/commit/402c32d88b294abf92bb1414a4400a27d9f623c8)
- Try to add libde265 to the linking to fix the fuzz build. [`7410474`](https://github.com/ImageMagick/ImageMagick/commit/7410474430f44ab0f3cd5d11ca83a51cd952c75a)
- ensure blob and meta resource type can make a round trip [`3797114`](https://github.com/ImageMagick/ImageMagick/commit/379711417b449b5782d23e37a5d204e1d3194222)
- only clone resource image, not blob or meta [`7a63f55`](https://github.com/ImageMagick/ImageMagick/commit/7a63f554dc0f986aa3ef2767d041a0f3294decd2)
- Revert changes. [`f8feb2e`](https://github.com/ImageMagick/ImageMagick/commit/f8feb2ee1b03f0190ca4440777fb2330e3341ce1)
- Corrected linker flags. [`3a1ce45`](https://github.com/ImageMagick/ImageMagick/commit/3a1ce456f0b02d456078906897b20265a3111ab5)
- No longer use HOST_FILLORDER but force the user to specify it when they don't want LSB byte order (#6300). [`937d3dd`](https://github.com/ImageMagick/ImageMagick/commit/937d3ddf1ed658c40e52aeb8c5ef17dbc5c67248)
- Tiny optimization. [`ac48d89`](https://github.com/ImageMagick/ImageMagick/commit/ac48d8951371e41f7f5e833034762122b8caea85)
- Code style changes. [`783a78f`](https://github.com/ImageMagick/ImageMagick/commit/783a78f54798a1a48d27cbe8bf6c34ad6d40b478)
- log gamma [`0cf104a`](https://github.com/ImageMagick/ImageMagick/commit/0cf104a57736ab6b0af196bc04dd9736b9429781)
- rename Oklab to OkLab [`eb44114`](https://github.com/ImageMagick/ImageMagick/commit/eb441143c3449c76000229db9fdf917fee1ced9f)
- revert [`afb52e3`](https://github.com/ImageMagick/ImageMagick/commit/afb52e3625afd8eeb99207ba02daabc977f19df1)
- cosmetic [`d35b2ab`](https://github.com/ImageMagick/ImageMagick/commit/d35b2abef0df4c179b68f922798be6032fcd2565)
- don't default grayscale to paletted for PNG (https://github.com/ImageMagick/ImageMagick/issues/6314) [`ac5f29e`](https://github.com/ImageMagick/ImageMagick/commit/ac5f29e7eb4fda06b465d9088d6035ed91c9f58e)
- release [`776a88d`](https://github.com/ImageMagick/ImageMagick/commit/776a88df6a893d6aba78b2b184490f959d8b9d04)

## [7.1.1-8](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-7...7.1.1-8) - 2023-04-22

### Fixed

- Added checks to make sure all bytes were read to resolve #6267. [`#6267`](https://github.com/ImageMagick/ImageMagick/issues/6267)

### Commits

- beta release [`35ec38f`](https://github.com/ImageMagick/ImageMagick/commit/35ec38f38915f5635ea2f8dcaa20c2960e711db5)
- Treat warnings as errors in the MacOS build and enabled more warnings for that build. [`02b2aa6`](https://github.com/ImageMagick/ImageMagick/commit/02b2aa6bd80b50f9fbaaf9f72c77e04c3b6a9294)
- Corrected compare. [`35505ca`](https://github.com/ImageMagick/ImageMagick/commit/35505caa6808e2b13e395750fc75fc785a2cfad4)
- Not longer export methods that are not used in other parts of the library. [`01251e5`](https://github.com/ImageMagick/ImageMagick/commit/01251e5e41f9581597d586d73c2e562f70d66af8)
- No longer call ParseMetaGeometry twice when we don't add a thumbnail. [`6a94dd8`](https://github.com/ImageMagick/ImageMagick/commit/6a94dd85257db6d8b0dd44d989e91ea0fbd65d3c)
- Fix typo that caused a division by zero in #6263. [`78347b5`](https://github.com/ImageMagick/ImageMagick/commit/78347b5f0e6bc92358b86ec3eaded398ac1069f8)
- don't reduct 3 to 1 channel gray if meta channels are present [`a8f6186`](https://github.com/ImageMagick/ImageMagick/commit/a8f6186d222aff99719c4dcd0d9f04ad03876d95)
- The depth must be specified when reading a map image. [`2d6e2e9`](https://github.com/ImageMagick/ImageMagick/commit/2d6e2e9e28216942a55691f186b9f952342684c3)
- validate pixel offset [`90e067c`](https://github.com/ImageMagick/ImageMagick/commit/90e067cddde91ac3cd7a660d6e99b6fde71b934c)
- validate pixel offset [`d92cb0e`](https://github.com/ImageMagick/ImageMagick/commit/d92cb0e65707cfee6ca0adb58075dea04cbfc722)
- release [`920f792`](https://github.com/ImageMagick/ImageMagick/commit/920f79206ff59f30a4cff22c9c9c393508b82663)

## [7.1.1-7](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-6...7.1.1-7) - 2023-04-16

### Merged

- PixelChannel: Add invalid channel field [`#6230`](https://github.com/ImageMagick/ImageMagick/pull/6230)

### Commits

- beta release [`3bd5ce1`](https://github.com/ImageMagick/ImageMagick/commit/3bd5ce112de3b075ab4a779d0b6db1047ef81be2)
- account for extra samples [`9a9896f`](https://github.com/ImageMagick/ImageMagick/commit/9a9896fce95d09e5e47b86baccbe1ce1a2fca76b)
- The quantum extent should also including the pad. [`b019133`](https://github.com/ImageMagick/ImageMagick/commit/b019133ef486585caacce13792ecfcfc6ca6b9f7)
- Another improvement of calculating the size of the extent. [`3151fd8`](https://github.com/ImageMagick/ImageMagick/commit/3151fd858fe8db16fbd4a9b9b8a892a1acb2b1d6)
- The padding is per pixel. [`dc0556c`](https://github.com/ImageMagick/ImageMagick/commit/dc0556c4fdac8e1ef26f105fb22cac4582b654a5)
- Cosmetic. [`ad36935`](https://github.com/ImageMagick/ImageMagick/commit/ad36935e0bb1b113f20e468f23d92d16dd84d349)
- Use the new API when available. [`8b12fc1`](https://github.com/ImageMagick/ImageMagick/commit/8b12fc147bf3b84bf453473ed8b4045db9201a5b)
- don't cut off letters (https://github.com/ImageMagick/ImageMagick/issues/6221) [`fcf2674`](https://github.com/ImageMagick/ImageMagick/commit/fcf267433cf4620694010261c46e3dabf8af250e)
- Moved static declaration. [`8eaadcf`](https://github.com/ImageMagick/ImageMagick/commit/8eaadcf34e9d4ee19a06e8d9136b2402216a8013)
- Removed unused lt_dlexit define. [`d454d11`](https://github.com/ImageMagick/ImageMagick/commit/d454d1124389d31db5fbabc5f685472233451d94)
- Removed unused NTSetSearchPath method. [`43ea02a`](https://github.com/ImageMagick/ImageMagick/commit/43ea02a3c9a6870b9289dfe988174f2fa35df510)
- Windows doesn't need a call to lt_dlinit. [`48e9207`](https://github.com/ImageMagick/ImageMagick/commit/48e9207d7f1ba299bf9203d49cef01adb904e222)
- There is no need to call WSAStartup because we will always have version 2.2 on the supported platforms. [`24990f7`](https://github.com/ImageMagick/ImageMagick/commit/24990f73940b56925d78b61b007bc21df40c802b)
- Moved linking of lib inside other check. [`b13fabd`](https://github.com/ImageMagick/ImageMagick/commit/b13fabde8e29745c220a0a9bb002fdb1e38298be)
- More cleanup of header files. [`d048972`](https://github.com/ImageMagick/ImageMagick/commit/d0489724c071b4bc5883878e70a97ee9aa5a942f)
- Silence warnings for when the distribute-cache is not supported. [`13841a1`](https://github.com/ImageMagick/ImageMagick/commit/13841a11877db52cebb332f727e342c65113acbf)
- support `--enable-dpc` configure option [`fc7bb1d`](https://github.com/ImageMagick/ImageMagick/commit/fc7bb1d8609d01082b9244a595db433365c7218c)
- Fixed build error. [`178f677`](https://github.com/ImageMagick/ImageMagick/commit/178f677f674f8bb13b64051627dd187b8e4f4ae6)
- theoretically a more intuitive brighness contrast algorithm (https://github.com/ImageMagick/ImageMagick/issues/6079) [`cdc73fb`](https://github.com/ImageMagick/ImageMagick/commit/cdc73fb73b68cc9ca0fff856f1b7d3428b22c917)
- revert format hint (https://github.com/ImageMagick/ImageMagick/issues/6242) [`9e1492e`](https://github.com/ImageMagick/ImageMagick/commit/9e1492e799372a59d702e5cfe602b5d6a4ec6679)
- Use the new MAGICKCORE_DPC_SUPPORT flag. [`7c8a486`](https://github.com/ImageMagick/ImageMagick/commit/7c8a486c33616fd06a43b658ef80dd8a3ada3092)
- Removed define that always had the same value. [`8e5fbea`](https://github.com/ImageMagick/ImageMagick/commit/8e5fbeaa708719f258eee5264138a4c823a867d9)
- We only need to link ws2_32.lib on Windows when we have enabled DPC support. [`1c4f052`](https://github.com/ImageMagick/ImageMagick/commit/1c4f0527332a2b75cb6bbd7d8daf1a91d4310215)
- identify correct format [`ef12f38`](https://github.com/ImageMagick/ImageMagick/commit/ef12f38bc1afd4a785e79a4aafb1261d07ee56d9)
- Restored the call to WSAStartup because we do need to do this when we use winsock2. [`1bc9391`](https://github.com/ImageMagick/ImageMagick/commit/1bc93917ec29c6b1bccab23575f193679a9710ce)
- Correct define check. [`610a8a5`](https://github.com/ImageMagick/ImageMagick/commit/610a8a5914a2fb67e86d5789dabff486f59b106f)
- Corrected checks that determine if we actually are able to support dpc. [`70cd76b`](https://github.com/ImageMagick/ImageMagick/commit/70cd76b553add0e40f3c754b5710a7debc618c2a)
- revert [`723b63a`](https://github.com/ImageMagick/ImageMagick/commit/723b63a5b492887d8921b37617e1f874ac5e3cfc)
- correct slope/intercept [`405c61a`](https://github.com/ImageMagick/ImageMagick/commit/405c61a7b6a93d4ccbcac987ad20dcabb4102dbb)
- correct intercept [`b29bcd9`](https://github.com/ImageMagick/ImageMagick/commit/b29bcd96bc7fcf5dab3153e694b27278795a5752)
- eliminate compiler warnings (https://github.com/ImageMagick/ImageMagick/pull/6230) [`fba0e38`](https://github.com/ImageMagick/ImageMagick/commit/fba0e38896d3f2bad7724c36a546a4c6c492bea1)
- cosmetic [`1fe2162`](https://github.com/ImageMagick/ImageMagick/commit/1fe2162f91e19da9cef89f14d2c3ab445aa6f09b)
- eliminate compiler warning [`3b84c79`](https://github.com/ImageMagick/ImageMagick/commit/3b84c7949063ad0720d588ea8a880151b00a99e9)
- release [`e4b3733`](https://github.com/ImageMagick/ImageMagick/commit/e4b3733f83adb50e595268d63443c7f431cfd1c5)
- beta release [`3b5b4a1`](https://github.com/ImageMagick/ImageMagick/commit/3b5b4a18dd9a77fdeb7874ac68eb0bcbe05a1f9c)
- if the image type is explicit, use the file extension if possible (https://github.com/ImageMagick/ImageMagick/issues/6242) [`67aa0ed`](https://github.com/ImageMagick/ImageMagick/commit/67aa0edbd3f241071d59cffdb9afbbdfd6ad7edf)
- Removed unused return value. [`0d5e3a0`](https://github.com/ImageMagick/ImageMagick/commit/0d5e3a078c8ca0b4b34dd6074e5ec2b3148aad50)
- Use version number instead. [`1bc3bdc`](https://github.com/ImageMagick/ImageMagick/commit/1bc3bdc428b506eb7dd5d839c1fd89e543e87c54)
- Silence warning by casting to size_t instead where negative values will overflow in a large value. [`8def9df`](https://github.com/ImageMagick/ImageMagick/commit/8def9dffdc93c530a25715f1e759489dfe5b1783)
- Silenced warnings. [`7285688`](https://github.com/ImageMagick/ImageMagick/commit/7285688a15f19256986be22a593475a2eda6bbf3)
- Silenced warnings. [`864e6db`](https://github.com/ImageMagick/ImageMagick/commit/864e6dbd6aecc33dd986478e4727e81a1de8434a)
- Added missing break. [`58b6568`](https://github.com/ImageMagick/ImageMagick/commit/58b6568570a348a89cf514a6a17a6a6cbf5b0266)
- Moved devcontainer into security folder. [`386f3b8`](https://github.com/ImageMagick/ImageMagick/commit/386f3b80c988f0fe64245f596bf703037ba4089e)
- Reverted patch and silenced warning. [`4602557`](https://github.com/ImageMagick/ImageMagick/commit/4602557749d8822bd6a9b407062869ac9b3b0de6)
- Added name to the container. [`f9b5142`](https://github.com/ImageMagick/ImageMagick/commit/f9b514222047f1121da6657d82ce3faa37f7bbd2)
- Added missing break. [`9754705`](https://github.com/ImageMagick/ImageMagick/commit/9754705c52ea3ea3abdb987054ba1555e1e02725)
- Silenced MagickCore warnings. [`427e443`](https://github.com/ImageMagick/ImageMagick/commit/427e4434bdf990728607e97898c9a376b051b6a0)
- Silenced coders warnings. [`8f78bf4`](https://github.com/ImageMagick/ImageMagick/commit/8f78bf49301271b0729e03a5e0cb7c19bd6954e7)
- Corrected devcontainer name. [`ecc72e5`](https://github.com/ImageMagick/ImageMagick/commit/ecc72e5fe4cf4e9ad79c33dd0b86e4c01c2d48ee)
- Unreference in else statement instead. [`69da709`](https://github.com/ImageMagick/ImageMagick/commit/69da709ae656582f52311cff7c6656105cb1863e)
- Removed unused argument. [`890b4c7`](https://github.com/ImageMagick/ImageMagick/commit/890b4c72e79b68bb046e5e2b052f1bc4a111ca41)
- Removed unused return values. [`1309276`](https://github.com/ImageMagick/ImageMagick/commit/1309276c99076f8973154cdb6db0674c015f58e2)
- Only define GetICCProperty when build with LCMS delegate. [`bacfcad`](https://github.com/ImageMagick/ImageMagick/commit/bacfcad83b50f76c726d119859e7c4bd2b3302eb)
- Silenced warning. [`a489b2a`](https://github.com/ImageMagick/ImageMagick/commit/a489b2a775e29d668fe083010a48b36f18e74085)
- Silenced warnings in MagickWand. [`bf1e065`](https://github.com/ImageMagick/ImageMagick/commit/bf1e065799aabd15628d6177a0edd98b00db823d)
- Added devcontainer for local development. [`18fd137`](https://github.com/ImageMagick/ImageMagick/commit/18fd137a79803ed36ee5722b7e158297d44f9e81)
- Use define because the fallthrough attribute is only supported by gcc. [`312aaf9`](https://github.com/ImageMagick/ImageMagick/commit/312aaf9e11934899ffed9aa5330a5d51f174a0e6)
- Added Dockerfile to the editorconfig. [`38ecac1`](https://github.com/ImageMagick/ImageMagick/commit/38ecac1ead19b0d3d514f456e6f30212970550bc)
- Use different notation to fix the macos build. [`35152a1`](https://github.com/ImageMagick/ImageMagick/commit/35152a119600f0d4379106e6b1af091441f012a9)
- Added devcontainer that uses the clang compiler. [`fc6f751`](https://github.com/ImageMagick/ImageMagick/commit/fc6f751b516ae36cc1fd3b90dca30388e2b1b422)
- Changed build to treat all warnings as errors and check for more warnings. [`2a003f8`](https://github.com/ImageMagick/ImageMagick/commit/2a003f87b7edb07fc4fb65077d9f0c01d618c68b)
- Silenced warning. [`f85c832`](https://github.com/ImageMagick/ImageMagick/commit/f85c832c820a66f30ec765401cb8ee6a80d66187)
- Change code to make it compile with -Wall -Wextra -Werror [`b164646`](https://github.com/ImageMagick/ImageMagick/commit/b1646463004163e58ce442eea8567559e73cf214)
- Silenced warning. [`cdba683`](https://github.com/ImageMagick/ImageMagick/commit/cdba683f0e9529e0c32250ab4a75799f605c235d)
- Ignore unused-function and builtin-declaration-mismatch warnings to work around autoconf issues. [`f311596`](https://github.com/ImageMagick/ImageMagick/commit/f311596f44cbc29f4af83fdfd990487c567fb172)
- Clang needs different flags to fix the build. [`3e49a05`](https://github.com/ImageMagick/ImageMagick/commit/3e49a0574881e9390f61196a6275bd7a5c451518)
- Also build with clang in the daily build. [`717d8d7`](https://github.com/ImageMagick/ImageMagick/commit/717d8d7d853915a60716211542e5690d2fe64ffc)
- Include compiler in the title. [`50b4062`](https://github.com/ImageMagick/ImageMagick/commit/50b406243962e285296be10a983651c3d3ac331d)
- Silence warnings that occur when freetype is enabled. [`3f9cfbd`](https://github.com/ImageMagick/ImageMagick/commit/3f9cfbdc83354635ddf4b8ece07dac9779f0c078)
- Silenced more warnings. [`7c809d7`](https://github.com/ImageMagick/ImageMagick/commit/7c809d75926d1b9fbacdc1202e462662825ebd99)
- Silence the warning differently. [`feaa675`](https://github.com/ImageMagick/ImageMagick/commit/feaa67525e76c2823fc2345441484ed058f8d0ed)
- elimiate compiler warnings [`f49eeca`](https://github.com/ImageMagick/ImageMagick/commit/f49eeca76e998eca33c4c87b6030bf4ca09f9ca1)
- eliminate compiler warnings [`c40db4e`](https://github.com/ImageMagick/ImageMagick/commit/c40db4eb2dbc37a3b0e4f79dd020be4d1a39a71e)
- eliminate compiler warnings [`9d85754`](https://github.com/ImageMagick/ImageMagick/commit/9d85754dac637cd68601fef32d8bdf472aa0cc60)
- eliminate compiler warning [`7157e1a`](https://github.com/ImageMagick/ImageMagick/commit/7157e1ad9a1c1e6705f37720548acd84647c4a60)
- expand channel map by 1 [`cc97c3a`](https://github.com/ImageMagick/ImageMagick/commit/cc97c3aeaf65cd029aa6ef67076e2c2a45f5d678)
- initialize max channels + 1 [`bdd4599`](https://github.com/ImageMagick/ImageMagick/commit/bdd45991a031969dba24227066dcb507e23afcb6)
- add additional checks for casting double to size_t [`f7b5682`](https://github.com/ImageMagick/ImageMagick/commit/f7b5682435d37ad5ea8142d69629c93228e6376d)
- cosmetic [`77f6713`](https://github.com/ImageMagick/ImageMagick/commit/77f6713783082cbbda797ff9f592bf39885c49f7)
- identify z component of chromaticity [`fecfed4`](https://github.com/ImageMagick/ImageMagick/commit/fecfed4d0cf87edac7a715ad5c62a58bde3a229f)
- Refactor code to make it more readable. [`9783994`](https://github.com/ImageMagick/ImageMagick/commit/97839947b534a0700d007215da9d5b06cb1cbce8)
- Corrected compare. [`c13cada`](https://github.com/ImageMagick/ImageMagick/commit/c13cada56348043b68f20ddda1a6ec18754ed8d0)
- Also skip writing the exif/tiff resolution properties when the pHYs chunk is written. [`d4f233b`](https://github.com/ImageMagick/ImageMagick/commit/d4f233b8cd69585d740e29dc08691c22969cbd1c)
- improved range checking [`4daec2d`](https://github.com/ImageMagick/ImageMagick/commit/4daec2d748cb2f7540ca0d3f694fb2384b0a5601)
- cosmetic. [`8066117`](https://github.com/ImageMagick/ImageMagick/commit/8066117e4871f20e98d818b9345e1fa6e5e8eeaf)
- Removed unused return value. [`d3cf508`](https://github.com/ImageMagick/ImageMagick/commit/d3cf5084cfe9c35b826e0b7450132bab1f8373fa)
- consistent method to check for alpha channel [`242e940`](https://github.com/ImageMagick/ImageMagick/commit/242e9404512a2cc31e858632f963005a3ec32be9)
- Correct comment. [`43aa790`](https://github.com/ImageMagick/ImageMagick/commit/43aa790ee24b0be2d3b74a969fbbd3d6f6683a16)
- Added method to update the density and orientation in the xmp profile. [`fc4f67b`](https://github.com/ImageMagick/ImageMagick/commit/fc4f67bb1b8eb1b61ae70e401482844086949721)
- Corrected value for tiff:ResolutionUnit. [`c9f17dc`](https://github.com/ImageMagick/ImageMagick/commit/c9f17dccb2ed29aa95478d4fb1736e869d6ec884)
- Cosmetic. [`589856f`](https://github.com/ImageMagick/ImageMagick/commit/589856f5497a23e959123b7163601e979763ce2f)
- Removed debug printf statement... [`fecd253`](https://github.com/ImageMagick/ImageMagick/commit/fecd253924effa9111e4955f1d28d7d9722c7835)
- round crop width properly [`adda986`](https://github.com/ImageMagick/ImageMagick/commit/adda986b5a7c331e0cf6e9dce3128e7a1f0b40e6)
- Install more dependencies for the macOS build. [`4a52f67`](https://github.com/ImageMagick/ImageMagick/commit/4a52f674a41a590a5d0482c2dc37fef4a6dc799f)
- Silence warning. [`30f3676`](https://github.com/ImageMagick/ImageMagick/commit/30f3676342add45216fd09329f5af2a50c1d0fc7)
- release [`21d049b`](https://github.com/ImageMagick/ImageMagick/commit/21d049b305ff00c77e168bad1085abb73b7f2201)

## [7.1.1-6](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-5...7.1.1-6) - 2023-04-02

### Commits

- beta release [`a680ab2`](https://github.com/ImageMagick/ImageMagick/commit/a680ab229d0115c62096828851242a6a4f30cea3)
- Use const string instead. [`b094512`](https://github.com/ImageMagick/ImageMagick/commit/b0945129b022458c022a83ff0740889a9543e00f)
- display -moments deprecation warning (#https://github.com/ImageMagick/ImageMagick/issues/6195) [`2ef7c36`](https://github.com/ImageMagick/ImageMagick/commit/2ef7c3652e780d8f4a1396ab7778e8814b0cc0ae)
- set setting to True [`984294d`](https://github.com/ImageMagick/ImageMagick/commit/984294d86affe3af5d856c0ba3a5b399c5b4afd8)
- conditional colormap [`89c07db`](https://github.com/ImageMagick/ImageMagick/commit/89c07db585f57fbda3cb2cf15e197b27a178054f)
- Enabled OpenMP in the portable build. [`f92ab19`](https://github.com/ImageMagick/ImageMagick/commit/f92ab197cfabe8020c014818736e8bed71435d58)
- enable near-lossless compression quality (https://github.com/ImageMagick/ImageMagick/discussions/6204) [`3331c9e`](https://github.com/ImageMagick/ImageMagick/commit/3331c9ed8bdbbdc548f8309a3fadf5b6e638bc98)
- update documentation to use `magick` [`ad86745`](https://github.com/ImageMagick/ImageMagick/commit/ad867455b3cd6e726be11c67419b80dbeb6c9ac8)
- switch http to https [`67d687e`](https://github.com/ImageMagick/ImageMagick/commit/67d687ef2b2c0c349120fcaad9ca3e6c3d9cb874)
- uniform copyright [`71d27ee`](https://github.com/ImageMagick/ImageMagick/commit/71d27ee9c5fab945787547715581b7b48b4f5425)
- channel 0 is a permitted channel (patch from @snibgo) [`4317238`](https://github.com/ImageMagick/ImageMagick/commit/43172387aee0432c1273c03fa30f925b15631fa3)
- update multispectral imagery location [`a23b0f6`](https://github.com/ImageMagick/ImageMagick/commit/a23b0f6db3b66a8b0b0f3a5e9b86caf597d84a62)
- enlarge image tile [`21fed7c`](https://github.com/ImageMagick/ImageMagick/commit/21fed7c3b44ecdd94c08a12f2d4ac28004cb6adc)
- sharper [`7523d7e`](https://github.com/ImageMagick/ImageMagick/commit/7523d7e4057f6828a5f1c599a4b037354966a30c)
- Removed unused includes. [`b359cb2`](https://github.com/ImageMagick/ImageMagick/commit/b359cb2b34a469a577bb6a33d3d0a7df844a3386)
- Cosmetic. [`aee6ef6`](https://github.com/ImageMagick/ImageMagick/commit/aee6ef674a7682f626f778f984c1040ee2274e39)
- Cosmetic [`f0af90e`](https://github.com/ImageMagick/ImageMagick/commit/f0af90e65fc66c79f69e78187c70af10b135dfa6)
- Also set dpi-x and dpi-y when running rsvg-convert (#6214). [`d2e151e`](https://github.com/ImageMagick/ImageMagick/commit/d2e151ef619a70cfa5dd765619d8f64d8930c1f6)
- Only write ResolutionResourceBlock when dpi is set (#6201). [`cc00cae`](https://github.com/ImageMagick/ImageMagick/commit/cc00cae94b58e8e4fcb93ed4ba8583289dd0a864)
- possible heap buffer overflow (https://github.com/ImageMagick/ImageMagick/security/advisories/GHSA-35q2-86c7-9247) [`d7a8bdd`](https://github.com/ImageMagick/ImageMagick/commit/d7a8bdd7bb33cf8e58bc01b4a4f2ea5466f8c6b3)
- account for multiple meta channels (thanks to Dirk) [`359fc70`](https://github.com/ImageMagick/ImageMagick/commit/359fc70e904175c6ae49404f55fe9c3c071ad025)
- Corrected return value of GetQuantumExtent for MultispectralQuantum. [`562360b`](https://github.com/ImageMagick/ImageMagick/commit/562360bb70990931e1380db2fd8b6cae39183f98)
- There is no need to update the rows_remaining. [`8011e36`](https://github.com/ImageMagick/ImageMagick/commit/8011e3634772509bc11a5f4a41fa402fd5312853)
- Improved calculation of the extent. [`142aa5b`](https://github.com/ImageMagick/ImageMagick/commit/142aa5b51f1b1359a0a583c8db7b6e52a9981642)
- No longer "override" error message with NonconformingDrawingPrimitiveDefinition to improve error reporting. [`06186b1`](https://github.com/ImageMagick/ImageMagick/commit/06186b17f6ab292b582d57e8b0aeef66ed50293f)
- multiply strip size by # of samples [`1be141e`](https://github.com/ImageMagick/ImageMagick/commit/1be141ef854916bf48bdda6f1ef0324fcde8cae9)
- release [`b2dd67b`](https://github.com/ImageMagick/ImageMagick/commit/b2dd67b1681e23d0e0b9769d81bed23f05129e2a)

## [7.1.1-5](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-4...7.1.1-5) - 2023-03-26

### Commits

- beta release [`9b9fc9d`](https://github.com/ImageMagick/ImageMagick/commit/9b9fc9dfeee411817250b605daad082f82e08a3e)
- offset to x1 for west gravity (#https://github.com/ImageMagick/ImageMagick/issues/6163) [`bb82582`](https://github.com/ImageMagick/ImageMagick/commit/bb82582f1e08cdb1f039820b532c99de2784c3bc)
- optimization [`de1cc16`](https://github.com/ImageMagick/ImageMagick/commit/de1cc165239e32f6e7f3cf7744bc90cf4bba4142)
- add additional meta channels [`c70f299`](https://github.com/ImageMagick/ImageMagick/commit/c70f299df861223dbab09ba92341e7c329f6bef7)
- ensure source and hald images are in the same colorspace (#https://github.com/ImageMagick/ImageMagick/discussions/6173) [`852a723`](https://github.com/ImageMagick/ImageMagick/commit/852a723f1ea8a4dbf204f013173eb4e17ce4f0c1)
- cosmetic [`71cc1d1`](https://github.com/ImageMagick/ImageMagick/commit/71cc1d17aae2181390a173de8f7291933ee8240f)
- document multispectral imagery (after doc update) [`90e86d4`](https://github.com/ImageMagick/ImageMagick/commit/90e86d47392cc5d24c353c03256f5fc29c77cd27)
- throw warning then writing image format with support for read but not write (https://github.com/ImageMagick/ImageMagick/discussions/6183) [`1083db7`](https://github.com/ImageMagick/ImageMagick/commit/1083db70529509e591baf643483746ef39ec785d)
- MVG must be explicit [`4a24b8d`](https://github.com/ImageMagick/ImageMagick/commit/4a24b8dc1728052f5226f420b70530c29f6b16c4)
- enable left bearing offset for undefined and west gravities [`7ba3a8a`](https://github.com/ImageMagick/ImageMagick/commit/7ba3a8a16af467b3b9d09d95d81747b2a9804adf)
- no_interpolation member introduced in libraw 0.21 [`aba35a6`](https://github.com/ImageMagick/ImageMagick/commit/aba35a6ce00dca61a175f56dc4320db7192b4599)
- Auto correct negative image positions and raise a warning instead. [`194e929`](https://github.com/ImageMagick/ImageMagick/commit/194e929793d7d9019051c5412d434b099c62b9c8)
- Only write position offset since negative values are not allowed for rational (TIFFTAG_XRESOLUTION/TIFFTAG_YRESOLUTION). [`ffa3d25`](https://github.com/ImageMagick/ImageMagick/commit/ffa3d25689e9065624f6062522e25e4f03051466)
- eliminate memory leak when writing the JPS image format [`71fa21b`](https://github.com/ImageMagick/ImageMagick/commit/71fa21bb1756b316c194dfcc7f59142f7ccec8fd)
- release [`5eb3445`](https://github.com/ImageMagick/ImageMagick/commit/5eb344587cfd5af794ef07ec0ad7df99f7e2fa24)
- module is a reserved work in C++ (20) [`92a5afc`](https://github.com/ImageMagick/ImageMagick/commit/92a5afcfaa497372aff3544748143128e9ac416e)
- release [`2d24be5`](https://github.com/ImageMagick/ImageMagick/commit/2d24be538f286962c355cf422bb525375ac77998)

## [7.1.1-4](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-3...7.1.1-4) - 2023-03-18

### Commits

- beta release [`65712a9`](https://github.com/ImageMagick/ImageMagick/commit/65712a975f545c43484ab33a90b449a2052b70ec)
- Removed check that will never be true. [`6422c97`](https://github.com/ImageMagick/ImageMagick/commit/6422c97d9bb4b798d6c57bfaf6ac8a4a9a04b703)
- Removed unused private method. [`ec8c69e`](https://github.com/ImageMagick/ImageMagick/commit/ec8c69e34e1d2fd5947a6b625f958ab8cabdbe66)
- improve default fatal exception handler [`858769e`](https://github.com/ImageMagick/ImageMagick/commit/858769e6450a411b082080998d4fb91085216b5f)
- improve locale exception handling [`b10fda9`](https://github.com/ImageMagick/ImageMagick/commit/b10fda9acb9ec3a10676dd789be7a3bda398d717)
- terminate loop on page sentinel (#https://github.com/ImageMagick/ImageMagick/issues/6158) [`06d3b28`](https://github.com/ImageMagick/ImageMagick/commit/06d3b282a43457da6b3a2d3f84c33e07064a1e98)
- optimization [`2129847`](https://github.com/ImageMagick/ImageMagick/commit/2129847cd6b8f79ba10d2560a36b76de3311d5e6)
- Moved setting the SetUnhandledExceptionFilter to magick.c (#6152) [`bb1841b`](https://github.com/ImageMagick/ImageMagick/commit/bb1841bfdfb85ac145ddb62ae7ea1717a3299d48)
- Also call SetConsoleOutputCP in wmain() instead. [`72c3996`](https://github.com/ImageMagick/ImageMagick/commit/72c3996cf38909b3ab34c23cb2ce2fa16d140721)
- cosmetic [`72f0a8e`](https://github.com/ImageMagick/ImageMagick/commit/72f0a8e08f6b21a438a63eed848b03730ab3c539)
- Make sure that AsynchronousResourceComponentTerminus is exported. [`ca9ad33`](https://github.com/ImageMagick/ImageMagick/commit/ca9ad33a009e4cc7064cb4149d83ea2c2d3a6903)
- We always need to do a seek in our FT_Stream_IoFunc implementation (https://gitlab.freedesktop.org/freetype/freetype/-/issues/1208). [`1288469`](https://github.com/ImageMagick/ImageMagick/commit/12884697a84f185243347069198ab393cae7396c)
- Cosmetic. [`21db2a0`](https://github.com/ImageMagick/ImageMagick/commit/21db2a08eebf2d13a0af158eae1403b8ebcd73de)
- accomodate UTF-8 image file names [`f8dc416`](https://github.com/ImageMagick/ImageMagick/commit/f8dc416e1ca3bac3692c3d2f1ce88ca1d685f8dc)
- Newer versions of libtiff require the field_name to be set so we set it to a static dummy string. [`354f05a`](https://github.com/ImageMagick/ImageMagick/commit/354f05a620884e1a54463a89a35076ec97d5c57f)
- set gamma to 1.0 for linear colorspaces (#https://github.com/ImageMagick/ImageMagick/issues/6157) [`c950eda`](https://github.com/ImageMagick/ImageMagick/commit/c950eda7bf5acf8fdf549126c45517dd890fb126)
- release [`10ad43d`](https://github.com/ImageMagick/ImageMagick/commit/10ad43dc3e5113fa1969a55583a080c5a6a23f65)

## [7.1.1-3](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-2...7.1.1-3) - 2023-03-11

### Merged

- Add HEIC support to AppImage (Partially solve #4666) [`#6098`](https://github.com/ImageMagick/ImageMagick/pull/6098)

### Commits

- beta release [`0e525cc`](https://github.com/ImageMagick/ImageMagick/commit/0e525cc97ad7b0a31d817ab723905b035854e697)
- synchronize meta channel names, e.g., meta0, meta1, etc. [`14255d0`](https://github.com/ImageMagick/ImageMagick/commit/14255d004f62599079b9fd2986211119d1dda791)
- Also call MagickWandTerminus in TerminateMagick. [`55682a7`](https://github.com/ImageMagick/ImageMagick/commit/55682a795d1e707aaacbda847971677957f8da20)
- MagickWandTerminus calls MagickCoreTermines so we don't need to call both of them. [`75e4766`](https://github.com/ImageMagick/ImageMagick/commit/75e4766e03eb9267c24419461ac1c8cb0396c7df)
- fix memory leak in cloning DrawInfo structure (https://github.com/ImageMagick/ImageMagick/issues/6149) [`84d7ad1`](https://github.com/ImageMagick/ImageMagick/commit/84d7ad135f61073304053a7d9ab2cf66b63df0ef)
- release [`c5d5e71`](https://github.com/ImageMagick/ImageMagick/commit/c5d5e7117fb07096158bcad05e1086f0c2fff172)

## [7.1.1-2](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-1...7.1.1-2) - 2023-03-09

### Commits

- release [`f41f852`](https://github.com/ImageMagick/ImageMagick/commit/f41f852be7e5eb75ecd5d0b3e262ffed42795a1a)
- release [`5d382e7`](https://github.com/ImageMagick/ImageMagick/commit/5d382e70c2f82534f0d1638cd21c1050af68af2f)

## [7.1.1-1](https://github.com/ImageMagick/ImageMagick/compare/7.1.1-0...7.1.1-1) - 2023-03-09

### Merged

- restore library symbol versioning to fix ABI break [`#6145`](https://github.com/ImageMagick/ImageMagick/pull/6145)

### Commits

- beta release [`3ac92ec`](https://github.com/ImageMagick/ImageMagick/commit/3ac92ec21130747d4eeba925886919ec5e8bc5ef)
- PNG compression filters range from 0-5 [`1307d32`](https://github.com/ImageMagick/ImageMagick/commit/1307d322cd0736304863f18c52abd4def5cc171a)
- check for c++ compiler [`ecf3739`](https://github.com/ImageMagick/ImageMagick/commit/ecf37396ee11377af9b3d254713b434f85181cf1)
- support an array of metachannels without breaking the ABI [`25ce9ad`](https://github.com/ImageMagick/ImageMagick/commit/25ce9adb9dc3bec246682b493d0ce67bf51ba5a8)
- release [`c557f0d`](https://github.com/ImageMagick/ImageMagick/commit/c557f0d12dac99d391a4ed4d7e8a74b5efe59f66)

## [7.1.1-0](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-62...7.1.1-0) - 2023-03-08

### Merged

- improve Install-unix.txt [`#6105`](https://github.com/ImageMagick/ImageMagick/pull/6105)

### Commits

- beta release [`fd12019`](https://github.com/ImageMagick/ImageMagick/commit/fd12019f3650c63623f2b8888f0b6326f8156c4f)
- Code cleanup. [`b430dc1`](https://github.com/ImageMagick/ImageMagick/commit/b430dc10bb14a14c891065a13306db97a4f00740)
- Added support for reading ATI2 (BC5) images (#5919). [`7e5875b`](https://github.com/ImageMagick/ImageMagick/commit/7e5875b97e442f6b6f67e58d99d85b1ad2efbaf1)
- correct RLE unpack algorithm [`a1bd818`](https://github.com/ImageMagick/ImageMagick/commit/a1bd8188b3ad679f0814ae3935e45e496381df19)
- return total channels and meta channels [`8abb434`](https://github.com/ImageMagick/ImageMagick/commit/8abb43486dffc115b4e07ddef16296cc25e72d82)
- do not exceed 64 pixel channels (https://github.com/ImageMagick/ImageMagick/issues/6075) [`8c97870`](https://github.com/ImageMagick/ImageMagick/commit/8c978704bf132799efbae94aade632a6a099a0e7)
- properly detect an extra samples alpha channel (https://github.com/ImageMagick/ImageMagick/issues/6058) [`c6efe14`](https://github.com/ImageMagick/ImageMagick/commit/c6efe14959b8801471259d47858b177ea3890298)
- Added extra check to resolve the issue reported in #6080 (-process ' '). [`2c2829b`](https://github.com/ImageMagick/ImageMagick/commit/2c2829bd2af469a957e30a5de96a2e763c1c16b9)
- detect RLE error [`b2f4f4a`](https://github.com/ImageMagick/ImageMagick/commit/b2f4f4a2a45c1c9640aadeaace5ee926c92664ff)
- check for sans fonts [`0427628`](https://github.com/ImageMagick/ImageMagick/commit/04276281471885e2200848330985df9fa9301a01)
- check for NULL destination image [`295e075`](https://github.com/ImageMagick/ImageMagick/commit/295e0755b2d4d8352516209450969df015104a8a)
- improved support for meta channels in TIFF format (https://github.com/ImageMagick/ImageMagick/discussions/4995) [`2ef0b31`](https://github.com/ImageMagick/ImageMagick/commit/2ef0b31c2e9a45965388407c4c757fe740ecfee1)
- account for meta channels [`91e3c66`](https://github.com/ImageMagick/ImageMagick/commit/91e3c66c03852c64dd6e91f1040180dc8866a0c8)
- the channel mask is irrelevant [`bb2274b`](https://github.com/ImageMagick/ImageMagick/commit/bb2274b5763a5445d7f0ccd5df15e5204db1366c)
- revert [`847a5ae`](https://github.com/ImageMagick/ImageMagick/commit/847a5aeb330535096fd354ec97b3e040df0e140f)
- generate correct statistics for meta channels (https://github.com/ImageMagick/ImageMagick/issues/6097) [`876785e`](https://github.com/ImageMagick/ImageMagick/commit/876785ecd5bd243779c18aff6712b9ae9bad01a4)
- check for exceeding maximum channels [`63b53d3`](https://github.com/ImageMagick/ImageMagick/commit/63b53d3beea72b368bb2da6043c24b778d90e340)
- set the number of meta channels [`1abb25d`](https://github.com/ImageMagick/ImageMagick/commit/1abb25dd08683974d1701989b96060bdc29acf3a)
- Also build app-image with a pull request. [`cd1df2a`](https://github.com/ImageMagick/ImageMagick/commit/cd1df2af448041b6d86c5841ecdb402bb73380b1)
- continuing effort to support multispectral imaging [`584a326`](https://github.com/ImageMagick/ImageMagick/commit/584a326978ce1e0a868cff473d41d509b3393552)
- eliminate compiler warning [`844d21b`](https://github.com/ImageMagick/ImageMagick/commit/844d21bd6e42acf5bfead1baa8f23e2d079504fc)
- No longer check for Noto Sans and Nimbus Sans to make sure the correct default is used on Windows. [`a0f7fbf`](https://github.com/ImageMagick/ImageMagick/commit/a0f7fbff738066c71076bcde29fb8b900a671277)
- Restored missing null check. [`184cce1`](https://github.com/ImageMagick/ImageMagick/commit/184cce1636d0832effbad2ad6b71d19a7e4d4828)
- check for negative LUT lookup (https://github.com/ImageMagick/ImageMagick/issues/6070) [`de5f368`](https://github.com/ImageMagick/ImageMagick/commit/de5f368ee961855112d29ef8929f3df8433bc1e5)
- get MAGICK_FONT environment variable [`d8d0c9a`](https://github.com/ImageMagick/ImageMagick/commit/d8d0c9abdee8b0576ab2101783d48bc94141d24d)
- valid compression filters are 0 through 9 (https://github.com/ImageMagick/ImageMagick/discussions/6108) [`552c2c5`](https://github.com/ImageMagick/ImageMagick/commit/552c2c566c025d81ae177780220709d97a47c80a)
- Only allocate the sans_exception when we need to. [`03f0663`](https://github.com/ImageMagick/ImageMagick/commit/03f0663896d872f9facec8b6aebe75a4182710f0)
- site: fix typo for compare [`033e255`](https://github.com/ImageMagick/ImageMagick/commit/033e2559e5ab77a5de46287f2287ae0bd809c25d)
- clone latest documentation [`5819ff1`](https://github.com/ImageMagick/ImageMagick/commit/5819ff1fd0e88062f8fc8b5ca6b082199dba9714)
- channel FX and meta-channels, work in progress [`62f1608`](https://github.com/ImageMagick/ImageMagick/commit/62f1608e896cf4ffd5b703085af2db103ad1b78a)
- only set alpha trait for "alpha" mnemonic [`787c001`](https://github.com/ImageMagick/ImageMagick/commit/787c0018e878446cfd23489e7490d2a928cd14db)
- add support for more than one meta channel [`b9c30c3`](https://github.com/ImageMagick/ImageMagick/commit/b9c30c3ee8c133dd415472b978272ca986c121b8)
- support meta1 ... meta9 meta channels [`6b9f68f`](https://github.com/ImageMagick/ImageMagick/commit/6b9f68f14472e16d3f070dab77daafaa7350e016)
- support meta0 channel [`05fe46f`](https://github.com/ImageMagick/ImageMagick/commit/05fe46f9633d68d2aa4b697cf5bb97b1c7416ea1)
- still work to be done for multispectral images [`bead12a`](https://github.com/ImageMagick/ImageMagick/commit/bead12a05dee3e8adbdf32c85e1528cfd79e8424)
- more fixes for multispectral support [`d1e4d78`](https://github.com/ImageMagick/ImageMagick/commit/d1e4d786aef7b1ecf98b0b8bac005ea2abf944d5)
- identify a default font [`2ede725`](https://github.com/ImageMagick/ImageMagick/commit/2ede7250ffa558b42b88b8946c1f9a0c8c0315c7)
- additional support for multisprectral images [`6b2ae4e`](https://github.com/ImageMagick/ImageMagick/commit/6b2ae4ebca0b4e5f698c45f68297615156ce25d2)
- Also include optional libraries and deprecated code in the daily Windows build. [`0c00814`](https://github.com/ImageMagick/ImageMagick/commit/0c008149ca0e90287dc9cce58d1c699043c321eb)
- Also include incompatible licenses in the daily Windows build. [`8573c43`](https://github.com/ImageMagick/ImageMagick/commit/8573c43cb86063d884d5616953034517334056e6)
- Moved declaration of variable. [`779cb0c`](https://github.com/ImageMagick/ImageMagick/commit/779cb0c9c8d91b7b3863da0367f3ee8dbfa6338d)
- Added option (tiff:jpeg-tables-mode) to set the TIFFTAG_JPEGTABLESMODE. [`455e3cb`](https://github.com/ImageMagick/ImageMagick/commit/455e3cba6768e8eae7231a395ea60b0ec36314dd)
- throw exception for invalid channel type [`a59e589`](https://github.com/ImageMagick/ImageMagick/commit/a59e589eab4c01f5aaf74dbe40217a2a38655ed8)
- eliminate compiler warnings [`25d9d29`](https://github.com/ImageMagick/ImageMagick/commit/25d9d2970c249b32fbc79c409298b5936ef06c62)
- Fixed printing of the delegates when running configure. [`f73a3d1`](https://github.com/ImageMagick/ImageMagick/commit/f73a3d1a0663fd6dd58b0cc78c2541c41769fdd0)
- do not permit MVG coder from rendering SVG/MSVG images [`f7de350`](https://github.com/ImageMagick/ImageMagick/commit/f7de350f571ad6216dd4a840732a36c89ea6fd0f)
- Check for module instead of coder. [`accdd08`](https://github.com/ImageMagick/ImageMagick/commit/accdd08951d5fd055986176bfc55314fb6d5f4a8)
- recursion detection [`83d6643`](https://github.com/ImageMagick/ImageMagick/commit/83d6643b5dc2afa67c699967e9f71ca2f821dce4)
- recursion detection [`1010008`](https://github.com/ImageMagick/ImageMagick/commit/1010008fcc9f81eecaad13d08ea9ff18d1f8bb63)
- Removed checks for PANGO_DELEGATE since we only use pangocairo. [`8f7e7aa`](https://github.com/ImageMagick/ImageMagick/commit/8f7e7aa1a0dc26a81a3d1c5d77c1fded5661108e)
- Turns out we need to check for both pango and pangocairo to get the correct includes. [`e0f67d2`](https://github.com/ImageMagick/ImageMagick/commit/e0f67d257674f779168bfbac20584ee6b8dfb023)
- recursion detection framework [`9d3dd91`](https://github.com/ImageMagick/ImageMagick/commit/9d3dd9192f6710ec8e10f5edda9b7bf67caeb232)
- recursion detection [`9b2c57f`](https://github.com/ImageMagick/ImageMagick/commit/9b2c57f8794249f6b8fe2629c4ea01832d0a817f)
- erecursion detection [`c5b23cb`](https://github.com/ImageMagick/ImageMagick/commit/c5b23cbf2119540725e6dc81f4deb25798ead6a4)
- recursion detection fail [`d60d266`](https://github.com/ImageMagick/ImageMagick/commit/d60d2662f0e12f78d20fb1c90cc19dd1729233f7)
- do not composite SVG to avoid possible recursion [`a3b0f6c`](https://github.com/ImageMagick/ImageMagick/commit/a3b0f6c0677e4db09236ccb0c934db7aef3cd52f)
- Added pdf:printed define that can be used to set -dPrinted when executing Ghostscript (#6128). [`2e984f9`](https://github.com/ImageMagick/ImageMagick/commit/2e984f995bdc75fb5b956b8d35d7d4e511d97f7a)
- release [`9009707`](https://github.com/ImageMagick/ImageMagick/commit/9009707d09287d168057cb6018b37b68dd586775)

## [7.1.0-62](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-61...7.1.0-62) - 2023-02-12

### Merged

- add `BC5_UNORM` compression support [`#6039`](https://github.com/ImageMagick/ImageMagick/pull/6039)

### Commits

- beta release [`a8dc29d`](https://github.com/ImageMagick/ImageMagick/commit/a8dc29d0d2d8f9c4fb5441a388fa36f10d49827f)
- beta release [`79ff987`](https://github.com/ImageMagick/ImageMagick/commit/79ff9879a88a56627c743a716f83dc62656d2600)
- support filenames with embedded characters (https://github.com/ImageMagick/ImageMagick/issues/6040) [`3c49ec1`](https://github.com/ImageMagick/ImageMagick/commit/3c49ec13f6d143f5a36dcb10a8e3433dbbc25a3c)
- cast from character to short [`361a40f`](https://github.com/ImageMagick/ImageMagick/commit/361a40fbd87dd626449ca3613ee70c36ed1335a9)
- Fix EOI marker detection for Exif [`0a3c9ed`](https://github.com/ImageMagick/ImageMagick/commit/0a3c9ed40f6e34eeda9f2d5b437e33f49817fb7c)
- improve bounds checking [`03b12db`](https://github.com/ImageMagick/ImageMagick/commit/03b12db7d67c4069f72dfa0bd75e35eaffebc538)
- Added BC5Compression. [`6ef17a6`](https://github.com/ImageMagick/ImageMagick/commit/6ef17a6e9539bf66cdf73788e127348878547682)
- Code style changes. [`89826e5`](https://github.com/ImageMagick/ImageMagick/commit/89826e5b12db1344550236fd4a0f60c4d76ae0bf)
- Changed order. [`3a69948`](https://github.com/ImageMagick/ImageMagick/commit/3a69948d93b5c00d4d49c15342e8da7db58071ce)
- More code style changes. [`322e4bc`](https://github.com/ImageMagick/ImageMagick/commit/322e4bce666cbb8ca6ee5df27db79cbc52124486)
- Another minor change. [`b5df91a`](https://github.com/ImageMagick/ImageMagick/commit/b5df91a8c0ebec6854940bd892f794d6827a470a)
- Avoid typecasting. [`5d002fd`](https://github.com/ImageMagick/ImageMagick/commit/5d002fd6e37dbcc05a4b3ace00a4a0a99c9feb94)
- There is no need to set the alpha channel. [`f01454c`](https://github.com/ImageMagick/ImageMagick/commit/f01454c8814de622bd99ef9dcede46591cb008ab)
- alpha_trait should be undefined for ReadBC5. [`75aac78`](https://github.com/ImageMagick/ImageMagick/commit/75aac78f97f01db1363dd84c0a40d9ff0e9bc03b)
- handle undefined EXIF tag (https://github.com/ImageMagick/ImageMagick/issues/6052) [`e0b640e`](https://github.com/ImageMagick/ImageMagick/commit/e0b640e0e4660f24455134df240ac0da8f12ba15)
- Update SECURITY.md [`a8668be`](https://github.com/ImageMagick/ImageMagick/commit/a8668be21f6976f9306462cf84f17f0351b71f53)
- eliminate compiler warnings [`74b3683`](https://github.com/ImageMagick/ImageMagick/commit/74b3683a4c6c22d42019c753377ae844755e6dab)
- release [`32ce406`](https://github.com/ImageMagick/ImageMagick/commit/32ce406898b6f9992103cc0ee353f31a0e83f063)

## [7.1.0-61](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-60...7.1.0-61) - 2023-02-05

### Merged

- Fix wonky wording in SECURITY.md [`#6033`](https://github.com/ImageMagick/ImageMagick/pull/6033)
- Link MagickCore to urlmon when targeting Windows [`#6032`](https://github.com/ImageMagick/ImageMagick/pull/6032)

### Commits

- beta release [`b236524`](https://github.com/ImageMagick/ImageMagick/commit/b236524b27cfee49e58b938687024099b917de35)
- fix copyright [`e23ce3b`](https://github.com/ImageMagick/ImageMagick/commit/e23ce3bc66b26b2e7c63be6a77bc700810eac993)
- Whitespace [`d2079f1`](https://github.com/ImageMagick/ImageMagick/commit/d2079f18721f3e44ea6f5a0d5b550c823517570f)
- Corrected the seek implementation (https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=55325). [`977e449`](https://github.com/ImageMagick/ImageMagick/commit/977e449b4190f8d1bc300a44d1e80f89da483ba5)
- add support for -list pagesize [`ae4f311`](https://github.com/ImageMagick/ImageMagick/commit/ae4f311e3468cfc23cfb92c5f38940b8d3240ea4)
- Silenced warning. [`3c67022`](https://github.com/ImageMagick/ImageMagick/commit/3c6702293ed035fb8bb2a6491068a6b2b121c84e)
- Brotli files are no longer installed. [`12b2f5f`](https://github.com/ImageMagick/ImageMagick/commit/12b2f5f4f5f7e770264b180978def9380a5bba3a)
- Fuzzing build now also requires -lbrotlicommon. [`8ceca5d`](https://github.com/ImageMagick/ImageMagick/commit/8ceca5d5fb388f73f7b7fc624fa484611693e949)
- Disable LOSSLESS_SUPPORTED checks for libjpeg turbo because they break with their latest code. [`1175c9c`](https://github.com/ImageMagick/ImageMagick/commit/1175c9c3197cfcd21970772a62b1a6135c8d68f0)
- Removed -static suffix. [`574684e`](https://github.com/ImageMagick/ImageMagick/commit/574684e5eca990dc2e9a7183d960d1b6d9f088b2)
- disable setting profile:&lt;filename&gt; property as it is a security risk [`8235d35`](https://github.com/ImageMagick/ImageMagick/commit/8235d35d41f8d3cbd0c20612c406129593dbbf73)
- eliminate compiler warning [`a975e1b`](https://github.com/ImageMagick/ImageMagick/commit/a975e1b83bf7386c9adf56b4d3d14998090bdaed)
- revert [`c97c0db`](https://github.com/ImageMagick/ImageMagick/commit/c97c0db432ad971b19163e0787626d3cf3947aed)
- move `-set profile` handling to CLI [`2f6db24`](https://github.com/ImageMagick/ImageMagick/commit/2f6db246a38236567e11f16a0f0ebdca9954f431)
- Moved check for @ (indirect read) to FileToString and also check the policy inside that method. [`790764e`](https://github.com/ImageMagick/ImageMagick/commit/790764e49b3b30dc36fd2d56dcc9a0245f75860d)
- add a null byte to the iTXt chunk [`62e47eb`](https://github.com/ImageMagick/ImageMagick/commit/62e47eb4a21393211f54577536fc57339af9cecb)
- remove redundant path policy check [`1e2379f`](https://github.com/ImageMagick/ImageMagick/commit/1e2379f3c457c100854fdfed1ed141fed8c0c394)
- revert [`9c9d90f`](https://github.com/ImageMagick/ImageMagick/commit/9c9d90f7cdb9af44a2c68bbaf3e6c00917943963)
- update signatures [`2e616bd`](https://github.com/ImageMagick/ImageMagick/commit/2e616bde4d44b96f36fdcb552d22a5cfbc6e7862)
- ... [`88ccc99`](https://github.com/ImageMagick/ImageMagick/commit/88ccc99c92f9e67be046dea788494adfa89d06e8)
- update example [`f66786e`](https://github.com/ImageMagick/ImageMagick/commit/f66786e016266d951d556646c0c5d6ca20be4b57)
- ... [`f13c503`](https://github.com/ImageMagick/ImageMagick/commit/f13c503844f531ecb766b8ab3227ef32374f9440)
- cosmetic [`4e9ab48`](https://github.com/ImageMagick/ImageMagick/commit/4e9ab480a6c63ba896e9308b0b546a409c9bfc42)
- allow SI units with --with-cache configure option [`6558dbb`](https://github.com/ImageMagick/ImageMagick/commit/6558dbbd880dc1caa49c9f7d319d668e61c2dcab)
- Autogenerate release notes. [`d50e08f`](https://github.com/ImageMagick/ImageMagick/commit/d50e08f9bad4e43e0e7b563ae7f5642324cbe0fe)
- latest automake updates [`2dbe2c6`](https://github.com/ImageMagick/ImageMagick/commit/2dbe2c65c8cce6f32eb8198f62e0556c1cf611c6)
- latest automake updates [`1abcc73`](https://github.com/ImageMagick/ImageMagick/commit/1abcc73353026b110e3ab10b903c7f658404bede)
- eliminate unterminated macro [`68358d7`](https://github.com/ImageMagick/ImageMagick/commit/68358d70389840b9a44be08974d0d5f40ada096a)
- cosmetic [`4319441`](https://github.com/ImageMagick/ImageMagick/commit/431944147432e6facbfe20eff4074780172a5ab8)
- Don't use container when creating ChangeLog.md [`08d4a9d`](https://github.com/ImageMagick/ImageMagick/commit/08d4a9d1cf7dd24677577bb108cb1f18245b57b6)
- Don't use container when creating ChangeLog.md [`df5148e`](https://github.com/ImageMagick/ImageMagick/commit/df5148e25cbd8d1ca6d8a24695bab2d2c4660ffa)
- improve decompression errors [`6b11831`](https://github.com/ImageMagick/ImageMagick/commit/6b11831de742e3de6d227865c7507ebbb56a502d)
- release [`d396287`](https://github.com/ImageMagick/ImageMagick/commit/d3962875c233e7dfe741e86a2e65ad28c8c6c05f)

## [7.1.0-60](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-59...7.1.0-60) - 2023-01-29

### Commits

- beta release [`6f5f21e`](https://github.com/ImageMagick/ImageMagick/commit/6f5f21e50306546071cc730977eb45b5353c4443)
- Use #if instead of checking if the value is defined. [`d50c8c5`](https://github.com/ImageMagick/ImageMagick/commit/d50c8c51f33dab6ea644df5c79b24b558191108a)
- release [`212bed9`](https://github.com/ImageMagick/ImageMagick/commit/212bed9bab497c0f738c0f11ded1f34656ff154e)

## [7.1.0-59](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-58...7.1.0-59) - 2023-01-28

### Merged

- Strip EOI marker from HEIC/JXL Exif payload [`#6005`](https://github.com/ImageMagick/ImageMagick/pull/6005)
- Fix for space handling in appimage path [`#5993`](https://github.com/ImageMagick/ImageMagick/pull/5993)

### Commits

- beta release [`44f7797`](https://github.com/ImageMagick/ImageMagick/commit/44f779728fd0a6e2d4dccff51bc8e7f9c0dd54d2)
- initialize RLE pixels [`7b3eb56`](https://github.com/ImageMagick/ImageMagick/commit/7b3eb56aeb5882e52669e0d06b3425a3649a32c1)
- Replace tabs with spaces. [`30d823e`](https://github.com/ImageMagick/ImageMagick/commit/30d823eb749bee9a341ba9393438ee42b8b96500)
- wrong byte order [`010bbd2`](https://github.com/ImageMagick/ImageMagick/commit/010bbd2068f7d9da1c980f3393e2f5ecdc688ff4)
- Code style changes. [`ddb90b8`](https://github.com/ImageMagick/ImageMagick/commit/ddb90b8502d37715ad9b21c521bc25782536561c)
- Revert incorrect change... [`5075742`](https://github.com/ImageMagick/ImageMagick/commit/5075742b7e62ed3a6833684bf47aa85a2268e65d)
- only support WPG postscript embedded images [`89ed3a8`](https://github.com/ImageMagick/ImageMagick/commit/89ed3a846a1d2fbe866f891de3e0d16edf43a4e0)
- SETJMP_IS_THREAD_SAFE symbol requires namespace prefix (https://github.com/ImageMagick/ImageMagick/discussions/4123) [`7e53875`](https://github.com/ImageMagick/ImageMagick/commit/7e53875836c3d8950b3f848600f0c6bd682fe7fe)
- add MAGICKCORE prefix [`da36023`](https://github.com/ImageMagick/ImageMagick/commit/da36023786cf83f769a37cb84ef25721d41d19d4)
- add MAGICKCORE namespace prefix [`cd2d51c`](https://github.com/ImageMagick/ImageMagick/commit/cd2d51c5fe66f3118df075c644c2ea2c50fa19c9)
- remedy uninitialized value [`8fd36bc`](https://github.com/ImageMagick/ImageMagick/commit/8fd36bc22690b2cad1fd3a4e1f4f0532f9d43ced)
- permit setting colormap with empty pixel cache [`44e4444`](https://github.com/ImageMagick/ImageMagick/commit/44e44441f0cfe382d1574bea71e8ebdf0f324f2c)
- ensure code will compile with an ANSI-C compiler [`7b33aac`](https://github.com/ImageMagick/ImageMagick/commit/7b33aacbc8fbdb20026c339874e0b7739c8ebd68)
- Code cleanup. [`3354da9`](https://github.com/ImageMagick/ImageMagick/commit/3354da99df1615afa4c561571f610993b22824e2)
- Fixed implementation. [`db40940`](https://github.com/ImageMagick/ImageMagick/commit/db4094037e4422ba6278037a4c318c98d42c7e6d)
- Minor refactoring. [`039b26d`](https://github.com/ImageMagick/ImageMagick/commit/039b26d605a78f67f11166d8d6628c9832f450b4)
- Don't raise exception when photoshop layers could not be read (#6004). [`5bef560`](https://github.com/ImageMagick/ImageMagick/commit/5bef560e862bd7bc3767f62931da37a495ed42c6)
- cosmetic [`b39694b`](https://github.com/ImageMagick/ImageMagick/commit/b39694be7b6fc3cf3a2f96190869e96b2609998d)
- improve support for PNG iTXt chunk [`929dffc`](https://github.com/ImageMagick/ImageMagick/commit/929dffcefc4ccc0e09e49094d2da754cded8be2a)
- release [`e812c5e`](https://github.com/ImageMagick/ImageMagick/commit/e812c5efb8f4f7ed66ff9e6c90eb5024ad7c2ea7)
- Delay release. [`d045a60`](https://github.com/ImageMagick/ImageMagick/commit/d045a60f030e33525a821392e1c19c1bfd47adba)
- release [`3699462`](https://github.com/ImageMagick/ImageMagick/commit/3699462804a9f626460d0c5f91255893ea8d994f)
- release [`eda3e73`](https://github.com/ImageMagick/ImageMagick/commit/eda3e7366d46ad5904c593ad2508396978d05764)
- release [`6192ed2`](https://github.com/ImageMagick/ImageMagick/commit/6192ed29eb8db563a09093b0529933f2b09645f2)

## [7.1.0-58](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-57...7.1.0-58) - 2023-01-22

### Merged

- Fix Exif reading for JPEG XL [`#5932`](https://github.com/ImageMagick/ImageMagick/pull/5932)
- Fix Exif writing for HEIF/JPEG XL [`#5929`](https://github.com/ImageMagick/ImageMagick/pull/5929)

### Commits

- beta release [`1590c22`](https://github.com/ImageMagick/ImageMagick/commit/1590c22ecc63c09043f221d4291b86ed93cb2bbd)
- beta release [`da5c3c1`](https://github.com/ImageMagick/ImageMagick/commit/da5c3c1bbe3315fb98053cca5b6ab494e8b0ddce)
- cosmetic [`226533f`](https://github.com/ImageMagick/ImageMagick/commit/226533f66d669a81a0dbdef9104c44a4fdb3e2f0)
- cosmetic [`56fba37`](https://github.com/ImageMagick/ImageMagick/commit/56fba375ff6f83abe4398f2a1e94b61cb1de47c8)
- eliminate uninitialised value (https://github.com/ImageMagick/ImageMagick/issues/5916) [`9299149`](https://github.com/ImageMagick/ImageMagick/commit/9299149e7e972c0736f7bc03f5823c050b8b361d)
- initialize texture background [`c604295`](https://github.com/ImageMagick/ImageMagick/commit/c604295d1eafb85c4074cc3dbc5da1e1d2acf3c2)
- use define rather than constant [`e7f84cd`](https://github.com/ImageMagick/ImageMagick/commit/e7f84cda70bb5724086d440402806d8cd34420a0)
- DCX limited to 1024 frames [`69a5872`](https://github.com/ImageMagick/ImageMagick/commit/69a58726ecf148f56bc499c2803d897587485aba)
- eliminate compiler warning [`0f42619`](https://github.com/ImageMagick/ImageMagick/commit/0f42619717724bbcef04b546f1488bf9e8f6da1c)
- read old-style TXT images (https://github.com/ImageMagick/ImageMagick/issues/5922) [`c06fd8c`](https://github.com/ImageMagick/ImageMagick/commit/c06fd8cb8c24fe087557742a9a0b33c7d136797d)
- bounds check [`608cf01`](https://github.com/ImageMagick/ImageMagick/commit/608cf01cf65a91e827dd148d84c9df656999dc83)
- set default resolution [`393c95e`](https://github.com/ImageMagick/ImageMagick/commit/393c95ed0f1d7c5320f60d51785143f02b20825b)
- Code cleanup. [`016705d`](https://github.com/ImageMagick/ImageMagick/commit/016705dc1a801f5c5587148e8c1e7059c6f7bb95)
- https://github.com/ImageMagick/ImageMagick/pull/5930 [`a42a907`](https://github.com/ImageMagick/ImageMagick/commit/a42a9071e6a28758b05eea28a08651b14ebf6511)
- Code cleanup [`ef93cfe`](https://github.com/ImageMagick/ImageMagick/commit/ef93cfeb4aea3e4474f04cf8a5a8f6e6b638ce9b)
- revert support for Hue colorspace (https://github.com/ImageMagick/ImageMagick/issues/5942) [`f220cb9`](https://github.com/ImageMagick/ImageMagick/commit/f220cb95f09da3c1435a992d03838548edf1bdef)
- Removed debug logging of versions. [`0d9594e`](https://github.com/ImageMagick/ImageMagick/commit/0d9594e2a618b8eb33b13984f69ee5e4bd2eb270)
- Removed useless statement. [`a2e608c`](https://github.com/ImageMagick/ImageMagick/commit/a2e608c2e1c9a4393d04fbe0ec25d7d22dfe7e23)
- No longer change image to direct class when it has an alpha channel. [`0e717ce`](https://github.com/ImageMagick/ImageMagick/commit/0e717cea5d32027402f47793a416b398552c87e7)
- Fixed setting the image type. [`831880e`](https://github.com/ImageMagick/ImageMagick/commit/831880e8a7cfcf321298a5735717801f19c218b2)
- Whitespace [`8790df6`](https://github.com/ImageMagick/ImageMagick/commit/8790df6791951e186d9f3970e0840597104ac12d)
- Removed MNG_OBJECT_BUFFERS code. [`cf4cce9`](https://github.com/ImageMagick/ImageMagick/commit/cf4cce914042c50e1a78ac4403486bb067fe6d50)
- Removed MNG_BASI_SUPPORTED code. [`97dd5a9`](https://github.com/ImageMagick/ImageMagick/commit/97dd5a96232765a4cadfa1822db1b0437c09bb34)
- Removed PNG_DEBUG define. [`12ef402`](https://github.com/ImageMagick/ImageMagick/commit/12ef40201fe8de510c0e04430571806f80e79352)
- Removed checks for MNG_COALESCE_LAYERS. [`a4aeb8e`](https://github.com/ImageMagick/ImageMagick/commit/a4aeb8ea9b9d5c5e335b5fdad33e29cdb7deb3d4)
- Removed MNG_INSERT_LAYERS checks. [`7f1b8df`](https://github.com/ImageMagick/ImageMagick/commit/7f1b8dfda2a1a0b89b4d7b244c8b26a085943f1c)
- Removed check for RGBColorMatchExact. [`9c63342`](https://github.com/ImageMagick/ImageMagick/commit/9c633429727b9b07deaddd081fb9b3829470d160)
- Removed first_scene define. [`a006da0`](https://github.com/ImageMagick/ImageMagick/commit/a006da0756b8fbec8dcbba7bbded0d817f44b8be)
- Removed PNG_PTR_NORETURN. [`07927dd`](https://github.com/ImageMagick/ImageMagick/commit/07927ddf399c7cabdce102460a5f323eeb5a12b9)
- Removed PNG_DEPSTRUCT. [`1809d8d`](https://github.com/ImageMagick/ImageMagick/commit/1809d8d083a0cba7c17a8b7a79076c5a2a65970a)
- Added missing check for PNG_COLOR_TYPE_PALETTE + 1. [`c05b0a7`](https://github.com/ImageMagick/ImageMagick/commit/c05b0a7ff220e89e61a9ae29537bc257e0c59426)
- Only allow PNG_COLOR_TYPE_PALETTE when image has no alpha channel. [`b573cd7`](https://github.com/ImageMagick/ImageMagick/commit/b573cd7a5140f68a4664ca180dcc0d2a2c193ef7)
- Code cleanup. [`eb6ba6c`](https://github.com/ImageMagick/ImageMagick/commit/eb6ba6c2cd8a0110662f0f47ff848d37b7f93e4e)
- Split MngInfo into MngReadInfo and MngWriteInfo. [`ba1c55d`](https://github.com/ImageMagick/ImageMagick/commit/ba1c55d98160fb320ebb6d4ae3bfeae233200749)
- Cleanup comments. [`a549ab8`](https://github.com/ImageMagick/ImageMagick/commit/a549ab8107bdc78139a6d63b3d26ccf5cc7ee0b8)
- Removed unused fields. [`b0397ec`](https://github.com/ImageMagick/ImageMagick/commit/b0397ecc8bb1e3bf5a9f59d4043a45f8924637a5)
- Code cleanup. [`048d847`](https://github.com/ImageMagick/ImageMagick/commit/048d8473655525d2294612b0c1e2490a83f67dc2)
- Removed ping prefix and copy action of excludes that are never changed. [`d6efc18`](https://github.com/ImageMagick/ImageMagick/commit/d6efc18d823d9fbca19900dd2112662991786841)
- Changed have_global_bkgd into a MagickBooleanType. [`3492436`](https://github.com/ImageMagick/ImageMagick/commit/3492436e2d9ca85d4b8696071804fe3ff7f972e2)
- "if" statement now returns the expected value (https://github.com/ImageMagick/ImageMagick/discussions/4533) [`6553b82`](https://github.com/ImageMagick/ImageMagick/commit/6553b824931828b9ca7319dc02b257340e966a8b)
- Changed more have_ fields in MagickBooleanType. [`cddd515`](https://github.com/ImageMagick/ImageMagick/commit/cddd515ae8eed4f24a5ff22bfe79feb1d36c2831)
- Removed write from variable names because we now have a new struct. [`1176f30`](https://github.com/ImageMagick/ImageMagick/commit/1176f307791971b84fc2ee98e191acfd56a7832e)
- Changed equal_ fields to MagickBooleanType. [`53b55c7`](https://github.com/ImageMagick/ImageMagick/commit/53b55c73a2398bb1aa4025c1c32b78bef17ce526)
- Changed type of another field to MagickBooleanType. [`4fd1162`](https://github.com/ImageMagick/ImageMagick/commit/4fd1162c093a17051ba2671779899d99b2241da7)
- Renamed field. [`e8bb36f`](https://github.com/ImageMagick/ImageMagick/commit/e8bb36fbfdd53028e2a1f244fa5294d3f942871f)
- Renamed fields [`99c596a`](https://github.com/ImageMagick/ImageMagick/commit/99c596af210beb69088de9b5f191c3862e6da0b9)
- Changed write_ fields to MagickBooleanType. [`2e78e88`](https://github.com/ImageMagick/ImageMagick/commit/2e78e882ada26d3acde3932934f81112778ebd76)
- Removed printf statements. [`2927c97`](https://github.com/ImageMagick/ImageMagick/commit/2927c975baf55d931aee65711bd05ca3f4e8cd14)
- Removed PNG_LIBPNG_VER &gt; 10011 checks. [`a99cb17`](https://github.com/ImageMagick/ImageMagick/commit/a99cb1713912b36e74251a6fba95cbfe063d26fe)
- Remove extra parenthesis. [`6f92793`](https://github.com/ImageMagick/ImageMagick/commit/6f9279373256aba1632e158d83816bd650bc3700)
- Removed PNG_READ_EMPTY_PLTE_SUPPORTED, PNG_WRITE_EMPTY_PLTE_SUPPORTED and PNG_MNG_FEATURES_SUPPORTED checks. [`48b1ae7`](https://github.com/ImageMagick/ImageMagick/commit/48b1ae7b4475f9ad704bfb989fdae9cb18b2ad44)
- Removed MNG_LOOSE checks [`c31bfae`](https://github.com/ImageMagick/ImageMagick/commit/c31bfaed837621ec48ff06589c01c9ff0eb67fc9)
- Corrected colortype check to fix issue reported in #5491. [`069a791`](https://github.com/ImageMagick/ImageMagick/commit/069a79144175a90badd275d9bb03cc1af46f9a11)
- Use white background for bmp3 with alpha to fix issue reported in #5555. [`403b380`](https://github.com/ImageMagick/ImageMagick/commit/403b38041b3cfa6e0d88b6e091acb20570cb8fa5)
- Code cleanup. [`49aec10`](https://github.com/ImageMagick/ImageMagick/commit/49aec10739feafeea42411e1cac6176b50bdddc7)
- invalid arguments to magick tool (https://github.com/ImageMagick/ImageMagick/issues/5946) [`f38b72d`](https://github.com/ImageMagick/ImageMagick/commit/f38b72d1ceec688c2d96798bfc2b6a3da9c01ef6)
- Make sure the mng_info gets freed. [`f3b51a4`](https://github.com/ImageMagick/ImageMagick/commit/f3b51a460325aff40b9e8a1eda86f98fd892e504)
- Removed ZLIB_VERSION from png format info. [`9920062`](https://github.com/ImageMagick/ImageMagick/commit/9920062146883e8c46304577ebdc868d1f74bdfb)
- Add background color to colormap to avoid reading an uninitialized value due to increment of number_opaque (https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=54904). [`213fc94`](https://github.com/ImageMagick/ImageMagick/commit/213fc94bcd89baf8699412b89d6abafb43a10509)
- Read image after checking if we can read it. [`47f4efc`](https://github.com/ImageMagick/ImageMagick/commit/47f4efc96020939e67dde65d90be23cf748eb0e9)
- Disable call to -coalesce inside the webp encoder to avoid duplicate coalescing (#5542). [`1b5f7ca`](https://github.com/ImageMagick/ImageMagick/commit/1b5f7ca2ae918e6476b821ce6815b4b9ac066c7f)
- Disable call to -coalesce inside the video encoder to avoid duplicate coalescing. [`93ce987`](https://github.com/ImageMagick/ImageMagick/commit/93ce987abef8a9ee48822f1ed7738c5a56c0d1c1)
- Whitespace [`ac91453`](https://github.com/ImageMagick/ImageMagick/commit/ac91453fd2ac8852254905f81fd53842484d5a46)
- Added missing check for storage_class. [`7e74424`](https://github.com/ImageMagick/ImageMagick/commit/7e744248049d1c6c317c3b25aaa69ccd50a5f879)
- ignore .Z extention [`64ae960`](https://github.com/ImageMagick/ImageMagick/commit/64ae96073a3ae89c2d2d17a73406fc623e89cb5e)
- read blob byte rather than short [`f3a3f5f`](https://github.com/ImageMagick/ImageMagick/commit/f3a3f5f2fd56b3ee637d8fe4df3cfc863de20112)
- Run make check during build. [`a8156b3`](https://github.com/ImageMagick/ImageMagick/commit/a8156b37e3402027492eb9ce4f209822ff6f9771)
- Corrected check. [`8941b53`](https://github.com/ImageMagick/ImageMagick/commit/8941b539ff8181730576b7d07cefc4dd906360cf)
- Fx's gauss() only requires one parameter (https://github.com/ImageMagick/ImageMagick/discussions/5844) [`8b6f9d9`](https://github.com/ImageMagick/ImageMagick/commit/8b6f9d9eb66f4c7ca235bfe953796767722bbc91)
- restore image file is there is an exception when reading (https://github.com/ImageMagick/ImageMagick/issues/5952) [`8d32e46`](https://github.com/ImageMagick/ImageMagick/commit/8d32e4622431ebe93df7b73d4fa1b14731a642f4)
- Added method that will disable clamping unless the attribute was already set on the image. [`4be351f`](https://github.com/ImageMagick/ImageMagick/commit/4be351f54837ebe294ba823ff1b5be64fb0bd1ed)
- Disable automatic clamping when extending an image. [`8830f9b`](https://github.com/ImageMagick/ImageMagick/commit/8830f9b8cbf427f6bf52711ebf00333617f22f35)
- eliminate rare memory leak [`7145ff1`](https://github.com/ImageMagick/ImageMagick/commit/7145ff1f82fdb5975b24dec72d40553456402ee4)
- Also set image option for -family to make sure this works with the label: format. [`43eca0d`](https://github.com/ImageMagick/ImageMagick/commit/43eca0df1f7a9594902f4a6fe45393b14101b381)
- 1-bit images should be colormapped [`f79e7f6`](https://github.com/ImageMagick/ImageMagick/commit/f79e7f6c8dce64c0be74f4a0581d7da3476ad03e)
- set SetImageOption() for -family option [`fba0b2d`](https://github.com/ImageMagick/ImageMagick/commit/fba0b2d8d63c2ca250fd09b975bad947490aa8ec)
- Removed unused variable. [`71421ee`](https://github.com/ImageMagick/ImageMagick/commit/71421eec19b42c2aef0814e0051fc3829eec127c)
- Write the irot when libheif is version 1.14.0 or higher (#5647). [`3771668`](https://github.com/ImageMagick/ImageMagick/commit/37716685005781c1da69556bafef8f0a8e492791)
- Micro optimization. [`ef87e22`](https://github.com/ImageMagick/ImageMagick/commit/ef87e22bcc3426ad9dbbd49fab480667c25690ae)
- Use xlink:href instead of href as suggested by snibgo in #5968. [`08cce4e`](https://github.com/ImageMagick/ImageMagick/commit/08cce4eda34069d6fd1575d7266743c6e209d8dd)
- missing adjoin flag [`0090a61`](https://github.com/ImageMagick/ImageMagick/commit/0090a611b4b45b1b1ae8c27bf55ae96fb9108cc4)
- We should only discard bytes when the format type is not zero. [`5237397`](https://github.com/ImageMagick/ImageMagick/commit/52373975d15cf68b0c6919418236051f608c611b)
- Skip reserved bytes instead of reading them. [`119429c`](https://github.com/ImageMagick/ImageMagick/commit/119429c95d190848b26d990615c8f90d9bce2b8a)
- Fixed incorrect ping check. [`d6b6188`](https://github.com/ImageMagick/ImageMagick/commit/d6b61880602743cf6ab709d3f7ac2bc2f4f2eafe)
- Added missing call to SyncImage. [`6a4b365`](https://github.com/ImageMagick/ImageMagick/commit/6a4b365e58a7f19883f6d103341bf057d263a916)
- Create next image at start of the loop to avoid empty image at end of the list. [`1593c0b`](https://github.com/ImageMagick/ImageMagick/commit/1593c0b324e7288b53e69cbc074741d7c16c4294)
- improve BMP error checking (https://github.com/ImageMagick/ImageMagick/issues/5980) [`9ab84aa`](https://github.com/ImageMagick/ImageMagick/commit/9ab84aaa5dec73bef9682def5ce94034e65a4b8d)
- Using -define tga:preserve-orientation will be required to preserve the TGA orientation. [`75fbe9a`](https://github.com/ImageMagick/ImageMagick/commit/75fbe9a7135f513765d64cf65ab75e9ff4a977b4)
- cosmetic [`67f32af`](https://github.com/ImageMagick/ImageMagick/commit/67f32affe3a10b81291b220fbaf3bb4398741811)
- Corrected initialization of flip_y. [`c80d1de`](https://github.com/ImageMagick/ImageMagick/commit/c80d1de4dc42604f1f31e2bbc8abc47559443612)
- Removed unnecessary initialization of orientation. [`887ed7c`](https://github.com/ImageMagick/ImageMagick/commit/887ed7c3b0a0274c1e686cd3d49155d730f2ec69)
- eliminate possible integer overflow [`5ef5436`](https://github.com/ImageMagick/ImageMagick/commit/5ef543657dd243831dffdbf4ea11a6414b51fbf7)
- Removed unnecessary check. [`139ea59`](https://github.com/ImageMagick/ImageMagick/commit/139ea59eb4371a81f93684f1d132bd0780f27116)
- eliminate no op assignment variable [`e25868c`](https://github.com/ImageMagick/ImageMagick/commit/e25868c0bdc6501e5654a4985285b31478b7d610)
- support writing WPG images [`d7007d7`](https://github.com/ImageMagick/ImageMagick/commit/d7007d7a12e5b1a1435d9b20cc83357f3e831605)
- Added missing type casts. [`e0f8b3c`](https://github.com/ImageMagick/ImageMagick/commit/e0f8b3c860cfbb4adb4757306e193527b5a3d747)
- Silence another warning. [`ba36bd0`](https://github.com/ImageMagick/ImageMagick/commit/ba36bd0c771edcee4fb41a8166bd2f143a240a78)
- release [`6d8dabd`](https://github.com/ImageMagick/ImageMagick/commit/6d8dabdd2e4ff64f16445c5d4a115210ab7f3cb7)

## [7.1.0-57](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-56...7.1.0-57) - 2022-12-30

### Commits

- beta release [`56814b9`](https://github.com/ImageMagick/ImageMagick/commit/56814b9707389efd9b9b072ca319a8bd662c5fd0)
- Added support for writing animated jxl images. [`555b2cd`](https://github.com/ImageMagick/ImageMagick/commit/555b2cda13b41aaf343a283fa175df46e22c3f65)
- respect the TIFF offset prefix (https://github.com/ImageMagick/ImageMagick/issues/5768) [`df099de`](https://github.com/ImageMagick/ImageMagick/commit/df099dee7e06a50bf3ae12651790aa32f0090e62)
- slight optimization + cosmetic [`648ee44`](https://github.com/ImageMagick/ImageMagick/commit/648ee44cf4cc12641dcb714446e393ca656cd502)
- remove spurious Exif namespace (https://github.com/ImageMagick/ImageMagick/issues/5768) [`7b0e2a9`](https://github.com/ImageMagick/ImageMagick/commit/7b0e2a914ded4b3f7e2fb3649090b541b70b8d8b)
- release [`d68553b`](https://github.com/ImageMagick/ImageMagick/commit/d68553b17abcd3f8afa0cd46aabe0bfab26083fe)
- release [`eadf378`](https://github.com/ImageMagick/ImageMagick/commit/eadf378a6f4e088c32fa5eda62ca6c41d8a84c9c)

## [7.1.0-56](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-55...7.1.0-56) - 2022-12-28

### Commits

- beta release [`12096ae`](https://github.com/ImageMagick/ImageMagick/commit/12096ae0c0b331c4f43d421222e009da496c6100)
- Removed CHANGELOG.md [`42dd9c3`](https://github.com/ImageMagick/ImageMagick/commit/42dd9c32a6003ab89c63e472b801af55aa0d80ec)
- Added discussion template for the help category. [`c030396`](https://github.com/ImageMagick/ImageMagick/commit/c030396a15043b64da69eddd68b99e9af5b4bea0)
- Added missing label. [`c37a32b`](https://github.com/ImageMagick/ImageMagick/commit/c37a32bb84972870fc1161ad7e9ff15312013589)
- Add operating system as input field. [`b2cf040`](https://github.com/ImageMagick/ImageMagick/commit/b2cf040c56f479cfe453d80d30d93c4b3104e2ab)
- Use same template as help for development category. [`b039726`](https://github.com/ImageMagick/ImageMagick/commit/b03972642727c312b6d2536845df48cabeb05c05)
- note those pesky NULL entities [`269e8fd`](https://github.com/ImageMagick/ImageMagick/commit/269e8fdc934a3ae7d4a506ac4d917896bffd219e)
- rework beta badge [`3b7bf5b`](https://github.com/ImageMagick/ImageMagick/commit/3b7bf5b57417d446d6c988682f6f07cf4b55aab4)
- set character encoding to UTF-8 [`c5dfb89`](https://github.com/ImageMagick/ImageMagick/commit/c5dfb892f1ed271d755db5746c72a091a649b034)
- support hue colorspace quantization [`44fd848`](https://github.com/ImageMagick/ImageMagick/commit/44fd848e86448e7b81b3e7bf4ea4356c766f2306)
- check for EOF [`f7a3464`](https://github.com/ImageMagick/ImageMagick/commit/f7a3464ff37cb32b8a1dfad7be7b3058f18fac46)
- convert to sRGB if soruce colorspace is not sRGB compatible | CMYK [`189f9d4`](https://github.com/ImageMagick/ImageMagick/commit/189f9d4ce7e69afd5591372fdd0cf11fbb640835)
- lastest method signatures [`30bfc0f`](https://github.com/ImageMagick/ImageMagick/commit/30bfc0fff7e14f79df96216389a8d54f2c35bcd4)
- inline method [`d859abb`](https://github.com/ImageMagick/ImageMagick/commit/d859abbe4fe20de3c7a931751e43384c06f2993d)
- account for TIFF offset in Exif profile [`21da4fc`](https://github.com/ImageMagick/ImageMagick/commit/21da4fc514acca9687df8a62b90ecf56742d8c98)
- Added supported for reading animated jpeg-xl [`3c45046`](https://github.com/ImageMagick/ImageMagick/commit/3c450467bf4a1b6cabbb0a15d856efa4972efe63)
- Added mime type. [`f540fc2`](https://github.com/ImageMagick/ImageMagick/commit/f540fc2bcfc5564aa5c2dfc16604a353e55522e2)
- Use JXL_DEC_FRAME event instead to create the next image to make sure identify shows all the frames. [`85a39a3`](https://github.com/ImageMagick/ImageMagick/commit/85a39a3a332ebe9d83d8fe5637937f5cd8f33e21)
- Removed whitespace. [`4685da1`](https://github.com/ImageMagick/ImageMagick/commit/4685da16f0674ce92e82c045b654a5a1327e5ee7)
- Initialize without memset. [`807e518`](https://github.com/ImageMagick/ImageMagick/commit/807e5185a8494a2351e17beb3d0bd586ef7e17d0)
- Use image_info instead. [`f374d6d`](https://github.com/ImageMagick/ImageMagick/commit/f374d6df3cb3e831037a43c218f33b73d72e8c47)
- Set frame distance to zero for lossless image. [`82138ea`](https://github.com/ImageMagick/ImageMagick/commit/82138eaa88f03b91732f4b658edba1d67e097b70)
- Initialize without memset. [`d63af13`](https://github.com/ImageMagick/ImageMagick/commit/d63af1388853dcbcc610fc01ad24b699c9b32a40)
- you can never have too many unit tests [`28ee717`](https://github.com/ImageMagick/ImageMagick/commit/28ee7175a43cfcdaddccc5c18e4266c15d26f152)
- release [`a9de416`](https://github.com/ImageMagick/ImageMagick/commit/a9de41600d18144e298a0cdcc98b9870a59058b6)

## [7.1.0-55](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-54...7.1.0-55) - 2022-12-17

### Merged

- fix: small error in docs [`#5882`](https://github.com/ImageMagick/ImageMagick/pull/5882)

### Commits

- beta release [`39fc3f2`](https://github.com/ImageMagick/ImageMagick/commit/39fc3f2ef164b208811dc17d02126d9f89172e06)
- proper Exif profile handling in HEIC (https://github.com/ImageMagick/ImageMagick/issues/5647) [`1c7af54`](https://github.com/ImageMagick/ImageMagick/commit/1c7af5461d4defbcfcac2a8db3e4fb1a81324861)
- keep tiles approximately same size across multiple frames [`e10b7a9`](https://github.com/ImageMagick/ImageMagick/commit/e10b7a9a34b7305ae680722c91f0af0de5ad0676)
- cosmetic [`1447648`](https://github.com/ImageMagick/ImageMagick/commit/144764880ad3692850fc5fe3c08a38b398d31a6e)
- ... [`4d27812`](https://github.com/ImageMagick/ImageMagick/commit/4d278125fd13e5b8348501575201ee109898e003)
- latest documentation updates [`5281cd2`](https://github.com/ImageMagick/ImageMagick/commit/5281cd2fd7d65ace08c4b3c4449c9dc31de04a05)
- lastest CSS updates [`b7b8950`](https://github.com/ImageMagick/ImageMagick/commit/b7b8950e7977be018040861981fb177de1566a77)
- release [`f06bc90`](https://github.com/ImageMagick/ImageMagick/commit/f06bc90b5989b39d36b04c362d3195df1dc92b05)
- release [`6edfae3`](https://github.com/ImageMagick/ImageMagick/commit/6edfae3829240aedef8a3a79b23c2fa1fd4c688f)

## [7.1.0-54](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-53...7.1.0-54) - 2022-12-10

### Merged

- remove todo, cause cHRM+gAMA is never sRGB [`#5851`](https://github.com/ImageMagick/ImageMagick/pull/5851)

### Commits

- beta release [`b21075c`](https://github.com/ImageMagick/ImageMagick/commit/b21075c9177d911f5aa36b20a86dab965987bd2e)
- Only write the gAMA chunk if the sRGB chunk is written too. However, write the gAMA chunk if gamma is not 1.0/2.2 and no sRGB chunk (https://github.com/ImageMagick/ImageMagick/issues/5850) [`b516099`](https://github.com/ImageMagick/ImageMagick/commit/b51609986ae9d40ed0ea68bd8698a90f6d498b1f)
- correct EXIF profile length (https://github.com/ImageMagick/ImageMagick/issues/5768) [`2e2a2e0`](https://github.com/ImageMagick/ImageMagick/commit/2e2a2e0f8103c932ced7d730e0650153d6785f3a)
- correct EXIF profile extraction from JXL images (https://github.com/ImageMagick/ImageMagick/issues/5768) [`cf133fa`](https://github.com/ImageMagick/ImageMagick/commit/cf133fa1249e0404f8c7f91d78d734f3b60e5ae7)
- add additional comments to the coder [`696a5b5`](https://github.com/ImageMagick/ImageMagick/commit/696a5b5bb70afc18a1857f044ecb207335dcc856)
- skip zero-length profiles (https://github.com/ImageMagick/ImageMagick/issues/5856) [`6741cd2`](https://github.com/ImageMagick/ImageMagick/commit/6741cd2c56479981c614370b448a0ecde3ef8fc0)
- check for profile length of zero [`abf01f3`](https://github.com/ImageMagick/ImageMagick/commit/abf01f32c001bc32b450160a29ea51c8613d73ab)
- cosmetic. [`3cc61f7`](https://github.com/ImageMagick/ImageMagick/commit/3cc61f7863239010ae71bb0cbedb7fc85fa36806)
- correct Image::compare documentation (https://github.com/ImageMagick/ImageMagick/discussions/5869) [`dd97eea`](https://github.com/ImageMagick/ImageMagick/commit/dd97eeadb959bf2d6435a2ea0a8cf4f1306f42b9)
- support polling of image processing operation progress (https://github.com/ImageMagick/ImageMagick/discussions/5868) [`e27cd48`](https://github.com/ImageMagick/ImageMagick/commit/e27cd48e1b51f8618f7c6a4be57992b47c411874)
- add checks for null tags when monitoring [`ee2f46b`](https://github.com/ImageMagick/ImageMagick/commit/ee2f46b29088781f21acf6450e0623843348b25a)
- release [`f5cf5ba`](https://github.com/ImageMagick/ImageMagick/commit/f5cf5baadc0ff473322ce86098b4f2bd2ebd3e13)

## [7.1.0-53](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-52...7.1.0-53) - 2022-12-04

### Merged

- another approach to fix #5836 [`#5841`](https://github.com/ImageMagick/ImageMagick/pull/5841)
- Chrome, Mozilla, GIMP do not assume sRGB [`#5824`](https://github.com/ImageMagick/ImageMagick/pull/5824)
- Spelling core [`#5789`](https://github.com/ImageMagick/ImageMagick/pull/5789)
- Spelling misc [`#5787`](https://github.com/ImageMagick/ImageMagick/pull/5787)
- Spelling coders [`#5788`](https://github.com/ImageMagick/ImageMagick/pull/5788)
- Spelling wand [`#5792`](https://github.com/ImageMagick/ImageMagick/pull/5792)
- Spelling plusplus [`#5791`](https://github.com/ImageMagick/ImageMagick/pull/5791)
- Spelling perl [`#5790`](https://github.com/ImageMagick/ImageMagick/pull/5790)
- Fix *arch-dir helpstring in configure.ac [`#5780`](https://github.com/ImageMagick/ImageMagick/pull/5780)

### Fixed

- another approach to fix #5836 (#5841) [`#5836`](https://github.com/ImageMagick/ImageMagick/issues/5836)
- Chrome, Mozilla, GIMP do not assume sRGB (#5824) [`#4375`](https://github.com/ImageMagick/ImageMagick/issues/4375)

### Commits

- beta release [`d615451`](https://github.com/ImageMagick/ImageMagick/commit/d6154516de2d88ce6a175bfc34cc7688b81f5cf7)
- https://github.com/ImageMagick/ImageMagick/discussions/5718 [`e437224`](https://github.com/ImageMagick/ImageMagick/commit/e437224488fc40aa63d2f9ca98865cd5abd097c9)
- set color reduction colorspace to that of the remap image @ https://github.com/ImageMagick/ImageMagick/issues/5731 [`6ea94f2`](https://github.com/ImageMagick/ImageMagick/commit/6ea94f252d4a03e24eb3ef31cdada95667de3aca)
- image profiles are const @ https://github.com/ImageMagick/ImageMagick/discussions/5743 [`238aaf6`](https://github.com/ImageMagick/ImageMagick/commit/238aaf632d3950ccef5a3dedc1aa2dd8e468bbc8)
- libdps delegate library  must be specifically requested @ https://www.amazon.com/gp/css/order-history?ref_=E_423_order [`e8dd496`](https://github.com/ImageMagick/ImageMagick/commit/e8dd496567af3ac59321eb128ff0fad6712d67d8)
- libdps delegate library must be specifically requested @ https://github.com/ImageMagick/ImageMagick/discussions/5742 [`2a17145`](https://github.com/ImageMagick/ImageMagick/commit/2a171451a4309ce7012da0ca542528c2b951177f)
- cosmetic [`e527643`](https://github.com/ImageMagick/ImageMagick/commit/e527643fb23938c64b23cabb8d116e6c9a72e641)
- parameter is double, cast [`26e636d`](https://github.com/ImageMagick/ImageMagick/commit/26e636db5e5ada69cbe80961cc7f720d5e5776ee)
- Install in a different folder and run as a different user. [`54202ca`](https://github.com/ImageMagick/ImageMagick/commit/54202cafe69a6033bb43010a6a349df8b8322dce)
- Removed invalid argument. [`77eccfc`](https://github.com/ImageMagick/ImageMagick/commit/77eccfc0c78e21b1ae16355a1dd10a9a0cb39d6f)
- Fixed build. [`381d6f0`](https://github.com/ImageMagick/ImageMagick/commit/381d6f022d756e7a13df9545405feb5dcb15e994)
- check for NULL [`eda2e46`](https://github.com/ImageMagick/ImageMagick/commit/eda2e460b43418060dbceda6541e03a37d6a09d7)
- avoid an unlikely divide by zero [`e68b300`](https://github.com/ImageMagick/ImageMagick/commit/e68b30089aa2333aad20fc7e1f18a41a026f7595)
- eliminate compiler warnings [`be77b88`](https://github.com/ImageMagick/ImageMagick/commit/be77b88a5032c879625d4742003100c20c3a3c49)
- eliminate compiler warning [`8307a50`](https://github.com/ImageMagick/ImageMagick/commit/8307a506529427c24fe4e21f1cb7d3b1446e927d)
- eliminate compiler warning [`b7340ba`](https://github.com/ImageMagick/ImageMagick/commit/b7340bad393e3f7696a4c2d5b2c7bb00ec88be42)
- eliminate coverity warning [`a5198d4`](https://github.com/ImageMagick/ImageMagick/commit/a5198d4b5ee5bea6be60aabcca01084b0b4fb24b)
- squash coverity warning [`7cb70aa`](https://github.com/ImageMagick/ImageMagick/commit/7cb70aa0bf113fbc8112ecf6f8703fb1d12debbf)
- the Flashpix library now requires you explicitedly enable when configuring [`eca4ce5`](https://github.com/ImageMagick/ImageMagick/commit/eca4ce5a0ed7e21d5d4079fc5fc9d8f205f68213)
- first attempt at supporting 16-bit half floats [`7c68a0e`](https://github.com/ImageMagick/ImageMagick/commit/7c68a0e4d1aaf9306588d0cf6728e3ffff5f8079)
- Fixed build error. [`bf1a4f2`](https://github.com/ImageMagick/ImageMagick/commit/bf1a4f2d128f258f65d4adbdc69ed5a2f304ff25)
- void shift overflow [`716f12c`](https://github.com/ImageMagick/ImageMagick/commit/716f12c7b3da9f3b71e5f919a080cfc5459edc5e)
- Changed version number in file of the portable release (#5749) [`1414950`](https://github.com/ImageMagick/ImageMagick/commit/1414950fe6b77829573521a81d795f98056f2305)
- latest autoconf/automake [`28a3af8`](https://github.com/ImageMagick/ImageMagick/commit/28a3af8a73c9f2ac3aa378ee64074d283a028479)
- latest autoconf updates [`db5acda`](https://github.com/ImageMagick/ImageMagick/commit/db5acda6f52733892d40180ec8b6986bd9b166d3)
- Improved error reporting and added call to JxlDecoderCloseInput instead of reporting an error. [`926ad10`](https://github.com/ImageMagick/ImageMagick/commit/926ad1036a33be831f7d8330f05a641e9544bdcf)
- implement suggestions from a static analyzer [`d4be270`](https://github.com/ImageMagick/ImageMagick/commit/d4be27057b42cdc195d8a7ce268c7c1d0b414ebb)
- compress binary image [`09442a5`](https://github.com/ImageMagick/ImageMagick/commit/09442a54fdc60ae866eebb2c73e1d64c2179735f)
- remove cast [`4ba8144`](https://github.com/ImageMagick/ImageMagick/commit/4ba8144f35fda7b8c7579bfa0f3df97f1d918565)
- update manifest [`0cbb5c7`](https://github.com/ImageMagick/ImageMagick/commit/0cbb5c716343b0491465887f995f6d559e6b454f)
- https://github.com/ImageMagick/ImageMagick/pull/5780 [`a762bd6`](https://github.com/ImageMagick/ImageMagick/commit/a762bd6a1eb2edea8c9cb2762972993fb17563cc)
- https://github.com/ImageMagick/ImageMagick/issues/5783 [`e057607`](https://github.com/ImageMagick/ImageMagick/commit/e057607f1eb75e9059d896b9ff90711293d84015)
- only open X display once when rendering text @ https://github.com/ImageMagick/ImageMagick/discussions/5779 [`f947d8f`](https://github.com/ImageMagick/ImageMagick/commit/f947d8f7f11a93fcda347ba752ea0023ad5c72b3)
- eliminate compiler exception [`4762421`](https://github.com/ImageMagick/ImageMagick/commit/476242146ff9ef836afd47c7f733a5b7850e92e1)
- Added support for reading the exif profile to the jxl coder. [`7c0bb44`](https://github.com/ImageMagick/ImageMagick/commit/7c0bb44f6781de78d2763e4b08acd538bceab2b5)
- Added missing version check. [`ca7c7bb`](https://github.com/ImageMagick/ImageMagick/commit/ca7c7bb78b31fc928a72d1536a682a683b99010b)
- Corrected types. [`0e1b56d`](https://github.com/ImageMagick/ImageMagick/commit/0e1b56de7976a089f6a97fca34c601e3f6d33295)
- use ANSI-style comments [`05152f4`](https://github.com/ImageMagick/ImageMagick/commit/05152f47f8517ac82d52fa4cb8742cfcec7f1d4f)
- eliminate pointer dereference [`a3be60d`](https://github.com/ImageMagick/ImageMagick/commit/a3be60dcfc38bf28d8e67864f58bc2ff958df7b6)
- support addition Si prefixes [`d3acd28`](https://github.com/ImageMagick/ImageMagick/commit/d3acd287202ce014e249db76f6346e6d7bbca5f5)
- cosmetic [`bfab5d9`](https://github.com/ImageMagick/ImageMagick/commit/bfab5d93e59291510a5e2bb1153bb07789d07785)
- cosmetic [`88cec68`](https://github.com/ImageMagick/ImageMagick/commit/88cec68d19d3fff7354335322016b864b19dcae2)
- cosmetic [`e5894b6`](https://github.com/ImageMagick/ImageMagick/commit/e5894b66fb986370eb10e670864b8b73b78df0f2)
- cosmetic [`8daeac9`](https://github.com/ImageMagick/ImageMagick/commit/8daeac9508047b8b59c60da65564c79557ae8834)
- cosmetic [`2abd25e`](https://github.com/ImageMagick/ImageMagick/commit/2abd25e5df8e3662713be939de84e8054d06b9c7)
- initialize target pixel [`3c01336`](https://github.com/ImageMagick/ImageMagick/commit/3c013363807dde2368d0088322d624674cdd8643)
- Use different policy. [`fd8486e`](https://github.com/ImageMagick/ImageMagick/commit/fd8486ef4ea1e54655a24448f404964acd1527a9)
- Disable jpegli in jxl build. [`17ed4f7`](https://github.com/ImageMagick/ImageMagick/commit/17ed4f7ebd7a60ff964a0bd0bfe5fdacd0fe80b6)
- Corrected path. [`e79c316`](https://github.com/ImageMagick/ImageMagick/commit/e79c31619e24c3d8194377cd8f43a21e6cee7d99)
- latest autoconf/automake configuration updates [`cfe298a`](https://github.com/ImageMagick/ImageMagick/commit/cfe298aa728d415884d71f23b2eef7ed9aa218b3)
- write metadata to JXL image format @ https://github.com/ImageMagick/ImageMagick/issues/5768 [`8d8999a`](https://github.com/ImageMagick/ImageMagick/commit/8d8999add0e642bbfc0c9194c4a9d144cd576af2)
- support XMP profile [`a52d78a`](https://github.com/ImageMagick/ImageMagick/commit/a52d78aaa84203c97b62d50fc946f3ec8fb4aaf6)
- leverage SplitStringInfo() to remove TIFF offset [`afc85bc`](https://github.com/ImageMagick/ImageMagick/commit/afc85bc874eca05dd2520c742976b25f1d27e018)
- cosmetic [`de94d35`](https://github.com/ImageMagick/ImageMagick/commit/de94d35d31d9a931efb5bb9f1bbfb04de44f3788)
- cosmetic [`4cd1cd7`](https://github.com/ImageMagick/ImageMagick/commit/4cd1cd7eb9ffb1e509917b6da386466594353b8e)
- set exif profile extent [`47cb468`](https://github.com/ImageMagick/ImageMagick/commit/47cb468294cf08b9a68680c375a02f9925f43bcd)
- l;atest web site updates [`5f88b9d`](https://github.com/ImageMagick/ImageMagick/commit/5f88b9de8c2fc3b42f8dd4c909b9840dfcdd3dcb)
- deprecate SetPixelBackgoundColor() method [`a607704`](https://github.com/ImageMagick/ImageMagick/commit/a607704b1d67843460b91fab2384cf61a4313392)
- remove bogus statement [`1997d2e`](https://github.com/ImageMagick/ImageMagick/commit/1997d2ec498a44545249b17ee0692c83025ea390)
- cosmetic [`f427cc6`](https://github.com/ImageMagick/ImageMagick/commit/f427cc670dd6320407a8cc819bd42c80c35ca7ba)
- Silence warning with VS2017. [`2101000`](https://github.com/ImageMagick/ImageMagick/commit/2101000da8ce5cced7aa290d59d564f7c4537379)
- Chrome, Mozilla, GIMP do not assume sRGB (https://github.com/ImageMagick/ImageMagick/pull/5824) [`66b1485`](https://github.com/ImageMagick/ImageMagick/commit/66b148510236d8064713eaa1bc75affddcb06b81)
- Fixed build. [`5bb3d45`](https://github.com/ImageMagick/ImageMagick/commit/5bb3d456d369baa17bc1df88b1de4972ac42febc)
- add getter/setter for the filter type [`44dc2fb`](https://github.com/ImageMagick/ImageMagick/commit/44dc2fbee85757922c33f183b2c82115f62325e1)
- Simplify checking the format. [`c18375b`](https://github.com/ImageMagick/ImageMagick/commit/c18375b6df8287c9f85bf40c5f5b7e952dbce965)
- Code cleanup [`e2fe11b`](https://github.com/ImageMagick/ImageMagick/commit/e2fe11bed944cfb249f1a0214c4459b07fcedf67)
- Fixed copy paste mistake. [`195fcde`](https://github.com/ImageMagick/ImageMagick/commit/195fcde7485312c8312a2d31e183e207c0cae4f1)
- The chromaticity should be set after changing the colorspace of the image (#5835). [`ff122c7`](https://github.com/ImageMagick/ImageMagick/commit/ff122c7237a9ba9bcc32e5c5b5d3c9f36c1f05a7)
- offset is already incremented @ (https://github.com/ImageMagick/ImageMagick/commit/8d8999add0e642bbfc0c9194c4a9d144cd576af2#r91564352) [`aeb8bf8`](https://github.com/ImageMagick/ImageMagick/commit/aeb8bf8e3e7aecf2599dd82d35c611e6a918e740)
- refactor offset/size calculation [`030f1fa`](https://github.com/ImageMagick/ImageMagick/commit/030f1fa8bedf29886b10753f14e8c3a372910af5)
- label not centered with gravity (https://github.com/ImageMagick/ImageMagick/issues/5834) [`88759f1`](https://github.com/ImageMagick/ImageMagick/commit/88759f150bb23a3effb125e4c79306a7107ffe0a)
- latest documentation [`fe219dc`](https://github.com/ImageMagick/ImageMagick/commit/fe219dc9624ea07c00eb94e6dab95817732bba6f)
- Make sure the offset starts at the correct position. [`b215d85`](https://github.com/ImageMagick/ImageMagick/commit/b215d851689e26ec76fe39039d52750ea3818670)
- check method argument to determine the adjustment [`7c1768b`](https://github.com/ImageMagick/ImageMagick/commit/7c1768b5d395809727990859705d749821b91910)
- properly detect grayscale JXL images (https://github.com/ImageMagick/ImageMagick/issues/5836) [`c327e00`](https://github.com/ImageMagick/ImageMagick/commit/c327e0008b5139a0c9245d8f226405afa70ea23a)
- another approach for detecting RGB vs. GRAY colorspace [`e9885fb`](https://github.com/ImageMagick/ImageMagick/commit/e9885fbfadf74fda1b8562859ff9d489b6b45c66)
- set channel mask to the proper value (https://github.com/ImageMagick/ImageMagick/issues/5843) [`64d2830`](https://github.com/ImageMagick/ImageMagick/commit/64d28301a6ababb48f8c57879b7368ba4f223a09)
- need to check image parameter exists before we get members (thanks Dirk) [`fbc548b`](https://github.com/ImageMagick/ImageMagick/commit/fbc548bb83c1febcf8f3fc049b967fbbb26b0b85)
- cosmetic [`1433170`](https://github.com/ImageMagick/ImageMagick/commit/143317016012652acba938eed6f7554c143750fc)
- cosmetic. [`e2d8cea`](https://github.com/ImageMagick/ImageMagick/commit/e2d8cea80733252ed9cad1b700a31dd29218987d)
- cosmetic [`303cb62`](https://github.com/ImageMagick/ImageMagick/commit/303cb629466374415a828593e0d746ab3b672a7c)
- cosmetic [`814ba99`](https://github.com/ImageMagick/ImageMagick/commit/814ba996de413fe44783089ca9aad3bee2c8a57b)
- release [`61fbe2b`](https://github.com/ImageMagick/ImageMagick/commit/61fbe2b45d9ab729276cb2a77db5f249d8df15fd)
- revert [`25c3265`](https://github.com/ImageMagick/ImageMagick/commit/25c326508ae1fa0a2068785d6dbf0085f83894ac)
- eliminate compiler warning [`6db8b9f`](https://github.com/ImageMagick/ImageMagick/commit/6db8b9fca949514feebc602e24135e567811676f)
- eliminate compiler warning [`02ba8f8`](https://github.com/ImageMagick/ImageMagick/commit/02ba8f87630921f479403acd4068d0bc44a85c32)
- eliminate compiler warnings [`c59f9d7`](https://github.com/ImageMagick/ImageMagick/commit/c59f9d7068c206941d25171461f36085610da260)
- cosmetic [`c91ce21`](https://github.com/ImageMagick/ImageMagick/commit/c91ce2143c6361ec3b6ac124576ff6f641369ae0)
- release [`b0cc8e4`](https://github.com/ImageMagick/ImageMagick/commit/b0cc8e4ae2c8cf48f8e059dd34ecbeff00b11a9d)

## [7.1.0-52](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-51...7.1.0-52) - 2022-11-06

### Merged

- coders: Enable opening https files in mingw [`#5727`](https://github.com/ImageMagick/ImageMagick/pull/5727)
- utilities: Enable support for unicode paths in mingw [`#5713`](https://github.com/ImageMagick/ImageMagick/pull/5713)

### Commits

- beta release [`bf925a7`](https://github.com/ImageMagick/ImageMagick/commit/bf925a7f1dd56b4306fed0a3802477eb83df13f8)
- support optional extension area [`42bae95`](https://github.com/ImageMagick/ImageMagick/commit/42bae95a16abed5251a43e9fe8022a84d838b4cd)
- check extension attribute type to set the alpha channel [`7b771b4`](https://github.com/ImageMagick/ImageMagick/commit/7b771b4368c3a5348816877be6d0f103338fc89a)
- Pass image's type instead of colorspace to IsGrayImageType [`d3539ae`](https://github.com/ImageMagick/ImageMagick/commit/d3539aed98e9eda9c93c4ab480d2bd700ce9334f)
- cosmetic [`839984c`](https://github.com/ImageMagick/ImageMagick/commit/839984c93c81e553104703ea09d0412333df730e)
- eliminate unnecessary file open when globbing (thanks to P Antoine) [`73dd9de`](https://github.com/ImageMagick/ImageMagick/commit/73dd9deace2a19c6e63e4890dc37bda1f703fc5c)
- OCE-2022-70: DoS at Stdin [`09e738e`](https://github.com/ImageMagick/ImageMagick/commit/09e738e84bd78c473771804de821e99f82d99219)
- possible DoS @ stdin (OCE-2022-70); possible arbitrary file leak (OCE-2022-72) [`05673e6`](https://github.com/ImageMagick/ImageMagick/commit/05673e63c919e61ffa1107804d1138c46547a475)
- revert scene check [`2752356`](https://github.com/ImageMagick/ImageMagick/commit/27523561a72a9934a851120693ed0fedb524d30e)
- Use new certificate. [`e9da157`](https://github.com/ImageMagick/ImageMagick/commit/e9da157073da96391f6184e3746889f2c772d730)
- cosmetic [`3aa3062`](https://github.com/ImageMagick/ImageMagick/commit/3aa30627a2b3fc84f9bb53ca9ce9e4f8612c60aa)
- enhanced delete list parsing [`5118724`](https://github.com/ImageMagick/ImageMagick/commit/511872451db40249f6d4126124f3cd837e233754)
- cosmetic [`4ba2bbc`](https://github.com/ImageMagick/ImageMagick/commit/4ba2bbc3447ec38eb5e133517d93c03f6cc35962)
- support `-delete registry:NAME` to delete images from the system registry [`fe5eeb8`](https://github.com/ImageMagick/ImageMagick/commit/fe5eeb8656fb00623e3297b43b6b58ba3715517d)
- support `-delete registry:NAME` to delete images from the system registry [`ba541de`](https://github.com/ImageMagick/ImageMagick/commit/ba541deb8a7f86e411ea64c74df00e9c50758904)
- string optimization [`d78b958`](https://github.com/ImageMagick/ImageMagick/commit/d78b958aa52de33f7ecb3390e2a8f27864627c53)
- allow for EOF [`d0bee0b`](https://github.com/ImageMagick/ImageMagick/commit/d0bee0b3e9bbfbe849f013cd04da497dcfb023c8)
- Use new private api. [`2d0b7fc`](https://github.com/ImageMagick/ImageMagick/commit/2d0b7fcc16daa4bd746dafb4e71c0c69fb94a280)
- Whitespace. [`3193b5e`](https://github.com/ImageMagick/ImageMagick/commit/3193b5e397b70a53760ffa4ea060f241e94e1e24)
- Renamed variable [`fa28e60`](https://github.com/ImageMagick/ImageMagick/commit/fa28e609ae4f7568d14be1f43145aa2983358ade)
- rotate HLS by 120 degrees (private email from John Z) [`5f4ad1d`](https://github.com/ImageMagick/ImageMagick/commit/5f4ad1d97e485800f173e350271b65ebc96af8fa)
- Use the new ElementInfo api. [`ead0c10`](https://github.com/ImageMagick/ImageMagick/commit/ead0c1053b937e2ff8644d6193a960749d93cce5)
- blob byte optimization [`6fac1c9`](https://github.com/ImageMagick/ImageMagick/commit/6fac1c98fa392b635754e7359187155ede91ed88)
- add check for grayscale image @ https://github.com/ImageMagick/ImageMagick/issues/5705 [`e7d354e`](https://github.com/ImageMagick/ImageMagick/commit/e7d354eaad7e38918a60d0ad201493b5a5c6972a)
- optimize reading blob string [`4ff14c8`](https://github.com/ImageMagick/ImageMagick/commit/4ff14c8d62762f4a84626e286782b9ff5b12a6cc)
- proper boundary check [`79cd5a5`](https://github.com/ImageMagick/ImageMagick/commit/79cd5a5421ad551e0a4592bc7b31a79c8796074d)
- register WebP mime type [`c3f81bc`](https://github.com/ImageMagick/ImageMagick/commit/c3f81bc6823c45f75469a29720808f463c9bd7db)
- fix monochrome colormap [`b4193e8`](https://github.com/ImageMagick/ImageMagick/commit/b4193e8e4d85ef0a3c2775527f01a0aa146f2d64)
- Fixed possible null reference. [`ffd7221`](https://github.com/ImageMagick/ImageMagick/commit/ffd7221e800a9784096544cc198bb93e9c0a9d6a)
- Use the ElementInfo api instead. [`7a2b09b`](https://github.com/ImageMagick/ImageMagick/commit/7a2b09b5ceabfeb63c31f966d29010739e9e5114)
- Another fix. [`ad532fa`](https://github.com/ImageMagick/ImageMagick/commit/ad532fa542b1a64389d51b4ca18bf451d6bd4f8a)
- set blob EOF flag [`bc1e75c`](https://github.com/ImageMagick/ImageMagick/commit/bc1e75ccf6f975a1345ff574540545dc46c0e4d5)
- Use the ElementInfo api and fixed return value of SetLogEventMask. [`d80fafe`](https://github.com/ImageMagick/ImageMagick/commit/d80fafec97e3451ea8a6122b9deb2b24bd346d45)
- Earlier unlock of semaphore. [`d4ae038`](https://github.com/ImageMagick/ImageMagick/commit/d4ae038ca89b0f6dd8e18604328a30433ecf42c7)
- Fixed unlock of semaphore. [`9d98dad`](https://github.com/ImageMagick/ImageMagick/commit/9d98dadb26761c8e30f5c46511ca5c6b851baad8)
- latest autoconf update [`5d3d9e2`](https://github.com/ImageMagick/ImageMagick/commit/5d3d9e2489e658db9a60dd67a603dd5a58c0e110)
- Use the ElementInfo api. [`dc5bb28`](https://github.com/ImageMagick/ImageMagick/commit/dc5bb280f0d2e8709cddfe613f9652fe89bddd51)
- Use the ElementInfo api. [`ae600a1`](https://github.com/ImageMagick/ImageMagick/commit/ae600a1b06ee209191793b3b391e553c19053576)
- Code cleanup. [`13ba626`](https://github.com/ImageMagick/ImageMagick/commit/13ba626c30b93721669b4cab8f4b44128c168749)
- Use the ElementInfo api. [`24a4cd0`](https://github.com/ImageMagick/ImageMagick/commit/24a4cd039a90ffd1580f50fe8680707d77dedba3)
- Fixed bug that was introduced when using the ElementInfo api. [`f9d96c7`](https://github.com/ImageMagick/ImageMagick/commit/f9d96c7033e81dcc50b9a881bde0b94059957b59)
- https://github.com/ImageMagick/ImageMagick/pull/5713 [`fb70c5b`](https://github.com/ImageMagick/ImageMagick/commit/fb70c5b55254484b9b2a2e0b5393a9e90b6108f6)
- robust support of masks in MPC and MIFF [`9f0f4b2`](https://github.com/ImageMagick/ImageMagick/commit/9f0f4b23817add28e073b94dbff81035416f71cf)
- https://github.com/ImageMagick/ImageMagick/pull/5713 [`914e376`](https://github.com/ImageMagick/ImageMagick/commit/914e376e2ec2cde8ea1f1e90d556a6267446b732)
- https://github.com/ImageMagick/ImageMagick/issues/5680 [`11df7ff`](https://github.com/ImageMagick/ImageMagick/commit/11df7ff61d9cb73b7eae888f58473d2fca226ce4)
- https://github.com/ImageMagick/ImageMagick/issues/5680 [`43ba8a6`](https://github.com/ImageMagick/ImageMagick/commit/43ba8a6f2079eaf1dff0d1a749b6be3731943175)
- initialize package key [`878da43`](https://github.com/ImageMagick/ImageMagick/commit/878da433b3ea9dae46bbbe8b42d55bb03d1084a4)
- release [`04ee6ce`](https://github.com/ImageMagick/ImageMagick/commit/04ee6cec572251279db13cba52a59eaef12f5652)

## [7.1.0-51](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-50...7.1.0-51) - 2022-10-16

### Commits

- beta release [`fea7eed`](https://github.com/ImageMagick/ImageMagick/commit/fea7eed9c4067e6b9ded49da23790eb54c7d8d2b)
- obtain scene from image structure [`53eb353`](https://github.com/ImageMagick/ImageMagick/commit/53eb353a1a4487c5dcf887e11fc7381f2deb08f0)
- prevent undefined shift [`742374a`](https://github.com/ImageMagick/ImageMagick/commit/742374aed7d086bd310cc8eb3432df55fa86c3c0)
- Added private api to go through a linked list without using semaphores. [`212020f`](https://github.com/ImageMagick/ImageMagick/commit/212020f5e6a7b2bd13d0bbf0e4668f093a8e79af)
- Fixed build. [`e53a959`](https://github.com/ImageMagick/ImageMagick/commit/e53a9593542b07253b2ddc29300e4d2f01365858)
- latest automake configuration [`a88a3b5`](https://github.com/ImageMagick/ImageMagick/commit/a88a3b5b6a81e4d123e31928402c4fce2ccd7476)
- fix undefined-shift in ReadTGAImage @ https://oss-fuzz.com/testcase?key=5129864151957504 [`fcaddfb`](https://github.com/ImageMagick/ImageMagick/commit/fcaddfb00da9271885cc1233d209bae0d8bd3353)
- prevent divide by zero exception [`1cf41df`](https://github.com/ImageMagick/ImageMagick/commit/1cf41df5db4aa83c5620a146cd107d10d2b2cdb5)
- release [`aea87b5`](https://github.com/ImageMagick/ImageMagick/commit/aea87b538fdb0e464ac3bbc7941127119baac5dd)

## [7.1.0-50](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-49...7.1.0-50) - 2022-10-08

### Merged

- Fix DDS file DDPF_LUMINANCE type of data [`#5452`](https://github.com/ImageMagick/ImageMagick/pull/5452)

### Commits

- beta release [`9f4d7d5`](https://github.com/ImageMagick/ImageMagick/commit/9f4d7d51e1cc2c8be8672703da3e860ff57bc86d)
- Removed default quality of 50. [`d0b8d6e`](https://github.com/ImageMagick/ImageMagick/commit/d0b8d6e92e82cd9b4d8dac3d0de63717fbc0c561)
- Use the new api of jpeg-xl 0.7.0. [`1246eab`](https://github.com/ImageMagick/ImageMagick/commit/1246eab3cea5e69a5f659c8aa4a4451f10b5c9e0)
- Set the minimum jpeg-xl version to 0.7.0 [`67e6c68`](https://github.com/ImageMagick/ImageMagick/commit/67e6c683380270e5f49c7da4f243bd38843b364a)
- Corrected setting the properties that should be set when the image has an alpha channels. [`401f580`](https://github.com/ImageMagick/ImageMagick/commit/401f58079c96dd4d8f62ac8b73224a8dee278de0)
- Adjust num_color_channels when the image is grayscale. [`1a2117e`](https://github.com/ImageMagick/ImageMagick/commit/1a2117e46a2787e79bc3a64a857564915f1b0258)
- Use ReadStrip method when bit depth is higher than 8 (#5597) [`f95bf0b`](https://github.com/ImageMagick/ImageMagick/commit/f95bf0b432fd252fb587badcc776eafbfaccd722)
- Added support for reading the resolution of an xcf file (#5549). [`7f0348c`](https://github.com/ImageMagick/ImageMagick/commit/7f0348ca8d1e774d65dda49661b280ffcbeb4dfb)
- Minor style change. [`c50602c`](https://github.com/ImageMagick/ImageMagick/commit/c50602cc46b62b8342b8802b980714793f1730e0)
- Correct distance calculation. [`c3f5009`](https://github.com/ImageMagick/ImageMagick/commit/c3f5009299a9047c5e8c4d4f39bc617ae768ad9c)
- Perform ChannelGeometry checks earlier. [`7eb960d`](https://github.com/ImageMagick/ImageMagick/commit/7eb960d23c937890d6ed53b2567c8efaef2ae86b)
- Corrected version format to be compatible with Ghostscript 10.00.0 (#5618) [`d5349ca`](https://github.com/ImageMagick/ImageMagick/commit/d5349ca2ff3772b4d3b994e1450c1c57b7f1232e)
- Correct quotes around the password, the old way no longer works with version 10.00.0 of Ghostscript. [`82bbf4c`](https://github.com/ImageMagick/ImageMagick/commit/82bbf4c49a2ffec5980981b867ab93bbe033d9c7)
- Read and use the offset instead of skipping it (#5604). [`bb4018a`](https://github.com/ImageMagick/ImageMagick/commit/bb4018a4dc61147b37d3c42d85e5893ca5e2a279)
- Corrected bounds calculation ($5623). [`5118534`](https://github.com/ImageMagick/ImageMagick/commit/5118534487b0060fc35d573aff9bf69b33dc1e16)
- fix incorrect handling of SQ groups in header @ https://github.com/ImageMagick/ImageMagick/issues/5606 [`0bc1022`](https://github.com/ImageMagick/ImageMagick/commit/0bc102241840ff8eacd000c3436f6fe71085a9bd)
- support 1-bit pixels [`740ac65`](https://github.com/ImageMagick/ImageMagick/commit/740ac6550558dc454d003cf3883580cf7994de84)
- release [`f032690`](https://github.com/ImageMagick/ImageMagick/commit/f032690e5ed2b15873516220fb8dcdda82924988)

## [7.1.0-49](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-48...7.1.0-49) - 2022-09-24

### Merged

- Fixed magnify confusing colorspaces other than linear-RGB. [`#5569`](https://github.com/ImageMagick/ImageMagick/pull/5569)
- Fix timespec assignment on AIX [`#5565`](https://github.com/ImageMagick/ImageMagick/pull/5565)

### Commits

- beta release [`01d9f84`](https://github.com/ImageMagick/ImageMagick/commit/01d9f843dab9e3116bc34598f736ff0d832ec862)
- eliminate compiler warning [`199cd42`](https://github.com/ImageMagick/ImageMagick/commit/199cd42215a6cb98f67cfd39fa5b8d0f3a8fd1be)
- check exception signature [`43913c8`](https://github.com/ImageMagick/ImageMagick/commit/43913c8f62a196787eaeaccfb48de19e47b49186)
- improved JP2 header checking [`a83914e`](https://github.com/ImageMagick/ImageMagick/commit/a83914e22cdb73cf5489183bdfd4049e1ae583a2)
- assign appropriate timespec members individually rather than collectively [`2afa60c`](https://github.com/ImageMagick/ImageMagick/commit/2afa60c9c1d74743a2481cfe28d0aa220e5600d8)
- prevent integer overflow @ oss-fuzz [`6524996`](https://github.com/ImageMagick/ImageMagick/commit/6524996a008b72f5a51efbf78aa0ea1f892ff2a1)
- eliminate use of unitialized variable [`dacfc37`](https://github.com/ImageMagick/ImageMagick/commit/dacfc37aed2c878ef47cf73f85611d76f1959a81)
- Changes build options for libheif. [`071e83b`](https://github.com/ImageMagick/ImageMagick/commit/071e83be4c1d12ab1633fbe587e910e719ab867a)
- Fixed writing duplicate profiles that was reported in #5537. [`8af10ce`](https://github.com/ImageMagick/ImageMagick/commit/8af10ce75526e82b500b1a6cfc827c3b56d67b49)
- earlier check for maximum channels [`9a630bd`](https://github.com/ImageMagick/ImageMagick/commit/9a630bdc9f9f6e5ecd9776e9ef42184dbcf0f786)
- cast unsigned char to int before 8-bit shift [`2cac30d`](https://github.com/ImageMagick/ImageMagick/commit/2cac30d690adb3cb105473462bc8d2c7e4e8fb69)
- Added missing typecast. [`bcac20d`](https://github.com/ImageMagick/ImageMagick/commit/bcac20d0c6a6cd7e95f678c7d50002329ea1ef9d)
- exit on EOF @ https://github.com/ImageMagick/ImageMagick6/issues/197 [`f1337d8`](https://github.com/ImageMagick/ImageMagick/commit/f1337d85b058da0a168a5a6bb7ba65fd5e1e4711)
- forgot to reset the pointer when updating the wand view [`a909485`](https://github.com/ImageMagick/ImageMagick/commit/a909485d86cb32f26fe261009523ee26c378508d)
- clone the image when calling NewWandView() [`4e7883c`](https://github.com/ImageMagick/ImageMagick/commit/4e7883c352972cf3b06418d24b5d89f199b199aa)
- don't clone image [`cf50a01`](https://github.com/ImageMagick/ImageMagick/commit/cf50a01d457fa9943d49e167c38f6461795e59b9)
- some efficiency by using virtual rather than authentic pixels [`1631289`](https://github.com/ImageMagick/ImageMagick/commit/163128974322fb9a933bc53925bc69972009769f)
- revert [`48a4cce`](https://github.com/ImageMagick/ImageMagick/commit/48a4cce8d5193d6bf9e54135bba5085aa57ecb79)
- cosmetic [`c3746a5`](https://github.com/ImageMagick/ImageMagick/commit/c3746a509be1f6b470769ad7d0d1eaba71b00fbe)
- release [`7a3f3f1`](https://github.com/ImageMagick/ImageMagick/commit/7a3f3f1bdbcc95a212a45484fab76225d84e289c)

## [7.1.0-48](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-47...7.1.0-48) - 2022-09-11

### Merged

- png.c: Remove the extra space character in "%8lu " [`#5513`](https://github.com/ImageMagick/ImageMagick/pull/5513)

### Commits

- Corrected setting the flags. [`15861e0`](https://github.com/ImageMagick/ImageMagick/commit/15861e07b34c3195991f4aca7f05f8e861691e9c)
- Adding new jpeg-xl libraries. [`2addb6a`](https://github.com/ImageMagick/ImageMagick/commit/2addb6a1e1c12924a35a96bec32813e5561f0300)
- Disable shared build for jpeg-xl in oss-fuzz build. [`2d7655b`](https://github.com/ImageMagick/ImageMagick/commit/2d7655b8e92ea254c58053403e4fc37f466f6fba)
- beta release [`6e21089`](https://github.com/ImageMagick/ImageMagick/commit/6e21089cbd7be66b15e7963408035fa122ab488a)
- Also clone libjxl. [`69012fa`](https://github.com/ImageMagick/ImageMagick/commit/69012fa495e6c415be511ce537fb0b79c1ff715b)
- heap-buffer-overflow for crafted TIFF image; alert from Hardik [`1f82e81`](https://github.com/ImageMagick/ImageMagick/commit/1f82e81bead325f02f5d71d217452f97b864d3d3)
- Moved getting the distance to a separate method. [`d31664a`](https://github.com/ImageMagick/ImageMagick/commit/d31664a7b5ec3b1aa8f96ff90d27c639d5c20024)
- incorrect bounds checking for draw affine @ https://github.com/ImageMagick/ImageMagick/issues/5497 [`c8b0c9d`](https://github.com/ImageMagick/ImageMagick/commit/c8b0c9d6b95668994b192aba42b8cf8386b9e0a0)
- Also add cc to the editorconfig settings. [`1818a8f`](https://github.com/ImageMagick/ImageMagick/commit/1818a8f83f5ea614ee9a5cbb4e74cfae91424ff2)
- Code style changes. [`df86708`](https://github.com/ImageMagick/ImageMagick/commit/df867085416b85b468841911b398065ea91de5af)
- Change size checks. [`d071d51`](https://github.com/ImageMagick/ImageMagick/commit/d071d518e1038f9b4c35c98dc554150344720cc0)
- No longer make the ping fuzzer format specific. [`3195a4c`](https://github.com/ImageMagick/ImageMagick/commit/3195a4ca58bba46e08e774ae47518dc6b29366a6)
- Corrected check. [`9a22a14`](https://github.com/ImageMagick/ImageMagick/commit/9a22a14d114f3d820ecaff029b8c9f77caa8ced5)
- fix memory issues for the unit tests [`81a8bc4`](https://github.com/ImageMagick/ImageMagick/commit/81a8bc4abcc3f1b161845456aea901087a81186c)
- check to ensure image # is &gt;= 0 [`cb4ccbc`](https://github.com/ImageMagick/ImageMagick/commit/cb4ccbc40c84495301279e0e78ffed94b0b5ac23)
- correct PSNR distortion @ https://github.com/ImageMagick/ImageMagick/issues/5504 [`2d88ff2`](https://github.com/ImageMagick/ImageMagick/commit/2d88ff2eb2d9afbd42f6190bf4084b5ce799f454)
- fix PSNR to return the correct location for similarity search @ https://github.com/ImageMagick/ImageMagick/issues/5504# Please enter the commit message for your changes. Lines starting [`9094277`](https://github.com/ImageMagick/ImageMagick/commit/90942775a5b8716c7d4f0a58af97304493538bec)
- properly handle a PSNR of 0 (undefined) [`dfbf39d`](https://github.com/ImageMagick/ImageMagick/commit/dfbf39d83af7cf6709b5910b8a9c76db163f19ea)
- Set raw_info-&gt;params.user_flip to 0 to prevent auto-orientation of the image (thanks totoestcontent) (#5326). [`5a543ba`](https://github.com/ImageMagick/ImageMagick/commit/5a543bad4954be35c99828d1a1f20bff1d3614e5)
- return normalized PSNR distortion [`751829c`](https://github.com/ImageMagick/ImageMagick/commit/751829cd4c911d7a42953a47c1f73068d9e7da2f)
- log10(0) is -inf [`56aa72d`](https://github.com/ImageMagick/ImageMagick/commit/56aa72d0166d19fbac1cd337d7bab98b94988d1a)
- log10(0) is -inf [`4538e0b`](https://github.com/ImageMagick/ImageMagick/commit/4538e0b7776592090474022c52e73387a9af0182)
- enable the -auto-level option @ https://github.com/ImageMagick/ImageMagick/issues/5524 [`5c6d1cd`](https://github.com/ImageMagick/ImageMagick/commit/5c6d1cd07129084d597aa6de6fd3752cfdbcbecc)
- Added missing inline. [`46a918e`](https://github.com/ImageMagick/ImageMagick/commit/46a918e0b11d1213f6ab06e9b98a640133b0092e)
- Removed define that was only used once. [`3d876c8`](https://github.com/ImageMagick/ImageMagick/commit/3d876c8cb817dab680d6595899cc89304317d0c7)
- validate class name [`debcebf`](https://github.com/ImageMagick/ImageMagick/commit/debcebf3501cedb6cc5928727e62d3520d681928)
- validate stroke width [`71a79c3`](https://github.com/ImageMagick/ImageMagick/commit/71a79c3f0ad728cd32092997db9f2a848334295b)
- render empty labels @ https://github.com/ImageMagick/ImageMagick/issues/5530 [`2397a41`](https://github.com/ImageMagick/ImageMagick/commit/2397a41ca3945e67d656d689e4982002c017652f)
- support -family option @ https://github.com/ImageMagick/ImageMagick/issues/5531 [`b5ae039`](https://github.com/ImageMagick/ImageMagick/commit/b5ae039da8bff594d9d736e50b4973ab2e0e07f3)
- recognize CSS-style family font list @ https://github.com/ImageMagick/ImageMagick/issues/5531 [`2d44f06`](https://github.com/ImageMagick/ImageMagick/commit/2d44f06a6790dbcefb96e0a7a5becb2cbe15faad)
- throw exception for empty label @ https://github.com/ImageMagick/ImageMagick/issues/5530 [`0d501b6`](https://github.com/ImageMagick/ImageMagick/commit/0d501b66a677e5fd440529edc92fd2d60bf1fa60)
- move alpha from meta channels @ https://github.com/ImageMagick/ImageMagick/issues/5521 (patch from Dirk) [`77561be`](https://github.com/ImageMagick/ImageMagick/commit/77561be40bb1cd102b73fdf71323b4ec8a733793)
- Tiny optimization. [`66f41de`](https://github.com/ImageMagick/ImageMagick/commit/66f41deff9174ffca5129f7964f92a3e6c82d2cd)
- Removed duplicate check. [`54f3998`](https://github.com/ImageMagick/ImageMagick/commit/54f39980165651e1df00a897acfc225760af48d2)
- Reverted incorrect patch. [`d57f539`](https://github.com/ImageMagick/ImageMagick/commit/d57f539f7ec5274f5cf3e01fac31ba72a49dc8c6)
- create a single instance of MagickLog10() method in private header [`d6061d9`](https://github.com/ImageMagick/ImageMagick/commit/d6061d9bbc646bf7f7ef467b0d375cb44064a890)
- Run autoreconf -fiv before running configure. [`cc1a92b`](https://github.com/ImageMagick/ImageMagick/commit/cc1a92b6c861c1f27d11468a5532db365675f989)
- Install extra packages. [`dd0b3fb`](https://github.com/ImageMagick/ImageMagick/commit/dd0b3fbaefd98f93a1c6b7981cc7d2f386701774)
- Try to fix the clang build. [`b361e96`](https://github.com/ImageMagick/ImageMagick/commit/b361e9650e07d0326c8510ff4e4618dcfbcd3c07)
- Another attempt to fix the clang build. [`0a535ff`](https://github.com/ImageMagick/ImageMagick/commit/0a535ff4c21dee12e67b83d98e843aa1f4aed70a)
- Revert changes. [`5a84c82`](https://github.com/ImageMagick/ImageMagick/commit/5a84c828159133dd44dee1531cd725d9a8c715e4)
- Silenced warnings. [`2ad0471`](https://github.com/ImageMagick/ImageMagick/commit/2ad04718fd02d35af723fd384993c6a7d0f44144)
- Also install git. [`94fdfc9`](https://github.com/ImageMagick/ImageMagick/commit/94fdfc9d9822782c4a9aab1470948637f722adb1)
- Also set CXX. [`de8c6d6`](https://github.com/ImageMagick/ImageMagick/commit/de8c6d69e8490f6e6295957042f44b7598a9e3ba)
- Also set CXX for app-image build. [`4d7f1a7`](https://github.com/ImageMagick/ImageMagick/commit/4d7f1a7e8b23b4d33f5534ab9064219202873f54)
- Use env instead. [`3a66612`](https://github.com/ImageMagick/ImageMagick/commit/3a666127f8b132187a7c66a7f4a470e433a1f1e9)
- Corrected variable. [`87ed754`](https://github.com/ImageMagick/ImageMagick/commit/87ed7542141d407a4d00cf089de4303d5541e40a)
- Corrected clone for the freetype project. [`2823eb9`](https://github.com/ImageMagick/ImageMagick/commit/2823eb9b06e6bb5961d65b8e8d21c1dc000bbb62)
- Corrected folder. [`6f5dd74`](https://github.com/ImageMagick/ImageMagick/commit/6f5dd7419a840553b2ab287d7880292f8b9298dc)
- Use GitHub mirror instead. [`8ba9e67`](https://github.com/ImageMagick/ImageMagick/commit/8ba9e67d34fb860fc4e02d752885bbe8a8e17070)
- Fix HEIF header include path for MINGW [`fa72362`](https://github.com/ImageMagick/ImageMagick/commit/fa72362104cb9b4924808d5cb77386f9b4e73d5d)
- fix short reallocation @ https://github.com/ImageMagick/ImageMagick/issues/5553 [`fdab524`](https://github.com/ImageMagick/ImageMagick/commit/fdab52405409fee5d7c02fe4e60d5474caa54498)
- proper overflow check [`ca72d98`](https://github.com/ImageMagick/ImageMagick/commit/ca72d98bf1bc3ba6b87e73c4e5627994ab6c8240)
- don't transform to sRGB colorspace if already in a compatible colorspace @ https://github.com/ImageMagick/ImageMagick/discussions/5543 [`c1ca247`](https://github.com/ImageMagick/ImageMagick/commit/c1ca2476540dd2f55ac108a190a75ff83a207a9c)
- release [`c243c92`](https://github.com/ImageMagick/ImageMagick/commit/c243c92818c376315650f6d8340e7e62e9a14a9e)

## [7.1.0-47](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-46...7.1.0-47) - 2022-08-27

### Merged

- The effect of modulate:colorspace LCH is different for palette and true color images. [`#5470`](https://github.com/ImageMagick/ImageMagick/pull/5470)

### Commits

- beta release [`d1be0fd`](https://github.com/ImageMagick/ImageMagick/commit/d1be0fd485f786041401d25a0f554cbd680e653e)
- correct normalization for the complex magnitude-phase option [`d4904e5`](https://github.com/ImageMagick/ImageMagick/commit/d4904e56f4fbda286cfca3661b9a1d4bf93c8279)
- Check for quantum pad overflow (issue notification from hardik) [`2305c70`](https://github.com/ImageMagick/ImageMagick/commit/2305c702ea8d2d911f1be2e7690103e2f3cc8a2e)
- more conservative pad check [`f2398de`](https://github.com/ImageMagick/ImageMagick/commit/f2398de5b897203c36eade3b6cbc754fd57d003a)
- Run autogen with --no-po4a. [`2b3ffd9`](https://github.com/ImageMagick/ImageMagick/commit/2b3ffd976bd8c6845bcf279a99708fa013734a7f)
- Added missing LDFLAGS for the oss-fuzz build. [`afee576`](https://github.com/ImageMagick/ImageMagick/commit/afee576934f3e4865d131f4691d77b743c7cb5e9)
- Also use clang in our codespace. [`825d09e`](https://github.com/ImageMagick/ImageMagick/commit/825d09edb97affa63aafcb24b0b512392389ce7f)
- eliminate undefined behavior, fuzz issue from Hardik [`2dc49e8`](https://github.com/ImageMagick/ImageMagick/commit/2dc49e8b98051d1ed1eb52f84c93941e2f3f9bc8)
- check for extra samples when computing pad, alert from Hardik [`e389397`](https://github.com/ImageMagick/ImageMagick/commit/e389397b2be1a1b586923f279b1f2c36b28b1eb0)
- eliminate pointer overflow, alert from Hardik [`264d91e`](https://github.com/ImageMagick/ImageMagick/commit/264d91e02a2e9c6ec318d751956000d19d5617fc)
- Updated gitignore. [`ed0ebb9`](https://github.com/ImageMagick/ImageMagick/commit/ed0ebb953ad962712e5687b16479924bfdbd6611)
- raw image property unit error @ https://github.com/ImageMagick/ImageMagick/issues/5492 [`6391584`](https://github.com/ImageMagick/ImageMagick/commit/6391584f62fa767a4666d3b8678eca4d957ba7e8)
- Also link libsharpyuv. [`41c6b78`](https://github.com/ImageMagick/ImageMagick/commit/41c6b783621b4c58050b73f9039092a9259d9ada)
- Also link ubsan. [`60ef02c`](https://github.com/ImageMagick/ImageMagick/commit/60ef02c735e16eb08d8b6fa491b657d011356c79)
- Added json to the .editorconfig. [`5c0e94d`](https://github.com/ImageMagick/ImageMagick/commit/5c0e94d485e7f6eaffc39ed7b6420d318e52d7c1)
- Try to disable recommendations. [`793c633`](https://github.com/ImageMagick/ImageMagick/commit/793c6330643dc07d9582d56622658df2d1590c48)
- Force CXX compiler. [`07f3b48`](https://github.com/ImageMagick/ImageMagick/commit/07f3b487f9860fd4eb9422f1a906d0fe83b6fd1c)
- Removed LDFLAGS. [`695b0f5`](https://github.com/ImageMagick/ImageMagick/commit/695b0f58f73304b144dc66bdb2f9a2785ff7cac1)
- squash heap-buffer-overflow, PoC TIFF from Hardik [`30ccf9a`](https://github.com/ImageMagick/ImageMagick/commit/30ccf9a0da1f47161b5935a95be854fe84e6c2a2)
- cosmetic [`d91623c`](https://github.com/ImageMagick/ImageMagick/commit/d91623c1234ae3b4da3f680b05d404af68bcbbf6)
- Also build jpeg-xl with oss-fuzz. [`7dcef54`](https://github.com/ImageMagick/ImageMagick/commit/7dcef546b9463d021e46d8eb16d3a611df1b6ddb)
- release [`47c6f10`](https://github.com/ImageMagick/ImageMagick/commit/47c6f10607fd1b1e6e9226cd9869479902b65821)

## [7.1.0-46](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-45...7.1.0-46) - 2022-08-17

### Commits

- beta release [`5ab412c`](https://github.com/ImageMagick/ImageMagick/commit/5ab412cf47dea2f09f08d2e7e84d1892b711bac8)
- Silenced warning. [`34d98f3`](https://github.com/ImageMagick/ImageMagick/commit/34d98f3e05e8837e8170a488c6d356c511d6fda8)
- cosmetic [`4af7a41`](https://github.com/ImageMagick/ImageMagick/commit/4af7a416cce767020b7feaa31dab8333c501c7f4)
- need uintptr_t for pointer arithmetic @ https://github.com/ImageMagick/ImageMagick/discussions/5380 [`82a8036`](https://github.com/ImageMagick/ImageMagick/commit/82a80362bd2ad1681a9123572c14da8ad958b554)
- eliminate compiler warning [`c7aef5e`](https://github.com/ImageMagick/ImageMagick/commit/c7aef5e5f7f63c7c71047fcafdd202caa026e5e5)
- NCC must return a value less or equal to 1 @ https://github.com/dlemstra/Magick.NET/issues/1220 [`5702794`](https://github.com/ImageMagick/ImageMagick/commit/57027947ebcc94305b299070dca75d60c75b1b55)
- move exit on timeout from MagickCore to convert utility @ https://github.com/dlemstra/Magick.NET/issues/445 [`27b0efa`](https://github.com/ImageMagick/ImageMagick/commit/27b0efa5d26143bdbbc5ac1e24932a1ad3d73501)
- properly render strokes when stroke-opacity set @ https://github.com/ImageMagick/ImageMagick/issues/5422 [`74c381a`](https://github.com/ImageMagick/ImageMagick/commit/74c381a48cb9312f9d263274b61980f8dde5a497)
- we don't currently support read masks for FFT NCC similarity, but we will soon [`a733f5f`](https://github.com/ImageMagick/ImageMagick/commit/a733f5f7e21fa358854dff87199e38f55993b5df)
- validate pixel channel before we interpolate @ https://github.com/ImageMagick/ImageMagick/discussions/4533 [`c8233a0`](https://github.com/ImageMagick/ImageMagick/commit/c8233a0d608ad893c0ba66e540b87168ea88ec0c)
- Use RelinquishMagickMemory instead. [`1efe08d`](https://github.com/ImageMagick/ImageMagick/commit/1efe08d5eab94b2353916a9e4bb82794bf62e84f)
- Renamed variables. [`7191788`](https://github.com/ImageMagick/ImageMagick/commit/71917888ebc8f725c94fb965eff816b5c1dff588)
- Code style changes. [`edf5871`](https://github.com/ImageMagick/ImageMagick/commit/edf587156bf7af0a6127fea3effab61c74df97b4)
- Use create_wchar_path instead. [`09c027d`](https://github.com/ImageMagick/ImageMagick/commit/09c027dcf7bfe1d86addcf395d9fc2156d78da77)
- Corrected patch. [`c26fe1b`](https://github.com/ImageMagick/ImageMagick/commit/c26fe1bca6a9ced10d1504951071e19c7aa256aa)
- Corrected check. [`797e6cc`](https://github.com/ImageMagick/ImageMagick/commit/797e6cc606fb3112fb2648d37fbb125e68bedd76)
- Use create_wchar_path instead. [`880e9fe`](https://github.com/ImageMagick/ImageMagick/commit/880e9fedc4027247fc393492542485bd72ede3f6)
- Revert back to old check. [`2beb319`](https://github.com/ImageMagick/ImageMagick/commit/2beb319d7742eba3da6dfe10be98453d60886e54)
- check image channel bounds @ https://github.com/ImageMagick/ImageMagick/discussions/4533 [`e0aa08b`](https://github.com/ImageMagick/ImageMagick/commit/e0aa08bfe91fb1c2e9afcd9ce0de1f5c85fc4589)
- cosmetic [`3bb41bf`](https://github.com/ImageMagick/ImageMagick/commit/3bb41bf3e9ac10dfdfdedebbae66e88090a60414)
- throw an exception is channel is invalid [`909d6d2`](https://github.com/ImageMagick/ImageMagick/commit/909d6d21a03aa8d8790df1e204e9f5c3dbca51fb)
- cosmetic [`2256431`](https://github.com/ImageMagick/ImageMagick/commit/2256431d1ecc8606b2a2f6c8581abc6a9aafb57a)
- missing break;  fx translator should not allow expressions like u.w.intensity @ https://github.com/ImageMagick/ImageMagick/discussions/4533 [`25c8915`](https://github.com/ImageMagick/ImageMagick/commit/25c89150f62506e5c4ddba1c10a9722d746bca0c)
- a zero length line segment is not a point [`63f3303`](https://github.com/ImageMagick/ImageMagick/commit/63f3303210e8346f8242389f2d98c68e1e049a4a)
- Moved building the dependencies to a separate file. [`a9ef5f1`](https://github.com/ImageMagick/ImageMagick/commit/a9ef5f151bd76a9bdce27dfcc3be339872fd8306)
- Moved building imagemagick to a separate file. [`98a3569`](https://github.com/ImageMagick/ImageMagick/commit/98a35690576eb50d44c0f4a3790d7bb4717addd7)
- Echo flags. [`19de685`](https://github.com/ImageMagick/ImageMagick/commit/19de6852b53e07c3523d95a0159f4b61bf1b1227)
- Also echo $CXXFLAGS [`def0dbe`](https://github.com/ImageMagick/ImageMagick/commit/def0dbed3ee410985c37a83889ee74ab5e741aa1)
- Build with utilities. [`88e7ac1`](https://github.com/ImageMagick/ImageMagick/commit/88e7ac1f0ac50420428caaea7f09bcd958d12c0b)
- Disable shared when building libtiff. [`feca588`](https://github.com/ImageMagick/ImageMagick/commit/feca588ddf8481e879410aa2d5cfd73ad193be87)
- Reverted change. [`b5a0322`](https://github.com/ImageMagick/ImageMagick/commit/b5a03226550b1d4cebfc3f829f8b0c67ec412dba)
- Silence warning for non debug build. [`5d2d413`](https://github.com/ImageMagick/ImageMagick/commit/5d2d4139d093f1d2deeefc8b6649842d77e4184e)
- Stop setting obsolete argument [`cfce900`](https://github.com/ImageMagick/ImageMagick/commit/cfce90040c060269b89d5b16cd168e69d8f5d9f2)
- fix morphology thicken @ https://github.com/ImageMagick/ImageMagick/issues/5433 [`20c3a7e`](https://github.com/ImageMagick/ImageMagick/commit/20c3a7e6110517ea190ad4a89cfb555c2315945d)
- cosmetic [`60d1c0c`](https://github.com/ImageMagick/ImageMagick/commit/60d1c0ce3e5d180d702207eea416d7fed2f20fe8)
- hit and miss morphology now returns expected results [`eac2e28`](https://github.com/ImageMagick/ImageMagick/commit/eac2e284f5058e4dcd17e3665b7656a91ae2a648)
- sync results to morphology docs @ https://imagemagick.org/Usage/morphology/ [`6d428ef`](https://github.com/ImageMagick/ImageMagick/commit/6d428efb9cc6f4fa3f55643bc56be944186239bd)
- synchronize morphology results with docs @ https://imagemagick.org/Usage/morphology [`57afcf0`](https://github.com/ImageMagick/ImageMagick/commit/57afcf001c242b78dd52b8fa21e05ecd0ce81611)
- Disable shared build for libtiff. [`a1f6dfa`](https://github.com/ImageMagick/ImageMagick/commit/a1f6dfaecc6d4d3be0b146c4ec762ad5ae6e75ce)
- Removed echo. [`455ee30`](https://github.com/ImageMagick/ImageMagick/commit/455ee30a1912774be57932e796089f37df94e0aa)
- Don't allocate memory for scale and copyright that are unused. [`aa492c6`](https://github.com/ImageMagick/ImageMagick/commit/aa492c67ec1c6976ae0720718566333ec0415712)
- support word-break option for caption @ https://github.com/ImageMagick/ImageMagick/discussions/5440 [`6cf5918`](https://github.com/ImageMagick/ImageMagick/commit/6cf5918b82219d9832a19d8f0e823f8b948ec5d7)
- increment max arguments [`3b635dc`](https://github.com/ImageMagick/ImageMagick/commit/3b635dc645e2d15ef3206ac92206ead5e57759ef)
- cosmetic [`57d95a4`](https://github.com/ImageMagick/ImageMagick/commit/57d95a4f36cdf86e04c70af52aafb0d8638cc998)
- Added early exit for list length resource limit. [`31048df`](https://github.com/ImageMagick/ImageMagick/commit/31048df7f3cad9d84b31b19410de0048ad4151eb)
- Make files executable. [`20dc982`](https://github.com/ImageMagick/ImageMagick/commit/20dc982c298a4ad256f76676351284fba7b9bce7)
- Added a Codespaces devcontainer that use a similar configuration as our oss-fuzz container. [`6a80e3f`](https://github.com/ImageMagick/ImageMagick/commit/6a80e3f59cae4f30fa5a08f4f7ddd8c93e50a2d0)
- Mark version as beta again. [`b5a271e`](https://github.com/ImageMagick/ImageMagick/commit/b5a271e223dad0fe49dee81cfe2ff3105f832534)
- Build fix. [`af14a94`](https://github.com/ImageMagick/ImageMagick/commit/af14a94b83c4b35c154bd1ec12855215a23001d2)
- set explicit format @ https://github.com/ImageMagick/ImageMagick/issues/5444 [`5ef3d4d`](https://github.com/ImageMagick/ImageMagick/commit/5ef3d4d66e33880d19614f0f64a85ed728ee5226)
- release [`2b90eb9`](https://github.com/ImageMagick/ImageMagick/commit/2b90eb9da96e4c22da6cf6d02e84a2948a5aefa7)

## [7.1.0-45](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-44...7.1.0-45) - 2022-07-31

### Merged

- Update Readme.md [`#5320`](https://github.com/ImageMagick/ImageMagick/pull/5320)

### Commits

- beta release [`9e3fa16`](https://github.com/ImageMagick/ImageMagick/commit/9e3fa1679410d511c691d5f6eb09f7d0a2ae0e3f)
- beta release [`ca18a05`](https://github.com/ImageMagick/ImageMagick/commit/ca18a0519b5ee0d08505f8fe8e6be2ef4fde212b)
- omp_init_lock() has undefined behavior if the lock is already init'ed @ https://github.com/ImageMagick/ImageMagick/issues/5360 [`fc4744f`](https://github.com/ImageMagick/ImageMagick/commit/fc4744f79987ba5309ab4e5cb95faacab2ca72a9)
- verify Freetype delegate library is version 2.8 or above [`8a25b36`](https://github.com/ImageMagick/ImageMagick/commit/8a25b36867cc5872e9ebde7e83e96a0600d2eebe)
- Whitespace. [`70e7690`](https://github.com/ImageMagick/ImageMagick/commit/70e7690706e79d653bbb35aeb6b603cceb82bea7)
- Changed checks for libtiff. [`ee1f26f`](https://github.com/ImageMagick/ImageMagick/commit/ee1f26ff19ae070d91fab8415a9f7950a2b4d19d)
- conditionally destroy mutux [`b4f429f`](https://github.com/ImageMagick/ImageMagick/commit/b4f429ff28ca7d0ad172e567c01deb8b7503ac5d)
- lock/unlock mutex assumes an initialized lock [`deb080b`](https://github.com/ImageMagick/ImageMagick/commit/deb080b28ef0216e2d0785db923445dee4e8fc41)
- Removed MAGICKCORE_HAVE_TIFF checks. [`c6f8c5e`](https://github.com/ImageMagick/ImageMagick/commit/c6f8c5e49f1747eb7cf2b98f5d70ea77d66bc6cf)
- Removed variables that are set but never used. [`e973979`](https://github.com/ImageMagick/ImageMagick/commit/e973979e6fa1746616b08b01a9d8fd07d9089bb4)
- fix -evaluate Pow 2 issue @ https://github.com/ImageMagick/ImageMagick/issues/5376 [`a318c2d`](https://github.com/ImageMagick/ImageMagick/commit/a318c2da8115312ccf2f3d5b22e5ac9e9fcc1f6d)
- cosmetic [`94deb70`](https://github.com/ImageMagick/ImageMagick/commit/94deb70e6b2e773b3d4a3a4ef54df6377b501896)
- set virtual pixel method for connected components algorithm @ https://github.com/ImageMagick/ImageMagick/issues/5368 [`d65a985`](https://github.com/ImageMagick/ImageMagick/commit/d65a985729b50762f1e352e128db245dba7a3fea)
- eliminate compiler issues / warnings [`fc11d83`](https://github.com/ImageMagick/ImageMagick/commit/fc11d8357eeae86c2ef33f899846af10f64f7fd7)
- fix cast from provenance-free integer type to pointer type @ https://github.com/ImageMagick/ImageMagick/discussions/5380 [`6e29345`](https://github.com/ImageMagick/ImageMagick/commit/6e29345c58386f30ebad04adae636b81ef1333c6)
- https://github.com/ImageMagick/ImageMagick/pull/5320 [`8e395fd`](https://github.com/ImageMagick/ImageMagick/commit/8e395fdae15e427ef0dc4f09b60ac8089b3f6530)
- authenticate distributed cache [`d8d651e`](https://github.com/ImageMagick/ImageMagick/commit/d8d651e5724287315d3eae12557830e3a6be4030)
- cosmetic [`aad18ad`](https://github.com/ImageMagick/ImageMagick/commit/aad18ad71a50a30cf9ea9c647171b75ee89fae77)
- eliminate compiler warning [`10e6f75`](https://github.com/ImageMagick/ImageMagick/commit/10e6f7578850c1c71fa995f01e1ea84c7604d5af)
- divide NCC by the # of channels @ https://github.com/dlemstra/Magick.NET/issues/1220 [`64bdc88`](https://github.com/ImageMagick/ImageMagick/commit/64bdc8865b329395b2921ea9ce2e2f0623f197be)
- release [`d9369f5`](https://github.com/ImageMagick/ImageMagick/commit/d9369f5ef4580cf365c1950db78327689f5cb250)
- improve distributed cache exception messages [`d80f6a7`](https://github.com/ImageMagick/ImageMagick/commit/d80f6a7cd7b569d39ae657bd9ebe1ef3f57f8f95)
- release [`e32676e`](https://github.com/ImageMagick/ImageMagick/commit/e32676e0a7626768f98e851be1c28cb611acfacc)

## [7.1.0-44](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-43...7.1.0-44) - 2022-07-24

### Merged

- build: fix quoting for autoconf sendfile check [`#5333`](https://github.com/ImageMagick/ImageMagick/pull/5333)

### Commits

- beta release [`54080fc`](https://github.com/ImageMagick/ImageMagick/commit/54080fc7ee70731bc07a204b77efaf6b28c3ff08)
- beta release [`34683fa`](https://github.com/ImageMagick/ImageMagick/commit/34683fa9106788f63bca0ac2a6255de4b38bc4ce)
- ... [`220a680`](https://github.com/ImageMagick/ImageMagick/commit/220a6800956959970ac9d9d03fc595564736c8a6)
- respect configure's --disable-assert option [`bf9fcc1`](https://github.com/ImageMagick/ImageMagick/commit/bf9fcc129ab026ebb7e05bbad3b833a833eb1a87)
- disable assert in ImageMagick specific header [`86bbe49`](https://github.com/ImageMagick/ImageMagick/commit/86bbe49925db5095e88e45390b4fb88231302abb)
- Reduce MaxMemoryRequest. [`d2a9180`](https://github.com/ImageMagick/ImageMagick/commit/d2a918098878bd73a57a34b901b5ae85c0c8d17f)
- Use our own memory manager for Freetype memory allocation. [`f5f3dd8`](https://github.com/ImageMagick/ImageMagick/commit/f5f3dd83933669168ed147b9fbe3ac663d6fcd73)
- Added extra checks to make sure we don't go out of bounds when checking spaces. [`dd9e9bb`](https://github.com/ImageMagick/ImageMagick/commit/dd9e9bb80e500ad5e1213e7b4a5f7075ef09b547)
- Added extra options to point to ImageMagick6 and Freds-Scripts. [`abaa4dc`](https://github.com/ImageMagick/ImageMagick/commit/abaa4dc0acd8518052c19b4f83d4e17314458542)
- Changed correction to fix issue reported in #5326. [`9c90852`](https://github.com/ImageMagick/ImageMagick/commit/9c9085248492c1b2c32388e5fa5ccb057dd99141)
- cosmetic [`d8c641f`](https://github.com/ImageMagick/ImageMagick/commit/d8c641ff5dfd45f707fe7e33312b224272002a49)
- cosmetic changes [`215e407`](https://github.com/ImageMagick/ImageMagick/commit/215e407181bc7b7a67675ad4675bfc24735d9465)
- fix spurious extra channel @ https://github.com/ImageMagick/ImageMagick/issues/5325 [`787a7c2`](https://github.com/ImageMagick/ImageMagick/commit/787a7c22998d89210ff088234b36d369dd5856d1)
- framework for bayer image format (in-progress) [`e65c7e6`](https://github.com/ImageMagick/ImageMagick/commit/e65c7e60962da8707e7d117f6576e300fc681923)
- initial bayer coder header [`872f637`](https://github.com/ImageMagick/ImageMagick/commit/872f637a8715f9b5eaab3fc0c6b7037ecf146508)
- move MagickCommandGenesis() as mogrify.c will be deprecated someday [`cd80a8a`](https://github.com/ImageMagick/ImageMagick/commit/cd80a8a842d983c2805e4e9fe5bb6d8541038ccb)
- switch to MagickImageCommand() as ConvertImageCommand() will deprecate in the future [`2d96d8e`](https://github.com/ImageMagick/ImageMagick/commit/2d96d8e36cfa8ffe4bd92675a3aaf6c9bf235036)
- add `magick` CLI unit test [`f6282ec`](https://github.com/ImageMagick/ImageMagick/commit/f6282ec88ca5233d19654b040be34506c96f2219)
- support read raw Bayer (rggb) images based on http://im.snibgo.com/demosaic.htm [`2c08642`](https://github.com/ImageMagick/ImageMagick/commit/2c086422dbc1f845fbcc212929a61fabc53a2924)
- Added earlier exit for when writing the pixel row fails. [`df5637a`](https://github.com/ImageMagick/ImageMagick/commit/df5637a4aeb494f99802f251509c86edf38e199d)
- support writing bayer raw image samples [`1f04c1d`](https://github.com/ImageMagick/ImageMagick/commit/1f04c1d86831f73952760e91f29b8e37a60d234a)
- Changed the default Windows build to dynamic. [`e552479`](https://github.com/ImageMagick/ImageMagick/commit/e552479efe89fe0681892221245befe2611e8ca6)
- eliminate a double free per [`4139ef8`](https://github.com/ImageMagick/ImageMagick/commit/4139ef88d566c6572e4bb998ba19fcabdc7ec160)
- fix quoting for autoconf sendfile check [`017a485`](https://github.com/ImageMagick/ImageMagick/commit/017a485ac916e1d7c452f5f3470de5f3e483524f)
- Read bayer image without using MagickImageCommand. [`0afa38d`](https://github.com/ImageMagick/ImageMagick/commit/0afa38d17e78ece86eb64d693838ae54b5ede58b)
- make GRAY explicit to force the GRAY coder [`a61aed8`](https://github.com/ImageMagick/ImageMagick/commit/a61aed8956f8bc5b32b70f1db3a149d62a8ddb2b)
- Write bayer image without using MagickImageCommand. [`98fc6cb`](https://github.com/ImageMagick/ImageMagick/commit/98fc6cbbc2c096a3bd71f6ca95bdfd7b72bb4e45)
- Renamed variables. [`184e9be`](https://github.com/ImageMagick/ImageMagick/commit/184e9bec9195e7577d6d9aef049f31b0013f61d8)
- Corrected solution name. [`e1dd8ed`](https://github.com/ImageMagick/ImageMagick/commit/e1dd8edeece0947fa11dc0c155b2f108458c36c5)
- bayer coder is no longer dependent on MagickWand lib [`e236e87`](https://github.com/ImageMagick/ImageMagick/commit/e236e87424075d7d22820e2cf6780a69c1be1e40)
- add Dirk as coder author [`1f1482d`](https://github.com/ImageMagick/ImageMagick/commit/1f1482d7feca6a77e4d60713a4aafb14dab7ec19)
- Moved creation of the fill pattern image. [`6b83a76`](https://github.com/ImageMagick/ImageMagick/commit/6b83a7654e345754f751f9171ea92e2ae763b0eb)
- Use different configuration to make sure all configurations are build. [`77bcc95`](https://github.com/ImageMagick/ImageMagick/commit/77bcc95c06ca8bdbf709b24eb3a96efff83adb41)
- fix tiled pattern for -virtual-pixel none @ https://github.com/ImageMagick/ImageMagick/discussions/5331 [`055d941`](https://github.com/ImageMagick/ImageMagick/commit/055d9416c960488a0153e3d5a1a02cf84997247e)
- check primitive boundaries to avoid overflow [`75c4e7f`](https://github.com/ImageMagick/ImageMagick/commit/75c4e7fca9f5b2bbd25e42ec7aa56468a75f98a5)
- eliminate unitialized warning [`6adb276`](https://github.com/ImageMagick/ImageMagick/commit/6adb276e2c75c4445de442f83f71f65547e5f98a)
- Corrected channel checks inside PerceptibleImage. [`33d3567`](https://github.com/ImageMagick/ImageMagick/commit/33d3567be16098b43e2f7e876fe058472709ca9f)
- Removed CoderDecoderThreadSupportFlag | CoderEncoderThreadSupportFlag and because we are no longer using wand. [`7860a04`](https://github.com/ImageMagick/ImageMagick/commit/7860a04904cd79e7ec72e0b3eb0bdc37b7fb12ce)
- Eliminate double free. [`892040b`](https://github.com/ImageMagick/ImageMagick/commit/892040b56cc81ae2068ad59f78888d0f2fce79d9)
- Use consistent naming. [`5c1e4e5`](https://github.com/ImageMagick/ImageMagick/commit/5c1e4e5a9339e100b04318cf14068afd74542d38)
- Open blob before checking dimensions to avoid memory leak in ImagesToBlob and ImageToBlob. [`444800f`](https://github.com/ImageMagick/ImageMagick/commit/444800f1385fcb58e9ec5bd9aae63bd9e3b156c1)
- cosmetic [`9e020d2`](https://github.com/ImageMagick/ImageMagick/commit/9e020d234e55a41513d3084981f252ed506858c0)
- set opaque alpha channel for pattern coder @ https://github.com/ImageMagick/ImageMagick/discussions/5331 [`ed5737d`](https://github.com/ImageMagick/ImageMagick/commit/ed5737db30014f4b8e60b9e77704b26432282121)
- create property for constrast and linear stretch [`a254d10`](https://github.com/ImageMagick/ImageMagick/commit/a254d108832ff60de0d85899b272d56449d7aabc)
- protect MagickCoreTerminus() with a mutex @ https://github.com/ImageMagick/ImageMagick/issues/5360 [`efb11f5`](https://github.com/ImageMagick/ImageMagick/commit/efb11f5f681bf419c91ebcfe1fce0f76ca5e90f9)
- release [`0def2d2`](https://github.com/ImageMagick/ImageMagick/commit/0def2d22ca04a68677ae88f275511098752d0ca0)
- revert optimal texture mapping [`efb742d`](https://github.com/ImageMagick/ImageMagick/commit/efb742d2dd2951ac1b62b40fac697d8870860e30)
- associate {linear,constrast}-stretch with histogram namespace [`3628467`](https://github.com/ImageMagick/ImageMagick/commit/3628467f8a9981f2a85531fa98b2f91ab4157e09)
- contrast-stretch proper is percent of total pixels to clip [`a2e819a`](https://github.com/ImageMagick/ImageMagick/commit/a2e819ae89818f41f1d170defe8edf8c67760410)
- release [`0f290dc`](https://github.com/ImageMagick/ImageMagick/commit/0f290dc318a86972e428437bc69b1b063f2ad7d4)
- release [`32491af`](https://github.com/ImageMagick/ImageMagick/commit/32491af93965e30940bb0f4bd183eb867cc44678)
- Remove unnecessary typecast. [`93737f7`](https://github.com/ImageMagick/ImageMagick/commit/93737f78c8a29451f07f1a8b380673a032896b1c)
- Open blob earlier to possible avoid memory leak in ImagesToBlob and ImageToBlob. [`794e12f`](https://github.com/ImageMagick/ImageMagick/commit/794e12faed276a84fb0193a7a7d2a392b202f8b5)
- Corrected detection of transparent pixels (#5366) [`d033472`](https://github.com/ImageMagick/ImageMagick/commit/d033472aa43cbab948080117380c6294d9031b05)
- release [`ad83b6a`](https://github.com/ImageMagick/ImageMagick/commit/ad83b6a2921687661a91ffd9e3db33f82db8408f)
- release [`520a724`](https://github.com/ImageMagick/ImageMagick/commit/520a7245e8069fb3367b2fef790978a77b3e2a9a)
- release [`6cd515d`](https://github.com/ImageMagick/ImageMagick/commit/6cd515dee3010d6d5accfacb2a2943fdc8dc16f8)

## [7.1.0-43](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-42...7.1.0-43) - 2022-07-09

### Commits

- beta release [`c9ea9fd`](https://github.com/ImageMagick/ImageMagick/commit/c9ea9fd96d950849d381ce41250609d4c329303c)
- release [`71011cf`](https://github.com/ImageMagick/ImageMagick/commit/71011cf1d38ea9bc5eac52fee433b58569b24167)
- beta release [`8718d62`](https://github.com/ImageMagick/ImageMagick/commit/8718d62924c78a8b323e8dc5962eea151edebd38)
- release [`c95ef31`](https://github.com/ImageMagick/ImageMagick/commit/c95ef31d1ed702cc502f06202b17fee39e27ced9)

## [7.1.0-42](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-41...7.1.0-42) - 2022-07-09

### Commits

- incorrect pointer update when computing median @ https://github.com/ImageMagick/ImageMagick/issues/5298 [`e29f487`](https://github.com/ImageMagick/ImageMagick/commit/e29f487ccdbe9f971fa69f16785767b2484a8f0e)
- beta release [`3a3baa9`](https://github.com/ImageMagick/ImageMagick/commit/3a3baa91cfee5af70f87266f33db54917739ba19)
- Added extra check because the flag was removed in 0.21-Beta1. [`0b13828`](https://github.com/ImageMagick/ImageMagick/commit/0b13828b46ac7fc83a1eb677bda602285f8f04cd)
- the -transparent-color option accepts colornames @ https://github.com/ImageMagick/ImageMagick/discussions/5297 [`ce18e42`](https://github.com/ImageMagick/ImageMagick/commit/ce18e422f951fa3e2627539b7bc0b03082176eea)
- fix MVG stroke-opacity issues [`6cd5112`](https://github.com/ImageMagick/ImageMagick/commit/6cd511240400d5be19a95811a54de302186d5afd)
- map channel parameter to pixel channel offset @ https://github.com/ImageMagick/ImageMagick/issues/5308 [`6bd722b`](https://github.com/ImageMagick/ImageMagick/commit/6bd722bfdd21ea03c7a309d11f0f1d18af6e2f1c)
- release [`396d87c`](https://github.com/ImageMagick/ImageMagick/commit/396d87cf05f21810b1f64ac3f7d1d26653a90b96)

## [7.1.0-41](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-40...7.1.0-41) - 2022-07-06

### Commits

- beta release [`19f1a50`](https://github.com/ImageMagick/ImageMagick/commit/19f1a50371acc1f4eaead23d097523319e64894a)
- preserve input depth @ https://github.com/ImageMagick/ImageMagick6/issues/188 [`a69791d`](https://github.com/ImageMagick/ImageMagick/commit/a69791d9fbe91f1428ab1f75d3493649d96fba19)
- cosmetic [`56dba8e`](https://github.com/ImageMagick/ImageMagick/commit/56dba8e426519c4e95405b2018618edafe434daf)
- update to latest automake/autoconf release [`52d6892`](https://github.com/ImageMagick/ImageMagick/commit/52d689220fc5d5b2e2fc0fc4389ee781764bf07e)
- recognize SVG file if it starts with whitespace @ https://github.com/ImageMagick/ImageMagick/issues/5294 [`db042fb`](https://github.com/ImageMagick/ImageMagick/commit/db042fbefdb06f71b8e1e01a78c245b35983b492)
- Removed unused stealth flag. [`316b9d5`](https://github.com/ImageMagick/ImageMagick/commit/316b9d5ae46463697400536923585843fe294aa2)
- Removed used path field. [`ed8d481`](https://github.com/ImageMagick/ImageMagick/commit/ed8d481cacaec90db2f4883661c359aebe2f5fa1)
- Removed unused target field. [`92d2fe1`](https://github.com/ImageMagick/ImageMagick/commit/92d2fe198173cab3bf1faf610784647e209f61c7)
- Removed unused exempt field. [`3036966`](https://github.com/ImageMagick/ImageMagick/commit/3036966f9a9cd59f9e76fbe48bcf0aadce026dcb)
- Added extra option to the skip spaces to the MagicInfo. [`1563f07`](https://github.com/ImageMagick/ImageMagick/commit/1563f074ff2e6cc3f3e2e218acfc112dc90ee288)
- Always start at the start of the string when comparing the magic value. [`be46ed6`](https://github.com/ImageMagick/ImageMagick/commit/be46ed631986a01f725191ff49e3c93d744fa10e)
- cosmetic [`c4a9a8b`](https://github.com/ImageMagick/ImageMagick/commit/c4a9a8bd598c1c480f0a10a911a22b15889171d4)
- avoid OMP deadlock @ https://github.com/ImageMagick/ImageMagick/issues/5301 [`1de5b94`](https://github.com/ImageMagick/ImageMagick/commit/1de5b94fb832d3b7d2909764cb6a4e5dd2d12c3d)
- release [`8a38ada`](https://github.com/ImageMagick/ImageMagick/commit/8a38adadf20522c8f39f81200109f99976d29bec)

## [7.1.0-40](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-39...7.1.0-40) - 2022-07-03

### Commits

- beta release [`15fbf4d`](https://github.com/ImageMagick/ImageMagick/commit/15fbf4da67cd51f903c13adbebd40eda1bfff047)
- prevent undefined shift [`2b10479`](https://github.com/ImageMagick/ImageMagick/commit/2b10479483641a0dd3092650edd4964b591cf3b9)
- prevent possible buffer overflow [`a854a0a`](https://github.com/ImageMagick/ImageMagick/commit/a854a0a8af977a1b67830f02a53d9eb4d877e10d)
- correct copy/paste error [`b11d647`](https://github.com/ImageMagick/ImageMagick/commit/b11d64704f46cedade2ca3cdcebbc8d1f315035e)
- We need to free the stream ourselves when the call to FT_Open_Face fails. [`a1eb122`](https://github.com/ImageMagick/ImageMagick/commit/a1eb12255c950825c96714d86d6a69e8e83bc9e2)
- Added missing call to DestroyString. [`bc786da`](https://github.com/ImageMagick/ImageMagick/commit/bc786dac768bd5013cd497c5788aea7a0f02e873)
- MVG requires seekable stream [`16f316e`](https://github.com/ImageMagick/ImageMagick/commit/16f316e33a66c67dfc13cd4cbe82097bee90f7e5)
- Added extra malloc method to avoid early calls to the policy checks on Windows. [`57e7129`](https://github.com/ImageMagick/ImageMagick/commit/57e7129d4e75dee3024e7ad1fba6b18356ec10d0)
- Removed defines. [`d868d16`](https://github.com/ImageMagick/ImageMagick/commit/d868d16a8c0548d144223e33896f3c0e6a4677e2)
- Only check for dll's in non static build. [`59be75e`](https://github.com/ImageMagick/ImageMagick/commit/59be75ecd4d310edc8ea4de73d42f871dcee0580)
- Set the client name and path earlier. [`b26efc7`](https://github.com/ImageMagick/ImageMagick/commit/b26efc7a6fba5c683c4e3a0447654a2785541dd2)
- fix background opacity rounding @ https://github.com/ImageMagick/ImageMagick/issues/5264 [`b42d5cb`](https://github.com/ImageMagick/ImageMagick/commit/b42d5cbea9bb289130094d6299ff4897b75ab37b)
- empty result on conversion from tiff to pdf @ https://github.com/ImageMagick/ImageMagick/issues/5256 [`9075c30`](https://github.com/ImageMagick/ImageMagick/commit/9075c3037b37b09b188626ff68559083328c6809)
- Corrected patch that was made for #5256. [`002a038`](https://github.com/ImageMagick/ImageMagick/commit/002a0380bd6828201574a05ce9484e8136871086)
- Pass negative interline_spacing to pango [`7e20db5`](https://github.com/ImageMagick/ImageMagick/commit/7e20db545aade7638047341bccdfb31807525d82)
- Also check extension to fix possible stack overflow. [`acae312`](https://github.com/ImageMagick/ImageMagick/commit/acae31224ed02694b25570e6ce121925d8c0227c)
- eliminate possible buffer overflow [`309dfda`](https://github.com/ImageMagick/ImageMagick/commit/309dfda1122f08fcf349b6f611b3b6df994d9297)
- set group 4 photometric to min-is-white [`6ab6a3f`](https://github.com/ImageMagick/ImageMagick/commit/6ab6a3f141d0c2dd4a3b52dea0db6cdb807f1fab)
- dasharray requires non-zero values [`19cdaf1`](https://github.com/ImageMagick/ImageMagick/commit/19cdaf1154a4fdfcff9551724dbe8b44a89765e0)
- cosmetic [`75249eb`](https://github.com/ImageMagick/ImageMagick/commit/75249ebf0800f785e451337c6b70072195d5f866)
- eliminate compiler warning [`d192518`](https://github.com/ImageMagick/ImageMagick/commit/d19251872eea427615ecc2b5f3726cd91ec19480)
- only permit one rows/columns keyword [`972f445`](https://github.com/ImageMagick/ImageMagick/commit/972f445c9064afefa0e61cfc906aa102e0ee45fb)
- Moved allocation back to the correct spot to avoid bypassing SetImageExtent. [`9a8c352`](https://github.com/ImageMagick/ImageMagick/commit/9a8c352c06613c557c3ba5113b79afaae429c1c4)
- Also restore setting quantum_info to null. [`bc14685`](https://github.com/ImageMagick/ImageMagick/commit/bc146855d32c1fbac33a9d0c9f8b2dbc9f83cec1)
- revert [`5e87813`](https://github.com/ImageMagick/ImageMagick/commit/5e87813a9935e9b5ed634e601bf5b329cfc765bf)
- eliminate uninitialized value warning [`8584fcd`](https://github.com/ImageMagick/ImageMagick/commit/8584fcd4b162abc22229e3555dbd08f820057ee3)
- Make sure all text strings are freed when realloc fails. [`76693a4`](https://github.com/ImageMagick/ImageMagick/commit/76693a4cbd42bfa77cb089a3033fe19c7c1f7650)
- Reset primitive_info inside RenderMVGContent because this address could point to another address. [`e2bf123`](https://github.com/ImageMagick/ImageMagick/commit/e2bf123cbaff9dcde654116a933b202cffac2e18)
- Always check if .text is set instead. [`dd2791b`](https://github.com/ImageMagick/ImageMagick/commit/dd2791b0fdb7175f0e658b76637ed7aead5ed95c)
- eliminate uninitialized alpha pixel [`7f01237`](https://github.com/ImageMagick/ImageMagick/commit/7f0123790b85438962b60c362d0bfe2557ce1c2c)
- remove debugging mod [`1ad7086`](https://github.com/ImageMagick/ImageMagick/commit/1ad70866a53f588031c50821bfcd743de7c66df9)
- eliminate compiler warning [`51e2b04`](https://github.com/ImageMagick/ImageMagick/commit/51e2b04a82aad68a06219ab620e41c00acdb43fc)
- recognize read-mask & write-mask for -channel option [`6b8d6f9`](https://github.com/ImageMagick/ImageMagick/commit/6b8d6f9ff85b8ccfcd6e281782878bd91eee2b2d)
- eliminate compiler warning [`e32bd1d`](https://github.com/ImageMagick/ImageMagick/commit/e32bd1d99f8d690fcfe2bc941b981bd71a0af68a)
- fix scrambled image @ https://github.com/ImageMagick/ImageMagick/issues/5291 [`e8a2735`](https://github.com/ImageMagick/ImageMagick/commit/e8a273560c58dc2a099b2989d5cfcd0021e40d51)
- yikes, misspelled 'level' [`7ad1916`](https://github.com/ImageMagick/ImageMagick/commit/7ad19164011001630f10f62a5116d54f5769d5f8)
- release [`de7e8cd`](https://github.com/ImageMagick/ImageMagick/commit/de7e8cd106af3d7f13ba4fb1a7ef2ef5e3aa6a07)

## [7.1.0-39](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-38...7.1.0-39) - 2022-06-20

### Commits

- beta release [`77932cb`](https://github.com/ImageMagick/ImageMagick/commit/77932cb9424f81fca686942bd8cb97b2eafc6065)
- Fixed possible memory leak. [`12a1b25`](https://github.com/ImageMagick/ImageMagick/commit/12a1b25e47deb28129815e9f50c7624dd70a3a46)
- support floating point formats [`7093702`](https://github.com/ImageMagick/ImageMagick/commit/70937026d08d11a488899c2d36dff1c3b45b5151)
- initialize date:precision in private TimerComponentGenesis() method [`fce5298`](https://github.com/ImageMagick/ImageMagick/commit/fce5298f22272ae8439b95316b5981d61bb301c9)
- check for -1 is not required [`68fb3c5`](https://github.com/ImageMagick/ImageMagick/commit/68fb3c56279ede6a30bfdd6348f3806811354132)
- refactor date:precision flow [`6df26f2`](https://github.com/ImageMagick/ImageMagick/commit/6df26f22cf373c0fcf491e2d1b6033d74bccfcab)
- eliminate compiler warning [`2dda00a`](https://github.com/ImageMagick/ImageMagick/commit/2dda00ae5f67024b5fd22b752eb6521bf83a006c)
- release [`21a5642`](https://github.com/ImageMagick/ImageMagick/commit/21a5642bc3c5b17c8e4e6cad9e1f41eeb6be9677)

## [7.1.0-38](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-37...7.1.0-38) - 2022-06-19

### Commits

- beta release [`874da17`](https://github.com/ImageMagick/ImageMagick/commit/874da17fa8719420e864358ace1b40947f866e37)
- update DOX config files [`fe3d2bf`](https://github.com/ImageMagick/ImageMagick/commit/fe3d2bff54cf353ec2c085f075c0287effd62686)
- update DOX config files [`b8648f4`](https://github.com/ImageMagick/ImageMagick/commit/b8648f474496126e4a0adf805114d5fdcd3b97db)
- update DOX config files [`2a7bf28`](https://github.com/ImageMagick/ImageMagick/commit/2a7bf28e7df8694c3c49b53ff29b318a658285e2)
- correct formulation of the phash normalization [`8d73544`](https://github.com/ImageMagick/ImageMagick/commit/8d73544754fd9170712e097a38e9df2e79381d2d)
- phash normalization is conventional RMS calculation [`146eee5`](https://github.com/ImageMagick/ImageMagick/commit/146eee51ee6807b232e2eafecd3234cfac364dcc)
- only check shread count once [`ec530f1`](https://github.com/ImageMagick/ImageMagick/commit/ec530f1505e1d8d09da4e3b008dd4543e1022632)
- cosmetic [`69110cf`](https://github.com/ImageMagick/ImageMagick/commit/69110cf5299160ccd59724ddf2cb2fbef38e86a6)
- cosmetic [`f088340`](https://github.com/ImageMagick/ImageMagick/commit/f088340e2d730e108a990a341f3ef38247cd0f3c)
- add private ShredMagickMemory() method to hide contents of memory buffers before they are relinquished [`28637d2`](https://github.com/ImageMagick/ImageMagick/commit/28637d210be357dc11e59776864c3dc2ac52a927)
- system:shred value has precedence over MAGICK_SHRED_PASSES [`bea3c06`](https://github.com/ImageMagick/ImageMagick/commit/bea3c06e199425c5a4ee27043de5aa8e59b8e520)
- support shredding memory pools [`9479fba`](https://github.com/ImageMagick/ImageMagick/commit/9479fbaa5fb7eb39ae6cce587fd4e315131b0ca4)
- update memory pointer [`8b289a8`](https://github.com/ImageMagick/ImageMagick/commit/8b289a89f2a4940ad1ac3c931174c809acb0b35d)
- Silenced warning. [`c7bbf5c`](https://github.com/ImageMagick/ImageMagick/commit/c7bbf5c0283bd43a5485207610a195ae7baff9b2)
- Corrected documentation. [`20ec4a7`](https://github.com/ImageMagick/ImageMagick/commit/20ec4a7c3313b14764ec8c0d98b7b7b1d5c8794a)
- first pass is fast for performance, second is crytographically strong [`c1ddb64`](https://github.com/ImageMagick/ImageMagick/commit/c1ddb64e5764fabeb40486df7e0fcb8ba96e8a42)
- recommend shred value of 1 for performance reasons [`59e784b`](https://github.com/ImageMagick/ImageMagick/commit/59e784bd06192b73eb8f1b99ea3d43571ee7c329)
- only set the # of shred passes one time [`6cffc2e`](https://github.com/ImageMagick/ImageMagick/commit/6cffc2eebbed08d57bed0960a607de1f698900b4)
- if enabled, shred streams [`4886318`](https://github.com/ImageMagick/ImageMagick/commit/4886318810eb1e74def3744ff360af58d42df0d6)
- unmap mapped pixels [`4bbcaa2`](https://github.com/ImageMagick/ImageMagick/commit/4bbcaa22aa3bd23be55191b6bfbfcec8915c6966)
- default mapped member to false [`50be626`](https://github.com/ImageMagick/ImageMagick/commit/50be6264fdb5861df77cba7501d3048d1fd703e4)
- don't shred streaming pixels [`44b3e9b`](https://github.com/ImageMagick/ImageMagick/commit/44b3e9b51d70e256a4b67122af9b6f38b3fbcf59)
- rework shred passes [`3699b74`](https://github.com/ImageMagick/ImageMagick/commit/3699b7456a4b0ca335ef566f5713d69f4b6d960b)
- optimize performance [`b30e351`](https://github.com/ImageMagick/ImageMagick/commit/b30e351c307263c273075779a593d081b8b509d1)
- change per lint advisement [`a637245`](https://github.com/ImageMagick/ImageMagick/commit/a637245a2fb2c5f3937ffb0540de593b4e9e5910)
- typecast per lint advisement [`5733a82`](https://github.com/ImageMagick/ImageMagick/commit/5733a82f41db607567df284253d07a60bcfd85f3)
- eliminate compiler warning [`249bcdf`](https://github.com/ImageMagick/ImageMagick/commit/249bcdffd7ef8a31f1529b643ea2d5d0b1caeb57)
- eliminate lint warnings [`8c6731a`](https://github.com/ImageMagick/ImageMagick/commit/8c6731a2c31454e64dbbb8cad427f7d514c866d2)
- eliminate lint warnings [`ff3e1f5`](https://github.com/ImageMagick/ImageMagick/commit/ff3e1f52acb9920176faaf45c7cb002d7ae975ca)
- support date:timestamp property [`e1b538a`](https://github.com/ImageMagick/ImageMagick/commit/e1b538ac6d78267fa5c0c3e27f9ca2f9b2f34d22)
- eliminate lint warnings [`92e7887`](https://github.com/ImageMagick/ImageMagick/commit/92e788780ffa4b6965fcd387dd41ebd13940db20)
- set timestamp from image-&gt;timestamp member [`3ed71fd`](https://github.com/ImageMagick/ImageMagick/commit/3ed71fd3d530724cd12a9a78666c60aee0c6f11b)
- eliminate lint warnings [`80bd592`](https://github.com/ImageMagick/ImageMagick/commit/80bd592dd20d4a1287842459ca3801c3ae3866cd)
- support MAGICK_DATE_PRECISION and registry:date:precision defines [`304069d`](https://github.com/ImageMagick/ImageMagick/commit/304069da840e0fea9ebce54b2572d5e7cee3116a)
- support registry:precision define [`3b2b78a`](https://github.com/ImageMagick/ImageMagick/commit/3b2b78a7b82d41db7590b9cb3ba3b210254ff2b8)
- ... [`9acdf7c`](https://github.com/ImageMagick/ImageMagick/commit/9acdf7c34f68e39ab7f2442bb9cea5266ae07d06)
- need at least one policy defined [`812ade8`](https://github.com/ImageMagick/ImageMagick/commit/812ade8dec620e968f2a1b8572136a4f9fb859da)
- eliminate lint warnings [`0f8c615`](https://github.com/ImageMagick/ImageMagick/commit/0f8c615fd27cd404dae1b9ab01f38c5994bd0df1)
- note, system:precision is deprecated [`d9f3714`](https://github.com/ImageMagick/ImageMagick/commit/d9f371473bad3e95ffa8a6819418c5d33824122a)
- eliminate icc compiler warnings [`d90c06f`](https://github.com/ImageMagick/ImageMagick/commit/d90c06fef6df2b44b906a8570adac56896205204)
- eliminate icc compiler warnings [`91eb3ef`](https://github.com/ImageMagick/ImageMagick/commit/91eb3ef024c1b80ca7187ea3de60e1def96639b3)
- eliminate compiler warning [`1bb549f`](https://github.com/ImageMagick/ImageMagick/commit/1bb549fdd9790c8dda0a0fce62ba89a7ceec2d28)
- Reverted incorrect patch when doing auto-orient of an image that is right-top or left-bottom. [`ca1913b`](https://github.com/ImageMagick/ImageMagick/commit/ca1913ba9cd5ef886a5557955b0284cc3b53e893)
- Corrected conversion from flip to Orientation. [`5f7f165`](https://github.com/ImageMagick/ImageMagick/commit/5f7f165507748ee04352c9801c0c00eaeecf1893)
- Only close the file blob when gzopen is successful (#5233). [`bbceed7`](https://github.com/ImageMagick/ImageMagick/commit/bbceed7bc2496df04845b3ef7da209d3eec2e41c)
- Added method to add utf8 support for gzopen on Windows. [`342e7a3`](https://github.com/ImageMagick/ImageMagick/commit/342e7a3eba0888c1656379ca513e1013f03a61e8)
- Only parse SOURCE_DATE_EPOCH once. [`58f6ce5`](https://github.com/ImageMagick/ImageMagick/commit/58f6ce5a2409546bc14f50d0eb97ece14ad9e60d)
- Restored check that did not seem to be necessary. [`157b3b4`](https://github.com/ImageMagick/ImageMagick/commit/157b3b4e66ecdfe3d753daa70a39a4daf84a1655)
- Whitespace [`063da01`](https://github.com/ImageMagick/ImageMagick/commit/063da01fbf87034f4771bd0c84e35c95230907b9)
- Limit the value of min_channels in the PSDInfo inside the tiff coder to make it possible to read images with a lot of meta channels. [`bb6b465`](https://github.com/ImageMagick/ImageMagick/commit/bb6b465db802256c7e94def1282366163dea405d)
- Make sure that the creation and modification date have the same value in both places and added option to override this (pdf:create-epoch and pdf:modify-epoch) [`2cd74b8`](https://github.com/ImageMagick/ImageMagick/commit/2cd74b89d949ed7488319e24ccc9223fb229beef)
- Added option to specify the creator (pdf:creator) and use that as xap:CreatorTool instead. [`27463ec`](https://github.com/ImageMagick/ImageMagick/commit/27463ec8bdfc2029edde648e90110286269088b0)
- Added WritePDFValue method that can be reused to write other values. [`4bf8773`](https://github.com/ImageMagick/ImageMagick/commit/4bf87730be817c074d25df0f4e4afa45f73ea584)
- Use the new method to write the other values. [`d246538`](https://github.com/ImageMagick/ImageMagick/commit/d2465387bbbe2d0190402734780777fb357a517a)
- Added option to specify the keywords (pdf:keywords) and use that as pdf:Keywords in the xmp profile. [`5450512`](https://github.com/ImageMagick/ImageMagick/commit/5450512e75a98e32ce5b12065f51118e50393b4c)
- Only check if magick is PDFA once. [`fac352a`](https://github.com/ImageMagick/ImageMagick/commit/fac352a56c4837a98997f8f605124860b6c2dce4)
- Added option to specify the subject (pdf:subject). [`b6d5881`](https://github.com/ImageMagick/ImageMagick/commit/b6d588132ba9e3dafa4ae56ba504def4ddcbfe06)
- Also fix incorrect fclose for bzlib. [`784f9fe`](https://github.com/ImageMagick/ImageMagick/commit/784f9fe9b2c01b543341e3dc246cbeb3f7785381)
- collect VICAR properties [`2c010f8`](https://github.com/ImageMagick/ImageMagick/commit/2c010f85f06b48f13cffc5e09b0fc771f3e2be85)
- fix improper close when opening zipped file [`f1cc4b9`](https://github.com/ImageMagick/ImageMagick/commit/f1cc4b96a8df146f327d71cd8e8aee47ca8487fa)
- Restored setting the file to NULL [`7c43344`](https://github.com/ImageMagick/ImageMagick/commit/7c433440a17a89fe79d35229e6a03a9bc6ed6ce0)
- Also remove date:timestamp when stripping the image. [`7922af1`](https://github.com/ImageMagick/ImageMagick/commit/7922af1e56acb0f5fca6fef9aeec1c7b7061cf99)
- release [`bc1cb48`](https://github.com/ImageMagick/ImageMagick/commit/bc1cb484406836889d2a05dc298efb1a1750cbd0)

## [7.1.0-37](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-36...7.1.0-37) - 2022-06-05

### Fixed

- Set pass when webp:target-size or webp:target-psnr are set to fix #4931. [`#4931`](https://github.com/ImageMagick/ImageMagick/issues/4931)

### Commits

- ... [`be0bdc3`](https://github.com/ImageMagick/ImageMagick/commit/be0bdc32c03f48923ca811e139d0a13f3724c4f5)
- don't keep in repo [`e926a8e`](https://github.com/ImageMagick/ImageMagick/commit/e926a8e24d48c43f1997b254ed57381ff6fe7784)
- beta release [`cc2d2a0`](https://github.com/ImageMagick/ImageMagick/commit/cc2d2a0a9321d121703d82e172d9ac55657f9607)
- Added extra permissions. [`a3420ae`](https://github.com/ImageMagick/ImageMagick/commit/a3420aee4dc92b1fb46ecc7e3931eaa7eec1314b)
- https://github.com/ImageMagick/ImageMagick/issues/5184 [`b8c664e`](https://github.com/ImageMagick/ImageMagick/commit/b8c664e0a35dbd213d7474785a8d87b06251d2dc)
- support Unicode MP4 filenames @ https://github.com/ImageMagick/ImageMagick/issues/5182 [`954f929`](https://github.com/ImageMagick/ImageMagick/commit/954f9295a3e4c8255f8fb2e2658ea71104ebc363)
- correct AcquireUniqueSymbolicLink() description [`5466350`](https://github.com/ImageMagick/ImageMagick/commit/5466350ef111fe52d2f4516a09543a6daf8c7c3e)
- chore: Included githubactions in the dependabot config [`44942dc`](https://github.com/ImageMagick/ImageMagick/commit/44942dc23fcdc3e3d459a260cacde9e25edd79e1)
- identify delegate library version [`2078fbe`](https://github.com/ImageMagick/ImageMagick/commit/2078fbe79e57915b214bcc0966b4fabddb7703d2)
- call method rather than define [`8c632fd`](https://github.com/ImageMagick/ImageMagick/commit/8c632fde8abb0f3cdba1ce4bb4d2bf9cf335f8b5)
- cosmetic [`0fba11b`](https://github.com/ImageMagick/ImageMagick/commit/0fba11bd0a7c2078fad61fda59f24a4c97423825)
- fix lint issues [`256301d`](https://github.com/ImageMagick/ImageMagick/commit/256301d23094c7a7515925c8b20c5aed16513ca6)
- fix lint issues [`0b92950`](https://github.com/ImageMagick/ImageMagick/commit/0b92950123c6dea27a9abb088ae69e329ec31a0f)
- fix lint issues [`e75b53a`](https://github.com/ImageMagick/ImageMagick/commit/e75b53abdcb5291e4e95f327c206efdb7863a116)
- Restore code that was removed by accident. [`c386108`](https://github.com/ImageMagick/ImageMagick/commit/c386108a74145b7b9ccefe3a3884f5a2d8463a41)
- Fix build. [`46e7166`](https://github.com/ImageMagick/ImageMagick/commit/46e71660f49810bbf772720743d16e101f4deff4)
- Use image-&gt;depth instead. [`6a74a35`](https://github.com/ImageMagick/ImageMagick/commit/6a74a3550eef119014ebd85229254cc8c2fe55ba)
- Don't set default values. [`6e0765d`](https://github.com/ImageMagick/ImageMagick/commit/6e0765d987feb5e9b16d0f3e44cedba58ffbb83c)
- use SetQuantum methods instead. [`afe37c5`](https://github.com/ImageMagick/ImageMagick/commit/afe37c56d47db5932eed62f73a4eb5460df27c4f)
- Move case statement to make sure that non FloatingPointQuantumFormat will end up in the default case. [`54ce5d9`](https://github.com/ImageMagick/ImageMagick/commit/54ce5d9f40253902d4266826f12e796ae2ad3920)
- cosmetic [`c1766ca`](https://github.com/ImageMagick/ImageMagick/commit/c1766ca97e10178f77194ac8d6666e40ee699801)
- point to latest EXIF standard doc [`7da6db4`](https://github.com/ImageMagick/ImageMagick/commit/7da6db4814a3879fd05429de49d6d1ce0f281276)
- Bump actions/upload-artifact from 1 to 3 [`a8c1ed3`](https://github.com/ImageMagick/ImageMagick/commit/a8c1ed39dcb47bc09b91256a26023f41cc36766c)
- sum hash differences rather than assign [`8a8a68a`](https://github.com/ImageMagick/ImageMagick/commit/8a8a68a42197dd104701b175fb0e3d4ef4557446)
- Continue with decoding the image when JxlDecoderGetColorAsEncodedProfile returns JXL_DEC_ERROR. [`53addfb`](https://github.com/ImageMagick/ImageMagick/commit/53addfb6e549f464d3507f1369e43e7d886dd05b)
- Added extra check for non error codes. [`5aaedfe`](https://github.com/ImageMagick/ImageMagick/commit/5aaedfec2b5ce0075f50bd5e578a8b194d4c52ce)
- Corrected rotation angle for right-top and left-bottom in auto-orient. [`b65d0d9`](https://github.com/ImageMagick/ImageMagick/commit/b65d0d9af078b01574d979e73fa71933ede6a403)
- release [`1b8963a`](https://github.com/ImageMagick/ImageMagick/commit/1b8963a4088677b62ad3885dcd4e83c7a33ef47a)

## [7.1.0-36](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-35...7.1.0-36) - 2022-05-30

### Commits

- beta release [`cfdb489`](https://github.com/ImageMagick/ImageMagick/commit/cfdb4897c6a2212c83be207f4dd5344b0d373d3e)
- Corrected the avif check to fix the issue reported in #5159. [`c638f3f`](https://github.com/ImageMagick/ImageMagick/commit/c638f3fbfc0517b5b3b1d69f67c16bb874fb6719)
- introducing the `dominant-color` property [`9135de4`](https://github.com/ImageMagick/ImageMagick/commit/9135de494c057fbe1cbb5193ba6cb4158a6520bd)
- improve dominant color reporting [`3077a6c`](https://github.com/ImageMagick/ImageMagick/commit/3077a6cc430a57869ee0fa56f3b3a5e65f3f15a3)
- Updated CodeQL Action. [`b7b90a1`](https://github.com/ImageMagick/ImageMagick/commit/b7b90a1498dc74b8d24bbd4923c61f7d0ee6a125)
- Try with different permissions. [`c092510`](https://github.com/ImageMagick/ImageMagick/commit/c092510ca5bb408fd07fdbbd7b566f04bb51eef3)
- Corrected permission name. [`0014ddf`](https://github.com/ImageMagick/ImageMagick/commit/0014ddfb2af800cb45c11dfb3396ded1abc65525)
- Corrected pragma comments due to repository renames. [`ad98584`](https://github.com/ImageMagick/ImageMagick/commit/ad985843a21055fe0639410e75fe52e94c7ff2f1)
- Added arm64 to the main build. [`5eb9b2b`](https://github.com/ImageMagick/ImageMagick/commit/5eb9b2b2906714a7dc437d3fbd8dea470e2d2516)
- cosmetic [`967fc1c`](https://github.com/ImageMagick/ImageMagick/commit/967fc1ceb84319e3234400a096d5fbd3efee5cbf)
- Download ChangeLog after cloning the repositories. [`7b0bf73`](https://github.com/ImageMagick/ImageMagick/commit/7b0bf732d5907d5a0f0cadb5bf2e17edee70319d)
- latest ImageMagick documentation [`0442c9d`](https://github.com/ImageMagick/ImageMagick/commit/0442c9d0ff3fceb24128705b44fd25a7b2c69c9c)
- release [`cd1add4`](https://github.com/ImageMagick/ImageMagick/commit/cd1add42d5583a842788450bd768bfd2c3851786)

## [7.1.0-35](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-34...7.1.0-35) - 2022-05-16

### Commits

- beta release [`e37bfbd`](https://github.com/ImageMagick/ImageMagick/commit/e37bfbdac1842265bbe1e3da7b61dd8580d947b5)
- remove special use case of Kmeans for color reduction @ https://github.com/ImageMagick/ImageMagick/issues/5152 [`53d7d06`](https://github.com/ImageMagick/ImageMagick/commit/53d7d0693138f2f63c099260c224bcbc4802972f)
- fix temporary file leak [`7496436`](https://github.com/ImageMagick/ImageMagick/commit/74964367f92291090d5919a12a167a2051c90f90)
- one-off release due to "-monochrome command no longer dithers grayscale [`ff6dbbb`](https://github.com/ImageMagick/ImageMagick/commit/ff6dbbbec9cfac49f3a6217e51717139bde840ff)

## [7.1.0-34](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-33...7.1.0-34) - 2022-05-15

### Commits

- beta release [`68a0412`](https://github.com/ImageMagick/ImageMagick/commit/68a041269ddfc43dc334022176395592d179dba2)
- require min 3 channels for compositing [`5d38476`](https://github.com/ImageMagick/ImageMagick/commit/5d38476b487766c1fc03f22193ed6d81aff917d6)
- PDF to PBM no longer returning all white @ https://github.com/ImageMagick/ImageMagick/issues/5134 [`8e605a2`](https://github.com/ImageMagick/ImageMagick/commit/8e605a2a3b8bb54393ffbf14b5d9af0973091aad)
- Removed incorrect method definition from the header file. [`18ccd96`](https://github.com/ImageMagick/ImageMagick/commit/18ccd96e8e9fc5707273287aab466485abf9c69d)
- fix build with -Werror @ https://github.com/ImageMagick/ImageMagick6/pull/177 [`0dcacb8`](https://github.com/ImageMagick/ImageMagick/commit/0dcacb8ca5b1b986ce1599a7b9642fc08deb328b)
- clarify usage [`186578a`](https://github.com/ImageMagick/ImageMagick/commit/186578a5a7a653441f6270624f6124c258bc83e7)
- eliminate compiler warnings [`4fe856b`](https://github.com/ImageMagick/ImageMagick/commit/4fe856bdfa99ec43ca8843ba5bf9f9ba7db57c03)
- latest autoconf/automake config [`4b69c54`](https://github.com/ImageMagick/ImageMagick/commit/4b69c54f928e76199d9fec740a2058c69ac15e74)
- cosmetic [`2722c2f`](https://github.com/ImageMagick/ImageMagick/commit/2722c2fa6004efdc5d33ccd85db9e99a2c3ae85b)
- cosmetic [`78a1988`](https://github.com/ImageMagick/ImageMagick/commit/78a19889d28b045254a1dbf4431e2fdf5c839daa)
- automake/autoconf update [`a772a53`](https://github.com/ImageMagick/ImageMagick/commit/a772a53cde76526ba5dadd10254b18d7c8a04cff)
- automake/autoconf update [`9d882e4`](https://github.com/ImageMagick/ImageMagick/commit/9d882e45df2b47e09467e996b3019ff1df14be0b)
- correct check for Magick++ compliance [`f4d8e6e`](https://github.com/ImageMagick/ImageMagick/commit/f4d8e6ec87e10802c7ab3fe99991ae28d0d7473c)
- automake/autoconf remove obselete macros [`644472a`](https://github.com/ImageMagick/ImageMagick/commit/644472a70043ce3b85f8e77ad0d67d5e2f7ffd2f)
- build RPM tweaks [`40bc17c`](https://github.com/ImageMagick/ImageMagick/commit/40bc17c866d6a1e8bbabf1496d0e68c5b4b8dc8d)
- tweak BZIP2 autoconf macro [`af5fdcd`](https://github.com/ImageMagick/ImageMagick/commit/af5fdcd2129bf0e8651d0a7f827e4abec77f5c0e)
- do not change grayscale colorspace to sRGB when compositing [`05074b2`](https://github.com/ImageMagick/ImageMagick/commit/05074b260d5eddbfa76e5d3bb68e50d1c122dc08)
- release [`f2934c5`](https://github.com/ImageMagick/ImageMagick/commit/f2934c5212ae38aea2b8d21bbdf22dcc31e3903e)

## [7.1.0-33](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-32...7.1.0-33) - 2022-05-07

### Merged

- autotools: Add ws2_32 library with MagickCore for Win32 platform [`#5119`](https://github.com/ImageMagick/ImageMagick/pull/5119)
- Avoid NULL pointer dereference in coders/wmf.c [`#5117`](https://github.com/ImageMagick/ImageMagick/pull/5117)

### Commits

- beta release [`600c455`](https://github.com/ImageMagick/ImageMagick/commit/600c455b84e471b700880653a6316c75b238bdc3)
- possible null dereference [`4e085a2`](https://github.com/ImageMagick/ImageMagick/commit/4e085a2d4a968856b85a3152b97330f257c57e0d)
- improved error checking [`2e5c976`](https://github.com/ImageMagick/ImageMagick/commit/2e5c976bbf64c77265bfc13727ff584759906f23)
- Also create an arm64 installer. [`c84fcf5`](https://github.com/ImageMagick/ImageMagick/commit/c84fcf5d794e82411c740841dabfabf48e84aa66)
- Also create portable arm64 binaries. [`6126915`](https://github.com/ImageMagick/ImageMagick/commit/6126915469c6e6523250c604e63f91686787bd14)
- eliminate coverity defect [`4cec11d`](https://github.com/ImageMagick/ImageMagick/commit/4cec11d25697bf36279de36639cc5516c4ae4b40)
- eliminate Coverity defect [`0364622`](https://github.com/ImageMagick/ImageMagick/commit/03646225cbf3346d8ae455a0abbb2607cdb0e8e0)
- eliminate Coverity defect [`a619616`](https://github.com/ImageMagick/ImageMagick/commit/a619616e7ee750543f97e77d2a64dcfcda3c6df1)
- https://github.com/ImageMagick/ImageMagick/discussions/5099 [`43da986`](https://github.com/ImageMagick/ImageMagick/commit/43da9864b5642e6c75c820b5d2241f5c9770e431)
- prevent memory leak on exception [`0157eb8`](https://github.com/ImageMagick/ImageMagick/commit/0157eb86a847443671a480dd3d2e8fca64fed16a)
- the tiles per page cannot be zero [`fecf247`](https://github.com/ImageMagick/ImageMagick/commit/fecf247fb9a6eae8fc719b413553822bc3d1fe78)
- check security policy before reading an -fx expression from a file [`c53fb96`](https://github.com/ImageMagick/ImageMagick/commit/c53fb964bcd9fa05fb9f5670e13ffdf65ad97147)
- fix exception on a valid ternary @ https://github.com/ImageMagick/ImageMagick/discussions/4533 [`64b5fe6`](https://github.com/ImageMagick/ImageMagick/commit/64b5fe68ac7edd0baef7271c127c7bdf49a573b3)
- display the image pixel cache type [`759029d`](https://github.com/ImageMagick/ImageMagick/commit/759029dd82c11157a5a6b61d36fff6d2588f1f34)
- change order of pixel cache type [`3529df8`](https://github.com/ImageMagick/ImageMagick/commit/3529df8399eadd863a7696ff5f48d887bae93fcb)
- change order of pixel cache type [`bacb357`](https://github.com/ImageMagick/ImageMagick/commit/bacb3574e5138e819abf8ab904d5ea3079764700)
- use the correct property key for arithmetic coding [`0184b6c`](https://github.com/ImageMagick/ImageMagick/commit/0184b6cb7b72436aa5eefcd8b1612a88b601bae5)
- Reverted patch because HDRI should always be highres. [`4e20a27`](https://github.com/ImageMagick/ImageMagick/commit/4e20a27b8790d8308f0477723f4998184db2d432)
- the maximum dissolve factor is 1.0 [`452c436`](https://github.com/ImageMagick/ImageMagick/commit/452c436c509792dfc582c3efc80ac11875731590)
- Removed duplicate check. [`b108dbd`](https://github.com/ImageMagick/ImageMagick/commit/b108dbd243d7f36ef1be32c574524a88f3dd4156)
- Fixed possible memory leak reported in #5121. [`9c957a6`](https://github.com/ImageMagick/ImageMagick/commit/9c957a6d66ead61d6a36bd20935b402db257792b)
- Removed to heif_filetype_yes_unsupported check to resolved the issue reported in #5123. [`47898c6`](https://github.com/ImageMagick/ImageMagick/commit/47898c655bc726da6d7fdd41b70a6a73c5754cb0)
- possible memory leak @ https://github.com/ImageMagick/ImageMagick/issues/5121 [`b0c1967`](https://github.com/ImageMagick/ImageMagick/commit/b0c1967fe17ddb59d2b26112efc0465bd01c971f)
- eliminate compiler warnings [`a10a570`](https://github.com/ImageMagick/ImageMagick/commit/a10a57044ae285c0f33159a53f3c8a3e1c297b82)
- eliminate compiler warnings [`3fa3d9f`](https://github.com/ImageMagick/ImageMagick/commit/3fa3d9fc2ead42461cfb2c2cd47d6b60d681cc96)
- conditional logging [`53fb342`](https://github.com/ImageMagick/ImageMagick/commit/53fb3423ebf9fc3da08ab61d5b186c5203e76f9e)
- eliminate compiler warnings [`a429f44`](https://github.com/ImageMagick/ImageMagick/commit/a429f447c7f3d34bf71c2c0a1df249e694d6ce2a)
- background kept when making cylinder @ https://github.com/ImageMagick/ImageMagick/discussions/5112 [`925a6c5`](https://github.com/ImageMagick/ImageMagick/commit/925a6c5d87ab5372d0b8b073819416e4ef5db312)
- cosmetic [`d4d5ca2`](https://github.com/ImageMagick/ImageMagick/commit/d4d5ca2dd981a37408e7a97e407c1d5632312c07)
- possible memory leak @ https://github.com/ImageMagick/ImageMagick/issues/5131 [`8ed6d1d`](https://github.com/ImageMagick/ImageMagick/commit/8ed6d1d52957b74c75ec8037ad698f714b9fb918)
- release [`4e6f7b1`](https://github.com/ImageMagick/ImageMagick/commit/4e6f7b1ee2ee736e466edf0efad09c0033be2ca7)
- release [`39baedd`](https://github.com/ImageMagick/ImageMagick/commit/39baedd0019edb3b69749b314633d6ad9428bcb9)

## [7.1.0-32](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-31...7.1.0-32) - 2022-04-30

### Merged

- Add support for FITS images with NaN values [`#5084`](https://github.com/ImageMagick/ImageMagick/pull/5084)
- Fixes grammar/typos/markdown [`#5083`](https://github.com/ImageMagick/ImageMagick/pull/5083)

### Commits

- prep Beta release [`d2c4a6f`](https://github.com/ImageMagick/ImageMagick/commit/d2c4a6fad5d9b1d68f729e09ed9e1af2e28957df)
- https://github.com/ImageMagick/ImageMagick/issues/3661 [`9090b17`](https://github.com/ImageMagick/ImageMagick/commit/9090b171d2df7cabfbed8853e7782fe08100b756)
- possible obscure memory leak [`8e0c95e`](https://github.com/ImageMagick/ImageMagick/commit/8e0c95ef940ef57e69f5b431bd12176f0c27f9f5)
- check event mask before logging [`eab8155`](https://github.com/ImageMagick/ImageMagick/commit/eab8155547f7422239e58e48a41f0268a629b4fb)
- check event mask before logging [`7dcb276`](https://github.com/ImageMagick/ImageMagick/commit/7dcb276defa9b2731d1716395301a173ed62c593)
- Also create changelog in the daily build. [`878a667`](https://github.com/ImageMagick/ImageMagick/commit/878a66722cc85a1b45da45e44a0ba187ac41ba64)
- Removed %GITHUB_WORKSPACE% from other builds. [`2540c48`](https://github.com/ImageMagick/ImageMagick/commit/2540c48a6a04c14ede0e4cf87c01a4dd2b862a5d)
- improve/optimize logging [`7ba113a`](https://github.com/ImageMagick/ImageMagick/commit/7ba113a0d26b6d2b008ce0fcf428050a84e5a0ac)
- https://github.com/ImageMagick/ImageMagick/issues/5041 [`c942d53`](https://github.com/ImageMagick/ImageMagick/commit/c942d5341c64124b7e10d85f1dc66c668d926a10)
- need Changelog.md, referenced by web pages [`6b6e7f3`](https://github.com/ImageMagick/ImageMagick/commit/6b6e7f3cedf498b96539a52631b1e0856002eb7d)
- ilatest autoconf update [`9dfee98`](https://github.com/ImageMagick/ImageMagick/commit/9dfee98d7db512005b81ea419d57f3b4a5107986)
- move to wbsite repo [`3e445a0`](https://github.com/ImageMagick/ImageMagick/commit/3e445a0deee2c083df33f77932f92a3a04e674e6)
- optimize thumbnail resizing [`09ab692`](https://github.com/ImageMagick/ImageMagick/commit/09ab692eeafa266bca06b62f0e366709bb42d56e)
- https://github.com/ImageMagick/ImageMagick/discussions/4533#discussioncomment-2626990 [`d13f844`](https://github.com/ImageMagick/ImageMagick/commit/d13f844162c4978eff849d16d534d79c420237bd)
- Rename extent to length. [`b056cec`](https://github.com/ImageMagick/ImageMagick/commit/b056cecdc0de98e015ad0dc3505561b96efa6410)
- Allow exif profile that has a zero length (#5082). [`0433d6e`](https://github.com/ImageMagick/ImageMagick/commit/0433d6e98008003e915bbcda4f29f00ffbe2a59d)
- Moved length check. [`267a891`](https://github.com/ImageMagick/ImageMagick/commit/267a89135c30f147e4f6c7e35c12d1f0c065e1f8)
- Removed code that was used to create a test image. [`bf925e6`](https://github.com/ImageMagick/ImageMagick/commit/bf925e68e11d1a86caeefdba0144c9ded39adf86)
- Use consistent code style. [`c4c031b`](https://github.com/ImageMagick/ImageMagick/commit/c4c031b83ef583a519bfd38ace4f4cb3350f1a2c)
- revert [`bca2fb8`](https://github.com/ImageMagick/ImageMagick/commit/bca2fb87480b0c5ffb57e1da2e73d07f90571c6a)
- Added missing CoderEndianSupportFlag (#5090). [`0952c6a`](https://github.com/ImageMagick/ImageMagick/commit/0952c6a11d41ce6b1998060ff1005f8692a08651)
- Sort commits by date instead. [`7b95dda`](https://github.com/ImageMagick/ImageMagick/commit/7b95dda41de4b4be9020c65c4b18b367988705b5)
- https://oss-fuzz.com/testcase?key=5120317075357696 [`5622990`](https://github.com/ImageMagick/ImageMagick/commit/56229901c3b41d81bdd7df8f7a1b91b7f54ccb22)
- Removed unused arguments. [`c704997`](https://github.com/ImageMagick/ImageMagick/commit/c704997d8d4e0cb2558428e462e69e4f5d4d6515)
- Added missing typecasts. [`6820800`](https://github.com/ImageMagick/ImageMagick/commit/6820800c9c8c0bc60fc7e43462160a9782f2c304)
- check for image width/height exceeding INT_MAX [`6d2c75e`](https://github.com/ImageMagick/ImageMagick/commit/6d2c75e57e05180c4c47b4028b906203efcd710f)
- eliminate compiler exception [`8649f4f`](https://github.com/ImageMagick/ImageMagick/commit/8649f4f9b9fc6a4ca6e7edbadce08367b790b872)
- add comment [`c506f55`](https://github.com/ImageMagick/ImageMagick/commit/c506f551e56d075886b7950de1a7df76ae552e28)
- Use set_arg_encoding as suggestion in #5092. [`67a2613`](https://github.com/ImageMagick/ImageMagick/commit/67a26132f811437540115e824f160af77f224f4b)
- optimize logging [`b2eaec1`](https://github.com/ImageMagick/ImageMagick/commit/b2eaec135972c582335f7ad034100ad88b6552b3)
- fix copyright [`c2fc57a`](https://github.com/ImageMagick/ImageMagick/commit/c2fc57ac8946126136051df2e350ae6920783e3e)
- initalize logging variable [`263bfae`](https://github.com/ImageMagick/ImageMagick/commit/263bfae95f1947c2bc1ee97d2c4ed1f106d96373)
- possible divide by zero [`dce1bcf`](https://github.com/ImageMagick/ImageMagick/commit/dce1bcf6270a21baed987c5f97e13be352e86fdc)
- more informative exception message [`b7d240b`](https://github.com/ImageMagick/ImageMagick/commit/b7d240bd8745bccbbfaabfeb1a4b7d3fd5218526)
- more informative exception message [`354669f`](https://github.com/ImageMagick/ImageMagick/commit/354669f10c64bed9ae55ae81da53d7af25ab5f80)
- make some logging coditional [`372b5df`](https://github.com/ImageMagick/ImageMagick/commit/372b5dff23249d326a010fc6f9ba016decdf750d)
- https://github.com/ImageMagick/ImageMagick/issues/3859 [`f49b826`](https://github.com/ImageMagick/ImageMagick/commit/f49b826849822cad755330b0a2d9ccc65b4ab2d0)
- release [`a2b2c08`](https://github.com/ImageMagick/ImageMagick/commit/a2b2c088faff39da703480652777d95955bd6e7a)

## [7.1.0-31](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-30...7.1.0-31) - 2022-04-23

### Commits

- https://github.com/ImageMagick/ImageMagick/issues/4973 [`c8ecfc4`](https://github.com/ImageMagick/ImageMagick/commit/c8ecfc44c64c7e06d346fc8d52bd52c3afc42444)
- Also correct stroke opacity. [`ac9e7bd`](https://github.com/ImageMagick/ImageMagick/commit/ac9e7bd72e60da35cb1284b06d5c269121c7bdc2)
- Removed parentheses. [`2e73d03`](https://github.com/ImageMagick/ImageMagick/commit/2e73d03390672f12fb1c992d85970323c57e9994)
- bump revisition [`9d2bc47`](https://github.com/ImageMagick/ImageMagick/commit/9d2bc47dc6465da9bbac5f6ce6b1bee061a7557c)
- eliminate compiler warning [`f39269a`](https://github.com/ImageMagick/ImageMagick/commit/f39269ac910fcd897c8186e09d7cbc7c28c6063e)
- release commits [`2b4683b`](https://github.com/ImageMagick/ImageMagick/commit/2b4683b7f57edf13a81d7f060ef68d3e3f463fb5)
- eliminate Coverity defects [`4853d63`](https://github.com/ImageMagick/ImageMagick/commit/4853d63c7c83a72c4722c096931d15b79f3bd8d3)
- eliminate Coverity defect [`90160a4`](https://github.com/ImageMagick/ImageMagick/commit/90160a408d6681cb68d4b98dfdceab5922b58350)
- latest autoconf/automake updates [`55238e3`](https://github.com/ImageMagick/ImageMagick/commit/55238e3ed62f4badff3e0fe2ac549c08e675f069)
- Added version checks for heif_check_filetype (#5049). [`25d749c`](https://github.com/ImageMagick/ImageMagick/commit/25d749cde1247484b7a491f51f6e8ecffbaff43a)
- Silenced warning when version is lower that 1.4.0. [`ed40ca1`](https://github.com/ImageMagick/ImageMagick/commit/ed40ca1f563d476e28af28d9d827da5352b3b0d3)
- Call CloseBlob earlier because we read the image from the file instead. [`eaf387c`](https://github.com/ImageMagick/ImageMagick/commit/eaf387c9fcbdbfd7f3bd8095aa0cf664ed148b75)
- Changed the minimum version for libheif to 1.4.0. [`c67cae6`](https://github.com/ImageMagick/ImageMagick/commit/c67cae6b6a35d18093db38748f592ffeb7504a34)
- autoconf latest update [`ca1924a`](https://github.com/ImageMagick/ImageMagick/commit/ca1924a8dd5aa7caa7ec584359ad24adc22e2931)
- Added option to mark the version as beta. [`b9066e3`](https://github.com/ImageMagick/ImageMagick/commit/b9066e3ca2a0216c6e10215a4d177d15becec991)
- Changed triggers for the release build. [`065f67c`](https://github.com/ImageMagick/ImageMagick/commit/065f67cbc24262d08f812f9c8b881a2c9be75c2f)
- latest autoconf update [`5f9fb8a`](https://github.com/ImageMagick/ImageMagick/commit/5f9fb8ad69e13c64abeb4657e2586ed6e3dcf76d)
- fix rare but possible memory leak [`58f3723`](https://github.com/ImageMagick/ImageMagick/commit/58f3723223b2eee350f63da67b60fb5599974349)
- proper check for number of channels [`73e0f4f`](https://github.com/ImageMagick/ImageMagick/commit/73e0f4f21476bf4b567aad1bc76fcfa4bc66b984)
- https://github.com/ImageMagick/ImageMagick/discussions/5066 [`2b0df1c`](https://github.com/ImageMagick/ImageMagick/commit/2b0df1c408a86247e17f9d78d9f0068fd8093818)
- set threshold policy by default [`aa35c9e`](https://github.com/ImageMagick/ImageMagick/commit/aa35c9e70eb333a35cc14812ab8ccd00368f43df)
- Get the intensity before changing the of the pixel channels (thanks Snibgo) #5067. [`c63bb2e`](https://github.com/ImageMagick/ImageMagick/commit/c63bb2eb4e14c83b6a260dfb2c1d9f1440977311)
- initialize composite variables as they are declared [`1cff1a7`](https://github.com/ImageMagick/ImageMagick/commit/1cff1a73ddb8561f2a05914250cb17e2dfe3b760)
- fix copyright format [`ba449b1`](https://github.com/ImageMagick/ImageMagick/commit/ba449b1180f8d667766b2d6045421a1c2de6b05b)
- Create ChangeLog during the release build. [`750eb06`](https://github.com/ImageMagick/ImageMagick/commit/750eb06242086a27e639fcf7a40dc59c928aa63c)
- Try without %GITHUB_WORKSPACE% [`9e8d681`](https://github.com/ImageMagick/ImageMagick/commit/9e8d6814a4287eadb071359917991417f5509ee7)
- Corrected typo. [`92e2fd7`](https://github.com/ImageMagick/ImageMagick/commit/92e2fd7cf5ba4e64efb0ba2cc571ad658e554f30)
- Use the generated ChangeLog.md file instead. [`8fabbd2`](https://github.com/ImageMagick/ImageMagick/commit/8fabbd2789c70eac3f0adeb3a32c9f31237e5205)
- Use version 3 of checkout. [`a007cff`](https://github.com/ImageMagick/ImageMagick/commit/a007cff3ad850d600f50be2504ed88304aad8b6c)
- Added missing cd. [`65af881`](https://github.com/ImageMagick/ImageMagick/commit/65af881610d1706525154f89ce885c7c17e78c71)
- Use date of latest change to m4/version.m4 instead. [`6bdc026`](https://github.com/ImageMagick/ImageMagick/commit/6bdc0260e6a0498ba3b1eecd02a0a3931b1618c2)
- Temporary list folder content. [`137a2f7`](https://github.com/ImageMagick/ImageMagick/commit/137a2f7f581971648d3d28d5d1150371f263a15e)
- Changed fetch depth. [`e33db37`](https://github.com/ImageMagick/ImageMagick/commit/e33db3706b413cba872bdd5ceab772fea0b2a513)
- The default fetch-depth is 1. [`84b5399`](https://github.com/ImageMagick/ImageMagick/commit/84b5399719de85cbef9d4bf4c77e1ed3ced310b1)
- Added missing with. [`b75e55d`](https://github.com/ImageMagick/ImageMagick/commit/b75e55dfb70e73cc00f483f4948bcfd8d71bc3e8)
- Removed path. [`e4309a1`](https://github.com/ImageMagick/ImageMagick/commit/e4309a1d953b68e77b9656372c10599afef2f222)
- laterst automake/autoconf update [`86d58bd`](https://github.com/ImageMagick/ImageMagick/commit/86d58bd3f2fcd894e0a8462d881de2733a236162)
- fix compiler warning [`f8385a0`](https://github.com/ImageMagick/ImageMagick/commit/f8385a023acaeb8ad28fe61d8d6b086691304d4a)
- use old-style comment declarations [`1cf7450`](https://github.com/ImageMagick/ImageMagick/commit/1cf745032c50c262fcab13bdad9ef6b14991ebc6)
- off-by-one fix [`79a386b`](https://github.com/ImageMagick/ImageMagick/commit/79a386b12e7ec1f417785e33992e7b3a5f66872e)
- ensure we don't dereference null pointer [`c0bf80d`](https://github.com/ImageMagick/ImageMagick/commit/c0bf80de0534e62eddaaeb1ccdc386573f8e5319)
- unecessary check for null [`2a782eb`](https://github.com/ImageMagick/ImageMagick/commit/2a782ebe0729899389d93ffa2aa80053f79dc03f)
- release [`aa6e7e5`](https://github.com/ImageMagick/ImageMagick/commit/aa6e7e5f36d298cd2cb8962b559d36ce5fd218ba)

## [7.1.0-30](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-29...7.1.0-30) - 2022-04-16

### Merged

- fix #5033: runtime error: load of misaligned address [`#5034`](https://github.com/ImageMagick/ImageMagick/pull/5034)

### Fixed

- fix #5033: runtime error: load of misaligned address (#5034) [`#5033`](https://github.com/ImageMagick/ImageMagick/issues/5033) [`#5033`](https://github.com/ImageMagick/ImageMagick/issues/5033)

### Commits

- https://github.com/ImageMagick/ImageMagick/discussions/4861 [`347b828`](https://github.com/ImageMagick/ImageMagick/commit/347b82801da2b0223a4de34d6c30123041061c2b)
- prep next release [`ff88d9d`](https://github.com/ImageMagick/ImageMagick/commit/ff88d9dbb7df4bbb322755f2d68ca4ca42f6709d)
- limit trim to a minimum size [`32fa9ae`](https://github.com/ImageMagick/ImageMagick/commit/32fa9aecffb8de26ecbee27b857d29b2215e713c)
- do not set ICC properties unless the value is non-null [`052cb94`](https://github.com/ImageMagick/ImageMagick/commit/052cb94517a1fcf4d8e1f21c2bb1340417b19177)
- eliminate arbitrary limit on CMS descriptions [`bff8264`](https://github.com/ImageMagick/ImageMagick/commit/bff82645de30f053da7396c8b6f71d8eef27f608)
- Removed unused setter. [`a41d6d1`](https://github.com/ImageMagick/ImageMagick/commit/a41d6d1a87e547e41e826cb173eaff7846e42d42)
- Moved variable definition. [`a92f1c0`](https://github.com/ImageMagick/ImageMagick/commit/a92f1c0689ba4527149e60ae1afcd0e23b11b951)
- Improved freetype error reporting (#4997). [`e18b283`](https://github.com/ImageMagick/ImageMagick/commit/e18b2839e1e39a9081750514b9515964c3737abe)
- read HEIF from file rather than memory [`7ef309b`](https://github.com/ImageMagick/ImageMagick/commit/7ef309b6e091b0b3a5f2fc803efce5ae86d045a4)
- Added missing version check. [`5d003d9`](https://github.com/ImageMagick/ImageMagick/commit/5d003d90e828f7374069969bc10a2f08147232a2)
- Corrected check. [`e61eaf4`](https://github.com/ImageMagick/ImageMagick/commit/e61eaf4cda034d7ad5d99e82e72557e8f35c35ce)
- Use different naming convention. [`9661fa0`](https://github.com/ImageMagick/ImageMagick/commit/9661fa011f6a95a0fedfe24454fddbfee44d6896)
- Improved set_file_timestamp on Windows. [`59d1c9a`](https://github.com/ImageMagick/ImageMagick/commit/59d1c9a4ff060cd7070b95d45aff618090d7d114)
- Corrected multiplication. [`5c99efd`](https://github.com/ImageMagick/ImageMagick/commit/5c99efdf48f14caf4ce03064c35cc3a69b786177)
- Code style changes. [`13b4e4a`](https://github.com/ImageMagick/ImageMagick/commit/13b4e4aad6e7dc0f3dea088a6395e2b5859680e6)
- Use sizeof instead. [`769b275`](https://github.com/ImageMagick/ImageMagick/commit/769b275bdbecf77631495967382e9c5170038c76)
- Restored check that was added in #3137. [`9643c4a`](https://github.com/ImageMagick/ImageMagick/commit/9643c4a57f6dfc6badd7cd2ff10a4069f1b536d5)
- Whitespace. [`f5a909d`](https://github.com/ImageMagick/ImageMagick/commit/f5a909dff47488a0b68dc25aad822ff79dca76e4)
- HEIC container must be a seekable file on disk [`19e645e`](https://github.com/ImageMagick/ImageMagick/commit/19e645eba81385fc9ee46337c013960719dd8ddf)
- check for empty string not required [`017d17f`](https://github.com/ImageMagick/ImageMagick/commit/017d17f8c26d21e405dd02159911921656b4ffd1)
- check to see if ICC property exists before its created [`8f8db6b`](https://github.com/ImageMagick/ImageMagick/commit/8f8db6bc26668552d7f07d587dedb36439fa9dab)
- revert [`001f2d0`](https://github.com/ImageMagick/ImageMagick/commit/001f2d053da663719b3cd9166631ba87e6e4056f)
- do not permit setting read-only properties (e.g. exif:*) [`e3c4d3f`](https://github.com/ImageMagick/ImageMagick/commit/e3c4d3fb16fd1fcf4fbc692b3c0c480c7032a054)
- support 6 channel cmyka + metachannel images [`fa0e7bf`](https://github.com/ImageMagick/ImageMagick/commit/fa0e7bf41ae8362216b180c33c3f152805374b05)
- respect the mask when computing the FFT similarity [`695acbc`](https://github.com/ImageMagick/ImageMagick/commit/695acbc66f4bba7a910d9e8e3d74d88bca3438ec)
- mention multistrectral imagery [`d2b6318`](https://github.com/ImageMagick/ImageMagick/commit/d2b6318e9095f19de92dca33efe754055845473f)
- missing case for -read-mask option [`5ecbd67`](https://github.com/ImageMagick/ImageMagick/commit/5ecbd67179fd9a4faf6bc3327e02ed80b6368675)
- revert [`99d530c`](https://github.com/ImageMagick/ImageMagick/commit/99d530cd8de8e98ba88d20453b3dafa06ce2bf35)
- bypass FFT compare when mask is defined [`c5b8a8e`](https://github.com/ImageMagick/ImageMagick/commit/c5b8a8e9c42a3ec0e482c11326a29b52367f5c67)
- fix unknown size compiler exception [`8f3936f`](https://github.com/ImageMagick/ImageMagick/commit/8f3936f6ffb52a176d9847642ecdee8fd6f24e98)
- cast to eliminate possible data loss error [`0ae1a49`](https://github.com/ImageMagick/ImageMagick/commit/0ae1a49f2b62ac6d4a44fc7890d0099d0b6f19de)
- generalize multispectral support [`914c2e8`](https://github.com/ImageMagick/ImageMagick/commit/914c2e86b4e088c4f5ecbc5bebd6ea96215a53b9)
- eliminate compiler warning [`4576d73`](https://github.com/ImageMagick/ImageMagick/commit/4576d732f2fe107c9f9035d822d21fa58b10545f)
- generalize multispectral support [`101e955`](https://github.com/ImageMagick/ImageMagick/commit/101e955b4bf42e41ed2c56370d4d73cbbc20b4c1)
- add multispectral support to the MIFF format [`8fbf695`](https://github.com/ImageMagick/ImageMagick/commit/8fbf695f3ebe89058d3444c6440405a085a47a29)
- quiet compiler warnings [`db6bfc4`](https://github.com/ImageMagick/ImageMagick/commit/db6bfc410a1bfe050af83d70a11b30af2b1cb24e)
- evolve multispectral image support [`e31b13c`](https://github.com/ImageMagick/ImageMagick/commit/e31b13c7497fa9b16fc051624747ac69f203f195)
- eliminate compiler exception [`469219c`](https://github.com/ImageMagick/ImageMagick/commit/469219cc87137ce38c5408b6774caa24c6095e9a)
- do not attempt to write a null image list (thanks to Vinay Rohila) [`716496e`](https://github.com/ImageMagick/ImageMagick/commit/716496e6df0add89e9679d6da9c0afca814cfe49)
- https://github.com/ImageMagick/ImageMagick/issues/5010 [`41019b0`](https://github.com/ImageMagick/ImageMagick/commit/41019b04aef823de19d2c331927fa21f477a851e)
- Update SECURITY.md [`6708d4f`](https://github.com/ImageMagick/ImageMagick/commit/6708d4f2f577dcc835779df5c6f28732ccba44e0)
- Reverse loop to "fix" compiler optimization bug on arm64 Linux. [`1350b58`](https://github.com/ImageMagick/ImageMagick/commit/1350b58867213c1c30d200e137b894f93b53c31a)
- https://github.com/ImageMagick/ImageMagick/issues/5008 [`7e36bce`](https://github.com/ImageMagick/ImageMagick/commit/7e36bce9e429604a633b921b01d26ebab00e5578)
- TXT format supports multispectral images [`a107b94`](https://github.com/ImageMagick/ImageMagick/commit/a107b94135aab17f22a8181f1a0809f79969f6b4)
- Fixed build errors. [`4f3d080`](https://github.com/ImageMagick/ImageMagick/commit/4f3d0804a8c961da75c38df46984c413ac6e8f66)
- Lab colorspace survives a round-trip [`6eb56b8`](https://github.com/ImageMagick/ImageMagick/commit/6eb56b86f2c38cfbeabcc5aae218c359a9492d91)
- eliminate compiler warning [`f51ac93`](https://github.com/ImageMagick/ImageMagick/commit/f51ac93840a3a8ff2ece5e73e9d40145a5e644ef)
- longitude requires minor version 20 [`46df306`](https://github.com/ImageMagick/ImageMagick/commit/46df30643ab464f61533d9e36dcd828f616e30f0)
- https://github.com/ImageMagick/ImageMagick/pull/5034 [`940b133`](https://github.com/ImageMagick/ImageMagick/commit/940b133b15d6c653c3270eeedc55cdf9cb9cdfe1)
- alpha_trait should be set, otherwise the alpha value will not be used. [`90f788f`](https://github.com/ImageMagick/ImageMagick/commit/90f788f71026d54a7220ac4cc934cf0081296c62)
- https://github.com/ImageMagick/ImageMagick/issues/5028 [`ebea37d`](https://github.com/ImageMagick/ImageMagick/commit/ebea37d8e3282fc53a5a88493921505106e363e5)
- https://github.com/ImageMagick/ImageMagick/issues/5027 [`6516558`](https://github.com/ImageMagick/ImageMagick/commit/6516558cc6ad2ed72fafb9cf0825c8406d701d86)
- pending release [`196b8b0`](https://github.com/ImageMagick/ImageMagick/commit/196b8b054c9b02b5a8b133027d9e9f9d24f148e0)
- Use -define connected-components:sort=area | width | height | x | y to sort the verbose connected components objects. By default, the objects are listed in decreasing area. Add -define connected-components:sort-order=increasing | decreasing to specify the sort order. [`41d9d59`](https://github.com/ImageMagick/ImageMagick/commit/41d9d592f1e2411032d47cb8b11c24f6d92bf68f)
- eliminate compiler warning [`3366885`](https://github.com/ImageMagick/ImageMagick/commit/3366885064260cfdf2104943336ee12f459d4f60)
- eliminate compiler warning [`89527f6`](https://github.com/ImageMagick/ImageMagick/commit/89527f67d4f43bf632ae491b1ac50d7a16983bfa)
- forgot to include "static.h" header [`93b59d6`](https://github.com/ImageMagick/ImageMagick/commit/93b59d632ef989825d415726eb597de3dcdbfe39)
- fix Coverity defects [`c8ca79e`](https://github.com/ImageMagick/ImageMagick/commit/c8ca79e569f50b88d04ee78ad7b060bbdf6d0c91)
- future: throw an exception if type cache cannot be acquired [`0903518`](https://github.com/ImageMagick/ImageMagick/commit/0903518d5fafcb58a66a3745f65c07a1256d2d1a)
- eliminate Coverity defects [`a564acf`](https://github.com/ImageMagick/ImageMagick/commit/a564acf287b19b000ab276bf05d6b05d4ea9ecfe)
- eliminate Coverity defects [`de80673`](https://github.com/ImageMagick/ImageMagick/commit/de806730111e471eba40164823ad21e18632bd7c)
- ... [`91c6c53`](https://github.com/ImageMagick/ImageMagick/commit/91c6c5300f0c6eba01f2e5a01de83d00c65d0f11)
- eliminate Coverity defects [`34a91f0`](https://github.com/ImageMagick/ImageMagick/commit/34a91f0c742b5d5f3791842e0dc0e2192e8cfbd1)
- eliminate Coverity defects [`a744181`](https://github.com/ImageMagick/ImageMagick/commit/a744181f6284c594bcfdbc1e9f8e70aca53bff0a)
- streaming interface must be allocated on the heap [`dc5116f`](https://github.com/ImageMagick/ImageMagick/commit/dc5116fb171f35ab3c6a1e027687e971a72d097e)
- fix memory leak in Freetype streaming interface [`d8c2b0c`](https://github.com/ImageMagick/ImageMagick/commit/d8c2b0cb6da671ba238e1b733b85e1a221cb0c88)
- eliminate Coverity defects [`9ee5a2e`](https://github.com/ImageMagick/ImageMagick/commit/9ee5a2e7321244abaa161954fa054fd2ff06927d)
- revert [`daa64a9`](https://github.com/ImageMagick/ImageMagick/commit/daa64a9d74298f1093c23147cd02e73df160ffcd)
- eliminate Coverity defect [`62f3f3a`](https://github.com/ImageMagick/ImageMagick/commit/62f3f3a08ff8dea7117b657db54321ea8430bd73)
- utilitze fstat() blocksize to set stream buffer size [`ff0734c`](https://github.com/ImageMagick/ImageMagick/commit/ff0734c8940d1da8562d421bcd8f600a81ed720a)
- revert [`4433872`](https://github.com/ImageMagick/ImageMagick/commit/443387288bb40a7e56de5bcb87bba630a16f736f)
- eliminate Coverity defects [`6b15959`](https://github.com/ImageMagick/ImageMagick/commit/6b15959d781808e3b6e8f1f3c4acbb73e6e0a1c9)
- eliminate leak in Freetype streaming interface [`e0a9b4d`](https://github.com/ImageMagick/ImageMagick/commit/e0a9b4dbae2f99d0d5efdce8e240cca7215e9460)
- prevent double free in Freetype streaming interface [`f12746c`](https://github.com/ImageMagick/ImageMagick/commit/f12746c6ad365311b5c1d7ce3ee755b31f24de7d)
- eliminate Coverity defects [`3a256ce`](https://github.com/ImageMagick/ImageMagick/commit/3a256ce9002ebfb88da77f415869f9f81f4d4187)
- fix fill-opacity special case where the fill color alpha is fully transparent [`1835ba8`](https://github.com/ImageMagick/ImageMagick/commit/1835ba84863b088f50db5e074835bca84868c9c4)
- eliminate Coverity defect [`0ef3f01`](https://github.com/ImageMagick/ImageMagick/commit/0ef3f0122fcb538392f0fad352480b336c65bc4d)
- eliminate Coverity defects [`781a886`](https://github.com/ImageMagick/ImageMagick/commit/781a8861e443b028477793d50406557bbee0451f)
- Always use IsGrayColorspace. [`c154ffe`](https://github.com/ImageMagick/ImageMagick/commit/c154ffef2f360efd56712212a85208f39f11a0b7)
- release [`8e8a7ce`](https://github.com/ImageMagick/ImageMagick/commit/8e8a7ceba8ba57f6867947a16bfab319ca47c993)

## [7.1.0-29](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-28...7.1.0-29) - 2022-03-27

### Merged

- Remove unused EXPLICIT_TEMPLATE_INSTANTIATION [`#4982`](https://github.com/ImageMagick/ImageMagick/pull/4982)
- Fixes #4985: 4e+26 is outside the range of representable values of type 'unsigned long' at coders/pcl.c:299 [`#4986`](https://github.com/ImageMagick/ImageMagick/pull/4986)

### Fixed

- Fixes #4985: 4e+26 is outside the range of representable values of type 'unsigned long' at coders/pcl.c:299 (#4986) [`#4985`](https://github.com/ImageMagick/ImageMagick/issues/4985)

### Commits

- ... [`280e7e6`](https://github.com/ImageMagick/ImageMagick/commit/280e7e6c2183a534efdf08db225dfa21350f0403)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=45887 [`96ae906`](https://github.com/ImageMagick/ImageMagick/commit/96ae9066b001ff951c6a3c936081bacfaa69935f)
- https://github.com/ImageMagick/ImageMagick/issues/4972 [`ffc2aaa`](https://github.com/ImageMagick/ImageMagick/commit/ffc2aaae543dcd60c6cc7e5a426f66dbc51df560)
- https://github.com/ImageMagick/ImageMagick/issues/4974 [`c871830`](https://github.com/ImageMagick/ImageMagick/commit/c8718305f120293d8bf13724f12eed885d830b09)
- https://github.com/ImageMagick/ImageMagick/issues/4975 [`44cb819`](https://github.com/ImageMagick/ImageMagick/commit/44cb81933777a199b9209d89a72fd2acf202d5de)
- latest changes [`2bfd2be`](https://github.com/ImageMagick/ImageMagick/commit/2bfd2beb581bbfd242ff7dd20a15dc602a154014)
- https://github.com/ImageMagick/ImageMagick/issues/4936 [`83b114f`](https://github.com/ImageMagick/ImageMagick/commit/83b114f7ae99561d9c6abc67ab11c50f9d547655)
- https://github.com/ImageMagick/ImageMagick/issues/4936 [`000557d`](https://github.com/ImageMagick/ImageMagick/commit/000557da249fa36ad8111c312cb43f179a1f7070)
- enforce one `id` per MIFF image [`966a769`](https://github.com/ImageMagick/ImageMagick/commit/966a769a646aaaeff127862b8e475297bf5058d3)
- revert [`96162eb`](https://github.com/ImageMagick/ImageMagick/commit/96162ebad2f05140a0d899b46a3e5dec9d4005f2)
- latest changelog [`d1d344b`](https://github.com/ImageMagick/ImageMagick/commit/d1d344b0ac1b5e98955009d57ed7f6954b54afcf)
- reset id [`83de35d`](https://github.com/ImageMagick/ImageMagick/commit/83de35d0ab6e5100450d604bf300670af7e1b3e8)
- reset id [`a4736b4`](https://github.com/ImageMagick/ImageMagick/commit/a4736b4577b45def91148a4e5e71d8d4151ff96f)
- over allocate quantum pixel buffer [`219d19f`](https://github.com/ImageMagick/ImageMagick/commit/219d19f96e6a87b17ab26dfa6eadc7ad3169092a)
- https://github.com/ImageMagick/ImageMagick/issues/4987 [`25309b9`](https://github.com/ImageMagick/ImageMagick/commit/25309b9772d72072f8574352968aeca7134ba433)
- no suitable delegate utility for CGM or FIG formats [`004fc5d`](https://github.com/ImageMagick/ImageMagick/commit/004fc5d725fa2dc395391d1ac65f815823595189)
- https://github.com/ImageMagick/ImageMagick/issues/4988 [`ca3654e`](https://github.com/ImageMagick/ImageMagick/commit/ca3654ebf7a439dc736f56f083c9aa98e4464b7f)
- cosmetic [`e36bd84`](https://github.com/ImageMagick/ImageMagick/commit/e36bd84b0935b204a27a05aa041dfea6faf25099)
- cosmetic [`2c35b9a`](https://github.com/ImageMagick/ImageMagick/commit/2c35b9a24bd6abf17b1f135ced20611f4ad7fa17)
- account for case where gray image is imported as RGBA [`22cfaf3`](https://github.com/ImageMagick/ImageMagick/commit/22cfaf35dcea6d07e5353660794edca16b363c6b)
- speculative allocation since we don't yet know the quantum type [`bd77531`](https://github.com/ImageMagick/ImageMagick/commit/bd77531ae8dd24adb583f87e7c0b73c306ac64cc)
- pending release [`8be1086`](https://github.com/ImageMagick/ImageMagick/commit/8be1086bee313dfcfe014e3c60197bf0b636776f)
- revert [`ab39cc4`](https://github.com/ImageMagick/ImageMagick/commit/ab39cc4abe3510b31d9e3dafe8a3b898ce627605)
- set quantum extent [`c909df1`](https://github.com/ImageMagick/ImageMagick/commit/c909df15fc9e55b99c9d4480d4ed48a141fb943b)
- revert [`cb65691`](https://github.com/ImageMagick/ImageMagick/commit/cb656913eb12c67f3d8a3098635e239c3d94bf18)
- pending release [`a6551b2`](https://github.com/ImageMagick/ImageMagick/commit/a6551b2514ecf294c7ee11841d1e0b665fbbc7a8)
- release [`4c0b7d2`](https://github.com/ImageMagick/ImageMagick/commit/4c0b7d25daf11131af48820b2aa6cc0b1cf11a9e)

## [7.1.0-28](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-27...7.1.0-28) - 2022-03-20

### Merged

- Fix setting the pixel intensity method with SetImageProperty [`#4969`](https://github.com/ImageMagick/ImageMagick/pull/4969)
- fix issue: outside the range of representable values of type 'unsigned int' at coders/psd.c:1025 [`#4963`](https://github.com/ImageMagick/ImageMagick/pull/4963)

### Commits

- ... [`daef664`](https://github.com/ImageMagick/ImageMagick/commit/daef66469b28411755b42f000daa5c1dceec8697)
- export libjxl version # [`4f15721`](https://github.com/ImageMagick/ImageMagick/commit/4f15721bb54adf029a3e6d2b44ec674a4ccbbcbf)
- support grayscale and linear colorspaces [`298ac0b`](https://github.com/ImageMagick/ImageMagick/commit/298ac0bf3b2a00a4eda82934b6aae48e564ee7c5)
- Restore dds:compression=dxt5 behavior [`7dcb23a`](https://github.com/ImageMagick/ImageMagick/commit/7dcb23a29c6b1110c2c29f9862cf39b502a98982)
- set pixel format in image out block [`e709dbf`](https://github.com/ImageMagick/ImageMagick/commit/e709dbf20aa1d025bfcf9bbe463ece3aa2f02125)
- improve checking for conditional function arguments [`a1d46a8`](https://github.com/ImageMagick/ImageMagick/commit/a1d46a8566c5fb79583e82fec3a561402ff9cec1)
- https://github.com/ImageMagick/ImageMagick/issues/4927 [`d8624b4`](https://github.com/ImageMagick/ImageMagick/commit/d8624b4611882b4e15be6c22d306d56f1914056f)
- https://github.com/ImageMagick/ImageMagick/issues/4927 [`7441e31`](https://github.com/ImageMagick/ImageMagick/commit/7441e318c500975be5d55378e37c2f4695f0b864)
- no need to check for &lt; 0 [`69f805b`](https://github.com/ImageMagick/ImageMagick/commit/69f805b22c8c24fcd7c75587a0ad2fd53740dbb8)
- coders: sync JXL output [`9ca56be`](https://github.com/ImageMagick/ImageMagick/commit/9ca56be04a4229105e9cd20ccde47528a048f80f)
- Changed the format of MAGICK_GIT_REVISION and use this in -version. [`a7c4ca3`](https://github.com/ImageMagick/ImageMagick/commit/a7c4ca34d4e6670b3741027c2ad6dde931c92871)
- Corrected name of the define. [`dfaeb2e`](https://github.com/ImageMagick/ImageMagick/commit/dfaeb2e05707f9bd4cff0cbdc4778b3bdb2b001f)
- Corrected date format. [`a6f7e16`](https://github.com/ImageMagick/ImageMagick/commit/a6f7e1627f54cf08c883ec83988db424ff914fe0)
- regenerate compare docs [`f9d988b`](https://github.com/ImageMagick/ImageMagick/commit/f9d988b415174751c3efd7acb4d8b3231d465572)
- correct date format [`301a801`](https://github.com/ImageMagick/ImageMagick/commit/301a8014ffe901739e20ef08098bb54120243cdc)
- Coders: https://github.com/ImageMagick/ImageMagick/issues/4947 [`8043433`](https://github.com/ImageMagick/ImageMagick/commit/8043433ba9ce0c550e09f2b3b6a3f5f62d802e6d)
- Coders: proper check for out of bounds per https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=45640 [`ea43d4b`](https://github.com/ImageMagick/ImageMagick/commit/ea43d4b023e7b2fdbf8ff6d6fb23e7dd91add4c3)
- Coders: https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=42549 [`a81927b`](https://github.com/ImageMagick/ImageMagick/commit/a81927b4801ffe7b2168c39588a3043d26d70df2)
- Coders: eliminate compiler warnings [`8ed4f9a`](https://github.com/ImageMagick/ImageMagick/commit/8ed4f9a8d722e70d6072c374d4dccc9b5da50057)
- Coders: cosmetic [`0dadfa7`](https://github.com/ImageMagick/ImageMagick/commit/0dadfa75c7fa54f57d771f6c6f97b969863d2601)
- Coders: PS and EPS %%BoundingBox not being parsed #4961 [`35fdd9f`](https://github.com/ImageMagick/ImageMagick/commit/35fdd9f89aca2f8ec6c7b770641e0c5c2853eb47)
- Coders: support 10-bit AVIF per https://github.com/ImageMagick/ImageMagick/discussions/4932 [`418e3f4`](https://github.com/ImageMagick/ImageMagick/commit/418e3f40dc7302dae664eaaf0ea4cd4b7b59f852)
- MagickCore: cosmetic [`08e77d2`](https://github.com/ImageMagick/ImageMagick/commit/08e77d21968bd9c7374692b46af51cd7a1ff1e3b)
- MagickCore: support getentropy() [`b1027c8`](https://github.com/ImageMagick/ImageMagick/commit/b1027c855af1c8c29e07217b9216b1743d8004e0)
- build: release [`1627727`](https://github.com/ImageMagick/ImageMagick/commit/16277279886c57325d874e1acce04d979172a304)
- getentropy() requires sys/random.h include [`b62bc9d`](https://github.com/ImageMagick/ImageMagick/commit/b62bc9dc24e6c59db3a3185b87def27ff02789d3)
- pending release [`b83772f`](https://github.com/ImageMagick/ImageMagick/commit/b83772f8cdc35f27aa669c9e15eb6b8ad0f98786)

## [7.1.0-27](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-26...7.1.0-27) - 2022-03-04

### Commits

- ... [`fe3a627`](https://github.com/ImageMagick/ImageMagick/commit/fe3a627b4a9f9c15ef8d34daefc08f5471681f4a)
- cosmetic [`c1fe09e`](https://github.com/ImageMagick/ImageMagick/commit/c1fe09e3533d2b778f45d49f243e210dcb915cc7)
- https://github.com/ImageMagick/ImageMagick/issues/4870 [`eb08826`](https://github.com/ImageMagick/ImageMagick/commit/eb0882667cddc4ea71b61a583a782c430220faf4)
- https://github.com/ImageMagick/ImageMagick/issues/4876 [`17b8572`](https://github.com/ImageMagick/ImageMagick/commit/17b85720f0685d83797c3925a866f42971c23713)
- ... [`d2ad523`](https://github.com/ImageMagick/ImageMagick/commit/d2ad523daad137e04a148e0ab15fe044393206aa)
- canonical copyright notice [`cd32501`](https://github.com/ImageMagick/ImageMagick/commit/cd32501e861b3755c116baa47fa879323e11cffd)
- https://github.com/ImageMagick/ImageMagick/issues/966 [`f6db6e0`](https://github.com/ImageMagick/ImageMagick/commit/f6db6e06dfabe0412d61b433b89efe5ad58d9b21)
- escape \n character [`624e514`](https://github.com/ImageMagick/ImageMagick/commit/624e5144d9b76789b51c8c24e002ea2c854bc406)
- https://github.com/ImageMagick/ImageMagick/issues/966 [`5c23779`](https://github.com/ImageMagick/ImageMagick/commit/5c2377996445ce1c3be00e78a08afde131fb813d)
- https://github.com/ImageMagick/ImageMagick/issues/4888 [`5512240`](https://github.com/ImageMagick/ImageMagick/commit/5512240ff88749d9450d51aa977969a9ad321d6c)
- https://github.com/ImageMagick/ImageMagick/issues/4888 [`2fa2184`](https://github.com/ImageMagick/ImageMagick/commit/2fa218431d622f33da90a79c1a2f5f5750710fdc)
- https://github.com/ImageMagick/ImageMagick/issues/966 [`62a3cd5`](https://github.com/ImageMagick/ImageMagick/commit/62a3cd54416c067da75be895a27362a01aaebdc8)
- throw exception on reserved filename character (\xff) [`ee80bac`](https://github.com/ImageMagick/ImageMagick/commit/ee80bacc9d4c36c0405a46cd555e953a40fd129e)
- https://github.com/ImageMagick/ImageMagick/issues/4896 [`14a8a35`](https://github.com/ImageMagick/ImageMagick/commit/14a8a358452405e99dfa52e799ed37c02db316e6)
- auto-generate the change log from git commits [`67bc403`](https://github.com/ImageMagick/ImageMagick/commit/67bc40387b9270e28f911199bac2de577f828b42)
- ... [`165327a`](https://github.com/ImageMagick/ImageMagick/commit/165327a5247525ccd0bea04b88114df86896cfee)
- Changed trigger for release. [`ccff96d`](https://github.com/ImageMagick/ImageMagick/commit/ccff96dfb318c906a396681a0dbfa12b08e1e90f)
- ChangeLog =&gt; ChangeLog.md [`0b5cb6e`](https://github.com/ImageMagick/ImageMagick/commit/0b5cb6edef00d63af0904dbd955cb57f186f7e9f)
- improve "geometry does not contain image" exception message [`28be54d`](https://github.com/ImageMagick/ImageMagick/commit/28be54df1dbf9726ff9dd257955a1a78470e76f4)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`4b1dc4c`](https://github.com/ImageMagick/ImageMagick/commit/4b1dc4cb1e91af85f5cf05da92588da7696ce3ed)
- https://github.com/ImageMagick/ImageMagick/discussions/4862 [`9d74db9`](https://github.com/ImageMagick/ImageMagick/commit/9d74db9c45eb207c6c9d3f1ac762d05f0ae3bf86)
- proper check for libjxl minimum version [`ccf788b`](https://github.com/ImageMagick/ImageMagick/commit/ccf788bd768a2ff75bb529d39bdcdfbeadeede23)
- include reference to JXL coder source module [`18f7a0a`](https://github.com/ImageMagick/ImageMagick/commit/18f7a0afba8374f6b52053a383101d36aef0dab6)
- https://github.com/ImageMagick/ImageMagick/issues/4874 [`3630e5c`](https://github.com/ImageMagick/ImageMagick/commit/3630e5c63e6188d037fd225d4073b001275dc830)
- Fixed memory leak in ThumbnailImage. [`47fed11`](https://github.com/ImageMagick/ImageMagick/commit/47fed11f7bae354cb40f1805aa9707faf593438c)
- Code style changes. [`161b2bd`](https://github.com/ImageMagick/ImageMagick/commit/161b2bdc8221078fb84119fd64be9376979d5819)
- More code style changes. [`0d2723e`](https://github.com/ImageMagick/ImageMagick/commit/0d2723e796313a72aceb73784d6d203c1bdfb477)
- Use RegEnumValueW instead. [`bfad2a3`](https://github.com/ImageMagick/ImageMagick/commit/bfad2a34d6fdcabda36cff83e49fe5320804dc9d)
- Code style changes. [`fbb2bad`](https://github.com/ImageMagick/ImageMagick/commit/fbb2bad1388403d617fc87d72254ad86534de4a7)
- Only set system_root_length once. [`6fe9a5f`](https://github.com/ImageMagick/ImageMagick/commit/6fe9a5fe6e2ce2c8faccd6f2e609222ade42ac75)
- Removed one of the buffers. [`3be14c7`](https://github.com/ImageMagick/ImageMagick/commit/3be14c7f5b2ac83e078471e96a8fc393869f8c3e)
- The value is also utf8 when RegEnumValueW is used. [`9954343`](https://github.com/ImageMagick/ImageMagick/commit/995434350c3ac84cfeaaad0eeeb00483a0030110)
- pending release [`b7174d2`](https://github.com/ImageMagick/ImageMagick/commit/b7174d211065e5b794cdb5ebc72f317124b2cd47)
- Corrected adjoin check. [`ffaf35e`](https://github.com/ImageMagick/ImageMagick/commit/ffaf35e7dce75cf5492308ff90b1a38228e5c0bf)
- pending release [`dc2b955`](https://github.com/ImageMagick/ImageMagick/commit/dc2b9553e9b1e73ce264f41e5820a236db7403fd)

## [7.1.0-26](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-25...7.1.0-26) - 2022-02-21

### Merged

- Appropriate default kmin, kmax values for lossy and lossless into webp encoder [`#4846`](https://github.com/ImageMagick/ImageMagick/pull/4846)

### Commits

- ... [`702d55a`](https://github.com/ImageMagick/ImageMagick/commit/702d55a87c2b6dc5052a9a71bbbeba2b0b2fc619)
- https://github.com/ImageMagick/ImageMagick/issues/4761 [`35b2e14`](https://github.com/ImageMagick/ImageMagick/commit/35b2e14d82ae87fe97b2a0e3f49cdd19d82c8f06)
- https://github.com/ImageMagick/ImageMagick/discussions/4755 [`0101c29`](https://github.com/ImageMagick/ImageMagick/commit/0101c2901a8c0922ef0dba06dca446efe38d8dd1)
- Added option to allow specifying -dShowAnnots=false. [`60e8f2c`](https://github.com/ImageMagick/ImageMagick/commit/60e8f2ce8bdf0822cd59e1f898a984d79ef50690)
- https://github.com/ImageMagick/ImageMagick/issues/4843 [`17eaebd`](https://github.com/ImageMagick/ImageMagick/commit/17eaebd2c1ffb42c1b1b5b17c2db12e19ec69d30)
- ... [`31720fe`](https://github.com/ImageMagick/ImageMagick/commit/31720fee01114d59f6122ae2251f1452e0e9b67f)
- Removed the xtrn coder. [`6a863cc`](https://github.com/ImageMagick/ImageMagick/commit/6a863ccebb6d777739fb8d9b5b3b78c868dafb82)
- Removed xtrn coder. [`0d1b03d`](https://github.com/ImageMagick/ImageMagick/commit/0d1b03d3176d47e6f2e512bdc7968a9fa153189a)
- ... [`c2617e9`](https://github.com/ImageMagick/ImageMagick/commit/c2617e9a8de9e4a3c481956d647e12f09cec97f0)
- fix compiler exception under Cygwin [`ee54f8d`](https://github.com/ImageMagick/ImageMagick/commit/ee54f8dcf76a6c82b741cfdf8e0a7b4558671c9d)
- remove reference to ImageMagickObject [`a7141eb`](https://github.com/ImageMagick/ImageMagick/commit/a7141eb10579909e1bf5070ebaf700182cbcf25a)
- remove references to ImageMagickObject [`ccb6b35`](https://github.com/ImageMagick/ImageMagick/commit/ccb6b35068bfc9bdc7da309d8985cfd6644f8e71)
- ... [`f43aa87`](https://github.com/ImageMagick/ImageMagick/commit/f43aa87b45ac36dae42a33457603f2d67e5c4fbd)
- pending release [`aa668b2`](https://github.com/ImageMagick/ImageMagick/commit/aa668b23d9f4804fe47761bb4ed65b6877cc0914)
- Raise exception when image could not be read but no exception was raised. [`f939c22`](https://github.com/ImageMagick/ImageMagick/commit/f939c225f2a62e4ba2d8d449f7ffa514a9aac500)
- Changed copyright. [`05b88b4`](https://github.com/ImageMagick/ImageMagick/commit/05b88b46eac5f8929e3461e86748474d98c2e7ab)
- Changed copyright. [`0efff06`](https://github.com/ImageMagick/ImageMagick/commit/0efff06599dc6d08c30ec19a79c494d2a6607846)
- Removed NTGhostscriptDLL and NTGhostscriptLoadDLL from the private header. [`c27d494`](https://github.com/ImageMagick/ImageMagick/commit/c27d494351fcb8e5f1f69cceff27824122c4d0a2)
- Fixes for installation in a folder that contains non ASCII characters (#4382). [`9928afc`](https://github.com/ImageMagick/ImageMagick/commit/9928afc2c123f2be6720f5aaa5931978e6ca2e2e)
- off-by-one fix [`352a9ab`](https://github.com/ImageMagick/ImageMagick/commit/352a9ab54ef228553d793c148c717d9f0beac864)
- don't over-allocate thread-specific data [`7ff4ae1`](https://github.com/ImageMagick/ImageMagick/commit/7ff4ae104a9710407786c14223001ad4176d1331)
- pending release [`893aea3`](https://github.com/ImageMagick/ImageMagick/commit/893aea3e3d8a102036e67cc0d97e351d69e5b6f6)
- no need for conditional compile [`57be678`](https://github.com/ImageMagick/ImageMagick/commit/57be6784c1bea811aa35199f56e5cec9777946f0)
- rename method to TLS-moniker, thread local storage [`5775664`](https://github.com/ImageMagick/ImageMagick/commit/5775664a028c8fdd9fe9d99a4628d08ec57f424c)
- Use MagickBooleanType instead. [`fc3c6fb`](https://github.com/ImageMagick/ImageMagick/commit/fc3c6fbed9ba036bc3227b80a8ac36d30abbbedf)
- Removed unnecessary initialization. [`51cbb7d`](https://github.com/ImageMagick/ImageMagick/commit/51cbb7d8d8ceb70b111dee0a8d1cfe58a7914233)
- cosmetic [`f3a4813`](https://github.com/ImageMagick/ImageMagick/commit/f3a48131fad4067240698714eba044ca78236c8c)
- cosmetic [`6f6caf2`](https://github.com/ImageMagick/ImageMagick/commit/6f6caf214b9cbfd008a8712a501a1e3e6a83b832)
- https://github.com/ImageMagick/ImageMagick/discussions/4859 [`c1304c0`](https://github.com/ImageMagick/ImageMagick/commit/c1304c02317ba992dde535314c459ced1a463848)
- https://github.com/ImageMagick/ImageMagick/discussions/4856 [`717546e`](https://github.com/ImageMagick/ImageMagick/commit/717546e1e02660f471bd53bf6a5f83e62ff08f8c)
- pending release [`1363b1e`](https://github.com/ImageMagick/ImageMagick/commit/1363b1e1e27aac515305f0979541e23c0716932b)
- adjust -extent geometry support for &lt; && &gt; [`3db22d0`](https://github.com/ImageMagick/ImageMagick/commit/3db22d038089abfdd3bff3ca4f0edc9158ac57e5)
- https://github.com/ImageMagick/ImageMagick/discussions/4856 [`66cb4f9`](https://github.com/ImageMagick/ImageMagick/commit/66cb4f91bc09b645f0ce3824a8469718d0cbc761)
- pending release [`50b7ec5`](https://github.com/ImageMagick/ImageMagick/commit/50b7ec519c4f07ffd8eb80fdd0aaa00d0e82b6d6)
- add strimg image format [`86b1eb4`](https://github.com/ImageMagick/ImageMagick/commit/86b1eb465afe7be1de3a6baf16c535118855a22c)
- pending release [`0c5784d`](https://github.com/ImageMagick/ImageMagick/commit/0c5784d96b39e3ea78105b595dab1342bb963799)
- https://github.com/ImageMagick/ImageMagick/issues/4865 [`63a25b5`](https://github.com/ImageMagick/ImageMagick/commit/63a25b5f4f5c70a00b330c6fc36133903774752c)
- pending release [`a6458f9`](https://github.com/ImageMagick/ImageMagick/commit/a6458f9b8b5805bab5ff781c3ae22baa05cd8494)
- https://github.com/ImageMagick/ImageMagick/issues/4864 [`3663328`](https://github.com/ImageMagick/ImageMagick/commit/3663328cd031976250bb06cdcd78c1bdffbfe8b8)
- pending release [`4dfd217`](https://github.com/ImageMagick/ImageMagick/commit/4dfd21705173d2a6e3ca4b0a6723a6e1f48ef885)
- https://github.com/ImageMagick/ImageMagick/issues/4867 [`da3971c`](https://github.com/ImageMagick/ImageMagick/commit/da3971cb2ecde8856358e2221aec5b924467ef85)
- pending release [`78680f5`](https://github.com/ImageMagick/ImageMagick/commit/78680f51e98d6aecf25b0d9951de3d8122d3b871)

## [7.1.0-25](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-24...7.1.0-25) - 2022-02-15

### Commits

- ... [`191fd98`](https://github.com/ImageMagick/ImageMagick/commit/191fd9864aa54bde02bf1863bc306fbe24843f64)
- Corrected copyright header. [`678fb88`](https://github.com/ImageMagick/ImageMagick/commit/678fb8880e29819d30e5e35b73eafddc9cd9b461)
- Corrected length check. [`a563804`](https://github.com/ImageMagick/ImageMagick/commit/a5638045db7c13d2e8a86e51a4b339080f03d5cc)
- Added missing copyright and header. [`de8c61d`](https://github.com/ImageMagick/ImageMagick/commit/de8c61dc8d2492219397c312653128109d3c7c1f)
- Corrected header style. [`18f5a8f`](https://github.com/ImageMagick/ImageMagick/commit/18f5a8fca87fb6dbb204e1c62a426df61842e055)
- Removed unused binary. [`a83ebfc`](https://github.com/ImageMagick/ImageMagick/commit/a83ebfcaf3eb79fa846718af70df6b978c8ed946)
- Corrected header. [`8960f4d`](https://github.com/ImageMagick/ImageMagick/commit/8960f4d9433627848550f86cecedbad6f5bd4a34)
- Changed copyright headers. [`3ddbe16`](https://github.com/ImageMagick/ImageMagick/commit/3ddbe16bbe136160f4bbff3804a8423816974e57)
- https://github.com/ImageMagick/ImageMagick/issues/4822 [`111d4e4`](https://github.com/ImageMagick/ImageMagick/commit/111d4e4aae5b27bff8a9028b2ad230bc89a57039)
- one off when debugging [`869315d`](https://github.com/ImageMagick/ImageMagick/commit/869315df81a6c70f339e58e55eccef7c4fb19cc7)
- display last debugging character [`7fd967e`](https://github.com/ImageMagick/ImageMagick/commit/7fd967ef5e60ac3a814a3b34fc87c48c59dae3a9)
- alpha is never zero [`8d33dd8`](https://github.com/ImageMagick/ImageMagick/commit/8d33dd8dd63729d0cb9ceb7432cadeca69beab17)
- Removed unnecessary variable. [`6b246ff`](https://github.com/ImageMagick/ImageMagick/commit/6b246ffd6e4c92076c44a75c77d535f861368074)
- https://github.com/ImageMagick/ImageMagick/issues/4837 [`a833062`](https://github.com/ImageMagick/ImageMagick/commit/a8330620ca1695f35bd8a8b07245b78cbe21880b)
- revert [`7d5e159`](https://github.com/ImageMagick/ImageMagick/commit/7d5e159ed8872c1ce51f1b89b4027689fb80e3a0)
- cosmetic [`0e22666`](https://github.com/ImageMagick/ImageMagick/commit/0e2266611121c1eab597a5051fd4cb37d5300e2d)
- off-by-one fix [`56f1643`](https://github.com/ImageMagick/ImageMagick/commit/56f1643600448447dbdb6c03716ec9474153c43b)
- fix unitialized value [`1931a77`](https://github.com/ImageMagick/ImageMagick/commit/1931a7732fb7488d1c7d992ccdb1dffd026aeb5d)
- https://github.com/ImageMagick/ImageMagick/issues/4841 [`0fec6dc`](https://github.com/ImageMagick/ImageMagick/commit/0fec6dca6c990038c7f275f04b3e6829c9aea95a)
- off-by-one fix [`7f7c905`](https://github.com/ImageMagick/ImageMagick/commit/7f7c90526187ddd560d2a511cde2d9b9acef4fb1)
- Removed ImageMagickObject because we no longer support this. [`61dcc55`](https://github.com/ImageMagick/ImageMagick/commit/61dcc55d596e8e241841cb3b9088fd9f55a154e7)
- pending release [`14e94c3`](https://github.com/ImageMagick/ImageMagick/commit/14e94c311502613805a8973de2dc1d6958858d80)

## [7.1.0-24](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-23...7.1.0-24) - 2022-02-12

### Commits

- ... [`8c52d6f`](https://github.com/ImageMagick/ImageMagick/commit/8c52d6fa50d7c39ea4446d416640e29dada61996)
- eliminate compiler warning [`0595255`](https://github.com/ImageMagick/ImageMagick/commit/0595255bde9edab97da3331f90b7489bc92ca6dc)
- Changed copyright headers. [`2056a1f`](https://github.com/ImageMagick/ImageMagick/commit/2056a1f77255bd551926f18ec321063d5c2ee195)
- Changed copyright headers. [`67beeff`](https://github.com/ImageMagick/ImageMagick/commit/67beeff5d03c194d0c846632c124905a56324625)
- Added copyright headers. [`78e4a56`](https://github.com/ImageMagick/ImageMagick/commit/78e4a56a833cd64f1676bf54847409cae1debaf4)
- Removed reverences to travis. [`aa1806d`](https://github.com/ImageMagick/ImageMagick/commit/aa1806d1f437958cd847692d3c781bdd4c9a22e2)
- possible performance optimization [`4a8a0d4`](https://github.com/ImageMagick/ImageMagick/commit/4a8a0d4f26b828532f266143d9dd3b8ca6fb52ac)
- cosmetic [`68eb33f`](https://github.com/ImageMagick/ImageMagick/commit/68eb33f7660a78ff22daec7a60265db15e3e46fe)
- Fixed build error. [`15f9463`](https://github.com/ImageMagick/ImageMagick/commit/15f9463eed4b4affd9dd3031d00e86c8f6b4753d)
- Removed unused flags. [`73b1d1d`](https://github.com/ImageMagick/ImageMagick/commit/73b1d1d2d45566f69697e0402508d73946c45359)
- optimize reading of XPM properties [`f578dad`](https://github.com/ImageMagick/ImageMagick/commit/f578dad6151beb51747e7928770975ccddf064b6)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=44457 [`a9bd4c0`](https://github.com/ImageMagick/ImageMagick/commit/a9bd4c0e16d034f733c93d5d1b022f9e5f78e70e)
- revert [`503333f`](https://github.com/ImageMagick/ImageMagick/commit/503333f87ae676f5e327d83e10def04b3ecee5ab)
- https://github.com/ImageMagick/ImageMagick/discussions/4813 [`cadfcdd`](https://github.com/ImageMagick/ImageMagick/commit/cadfcdd11829197ed415177ef00a61921add7345)
- Removed empty header file. [`f5f9030`](https://github.com/ImageMagick/ImageMagick/commit/f5f90302c9d3fd9a987fda8f8cddbd6ede4cf697)
- Removed method that has been renamed. [`f8a1cf9`](https://github.com/ImageMagick/ImageMagick/commit/f8a1cf9eae09a52a63609bcacfa3c36bbf6cd4ac)
- Removed RIFF header to avoid issues with WEBP images (#4819). [`4c156f2`](https://github.com/ImageMagick/ImageMagick/commit/4c156f21b3f6ece862b85bdef6062b6bfd1d7c71)
- Removed IsAVI check (#4819). [`a1c342c`](https://github.com/ImageMagick/ImageMagick/commit/a1c342c04916670b4a1f161a29d24e9c04c4108d)
- prefer performance over quality [`75d1dbf`](https://github.com/ImageMagick/ImageMagick/commit/75d1dbf70f63ae365e3359d4b8c473a546d68bca)
- Changed copyright headers. [`8891ec1`](https://github.com/ImageMagick/ImageMagick/commit/8891ec1db10a70558deef45f61941b4fe0576b66)
- cosmetic [`4f923a8`](https://github.com/ImageMagick/ImageMagick/commit/4f923a83f2acf86eb56399442223513dcd2aa503)
- invalid free memory on NULL pointer [`4b03774`](https://github.com/ImageMagick/ImageMagick/commit/4b0377467fb3e1864ccd91c54393ca5d9bdeb3db)
- https://github.com/ImageMagick/ImageMagick/issues/4822 [`acc0934`](https://github.com/ImageMagick/ImageMagick/commit/acc0934a25ca392823d3d90febeb093c4ce9f2f0)
- remove debugging statement [`e69f2b1`](https://github.com/ImageMagick/ImageMagick/commit/e69f2b1413f1a9f2d5518aad13debacbe5b32195)
- https://github.com/ImageMagick/ImageMagick/issues/4828 [`3e2b04a`](https://github.com/ImageMagick/ImageMagick/commit/3e2b04a63c564aa4f2ce1da45a7346a59d15c0a2)
- prevent integer overflow [`32ce1ca`](https://github.com/ImageMagick/ImageMagick/commit/32ce1ca9b0746a592461e2cafc134d7a3eecbe54)
- Corrected UTF-16 big endian encoding (#4771). [`1d8b675`](https://github.com/ImageMagick/ImageMagick/commit/1d8b67552892fd3f1342a31f189305fb6b073165)
- Code style changes. [`1b9c0c9`](https://github.com/ImageMagick/ImageMagick/commit/1b9c0c96e41e48dd26ed2ebbaac36382d249ae96)
- Set the alpha_trait of the pixel in the colormap. [`07559b5`](https://github.com/ImageMagick/ImageMagick/commit/07559b540a0c3311bebe8a6948492fcf0101f06b)
- Also set the colorspace in the colormap. [`2ec7d4c`](https://github.com/ImageMagick/ImageMagick/commit/2ec7d4cbf8b7d13a2a0afe12e1af3df8cb59b51a)
- Use GetPixelInfo instead. [`3eb643b`](https://github.com/ImageMagick/ImageMagick/commit/3eb643b7fe36d4a5200afe1e11e79dab48ddc5c4)
- https://github.com/ImageMagick/ImageMagick/issues/4830 [`b3fc034`](https://github.com/ImageMagick/ImageMagick/commit/b3fc034f37ffe46c8314fae42acbd6c6a11b9da5)
- remove debugging statement [`38a2625`](https://github.com/ImageMagick/ImageMagick/commit/38a2625f094c42ac1c62ace34b5c560b8dbfd026)
- update copyright year [`80629df`](https://github.com/ImageMagick/ImageMagick/commit/80629dfb3fea55eefa2dd8bdd9ca1be341502e16)
- correct copyright year [`2652397`](https://github.com/ImageMagick/ImageMagick/commit/26523979fc9cb29e586b3e668e1fc6e075fc235e)
- pending release [`e5eed1c`](https://github.com/ImageMagick/ImageMagick/commit/e5eed1ca1a43df880c8a851a1c49b3cbb31510b1)

## [7.1.0-23](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-22...7.1.0-23) - 2022-02-05

### Merged

- Make MagickSet/GetSamplingFactors() use ':' instead of ',' [`#4794`](https://github.com/ImageMagick/ImageMagick/pull/4794)

### Commits

- check if image extent is NaN [`94650bc`](https://github.com/ImageMagick/ImageMagick/commit/94650bc4f10a5bb49e16c0f766adcb0db5f04a41)
- ... [`419dd8d`](https://github.com/ImageMagick/ImageMagick/commit/419dd8de4432beafd827339ca0595895db8ce032)
- apply the Fx expression to each image in the sequence [`c516ca8`](https://github.com/ImageMagick/ImageMagick/commit/c516ca8d21c1c2b6b0223b259cfc1f572d343e99)
- exit MVG parser realy if clipping path fails to render [`a628a09`](https://github.com/ImageMagick/ImageMagick/commit/a628a0918de7fa4c54fb84c036775ed6d92d84a8)
- ... [`4b4f4c3`](https://github.com/ImageMagick/ImageMagick/commit/4b4f4c381367a83f03959493be622b77abd9117c)
- avoid deep recursion [`a42870a`](https://github.com/ImageMagick/ImageMagick/commit/a42870a846d9471ac696475cc3aaabea8c76d6d5)
- cosmetic [`3fbdf95`](https://github.com/ImageMagick/ImageMagick/commit/3fbdf95d043aed30d7a6aa4fd9b3f68519f3c49f)
- ... [`51f487a`](https://github.com/ImageMagick/ImageMagick/commit/51f487aaab80518d5f601002bd818e8588b6b439)
- small memory leak if images exceed list length [`ce5c2b1`](https://github.com/ImageMagick/ImageMagick/commit/ce5c2b1847cbc90df68b0985cb99e3cf5f852813)
- https://github.com/ImageMagick/ImageMagick/issues/4790 [`b51707c`](https://github.com/ImageMagick/ImageMagick/commit/b51707c08f3dee192d464d38fc507c86051e62e6)
- https://github.com/ImageMagick/ImageMagick/issues/4793 [`6d69fce`](https://github.com/ImageMagick/ImageMagick/commit/6d69fceff3d6a30d8c7a1b7fd6702d9febcf9bd7)
- Use read_info instead of image_info. [`b38ab1e`](https://github.com/ImageMagick/ImageMagick/commit/b38ab1e28668bbfb7f39373f05b4906ae66b93ef)
- Corrected setting delay instead. [`2adce17`](https://github.com/ImageMagick/ImageMagick/commit/2adce170469980ba2b0d4f33947fa6be3495e732)
- Parse the image info once for all the frames. [`2488fc5`](https://github.com/ImageMagick/ImageMagick/commit/2488fc552ea38f34d7b5463cc81769f50dabff71)
- Corrected copy paste mistake. [`c9e20a4`](https://github.com/ImageMagick/ImageMagick/commit/c9e20a4623da788cc2f3f3c316e9456fb7aec41d)
- Renamed struct. [`49edbf0`](https://github.com/ImageMagick/ImageMagick/commit/49edbf034d00512a5e2022cf12d46ff1baf13586)
- Moved sync of orientation to a separate method. [`c3839eb`](https://github.com/ImageMagick/ImageMagick/commit/c3839ebf2fa4d75d8899e68acab892953f8cf553)
- Added extra option to also disable syncing from tiff. [`59ccfd7`](https://github.com/ImageMagick/ImageMagick/commit/59ccfd7425f367c53e9aeb0c7cfbde820086f2f7)
- Moved setting the resolution info from the exif/tiff properties to a separate method. [`7df7426`](https://github.com/ImageMagick/ImageMagick/commit/7df7426ad3a5f7753198fded7d22603370987c03)
- Moved declaration of variables. [`1980a3b`](https://github.com/ImageMagick/ImageMagick/commit/1980a3b0faa63159b19a3ba769dbc5f94a886d38)
- Code style change. [`a6c2928`](https://github.com/ImageMagick/ImageMagick/commit/a6c292867872458731a827dc42aaeb4006a086fd)
- The properties can only be deleted after they have been used. [`715cf34`](https://github.com/ImageMagick/ImageMagick/commit/715cf341e699bf928d06e23c2964c3d5b5122471)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=44401 [`a987a8a`](https://github.com/ImageMagick/ImageMagick/commit/a987a8ae4b7e7a1c0f3fc14f53ebbce86230ca47)
- https://github.com/ImageMagick/ImageMagick/issues/4807 [`d61dd34`](https://github.com/ImageMagick/ImageMagick/commit/d61dd34fe01ee2c48d81932124e1a913ed477c89)
- https://github.com/ImageMagick/ImageMagick/issues/4807 [`9492d1f`](https://github.com/ImageMagick/ImageMagick/commit/9492d1faaee3adeaa270428814844bc72f16f200)
- pending release [`48edb6a`](https://github.com/ImageMagick/ImageMagick/commit/48edb6a2b5e6771354284870667ce0d9c379e6c5)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=44424 [`7069862`](https://github.com/ImageMagick/ImageMagick/commit/70698622896fc9b045527740952b4627a352e119)
- release [`038f317`](https://github.com/ImageMagick/ImageMagick/commit/038f31702e52b5c87254e96b10cb1490d92152a0)

## [7.1.0-22](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-21...7.1.0-22) - 2022-01-29

### Commits

- bump patch level version [`d2ce572`](https://github.com/ImageMagick/ImageMagick/commit/d2ce5721f36572fb80c7a4df8ccec83a399f15ee)
- check for excessive color name length [`d3b7cdb`](https://github.com/ImageMagick/ImageMagick/commit/d3b7cdbecc0bca9a4eba59e7837830e8acd0b0e9)
- restore MPRI URI [`9651500`](https://github.com/ImageMagick/ImageMagick/commit/9651500e10cb2f7dcf014b2d244753988817ad0b)
- pending release [`3eb8a9b`](https://github.com/ImageMagick/ImageMagick/commit/3eb8a9b78e03510542f7d8a7e4d77fd7055d12da)
- Corrected MPRI fix. [`2c2d1d8`](https://github.com/ImageMagick/ImageMagick/commit/2c2d1d842845a85933c5bbd8b269e305cabdc130)
- Only check the path when filename is specified. [`417f4fb`](https://github.com/ImageMagick/ImageMagick/commit/417f4fb9cef7b37aafccd686efd3635202b33d9a)
- permit compositing MPRI images [`5aaf162`](https://github.com/ImageMagick/ImageMagick/commit/5aaf16278f79d2c4e51fd9b75cbe198b8949c407)
- permit compositing MPRI images [`cb0ac90`](https://github.com/ImageMagick/ImageMagick/commit/cb0ac90228fdc388cbb724ca68f9afc3619a3d05)
- pending release [`c10371d`](https://github.com/ImageMagick/ImageMagick/commit/c10371db6c8363d76f204877110d1d0980502ce8)

## [7.1.0-21](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-20...7.1.0-21) - 2022-01-28

### Merged

- msl coder: add support for autoorient [`#4745`](https://github.com/ImageMagick/ImageMagick/pull/4745)

### Commits

- It's a new dawn; It's a new day; It's a new life; For ImageMagick [`03ddd19`](https://github.com/ImageMagick/ImageMagick/commit/03ddd19cfd5a3937aecef34e2173f47c9f2f4825)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=43967 [`2df3d01`](https://github.com/ImageMagick/ImageMagick/commit/2df3d0124b6e1b12c01421c1d5ed60143125af5f)
- https://github.com/ImageMagick/ImageMagick/discussions/4533#discussioncomment-20 [`ae90a62`](https://github.com/ImageMagick/ImageMagick/commit/ae90a6229bc6216a728879b18d11c01e34bdbf0a)
- Cleanup file to use our coding style. [`9b3f50f`](https://github.com/ImageMagick/ImageMagick/commit/9b3f50f6664be6568e47a83a6ac1e5f9b487332b)
- Added missing version check. [`7cc55cc`](https://github.com/ImageMagick/ImageMagick/commit/7cc55cc5e5a666e17287c81e2f40d1b79be410f4)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`4c96061`](https://github.com/ImageMagick/ImageMagick/commit/4c960619700ed551d92bc137df4c60c83699866c)
- ... [`7ba9959`](https://github.com/ImageMagick/ImageMagick/commit/7ba995934e985d22340fddcfc79767d95291c93b)
- eliminate compiler warning [`03470b4`](https://github.com/ImageMagick/ImageMagick/commit/03470b4bf61f4805668812d78df83fdfb8c53bc5)
- Silenced warning. [`df88116`](https://github.com/ImageMagick/ImageMagick/commit/df88116c3eea2f7e3ba073570cb5573c57186ad7)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`a0b049f`](https://github.com/ImageMagick/ImageMagick/commit/a0b049ff449a3b2f8a673b97d77ea7458b580df6)
- check for excessive memory request when drawing [`1496901`](https://github.com/ImageMagick/ImageMagick/commit/1496901aea4d6de5bc5c1051a423e95a80d77995)
- for debug(), print channels in array style, e.g. [1] [`2cee06e`](https://github.com/ImageMagick/ImageMagick/commit/2cee06e61fd6a104c7a386775e769c79f2176169)
- https://github.com/ImageMagick/ImageMagick/issues/4766 [`62845d5`](https://github.com/ImageMagick/ImageMagick/commit/62845d5672eca4446b952dd0ab2e3e0dab0309d4)
- https://github.com/ImageMagick/ImageMagick/issues/4761 [`cdb8e3f`](https://github.com/ImageMagick/ImageMagick/commit/cdb8e3f6e5b2268621ae1317addc7941676a9aab)
- promote blocksize from int to ssize_t [`7347fb3`](https://github.com/ImageMagick/ImageMagick/commit/7347fb36cafe764d9d67c66adf3d80a6c784d22e)
- pending release [`2b1d06d`](https://github.com/ImageMagick/ImageMagick/commit/2b1d06d650782c55263ff5bbb8aad65b45775b97)
- https://github.com/ImageMagick/ImageMagick/issues/4771 [`e035b46`](https://github.com/ImageMagick/ImageMagick/commit/e035b46ae5802754075b9abd7aa577d1006ab545)
- pending release [`622ed89`](https://github.com/ImageMagick/ImageMagick/commit/622ed89edc6d1e38025a72df388f0845fa5e8da6)
- PDF unicode title [`f084a86`](https://github.com/ImageMagick/ImageMagick/commit/f084a86ecaf9737af86f242d68d5e9cf25a61144)
- pending release [`ddc7540`](https://github.com/ImageMagick/ImageMagick/commit/ddc75409693fa681446d39e2cf9929780631e848)

## [7.1.0-20](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-19...7.1.0-20) - 2022-01-22

### Merged

- Fix wrong logic when compare two float values with '==" directly [`#4723`](https://github.com/ImageMagick/ImageMagick/pull/4723)
- Support 'msf1' support in heic.c [`#4701`](https://github.com/ImageMagick/ImageMagick/pull/4701)
- QOI fixes [`#4665`](https://github.com/ImageMagick/ImageMagick/pull/4665)
- Added support for QOI format [`#4653`](https://github.com/ImageMagick/ImageMagick/pull/4653)

### Commits

- ... [`bc39ec6`](https://github.com/ImageMagick/ImageMagick/commit/bc39ec6f0c977dfd2a6aacc334e4143f56e97dd3)
- improved fix for possible DoS for certain SVG constructs [`f460242`](https://github.com/ImageMagick/ImageMagick/commit/f4602423ad9dc1f1b70f3b851c867925cab7d17c)
- cosmetic [`1b697c4`](https://github.com/ImageMagick/ImageMagick/commit/1b697c46834bf3ca227161f1001e763a5f5c5419)
- Fixed Windows build. [`966d7ca`](https://github.com/ImageMagick/ImageMagick/commit/966d7cafa9e17750511de1f372de044be0cc987b)
- Silenced warning. [`29bb2fb`](https://github.com/ImageMagick/ImageMagick/commit/29bb2fb0917d7b72dc3b62d4fe6d716d96fc496e)
- Added checks for invalid PSD channel size. [`7adbd99`](https://github.com/ImageMagick/ImageMagick/commit/7adbd9998130d5d3014bd6a3ed58d93f24b06987)
- ... [`d63614b`](https://github.com/ImageMagick/ImageMagick/commit/d63614b163aba55e2cc8edd738cbc63df473bb39)
- permit 4GB blocks [`c05a26d`](https://github.com/ImageMagick/ImageMagick/commit/c05a26d41177de18191ce595f78d0d64e573a9d3)
- https://github.com/ImageMagick/ImageMagick/issues/4629 [`6221134`](https://github.com/ImageMagick/ImageMagick/commit/62211342165a1179af752818764944c917c7de26)
- ... [`ebfd707`](https://github.com/ImageMagick/ImageMagick/commit/ebfd707c2a442fbe3b1c4aa15fbf4e8a73af742b)
- Silenced warnings. [`075565e`](https://github.com/ImageMagick/ImageMagick/commit/075565e93c71bcaaabf0ce70b7d1060bccdf0020)
- https://github.com/ImageMagick/ImageMagick/issues/4639 [`de0e304`](https://github.com/ImageMagick/ImageMagick/commit/de0e304d9ca8c6d0365692e26ea0cef4d4f7d02c)
- support seamless blending of a foreground and background image [`104fede`](https://github.com/ImageMagick/ImageMagick/commit/104fede6e66a2af7ff45ee07d318cd49ca073e0c)
- Added missing SeamlessBlendCompositeOp. [`45f37ad`](https://github.com/ImageMagick/ImageMagick/commit/45f37ad1ae7eaf3a1fd12306c7b87c0bbcb8735a)
- cosmetic [`3d8da65`](https://github.com/ImageMagick/ImageMagick/commit/3d8da65b5ac16d730fdd3f6ebbfbce91262e8026)
- ... [`17c52a2`](https://github.com/ImageMagick/ImageMagick/commit/17c52a2e28d702c5d0aa1b3d90c9d2f7511e7a53)
- change default iterations and residual threshold [`f24cbc8`](https://github.com/ImageMagick/ImageMagick/commit/f24cbc8017c4a79f18c701f708b1c391ebe1be31)
- Silenced warnings. [`27c7eed`](https://github.com/ImageMagick/ImageMagick/commit/27c7eedcb0f287d6cbeea20969e78227954d54c9)
- Fixed build. [`6888325`](https://github.com/ImageMagick/ImageMagick/commit/6888325d8673aa33b312d2f4dff3146ada1b6ed6)
- Added method to make it more clear why we have a quantum depth check. [`555ed1d`](https://github.com/ImageMagick/ImageMagick/commit/555ed1d6e0cc50e6c2fa697e7796a807bd27a2c7)
- Removed unnecessary backslash. [`ddda61c`](https://github.com/ImageMagick/ImageMagick/commit/ddda61cd9d5af6a54566db3ceb827af61016a97b)
- seamless blending requires the HDRI feature [`12db194`](https://github.com/ImageMagick/ImageMagick/commit/12db1942902aa2ec3c59e252806bb61623ed02df)
- support mask image for seamless blending [`d90a154`](https://github.com/ImageMagick/ImageMagick/commit/d90a154e9a6e557a8c211ece8ee60b9d8f2099b1)
- respect -verbose for seamless blending [`c6de626`](https://github.com/ImageMagick/ImageMagick/commit/c6de626f2c2ed6c829a3a87fb961838458c787d7)
- only print select iterations [`d307949`](https://github.com/ImageMagick/ImageMagick/commit/d3079499851338ad7c6b5f6365f90421d3840754)
- print last iteration residual [`9ef6c1c`](https://github.com/ImageMagick/ImageMagick/commit/9ef6c1cc35bfa2d53b5ccce37f5866ea5b866623)
- declaration hides previous local declaration [`22c7591`](https://github.com/ImageMagick/ImageMagick/commit/22c75910e8951328de801b2875b70b37ce5e6731)
- Fixed possible memory leak. [`19feb22`](https://github.com/ImageMagick/ImageMagick/commit/19feb22358570919e6fb5e28acd20c4dee19ad19)
- Removed unused variable. [`4048fd6`](https://github.com/ImageMagick/ImageMagick/commit/4048fd670ce5e5f3bef5a7bf6d2e16a22cefe266)
- don't blur the foreground object [`4719503`](https://github.com/ImageMagick/ImageMagick/commit/471950301a62ef7ac4a0de85817b238dd9beb9d1)
- ensure tick is at least 1 [`6dd4736`](https://github.com/ImageMagick/ImageMagick/commit/6dd4736658ca49b5195bfe22b9a6f6622d041d77)
- account for floating point when comparing alpha values [`8a4791c`](https://github.com/ImageMagick/ImageMagick/commit/8a4791c9840d1926c3ae7cbb81e8b996ee1d1e8c)
- seamless blending works for non-HRDI but is less effective [`04fe3b0`](https://github.com/ImageMagick/ImageMagick/commit/04fe3b0c862d3739193527042df6e9d6862551c2)
- Added missing typecast. [`e11ced0`](https://github.com/ImageMagick/ImageMagick/commit/e11ced0bdf1e3c9336394243e50c552e3b8ffb74)
- distinquish foreground object with read mask [`8940d00`](https://github.com/ImageMagick/ImageMagick/commit/8940d001988c0b92243411092a3d298c7438bb88)
- make const [`d914d77`](https://github.com/ImageMagick/ImageMagick/commit/d914d779f7ad3bc5db2533c6e103925dd933626e)
- thread seamless blending [`5eb6905`](https://github.com/ImageMagick/ImageMagick/commit/5eb6905d1b4e03c92e65bf22886ccc145f21c037)
- remove read mask [`88393c2`](https://github.com/ImageMagick/ImageMagick/commit/88393c22a3b17234fd76c0fe281d95e8a33f5f3e)
- sums require a double type [`b6d4849`](https://github.com/ImageMagick/ImageMagick/commit/b6d484960b84e0c31ba56bbd589c02b753086026)
- Set depth and colorspace before the width and height are checked. [`e67a3e2`](https://github.com/ImageMagick/ImageMagick/commit/e67a3e24f8f8c76f74af0ac539878c83a72f7265)
- Revert useless patch because the image will get destroyed. [`9de7a82`](https://github.com/ImageMagick/ImageMagick/commit/9de7a828e6a945a08fb1acbd3d40f4649aad0fa7)
- only mask portions of alpha channel [`7d87b21`](https://github.com/ImageMagick/ImageMagick/commit/7d87b215eca34dc4ce9ec6a0f1127f5885322eb7)
- https://github.com/ImageMagick/ImageMagick/issues/4654 [`e1cf544`](https://github.com/ImageMagick/ImageMagick/commit/e1cf544ecc7d34122f2a0d44f4eb4368dc37f3ae)
- https://github.com/ImageMagick/ImageMagick/issues/4649 [`9e492fa`](https://github.com/ImageMagick/ImageMagick/commit/9e492fa37cff83e9bb178633e84b1b49638b101a)
- https://github.com/ImageMagick/ImageMagick/pull/4653 [`57bc254`](https://github.com/ImageMagick/ImageMagick/commit/57bc2540bc42f4a05747a8bbf57c41609b091765)
- set proper type [`332418d`](https://github.com/ImageMagick/ImageMagick/commit/332418dd242c30ace1067bb977ceda999819e780)
- Fixed Windows build. [`566a4ca`](https://github.com/ImageMagick/ImageMagick/commit/566a4ca03c2353739deb75c9d3c20cbc336e658b)
- Update qoi header file. [`b7cec57`](https://github.com/ImageMagick/ImageMagick/commit/b7cec57ef3a11adf041073464f65a40a9b0f5061)
- Added missing comments and fixed the IsQOI implementation. [`98994d0`](https://github.com/ImageMagick/ImageMagick/commit/98994d0fd74014e81839b08f832c795d8532a0c9)
- Build ImageMagick on Windows with VisualStudio 2022 instead. [`7a16ce0`](https://github.com/ImageMagick/ImageMagick/commit/7a16ce07b57ddda9fc7643860069fe104e6a0f75)
- Try without the move. [`966be37`](https://github.com/ImageMagick/ImageMagick/commit/966be3715b1bea8194c9604cad4696bf9715c7c0)
- Added step to install InnoSetup. [`d4de816`](https://github.com/ImageMagick/ImageMagick/commit/d4de816bc1ba88a2dea9ba6beb9345b67da37c98)
- Updated link to ffmpeg version. [`e790aef`](https://github.com/ImageMagick/ImageMagick/commit/e790aef43efce1709559bf2f572b5155bdab8649)
- framework for saliency blending composite op [`e137239`](https://github.com/ImageMagick/ImageMagick/commit/e13723901f184a8cf1df8dc3c5859e8f4a901fc6)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=43390 [`fbbf013`](https://github.com/ImageMagick/ImageMagick/commit/fbbf013a252376e2afe4eaff6f00c5b3803fb505)
- Changed the build of configure to 64-bit. [`5f99f02`](https://github.com/ImageMagick/ImageMagick/commit/5f99f02fef37e8d04f90c30aab9c59c128d0fe46)
- infrastructure for saliency blending [`1b2ad4d`](https://github.com/ImageMagick/ImageMagick/commit/1b2ad4dee2a1c656b0dd1906f00e043e66c2edd8)
- https://github.com/ImageMagick/ImageMagick/issues/4679 [`50780da`](https://github.com/ImageMagick/ImageMagick/commit/50780da98acdb8b427bc589a6e3637308d7f9fd9)
- Style changes. [`d8aa7be`](https://github.com/ImageMagick/ImageMagick/commit/d8aa7be021d7700539e4f7528f417ed45bc2922a)
- revert composite masking change [`0c02614`](https://github.com/ImageMagick/ImageMagick/commit/0c026146f2de66641919976bafd02641592dba03)
- support saliency blend composite op [`ed1b215`](https://github.com/ImageMagick/ImageMagick/commit/ed1b215781d5a1202bfe3e068357a60e70e1974c)
- Silenced warning. [`26d792a`](https://github.com/ImageMagick/ImageMagick/commit/26d792a4de80a3a33ca1398b4ffb75e923efcd04)
- https://github.com/ImageMagick/ImageMagick/issues/4681 [`dc2f71d`](https://github.com/ImageMagick/ImageMagick/commit/dc2f71d3672c7fc8eaf22c6ca0a182a2dbed773a)
- ... [`11f1e07`](https://github.com/ImageMagick/ImageMagick/commit/11f1e07c09f68d678830a5fa09ec345f667825b6)
- https://github.com/ImageMagick/ImageMagick/issues/4689 [`4ff42a4`](https://github.com/ImageMagick/ImageMagick/commit/4ff42a4ca11b7cdfef58c25bc12e6b58b84a9c16)
- cosmetic [`6253a76`](https://github.com/ImageMagick/ImageMagick/commit/6253a76ab0bda5d5c1544ecda9db2b6f2726cb8e)
- support writing gray and colormapped images [`6fee782`](https://github.com/ImageMagick/ImageMagick/commit/6fee7820d3959196fe683112b075bd8da36b3df6)
- eliminate rare memory leak [`647d129`](https://github.com/ImageMagick/ImageMagick/commit/647d1294b47f6b79a5369b39a91a7e188e598445)
- revert [`86aa371`](https://github.com/ImageMagick/ImageMagick/commit/86aa371142b4c6b110acf88cbabb146513279a5c)
- set image type to linear or non-linear RGB before checking quantum type [`f718d82`](https://github.com/ImageMagick/ImageMagick/commit/f718d82aa82c623cbd4826c72308a35557efa6c9)
- ... [`64be892`](https://github.com/ImageMagick/ImageMagick/commit/64be8922ecae95888846dca0ec828e67aca46714)
- revert [`6bc980f`](https://github.com/ImageMagick/ImageMagick/commit/6bc980fece71145a001f5dc325a045f0de5736bc)
- style [`f7e6b23`](https://github.com/ImageMagick/ImageMagick/commit/f7e6b23f33320ccfb26a4da739fdf2349b6a7fe3)
- semaless blending requires we disable composite clamping [`a5aadc5`](https://github.com/ImageMagick/ImageMagick/commit/a5aadc523de40ea77f722747151a4e92d99f6c6d)
- check for runlength overrun [`4149bcd`](https://github.com/ImageMagick/ImageMagick/commit/4149bcde427b331fdfc2cb16c6ded991cd8315cc)
- ... [`20dbaa2`](https://github.com/ImageMagick/ImageMagick/commit/20dbaa2405fa184a818df70312838cfd52fb75fb)
- Added arm64 to the daily build on Windows. [`ce81f99`](https://github.com/ImageMagick/ImageMagick/commit/ce81f9963795802b9a730edd519ca4d67886fabe)
- Updated ChangeLog. [`d1131e6`](https://github.com/ImageMagick/ImageMagick/commit/d1131e6585c60a75f5c7c18273f5eb6e188453e6)
- Code style changes. [`a819f8e`](https://github.com/ImageMagick/ImageMagick/commit/a819f8efbe1a2b57eab3baee1171e11200e118dc)
- Moved ping exit. [`cb62455`](https://github.com/ImageMagick/ImageMagick/commit/cb62455a1d86b7cd13bb6fd3df29583f314caaef)
- composite crop with relaxed [`b119ff5`](https://github.com/ImageMagick/ImageMagick/commit/b119ff59ffcacb5480f97cd08f1ebf596324401f)
- destroy relaxed image [`5b645b6`](https://github.com/ImageMagick/ImageMagick/commit/5b645b61f8bd0c1e9301b250d87f714127636f77)
- https://github.com/ImageMagick/ImageMagick/issues/4704 [`14ee325`](https://github.com/ImageMagick/ImageMagick/commit/14ee32548b8f9143317ebc30436f7adfa7e42c78)
- ... [`ae109d4`](https://github.com/ImageMagick/ImageMagick/commit/ae109d4b44a2ddda160b1131a8e301f4a770a3a6)
- https://github.com/ImageMagick/ImageMagick/issues/4660 [`7fc7c5c`](https://github.com/ImageMagick/ImageMagick/commit/7fc7c5cb5461cb7588a9ce120b5da32f2af4a6fc)
- https://github.com/ImageMagick/ImageMagick/issues/4704 [`f524d98`](https://github.com/ImageMagick/ImageMagick/commit/f524d98a7693602d671af2d80be5a352d2e08f2d)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`1c5e6e1`](https://github.com/ImageMagick/ImageMagick/commit/1c5e6e1b80dacc6c7410ae464da440e6ed3ca5bc)
- cosmetic [`86142bd`](https://github.com/ImageMagick/ImageMagick/commit/86142bdc2932550ec121081ff0f3359a34cd15cc)
- https://github.com/ImageMagick/ImageMagick/discussions/4515 [`444045d`](https://github.com/ImageMagick/ImageMagick/commit/444045d683bc7fb26c9f912f67917c8149fa769b)
- ... [`69efcf8`](https://github.com/ImageMagick/ImageMagick/commit/69efcf81adc31bc52ff72f917586bd6313233502)
- Fixed build errors. [`67b7057`](https://github.com/ImageMagick/ImageMagick/commit/67b70572c269db276a04300145773063e41ccb67)
- revert for now [`57e0828`](https://github.com/ImageMagick/ImageMagick/commit/57e08283fb2f0498366f1c5fa01e9aeed3833af8)
- eliminate compiler warnings [`457ad2f`](https://github.com/ImageMagick/ImageMagick/commit/457ad2f58daf38a177ea6d08eff89afb17e27e01)
- the FLIF library is no longer being maintained, change to opt-in [`b31cab4`](https://github.com/ImageMagick/ImageMagick/commit/b31cab4783aa9c90124e04f4fd7b326335ff0447)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`9420e11`](https://github.com/ImageMagick/ImageMagick/commit/9420e11f33e7c5d4c64567b1c192bab14b5864a1)
- eliminate compiler warnings [`4f37566`](https://github.com/ImageMagick/ImageMagick/commit/4f37566212b7cd0dab0cd64df5b2666b2462e5a0)
- eliminate Windows compiler warnings [`72043e9`](https://github.com/ImageMagick/ImageMagick/commit/72043e927b891e301f447298802c5462f0b43904)
- Silenced warnings on Windows. [`31bf1f2`](https://github.com/ImageMagick/ImageMagick/commit/31bf1f23534892244c94c13cd7e3ed23091c5073)
- Raise exception instead of printing to stderr. [`58d1336`](https://github.com/ImageMagick/ImageMagick/commit/58d1336cce69f3202ca41e8889c59c9455afb3df)
- Removed printf to sderr. [`ded93a9`](https://github.com/ImageMagick/ImageMagick/commit/ded93a9e88b8b446abe4d9970fd672fcc80a5e04)
- Silenced warnings. [`3c3fa17`](https://github.com/ImageMagick/ImageMagick/commit/3c3fa171517119825ac65edc54db3f8df9bcf009)
- Removed unused call. [`6986984`](https://github.com/ImageMagick/ImageMagick/commit/698698484aed96d56a053f68106672d7eeb4dcbc)
- Added missing call to DestroyImageList. [`71e8cc6`](https://github.com/ImageMagick/ImageMagick/commit/71e8cc68420a9a4d236c9b3364eb8291ac5f3ce8)
- update built-in delegates [`91b5044`](https://github.com/ImageMagick/ImageMagick/commit/91b504436ea48f362137242dfb9ec90098fab04a)
- precedence bug, now fixed [`0d9b7a6`](https://github.com/ImageMagick/ImageMagick/commit/0d9b7a60617849f55014d619306dc34ae77eb062)
- https://github.com/ImageMagick/ImageMagick/security/code-scanning/38? [`0a0e0e4`](https://github.com/ImageMagick/ImageMagick/commit/0a0e0e44bd7e43c767ef594b9059a8c09c8a4943)
- eliminate "declaration of 'p' hides previous local declaration" warning [`def69fd`](https://github.com/ImageMagick/ImageMagick/commit/def69fd7bee47398269378be88d16e8be4328c7a)
- fix memory leak for empty Fx expression [`db160de`](https://github.com/ImageMagick/ImageMagick/commit/db160dea48c932241b084efe6421e07700066a34)
- Removed ImageMagickObject from the Windows installer. [`36ceca1`](https://github.com/ImageMagick/ImageMagick/commit/36ceca115c4042f1779db127f86f88b7e81b0d5d)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`f54aa4e`](https://github.com/ImageMagick/ImageMagick/commit/f54aa4e7ba8a8fb82d200844dc59804f5f6c8cbf)
- fix for divide by zero until snibgo settles on a solution [`bf5fccd`](https://github.com/ImageMagick/ImageMagick/commit/bf5fccd54a350da3b76826b42e3664adbb7e0926)
- add cast to avoid overflow [`40fd5db`](https://github.com/ImageMagick/ImageMagick/commit/40fd5dbf305e4d7b8ee268bb6f715e27843a0d2f)
- https://github.com/ImageMagick/ImageMagick/issues/4729 [`e50f19f`](https://github.com/ImageMagick/ImageMagick/commit/e50f19fd73c792ebe912df8ab83aa51a243a3da7)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`8d9268b`](https://github.com/ImageMagick/ImageMagick/commit/8d9268b8daf19842f62f5aa367efe7fba9f5afb5)
- zero papersize geometry [`a6e081b`](https://github.com/ImageMagick/ImageMagick/commit/a6e081bf73c54035e8aa7b08481ea5db446eeb47)
- AVIF is supported by the HEIC coder [`1b89b2b`](https://github.com/ImageMagick/ImageMagick/commit/1b89b2b729238758a98c596c256a1d5753fa5670)
- cosmetic [`f7c813e`](https://github.com/ImageMagick/ImageMagick/commit/f7c813e801a855b27c35bb956e6af5a2dad8dc27)
- https://github.com/ImageMagick/ImageMagick/discussions/4533#discussioncomment-2001819 [`2606211`](https://github.com/ImageMagick/ImageMagick/commit/260621179f340cd8be4c0251004061c2e861d26f)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`08cc32b`](https://github.com/ImageMagick/ImageMagick/commit/08cc32b451fb151bb41d026bffe39c9721a83657)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`12dc47a`](https://github.com/ImageMagick/ImageMagick/commit/12dc47a56b402472e018ca6710705132566c1dcc)
- eliminate warnings [`7399756`](https://github.com/ImageMagick/ImageMagick/commit/7399756302dedfcfdfc45d3f81edabc61658ee45)
- Added option to force using pam as the intermediate video format. [`4a0226a`](https://github.com/ImageMagick/ImageMagick/commit/4a0226a0b05795da1b9f018d4322c7aaf314e41b)
- https://github.com/ImageMagick/ImageMagick/discussions/4533#discussioncomment-2012423 [`d6b1d74`](https://github.com/ImageMagick/ImageMagick/commit/d6b1d74cbd6967e070ee5a614cc0b37dbfb4a662)
- add cast to eliminate splint warning [`2cd8407`](https://github.com/ImageMagick/ImageMagick/commit/2cd8407760811bf4e219a467a19b56f889416a5d)
- pending release [`9fe6b78`](https://github.com/ImageMagick/ImageMagick/commit/9fe6b787854b576a6502c0e103a686503d71d58b)
- Added move to use the installed version of Strawberry Perl instead. [`8d5921b`](https://github.com/ImageMagick/ImageMagick/commit/8d5921b11e7b4ba633a2d630d2bad6e8f3322dab)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`10ef22c`](https://github.com/ImageMagick/ImageMagick/commit/10ef22c64a1e7789fc03fa323823ed331d076de3)
- pending release [`660e30f`](https://github.com/ImageMagick/ImageMagick/commit/660e30fd68a24d677adfa0d462962298d6b9fe34)

## [7.1.0-19](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-18...7.1.0-19) - 2021-12-22

### Commits

- ... [`8a24e36`](https://github.com/ImageMagick/ImageMagick/commit/8a24e363687b2e9221eb06c90cf236a882f1ff82)
- support -integral option [`4928887`](https://github.com/ImageMagick/ImageMagick/commit/49288871f6f12d3f42ac32cc42835e24501740c7)
- ... [`95e02e5`](https://github.com/ImageMagick/ImageMagick/commit/95e02e562d728e23bdb058e38c6e2282f08e64d3)
- optimize [`a22aff9`](https://github.com/ImageMagick/ImageMagick/commit/a22aff94916cfcbf8f26c75096dcff2901b907df)
- pointer is const [`449bba2`](https://github.com/ImageMagick/ImageMagick/commit/449bba22b048ecdc91d7ea51df2dd0254ca63102)
- Set the colorspace after the width and height of the image have been checked. [`661eafd`](https://github.com/ImageMagick/ImageMagick/commit/661eafd82e0666dc983d0fcb26e9b6eda71fc695)
- check for unbalanced parenthesis [`e2ce775`](https://github.com/ImageMagick/ImageMagick/commit/e2ce77517df3cbe7e53cca5cb63125846646096a)
- https://github.com/ImageMagick/ImageMagick/issues/4626 [`d7f1b2b`](https://github.com/ImageMagick/ImageMagick/commit/d7f1b2b9b816baaa956381ff80c3b120e83faa95)
- pending release [`fe8039f`](https://github.com/ImageMagick/ImageMagick/commit/fe8039f5b40f8dde11a6524dc0530bfb785c5ee7)

## [7.1.0-18](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-17...7.1.0-18) - 2021-12-18

### Commits

- Add note to avoid confusion. [`2ee9473`](https://github.com/ImageMagick/ImageMagick/commit/2ee9473f35bbf5d42dd8e47e4d0d683eb5c7eda7)
- ... [`28c8f05`](https://github.com/ImageMagick/ImageMagick/commit/28c8f0508984cb3515bf74d6227097a9331d9ab7)
- https://github.com/ImageMagick/ImageMagick/security/code-scanning/31 [`e4c5667`](https://github.com/ImageMagick/ImageMagick/commit/e4c566742265eaa4f677dba53443e35a41ee7045)
- revert [`d173288`](https://github.com/ImageMagick/ImageMagick/commit/d173288bf5b8a3a466d2cd412090ebe569da53f8)
- Removed last line from the note. [`ff55679`](https://github.com/ImageMagick/ImageMagick/commit/ff55679c06a44c0e588d758e34ee0cd495f04a4c)
- Corrected the built-in video encoder and decoder. [`c51be1d`](https://github.com/ImageMagick/ImageMagick/commit/c51be1d973437666da9705d159d8d0aaa8c4ae61)
- Improved adjustment of page offset when resizing an image. [`0c4bc88`](https://github.com/ImageMagick/ImageMagick/commit/0c4bc88231fd1dc5eaa3861dbe3f3821497faf0a)
- improved adjustment of page offset when resizing an image [`ecb4ffa`](https://github.com/ImageMagick/ImageMagick/commit/ecb4ffaefbce69112097ecafef8f0e714dc0c3da)
- https://github.com/ImageMagick/ImageMagick/issues/4558 [`54c3203`](https://github.com/ImageMagick/ImageMagick/commit/54c32036e238d23197812fc93471f2886b72e27d)
- https://github.com/ImageMagick/ImageMagick/discussions/4580 [`86b8264`](https://github.com/ImageMagick/ImageMagick/commit/86b8264127054186cd38514d8e986bf848f2e9cd)
- Corrected method name. [`62001c3`](https://github.com/ImageMagick/ImageMagick/commit/62001c33f1f1568fa78fd422ca47399a4413e2f7)
- Swapped the Sync8BimProfile and the SyncExifProfile methods. [`dd26314`](https://github.com/ImageMagick/ImageMagick/commit/dd263149f709f1a8fe4e17e23fe6eb17f15dac04)
- Corrected typecast [`123b157`](https://github.com/ImageMagick/ImageMagick/commit/123b15740896247379d4202cfefa700f5f065fb1)
- Also sync the exif profile inside the 8bim profile. [`6ce6671`](https://github.com/ImageMagick/ImageMagick/commit/6ce66717d9e976ed947eeae7639d2a2e625a4c10)
- Added option to disabling synchronization of the image with the data from the exif profile. [`0d20e11`](https://github.com/ImageMagick/ImageMagick/commit/0d20e11dfb3776f099368b7bee84107b90a40e63)
- Removed typecast. [`5e25ac4`](https://github.com/ImageMagick/ImageMagick/commit/5e25ac4536df6603fe6ed57fa6a7497b3a8fb401)
- Don't use SetImageGray inside a coder but use a method for the coders only instead. [`98a14e0`](https://github.com/ImageMagick/ImageMagick/commit/98a14e0603299b83138dd4e5c1cdec8e89ce1b33)
- Restored debug message. [`6c7d62f`](https://github.com/ImageMagick/ImageMagick/commit/6c7d62f7dc40862730c2acc2fe9d2772573bf501)
- https://github.com/ImageMagick/ImageMagick/issues/4587 [`bd62b31`](https://github.com/ImageMagick/ImageMagick/commit/bd62b31c436a37f85458fc149b4867486ce147b2)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=42504 [`f74fefd`](https://github.com/ImageMagick/ImageMagick/commit/f74fefdb120cfe5c4357c5792fd716c95a1adbe0)
- ... [`53fb13e`](https://github.com/ImageMagick/ImageMagick/commit/53fb13e21b41877a2f1b5a9039e06c989fbc7995)
- pending release [`085d991`](https://github.com/ImageMagick/ImageMagick/commit/085d9911160ea304e4661fdd158f9933981d30f8)

## [7.1.0-17](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-16...7.1.0-17) - 2021-12-04

### Commits

- ... [`40189c3`](https://github.com/ImageMagick/ImageMagick/commit/40189c37f33b77df5970ddbba7560c596a61c877)
- Corrected the patch made in #4497. [`44cf75f`](https://github.com/ImageMagick/ImageMagick/commit/44cf75ff01a9c8f4accfbd630297a1aae1512ea9)
- https://github.com/ImageMagick/ImageMagick/issues/4501 [`f4375d0`](https://github.com/ImageMagick/ImageMagick/commit/f4375d0a48b89a5c7696d487bf12f363dae9dfa6)
- eliminate compiler exception [`90de0c0`](https://github.com/ImageMagick/ImageMagick/commit/90de0c000b08ee4618429221ab73caf8dfb83fe2)
- Corrected the check. [`0e417f4`](https://github.com/ImageMagick/ImageMagick/commit/0e417f477b5914308ce7e8de13a5c6e787a133d1)
- Corrected reading the next image. [`2b6531d`](https://github.com/ImageMagick/ImageMagick/commit/2b6531d36c68316211dfe89b1f99fe2dd07b0371)
- revert memory leak patch [`34266d6`](https://github.com/ImageMagick/ImageMagick/commit/34266d6acf9cd9a0f94175d39e92472fbd894c22)
- https://github.com/ImageMagick/ImageMagick/issues/4501 [`1e40102`](https://github.com/ImageMagick/ImageMagick/commit/1e40102cee6bea0a4252d5d44551129f59d991f2)
- Corrected argument. [`775c1bd`](https://github.com/ImageMagick/ImageMagick/commit/775c1bd2aef0bfee8c71f97dbaaab4472ca83250)
- https://github.com/ImageMagick/ImageMagick/issues/4501 [`9b817fb`](https://github.com/ImageMagick/ImageMagick/commit/9b817fbed41712afca743e78d7f1faedff1b6939)
- Use magick_unreferenced instead. [`264d486`](https://github.com/ImageMagick/ImageMagick/commit/264d48677caeda69e306434d153fc1e77b80d9f9)
- Removed unused define. [`5f8ace2`](https://github.com/ImageMagick/ImageMagick/commit/5f8ace2080b644376ea1b4e3e2be83f73b1d75b0)
- Moved check for the define to the methods itself. [`23402d5`](https://github.com/ImageMagick/ImageMagick/commit/23402d5ca69f33a351b026aa1efbff824a995a5f)
- pending release [`abded9a`](https://github.com/ImageMagick/ImageMagick/commit/abded9a381edea209c5ab7c3924abe0155831a36)
- ASAN returns false positives for OMP [`63062af`](https://github.com/ImageMagick/ImageMagick/commit/63062afee01f2db250016a2c7c526324dd0060a5)
- pending release [`1c66ab8`](https://github.com/ImageMagick/ImageMagick/commit/1c66ab80705174cd729449fdeebdf64c3d9d9025)
- https://github.com/ImageMagick/ImageMagick/issues/4512 [`a400176`](https://github.com/ImageMagick/ImageMagick/commit/a40017631a00a823470cfac376b1277c0a73466d)
- pending release [`79af0b3`](https://github.com/ImageMagick/ImageMagick/commit/79af0b3fae0015e9474d9be88e5d1a5d012f5cd4)
- Added check for invalid size (#4522). [`285c84a`](https://github.com/ImageMagick/ImageMagick/commit/285c84a86dacdc4ebee2ce3e88e642dbf174d3dc)
- Added extra check to make sure that the index is already set. [`79eec91`](https://github.com/ImageMagick/ImageMagick/commit/79eec9112cd5f5a0d356b0989229422070c294f4)
- Reduce number of typecasts. [`bb38559`](https://github.com/ImageMagick/ImageMagick/commit/bb38559758dedfb70a318c1b8c1ecffead52d636)
- Fixed memory leak. [`eaf0aa4`](https://github.com/ImageMagick/ImageMagick/commit/eaf0aa4a717672d18a1f239faa6d7301ea658b0b)
- Whitespace. [`979856a`](https://github.com/ImageMagick/ImageMagick/commit/979856ae5e08d97a26790e4a2999824b64342ce4)
- Added missing checks for the return value of the exr methods. [`3aa48d3`](https://github.com/ImageMagick/ImageMagick/commit/3aa48d31f03d2b08999480890f69b53c554afc79)
- close input file if early exit on exception [`5394e32`](https://github.com/ImageMagick/ImageMagick/commit/5394e32bdd509195f8ac41752853e7b325d609ed)
- https://github.com/ImageMagick/ImageMagick/discussions/4529 [`e66261f`](https://github.com/ImageMagick/ImageMagick/commit/e66261ffe76e9b2c2e4f0257023952acd8b30017)
- pending release [`1d5c2e5`](https://github.com/ImageMagick/ImageMagick/commit/1d5c2e55adc8bcdf0d93ebf8f30ab098bb9e5303)

## [7.1.0-16](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-15...7.1.0-16) - 2021-11-21

### Commits

- eliminate possible device by zero [`cdf8735`](https://github.com/ImageMagick/ImageMagick/commit/cdf8735e35ad9df344b99a2ae1255cd0f2f0ccea)
- ... [`0446e05`](https://github.com/ImageMagick/ImageMagick/commit/0446e0544e2e9b6deb2614397dadb993503d5e5b)
- Added flag for unsupported channels and skip them instead. [`39a9ab7`](https://github.com/ImageMagick/ImageMagick/commit/39a9ab792c997be4c722ea998d2af6e0470341a0)
- Renamed variable. [`12431a3`](https://github.com/ImageMagick/ImageMagick/commit/12431a37363724d32b8419fb62a730a898890956)
- Set the channel earlier to get rid of the switch when setting the pixel value. [`f219611`](https://github.com/ImageMagick/ImageMagick/commit/f21961130656ccc3ae1e91ba5b653e0b27778028)
- Also check for other modes in the GetPixelChannelFromPsdIndex method. [`9c9b65e`](https://github.com/ImageMagick/ImageMagick/commit/9c9b65e53859f422f890c38ca85ab1a46ea2b64f)
- DuotoneMode does not support alpha. [`927796d`](https://github.com/ImageMagick/ImageMagick/commit/927796d9340a1591c8ed9ea4a26f21cdf59b6282)
- Corrected initial channel type. [`dd26030`](https://github.com/ImageMagick/ImageMagick/commit/dd26030975e827fe9af9c5d10b5ff69c429a2961)
- Minor refactoring. [`9b562c2`](https://github.com/ImageMagick/ImageMagick/commit/9b562c258e638e725dc078ef0a73337d8444441f)
- Code style change. [`0a4e402`](https://github.com/ImageMagick/ImageMagick/commit/0a4e4026f01be479fa3f92f349f3da29912eea86)
- Make sure the other channels of the pixel are also set when setting the index of the pixel. [`c43c03c`](https://github.com/ImageMagick/ImageMagick/commit/c43c03cf02d4e94d2df03dd6913f34b8a6db8cc0)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=41268 [`b434f8c`](https://github.com/ImageMagick/ImageMagick/commit/b434f8cf9d7ec472fdfa8214d9ad07216c39f2b1)
- Corrected the type. [`63cfa54`](https://github.com/ImageMagick/ImageMagick/commit/63cfa542ab3d2d15eb067b12ef9160d6eebd9845)
- Corrected comments. [`bad0b1c`](https://github.com/ImageMagick/ImageMagick/commit/bad0b1c4929745544547fd1efc9f77071965d641)
- Moved define. [`a839c2a`](https://github.com/ImageMagick/ImageMagick/commit/a839c2a1751cd48bb19b9951d5b450f7b54938c8)
- Removed unnecessary define. [`3afb075`](https://github.com/ImageMagick/ImageMagick/commit/3afb075b42014ab86fbe4c2ffcecc9d33150326b)
- Corrected OpenCL define checks (#4450). [`7dc99d8`](https://github.com/ImageMagick/ImageMagick/commit/7dc99d829fe73df68911e32d8b72cf355586123d)
- pending release [`03b1a2e`](https://github.com/ImageMagick/ImageMagick/commit/03b1a2ecb4a14f5ea3f1f073418008109bdffb55)

## [7.1.0-15](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-14...7.1.0-15) - 2021-11-20

### Merged

- Make exported name be same as in C file. [`#4430`](https://github.com/ImageMagick/ImageMagick/pull/4430)

### Commits

- ... [`cd9d52c`](https://github.com/ImageMagick/ImageMagick/commit/cd9d52cb636d8bb7d996cd7e5017515d34d09bf4)
- https://github.com/ImageMagick/ImageMagick6/issues/168 [`55fc1ab`](https://github.com/ImageMagick/ImageMagick/commit/55fc1abb3422a00a94b66f4cf6a560a36eb2624c)
- mitigate UBSAN alerts [`9458e3d`](https://github.com/ImageMagick/ImageMagick/commit/9458e3dd3fb96ff599c3b71568de98c9f88208b2)
- mitigate UBSAN alerts [`3dc9db6`](https://github.com/ImageMagick/ImageMagick/commit/3dc9db61aca5f45e479cbd8ce4747edf5e870551)
- mitigate UBSAN alerts [`128c05a`](https://github.com/ImageMagick/ImageMagick/commit/128c05aab27b5f950c79f0d542cc15e4d17e7e2c)
- eliminate compiler warning [`4eb5f9a`](https://github.com/ImageMagick/ImageMagick/commit/4eb5f9a940f96de1e69657b129a472264c1004b1)
- ... [`db57cff`](https://github.com/ImageMagick/ImageMagick/commit/db57cffb9c170f60d86066a761b37e34f670dfc5)
- Corrected type cast. [`d221c6f`](https://github.com/ImageMagick/ImageMagick/commit/d221c6ff23d5a1fb5acb13a7ae7bda9c517bb940)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=41172 [`9c171c8`](https://github.com/ImageMagick/ImageMagick/commit/9c171c8af6420bdf6c953a8db0c8a654b1f7f74d)
- https://github.com/ImageMagick/ImageMagick/issues/4495 [`79da16f`](https://github.com/ImageMagick/ImageMagick/commit/79da16f30ca9085bbefcd9903155ea7d75ade21b)
- https://github.com/ImageMagick/ImageMagick/issues/4497 [`9bf7dfc`](https://github.com/ImageMagick/ImageMagick/commit/9bf7dfc372c55095f767e1f3ed0bbc077e88382d)
- eliminate compiler warning [`5adddc2`](https://github.com/ImageMagick/ImageMagick/commit/5adddc2efa20b5670dde30545c344cba1086f6f5)
- Move indexes of the meta channels to the end of the channel_map of the image. [`9239f3b`](https://github.com/ImageMagick/ImageMagick/commit/9239f3bdbcdf83e98957c2cbed7374ba62a5dc05)
- Added extra check to make sure number_meta_channels won't exceed the size of channel_map. [`4fb50e2`](https://github.com/ImageMagick/ImageMagick/commit/4fb50e2e8bc2cff0057ab9af8f40715e8ae7eda1)
- Changed type of the type field. [`7ff1303`](https://github.com/ImageMagick/ImageMagick/commit/7ff13033d0982e4f1d8095acfc07df948a8eef20)
- No longer support reading type -4 that does not exist according to the PSD file format specification. [`186e62a`](https://github.com/ImageMagick/ImageMagick/commit/186e62abf45b692086e8f6355ce8f49826f02ab2)
- We no longer support -4 and -3 will be skipped [`c07194a`](https://github.com/ImageMagick/ImageMagick/commit/c07194a63d417c92e2e9e07deb1781027037e121)
- Make sure the alpha channel is always -1 in the merged image. [`b3a8c52`](https://github.com/ImageMagick/ImageMagick/commit/b3a8c527e0df0c49854f5f32012f3c1e36eb52c7)
- Removed unused pixel-private includes. [`d6da28b`](https://github.com/ImageMagick/ImageMagick/commit/d6da28b0e03c15d1290ed17c94ff35d85b7ac5a5)
- Moved StartMetaChannel to the private header. [`3f2d061`](https://github.com/ImageMagick/ImageMagick/commit/3f2d06172752e489df5ee1a1b8002423f8c04a03)
- Removed unused pixel-private includes. [`07a87b2`](https://github.com/ImageMagick/ImageMagick/commit/07a87b29a9e16878be6392a415f6736192cf6443)
- Renamed define. [`b80d247`](https://github.com/ImageMagick/ImageMagick/commit/b80d2471da61c56e9f3571805332d0fc5da04f06)
- pending release [`fdd9410`](https://github.com/ImageMagick/ImageMagick/commit/fdd9410fcfb365ed3d92b75dbfdf817ccc152f3d)
- fix overly aggressive sanity check [`c836221`](https://github.com/ImageMagick/ImageMagick/commit/c8362214aca7af3d7af410a2c6fd87fa41cbf0f0)
- pending release [`c7fed90`](https://github.com/ImageMagick/ImageMagick/commit/c7fed9006739151f43803acf82646fac48b5bb61)
- Added support for reading the extra channels in the merged image of a PSD file (#4499). [`3b265d7`](https://github.com/ImageMagick/ImageMagick/commit/3b265d7066c36e08e6b619fa2d3b8ac80fe7eac9)
- pending release [`6a57c70`](https://github.com/ImageMagick/ImageMagick/commit/6a57c7014b5f2af01284da3c2169cf9e61895d21)
- Also added support for reading extra channels in the layers of a PSD file (#4499). [`f8373be`](https://github.com/ImageMagick/ImageMagick/commit/f8373be7636aa975a4ff63e0299e6f9f67d8aa01)
- MaximumValue should have the highest value instead of reordering the other values. [`8098f33`](https://github.com/ImageMagick/ImageMagick/commit/8098f3335cfdcf5ed1de6f284b9aabb4786808d0)
- pending release [`7030880`](https://github.com/ImageMagick/ImageMagick/commit/7030880c6da1c382f3b1251f0fe2a805fdab3ba5)

## [7.1.0-14](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-13...7.1.0-14) - 2021-11-14

### Merged

- Typo in magick color threshold image [`#4431`](https://github.com/ImageMagick/ImageMagick/pull/4431)

### Fixed

- Moved the free to the correct position to fix #4446. [`#4446`](https://github.com/ImageMagick/ImageMagick/issues/4446)

### Commits

- Fix stripes in output when resizing with OpenCL acceleration enabled [`0c660f2`](https://github.com/ImageMagick/ImageMagick/commit/0c660f2ff8899401be4acf0ce539f0441ebc370e)
- ... [`661c7a1`](https://github.com/ImageMagick/ImageMagick/commit/661c7a194bf8f621245f5ea5d0a0147decdab584)
- latest docs [`8a9b071`](https://github.com/ImageMagick/ImageMagick/commit/8a9b07155b7bb6e9c4768b117e9e6fb1c21e0306)
- typo in houghline comments. [`157b21d`](https://github.com/ImageMagick/ImageMagick/commit/157b21d508b8a3662c922b762aa92e524e67e57c)
- ... [`bb886ff`](https://github.com/ImageMagick/ImageMagick/commit/bb886ff398ae0dd6111ff011382dd84d4b6633e5)
- pending release [`fab9aae`](https://github.com/ImageMagick/ImageMagick/commit/fab9aaeafc5954d45cc4c5d8edd1503fcc1dadc9)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=40454 [`b93521f`](https://github.com/ImageMagick/ImageMagick/commit/b93521f5087ea92d3564862046422a0dc0ce8692)
- ... [`4ade863`](https://github.com/ImageMagick/ImageMagick/commit/4ade8632d14c349d0a6eef3ba0f9c09aa24ab76b)
- ... [`9f7884c`](https://github.com/ImageMagick/ImageMagick/commit/9f7884ca8864a6a7d99d9618abae263ce8b5a4a5)
- ... [`08dec75`](https://github.com/ImageMagick/ImageMagick/commit/08dec75b2fc1dcb913eec2d7ffd8810b00cc9a2f)
- Removed unnecessary semicolons. [`7fef3c3`](https://github.com/ImageMagick/ImageMagick/commit/7fef3c3ac8ef5397f8a7f318a5316f09a2c999c7)
- Corrected detection of the CMYK colorspace (#4106). [`e6a45aa`](https://github.com/ImageMagick/ImageMagick/commit/e6a45aa7b61bb217a8a66b5a6799d365c5ba0187)
- Improved detection of %%. [`8ff9f59`](https://github.com/ImageMagick/ImageMagick/commit/8ff9f59fcc7aa581ab6a1d53688bf94094ebe347)
- early exit on exception [`4cca191`](https://github.com/ImageMagick/ImageMagick/commit/4cca19105ccdd0991a79e138ce202ee30ebf9f64)
- The profile of a PSD file will no longer be copied to all the images. To old behavior can be re-enabled with the define psd:replicate-profile. [`50e2f07`](https://github.com/ImageMagick/ImageMagick/commit/50e2f07b37414dec19fd470d78fb2750428b2bed)
- https://github.com/ImageMagick/ImageMagick/discussions/4447 [`9a3756d`](https://github.com/ImageMagick/ImageMagick/commit/9a3756d8e54996c95b2f3880c0803c87a23b7036)
- ... [`7a608d6`](https://github.com/ImageMagick/ImageMagick/commit/7a608d6686258d6534cf948c61ad68356b91cd9c)
- https://github.com/ImageMagick/ImageMagick/issues/4452 [`b4ece92`](https://github.com/ImageMagick/ImageMagick/commit/b4ece92cdf03be8308d4eac86444f5b0be0935aa)
- https://github.com/ImageMagick/ImageMagick/issues/4448 [`5d3bc2a`](https://github.com/ImageMagick/ImageMagick/commit/5d3bc2abc650c16eff55c7d89f3d49b819f733c1)
- https://github.com/ImageMagick/ImageMagick/issues/4465 [`2a0dd59`](https://github.com/ImageMagick/ImageMagick/commit/2a0dd59371cb64bbfc4604451cec88477260e766)
- https://github.com/ImageMagick/ImageMagick/issues/4448 [`2ba5cdf`](https://github.com/ImageMagick/ImageMagick/commit/2ba5cdf4255cdf5d9349a15b7adfff13558397aa)
- pending release [`e4182c9`](https://github.com/ImageMagick/ImageMagick/commit/e4182c967a9434f180cbb748b24ed437c287381b)

## [7.1.0-13](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-12...7.1.0-13) - 2021-10-28

### Commits

- ... [`d988cbf`](https://github.com/ImageMagick/ImageMagick/commit/d988cbfa42a0cbe1bb3c90a0aad5fa0b5221f85f)
- ... [`366946d`](https://github.com/ImageMagick/ImageMagick/commit/366946defe55a8ea03dbbf87319a0f7cd6d0e324)
- Fix stack overflow when parsing malicious ps image file (#4415). [`c5fad5e`](https://github.com/ImageMagick/ImageMagick/commit/c5fad5e9446c23ff651f2655980877a0c81ec956)
- cosmetic [`ddae967`](https://github.com/ImageMagick/ImageMagick/commit/ddae9678fb137ab41ee6c09d9a1c91e4d014b8e4)
- pending release [`ab9bcad`](https://github.com/ImageMagick/ImageMagick/commit/ab9bcade8cf99b1ba2c42573d6ac080907374518)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=40451 [`987f36b`](https://github.com/ImageMagick/ImageMagick/commit/987f36b509139818c969a5474fee150e3f4034b4)
- pending release [`7ab72fa`](https://github.com/ImageMagick/ImageMagick/commit/7ab72fa00a9bf0c2c95d2beb55feb888f6629dbc)

## [7.1.0-12](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-11...7.1.0-12) - 2021-10-25

### Commits

- ... [`1b0f475`](https://github.com/ImageMagick/ImageMagick/commit/1b0f475ea77b71891df97ac0ca4a6c58e7f62b35)
- Removed unused define. [`b89ecbc`](https://github.com/ImageMagick/ImageMagick/commit/b89ecbc2d163ec1cc3184cb6a611ee0c5cff8bbb)
- Corrected writing the user mask data. [`53e9540`](https://github.com/ImageMagick/ImageMagick/commit/53e954000034cac934a07e88da0c87b1cff13775)
- Cosmetic. [`113f8f9`](https://github.com/ImageMagick/ImageMagick/commit/113f8f901efa88c63779d393340872c443ecfa3b)
- pending release [`02476ce`](https://github.com/ImageMagick/ImageMagick/commit/02476ce3ca19f2f0a267a036525182b626c9d24d)

## [7.1.0-11](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-10...7.1.0-11) - 2021-10-24

### Commits

- ... [`46c028b`](https://github.com/ImageMagick/ImageMagick/commit/46c028b5b76f590f38fe9c25039a560d848cd888)
- ... [`a3a2cc7`](https://github.com/ImageMagick/ImageMagick/commit/a3a2cc75063e372b50d804e5b04fa9dff4d9a47c)
- Whitespace. [`c191d5d`](https://github.com/ImageMagick/ImageMagick/commit/c191d5d0da3489fd0ab0640bd4450f4cee122471)
- Also include zero configuration build in the daily build. [`46b6677`](https://github.com/ImageMagick/ImageMagick/commit/46b66778bf4d9801a38164bf1022b84812ff15ab)
- Silenced warnings. [`1b04b83`](https://github.com/ImageMagick/ImageMagick/commit/1b04b8317378589d1c3a2fddecf30ef1f7cf2c80)
- https://github.com/ImageMagick/ImageMagick/issues/4372 [`f178d56`](https://github.com/ImageMagick/ImageMagick/commit/f178d564e761469158e2311db453a949184ea333)
- Renamed variable to silence warning. [`7eba68f`](https://github.com/ImageMagick/ImageMagick/commit/7eba68fd23e68f48911291e6e6ccda90c0b16548)
- Moved variable declaration. [`8391e04`](https://github.com/ImageMagick/ImageMagick/commit/8391e04b1a8f9000472c61e001420b9a9996c022)
- Use IsImageGray instead. [`2ad55fa`](https://github.com/ImageMagick/ImageMagick/commit/2ad55fa3497655604ac03666342c7cc04e14a36f)
- Added missing check. [`6c90dd8`](https://github.com/ImageMagick/ImageMagick/commit/6c90dd8ee5fe292714c6ac6b1d8046e7e48b2244)
- Corrected debug logging. [`40aa490`](https://github.com/ImageMagick/ImageMagick/commit/40aa4901db52e2d98077b5f81558b9c0d17fac84)
- Introduce new method that only checks if the image is grayscale. [`f10a8a1`](https://github.com/ImageMagick/ImageMagick/commit/f10a8a16f45ac7b5f061b7d8e4dfd1c9c84e0d6b)
- Renamed method. [`b492aba`](https://github.com/ImageMagick/ImageMagick/commit/b492aba5ba52daa811347408a6d589b500805e6b)
- Use new methods to check if the image is gray or monochrome. [`06e4331`](https://github.com/ImageMagick/ImageMagick/commit/06e4331e198718fe644f1f9e80be43161962b941)
- Renamed method. [`cb8d9ed`](https://github.com/ImageMagick/ImageMagick/commit/cb8d9ed1e5058a52e958df9e2bcea5dede3788db)
- https://github.com/ImageMagick/ImageMagick/issues/4378 [`42ddb98`](https://github.com/ImageMagick/ImageMagick/commit/42ddb98ee68ac63f2df5f80bc631ec3c289b2a5c)
- https://github.com/ImageMagick/ImageMagick/issues/4379 [`4bd86b0`](https://github.com/ImageMagick/ImageMagick/commit/4bd86b05421e998c95491e2bf9d1f987c2f517eb)
- ... [`dd7df11`](https://github.com/ImageMagick/ImageMagick/commit/dd7df1148c8140b21c2cb6e49e4554044e6b3297)
- Silenced warning. [`3bb4253`](https://github.com/ImageMagick/ImageMagick/commit/3bb4253e7c343c9b5f94e3d763a12f762f11a646)
- Use IsGrayImageType when possible [`ef939ef`](https://github.com/ImageMagick/ImageMagick/commit/ef939ef74c996b91e5dbd1cc73bc40030c0c8ae0)
- Removed IdentifyImageCoderMonochrome. [`d934c9a`](https://github.com/ImageMagick/ImageMagick/commit/d934c9a945a7a9528ba78f836ffecc188219a4d2)
- Only check the image type once. [`ba95a78`](https://github.com/ImageMagick/ImageMagick/commit/ba95a784116406f60ad98ee1133e1ee79f331eb0)
- Use IdentifyImageCoderGrayType instead. [`b95b4b1`](https://github.com/ImageMagick/ImageMagick/commit/b95b4b1b43de79fbdf81e9654f6599a43dc4f552)
- Use IdentifyImageCoderGray instead. [`b1d4280`](https://github.com/ImageMagick/ImageMagick/commit/b1d42802bb46e86aa2d45fb9b3e31fc70cae1e8c)
- Removed unnecessary statement. [`43ee149`](https://github.com/ImageMagick/ImageMagick/commit/43ee149af2ba600ffc4cf4a688d8e57a4b408596)
- The check for auto-grayscale should be done earlier. [`36febfd`](https://github.com/ImageMagick/ImageMagick/commit/36febfdd03cd2f546aa4c014b4ad0df7910c07c2)
- eliminate compiler error [`1b855b7`](https://github.com/ImageMagick/ImageMagick/commit/1b855b7b12edf9ddac2810ae604bbf3764343a12)
- Fix grammar in AUTHORS.txt [`c115616`](https://github.com/ImageMagick/ImageMagick/commit/c115616ff115cf1009d3560468bccf1a21ff43e6)
- Optimization for the low point size when the width and height of the image are fixed. [`f8cb770`](https://github.com/ImageMagick/ImageMagick/commit/f8cb770e502906c8888386402c6393d6efb4683c)
- Added new option called caption:start-pointsize that will allow setting the starting pointsize when trying to find the best font size. [`031a853`](https://github.com/ImageMagick/ImageMagick/commit/031a8533ddaffceeb31925d59c7bd80516e53d60)
- Use while instead. [`c2207f9`](https://github.com/ImageMagick/ImageMagick/commit/c2207f9012e32cb0ae0a7330f4736cc47f49b516)
- Removed else statement. [`4c8c7c6`](https://github.com/ImageMagick/ImageMagick/commit/4c8c7c689623b4c7071308492785e9364112ae0f)
- Fixed check of the boundaries when both the with and height of the image are defined. [`5a3371f`](https://github.com/ImageMagick/ImageMagick/commit/5a3371fe6f50b45d9e5a1a9271400d6166703ca9)
- Optimization for the low point size when the width and height of the image are fixed. [`74af638`](https://github.com/ImageMagick/ImageMagick/commit/74af638e37801da5a156c0634dc3e4bcf4ed2681)
- Removed gravity check. [`e90b163`](https://github.com/ImageMagick/ImageMagick/commit/e90b163f2f71ce78487560009a05127628cafab3)
- test release [`4c62b10`](https://github.com/ImageMagick/ImageMagick/commit/4c62b10ebf3c45de5724cbeabf2f0ac455e58686)
- Stop writing the icc profile to the output image because this changes the colors of the image and switch back to JxlColorEncodingSetToSRGB (#4385). [`b2cc365`](https://github.com/ImageMagick/ImageMagick/commit/b2cc365614f734c1cac39b8343c5c1f6033ee92f)
- Change to lowercase. [`18e15da`](https://github.com/ImageMagick/ImageMagick/commit/18e15da2dc6ceae05e95077f85e9d67dac31c5d8)
- fix stack overflow when parsing malicious tiff image [`f620340`](https://github.com/ImageMagick/ImageMagick/commit/f620340935777b28fa3f7b0ed7ed6bd86946934c)
- Also allow setting the max and start pointsize in the label coder. [`3990e66`](https://github.com/ImageMagick/ImageMagick/commit/3990e661655540843da53964576395abca80dd27)
- pending release [`a0291e9`](https://github.com/ImageMagick/ImageMagick/commit/a0291e944baf076f1036ca120aa115b7f46878c7)
- Added mime type for bmp (#4395). [`45febac`](https://github.com/ImageMagick/ImageMagick/commit/45febac063c24d54ff4f348129c677447a210336)
- pending release [`5ac355f`](https://github.com/ImageMagick/ImageMagick/commit/5ac355fe99f9aaed48d05715256b7a54ccf87b12)
- ... [`af76674`](https://github.com/ImageMagick/ImageMagick/commit/af766745f92967970b69091bdd52c1610722a489)
- Added missing (void). [`6e2983b`](https://github.com/ImageMagick/ImageMagick/commit/6e2983b9389b0494e44e75f78cf2a50526a481ca)
- Argument can be const. [`c4cf2ac`](https://github.com/ImageMagick/ImageMagick/commit/c4cf2ac655820d028f228cfc8ae69e44d979e70b)
- Reduce stack size. [`1bcee60`](https://github.com/ImageMagick/ImageMagick/commit/1bcee608550c8fb850c6e20970e20e8a53b4986c)
- Changed argument to blob_info. [`c7a767c`](https://github.com/ImageMagick/ImageMagick/commit/c7a767c55cded4e9fb7721388c7e2898f0227808)
- Corrected indentation. [`a864d83`](https://github.com/ImageMagick/ImageMagick/commit/a864d835725ccf4e6ba09112e1cb04f7a7f662a9)
- Added missing typecast. [`61a9889`](https://github.com/ImageMagick/ImageMagick/commit/61a9889dcc33437f48ec3637b247a4c81f07b38c)
- Create separate for the conversion of the wchar mode. [`72ffc83`](https://github.com/ImageMagick/ImageMagick/commit/72ffc835deeab2231b7c3f4ccc857396da219fca)
- Added flag that the handle is not inheritable by the child process. [`7241ee3`](https://github.com/ImageMagick/ImageMagick/commit/7241ee31f2e3b323e93830cd8482dc45794d8422)
- Corrected indentation. [`8c85ce0`](https://github.com/ImageMagick/ImageMagick/commit/8c85ce001ebb8c32986f0378dcaca3173ddd09b9)
- Added O_NOINHERIT flag. [`d8d087e`](https://github.com/ImageMagick/ImageMagick/commit/d8d087ec94092b2fc7afd9778b92d24604a78cc8)
- Also allow disabling the interpolation. [`b464cd2`](https://github.com/ImageMagick/ImageMagick/commit/b464cd2dbf8eaa9abde3a1b231906038ee873336)
- Removed checks for the macintosh define. [`f18599b`](https://github.com/ImageMagick/ImageMagick/commit/f18599b05e2ee0c54ecdc7dbd7527227973822e9)
- pending release [`baa6c1d`](https://github.com/ImageMagick/ImageMagick/commit/baa6c1d2a756c99d8590c1bd58887e9a0080af17)
- Use IdentifyImageGray instead. [`10df973`](https://github.com/ImageMagick/ImageMagick/commit/10df973b796da6d351911e8a6cc8ca96b15f60d4)
- ThrowDCMException should be used instead. [`a4a2ee6`](https://github.com/ImageMagick/ImageMagick/commit/a4a2ee6593b06e430fd3565d858a3fbab63cb876)
- slight performance optimization [`753f39f`](https://github.com/ImageMagick/ImageMagick/commit/753f39fef6c5f8aff18b793ef1d363ce08244c1b)
- Revert adjustment of the y1 value (#4405). [`f5c3396`](https://github.com/ImageMagick/ImageMagick/commit/f5c3396e2644cdd9b4350e537c9c0550c05f960c)
- Added additional boundary checks. [`be3c7dc`](https://github.com/ImageMagick/ImageMagick/commit/be3c7dc182ca88690083929ef550a9cb01d5860d)
- Create new struct for refactoring. [`7c8d19b`](https://github.com/ImageMagick/ImageMagick/commit/7c8d19b19d7f97a6e1d58ad05c3bd93c8d753757)
- revert optimization [`22694f6`](https://github.com/ImageMagick/ImageMagick/commit/22694f60aee3d6dc3a725605b2b39cda58dca2c9)
- Added RelinquishDCMMemory. [`9a301fa`](https://github.com/ImageMagick/ImageMagick/commit/9a301fa41f3bb299194d122e60d04380d4571e35)
- pending release [`9523594`](https://github.com/ImageMagick/ImageMagick/commit/95235946925dd5d3153d30f5e3673e7c0b1200ee)
- Copy scale to avoid duplicate free (https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=36990). [`7e2565b`](https://github.com/ImageMagick/ImageMagick/commit/7e2565b79a2268bc89a1b83bd30ed19fe8881add)
- Whitespace. [`c47f0e3`](https://github.com/ImageMagick/ImageMagick/commit/c47f0e34dcf05cfe8762b378c8b32065c600e5ed)
- Whitespace. [`4c04fad`](https://github.com/ImageMagick/ImageMagick/commit/4c04fade3b86f0f2277791bfdb121c19231d296a)
- cosmetic [`dadd444`](https://github.com/ImageMagick/ImageMagick/commit/dadd44478bf62d6033ecb6b822a8e38f09b5235d)
- https://oss-fuzz.com/testcase-detail/6308942275805184 [`5e99821`](https://github.com/ImageMagick/ImageMagick/commit/5e998214b84b69437a7cd93474b6dab9f82b4088)
- https://oss-fuzz.com/testcase-detail/6308942275805184 [`fab0e18`](https://github.com/ImageMagick/ImageMagick/commit/fab0e185965332958bfdd16020b6b1675e8d1bb2)
- Corrected calls to heif_image_handle_release. [`7b9b7c6`](https://github.com/ImageMagick/ImageMagick/commit/7b9b7c6a2a9c370b27d48d2da760600342881e5b)
- pending release [`97e5cdf`](https://github.com/ImageMagick/ImageMagick/commit/97e5cdfc8f4a318882ee41e62da1ba82a8c0a294)
- Fixed copy paste mistake. [`44179b2`](https://github.com/ImageMagick/ImageMagick/commit/44179b21d11e7edfceb194be9a966f47d5cfb314)
- Fixed possible memory leak. [`fbf76f2`](https://github.com/ImageMagick/ImageMagick/commit/fbf76f2efa62b644d41a6075c7d9bb598dfb3bbf)
- pending release [`e16d679`](https://github.com/ImageMagick/ImageMagick/commit/e16d67915d7ca440701f934f97cb9e0a75ea77f3)

## [7.1.0-10](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-9...7.1.0-10) - 2021-10-10

### Commits

- ... [`78efee9`](https://github.com/ImageMagick/ImageMagick/commit/78efee93db2217a8ad2ff622921e51465de64eb4)
- https://github.com/ImageMagick/ImageMagick/issues/4312 [`bc2f658`](https://github.com/ImageMagick/ImageMagick/commit/bc2f658a6c3d260d086aac795d9502035ae246d7)
- https://github.com/ImageMagick/ImageMagick/discussions/4311 [`494c960`](https://github.com/ImageMagick/ImageMagick/commit/494c960c815577d1ce4adfd663f75c9466b4bc72)
- ... [`c5afe90`](https://github.com/ImageMagick/ImageMagick/commit/c5afe90f2cb98e7874318581ca446170ce3ff716)
- Added missing call to SetImageProfile. [`4dca4a7`](https://github.com/ImageMagick/ImageMagick/commit/4dca4a7b3e719216a481b592683fb93c506dfda5)
- https://github.com/ImageMagick/ImageMagick/issues/4314 [`9c8b025`](https://github.com/ImageMagick/ImageMagick/commit/9c8b025640bffb45e5caedf27f10cec222c38290)
- Update configure with latest changes [`7df9e19`](https://github.com/ImageMagick/ImageMagick/commit/7df9e19ff93984991b768f763aaeb661ed07c43a)
- Update libjxl to use a .pc [`c82a9aa`](https://github.com/ImageMagick/ImageMagick/commit/c82a9aa538007d2d397e3c106493d4637e9b3900)
- don't adjust metrics if gravity is undefined [`3fc5106`](https://github.com/ImageMagick/ImageMagick/commit/3fc51062618127a8b683bb06344ca6152d9791fe)
- determine configuration with the `magick` utility [`6422663`](https://github.com/ImageMagick/ImageMagick/commit/6422663885abc973f74c3a5f0bdfa0afbc3202ca)
- ... [`a3c0680`](https://github.com/ImageMagick/ImageMagick/commit/a3c068017b549cc29ccea9f545af6c079d94c3bd)
- ... [`c1e67e9`](https://github.com/ImageMagick/ImageMagick/commit/c1e67e9a606247f5cc51fa079f242c93a9aaaa60)
- Moved using namespace std after ImageMagick header files to fix issues when enabling ISO C++ 17 and ISO C17 [`f7ff309`](https://github.com/ImageMagick/ImageMagick/commit/f7ff309b0b64fb0b478b3af1531ce5e6f179eea3)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=39708 [`524edfe`](https://github.com/ImageMagick/ImageMagick/commit/524edfed7587623a24ce7b7bb16af049b8b5e920)
- ... [`07ebe6b`](https://github.com/ImageMagick/ImageMagick/commit/07ebe6b6e47bbeadd84287c7395888df460677f8)
- pending release [`32bf14a`](https://github.com/ImageMagick/ImageMagick/commit/32bf14aa2ddb63cc919cf2fcb88a47998622cb69)

## [7.1.0-9](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-8...7.1.0-9) - 2021-10-03

### Commits

- ... [`a14c4cd`](https://github.com/ImageMagick/ImageMagick/commit/a14c4cd8dddfa9fbb431aa55913914ba7f6efd02)
- ... [`dd922fe`](https://github.com/ImageMagick/ImageMagick/commit/dd922fe9467bc6bf3cae41ce6a08c14c4d41abcf)
- https://github.com/ImageMagick/ImageMagick/discussions/4227 [`633618c`](https://github.com/ImageMagick/ImageMagick/commit/633618c249b97bf5ac9d85fbeb5b6654757d809f)
- check return status [`b213e5f`](https://github.com/ImageMagick/ImageMagick/commit/b213e5f2c02a81f9ee328f6ba1d1a4db80c2450b)
- continue parsing for warning [`8fd90c7`](https://github.com/ImageMagick/ImageMagick/commit/8fd90c7a92a487661ade6316444a8e6abe8d3c8e)
- use ANSI comments rather than C++ [`f76e974`](https://github.com/ImageMagick/ImageMagick/commit/f76e9743c33b04364b6c3ee1f5234bb0ee1695eb)
- ignore zero-length profiles [`071274b`](https://github.com/ImageMagick/ImageMagick/commit/071274b98aa4f12844595d8f14d667406069ef22)
- Corrected comments and changed argument order. [`f64d4e0`](https://github.com/ImageMagick/ImageMagick/commit/f64d4e043a1fe05d4905e09c4836ad40fd6cf279)
- Silenced warnings. [`36a5fa7`](https://github.com/ImageMagick/ImageMagick/commit/36a5fa73c78600cbd0308e36440d84d4a84585b2)
- Silence warning. [`bfe17f8`](https://github.com/ImageMagick/ImageMagick/commit/bfe17f8d308825079b886b11ed9b2e32ab50b576)
- Silenced warnings. [`0a9a6a8`](https://github.com/ImageMagick/ImageMagick/commit/0a9a6a8458d1b12a5ea5d16a0bda49fde6fd973e)
- Silenced warnings. [`9755ee2`](https://github.com/ImageMagick/ImageMagick/commit/9755ee291f559471eb400b9dd1729a648eedbb54)
- Corrected typecast. [`e0e829a`](https://github.com/ImageMagick/ImageMagick/commit/e0e829a84377110b5b35598726d6dcd5696b8dad)
- Silenced warnings. [`c89ec48`](https://github.com/ImageMagick/ImageMagick/commit/c89ec48fed14278b965a203e1d4723b438d74d03)
- cosmetic [`7c50d57`](https://github.com/ImageMagick/ImageMagick/commit/7c50d57e4814cd66c1a943fefd9e5ed97c38ce85)
- https://github.com/ImageMagick/ImageMagick/pull/4270 [`3037b2f`](https://github.com/ImageMagick/ImageMagick/commit/3037b2f32923df3da91949f0d39129b7da4f0674)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=39091 [`d9cb7ae`](https://github.com/ImageMagick/ImageMagick/commit/d9cb7ae93cb29b4a0624805cf4a40ef2d3824ee2)
- Silenced warnings. [`30e4e15`](https://github.com/ImageMagick/ImageMagick/commit/30e4e15b7a54408bec7075d61ffe829e96b81c8f)
- Corrected typecast. [`33cbae2`](https://github.com/ImageMagick/ImageMagick/commit/33cbae2c6fdb2dae77621e06204cfc571b1dda7b)
- Silenced warnings. [`3156587`](https://github.com/ImageMagick/ImageMagick/commit/31565876329d4813de0f1e4330a7a84f9a7b5dac)
- Cosmetic [`2322da9`](https://github.com/ImageMagick/ImageMagick/commit/2322da9e21f1b2290dea74f5b1973d29466374a7)
- Silenced warnings. [`9e336f1`](https://github.com/ImageMagick/ImageMagick/commit/9e336f1f3c9511f2e848eb4ee80324b64a7d4c9d)
- Silenced warning. [`4df253e`](https://github.com/ImageMagick/ImageMagick/commit/4df253e17e8b224866088ef396eed2c760cb2753)
- Removed unused variable. [`dfa9f1a`](https://github.com/ImageMagick/ImageMagick/commit/dfa9f1a3b4d270ecf9dcd4c507e128d65241a574)
- Silenced warnings. [`8cc5ffd`](https://github.com/ImageMagick/ImageMagick/commit/8cc5ffdf20195e2a854915f5c6039f7fafe281e6)
- Silenced warnings. [`a26b4b7`](https://github.com/ImageMagick/ImageMagick/commit/a26b4b78e2b45e36fb62aa046ae7d6b8f00dc26c)
- Silenced warnings. [`a40c341`](https://github.com/ImageMagick/ImageMagick/commit/a40c34116fffaaf77dc0eb3fa426f4c637a90aad)
- Corrected typecast. [`f440be7`](https://github.com/ImageMagick/ImageMagick/commit/f440be70190edd7e6bf07616a27a9bed37d98292)
- Silenced warnings. [`8bdd2e5`](https://github.com/ImageMagick/ImageMagick/commit/8bdd2e5ef0afbfc5ed858d5466d251a414137869)
- Cosmetic. [`04643cd`](https://github.com/ImageMagick/ImageMagick/commit/04643cdd916553b19e4b7ec61b60a45ad22217f8)
- Silenced warnings. [`8a1f456`](https://github.com/ImageMagick/ImageMagick/commit/8a1f456ed3b23bd4334854b152a7756dceeac8e1)
- Silenced warnings. [`a5ef57a`](https://github.com/ImageMagick/ImageMagick/commit/a5ef57ae24656e18405052e62313f58bfc3209bb)
- Removed unnecessary include. [`f7bce58`](https://github.com/ImageMagick/ImageMagick/commit/f7bce58427ccb4d48d3c42e2648dfdcc6fe87474)
- Silenced warnings. [`927966d`](https://github.com/ImageMagick/ImageMagick/commit/927966d480bc9b81f19a4d1124b9e3845cae78be)
- Cosmetic. [`1a2c0fa`](https://github.com/ImageMagick/ImageMagick/commit/1a2c0fa9e1c56928acaac2b0c16afeaa3e8df9eb)
- Silenced warnings. [`ba74500`](https://github.com/ImageMagick/ImageMagick/commit/ba74500b196220fa01d1cfc2632bba4721bfa56a)
- Silenced warning. [`d61c9a0`](https://github.com/ImageMagick/ImageMagick/commit/d61c9a0fd30b3352ce8d6514e80471f6d2c85178)
- Removed unused variable. [`db286e6`](https://github.com/ImageMagick/ImageMagick/commit/db286e608e075d6d67cae77afe2c839eda3cb7ee)
- Silenced warnings. [`5023814`](https://github.com/ImageMagick/ImageMagick/commit/5023814b5a23065f77edddb97c79eed1a810905f)
- Moved CircularityThreshold to a separate method. [`563de1c`](https://github.com/ImageMagick/ImageMagick/commit/563de1ce718e7c2cc9ed954bf3f1da7bc44ad301)
- Moved MajorAxisThreshold to a separate method. [`7ae012a`](https://github.com/ImageMagick/ImageMagick/commit/7ae012ab99a969603aa570d1ec0460390ab517b5)
- Moved MinorAxisThreshold to a separate method. [`c7035c3`](https://github.com/ImageMagick/ImageMagick/commit/c7035c377f5734ddecf3665e92bdabcc8e90d93e)
- Moved EccentricityThreshold to a separate method. [`0886f20`](https://github.com/ImageMagick/ImageMagick/commit/0886f209b8e350e23725fd50f69877932aa19aba)
- Moved AngleThreshold to a separate method. [`64b48fc`](https://github.com/ImageMagick/ImageMagick/commit/64b48fc3dcf8cacf3334adcd236ae5eead1cef2e)
- Moved PerimeterThreshold to a separate method. [`7052540`](https://github.com/ImageMagick/ImageMagick/commit/7052540aff4ab22021f06cdd539c987fd8a587c4)
- Silenced warnings. [`5131213`](https://github.com/ImageMagick/ImageMagick/commit/51312133557621ac14fab5771360c8e953ac12e9)
- Silenced warnings. [`5405b78`](https://github.com/ImageMagick/ImageMagick/commit/5405b780821cd45845506e6c6afb409d01691a3e)
- Silenced warnings. [`a0eac20`](https://github.com/ImageMagick/ImageMagick/commit/a0eac20ff7a8c0d8143eac41f8efa9047b002ce9)
- Corrected typecast. [`5940040`](https://github.com/ImageMagick/ImageMagick/commit/5940040706509a2f9fe5d93825c472b4207134cf)
- Silenced warnings. [`8098135`](https://github.com/ImageMagick/ImageMagick/commit/8098135f9e2db5a70aad466cfa32e7abbdc20d59)
- Silenced warnings. [`ef8d0d7`](https://github.com/ImageMagick/ImageMagick/commit/ef8d0d76df6cfc20e1138eec0d4910e8142a7da5)
- Silenced warnings. [`cbe2ee3`](https://github.com/ImageMagick/ImageMagick/commit/cbe2ee36bc291658d3b2e5a260d68991149af0fd)
- Silenced warnings. [`688b19a`](https://github.com/ImageMagick/ImageMagick/commit/688b19a560a3d4fa213bb07cdd15de00eb846576)
- Silenced warnings. [`ab616d3`](https://github.com/ImageMagick/ImageMagick/commit/ab616d398b342995edc55ccf6cc8b3c560b222e4)
- Silenced warnings. [`db0911b`](https://github.com/ImageMagick/ImageMagick/commit/db0911bd69133c72a0fb2de06f8f10841e01d0ab)
- Silenced warning. [`df0b207`](https://github.com/ImageMagick/ImageMagick/commit/df0b2071554a87a4c1a2b4a97965787aeb3ee793)
- Silenced warnings. [`26380ba`](https://github.com/ImageMagick/ImageMagick/commit/26380ba9cf89464da86d690d9ba0bf7ce1687b06)
- Silenced warnings. [`083ac80`](https://github.com/ImageMagick/ImageMagick/commit/083ac80d33d0274ab7915751edaf8eed7b306672)
- Silenced warnings. [`fa6182e`](https://github.com/ImageMagick/ImageMagick/commit/fa6182e1e5d6924976d662456e49666ed905ba8f)
- Silenced warning. [`cbf73b0`](https://github.com/ImageMagick/ImageMagick/commit/cbf73b0d97a1033d883091d3661eea002d2cf332)
- Silenced warning. [`49015df`](https://github.com/ImageMagick/ImageMagick/commit/49015df6081a0496a531251e3995c268252da2a1)
- Silenced warning. [`66ee0f7`](https://github.com/ImageMagick/ImageMagick/commit/66ee0f77b6a47c2d313e3f62fde5ff34cea5900e)
- Corrected return type. [`7530cc8`](https://github.com/ImageMagick/ImageMagick/commit/7530cc8f3225be7b821fedfeb8aa49e06164f68a)
- Silenced warnings. [`3ab1ec4`](https://github.com/ImageMagick/ImageMagick/commit/3ab1ec4c4bb49d1ac49911c88d8d5101799f1e46)
- Silenced warning. [`071352e`](https://github.com/ImageMagick/ImageMagick/commit/071352e56d35d187ebff342acace3891aea9560c)
- Removed unused arguments. [`7b3b3c7`](https://github.com/ImageMagick/ImageMagick/commit/7b3b3c76c7bf6b755fb11b496c64eb38f444ec54)
- Removed assert. [`a70f43f`](https://github.com/ImageMagick/ImageMagick/commit/a70f43f5586ab3d8496f28e6833eb38bd273b534)
- Added missing statement. [`aa493c1`](https://github.com/ImageMagick/ImageMagick/commit/aa493c105f3b6f496f26f60735fb0d0848ba9b5b)
- Add another missing statement. [`fd03a8f`](https://github.com/ImageMagick/ImageMagick/commit/fd03a8fc9308f12a98ad8375d5ad16a3b8906c0a)
- Silenced warning. [`e50d7d3`](https://github.com/ImageMagick/ImageMagick/commit/e50d7d37b3402734157b74b40a2f56ff1d38bf89)
- Use SIZE_MAX instead. [`2f442f7`](https://github.com/ImageMagick/ImageMagick/commit/2f442f7f05d02dc4d0a0399c32c07c1f47fc3841)
- Added missing semicolon. [`7f8d3bc`](https://github.com/ImageMagick/ImageMagick/commit/7f8d3bcd04c44242d448ae9fbd7a9d37f5f6b183)
- Use MAGICK_SSIZE_MAX instead because of the MagickMin. [`6ccb83b`](https://github.com/ImageMagick/ImageMagick/commit/6ccb83b8ad7e4532547ca738774a1aa74ff3b076)
- Build both 32 and 64 bit version on Windows. [`4703bc1`](https://github.com/ImageMagick/ImageMagick/commit/4703bc125a353ce4701ffee8836249bf4d242eb4)
- Removed unused variables. [`6d12d96`](https://github.com/ImageMagick/ImageMagick/commit/6d12d967a7c74a7830f4360172ff9a11518416f2)
- ... [`1829d08`](https://github.com/ImageMagick/ImageMagick/commit/1829d08946e761db88ec9504f7d4afbfe8d58dc8)
- Corrected solution configuration for the 32 bit build. [`f8c1f13`](https://github.com/ImageMagick/ImageMagick/commit/f8c1f138bd746a27b41aee6355a571f7fd89a2cb)
- https://github.com/ImageMagick/ImageMagick/issues/4278 [`fd26b54`](https://github.com/ImageMagick/ImageMagick/commit/fd26b54726415f89d412c9b7c31f9c9d9a8954c7)
- eliminate compiler warning [`69ea678`](https://github.com/ImageMagick/ImageMagick/commit/69ea678c1eb65755af1bb7753179da4f36f357fd)
- Fixed warning. [`c7c273f`](https://github.com/ImageMagick/ImageMagick/commit/c7c273fb89b7d14f7b2b56a6c4dda40eaf504759)
- Cosmetic. [`f910a2d`](https://github.com/ImageMagick/ImageMagick/commit/f910a2df14d7687cab2412aea64b1883d22aae05)
- Removed unnecessary check. [`45b1ad6`](https://github.com/ImageMagick/ImageMagick/commit/45b1ad6cc5e1c4a4a50ebc0f97ed17c83991c0db)
- Throw exception instead. [`b5d7d22`](https://github.com/ImageMagick/ImageMagick/commit/b5d7d22de2c63129f85483523a45761a60a5677b)
- eliminate compiler warning [`59dc862`](https://github.com/ImageMagick/ImageMagick/commit/59dc86278286f391dc6afe86145bd9ee9482a1d4)
- Corrected typecast. [`7366f26`](https://github.com/ImageMagick/ImageMagick/commit/7366f2608cbf893212024955a1851ede76449ddf)
- Corrected compare. [`a37c206`](https://github.com/ImageMagick/ImageMagick/commit/a37c2068cd6dc918c275fa20e09e3fd8e113f353)
- Added missing typecast. [`926e45f`](https://github.com/ImageMagick/ImageMagick/commit/926e45f87ba06e9adf168077988afea024982022)
- Revert patch because this breaks font rendering for other fonts. [`94721c6`](https://github.com/ImageMagick/ImageMagick/commit/94721c614080a605d911f1caf1bbd9f326827993)
- Adjust the x1 offset of the bounds to make sure a font is rendered inside the canvas (#4278). [`ed6f7d0`](https://github.com/ImageMagick/ImageMagick/commit/ed6f7d073f2de45f6c6f07385bcf63196ca53edd)
- Forgot to save the file before the commit. [`40384dd`](https://github.com/ImageMagick/ImageMagick/commit/40384dd6905598ce98d1fbf9e05432113ee9f174)
- Minor adjustment. [`ebaee9e`](https://github.com/ImageMagick/ImageMagick/commit/ebaee9ea620690dabdff3792e3c86a2c8de9325f)
- Correction of the bounds measurements. [`bafbac2`](https://github.com/ImageMagick/ImageMagick/commit/bafbac2ace6a4f8b61fd8fe58401582fa8614330)
- cosmetic [`8dbdb98`](https://github.com/ImageMagick/ImageMagick/commit/8dbdb9866e6522bf5ceea6b11b92a0d3370970eb)
- cosmetic [`75be18b`](https://github.com/ImageMagick/ImageMagick/commit/75be18b28a037f37aa0c58dd81a044ac113c98e4)
- Correct replacement of spaces that use more than one octet (#4305). [`f5ea8b0`](https://github.com/ImageMagick/ImageMagick/commit/f5ea8b08fe2dc607b15741b56ebe9553f080210f)
- cosmetic [`cc13ed5`](https://github.com/ImageMagick/ImageMagick/commit/cc13ed59273c2412ede5278abccbd418eeab5420)
- Minor optimization. [`a251f85`](https://github.com/ImageMagick/ImageMagick/commit/a251f85620fcb7f03654feb94265d850df48ca94)
- Cosmetic. [`7044df1`](https://github.com/ImageMagick/ImageMagick/commit/7044df16e5c834a66d650f293e6480a3026d46cc)
- Added extra check to prevent replacing a non-breaking space with a newline (#4305). [`de54d48`](https://github.com/ImageMagick/ImageMagick/commit/de54d48d716c833da3157f767233f25bd2e4d96f)
- Space pointer was still pointing to the old string. [`dbfb273`](https://github.com/ImageMagick/ImageMagick/commit/dbfb273e2a261b6e849614c6c510bbac515955a6)
- Cosmetic. [`536cc83`](https://github.com/ImageMagick/ImageMagick/commit/536cc83a975bfd1345582bd7a81eba64740f722b)
- argument is const [`442703a`](https://github.com/ImageMagick/ImageMagick/commit/442703a3eb2c6f738c703fb01ded2833d7493a1a)
- pending release [`7b5d247`](https://github.com/ImageMagick/ImageMagick/commit/7b5d247173533a7a29411f556cf548cf5d69b8de)
- Use SETJMP_IS_THREAD_SAFE instead of custom IMPNG_SETJMP_IS_THREAD_SAFE (#4123). [`7921bf0`](https://github.com/ImageMagick/ImageMagick/commit/7921bf068c25e876a1adf287313de47e20d86817)
- pending release [`85b3172`](https://github.com/ImageMagick/ImageMagick/commit/85b3172d179b96ff45d27565fbe70e8ff946b5ab)

## [7.1.0-8](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-7...7.1.0-8) - 2021-09-18

### Commits

- ... [`ffee953`](https://github.com/ImageMagick/ImageMagick/commit/ffee953296479c7cb6a27b08b3cd12b29a96ef48)
- Added link to advisory. [`600a8e5`](https://github.com/ImageMagick/ImageMagick/commit/600a8e54c1a6cf353cf9365a02b9ba52bda91ee5)
- Give the buffer a proper size instead of "over allocating". [`00bb801`](https://github.com/ImageMagick/ImageMagick/commit/00bb80173921219b213cc4808e13fc7733edc44b)
- Silenced warning. [`9419d6f`](https://github.com/ImageMagick/ImageMagick/commit/9419d6fd49f4944eef82c222e5e9c791be738444)
- Silenced warning. [`42ab885`](https://github.com/ImageMagick/ImageMagick/commit/42ab885b82356a810bf7d20a5169632ab883f45b)
- Silenced warning. [`30626f4`](https://github.com/ImageMagick/ImageMagick/commit/30626f44f3307a39d7a3addc47f31936e4ad043e)
- Silenced warning. [`e5e0a7d`](https://github.com/ImageMagick/ImageMagick/commit/e5e0a7dcaef08286e4e8066b42c415f8c73f4ead)
- Removed unused variable. [`3c4656a`](https://github.com/ImageMagick/ImageMagick/commit/3c4656a3f39071b7e7a35f6ddd9ec0d1333d68ff)
- Print date at the start of the build. [`021d3ce`](https://github.com/ImageMagick/ImageMagick/commit/021d3ce4805618ff46d18bbfd7a0db2542f53781)
- DDS: fixed a bug that caused artefacts in images [`c799d44`](https://github.com/ImageMagick/ImageMagick/commit/c799d44523506a5f58fa39307a3c6e5504a3b144)
- Add some more date prints to figure out what is taking so much time. [`739788f`](https://github.com/ImageMagick/ImageMagick/commit/739788fc60e50eb5140e83a280cae74858815cd9)
- Make it easier to find the dates [`fdb072f`](https://github.com/ImageMagick/ImageMagick/commit/fdb072f8273b1ca4bc66a3e026bb6508b5af6862)
- Added missing null check. [`9ccbd97`](https://github.com/ImageMagick/ImageMagick/commit/9ccbd97d788dd3a5b876a808dcfacf2311392f54)
- Added missing call to InitializeMagick. [`d6d5a7d`](https://github.com/ImageMagick/ImageMagick/commit/d6d5a7da72dc4d2ff73ad0f335e1c3c4b70735a0)
- Added missing null checks. [`ed9b3a1`](https://github.com/ImageMagick/ImageMagick/commit/ed9b3a1a403edce373912ad8862ffddb4a3125cc)
- https://github.com/ImageMagick/ImageMagick/issues/4235 [`772e98c`](https://github.com/ImageMagick/ImageMagick/commit/772e98c6431d9999830acfe67eb95857530317d5)
- ... [`d273f0f`](https://github.com/ImageMagick/ImageMagick/commit/d273f0fdd3e4b086959f10701b0cfbb27645344d)
- Added missing bom. [`ecb2d22`](https://github.com/ImageMagick/ImageMagick/commit/ecb2d22d33ae9b8324dc641d6ea1afcf1920d9f2)
- Removed date markers. [`428fe19`](https://github.com/ImageMagick/ImageMagick/commit/428fe19219b5bf7d84afa03109ee7c8c21a53b74)
- pending release [`881869e`](https://github.com/ImageMagick/ImageMagick/commit/881869ed01d35333c4184edc319b17006dda3ce3)

## [7.1.0-7](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-6...7.1.0-7) - 2021-09-12

### Merged

- Added decode support for DDS Dxt10 format [`#4126`](https://github.com/ImageMagick/ImageMagick/pull/4126)

### Commits

- ... [`f135b4c`](https://github.com/ImageMagick/ImageMagick/commit/f135b4cedfb418733d372ffc129eda5e0d1cb1d1)
- Update README.md [`5cfbef1`](https://github.com/ImageMagick/ImageMagick/commit/5cfbef1a171606738bbf85b7e830de368f1d2f52)
- Update README.md [`7f0e767`](https://github.com/ImageMagick/ImageMagick/commit/7f0e7673af0b63b76f27e13fb4c16ba5979c0d50)
- Update README.md [`e6077ba`](https://github.com/ImageMagick/ImageMagick/commit/e6077ba1f74cb26605f5561949c72e2bb80029eb)
- Update README.md [`029ff7d`](https://github.com/ImageMagick/ImageMagick/commit/029ff7d5ea6c5d19ee6c9d6154a6e4262943caa6)
- Update README.md [`1838dee`](https://github.com/ImageMagick/ImageMagick/commit/1838dee27e2907e0f16c252be0029f6ea00aec6d)
- Update README.md [`f5e052e`](https://github.com/ImageMagick/ImageMagick/commit/f5e052eb551452a9a0411c15e2d05c2fc705513c)
- Update README.md [`4606c0a`](https://github.com/ImageMagick/ImageMagick/commit/4606c0aa51e9512ed48fc0199ece6cf0caec850c)
- Update README.md [`bc29170`](https://github.com/ImageMagick/ImageMagick/commit/bc291701c358532dcdea350b3447b839cfc3043f)
- ... [`faa87f4`](https://github.com/ImageMagick/ImageMagick/commit/faa87f444450529de0d6dddd37baa992bd3460dc)
- Use yaml issue template instead. [`ecda000`](https://github.com/ImageMagick/ImageMagick/commit/ecda000b48679864cc03efd7ab14d56475f65feb)
- Added yml to the .editorconfig [`c5ae597`](https://github.com/ImageMagick/ImageMagick/commit/c5ae59784cd3942e2cb302f819e8911c4d431fa8)
- Removed travis CI link. [`15359c4`](https://github.com/ImageMagick/ImageMagick/commit/15359c48a90e7866d7b2599d3a572dd1b7190360)
- Changed build status link. [`1e1ab50`](https://github.com/ImageMagick/ImageMagick/commit/1e1ab508b1b5468fd9ae3a314d451e7da46f44de)
- Added donate badge. [`71e0b77`](https://github.com/ImageMagick/ImageMagick/commit/71e0b772dd1f3df1ac54e46d85909c955405420e)
- Changed file encoding. [`4ffb600`](https://github.com/ImageMagick/ImageMagick/commit/4ffb60019e0958ba02dd7252efad5f6c45e5d109)
- Added BC7_ prefix to the new variables. [`abed239`](https://github.com/ImageMagick/ImageMagick/commit/abed23939f5a05972bca3c70c9a265f20f5fe960)
- Added missing magick_unreferenced. [`647e477`](https://github.com/ImageMagick/ImageMagick/commit/647e47752ca6053d4ba060ac808c359f5ef2d4d4)
- Renamed variables. [`6d56ce1`](https://github.com/ImageMagick/ImageMagick/commit/6d56ce1c2776bbeb71146b00b226fefc7328c815)
- Initialize the arrays. [`8a41ce8`](https://github.com/ImageMagick/ImageMagick/commit/8a41ce827dfb1f499323ff20844e6c8ddf007c60)
- DDSInfo should be a const instead. [`c8bfe14`](https://github.com/ImageMagick/ImageMagick/commit/c8bfe144765bf91a200136054822badb1ea611b5)
- Renamed variable. [`99c26a8`](https://github.com/ImageMagick/ImageMagick/commit/99c26a87fabc827b9b6a00c6f34beff1a53db7eb)
- Corrected indentation. [`6d3a9fc`](https://github.com/ImageMagick/ImageMagick/commit/6d3a9fc09db05d8a4db6eae3af1c0586e22b1b77)
- Renamed variable. [`cc73c49`](https://github.com/ImageMagick/ImageMagick/commit/cc73c49654f15c11e8e8ce1d3810c78b0f8d6a1a)
- Renamed variable. [`b0cda46`](https://github.com/ImageMagick/ImageMagick/commit/b0cda462f3a8190fd1694087eb44b12866159f00)
- Whitespace. [`341249b`](https://github.com/ImageMagick/ImageMagick/commit/341249be9340fc3382c86045779b756dae43fe87)
- https://github.com/ImageMagick/ImageMagick/issues/4059 [`0ad86b1`](https://github.com/ImageMagick/ImageMagick/commit/0ad86b1de8de30a95f52e291f556836c7ce27701)
- Fixed typo. [`a538bea`](https://github.com/ImageMagick/ImageMagick/commit/a538beafd0c2edc9111663e62cff4e8127b07a29)
- Added missing typecast. [`affcc88`](https://github.com/ImageMagick/ImageMagick/commit/affcc8804ab94d0d6dc0ee5afe8089517a1050ce)
- Minor optimization when nothing will change. [`0b295fb`](https://github.com/ImageMagick/ImageMagick/commit/0b295fbcf5d69a4388f67df55a7dbd468f5786e8)
- Removed define that breaks with the Windows 10 SDK version 2104. [`ae0bf44`](https://github.com/ImageMagick/ImageMagick/commit/ae0bf4469b4546914e1cd3767d560e665876e92a)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=38401 [`c5d3358`](https://github.com/ImageMagick/ImageMagick/commit/c5d3358acc7cb76b9321004ff3fe6342e7c630e7)
- Added separate method for MSVG rendering. [`5bc6089`](https://github.com/ImageMagick/ImageMagick/commit/5bc608983b3d1b364e91d927cb0fdca037b44b8e)
- Code style change. [`67bafc4`](https://github.com/ImageMagick/ImageMagick/commit/67bafc4db482d5d90fa4455293c982713b11dee0)
- Added extra policy check. [`faad5a3`](https://github.com/ImageMagick/ImageMagick/commit/faad5a3caa24d7d0b34a7d8fe3f2b214a626293a)
- Code style changes. [`325f1f1`](https://github.com/ImageMagick/ImageMagick/commit/325f1f12643ed86f893b347c21f0811ff2a1dfee)
- Fixed incorrect check when module is used as the domain in policy.xml that would allow the use of a disabled module. [`816a070`](https://github.com/ImageMagick/ImageMagick/commit/816a070b8039102d1ead418c5101761cd7505836)
- Use InheritException instead. [`d2a2f1c`](https://github.com/ImageMagick/ImageMagick/commit/d2a2f1ca5917cfbdfa188b0a8a534061659db2cb)
- Added missing policy checks in RegisterStaticModules. [`35893e7`](https://github.com/ImageMagick/ImageMagick/commit/35893e7cad78ce461fcaffa56076c11700ba5e4e)
- Added early exits. [`b344d1f`](https://github.com/ImageMagick/ImageMagick/commit/b344d1f1090e73ce488938d6e5f5ac96a792356b)
- Use AllPolicyRights instead. [`6920157`](https://github.com/ImageMagick/ImageMagick/commit/6920157d93973bc8f75bc60fa2f22da5127f1f4b)
- Revert break to make it possible to use and allow list. [`8fa0697`](https://github.com/ImageMagick/ImageMagick/commit/8fa069797945f7b6e64b33cad4780311ff1b4ad5)
- Use the correct rights. [`01faddb`](https://github.com/ImageMagick/ImageMagick/commit/01faddbe2711a4156180c4a92837e2f23683cc68)
- Added missing call to CloseBlob. [`225b51d`](https://github.com/ImageMagick/ImageMagick/commit/225b51d7f2e86b8c8588022fe1e391249d023904)
- Fixed memory leak. [`f9c35c9`](https://github.com/ImageMagick/ImageMagick/commit/f9c35c91bac4d6380edeaaad8e536a7ef1fdb489)
- Clean up the remaining PDF files if reading one of the files fails. [`51d10c0`](https://github.com/ImageMagick/ImageMagick/commit/51d10c05d5a4a409a80d90826dd3fbdd2b765c5f)
- Update comment about availbale ImageTypes [`59b288d`](https://github.com/ImageMagick/ImageMagick/commit/59b288da691c30adf330334898261eff868bd13d)
- pending release [`9d3fc1a`](https://github.com/ImageMagick/ImageMagick/commit/9d3fc1a6142ee1180692d5a79f8c4367527d6843)
- Added missing calls to clean up the tile_image. [`a0232bf`](https://github.com/ImageMagick/ImageMagick/commit/a0232bf812f419c97eedde66e0a764f318eab7bd)
- Code style changes. [`86f886d`](https://github.com/ImageMagick/ImageMagick/commit/86f886daf4d48f966a47a70ab8e1bd6003565267)
- Code cleanup. [`2819152`](https://github.com/ImageMagick/ImageMagick/commit/28191523ff8650a3b4f28bbffcc60e02f593abc4)
- Also set RGB channels when reading the image. [`adbc185`](https://github.com/ImageMagick/ImageMagick/commit/adbc1855ec4768bd6069d7749185410ecef63a37)
- Added missing call to ConstrainColormapIndex. [`ea286be`](https://github.com/ImageMagick/ImageMagick/commit/ea286be7fdc95934b4773d3ef9d8eeb4efafd0b3)
- pending release [`bae7240`](https://github.com/ImageMagick/ImageMagick/commit/bae72403751eeaac75b87216ca34b59254c2af3e)
- Don't set the resolution when the cropbox is used. (#2657) [`ae08737`](https://github.com/ImageMagick/ImageMagick/commit/ae0873767ab7b862e3d50a852279150e2f692fb2)
- pending release [`9a01274`](https://github.com/ImageMagick/ImageMagick/commit/9a01274ab11088c8d59713748c0554bb4d534699)
- https://github.com/ImageMagick/ImageMagick/issues/2579 [`9108421`](https://github.com/ImageMagick/ImageMagick/commit/91084218c9a9d2fdcdb2f11d8af797acfc21d367)
- pending release [`720b86f`](https://github.com/ImageMagick/ImageMagick/commit/720b86f5d2c130b9dffb5e0e5a7b72f2c041b2a8)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=38573 [`6d00c96`](https://github.com/ImageMagick/ImageMagick/commit/6d00c96343ce0f5d3a91327c4ef2ed42fbcf86ad)
- https://github.com/ImageMagick/ImageMagick/issues/2576 [`d368d3c`](https://github.com/ImageMagick/ImageMagick/commit/d368d3c6bab35ad8857acaccc7b85d10c021c2c8)
- pending release [`957e478`](https://github.com/ImageMagick/ImageMagick/commit/957e47818ef0ae9ce73ade28a649ee7411a736e7)

## [7.1.0-6](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-5...7.1.0-6) - 2021-09-04

### Commits

- ... [`2d444c9`](https://github.com/ImageMagick/ImageMagick/commit/2d444c93b34f1a77c7d1d7570ba3e9350697af4e)
- ./configure --help no longer lists -disable-assert twice [`ac8fdfa`](https://github.com/ImageMagick/ImageMagick/commit/ac8fdfa944724cf5565b33d3f876d5ebdefded71)
- https://github.com/ImageMagick/ImageMagick/issues/4121 [`3c9c259`](https://github.com/ImageMagick/ImageMagick/commit/3c9c25927f6601dc778278de595b5cb0a4da6bd1)
- tweak the bilevel image type [`83fb8c8`](https://github.com/ImageMagick/ImageMagick/commit/83fb8c8644eeac8c667bbcb19b647c36830cc64f)
- Whitespace. [`70956aa`](https://github.com/ImageMagick/ImageMagick/commit/70956aa4058c556b5b3f0a28416951ba966d4419)
- Code style fixes. [`8447575`](https://github.com/ImageMagick/ImageMagick/commit/8447575dace7a606f73a8c3e2f374d907af382c1)
- Some optimizations when reading the exif profile. [`eb7cd80`](https://github.com/ImageMagick/ImageMagick/commit/eb7cd800ba6392ae6bd05f71a2c2718e59848af5)
- https://github.com/ImageMagick/ImageMagick/issues/4105 [`90914bd`](https://github.com/ImageMagick/ImageMagick/commit/90914bd1b924ef4b95c24a3ca1e579252d2fc5fc)
- Also prevent disabling highres for a quantum depth above 16 [`bc6d819`](https://github.com/ImageMagick/ImageMagick/commit/bc6d819af99d742bd6cdcc2f191af2a72600898e)
- Code style changes. [`3b90f52`](https://github.com/ImageMagick/ImageMagick/commit/3b90f52ce2fb342d26bf8e0c2cf60f9e312e2bd2)
- Some more code cleanup. [`99f677d`](https://github.com/ImageMagick/ImageMagick/commit/99f677d622fc946f4376aa18846fdd85cead9a28)
- Added support for reading the XMP profile from iTXt chunk (#4114). [`02fab91`](https://github.com/ImageMagick/ImageMagick/commit/02fab910d4043b5d6d0ab41676d53741aaea334c)
- Comment changes. [`ccb5555`](https://github.com/ImageMagick/ImageMagick/commit/ccb5555af3aa0bc1b1197cf5e3ba0c4049145c73)
- Minor changes to the formatting of the parentheses. [`827d30b`](https://github.com/ImageMagick/ImageMagick/commit/827d30b598bcd8e8ffdf1d80f4f468ce94a7ec72)
- Use different values per channel for scale and translate. [`4b9d95f`](https://github.com/ImageMagick/ImageMagick/commit/4b9d95fb1aa138cc75592f5331c5ce99faae94ba)
- https://github.com/ImageMagick/ImageMagick/issues/4128 [`37c9732`](https://github.com/ImageMagick/ImageMagick/commit/37c9732d4fd51f6868a7c005b6036a137cdccc8b)
- Add -dPrinted=false to the Ghostscript options (#4019) [`f9b8490`](https://github.com/ImageMagick/ImageMagick/commit/f9b8490463b7d98ffb795457ceb4cf6e09593619)
- Added missing define for the Windows build. [`6476508`](https://github.com/ImageMagick/ImageMagick/commit/6476508e5af1e6ad8be337fb526a4b955e5f98b5)
- Moved typecast to silence warnings. [`b069eb6`](https://github.com/ImageMagick/ImageMagick/commit/b069eb61b146e146c9583f72067c2426c3e1fe55)
- Minor refactoring. [`c2907ae`](https://github.com/ImageMagick/ImageMagick/commit/c2907ae9a2751ffd37981ea78e8b7b5d8495cdae)
- Updated .editorconfig. [`ffbe1ce`](https://github.com/ImageMagick/ImageMagick/commit/ffbe1cedd2aa83b365552bdadb44dc886fa0e792)
- Use link for the Windows build instructions instead. [`5ec7806`](https://github.com/ImageMagick/ImageMagick/commit/5ec78060a7a8a19066029f4eb32bee8eca4b585b)
- Removed extra endif that breaks the build. [`5992cba`](https://github.com/ImageMagick/ImageMagick/commit/5992cba82a8dc90ccdf39163189dc72408836df8)
- Add -HDRI to the quantum in the version string when HDRI is enabled. [`0e7233e`](https://github.com/ImageMagick/ImageMagick/commit/0e7233ef4256a7ac1a03bc726ca74f8228f192b9)
- https://oss-fuzz.com/testcase-detail/6502669439598592 [`1161978`](https://github.com/ImageMagick/ImageMagick/commit/1161978e8f3ff6607c5d0a34cd0e29150c4e29aa)
- pending release [`f500d17`](https://github.com/ImageMagick/ImageMagick/commit/f500d17454a43130ffb30bd4ca7836594eabb456)
- initialize buffer before calling TIFFGetField() [`428fa64`](https://github.com/ImageMagick/ImageMagick/commit/428fa64baa6075b93f09857aea77fdac74d16f86)
- Introduce new define for the visual studio version. [`94700f1`](https://github.com/ImageMagick/ImageMagick/commit/94700f1662e4ec293b0bea4e5d096d468988ebae)
- Removed checks for old Visual Studio versions. [`01ad6b3`](https://github.com/ImageMagick/ImageMagick/commit/01ad6b38b56cb3d1338eb959555e2eeffa986314)
- Include the compiler version in the output when it is known. [`cf472f4`](https://github.com/ImageMagick/ImageMagick/commit/cf472f4997caf053cd467ce10ae00c5fc696ed00)
- Fixed typo. [`e007d45`](https://github.com/ImageMagick/ImageMagick/commit/e007d45b069de531e763f369baeed10fb391c5c5)
- Revert local changes that should not have been committed yet. [`b9d8ebf`](https://github.com/ImageMagick/ImageMagick/commit/b9d8ebf930f22b375ffe09b59b33e6eb7e8ad44c)
- Use UTC date instead. [`7c589e7`](https://github.com/ImageMagick/ImageMagick/commit/7c589e7806142e6ee8d0afe68930ce7f501c214e)
- pending release [`a454b3a`](https://github.com/ImageMagick/ImageMagick/commit/a454b3a2aec75482aaaf040f072102b264e0fa35)

## [7.1.0-5](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-4...7.1.0-5) - 2021-08-22

### Merged

- fix #4097：Division by zero in ReadEnhMetaFile() of coders/emf.c [`#4098`](https://github.com/ImageMagick/ImageMagick/pull/4098)
- fix Division by zero in XMenuWidget() of MagickCore/widget.c [`#4041`](https://github.com/ImageMagick/ImageMagick/pull/4041)

### Fixed

- fix #4097：Division by zero in ReadEnhMetaFile() of coders/emf.c (#4098) [`#4097`](https://github.com/ImageMagick/ImageMagick/issues/4097)

### Commits

- Corrected remark to make it clear that this is for both reading and writing. [`5c09e3e`](https://github.com/ImageMagick/ImageMagick/commit/5c09e3e9cc6f904114e5c71cd1ff1a6df46cb9f8)
- ... [`085c116`](https://github.com/ImageMagick/ImageMagick/commit/085c1165f6158ebf968342d5a7d86690fdd7cf88)
- timeb.h is deprecated [`18e9f44`](https://github.com/ImageMagick/ImageMagick/commit/18e9f449af1847f650bab4d482d8e78b962748f8)
- eliminate compiler warning [`f0ed21d`](https://github.com/ImageMagick/ImageMagick/commit/f0ed21d134c26e5c2153c2910bf5b709553de393)
- reset image structure magick member [`7480434`](https://github.com/ImageMagick/ImageMagick/commit/748043424030bc4e01875812e199601c78739c72)
- optimize on grayscale detection [`11c49cd`](https://github.com/ImageMagick/ImageMagick/commit/11c49cde3c2b00cf5097d804f695762bc486ddc2)
- migrate colorspace:auto-grayscale from MagickCore to coders where it belongs [`2af2970`](https://github.com/ImageMagick/ImageMagick/commit/2af297015b3752df59794ae554f8df33103caff3)
- slight grayscale optimization [`b3f2cc6`](https://github.com/ImageMagick/ImageMagick/commit/b3f2cc6adf6f3b108958944eb4a7f58c96dd5ffc)
- fix compiler exception [`84d7493`](https://github.com/ImageMagick/ImageMagick/commit/84d7493233fdbc60ad979bd97071c9bca121ce0a)
- optimizing grayscale images, a work in progress [`e265516`](https://github.com/ImageMagick/ImageMagick/commit/e26551682dd93331b6f3ef78a2ac366226df4915)
- additional grayscale optimizations [`acbf6a8`](https://github.com/ImageMagick/ImageMagick/commit/acbf6a87adc8b6a86628e006b8582a43c4ac4fc0)
- ensure we set image gamma to 1 for linear grayscale image types [`4dac01e`](https://github.com/ImageMagick/ImageMagick/commit/4dac01ec2f038b75316c99c64a3c0dbaed717cd5)
- identify grayscale images lurking in the PPM image format [`e4b53d0`](https://github.com/ImageMagick/ImageMagick/commit/e4b53d0f17962641e0502a93ec9c7a13b7086c98)
- cosmetic [`2c2545d`](https://github.com/ImageMagick/ImageMagick/commit/2c2545d439c43bc2f5c1ebc2c6a9ad8511ecc359)
- set proper colormap index channel [`3ca9d29`](https://github.com/ImageMagick/ImageMagick/commit/3ca9d2972527b867f2c96b4997ddbd2ffc68d535)
- grayscale images were not being written properly [`944a910`](https://github.com/ImageMagick/ImageMagick/commit/944a910a82f654e2eb2dc28d3081594d18b6a393)
- Whitespace changes. [`85e440a`](https://github.com/ImageMagick/ImageMagick/commit/85e440a514fc24e78f51c7611538a02a44f812ac)
- slight optimization [`3aee329`](https://github.com/ImageMagick/ImageMagick/commit/3aee329e309398b1e830a7293b15ab6cb9a48c9c)
- revert [`fcbce07`](https://github.com/ImageMagick/ImageMagick/commit/fcbce07c69505662575c09069802fe894c6a8dd2)
- check is colorspace is incompatible before transforming it to sRGB [`f9e7a09`](https://github.com/ImageMagick/ImageMagick/commit/f9e7a09d8c2a1f24cfab503ac80cf2426b9c289d)
- revert and revisit [`386f933`](https://github.com/ImageMagick/ImageMagick/commit/386f933f4197446ced4873b184b966885c52229b)
- reduce memory moves [`316adb6`](https://github.com/ImageMagick/ImageMagick/commit/316adb6d5f257c51dd47bf9f47f20d141f1e57ec)
- revert [`5ee49d6`](https://github.com/ImageMagick/ImageMagick/commit/5ee49d66e6534ab7d145dce89e502a6d0b9f18fa)
- heap-based buffer overflow in TIFF coder (alert from Hunter Mitchell) [`1fa6e59`](https://github.com/ImageMagick/ImageMagick/commit/1fa6e59b0a8ae937cd04893ab3c6cdbdca0b5433)
- heap-based buffer overflow in TIFF coder (alert from Hunter Mitchell) [`1ef7420`](https://github.com/ImageMagick/ImageMagick/commit/1ef7420842ae912a746350605b016b928ab0004d)
- heap-based buffer overflow in TIFF coder (alert from Hunter Mitchell) [`005f7b9`](https://github.com/ImageMagick/ImageMagick/commit/005f7b9b4faba4a218befdae0d109fdfce0e8496)
- revert grayscale optimization for now [`a8416bd`](https://github.com/ImageMagick/ImageMagick/commit/a8416bdc2a2a4bc04a9c0e9acf53cb4d070c9ab3)
- check for grayscale with alpha channel [`6eea084`](https://github.com/ImageMagick/ImageMagick/commit/6eea084fd9f9f1be258376547344ca199ddc4625)
- revert [`b6800c8`](https://github.com/ImageMagick/ImageMagick/commit/b6800c8f2aed871845b70462a70c8155abec1419)
- Add support for writing the alpha channel (#1361) [`9da8d9c`](https://github.com/ImageMagick/ImageMagick/commit/9da8d9ccef4eaf37b3c765aae1399d8d2d83f0c6)
- Removed incorrect assert. [`a365542`](https://github.com/ImageMagick/ImageMagick/commit/a36554278729ca2ab6dc9e84a220528380ec06a9)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=36990 [`d137050`](https://github.com/ImageMagick/ImageMagick/commit/d137050dbe63cf1dcc815d6ecb5dfd1d56624335)
- https://github.com/ImageMagick/ImageMagick/issues/4059 [`b93a6a2`](https://github.com/ImageMagick/ImageMagick/commit/b93a6a2be891f1dbc761bdf4774b2e25b9109ff2)
- Corrected indentation. [`1b25f37`](https://github.com/ImageMagick/ImageMagick/commit/1b25f37fb374cb371d78e6ba139ad9bf7a9bf6fe)
- Added support for reading the embedded thumbnail. [`06b50d3`](https://github.com/ImageMagick/ImageMagick/commit/06b50d3e60a23d23d11114f32fb128df86109033)
- https://github.com/ImageMagick/ImageMagick/issues/4059 [`c14022a`](https://github.com/ImageMagick/ImageMagick/commit/c14022ab5b8593cc5c4c3f6936af93d2f9fb58b7)
- Added the new option to the ChangeLog. [`7f4edad`](https://github.com/ImageMagick/ImageMagick/commit/7f4edad9ae80cccfa0250656f1df1ba85997f744)
- Fix typo - ellipical to elliptical [`346218b`](https://github.com/ImageMagick/ImageMagick/commit/346218b2d2d14466521d993e8c56c23fb9c8df76)
- Set the color encoding to fix writing JXL images with libjxl 0.5 (#4064) [`7fb6eda`](https://github.com/ImageMagick/ImageMagick/commit/7fb6eda2c0ce209bacdc38d1c88c4a7d26125322)
- Renamed the method. [`e28d7c5`](https://github.com/ImageMagick/ImageMagick/commit/e28d7c54773706b02c65045d3c4a1d9e8b589f4a)
- Use JxlColorEncodingSetToLinearSRGB instead. [`970724d`](https://github.com/ImageMagick/ImageMagick/commit/970724dfdbabb5476e314ec66723cbd93885fa3d)
- Use &amp; instead. [`c37514a`](https://github.com/ImageMagick/ImageMagick/commit/c37514ac3a08eece93ba23670529745026551c1f)
- Use a single buffer instead. [`c4367bc`](https://github.com/ImageMagick/ImageMagick/commit/c4367bc3ce261a03f74b66ff0c97cb7720b70725)
- Correct order. [`fff99c1`](https://github.com/ImageMagick/ImageMagick/commit/fff99c14b1eaa7d0d11865d8ac2199689679bd9b)
- Whitespace [`c79cf71`](https://github.com/ImageMagick/ImageMagick/commit/c79cf71e91bbdfff81ec0353f31671c2116c5dc1)
- The DDSD_CAPS flags should also always be set. [`357ec61`](https://github.com/ImageMagick/ImageMagick/commit/357ec616c7a0a7247bd861619f2b32028af7cd2f)
- stop parsing after exception [`21a99da`](https://github.com/ImageMagick/ImageMagick/commit/21a99da0c4da80453fa442998ffd92aa3f1716e8)
- stop parsing on exception [`f0af490`](https://github.com/ImageMagick/ImageMagick/commit/f0af49097aafef2fcd391ee48ca02fb8ec99277c)
- Added new method to also preserve the creation of a file on Windows. This also fixes setting the timestamps on utf8 file names. [`df0b5ac`](https://github.com/ImageMagick/ImageMagick/commit/df0b5ac3eab808c0b39c497dcad41321dd8b4de6)
- Fixed build on non-Windows platform. [`86812bb`](https://github.com/ImageMagick/ImageMagick/commit/86812bb015dc8963d5bc006ce0b92207a12c7bac)
- Removed unused include. [`8334a7e`](https://github.com/ImageMagick/ImageMagick/commit/8334a7efba0571dc6a1561295eb1a309c5da65eb)
- prefer utimensat() over utime() [`481c8a4`](https://github.com/ImageMagick/ImageMagick/commit/481c8a4d165374a4e1262e75480147e3996f1072)
- Make sure a value is returned. [`1e59b57`](https://github.com/ImageMagick/ImageMagick/commit/1e59b5794eb74d1ff33138a79813fd23b36ad847)
- cosmetic [`19cadba`](https://github.com/ImageMagick/ImageMagick/commit/19cadba2492ebb41dddbaea6c4219d2593f90129)
- st_atim is st_atimespec under Apple/NetBSD [`fa64172`](https://github.com/ImageMagick/ImageMagick/commit/fa64172595cece87878e7b0b6439fca0e900b118)
- Fix memory leak in AnimateImageCommand() of MagickWand/animate.c and DisplayImageCommand() of MagickWand/display.c [`1630cbb`](https://github.com/ImageMagick/ImageMagick/commit/1630cbb8a5065aa769466baedac91f87e5c5bc89)
- pending release [`007c888`](https://github.com/ImageMagick/ImageMagick/commit/007c8882eb8b72878ae7a0209f1e2d225e533889)
- Added missing call to DestroyDisplay. [`b38b91d`](https://github.com/ImageMagick/ImageMagick/commit/b38b91d035cd5524431563d91983dd803d1c7d2f)
- Added .editorconfig. [`558ff49`](https://github.com/ImageMagick/ImageMagick/commit/558ff49afbde4c208cf380682772a09cd9ee6746)
- Upgrade solution instead. [`a225f4c`](https://github.com/ImageMagick/ImageMagick/commit/a225f4c065bb9ed031777ea8f4893f991f01e37d)
- Fix typo - Rodidoux to Robidoux [`f03ee36`](https://github.com/ImageMagick/ImageMagick/commit/f03ee363ed5a541383ee9f9dcda67a90c8aa7a24)
- Update reference to ImageMagick-6 [`4d65ee5`](https://github.com/ImageMagick/ImageMagick/commit/4d65ee597fd05151a9e7d8467c1e17f87baaa273)
- cosmetic [`8c6e77e`](https://github.com/ImageMagick/ImageMagick/commit/8c6e77e03928ece193767f7ad9a1485b79578099)
- cosmetic [`8dd4859`](https://github.com/ImageMagick/ImageMagick/commit/8dd4859aac64ca758e15ba20c9f9f2fc0c1e58f0)
- pending release [`69ba0c4`](https://github.com/ImageMagick/ImageMagick/commit/69ba0c45f657e7b7bf5171099de24c5c57898684)
- Use new solution that is already upgrade to VS2019. [`8f77c3c`](https://github.com/ImageMagick/ImageMagick/commit/8f77c3c9caeb586f4a77e5aa09ade19320b67fe0)
- pending release [`6e11e59`](https://github.com/ImageMagick/ImageMagick/commit/6e11e59b8a8111c3052dfea99312d802254ebe95)
- https://github.com/ImageMagick/ImageMagick/discussions/4096 [`dc1df68`](https://github.com/ImageMagick/ImageMagick/commit/dc1df68764b537d90be3311f6413c4271ef1ad22)
- Corrected return type to fix emscripten build error. [`bdeb549`](https://github.com/ImageMagick/ImageMagick/commit/bdeb549c28e130a02fdf90791acf7a7d5e10a66a)
- Corrected return type to fix emscripten build error. [`9916dc4`](https://github.com/ImageMagick/ImageMagick/commit/9916dc45d319d0810882fd8d659246bcec041fff)
- pending release [`74f8154`](https://github.com/ImageMagick/ImageMagick/commit/74f8154136d2f631ca3e0421e6cf6c8dccd548f7)

## [7.1.0-4](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-3...7.1.0-4) - 2021-07-18

### Commits

- ... [`433d174`](https://github.com/ImageMagick/ImageMagick/commit/433d17474d91aa37c5d933062b9c0a12fcbe9cf3)
- https://github.com/ImageMagick/ImageMagick/issues/3896 [`73ef506`](https://github.com/ImageMagick/ImageMagick/commit/73ef50686e69dbc2ea709f87435b1fd7cd3e4f8b)
- ... [`3497eb4`](https://github.com/ImageMagick/ImageMagick/commit/3497eb45819651fc3f16a4ee2e0e6c4f3c5c56cb)
- remove virtual canvas offset from similarity image [`e87b9ea`](https://github.com/ImageMagick/ImageMagick/commit/e87b9ea62438e2f679548bb2e50a3a64892b001d)
- ... [`418102d`](https://github.com/ImageMagick/ImageMagick/commit/418102ddffba555a18480b79de8713e69bdebe16)
- ... [`5bd18b5`](https://github.com/ImageMagick/ImageMagick/commit/5bd18b5181671f534e9a01f366a19c7b6d902438)
- search for fftw delegate library by default [`7c082c3`](https://github.com/ImageMagick/ImageMagick/commit/7c082c32a622763b11644e05a16ea4ad717b09b8)
- ... [`d2a7a08`](https://github.com/ImageMagick/ImageMagick/commit/d2a7a083b6aa31232ecd90c28399059bbd747c77)
- Call MagickWandTerminus instead of MagickCoreTerminus to also destroy the wand id's. [`e80cbdf`](https://github.com/ImageMagick/ImageMagick/commit/e80cbdf3752eb5c8972f579ba9f88cfc235db524)
- Fixed writing the iptc information when it is not stored as long. [`9f44f1e`](https://github.com/ImageMagick/ImageMagick/commit/9f44f1eb60a7669a0fd07ffb3086ba2075b8dd11)
- revert, use -enable-fftw to include FFT support [`273b425`](https://github.com/ImageMagick/ImageMagick/commit/273b425df8f66dec898b3774b2ae24a8ea5d60ad)
- https://github.com/ImageMagick/ImageMagick/issues/3951 [`e7d3e18`](https://github.com/ImageMagick/ImageMagick/commit/e7d3e182b72ff9b2c3ea1c9aa0f14d69cc968ba7)
- make genesis/terminus calls symmetric [`eddd1d9`](https://github.com/ImageMagick/ImageMagick/commit/eddd1d9d55b1bbda1b1ddad5c775fe251c65b003)
- pending release [`fa6c65a`](https://github.com/ImageMagick/ImageMagick/commit/fa6c65a4c40e1fa63629cff9d847191b270378da)
- revert; keep CoreGenesis/CoreTerminus pairs; destroy wand ids [`d987d2d`](https://github.com/ImageMagick/ImageMagick/commit/d987d2d852bc55dd6d0895decf16d4d95bd5ba07)
- include header that defines DestroyWandIDs() [`2618a34`](https://github.com/ImageMagick/ImageMagick/commit/2618a34db049f68eea07d010de6961cc1ea63a1a)
- Added new video options to the ChangeLog. [`8930dae`](https://github.com/ImageMagick/ImageMagick/commit/8930dae0d126fff1ff3ccb76b12da895c7b2c89a)
- Use MagickWandGenesis and Terminus instead. [`2e262f3`](https://github.com/ImageMagick/ImageMagick/commit/2e262f3b1196b2ff8a43eaf454fc6fc52f805d91)
- pending release [`159d069`](https://github.com/ImageMagick/ImageMagick/commit/159d06999c78d620f07de749dea93137527114d6)
- revert mods [`bb96fe8`](https://github.com/ImageMagick/ImageMagick/commit/bb96fe8039793751e7815b1c7d0aad6cd98cff3f)
- pending release [`0c074c1`](https://github.com/ImageMagick/ImageMagick/commit/0c074c122501a5bc3831ff4f95a6bf2e323929ce)
- Corrected call to RelinquishUniqueFileResource. [`4c1f846`](https://github.com/ImageMagick/ImageMagick/commit/4c1f84677557e44ae7c1e1c698a9415993a9dbee)
- Set the file to null to make sure a new file is written. [`59c28ac`](https://github.com/ImageMagick/ImageMagick/commit/59c28ac750bfdb5c67ee72cbd5d9906e7227f50d)
- Corrected cleanup of temporary files. [`8eb9c6c`](https://github.com/ImageMagick/ImageMagick/commit/8eb9c6c4898ac774a4c97dcfb783d0c751e64736)
- pending release [`5369493`](https://github.com/ImageMagick/ImageMagick/commit/53694931e6abe01d86ecabd3b45dc60a0d7461df)

## [7.1.0-3](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-2...7.1.0-3) - 2021-07-17

### Merged

- magick.sh.in: Corrected sample command [`#3867`](https://github.com/ImageMagick/ImageMagick/pull/3867)

### Commits

- Test with mingw-w64 using MSYS2 CI [`6509eba`](https://github.com/ImageMagick/ImageMagick/commit/6509eba48ebb5fd8a398a3548389ddcec0b60836)
- ... [`20cee9e`](https://github.com/ImageMagick/ImageMagick/commit/20cee9ed101b9b57f3202f5e982a7621d3df7040)
- ... [`2f59f48`](https://github.com/ImageMagick/ImageMagick/commit/2f59f484faf87958830755d3b29bfa16de1e8091)
- system() is not supported under IOS [`43c4c09`](https://github.com/ImageMagick/ImageMagick/commit/43c4c099f349fba0d033b731064a1d021c1c80ad)
- Moved define to silence warning [`7107723`](https://github.com/ImageMagick/ImageMagick/commit/7107723e5c107f7f6146e5a42ae0d2f9c8f6b90f)
- Use markdown in the intro instead. [`48e729d`](https://github.com/ImageMagick/ImageMagick/commit/48e729dced01220ed5cf4f7035afaff4aab01a32)
- Try a different syntax instead. [`8c5a1af`](https://github.com/ImageMagick/ImageMagick/commit/8c5a1af2aadb054a086348ef87ab4ad6248a30ce)
- Remove newline [`1ebec54`](https://github.com/ImageMagick/ImageMagick/commit/1ebec5455d4783125cca25fdd6631b617ba99296)
- Try without markdown. [`b56a2f6`](https://github.com/ImageMagick/ImageMagick/commit/b56a2f62ef2ec44692490b654c6cfe6f1352efae)
- Set the pixel format to ARGB when reading an animated PNG file. [`95add9f`](https://github.com/ImageMagick/ImageMagick/commit/95add9f12b236e0bf51e4ad94fc3c4f7afdaa87e)
- Also allow specifying the pixel format when reading the image. [`81e4de3`](https://github.com/ImageMagick/ImageMagick/commit/81e4de31833026997edb9d85d540c623815afe55)
- Make it more clear that no memory is leaking. [`78228f0`](https://github.com/ImageMagick/ImageMagick/commit/78228f05b022912f368a3652da9937b135fe9311)
- The predictor tag should only be set for specific compression types. [`c55d9ac`](https://github.com/ImageMagick/ImageMagick/commit/c55d9ac269c1129230c82942820537acaab58261)
- Only get the number of channels once. [`d4ecdd3`](https://github.com/ImageMagick/ImageMagick/commit/d4ecdd329d067bafae6d59f91fcf65ed5ed57c71)
- Added typecast to silence warning. [`af8fc23`](https://github.com/ImageMagick/ImageMagick/commit/af8fc23d08bc770aade4fa807d254251f475062c)
- Only call GetImageChannels once. [`86ff043`](https://github.com/ImageMagick/ImageMagick/commit/86ff0435472a50877a83a26ccfccaa8365f08e08)
- support -evaluate:clamp setting [`85f61c1`](https://github.com/ImageMagick/ImageMagick/commit/85f61c1974daeb23d53ac693198fbdbdee8e35b7)
- ... [`6c23915`](https://github.com/ImageMagick/ImageMagick/commit/6c23915c22c46d322580909b99f515cd67277aa7)
- ... [`4480b3e`](https://github.com/ImageMagick/ImageMagick/commit/4480b3ec63f428c63c6c1f1c92e8dfd80326ca32)
- set imaginary component of the complex conjugate to -Ai [`3a9c3ed`](https://github.com/ImageMagick/ImageMagick/commit/3a9c3ed1e4b5aba7f6eef5a6c9af1974a4c7e16b)
- Moved PKGBUILD file to the ImageMagick-Windows repository. [`f3bca7e`](https://github.com/ImageMagick/ImageMagick/commit/f3bca7e8a352d18877e08170dbac37c4f376fa06)
- Added Windows MSYS2 to the daily build. [`1a50afe`](https://github.com/ImageMagick/ImageMagick/commit/1a50afeebd1a1204ffa748824af53717eebcdac8)
- Only do a single MSYS2 build in a regular commit. [`8b0e9aa`](https://github.com/ImageMagick/ImageMagick/commit/8b0e9aa6043782fa5d2a8e0a54e3a65e2b16f408)
- Restored changes that were removed by accident. [`c071597`](https://github.com/ImageMagick/ImageMagick/commit/c071597408a3265f7ef319b890e30b3cb2d7a7fc)
- Introduce helper method. [`7bdaf57`](https://github.com/ImageMagick/ImageMagick/commit/7bdaf57fe297802a158b10f29d2a847218b44eac)
- Use double instead. [`6680fc3`](https://github.com/ImageMagick/ImageMagick/commit/6680fc386ac06395c3ffd0cfa23207c34b336702)
- Added support for setting the interline_spacing (#3827) [`8ada7db`](https://github.com/ImageMagick/ImageMagick/commit/8ada7db5007dbf92477755c7bcd1d234ff1d63d9)
- Disable font antialiasing when text_antialias is false (#3906). [`0c6512f`](https://github.com/ImageMagick/ImageMagick/commit/0c6512f82749e054a393675c7b68fdba4f327397)
- accelerated correlation-based image similary using FFT local statistics [`a6515bf`](https://github.com/ImageMagick/ImageMagick/commit/a6515bf66736dee023a579dfc4a0b3922e447ccd)
- Added raqm to the autolinking list. [`c431f3f`](https://github.com/ImageMagick/ImageMagick/commit/c431f3f3a614aab0041b9643d1c022a04a0f76fd)
- Added missing typecast. [`ef201e1`](https://github.com/ImageMagick/ImageMagick/commit/ef201e152033a37913efa6dd191f96205df65f32)
- Added option to peek in the byte buffer. [`59d0b87`](https://github.com/ImageMagick/ImageMagick/commit/59d0b87bc168f0b510902f2402bc2cb5e9986704)
- Fixed parsing the spot colors of a postscript document. [`86f2fd2`](https://github.com/ImageMagick/ImageMagick/commit/86f2fd2c65b051d244de445a99f8419b89dd5b2f)
- Moved define inside other define to silence warning. [`5498b40`](https://github.com/ImageMagick/ImageMagick/commit/5498b40f1609caf3e3cfd427396a2014ea4dc905)
- Use defines from tiff headers to silence warnings. [`bad2e2d`](https://github.com/ImageMagick/ImageMagick/commit/bad2e2dac531eab540da9f19e687ccaf5769aa50)
- prevent blow-up when standard deviation is 0 [`6b1a23f`](https://github.com/ImageMagick/ImageMagick/commit/6b1a23fb3e75feddb217ed8dde7610c853a1ed30)
- The defines are not available on MacOS. [`edaaf13`](https://github.com/ImageMagick/ImageMagick/commit/edaaf1326e87293f269f3b83490264ce3dae5580)
- Corrected earlier patch. [`c09727c`](https://github.com/ImageMagick/ImageMagick/commit/c09727c8fed0d557e2f9f2bc9821913da06851a9)
- Silence warning. [`7b8159c`](https://github.com/ImageMagick/ImageMagick/commit/7b8159c1772d90f3e1a0cab56bea2a61e93e915a)
- Renamed variable. [`9264818`](https://github.com/ImageMagick/ImageMagick/commit/9264818998f920a9765d8d08986b4fc6a1dac923)
- Use different defines to silence warning. [`dffc5fd`](https://github.com/ImageMagick/ImageMagick/commit/dffc5fd0103ecb44223b200fc0ff43e0e62359fe)
- Replace all values with the new defines. [`cbd1212`](https://github.com/ImageMagick/ImageMagick/commit/cbd1212554265d32ad5ee803549b6f5e61f348d8)
- skip zero pixels when dividing [`431e9b2`](https://github.com/ImageMagick/ImageMagick/commit/431e9b2b4445400d08a9d1b48199c380d9edc0ce)
- Corrected return type. [`ed3933d`](https://github.com/ImageMagick/ImageMagick/commit/ed3933d5cf2c3c6ea605cdff5fddd3ba1291e3e4)
- Check if this silences the mingw warnings. [`5c4a256`](https://github.com/ImageMagick/ImageMagick/commit/5c4a256ca0bb8aee173d5ffc49e88e4e69d05cd9)
- Use a single check instead of multiple separate checks. [`a0b1ef3`](https://github.com/ImageMagick/ImageMagick/commit/a0b1ef32180ba0e71279d09da4a4f3c1a7575df4)
- fix threading issue [`3d924d1`](https://github.com/ImageMagick/ImageMagick/commit/3d924d1f29aa2bf40efb8ce036ee24c3c1ebbced)
- Try a different check. [`0b606a7`](https://github.com/ImageMagick/ImageMagick/commit/0b606a75680fc3970b925881537198d2fb6c4126)
- Corrected copy paste mistake. [`deb6c52`](https://github.com/ImageMagick/ImageMagick/commit/deb6c5268af1003c4f015580d731905e32b595a5)
- optimize NCC distortion [`d5a0e51`](https://github.com/ImageMagick/ImageMagick/commit/d5a0e51def85b5be295e8e1fb32b8f15c3f343d6)
- Restored __MINGW32__ check. [`f69e87d`](https://github.com/ImageMagick/ImageMagick/commit/f69e87d030988d83025f735c3100cfc2416a28eb)
- ... [`bec7f7b`](https://github.com/ImageMagick/ImageMagick/commit/bec7f7bbe74e41b382e8dc0a54a277c76bc1d9aa)
- optimize grayscale detection [`ae67947`](https://github.com/ImageMagick/ImageMagick/commit/ae67947f9c098d2bd70b29dd3d502df6161bd06b)
- check for zero demoninator [`1999a4b`](https://github.com/ImageMagick/ImageMagick/commit/1999a4ba5623a3e56e3cebf0b416fb8dfed63aaa)
- skip channels with a zero standard-deviation [`1618240`](https://github.com/ImageMagick/ImageMagick/commit/161824005ee122630dfe09ac54faf16e1a6e23ed)
- ... [`c4df93b`](https://github.com/ImageMagick/ImageMagick/commit/c4df93bb37c4d82aea20af77fdbfea5c3df54753)
- Try linking with different libraries. [`8d1c095`](https://github.com/ImageMagick/ImageMagick/commit/8d1c0955250540216d88c7f4ba9241e3357caa54)
- Add libwebp.a again. [`7f5451f`](https://github.com/ImageMagick/ImageMagick/commit/7f5451f1fd54f96f68da227a81afa02068bdcd80)
- remove debugging output [`e261961`](https://github.com/ImageMagick/ImageMagick/commit/e261961e2af8bd1031f5a54b4d2a184ac9728e35)
- ... [`2f8d1ea`](https://github.com/ImageMagick/ImageMagick/commit/2f8d1ea3a55c2c76d8fc19f716f58e029397fc17)
- default to FFT acceleration when HDRI/FFT is enabled [`63d6df8`](https://github.com/ImageMagick/ImageMagick/commit/63d6df8addd0e83c32b960dae19cad70df0b9f9c)
- https://github.com/ImageMagick/ImageMagick/issues/3925 [`a4aa7af`](https://github.com/ImageMagick/ImageMagick/commit/a4aa7afdeb56c495b9ed48852a768174382639c0)
- Corrected getting the image dimensions when identifying a postscript file. [`d3eaf1a`](https://github.com/ImageMagick/ImageMagick/commit/d3eaf1ad42d07e612cbf85c42b9e5ba719f9a527)
- Fixed copy paste mistake. [`40968cf`](https://github.com/ImageMagick/ImageMagick/commit/40968cff0716e3bd7e33e74be2f5258949fa4547)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=36248 [`cce49e3`](https://github.com/ImageMagick/ImageMagick/commit/cce49e30a5d1465f42d2c9b5deaa402ed2332f15)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=36257 [`606b7da`](https://github.com/ImageMagick/ImageMagick/commit/606b7dab1c1f3e63b4cd2cca5d77ae3978a6659b)
- cosmetic [`692e6e0`](https://github.com/ImageMagick/ImageMagick/commit/692e6e0594ab861566d70a4ceadbfa5f22234e97)
- pending release [`a39db78`](https://github.com/ImageMagick/ImageMagick/commit/a39db78bea625be78c1574f26b754696b20c3289)

## [7.1.0-2](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-1...7.1.0-2) - 2021-06-25

### Commits

- ... [`580ab36`](https://github.com/ImageMagick/ImageMagick/commit/580ab36e3c1f35820007d76a65f899fe070ebd78)
- ... [`7e4a3fd`](https://github.com/ImageMagick/ImageMagick/commit/7e4a3fd49ce77e6ab77a31c1683f04f904e82658)
- ... [`c46b374`](https://github.com/ImageMagick/ImageMagick/commit/c46b37479fb7ddec1455a040c72aae0f61c76d46)
- fix memory corruption in ConcatenateStringInfo [`601356f`](https://github.com/ImageMagick/ImageMagick/commit/601356f1d2881b57945de8c22349d8758927f76a)
- pending release [`779e759`](https://github.com/ImageMagick/ImageMagick/commit/779e7591234a038f515f415cee7fdc42d1968d24)
- pending release [`c475e5e`](https://github.com/ImageMagick/ImageMagick/commit/c475e5eb6608b8e12b0a31ecb20817c65ad3c62c)

## [7.1.0-1](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-0...7.1.0-1) - 2021-06-20

### Commits

- ... [`50a0ccb`](https://github.com/ImageMagick/ImageMagick/commit/50a0ccbf19bc57f40a372a8c9de11e29de74bcce)
- ... [`2375efa`](https://github.com/ImageMagick/ImageMagick/commit/2375efa7071024ae4e7a229285860958b4ffdab4)
- ... [`ef93bbf`](https://github.com/ImageMagick/ImageMagick/commit/ef93bbf56ee823bad6ec8b35d415c51ff4ccf2b3)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=35322 [`4e56815`](https://github.com/ImageMagick/ImageMagick/commit/4e568154b4c8f9c3a3d5e86d433df013a1c65e96)
- https://github.com/ImageMagick/ImageMagick/issues/3844 [`ab847ac`](https://github.com/ImageMagick/ImageMagick/commit/ab847ac43f81ea470ac297bf17dc519b1bc06700)
- pending release [`85ae49e`](https://github.com/ImageMagick/ImageMagick/commit/85ae49e52b28376eee6c62a286217a7aae8efd3b)
- ver allocate memory, typically used when concatentating strings [`dfbf466`](https://github.com/ImageMagick/ImageMagick/commit/dfbf466c79608daf2ed4fe449c699eee4fae0891)
- Revert patch that automatically changes the image orientation #3844. [`b1d0888`](https://github.com/ImageMagick/ImageMagick/commit/b1d08886f2f4dce7a2edf24d954b46564ced8cd8)
- Moved type cast. [`98e5c74`](https://github.com/ImageMagick/ImageMagick/commit/98e5c745a15bfb366f7111230ab60349e4cb2220)
- pending release [`7d5d870`](https://github.com/ImageMagick/ImageMagick/commit/7d5d8709200877102c5a46c2a273c013c407aa77)
- Execute the video decode delegate differently to make it possible to add extra options. [`cc4638d`](https://github.com/ImageMagick/ImageMagick/commit/cc4638de0c98701b04478a7ecd828caaeb0b58bd)
- Added option to set the vsync option of the video decoder. [`b5604c4`](https://github.com/ImageMagick/ImageMagick/commit/b5604c459f80ff3421e4667d30cf11460a192c2a)
- Use const instead. [`95a729d`](https://github.com/ImageMagick/ImageMagick/commit/95a729dec8abc3aa294eb5cc01cb9d41ed76bfa1)
- Minor refactor. [`ab341ee`](https://github.com/ImageMagick/ImageMagick/commit/ab341eeb27d977eb70d67c54090d6b8fce169590)
- Renamed variables to make the code more readable. [`409b7c6`](https://github.com/ImageMagick/ImageMagick/commit/409b7c6303a5085408343b892d763b0a0e605075)
- Allow reading of incorrectly stored XMP profiles (#3617). [`e71d08a`](https://github.com/ImageMagick/ImageMagick/commit/e71d08aa98be7f1d42b638c12d5f5291a873eb75)
- The pixel memory should be available until WebPAnimEncoderAssemble has been called when writing an animated image. [`75600bb`](https://github.com/ImageMagick/ImageMagick/commit/75600bb09759939ec9ff9434b8dc8c7a53c8ba10)
- pending release [`0dfbabe`](https://github.com/ImageMagick/ImageMagick/commit/0dfbabe9a64c106cfded5aaa1759d39ee5f09272)
- Added extra method to silence warning. [`1f1b43e`](https://github.com/ImageMagick/ImageMagick/commit/1f1b43ea7a493b47d77a9f9de767f06ba511378d)
- pending release [`a5513da`](https://github.com/ImageMagick/ImageMagick/commit/a5513da1b8559fc6789248b7d5afdc1b0bc672e1)

## [7.1.0-0](https://github.com/ImageMagick/ImageMagick/compare/7.0.11-14...7.1.0-0) - 2021-06-12

### Commits

- ... [`20ff6c8`](https://github.com/ImageMagick/ImageMagick/commit/20ff6c82c75ecc5b8241610c25464daf01f615a3)
- Updated ChangeLog with jpeg-xl changes. [`57e2c38`](https://github.com/ImageMagick/ImageMagick/commit/57e2c3877b3b257467abcdf0c600561a658d7caf)
- ... [`0a231ef`](https://github.com/ImageMagick/ImageMagick/commit/0a231ef6295b99d27f08db1406ea3aff39bf8fd5)
- ... [`fadc0fc`](https://github.com/ImageMagick/ImageMagick/commit/fadc0fc36d01baad3651194e27938d375228d46f)
- https://github.com/ImageMagick/ImageMagick/issues/3765 [`4cfe557`](https://github.com/ImageMagick/ImageMagick/commit/4cfe557096716f29ab2b2c5202bb2024e63b198b)
- Use script from GitHub repository instead. [`a684bb0`](https://github.com/ImageMagick/ImageMagick/commit/a684bb010b8ef84481b1603d8a6b74d94c556439)
- Whitespace. [`435fad9`](https://github.com/ImageMagick/ImageMagick/commit/435fad9d1e61d5a3f595cb556986052c4db33e03)
- Added missing define MAGICKCORE_HAVE_UTIME for the Windows build (#3777) [`9be0520`](https://github.com/ImageMagick/ImageMagick/commit/9be05207eb24eed7a161ac90ce5650d392546e41)
- Minor refactoring. [`8d78773`](https://github.com/ImageMagick/ImageMagick/commit/8d78773891268cf41429ece4a688a80651818361)
- Fixed incorrect call to ThrowWriterException. [`f2a0b40`](https://github.com/ImageMagick/ImageMagick/commit/f2a0b4043f0c506df781dd715e161db5d2cb0b33)
- Added define to silence a warning. [`010ae56`](https://github.com/ImageMagick/ImageMagick/commit/010ae561b65e7106a440b86eef895477996b2981)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=35024 [`6eac50b`](https://github.com/ImageMagick/ImageMagick/commit/6eac50b44aa93f52d9244329446b1f45a680c162)
- Write the number of channels of the color profile instead of the image (#2070). [`53a01a2`](https://github.com/ImageMagick/ImageMagick/commit/53a01a2eb137c57e57f060705247fd3df81a5a5f)
- Fix memory leak when it failed to apply ICC color profile [`565b9c4`](https://github.com/ImageMagick/ImageMagick/commit/565b9c4c1d09cdcb016ab77a16c643b9a1755ae2)
- Corrected writing the icc profile in a PDF file (#2070). [`05486ef`](https://github.com/ImageMagick/ImageMagick/commit/05486efc97630a35f9c054f3fe2a4f09b103278a)
- When the compression is OJPEG the colorspace should not be changed to YCbCr. [`bb64ce7`](https://github.com/ImageMagick/ImageMagick/commit/bb64ce7240670b4f87bbeba4ac26d342cd1be016)
- The area value should only be atomic. [`220b524`](https://github.com/ImageMagick/ImageMagick/commit/220b5247245022d9f7636b9fab4adcef88ee3be9)
- ... [`8050b71`](https://github.com/ImageMagick/ImageMagick/commit/8050b715a47876f01921fbee2d9d210e59620f91)
- https://github.com/ImageMagick/ImageMagick/issues/3768 [`4cf2209`](https://github.com/ImageMagick/ImageMagick/commit/4cf220914f3aac3df8ddbb805d26ee670eb7d89f)
- https://github.com/ImageMagick/ImageMagick/issues/3768 [`61ef464`](https://github.com/ImageMagick/ImageMagick/commit/61ef464fc1f1163b4c5b9eacac68ab8ba872e107)
- https://github.com/ImageMagick/ImageMagick/issues/3818 [`864cf87`](https://github.com/ImageMagick/ImageMagick/commit/864cf878a04dbf976ca8e8b5dab7ddfd8a983aa2)
- https://github.com/ImageMagick/ImageMagick/issues/3818 [`c955242`](https://github.com/ImageMagick/ImageMagick/commit/c9552421c6e970ba8b2740d10a9ef230b58f7dd3)
- https://github.com/ImageMagick/ImageMagick/issues/3786 [`bccd8ab`](https://github.com/ImageMagick/ImageMagick/commit/bccd8abe11e42b1549a1ce2dcb809ed0d33519e5)
- https://github.com/ImageMagick/ImageMagick/discussions/3813 [`2430701`](https://github.com/ImageMagick/ImageMagick/commit/24307018801f6c0aea5a8286769a1d25c55ba611)
- https://github.com/ImageMagick/ImageMagick/issues/3779 [`59b1d3f`](https://github.com/ImageMagick/ImageMagick/commit/59b1d3fe20b237e61f12efaf321dbdd68b5e2d77)
- pending release [`9876f46`](https://github.com/ImageMagick/ImageMagick/commit/9876f46e75aa33874e2d5f807f1d68e2b7887a6d)
- ... [`869dd6b`](https://github.com/ImageMagick/ImageMagick/commit/869dd6bb77d9ded5da2e41fcf85dc580a28ce8aa)
- ... [`07b01f2`](https://github.com/ImageMagick/ImageMagick/commit/07b01f2760622b7ad0bed07b8dfb72cdf0444a81)
- ... [`3198e92`](https://github.com/ImageMagick/ImageMagick/commit/3198e92443989fba52c454c259d9495aea86defc)
- https://github.com/ImageMagick/ImageMagick/issues/3818 [`d64f1bb`](https://github.com/ImageMagick/ImageMagick/commit/d64f1bb3a4444898da8cc542c3b9bdda667ea3e9)
- pending release [`b4ca2be`](https://github.com/ImageMagick/ImageMagick/commit/b4ca2bed6e55417f439155eaa6a406ff71798116)
