from randomizer import symfile

symbols = symfile("roms/pokered.sym")

FIND = [a for a, b in [(106105, 52), (106112, 54), (106119, 29), (106713, 209), (106720, 36), (106727, 48), (107343, 35), (107350, 46), (123933, 38), (123940, 35), (123947, 40), (123954, 225), (123961, 233), (279510, 29), (279517, 38), (281351, 54), (281358, 247), (281901, 29), (281908, 18), (282909, 10), (282916, 49), (282923, 207), (282930, 19), (283503, 210), (283510, 40), (284199, 35), (284206, 202), (284213, 37), (284220, 72), (284227, 74), (284850, 16), (284857, 17), (284864, 38), (284871, 237), (285202, 36), (285209, 240), (285689, 49), (286262, 79), (286269, 2), (286276, 16), (286540, 2), (286547, 54), (301919, 20), (301926, 10), (301933, 40), (301940, 29), (301947, 20), (301954, 212), (303145, 35), (303152, 201), (303634, 17), (303641, 232), (303648, 54), (303655, 64), (329446, 245), (329739, 219), (334187, 217), (334194, 52), (334201, 205), (334208, 55), (335671, 39), (335678, 203), (336115, 39), (336652, 17), (336659, 37), (337078, 40), (337085, 16), (337092, 214), (337099, 222), (337112, 43), (344138, 10), (344145, 35), (345055, 204), (345853, 230), (362232, 216), (362239, 37), (362939, 220), (369402, 18), (369840, 226), (369847, 40), (369854, 38), (383710, 243), (383717, 40), (395143, 29), (395445, 82), (395452, 14), (395459, 35), (395904, 49), (396421, 40), (396428, 46), (397868, 11), (397875, 20), (397882, 4), (400064, 208), (400621, 81), (400640, 40), (401123, 80), (401130, 244), (401137, 17), (478270, 53), (478531, 16), (478538, 83), (478545, 49), (479646, 40), (290377, 20), (290390, 10), (290416, 80), (290429, 80), (290455, 18), (290475, 79), (290482, 49), (290489, 19), (290509, 82), (290516, 79), (290529, 49), (290536, 53), (290543, 82), (290550, 17), (290557, 49), (290564, 40), (290571, 2), (290578, 83), (290591, 49), (290598, 2), (290605, 10), (290625, 54), (290657, 16), (290676, 2), (290689, 83), (290703, 20), (290462, 19), (290876, 29), (290883, 18), (290638, 40), (290897, 40), (290928, 16), (290941, 49), (290954, 79), (290961, 83), (290968, 81), (290975, 40), (290982, 3)]]


symtext = []

for offset in FIND:
    closestsym = None
    closest = 0
    for symbol, symbol_offset in symbols.items():
        if symbol_offset > closest and symbol_offset <= offset:
            closest = symbol_offset
            closestsym = symbol
    symtext.append("self.symbols['{}'] + 0x{:x}".format(closestsym, offset-closest))

print("["+",\n".join(symtext)+"]")



