-- a_gp_globals.lua - created by Marioiscool246 on 1/14/2024, last updated on 10/26/2024 MM/DD/YY

-- Constants

GRAB_RELEASE_TYPE_NONE = 0
GRAB_RELEASE_TYPE_DROP = 1
GRAB_RELEASE_TYPE_THROW = 2
GRAB_RELEASE_TYPE_KNOCKBACK = 3
GRAB_RELEASE_TYPE_ESCAPE = 4

GRAB_HOLD_MODE_NORMAL = 0
GRAB_HOLD_MODE_BOWSER = 1
GRAB_HOLD_MODE_MAX = 2

-- Main mod globals

gGlobalSyncTable.mashoutEnabled = true
gGlobalSyncTable.grabThrowMult = 1.0
gGlobalSyncTable.groundPoundsBreaksGrabs = false
gGlobalSyncTable.checkSameTeam = false
gGlobalSyncTable.allowGrabHoldModeSwap = true

gPlayerGrabStates = {}

function player_grab_state_reset(localIndex)
    gPlayerGrabStates[localIndex].grabbing = {}
    gPlayerGrabStates[localIndex].grabbedBy = nil
    gPlayerGrabStates[localIndex].throwAngleVelY = 0
    gPlayerGrabStates[localIndex].holdPosY = 0.0
    gPlayerGrabStates[localIndex].incompleteLinkTimer = 0
    gPlayerGrabStates[localIndex].syncSeq = 0
    gPlayerGrabStates[localIndex].sentGrabRequest = false
    gPlayerGrabStates[localIndex].sentGrabRequestTimeout = 0
end

for i = 0, (MAX_PLAYERS - 1) do
    gPlayerGrabStates[i] = {}
    player_grab_state_reset(i)
end

gPlayerGrabHoldMode = GRAB_HOLD_MODE_NORMAL
gPlayerGrabHoldModeSwap = false

gPlayerGrabHoldModeNames = {
    [GRAB_HOLD_MODE_NORMAL] = "Normal",
    [GRAB_HOLD_MODE_BOWSER] = "Bowser Swing"
}

gPlayerGrabHoldActions = {
    [GRAB_HOLD_MODE_NORMAL] = ACT_HOLD_FREEFALL,
    [GRAB_HOLD_MODE_BOWSER] = ACT_PICKING_UP_BOWSER
}

gPlayerHoldActions = {
    [ACT_HOLD_PANTING_UNUSED] = ACT_HOLD_PANTING_UNUSED,
    [ACT_HOLD_IDLE] = ACT_HOLD_IDLE,
    [ACT_HOLD_HEAVY_IDLE] = ACT_HOLD_HEAVY_IDLE,
    [ACT_HOLD_JUMP_LAND_STOP] = ACT_HOLD_JUMP_LAND_STOP,
    [ACT_HOLD_FREEFALL_LAND_STOP] = ACT_HOLD_FREEFALL_LAND_STOP,
    [ACT_HOLD_BUTT_SLIDE_STOP] = ACT_HOLD_BUTT_SLIDE_STOP,
    [ACT_HOLD_WALKING] = ACT_HOLD_WALKING,
    [ACT_HOLD_HEAVY_WALKING] = ACT_HOLD_HEAVY_WALKING,
    [ACT_HOLD_DECELERATING] = ACT_HOLD_DECELERATING,
    [ACT_HOLD_BEGIN_SLIDING] = ACT_HOLD_BEGIN_SLIDING,
    [ACT_HOLD_BUTT_SLIDE] = ACT_HOLD_BUTT_SLIDE,
    [ACT_HOLD_STOMACH_SLIDE] = ACT_HOLD_STOMACH_SLIDE,
    [ACT_HOLD_JUMP_LAND] = ACT_HOLD_JUMP_LAND,
    [ACT_HOLD_FREEFALL_LAND] = ACT_HOLD_FREEFALL_LAND,
    [ACT_HOLD_QUICKSAND_JUMP_LAND] = ACT_HOLD_QUICKSAND_JUMP_LAND,
    [ACT_HOLD_JUMP] = ACT_HOLD_JUMP,
    [ACT_HOLD_FREEFALL] = ACT_HOLD_FREEFALL,
    [ACT_HOLD_BUTT_SLIDE_AIR] = ACT_HOLD_BUTT_SLIDE_AIR,
    [ACT_HOLD_WATER_JUMP] = ACT_HOLD_WATER_JUMP,
    [ACT_HOLD_WATER_IDLE] = ACT_HOLD_WATER_IDLE,
    [ACT_HOLD_WATER_ACTION_END] = ACT_HOLD_WATER_ACTION_END,
    [ACT_HOLD_BREASTSTROKE] = ACT_HOLD_BREASTSTROKE,
    [ACT_HOLD_SWIMMING_END] = ACT_HOLD_SWIMMING_END,
    [ACT_HOLD_FLUTTER_KICK] = ACT_HOLD_FLUTTER_KICK,
    [ACT_HOLD_METAL_WATER_STANDING] = ACT_HOLD_METAL_WATER_STANDING,
    [ACT_HOLD_METAL_WATER_WALKING] = ACT_HOLD_METAL_WATER_WALKING,
    [ACT_HOLD_METAL_WATER_FALLING] = ACT_HOLD_METAL_WATER_FALLING,
    [ACT_HOLD_METAL_WATER_FALL_LAND] = ACT_HOLD_METAL_WATER_FALL_LAND,
    [ACT_HOLD_METAL_WATER_JUMP] = ACT_HOLD_METAL_WATER_JUMP,
    [ACT_HOLD_METAL_WATER_JUMP_LAND] = ACT_HOLD_METAL_WATER_JUMP_LAND,
    [ACT_PICKING_UP] = ACT_PICKING_UP,
    [ACT_PICKING_UP_BOWSER] = ACT_PICKING_UP_BOWSER,
    [ACT_DIVE_PICKING_UP] = ACT_DIVE_PICKING_UP,
    [ACT_STOMACH_SLIDE_STOP] = ACT_STOMACH_SLIDE_STOP,
    [ACT_HOLDING_BOWSER] = ACT_HOLDING_BOWSER
}

gPlayerHoldIdleActions = {
    [ACT_HOLD_PANTING_UNUSED] = ACT_HOLD_PANTING_UNUSED,
    [ACT_HOLD_IDLE] = ACT_HOLD_IDLE,
    [ACT_HOLD_HEAVY_IDLE] = ACT_HOLD_HEAVY_IDLE,
    [ACT_HOLD_WATER_IDLE] = ACT_HOLD_WATER_IDLE,
    [ACT_HOLD_METAL_WATER_STANDING] = ACT_HOLD_METAL_WATER_STANDING,
    [ACT_HOLDING_BOWSER] = ACT_HOLDING_BOWSER
}

gPlayerAllowedInvulnActions = {
    [ACT_IN_QUICKSAND] = ACT_IN_QUICKSAND,
    [ACT_SHOCKWAVE_BOUNCE] = ACT_SHOCKWAVE_BOUNCE,
    [ACT_BURNING_GROUND] = ACT_BURNING_GROUND,
    [ACT_HARD_BACKWARD_GROUND_KB] = ACT_HARD_BACKWARD_GROUND_KB,
    [ACT_HARD_FORWARD_GROUND_KB] = ACT_HARD_FORWARD_GROUND_KB,
    [ACT_BACKWARD_GROUND_KB] = ACT_BACKWARD_GROUND_KB,
    [ACT_FORWARD_GROUND_KB] = ACT_FORWARD_GROUND_KB,
    [ACT_SOFT_BACKWARD_GROUND_KB] = ACT_SOFT_BACKWARD_GROUND_KB,
    [ACT_SOFT_FORWARD_GROUND_KB] = ACT_SOFT_FORWARD_GROUND_KB,
    [ACT_GROUND_BONK] = ACT_GROUND_BONK,
    [ACT_BURNING_GROUND] = ACT_BURNING_GROUND,
    [ACT_BACKWARD_AIR_KB] = ACT_BACKWARD_AIR_KB,
    [ACT_FORWARD_AIR_KB] = ACT_FORWARD_AIR_KB,
    [ACT_HARD_FORWARD_AIR_KB] = ACT_HARD_FORWARD_AIR_KB,
    [ACT_HARD_BACKWARD_AIR_KB] = ACT_HARD_BACKWARD_AIR_KB,
    [ACT_BURNING_JUMP] = ACT_BURNING_JUMP,
    [ACT_BURNING_FALL] = ACT_BURNING_FALL,
    [ACT_SOFT_BONK] = ACT_SOFT_BONK,
    [ACT_BACKWARD_WATER_KB] = ACT_BACKWARD_WATER_KB,
    [ACT_FORWARD_WATER_KB] = ACT_FORWARD_WATER_KB,
}

gPlayerKnockbackActions = {
    [ACT_HARD_BACKWARD_GROUND_KB] = ACT_HARD_BACKWARD_GROUND_KB,
    [ACT_HARD_FORWARD_GROUND_KB] = ACT_HARD_FORWARD_GROUND_KB,
    [ACT_BACKWARD_GROUND_KB] = ACT_BACKWARD_GROUND_KB,
    [ACT_FORWARD_GROUND_KB] = ACT_FORWARD_GROUND_KB,
    [ACT_SOFT_BACKWARD_GROUND_KB] = ACT_SOFT_BACKWARD_GROUND_KB,
    [ACT_SOFT_FORWARD_GROUND_KB] = ACT_SOFT_FORWARD_GROUND_KB,
    [ACT_GROUND_BONK] = ACT_GROUND_BONK,
    [ACT_BACKWARD_AIR_KB] = ACT_BACKWARD_AIR_KB,
    [ACT_FORWARD_AIR_KB] = ACT_FORWARD_AIR_KB,
    [ACT_HARD_FORWARD_AIR_KB] = ACT_HARD_FORWARD_AIR_KB,
    [ACT_HARD_BACKWARD_AIR_KB] = ACT_HARD_BACKWARD_AIR_KB,
    [ACT_BACKWARD_WATER_KB] = ACT_BACKWARD_WATER_KB,
    [ACT_FORWARD_WATER_KB] = ACT_FORWARD_WATER_KB,
}

gPlayerCheckMovingActionForGrabActions = {
    [ACT_RIDING_SHELL_GROUND] = ACT_RIDING_SHELL_GROUND,
    [ACT_BUTT_SLIDE] = ACT_BUTT_SLIDE,
    [ACT_STOMACH_SLIDE] = ACT_STOMACH_SLIDE,
    [ACT_HOLD_BUTT_SLIDE] = ACT_HOLD_BUTT_SLIDE,
    [ACT_HOLD_STOMACH_SLIDE] = ACT_HOLD_STOMACH_SLIDE,
    [ACT_DIVE_SLIDE] = ACT_DIVE_SLIDE,
    [ACT_CROUCH_SLIDE] = ACT_CROUCH_SLIDE,
    [ACT_SLIDE_KICK_SLIDE] = ACT_SLIDE_KICK_SLIDE,
    [ACT_DIVE] = ACT_DIVE,
    [ACT_SHOT_FROM_CANNON] = ACT_SHOT_FROM_CANNON,
    [ACT_FLYING] = ACT_FLYING,
    [ACT_RIDING_SHELL_JUMP] = ACT_RIDING_SHELL_JUMP,
    [ACT_RIDING_SHELL_FALL] = ACT_RIDING_SHELL_FALL,
    [ACT_TWIRLING] = ACT_TWIRLING,
    [ACT_SLIDE_KICK] = ACT_SLIDE_KICK,
}

gPlayerThrowActionTimers = {
    [ACT_THROWING] = 7,
    [ACT_AIR_THROW] = 6,
    [ACT_AIR_THROW_LAND] = 6,
    [ACT_WATER_THROW] = 5,
    [ACT_RELEASING_BOWSER] = 0,
}

gPlayerCharacterHoldZOffsets = {
    [CT_MARIO] = 27.0,
    [CT_LUIGI] = 26.0,
    [CT_TOAD] = 18.0,
    [CT_WALUIGI] = 33.0,
    [CT_WARIO] = 41.0
}