-- name: Faster Bubble Speed V4
-- description: Hold B while in a bubble to move faster. Hold A + B + Z to teleport to the nearest player, or teleport to a specific player using chat commands.\nCreated by Sunk.

--Arena code
--Thanks Djoslin
---@param name string
---@return string
local function strip_colors(name)
    local string = ''
    local inSlash = false
    for i = 1, #name do
        local character = name:sub(i, i)
        if character == '\\' then
            inSlash = not inSlash
        elseif not inSlash then
            string = string .. character
        end
    end
    return string
end

---@param player string
---@return MarioState | nil
local function get_mario_state_from_name(player)
    for i = 0, MAX_PLAYERS - 1, 1 do
        if gNetworkPlayers[i].connected then
            if string.lower(strip_colors(gNetworkPlayers[i].name)) == string.lower(strip_colors(player)) then
                return gMarioStates[i]
            end
        end
    end
    return nil
end

gGlobalSyncTable.multiplier = 1.07

---@param m MarioState
function fasterBubbling(m)
    if m.playerIndex ~= 0 then return end

    if gGlobalSyncTable.multiplier == nil then
        djui_chat_message_create("Something broke")
        gGlobalSyncTable.multiplier = 1.07
    end

    if (m.action == ACT_BUBBLED) and ((m.controller.buttonDown & B_BUTTON) ~= 0) then
        vec3f_mul(m.vel, gGlobalSyncTable.multiplier)
    end
end

---@param m MarioState
function teleBubbling(m)
    if m.playerIndex ~= 0 then return end

    ---@type MarioState
    local targetPlayer = nearest_mario_state_to_object(m.marioObj)

    if (m.action == ACT_BUBBLED) and
        ((m.controller.buttonDown & Z_TRIG) ~= 0) and ((m.controller.buttonDown & B_BUTTON) ~= 0) and ((m.controller.buttonDown & A_BUTTON) ~= 0) then
        vec3f_copy(m.pos, targetPlayer.pos)
    end
end

function on_faster_bubbling_chat_command(msg)
    if tonumber(msg) == nil then
        djui_chat_message_create("Please enter a number")
        return true
    end
    msg = tonumber(msg)

    --Speed does not seem to increase upon itsef as long as it's below this limit
    if msg > 1.1 then
        djui_chat_message_create("Going this fast will break bubbling")
    end
    djui_chat_message_create("Bubble speed set")
    gGlobalSyncTable.multiplier = msg
    return true
end

function on_tele_bubbling_chat_command(msg)
    if gMarioStates[0].action ~= ACT_BUBBLED then
        djui_chat_message_create("You must be in a bubble to use this command")
        return true
    end

    --If the target player is self, mention it and don't allow the teleport
    msg = strip_colors(msg)
    if (string.lower(msg) == string.lower(gNetworkPlayers[0].name)) or (tonumber(msg) == 0) then
        djui_chat_message_create("You cannot teleport to yourself")
        return true
    end

    ---@type MarioState
    local targetMarioState
    --Branches if a name or index is entered
    if tonumber(msg) == nil then
        --If a name is entered
        targetMarioState = get_mario_state_from_name(msg)
    else
        --If an index is entered
        targetMarioState = gMarioStates[tonumber(msg)]
    end

    if (targetMarioState == nil) or (not gNetworkPlayers[targetMarioState.playerIndex].connected) or (is_player_active(targetMarioState) == 0) then
        djui_chat_message_create("Enter a valid player")
        return true
    end

    vec3f_copy(gMarioStates[0].pos, targetMarioState.pos)

    return true
end

hook_event(HOOK_BEFORE_PHYS_STEP, fasterBubbling)
-- hook_event(HOOK_MARIO_UPDATE, teleBubbling)
_G.Moi64Mods.hook_mario_update(teleBubbling)
hook_chat_command("teleto", "Teleports to the specified player. Type in player name or index.",
    on_tele_bubbling_chat_command)
if network_is_server() then
    hook_chat_command('bubble', 'Changes the speed of bubbling. Recommended highest speed is 1.1.',
        on_faster_bubbling_chat_command)
end
