-- screenshot system

viewScreenshot = 0
local ssHud = true
screenshotMode = false
local confirmShot = false
local prevView = false
screenshots = {}
ssWaitForWarp = 0
local noFurtherTimer = 0
ssCooldown = 0

local LLS = gLakituState
local ssCamera = {
    pos = { x = 0, y = 0, z = 0 },
    pitch = 0,
    yaw = 0,
    roll = 0,
}

--[[local]] prevLocData = {
    level = 0,
    area = 0,
    act = 0,
    x = 0,
    y = 0,
    z = 0,
    peakHeight = 0,
    yaw = 0,
    action = 0,
    caps = 0,
    capTimer = 0,
}

-- controls (uses menu controls too)
---@param m MarioState
function ss_controls(m)
    if m.playerIndex ~= 0 then return end

    if m.freeze < 3 then m.freeze = 3 end

    -- Disable controls for everything but the menu
    sMenuInputsPressed = m.controller.buttonDown & (m.controller.buttonDown ~ sMenuInputsDown)
    sMenuInputsDown = m.controller.buttonDown
    m.controller.buttonDown = 0
    m.controller.buttonPressed = 0
    m.controller.stickX = 0
    m.controller.stickY = 0

    LLS.posHSpeed = 0
    LLS.posVSpeed = 0
    LLS.focHSpeed = 0
    LLS.focVSpeed = 0
    vec3f_copy(LLS.pos, ssCamera.pos)
    vec3f_copy(LLS.curPos, ssCamera.pos)
    vec3f_copy(LLS.goalPos, ssCamera.pos)
    local focus = {
        x = ssCamera.pos.x - sins(ssCamera.yaw) * coss(ssCamera.pitch),
        y = ssCamera.pos.y + sins(ssCamera.pitch),
        z = ssCamera.pos.z - coss(ssCamera.yaw) * coss(ssCamera.pitch)
    }
    vec3f_copy(LLS.focus, focus)
    vec3f_copy(LLS.curFocus, focus)
    vec3f_copy(LLS.goalFocus, focus)
    LLS.roll = 0
    LLS.keyDanceRoll = ssCamera.roll
    m.area.camera.yaw = ssCamera.yaw

    if not confirmShot then
        local speed = 0.5
        local rSpeed = 0.6
        local vSpeed = 64
        local rollSpeed = 256
        local zoomSpeed = 128
        if sMenuInputsDown & B_BUTTON ~= 0 then
            speed = speed / 2
            rSpeed = rSpeed / 2
            vSpeed = vSpeed // 2
            rollSpeed = rollSpeed // 2
            zoomSpeed = zoomSpeed // 2
        end

        -- movement
        local stickX = m.controller.rawStickX
        local stickY = m.controller.rawStickY
        ssCamera.pos.x = ssCamera.pos.x -
            math.floor(speed * (sins(ssCamera.yaw) * stickY + sins(ssCamera.yaw - 16384) * stickX))
        ssCamera.pos.z = ssCamera.pos.z -
            math.floor(speed * (coss(ssCamera.yaw) * stickY + coss(ssCamera.yaw - 16384) * stickX))

        -- pitch/yaw
        local x_invert = ((camera_config_is_free_cam_enabled() or camera_config_is_x_inverted()) and -1) or 1
        local y_invert = (camera_config_is_free_cam_enabled() and camera_config_is_y_inverted() and -1) or 1
        local mouseX = 0
        local mouseY = 0
        if camera_config_is_mouse_look_enabled() then
            mouseX = djui_hud_get_raw_mouse_x()
            mouseY = djui_hud_get_raw_mouse_y()
        end
        local rStickX = m.controller.extStickX
        local rStickY = m.controller.extStickY
        if m.controller.extStickX == 0 then
            if (sMenuInputsDown & R_CBUTTONS) ~= 0 then
                rStickX = clamp(stickX + 128, -128, 128)
            end
            if (sMenuInputsDown & L_CBUTTONS) ~= 0 then
                rStickX = clamp(stickX - 128, -128, 128)
            end
        end
        if m.controller.extStickY == 0 then
            if (sMenuInputsDown & U_CBUTTONS) ~= 0 then
                rStickY = clamp(stickY + 128, -128, 128)
            end
            if (sMenuInputsDown & D_CBUTTONS) ~= 0 then
                rStickY = clamp(stickY - 128, -128, 128)
            end
        end
        ssCamera.yaw = limit_angle(ssCamera.yaw -
            (rSpeed * rStickX - mouseX) * (x_invert * camera_config_get_x_sensitivity()))
        ssCamera.pitch = clamp(
            ssCamera.pitch - (rSpeed * rStickY + mouseY) * (y_invert * camera_config_get_y_sensitivity()), -0x3E00,
            0x3E00)

        -- roll
        if sMenuInputsDown & U_JPAD ~= 0 then
            ssCamera.roll = 0
        end
        if sMenuInputsDown & L_JPAD ~= 0 then
            ssCamera.roll = limit_angle(ssCamera.roll - rollSpeed)
        end
        if sMenuInputsDown & R_JPAD ~= 0 then
            ssCamera.roll = limit_angle(ssCamera.roll + rollSpeed)
        end

        -- vertical movement
        if sMenuInputsDown & A_BUTTON ~= 0 then
            ssCamera.pos.y = ssCamera.pos.y + vSpeed
        end
        if sMenuInputsDown & Z_TRIG ~= 0 then
            ssCamera.pos.y = ssCamera.pos.y - vSpeed
        end

        -- zoom
        if sMenuInputsDown & R_TRIG ~= 0 then
            if sMenuInputsPressed & R_TRIG ~= 0 then
                play_sound(SOUND_MENU_CAMERA_ZOOM_IN, m.marioObj.header.gfx.cameraToObject)
            end
            ssCamera.pos.x = ssCamera.pos.x - math.floor(speed * coss(ssCamera.pitch) * sins(ssCamera.yaw) * zoomSpeed)
            ssCamera.pos.y = ssCamera.pos.y + math.floor(speed * sins(ssCamera.pitch) * zoomSpeed)
            ssCamera.pos.z = ssCamera.pos.z - math.floor(speed * coss(ssCamera.pitch) * coss(ssCamera.yaw) * zoomSpeed)
        end
        if sMenuInputsDown & L_TRIG ~= 0 then
            if sMenuInputsPressed & L_TRIG ~= 0 then
                play_sound(SOUND_MENU_CAMERA_ZOOM_OUT, m.marioObj.header.gfx.cameraToObject)
            end
            ssCamera.pos.x = ssCamera.pos.x + math.floor(speed * coss(ssCamera.pitch) * sins(ssCamera.yaw) * zoomSpeed)
            ssCamera.pos.y = ssCamera.pos.y - math.floor(speed * sins(ssCamera.pitch) * zoomSpeed)
            ssCamera.pos.z = ssCamera.pos.z + math.floor(speed * coss(ssCamera.pitch) * coss(ssCamera.yaw) * zoomSpeed)
        end

        local dist, pitch, yaw = vec3f_get_dist_and_angle_lua(m.pos, ssCamera.pos)
        if dist > 3000 then
            if noFurtherTimer == 0 then
                play_sound(SOUND_MENU_CAMERA_BUZZ, m.marioObj.header.gfx.cameraToObject)
                djui_chat_message_create("Can't move camera further!")
            end
            noFurtherTimer = 5
            vec3f_set_dist_and_angle(m.pos, ssCamera.pos, 3000, pitch, yaw)
        elseif noFurtherTimer > 0 then
            noFurtherTimer = noFurtherTimer - 1
        end

        if ((sMenuInputsPressed & X_BUTTON) ~= 0 or ((sMenuInputsDown & L_TRIG) ~= 0 and (sMenuInputsPressed & R_TRIG) ~= 0)) and ssCooldown == 0 then
            play_sound(SOUND_MENU_CLICK_CHANGE_VIEW, m.marioObj.header.gfx.cameraToObject)
            if gGlobalSyncTable.hiding then
                screenshotMode = false
                LLS.roll = 0
                LLS.keyDanceRoll = 0
                ssCooldown = 90
                add_photo_points()
                return
            end
            confirmShot = true
        elseif (sMenuInputsPressed & Y_BUTTON) ~= 0 then
            ssHud = not ssHud
        elseif (sMenuInputsPressed & START_BUTTON) ~= 0 then
            m.controller.buttonDown = m.controller.buttonDown | START_BUTTON
            screenshotMode = false
            LLS.roll = 0
            LLS.keyDanceRoll = 0
        end
    else
        if (sMenuInputsPressed & B_BUTTON) ~= 0 then
            confirmShot = false
            ssHud = true
            play_sound(SOUND_MENU_CAMERA_BUZZ, m.marioObj.header.gfx.cameraToObject)
        elseif (sMenuInputsPressed & A_BUTTON) ~= 0 then
            ssCooldown = 90
            screenshotMode = false
            LLS.roll = 0
            LLS.keyDanceRoll = 0
            take_screenshot()
        end
    end
end

local SS_MENU_MUSIC = false

---@param m MarioState
function view_screenshot(m, shot)
    if m.playerIndex ~= 0 then return end
    local np = gNetworkPlayers[0]

    if m.freeze < 3 then m.freeze = 3 end

    if ssWaitForWarp ~= 0 then
        ssWaitForWarp = ssWaitForWarp - 1
        local data = prevLocData
        if (data.level == np.currLevelNum and data.area == np.currAreaIndex) or ssWaitForWarp == 1 then
            if np.currAreaSyncValid or ssWaitForWarp == 1 then
                m.pos.x = data.x
                m.pos.y = data.y
                m.pos.z = data.z
                m.peakHeight = data.peakHeight
                m.faceAngle.y = data.yaw
                if data.action == ACT_FLYING then
                    set_mario_action(m, ACT_FLYING, 0)
                elseif data.action & ACT_FLAG_AIR ~= 0 then
                    set_mario_action(m, ACT_SOFT_BONK, 0)
                else
                    force_idle_state(m)
                end
                m.flags = (m.flags & ~MARIO_SPECIAL_CAPS) | data.caps
                m.capTimer = data.capTimer
                lvl_set_current_level(0, data.level)
                ssWaitForWarp = 0
            end
        elseif not (warp_to_level(data.level, data.area, data.act) or warp_to_warpnode(data.level, data.area, data.act, 0)) then
            warp_to_warpnode(data.level, data.area, data.act, 0xf0)
        end
        return
    end

    if m.area.camera.cutscene ~= 0 then
        m.area.camera.cutscene = 0
        play_cutscene(m.area.camera)
    end

    if _G.SuperMomoi64 then
        if not SS_MENU_MUSIC then
            _G.SuperMomoi64.stop_custom_music()
            SS_MENU_MUSIC = true
        end
        _G.SuperMomoi64.play_custom_music("SS_MENU")
    end
    -- set_background_music(0, SEQ_MENU_TITLE_SCREEN, 0)

    -- Disable controls for everything but the menu
    sMenuInputsPressed = m.controller.buttonDown & (m.controller.buttonDown ~ sMenuInputsDown)
    sMenuInputsDown = m.controller.buttonDown
    m.controller.buttonDown = 0
    m.controller.buttonPressed = 0
    m.controller.stickX = 0
    m.controller.stickY = 0

    if prevView and sMenuInputsPressed & START_BUTTON ~= 0 then
        close_screenshot()
        m.controller.buttonDown = START_BUTTON
        return
    end

    if not m.floor then
        m.pos.x = 0
        m.pos.y = 0
        m.pos.z = 0
    end

    local data = screenshots[shot]
    if not data then return end

    if (not prevView) then
        prevLocData = {
            level = np.currLevelNum,
            area = np.currAreaIndex,
            act = np.currActNum,
            x = m.pos.x,
            y = m.pos.y,
            z = m.pos.z,
            peakHeight = m.peakHeight,
            yaw = m.faceAngle.y,
            action = m.action,
            caps = m.flags & MARIO_SPECIAL_CAPS,
            capTimer = m.capTimer,
        }
        add_log(true)

        if not (warp_to_level(data.level, data.area, data.act) or warp_to_warpnode(data.level, data.area, data.act, 0)) then
            warp_to_warpnode(data.level, data.area, data.act, 0xf0)
        end
        lvl_set_current_level(0, data.level)
        prevView = true
    end
    set_mario_action(m, ACT_UNINITIALIZED, 0)
    enable_time_stop_including_mario()

    LLS.posHSpeed = 0
    LLS.posVSpeed = 0
    LLS.focHSpeed = 0
    LLS.focVSpeed = 0
    local pos = { x = data.x, y = data.y, z = data.z }
    vec3f_copy(LLS.pos, pos)
    vec3f_copy(LLS.curPos, pos)
    vec3f_copy(LLS.goalPos, pos)
    local focus = {
        x = pos.x - sins(data.yaw) * coss(data.pitch),
        y = pos.y + sins(data.pitch),
        z = pos.z - coss(data.yaw) * coss(data.pitch)
    }
    vec3f_copy(LLS.focus, focus)
    vec3f_copy(LLS.curFocus, focus)
    vec3f_copy(LLS.goalFocus, focus)
    LLS.roll = 0
    LLS.keyDanceRoll = data.roll
    m.area.camera.yaw = data.yaw
    m.pos.x = data.mx
    m.pos.y = data.my
    m.pos.z = data.mz
end

function close_screenshot(noWarp)
    SS_MENU_MUSIC = false
    LLS.roll = 0
    LLS.keyDanceRoll = 0
    if viewScreenshot == 0 then return end
    viewScreenshot = 0
    if noWarp then
        ssWaitForWarp = 0
        return
    end

    local data = prevLocData
    if not (warp_to_level(data.level, data.area, data.act) or warp_to_warpnode(data.level, data.area, data.act, 0)) then
        warp_to_warpnode(data.level, data.area, data.act, 0xf0)
    end
    ssWaitForWarp = 30
end

function screenshot_hud()
    if not (confirmShot or ssHud) then return end
    djui_hud_set_resolution(RESOLUTION_DJUI)
    djui_hud_set_font(FONT_MENU)
    djui_hud_set_color(255, 255, 255, 255)

    local screenWidth = djui_hud_get_screen_width()
    local screenHeight = djui_hud_get_screen_height()

    local scale = 1.5
    local text = "Screenshot Mode"
    local width = djui_hud_measure_text(text) * scale
    local x = (screenWidth - width) * 0.5
    local y = 20

    if confirmShot then
        scale = 1
        text = "A - Confirm     B - Cancel"
        width = djui_hud_measure_text(text) * scale
        x = (screenWidth - width) * 0.5
        y = screenHeight - 60 * scale
        djui_hud_print_text(text, x, y, scale)
    else
        djui_hud_print_text(text, x, y, scale)

        local textLines = { "Control Stick - Move", "C Buttons/Right Stick: Rotate",
            "D-Pad: Tilt Left/Right (Up to reset)",
            "R - Zoom In", "L - Zoom Out", "A - Up", "Z - Down", "Hold B - Slow", "X or L+R - Take screenshot",
            "Y - Toggle hud",
            "Start - Cancel" }
        scale = 0.5
        y = (screenHeight - #textLines * 60 * scale) * 0.5
        for i, line in ipairs(textLines) do
            x = 10
            djui_hud_print_text(line, x, y, scale)
            y = y + 60 * scale
        end
    end
end

function enter_screenshot_mode()
    ssHud = true
    confirmShot = false
    screenshotMode = true
    vec3f_copy(ssCamera.pos, LLS.pos)
    local dist, pitch, yaw = vec3f_get_dist_and_angle_lua(LLS.pos, LLS.focus)
    ssCamera.yaw = limit_angle(yaw + 0x8000)
    ssCamera.pitch = pitch
    ssCamera.roll = LLS.roll
end

function take_screenshot(defaultAspect)
    djui_hud_set_resolution(RESOLUTION_DJUI)
    local screenWidth = djui_hud_get_screen_width()
    local screenHeight = djui_hud_get_screen_height()
    if defaultAspect then -- default is 16x9
        screenWidth = 16
        screenHeight = 9
    end

    play_sound(SOUND_MENU_REVERSE_PAUSE + 61569, gMarioStates[0].marioObj.header.gfx.cameraToObject)
    local m = gMarioStates[0]
    local data = {
        id = PACKET_SEND_SS,
        x = ssCamera.pos.x,
        y = ssCamera.pos.y,
        z = ssCamera.pos.z,
        mx = m.pos.x,
        my = m.pos.y,
        mz = m.pos.z,
        pitch = ssCamera.pitch,
        yaw = ssCamera.yaw,
        roll = ssCamera.roll,
        level = gNetworkPlayers[0].currLevelNum,
        area = gNetworkPlayers[0].currAreaIndex,
        act = gNetworkPlayers[0].currActNum,
        screenWidth = screenWidth,
        screenHeight = screenHeight,
        notify = true,
    }
    network_send(true, data)
    djui_chat_message_create("Screenshot sent!")
    table.insert(screenshots, data)
    autoSSTimer = gGlobalSyncTable.laterSSTime * 30
end

function add_photo_points()
    local points = 0
    for i = MAX_PLAYERS - 1, 0, -1 do
        local m = gMarioStates[i]
        if m.playerIndex == 0 or is_player_active(m) ~= 0 then
            djui_hud_set_resolution(RESOLUTION_N64)
            local screenPos = { x = 0, y = 0, z = 0 }
            local mPos = { x = m.pos.x, y = m.pos.y + 80, z = m.pos.z }
            djui_hud_world_pos_to_screen_pos(mPos, screenPos)
            local dist = -screenPos.z
            local screenWidth = djui_hud_get_screen_width()
            local screenHeight = djui_hud_get_screen_height()

            if dist > 80 and dist < 10000 and screenPos.x > 0 and screenPos.y > 0 and screenPos.x < screenWidth and screenPos.y < screenHeight then
                local intersect = collision_find_surface_on_ray(ssCamera.pos.x, ssCamera.pos.y, ssCamera.pos.z,
                    mPos.x - ssCamera.pos.x, mPos.y - ssCamera.pos.y, mPos.z - ssCamera.pos.z)

                if (not intersect.surface) or (intersect.surface.flags & SURFACE_FLAG_NO_CAM_COLLISION ~= 0 and intersect.surface.flags & SURFACE_FLAG_DYNAMIC == 0) then
                    local diff = abs_angle_diff(m.faceAngle.y, ssCamera.yaw)
                    if m.playerIndex ~= 0 then
                        local distFromCenter = math.sqrt((screenWidth * 0.5 - screenPos.x) ^ 2 +
                            (screenHeight * 0.5 - screenPos.y) ^ 2)

                        local add = 100 - dist // 60
                        add = add + 100 * (1 - distFromCenter / screenWidth)

                        if add > 1 then
                            local np = gNetworkPlayers[i]
                            local playerColor = network_get_player_text_color_string(i)
                            local name = playerColor .. np.name

                            if diff < 0x3000 then
                                local mult = 2 - (diff / 0x3000)
                                mult = math.floor(mult * 100) // 100
                                add = add * mult
                            end
                            if m.action & ACT_FLAG_STATIONARY ~= 0 then
                                add = add // 2
                            end

                            add = math.floor(add)
                            djui_chat_message_create(name .. ": \\#ffff50\\" .. add .. " point(s)")
                            points = points + add
                        end
                    elseif diff < 0x3000 then
                        djui_chat_message_create("Selfie Multiplier: \\#ffff50\\x2")
                        points = points * 2
                    end
                end
            end
        end
    end
    djui_chat_message_create("\\#ffff50\\Total: " .. points .. " point(s)")
    gPlayerSyncTable[0].points = gPlayerSyncTable[0].points + points
end

function take_auto_screenshot()
    local m = gMarioStates[0]
    ssCamera.pos.x = m.pos.x
    ssCamera.pos.y = m.pos.y + 300
    ssCamera.pos.z = m.pos.z
    ssCamera.yaw = limit_angle(m.faceAngle.y + 0x8000)
    ssCamera.roll = 0
    ssCamera.pitch = math.min(0, #screenshots - 4) * 0x1000
    if #screenshots ~= 0 then
        local zoomOut = 32 * 5 * #screenshots
        ssCamera.pos.x = ssCamera.pos.x + math.floor(coss(ssCamera.pitch) * sins(ssCamera.yaw) * zoomOut)
        ssCamera.pos.y = ssCamera.pos.y - math.floor(sins(ssCamera.pitch) * zoomOut)
        ssCamera.pos.z = ssCamera.pos.z + math.floor(coss(ssCamera.pitch) * coss(ssCamera.yaw) * zoomOut)
    end
    take_screenshot(true)
    ssCooldown = 90
    screenshotMode = false
    LLS.roll = 0
    LLS.keyDanceRoll = 0
end

function view_command(msg)
    local m = gMarioStates[0]
    local hideIndex = get_hide_index(true)
    if #screenshots == 0 then
        djui_chat_message_create("No pics? :(")
        return true
    elseif hideIndex == 0 then
        djui_chat_message_create("No need to view your own screenshots!")
        return true
    end

    if viewScreenshot ~= 0 then return true end
    if is_transition_playing() or m.action == ACT_PULLING_DOOR or m.action == ACT_PUSHING_DOOR then return true end

    local num = tonumber(msg)
    if num == nil then
        num = 0
    elseif num > #screenshots - 1 then
        num = #screenshots - 1
    end
    viewScreenshot = #screenshots - num
    prevView = false
    ssWaitForWarp = 0
    return true
end

hook_chat_command("view", "[NUM] - Seeker only; view past screenshots sent by the hider", view_command)


local function is_screenshot()
    return viewScreenshot ~= 0
end

_G.geoguessr = {
    is_screenshot = is_screenshot
}