-- name: GeoGuessr / Scav. Hunt v1.1
-- description: GeoGuessr in Super Mario 64!\n\nMod originally made for BizzareScape by EmilyEmmi.
-- incompatible: gamemode
-- deluxe: true

gGlobalSyncTable.hider = -1 -- global index
gGlobalSyncTable.hideTimer = 0
gGlobalSyncTable.seekTimer = 0
gGlobalSyncTable.maxHideTime = 2 * 60 -- 2 minutes
gGlobalSyncTable.maxSeekTime = 5 * 60 -- 5 minutes
gGlobalSyncTable.selectionType = 0
gGlobalSyncTable.autoTimer = 0
gGlobalSyncTable.nextHider = 0
gGlobalSyncTable.glitch = false
gGlobalSyncTable.sound = true
gGlobalSyncTable.hiding = false
gGlobalSyncTable.gameEnd = true
gGlobalSyncTable.foundPercent = 80
gGlobalSyncTable.seekerSpeak = true
gGlobalSyncTable.seekerSee = true
gGlobalSyncTable.firstSSTime = 30
gGlobalSyncTable.laterSSTime = 90
game_blacklist = { id = PACKET_SEND_BLACKLIST } -- this also acts as the packet data

hackName = "64"
local didFirstJoinStuff = false
local prevFound = false
local prevTimerGoing = false
local prevHideGoing = false
local informedOfNotSeeing = false
local hidePos = { x = 0, y = 0, z = 0 }
local hideValid = false
local hideLedge = false
local hideLedgeAngle = 0
local stuckOnWarpTimer = 180
local bug_warp = false
local afkTimer = 0
local prevSoundOn = true
autoSSTimer = 0
prevChatMessages = {}
pastHints = {}
gServerSettings.enablePlayerList = 1
gServerSettings.playerInteractions = PLAYER_INTERACTIONS_SOLID
gServerSettings.playerKnockbackStrength = 0
gServerSettings.bubbleDeath = 0
gServerSettings.stayInLevelAfterStar = 2
gServerSettings.skipIntro = 1
gLevelValues.hudRedCoinsRadar = 0
gLevelValues.hudSecretsRadar = 0
cheatTimer = 0
djui_set_popup_disabled_override(true)

function update()
    if prevSoundOn ~= gGlobalSyncTable.sound then
        prevSoundOn = gGlobalSyncTable.sound
        if prevSoundOn then
            sound_banks_enable(SEQ_PLAYER_ENV, SOUND_BANKS_ALL & ~SOUND_BANKS_FOREGROUND)
            sound_banks_enable(SEQ_PLAYER_SFX, SOUND_BANKS_ALL & ~SOUND_BANKS_FOREGROUND)
            sound_banks_enable(SEQ_PLAYER_LEVEL, SOUND_BANKS_ALL & ~SOUND_BANKS_FOREGROUND)
        else
            sound_banks_disable(SEQ_PLAYER_ENV, SOUND_BANKS_ALL & ~SOUND_BANKS_FOREGROUND)
            sound_banks_disable(SEQ_PLAYER_SFX, SOUND_BANKS_ALL & ~SOUND_BANKS_FOREGROUND)
            sound_banks_disable(SEQ_PLAYER_LEVEL, SOUND_BANKS_ALL & ~SOUND_BANKS_FOREGROUND)
        end
    end

    if gServerSettings.enablePlayerList == 0 and djui_is_playerlist_open() and not gPlayerSyncTable[0].roundExempt then
        cheatTimer = cheatTimer + 1
        if cheatTimer >= 150 then
            gPlayerSyncTable[0].roundExempt = true
            cheatTimer = 0
            djui_chat_message_create("\\#ff5050\\You can no longer play in this round.")
        end
    else
        cheatTimer = 0
    end

    djui_set_popup_disabled_override(true)
    local hideIndex = get_hide_index()
    if not didFirstJoinStuff then
        gPlayerSyncTable[0].roundExempt = false
        gPlayerSyncTable[0].found = 0
        gPlayerSyncTable[0].points = 0
        gPlayerSyncTable[0].viewing = false
        gPlayerSyncTable[0].afk = false
        gLevelValues.hudRedCoinsRadar = 0
        gLevelValues.hudSecretsRadar = 0
        if not gNetworkPlayers[0].currAreaSyncValid then return end
        log_to_console("\n\n\n\n\n\n\n\n")
        --djui_chat_message_create("Welcome!\nBe sure you have disabled music and popups!")
        if _G.OmmEnabled then
            _G.OmmApi.omm_force_setting("player", PLAYER_INTERACTIONS_SOLID)
            _G.OmmApi.omm_force_setting("damage", 0)
            _G.OmmApi.omm_force_setting("bubble", 0)
            _G.OmmApi.omm_force_setting("stars", 2)
            _G.OmmApi.omm_disable_feature("trueNonStop", true)
            _G.OmmApi.omm_disable_feature("starsDisplay", true)
            if _G.OmmApi.omm_get_forced_setting("cappy") ~= 0 then
                _G.OmmApi.omm_force_setting("cappy", 1)
            end
        end

        djui_chat_message_create("You can open the menu with /geo or L + Start.")

        -- mod detection
        for i, mod in pairs(gActiveMods) do
            if mod.enabled then
                local name = mod.name:lower()
                if (name:find("mute") or name:find("swear filter")) then
                    djui_chat_message_create("WARNING! Chat will break with this mod:")
                    djui_chat_message_create(mod.name)
                elseif mod.incompatible and mod.incompatible:find("romhack") then
                    hackName = mod.basePath
                end
            end
        end

        -- blacklist
        if network_is_server() then
            local value = mod_storage_load("x_" .. hackName)
            if value and value ~= "none" then
                local blacklisted = split(value, ".")
                for i = 1, #blacklisted do
                    game_blacklist[tonumber("0x" .. blacklisted[i])] = 1
                end
            end
        end

        -- request past hints and ss from host
        if not network_is_server() then
            network_send_to(1, true, {
                id = PACKET_REQUEST_GAME_INFO,
                index = network_global_index_from_local(0),
            })
        end
        prevFound = true
        hook_event(HOOK_ON_LEVEL_INIT, course_init)
        didFirstJoinStuff = true
    elseif gGlobalSyncTable.hiding then
        prevFound = false
        if hideIndex ~= 0 then
            if gMarioStates[0].health > 0xFF then
                gMarioStates[0].health = 0x880
            end

            if not prevTimerGoing then
                gPlayerSyncTable[0].points = 0
                gPlayerSyncTable[0].roundExempt = false
                djui_chat_message_create("Setting up location...")
                warp_to_lobby()
                informedOfNotSeeing = false
                prevTimerGoing = true

                screenshots = {}
                pastHints = {}
                inMenu = false
                screenshotMode = false
                close_screenshot(true)
            end
        elseif not prevHideGoing then
            gMarioStates[0].health = 0x880
            djui_chat_message_create("Get hiding! Press L + R or type /hide to pick your spot.")
            gPlayerSyncTable[0].afk = false
            afkTimer = 0
            gGlobalSyncTable.hideTimer = gGlobalSyncTable.maxHideTime * 30
            gGlobalSyncTable.seekTimer = gGlobalSyncTable.maxSeekTime * 30
            warp_to_start_level()
            prevHideGoing = true

            screenshots = {}
            pastHints = {}
            inMenu = false
            screenshotMode = false
            hideValid = false
            close_screenshot(true)
        end
    elseif prevTimerGoing or prevHideGoing then
        prevTimerGoing = false
        prevHideGoing = false
        if hideIndex ~= 0 and hideIndex ~= 255 then
            screenshotMode = false
            close_screenshot(true)
            djui_chat_message_create("Get searching!")
            if gGlobalSyncTable.selectionType == 1 then
                djui_chat_message_create("\\#ffff50\\A random player will be hider next round!")
            elseif gGlobalSyncTable.selectionType == 2 then
                local nextHide = get_next_hider(gGlobalSyncTable.hider)
                local np = network_player_from_global_index(nextHide)
                local playerColor = network_get_player_text_color_string(np.localIndex)
                djui_chat_message_create(playerColor .. np.name .. "\\#ffff50\\ will be hider next round!")
            elseif gGlobalSyncTable.selectionType == 3 then
                djui_chat_message_create("\\#ffff50\\The winner will be hider next round!")
            end
            warp_to_start_level()
        end
    elseif (gPlayerSyncTable[0].found and gPlayerSyncTable[0].found ~= 0) and not prevFound then
        prevFound = true
        if not gPlayerSyncTable[0].roundExempt then
            play_star_fanfare()
            djui_chat_message_create("CONGRATS! You are now invisible to other players.\nPlease keep this location hidden!")
        end
    end

    -- failsafe for warp bug
    if gMarioStates[0].action == ACT_DISAPPEARED then
        stuckOnWarpTimer = stuckOnWarpTimer - 1
        if stuckOnWarpTimer <= 0 then
            djui_chat_message_create("\\#ff5050\\Warp took too long! Leaving level...")
            if gNetworkPlayers[0].currCourseNum ~= 0 then
                warp_to_castle(gNetworkPlayers[0].currLevelNum)
            else
                warp_to_start_level()
            end
        end
    else
        stuckOnWarpTimer = 180
    end

    -- hide all players except the hider in ss, make the hider use default pose
    if viewScreenshot ~= 0 then
        sound_banks_disable(0, SOUND_BANKS_ALL_BITS)
        for i = 0, MAX_PLAYERS - 1 do
            local m = gMarioStates[i]
            if hideIndex == i then
                if m.action == ACT_LEDGE_GRAB then
                    set_character_animation(m, CHAR_ANIM_IDLE_ON_LEDGE)
                elseif m.action & ACT_FLAG_SWIMMING ~= 0 then
                    set_character_animation(m, CHAR_ANIM_WATER_IDLE)
                else
                    set_character_animation(m, CHAR_ANIM_FIRST_PERSON)
                end
                m.fadeWarpOpacity = 255
                m.marioBodyState.modelState = 0
            else
                m.marioObj.header.gfx.pos.y = 10000
                m.marioObj.header.gfx.node.flags = m.marioObj.header.gfx.node.flags | GRAPH_RENDER_INVISIBLE
                m.fadeWarpOpacity = 0
                obj_set_model_extended(m.marioObj, E_MODEL_NONE)
            end
        end
    end

    if hideIndex == 255 or hideIndex == 0 or (gPlayerSyncTable[0].found and gPlayerSyncTable[0].found ~= 0) then
        censor_levels_and_list(false)
    else
        censor_levels_and_list(true)
    end

    if network_is_server() then
        if hideIndex ~= 255 then
            if not gGlobalSyncTable.hiding then
                local foundCount = 0
                local seekerTotal = 0
                for i = 0, MAX_PLAYERS - 1 do
                    if hideIndex ~= i and gNetworkPlayers[i].connected and (not gPlayerSyncTable[i].afk) then
                        seekerTotal = seekerTotal + 1
                        if (gPlayerSyncTable[i].found and gPlayerSyncTable[i].found ~= 0) then
                            foundCount = foundCount + 1
                        end
                    end
                end
                local foundPercent = 0
                if seekerTotal ~= 0 then
                    foundPercent = (foundCount / seekerTotal) * 100
                end

                if foundPercent >= gGlobalSyncTable.foundPercent then
                    network_send_include_self(true, {
                        id = PACKET_GAME_END,
                    })
                elseif gGlobalSyncTable.seekTimer ~= 0 then
                    gGlobalSyncTable.seekTimer = gGlobalSyncTable.seekTimer - 1
                    if gGlobalSyncTable.seekTimer == 0 then
                        network_send_include_self(true, {
                            id = PACKET_GAME_END,
                        })
                    end
                end
            end
        elseif gGlobalSyncTable.selectionType ~= 0 then
            if gGlobalSyncTable.autoTimer == 0 then
                gGlobalSyncTable.lobbyLevel = math.random(1, #lobby_list)
                gGlobalSyncTable.autoTimer = 20 * 30
                gGlobalSyncTable.nextHider = get_next_hider(gGlobalSyncTable.hider)
            else
                gGlobalSyncTable.autoTimer = gGlobalSyncTable.autoTimer - 1
                if gGlobalSyncTable.autoTimer == 0 then
                    start_game_command(gGlobalSyncTable.nextHider)
                end
            end
        end
    end

    log_to_console("\n\n\n\nConsole is disabled to prevent cheating.\nSorry!\n\n\n\n")
end

hook_event(HOOK_UPDATE, update)

-- do interaction check here to avoid action being set
function allow_pvp_attack(attacker, victim)
    local hideIndex = get_hide_index()
    local sAttacker = gPlayerSyncTable[attacker.playerIndex]
    if victim.playerIndex ~= hideIndex then
        return false
    elseif (sAttacker.found and sAttacker.found ~= 0) then
        return false
    end

    if victim.playerIndex ~= 0 then return false end
    if hideIndex == 0 and attacker.action ~= ACT_UNINITIALIZED and attacker.action ~= ACT_SPAWN_NO_SPIN_AIRBORNE and attacker.action ~= ACT_SPAWN_SPIN_AIRBORNE and (not sAttacker.viewing) then
        local maxFound = 0
        for i = 1, MAX_PLAYERS - 1 do
            if gNetworkPlayers[i].connected and gPlayerSyncTable[i].found and maxFound < gPlayerSyncTable[i].found then
                maxFound = gPlayerSyncTable[i].found
            end
        end
        sAttacker.found = maxFound + 1
        local np = gNetworkPlayers[attacker.playerIndex]
        local playerColor = network_get_player_text_color_string(attacker.playerIndex)
        local name = playerColor .. np.name
        djui_chat_message_create(name .. "\\#dcdcdc\\ found you!")
        play_sound(SOUND_GENERAL2_RIGHT_ANSWER, victim.marioObj.header.gfx.cameraToObject)
        --set_mario_action(victim, victim.prevAction, 0)
        --force_idle_state(victim)
    end
    return false -- always false to prevent attack from happening
end

hook_event(HOOK_ALLOW_PVP_ATTACK, allow_pvp_attack)

function disable_sound(m, sound)
    if m.playerIndex ~= 0 then
        return 0
    end
end

hook_event(HOOK_CHARACTER_SOUND, disable_sound)

function chat_message(m, msg)
    local hideIndex = get_hide_index(true)
    local valid = false
    local validForAll = false
    if gGlobalSyncTable.gameEnd or hideIndex == 255 then
        valid = true
        validForAll = true
    elseif hideIndex == 0 then
        valid = true
    elseif (gPlayerSyncTable[0].found and gPlayerSyncTable[0].found ~= 0) then
        valid = true
    elseif (gGlobalSyncTable.seekerSpeak or gGlobalSyncTable.hiding) and hideIndex ~= m.playerIndex and (not gPlayerSyncTable[0].roundExempt) and (gPlayerSyncTable[m.playerIndex].found == nil or (gPlayerSyncTable[m.playerIndex].found == 0)) then
        valid = true
    end

    if not valid then
        if m.playerIndex == 0 then
            if not informedOfNotSeeing then
                djui_chat_message_create("\\#ff5050\\Other seekers cannot see your messages.")
                informedOfNotSeeing = true
            end
            valid = true
        else
            log_to_console("\n\n\n\n\n\n\n\n")
        end
    end

    -- if the player asks "can I be hider", "make me hider," etc., display queue
    if m.playerIndex == 0 and hideIndex ~= 0 and gGlobalSyncTable.selectionType ~= 0 then
        local lowerMsg = msg:lower()
        if lowerMsg:find(" hider") and (lowerMsg:find(" me ") or lowerMsg:find(" be ")) then
            queue_command()
        end
    end

    local np = gNetworkPlayers[m.playerIndex]
    local playerColor = network_get_player_text_color_string(m.playerIndex)
    local name = playerColor .. np.name

    local tag
    if hideIndex == m.playerIndex then
        tag = "\\#79959c\\[HIDER]"
        if m.playerIndex == 0 and not (validForAll or informedOfNotSeeing) then
            djui_chat_message_create("\\#ffff50\\Use /hint to chat with players that are still searching.")
            informedOfNotSeeing = true
        end
    elseif gPlayerSyncTable[m.playerIndex].roundExempt then
        tag = "\\#ff2020\\[DQ]"
    elseif (gPlayerSyncTable[m.playerIndex].found and gPlayerSyncTable[m.playerIndex].found ~= 0) then
        tag = "\\#60d160\\[FOUND]"
        if hideIndex ~= 255 and m.playerIndex == 0 and not (validForAll or informedOfNotSeeing) then
            djui_chat_message_create("\\#ff5050\\Players that are still searching cannot see your messages.")
            if network_is_server() or network_is_moderator() then
                djui_chat_message_create(
                    "\\#ff5050\\Moderators can use /hint to chat with players that are still searching.")
            end
            informedOfNotSeeing = true
        end
    end

    if tag then
        table.insert(prevChatMessages, (name .. " " .. tag .. "\\#6e6e6e\\: " .. msg))
    else
        table.insert(prevChatMessages, (name .. "\\#6e6e6e\\: " .. msg))
    end
    if #prevChatMessages > 200 then
        table.remove(prevChatMessages, 1)
    end

    if valid and tag then
        djui_chat_message_create(name .. " " .. tag .. "\\#dcdcdc\\: " .. msg)

        if m.playerIndex == 0 then
            play_sound(SOUND_MENU_MESSAGE_DISAPPEAR, m.marioObj.header.gfx.cameraToObject)
        else
            play_sound(SOUND_MENU_MESSAGE_APPEAR, gMarioStates[0].marioObj.header.gfx.cameraToObject)
        end
        return false
    end
    return valid
end

hook_event(HOOK_ON_CHAT_MESSAGE, chat_message)

function allow_interact(m, o, type)
    local hideIndex = get_hide_index()

    if gGlobalSyncTable.gameEnd and gGlobalSyncTable.hiding then
        return (type ~= INTERACT_WARP and type ~= INTERACT_WARP_DOOR and type ~= INTERACT_BBH_ENTRANCE)
    end

    if (gPlayerSyncTable[m.playerIndex].found and gPlayerSyncTable[m.playerIndex].found ~= 0) then
        return (type == INTERACT_POLE or type == INTERACT_WARP or type == INTERACT_WARP_DOOR or type == INTERACT_DOOR or type == INTERACT_BBH_ENTRANCE)
    elseif hideIndex == 0 and (not gGlobalSyncTable.hiding) and (type ~= INTERACT_PLAYER and type ~= INTERACT_POLE and type ~= INTERACT_WARP and type ~= INTERACT_WARP_DOOR and type ~= INTERACT_BBH_ENTRANCE) then
        return false
    end

    if type ~= INTERACT_PLAYER then return end

    -- disables interaction for players, except for the other players *against* the hider (the hider has interaction disabled towards others to prevent being pushed)
    -- PVP checks actually still work even when this returns false
    if hideIndex == 255 or hideIndex == m.playerIndex or gMarioStates[hideIndex].marioObj ~= o then
        local m2
        for i = 1, MAX_PLAYERS - 1 do
            local thisM = gMarioStates[i]
            if thisM.marioObj == o then
                m2 = thisM
                break
            end
        end

        if m2 and gNetworkPlayers[m2.playerIndex].currAreaSyncValid and hideIndex == 0 and m.playerIndex == 0 and m.marioObj ~= o and (m2.flags & MARIO_VANISH_CAP ~= 0 or m2.action & ACT_FLAG_METAL_WATER ~= 0 or m.action & (ACT_FLAG_INTANGIBLE | ACT_FLAG_INVULNERABLE) ~= 0) then
            allow_pvp_attack(m2, m) -- check here, since pvp can't occur
        end
        return false
    end
end

hook_event(HOOK_ALLOW_INTERACT, allow_interact)

function course_init()
    prevSoundOn = nil
    disable_time_stop_including_mario()
    bug_warp = false
    hideValid = false
    ssCooldown = 150
    local np = gNetworkPlayers[0]

    for data, v in pairs(game_blacklist) do
        if type(data) == "number" then
            local level = data // 10
            local area = data % 10
            if np.currActNum ~= 7 and np.currLevelNum == level and (area == 0 or np.currAreaIndex == area) then
                djui_chat_message_create("\\#ff5050\\This area is blacklisted.")
                if gNetworkPlayers[0].currCourseNum ~= 0 then
                    warp_to_castle(level)
                else
                    warp_to_start_level()
                end
                return
            end
        end
    end

    local hideIndex = get_hide_index()
    if np.currCourseNum > 0 and np.currCourseNum < 16 and np.currActNum < 6 then
        if viewScreenshot == 0 and ssWaitForWarp == 0 and gMarioStates[0].action ~= ACT_IDLE then -- fix dynos warp issue / issue with screen shots sometimes
            warp_to_level(np.currLevelNum, np.currAreaIndex, 6)
            return
        end
    elseif hideIndex ~= 0 and hideIndex ~= 255 and gGlobalSyncTable.hiding then
        warp_to_lobby()
        return
    end

    -- for hacks that change level names on the fly (like SM74)
    if gServerSettings.enablePlayerList == 0 and get_level_name(1, 9, 1) ~= "???" then
        gServerSettings.enablePlayerList = 1
        censor_levels_and_list(true)
    end

    -- 100% save
    if not save_file_get_using_backup_slot() then
        save_file_set_using_backup_slot(true)
        local file = get_current_save_file_num() - 1
        for course = 0, COURSE_MAX - 1 do
            save_file_set_star_flags(file, course, 0xFF)
        end
        save_file_set_flags(0xFFFFFFFF)
        gMarioStates[0].numStars = COURSE_MAX * 7 + 7
    end
end

course_init()
--hook_event(HOOK_ON_LEVEL_INIT, course_init) -- hook must be last

-- failsafe for doors disappearing
function on_object_unload(o)
    local np = gNetworkPlayers[0]
    if np.currAreaSyncValid and (not bug_warp) and np.currLevelSyncValid and (o.oInteractType == INTERACT_WARP or o.oInteractType == INTERACT_WARP_DOOR) then
        djui_chat_message_create("\\#ff5050\\Objects not synced properly! Try entering again.")
        bug_warp = true
        if viewScreenshot ~= 0 then
            close_screenshot()
        elseif np.currCourseNum ~= 0 then
            warp_to_castle(np.currLevelNum)
        else
            warp_to_start_level()
        end
    end
end
hook_event(HOOK_ON_OBJECT_UNLOAD, on_object_unload)

function disable_act_select_and_dialog(level)
    return false
end

hook_event(HOOK_USE_ACT_SELECT, disable_act_select_and_dialog)
hook_event(HOOK_ON_DIALOG, disable_act_select_and_dialog)

function on_pause_exit()
    local hideIndex = get_hide_index()
    if gGlobalSyncTable.hiding == (hideIndex ~= 0) then
        return false
    end
end

hook_event(HOOK_ON_PAUSE_EXIT, on_pause_exit)

function cancel_transition_if_ss()
    if viewScreenshot ~= 0 or ssWaitForWarp ~= 0 then
        return false
    end
end

hook_event(HOOK_ON_SCREEN_TRANSITION, cancel_transition_if_ss)

function on_player_connected(m)
    if m.playerIndex == 0 or (not didFirstJoinStuff) then return end
    local np = gNetworkPlayers[m.playerIndex]
    local playerColor = network_get_player_text_color_string(np.localIndex)
    djui_chat_message_create(playerColor .. np.name .. "\\#ffff50\\ connected!")
    play_sound(SOUND_GENERAL_COIN, gMarioStates[0].marioObj.header.gfx.cameraToObject)
end

hook_event(HOOK_ON_PLAYER_CONNECTED, on_player_connected)

function on_player_disconnected(m)
    if m.playerIndex == 0 then
        gServerSettings.enablePlayerList = 1 -- prevent carrying over across servers
        return
    end

    if network_is_server() then
        local hideIndex = get_hide_index()
        local nextIndex = network_local_index_from_global(gGlobalSyncTable.nextHider)
        if hideIndex == m.playerIndex then
            network_send_include_self(true, {
                id = PACKET_GAME_END,
                dc = true,
            })
        elseif nextIndex == m.playerIndex then
            gGlobalSyncTable.autoTimer = 0
        end
    end

    local np = gNetworkPlayers[m.playerIndex]
    local playerColor = network_get_player_text_color_string(np.localIndex)
    djui_chat_message_create(playerColor .. np.name .. "\\#ffff50\\ disconnected.")
    play_sound(SOUND_MENU_CHANGE_SELECT, gMarioStates[0].marioObj.header.gfx.cameraToObject)
end

hook_event(HOOK_ON_PLAYER_DISCONNECTED, on_player_disconnected)

---@param m MarioState
function mario_loop(m, beforeUpdate)
    m.numLives = 99
    m.cap = 0
    m.specialTripleJump = 0
    m.numCoins = 0
    local hideIndex = get_hide_index()

    if m.playerIndex == 0 and m.freeze == 0 and beforeUpdate then
        if gPlayerSyncTable[0].afk then
            if m.controller.buttonPressed ~= 0 or m.controller.stickMag ~= 0 then
                gPlayerSyncTable[0].afk = false
                afkTimer = 0
            end
        elseif m.controller.buttonPressed == 0 and m.controller.stickMag == 0 then
            afkTimer = afkTimer + 1
            if afkTimer > 900 then -- 30 seconds
                gPlayerSyncTable[0].afk = true
            end
        else
            afkTimer = 0
        end
    end

    if m.playerIndex == 0 and beforeUpdate and not is_game_paused() then
        if ssCooldown ~= 0 then
            ssCooldown = ssCooldown - 1
        end
        gPlayerSyncTable[0].viewing = (viewScreenshot ~= 0)

        if ssWaitForWarp ~= 0 or viewScreenshot ~= 0 then
            view_screenshot(m, viewScreenshot)
        elseif screenshotMode then
            ss_controls(m)
        elseif inMenu then
            menu_controls(m)
        elseif m.controller.buttonDown & L_TRIG ~= 0 then
            if m.controller.buttonPressed & START_BUTTON ~= 0 then
                open_menu()
                sMenuInputsPressed = 0
                sMenuInputsDown = m.controller.buttonDown
                m.controller.buttonPressed = m.controller.buttonPressed & ~START_BUTTON
            elseif m.controller.buttonPressed & R_TRIG ~= 0 then
                if hideIndex ~= 0 then
                    if gGlobalSyncTable.hiding then
                        enter_screenshot_mode()
                        sMenuInputsPressed = 0
                        sMenuInputsDown = m.controller.buttonDown
                        m.controller.buttonPressed = m.controller.buttonPressed & ~R_TRIG
                    else
                        view_command()
                        sMenuInputsPressed = 0
                        sMenuInputsDown = m.controller.buttonDown
                        m.controller.buttonPressed = m.controller.buttonPressed & ~R_TRIG
                    end
                elseif gGlobalSyncTable.hiding then
                    if m.area.localAreaTimer > 30 then
                        hide_command()
                    end
                else
                    enter_screenshot_mode()
                    sMenuInputsPressed = 0
                    sMenuInputsDown = m.controller.buttonDown
                    m.controller.buttonPressed = m.controller.buttonPressed & ~R_TRIG
                end
            end
        end
        if (hideIndex == 0 and (not gGlobalSyncTable.hiding)) and m.controller.buttonPressed & X_BUTTON ~= 0 then
            enter_screenshot_mode()
            sMenuInputsPressed = 0
            sMenuInputsDown = m.controller.buttonDown
            m.controller.buttonPressed = m.controller.buttonPressed & ~X_BUTTON
        end
    end

    if not (beforeUpdate or gGlobalSyncTable.glitch) then
        if m.action == ACT_LONG_JUMP and m.forwardVel < -60 then
            m.forwardVel = -60
        end

        if m.playerIndex == 0 and m.pos.x > 57344 or m.pos.z > 57344 or m.pos.x < -57344 or m.pos.z < -57344 then
            djui_chat_message_create("No going to PUs!")
            warp_restart_level()
        end

        if m.playerIndex == 0 and m.health ~= 0xFF and m.action & ACT_FLAG_SWIMMING ~= 0 and m.floor and (m.floor.type == SURFACE_DEATH_PLANE or m.floor.type == SURFACE_VERTICAL_WIND) then
            djui_chat_message_create("No going OOB!")
            m.health = 0xFF
        end
    end

    if m.action == ACT_UNINITIALIZED then
        m.marioObj.header.gfx.node.flags = m.marioObj.header.gfx.node.flags | GRAPH_RENDER_INVISIBLE
    end

    if hideIndex ~= 255 then
        if m.playerIndex ~= 0 and hideIndex == 0 and gPlayerSyncTable[m.playerIndex].viewing then -- fixes interaction when exiting screenshot with vanish cap
            m.pos.x, m.pos.y, m.pos.z = 0, 10000, 0
            m.forwardVel, m.vel.x, m.vel.y, m.vel.z = 0, 0, 0, 0
            m.marioObj.header.gfx.node.flags = m.marioObj.header.gfx.node.flags | GRAPH_RENDER_INVISIBLE
            m.particleFlags = 0
        elseif m.playerIndex ~= 0 and ((not (gGlobalSyncTable.seekerSee or gGlobalSyncTable.hiding)) or (gPlayerSyncTable[m.playerIndex].found and gPlayerSyncTable[m.playerIndex].found ~= 0)) and not (hideIndex == 0 or hideIndex == m.playerIndex or (gPlayerSyncTable[0].found and gPlayerSyncTable[0].found ~= 0)) then
            set_mario_action(m, ACT_UNINITIALIZED, 0)
            m.pos.x, m.pos.y, m.pos.z = 0, 10000, 0
            m.forwardVel, m.vel.x, m.vel.y, m.vel.z = 0, 0, 0, 0
            m.marioObj.header.gfx.node.flags = m.marioObj.header.gfx.node.flags | GRAPH_RENDER_INVISIBLE
            m.wasNetworkVisible = 0
            m.particleFlags = 0
            m.flags = m.flags | MARIO_VANISH_CAP
        elseif hideIndex ~= m.playerIndex and (gPlayerSyncTable[m.playerIndex].found and gPlayerSyncTable[m.playerIndex].found ~= 0) then
            m.flags = m.flags | MARIO_VANISH_CAP
            m.health = 0x880
        elseif m.playerIndex == 0 and hideIndex == 0 and beforeUpdate then
            if m.action == ACT_IDLE and m.actionState == 3 then -- disable sleeping and shivering
                m.actionState = 0
            end

            if gGlobalSyncTable.hiding then
                if gPlayerSyncTable[0].afk then
                    gPlayerSyncTable[0].afk = false
                    afkTimer = 0
                    hide_command()
                end

                if gGlobalSyncTable.hideTimer ~= 0 then
                    gGlobalSyncTable.hideTimer = gGlobalSyncTable.hideTimer - 1
                    if gGlobalSyncTable.hideTimer == 0 then
                        hide_command()
                    end
                end
            else
                if autoSSTimer ~= 0 then
                    autoSSTimer = autoSSTimer - 1
                    if autoSSTimer == 0 then
                        take_auto_screenshot()
                    end
                end

                m.freeze = math.max(m.freeze, 3)
                m.controller.buttonPressed = m.controller.buttonPressed &
                    ~(A_BUTTON | B_BUTTON | Z_TRIG | Y_BUTTON | X_BUTTON)
                m.controller.buttonDown = m.controller.buttonDown & ~(A_BUTTON | B_BUTTON | Z_TRIG | Y_BUTTON)
                m.controller.stickX = 0
                m.controller.stickY = 0
                m.flags = m.flags & ~(MARIO_SPECIAL_CAPS)
                if m.action == ACT_IN_CANNON and m.actionState == 2 then
                    warp_restart_level()
                end
                m.health = 0x880

                -- prevent falling off of ledges or being pushed by enemies or water currents
                if hideValid then
                    if hideLedge and m.action ~= ACT_LEDGE_GRAB and m.action & ACT_FLAG_SWIMMING_OR_FLYING == 0 then
                        set_mario_action(m, ACT_LEDGE_GRAB, 0)
                        m.faceAngle.y = hideLedgeAngle
                    end
                    vec3f_copy(m.pos, hidePos)
                elseif m.action & ACT_FLAG_STATIONARY ~= 0 and m.floor and m.floor.object == nil then
                    vec3f_copy(hidePos, m.pos)
                    hideValid = true
                    hideLedge = (m.action == ACT_LEDGE_GRAB)
                    hideLedgeAngle = m.faceAngle.y
                end
            end
        end
    end

    if gGlobalSyncTable.hiding and (not beforeUpdate) then
        gPlayerSyncTable[m.playerIndex].found = 0
    elseif m.playerIndex == 0 and gPlayerSyncTable[0].roundExempt then
        gPlayerSyncTable[m.playerIndex].found = 99
    end

    if (not beforeUpdate) and gServerSettings.enablePlayerList ~= 0 then
        if get_hide_index(true) == m.playerIndex then
            network_player_set_description(gNetworkPlayers[m.playerIndex], "Hider", 0x79, 0x95, 0x9c, 0xFF)
        elseif gPlayerSyncTable[m.playerIndex].roundExempt then
            network_player_set_description(gNetworkPlayers[m.playerIndex], "DQ", 0xff, 0x20, 0x20, 0xFF)
        elseif gPlayerSyncTable[m.playerIndex].found and gPlayerSyncTable[m.playerIndex].found ~= 0 then
            network_player_set_description(gNetworkPlayers[m.playerIndex],
                placeString(gPlayerSyncTable[m.playerIndex].found), 0x60, 0xd1, 0x60, 0xFF)
        elseif gPlayerSyncTable[m.playerIndex].viewing then
            network_player_set_description(gNetworkPlayers[m.playerIndex], "Viewing", 0x50, 0x50, 0xff, 0xFF)
        elseif gPlayerSyncTable[m.playerIndex].afk then
            network_player_set_description(gNetworkPlayers[m.playerIndex], "AFK", 0x79, 0x79, 0x79, 0xFF)
        else
            network_player_set_description(gNetworkPlayers[m.playerIndex], "Seeker", 0xff, 0x50, 0x50, 0xFF)
        end
    end
end

function mario_update(m)
    mario_loop(m)
end

function before_mario_update(m)
    mario_loop(m, true)
end

hook_event(HOOK_MARIO_UPDATE, mario_update)
hook_event(HOOK_BEFORE_MARIO_UPDATE, before_mario_update)

-- don't render mirror mario, since this also renders invisible players
function on_mirror_mario_render(mGFX)
    mGFX.node.flags = mGFX.node.flags | GRAPH_RENDER_INVISIBLE
end
hook_event(HOOK_MIRROR_MARIO_RENDER, on_mirror_mario_render)