-- Head render function. You can place this in your mods (please give credit!)

local HEAD_HUD = get_texture_info("hud_head_recolor")
local WING_HUD = get_texture_info("hud_wing")

local defaultIcons = {
    [gTextures.mario_head] = true,
    [gTextures.luigi_head] = true,
    [gTextures.toad_head] = true,
    [gTextures.waluigi_head] = true,
    [gTextures.wario_head] = true,
}

local PART_ORDER = {
    SKIN,
    HAIR,
    CAP,
}

-- the actual head render function.
--- @param index integer
--- @param x integer
--- @param y integer
--- @param scaleX number
--- @param scaleY number
function render_player_head(index, x, y, scaleX, scaleY, noSpecial, alwaysCap, alpha_)
    local m = gMarioStates[index]
    local np = gNetworkPlayers[index]
  
    local alpha = alpha_ or 255
    if (not noSpecial) and (m.marioBodyState.modelState & MODEL_STATE_NOISE_ALPHA) ~= 0 then
        alpha = math.max(alpha - 155, 0) -- vanish effect
    end
  
    if charSelectExists then
        djui_hud_set_color(255, 255, 255, alpha)
        local TEX_CS_ICON = charSelect.character_get_life_icon(index)
        if TEX_CS_ICON and not defaultIcons[TEX_CS_ICON] then
            djui_hud_render_texture(TEX_CS_ICON, x, y, scaleX / (TEX_CS_ICON.width * 0.0625),
                scaleY / (TEX_CS_ICON.width * 0.0625))
            if (not noSpecial) and m.marioBodyState.capState == MARIO_HAS_WING_CAP_ON then
                djui_hud_render_texture(WING_HUD, x, y, scaleX, scaleY) -- wing
            end
            return
        elseif TEX_CS_ICON == nil then
            djui_hud_set_font(FONT_HUD)
            djui_hud_print_text("?", x, y, scaleX)
            if (not noSpecial) and m.marioBodyState.capState == MARIO_HAS_WING_CAP_ON then
                djui_hud_render_texture(WING_HUD, x, y, scaleX, scaleY) -- wing
            end
            return
        end
    end
    local isMetal = false
    local capless = false
  
    local tileY = m.character.type
    for i = 1, #PART_ORDER do
        local color = { r = 255, g = 255, b = 255 }
        if (not noSpecial) and (m.marioBodyState.modelState & MODEL_STATE_METAL) ~= 0 then -- metal
            color = network_player_get_override_palette_color(np, METAL)
            djui_hud_set_color(color.r, color.g, color.b, alpha)
            isMetal = true
  
            if (not (noSpecial or alwaysCap)) and m.marioBodyState.capState == MARIO_HAS_DEFAULT_CAP_OFF then
                capless = true
                djui_hud_render_texture_tile(HEAD_HUD, x, y, scaleX, scaleY, 7 * 16, tileY * 16, 16, 16) -- capless metal
            else
                djui_hud_render_texture_tile(HEAD_HUD, x, y, scaleX, scaleY, 5 * 16, tileY * 16, 16, 16)
            end
            break
        end
  
        local part = PART_ORDER[i]
        if (not (noSpecial or alwaysCap)) and part == CAP and m.marioBodyState.capState == MARIO_HAS_DEFAULT_CAP_OFF then -- capless check
            capless = true
            part = HAIR
        elseif tileY == 2 or tileY == 7 then
            if part == CAP and capless then return end
            tileY = 7 -- use alt toad
            if part == HAIR then -- toad doesn't use hair except when cap is off
                if (not (noSpecial or alwaysCap)) and m.marioBodyState.capState == MARIO_HAS_DEFAULT_CAP_OFF then
                    capless = true
                    part = HAIR
                else
                    part = GLOVES
                end
            end
        end
        color = network_player_get_override_palette_color(np, part)
  
        djui_hud_set_color(color.r, color.g, color.b, alpha)
        if capless then
            djui_hud_render_texture_tile(HEAD_HUD, x, y, scaleX, scaleY, 6 * 16, tileY * 16, 16, 16) -- render hair instead of cap
        else
            djui_hud_render_texture_tile(HEAD_HUD, x, y, scaleX, scaleY, (i - 1) * 16, tileY * 16, 16, 16)
        end
    end
  
    if not isMetal then
        djui_hud_set_color(255, 255, 255, alpha)
        --djui_hud_render_texture(HEAD_HUD, x, y, scaleX, scaleY)
        djui_hud_render_texture_tile(HEAD_HUD, x, y, scaleX, scaleY, (#PART_ORDER) * 16, tileY * 16, 16, 16)
  
        if not capless then
            djui_hud_render_texture_tile(HEAD_HUD, x, y, scaleX, scaleY, (#PART_ORDER + 1) * 16, tileY * 16, 16, 16) -- hat emblem
            if (not noSpecial) and m.marioBodyState.capState == MARIO_HAS_WING_CAP_ON then
                djui_hud_render_texture(WING_HUD, x, y, scaleX, scaleY)                                        -- wing
            end
        end
    elseif m.marioBodyState.capState == MARIO_HAS_WING_CAP_ON then
        djui_hud_set_color(109, 170, 173, alpha)                -- blueish green
        djui_hud_render_texture(WING_HUD, x, y, scaleX, scaleY) -- wing
    end
end
