if incompatibleClient then return 0 end

-- Original Made by EliteMasterEric along with CoopDX PR #321 to replace dialog depending on character --
-- https://github.com/coop-deluxe/sm64coopdx/pull/321 --
-- Eric's Original stuffs will be added as soon as there is some way to directly get dialog strings

local dialogTable = {}
local function define_cs_dialog(dialogId, unused, linesPerBox, leftOffset, width, str)
    dialogTable[dialogId] = {
        unused = unused,
        linesPerBox = linesPerBox,
        leftOffset = leftOffset,
        width = width,
        str = str,
    }
end

local real_dialog_replace = smlua_text_utils_dialog_replace
_G.smlua_text_utils_dialog_replace = define_cs_dialog

-- All Base SM64 Dialog added to the Dialog Table
define_cs_dialog(DIALOG_000, 1, 6, 30, 200, ("Wow! You're smack in the\nmiddle of the battlefield.\nYou'll find the Power\nStars that Bowser stole\ninside the painting\nworlds.\nFirst, talk to the\nBob-omb Buddy. (Press [B]\nto talk.) He'll certainly\nhelp you out, and so will\nhis comrades in other\nareas.\nTo read signs, stop, face\nthem and press [B]. Press [A]\nor [B] to scroll ahead. You\ncan talk to some other\ncharacters by facing them\nand pressing [B]."))
define_cs_dialog(DIALOG_001, 1, 4, 95, 200, ("Watch out! If you wander\naround here, you're liable\nto be plastered by a\nwater bomb!\nThose enemy Bob-ombs love\nto fight, and they're\nalways finding ways to\nattack.\nThis meadow has become\na battlefield ever since\nthe Big Bob-omb got his\npaws on the Power Star.\nCan you recover the Star\nfor us? Cross the bridge\nand go left up the path\nto find the Big Bob-omb.\nPlease come back to see\nme after you've retrieved\nthe Power Star!"))
define_cs_dialog(DIALOG_002, 1, 4, 95, 200, ("Hey, you! It's dangerous\nahead, so listen up! Take\nmy advice.\n\nCross the two\nbridges ahead, then\nwatch for falling\nwater bombs.\nThe Big Bob-omb at the\ntop of the mountain is\nvery powerful--don't let\nhim grab you!\nWe're Bob-omb Buddies,\nand we're on your side.\nYou can talk to us\nwhenever you'd like to!"))
define_cs_dialog(DIALOG_003, 1, 5, 95, 200, ("Thank you, Mario! The Big\nBob-omb is nothing but a\nbig dud now! But the\nbattle for the castle has\njust begun.\nOther enemies are holding\nthe other Power Stars. If\nyou recover more Stars,\nyou can open new doors\nthat lead to new worlds!\nMy Bob-omb Buddies are\nwaiting for you. Be sure\nto talk to them--they'll\nset up cannons for you."))
define_cs_dialog(DIALOG_004, 1, 3, 95, 200, ("We're peace-loving\nBob-ombs, so we don't use\ncannons.\nBut if you'd like\nto blast off, we don't\nmind. Help yourself.\nWe'll prepare all of the\ncannons in this course for\nyou to use. Bon Voyage!"))
define_cs_dialog(DIALOG_005, 1, 3, 30, 200, ("Hey, Mario! Is it true\nthat you beat the Big\nBob-omb? Cool!\nYou must be strong. And\npretty fast. So, how fast\nare you, anyway?\nFast enough to beat me...\nKoopa the Quick? I don't\nthink so. Just try me.\nHow about a race to the\nmountaintop, where the\nBig Bob-omb was?\nWhaddya say? When I say\n『Go,』 let the race begin!\n\nReady....\n\n//Go!////Don't Go"))
define_cs_dialog(DIALOG_006, 1, 3, 30, 200, ("Hey!!! Don't try to scam\nME. You've gotta run\nthe whole course.\nLater. Look me up when\nyou want to race for\nreal."))
define_cs_dialog(DIALOG_007, 1, 5, 30, 200, ("Hufff...fff...pufff...\nWhoa! You...really...are...\nfast! A human blur!\nHere you go--you've won\nit, fair and square!"))
define_cs_dialog(DIALOG_008, 1, 4, 30, 200, ("BEWARE OF CHAIN CHOMP\nExtreme Danger!\nGet close and press [C]▲\nfor a better look.\nScary, huh?\nSee the Red Coin on top\nof the stake?\n\nWhen you collect eight of\nthem, a Power Star will\nappear in the meadow\nacross the bridge."))
define_cs_dialog(DIALOG_009, 1, 5, 30, 200, ("Long time, no see! Wow,\nhave you gotten fast!\nHave you been training\non the sly, or is it the\npower of the Stars?\nI've been feeling down\nabout losing the last\nrace. This is my home\ncourse--how about a\nrematch?\nThe goal is in\nWindswept Valley.\nReady?\n\n//Go//// Don't Go"))
define_cs_dialog(DIALOG_010, 1, 4, 30, 200, ("You've stepped on the\nWing Cap Switch. Wearing\nthe Wing Cap, you can\nsoar through the sky.\nNow Wing Caps will pop\nout of all the red blocks\nyou find.\n\nWould you like to Save?\n\n//Yes////No"))
define_cs_dialog(DIALOG_011, 1, 4, 30, 200, ("You've just stepped on\nthe Metal Cap Switch!\nThe Metal Cap makes\nMario invincible.\nNow Metal Caps will\npop out of all of the\ngreen blocks you find.\n\nWould you like to Save?\n\n//Yes////No"))
define_cs_dialog(DIALOG_012, 1, 4, 30, 200, ("You've just stepped on\nthe Vanish Cap Switch.\nThe Vanish Cap makes\nMario disappear.\nNow Vanish Caps will pop\nfrom all of the blue\nblocks you find.\n\nWould you like to Save?\n\n//Yes////No"))
define_cs_dialog(DIALOG_013, 1, 5, 30, 200, ("You've collected 100\ncoins! Mario gains more\npower from the castle.\nDo you want to Save?\n//Yes////No"))
define_cs_dialog(DIALOG_014, 1, 4, 30, 200, ("Wow! Another Power Star!\nMario gains more courage\nfrom the power of the\ncastle.\nDo you want to Save?\n\n//You Bet//Not Now"))
define_cs_dialog(DIALOG_015, 1, 4, 30, 200, ("You can punch enemies to\nknock them down. Press [A]\nto jump, [B] to punch.\nPress [A] then [B] to Kick.\nTo pick something up,\npress [B], too. To throw\nsomething you're holding,\npress [B] again."))
define_cs_dialog(DIALOG_016, 1, 3, 30, 200, ("Hop on the shiny shell and\nride wherever you want to\ngo! Shred those enemies!"))
define_cs_dialog(DIALOG_017, 1, 4, 30, 200, ("I'm the Big Bob-omb, lord\nof all blasting matter,\nking of ka-booms the\nworld over!\nHow dare you scale my\nmountain? By what right\ndo you set foot on my\nimperial mountaintop?\nYou may have eluded my\nguards, but you'll never\nescape my grasp...\n\n...and you'll never take\naway my Power Star. I\nhereby challenge you,\nMario!\nIf you want the Star I\nhold, you must prove\nyourself in battle.\n\nCan you pick me up from\nthe back and hurl me to\nthis royal turf? I think\nthat you cannot!"))
define_cs_dialog(DIALOG_018, 1, 4, 30, 200, ("I'm sleeping because...\n...I'm sleepy. I don't\nlike being disturbed.\nPlease walk quietly."))
define_cs_dialog(DIALOG_019, 1, 2, 30, 200, ("Shhh! Please walk\nquietly in the hallway!"))
define_cs_dialog(DIALOG_020, 1, 6, 95, 150, ("Dear Mario:\nPlease come to the\ncastle. I've baked\na cake for you.\nYours truly--\nPrincess Toadstool"))
define_cs_dialog(DIALOG_021, 1, 5, 95, 200, ("Welcome.\nNo one's home!\nNow scram--\nand don't come back!\nGwa ha ha!"))
define_cs_dialog(DIALOG_022, 1, 2, 95, 200, ("You need a key to open\nthis door."))
define_cs_dialog(DIALOG_023, 1, 3, 95, 200, ("This key doesn't fit!\nMaybe it's for the\nbasement..."))
define_cs_dialog(DIALOG_024, 1, 5, 95, 200, ("You need Star power to\nopen this door. Recover a\nPower Star from an enemy\ninside one of the castle's\npaintings."))
define_cs_dialog(DIALOG_025, 1, 4, 95, 200, ("It takes the power of\n3 Stars to open this\ndoor. You need [%] more\nStars."))
define_cs_dialog(DIALOG_026, 1, 4, 95, 200, ("It takes the power of\n8 Stars to open this\ndoor. You need [%] more\nStars."))
define_cs_dialog(DIALOG_027, 1, 4, 95, 200, ("It takes the power of\n30 Stars to open this\ndoor. You need [%] more\nStars."))
define_cs_dialog(DIALOG_028, 1, 4, 95, 200, ("It takes the power of\n50 Stars to open this\ndoor. You need [%] more\nStars."))
define_cs_dialog(DIALOG_029, 1, 5, 95, 200, ("To open the door that\nleads to the 『endless』\nstairs, you need 70\nStars.\nBwa ha ha!"))
define_cs_dialog(DIALOG_030, 1, 6, 30, 200, ("Hello! The Lakitu Bros.,\ncutting in with a live\nupdate on Mario's\nprogress. He's about to\nlearn a technique for\nsneaking up on enemies.\nThe trick is this: He has\nto walk very slowly in\norder to walk quietly.\n\n\n\nAnd wrapping up filming\ntechniques reported on\nearlier, you can take a\nlook around using [C]▶ and\n[C]◀. Press [C]▼ to view the\naction from a distance.\nWhen you can't move the\ncamera any farther, the\nbuzzer will sound. This is\nthe Lakitu Bros.,\nsigning off."))
define_cs_dialog(DIALOG_031, 1, 5, 30, 200, ("No way! You beat me...\nagain!! And I just spent\nmy entire savings on\nthese new Koopa\nMach 1 Sprint shoes!\nHere, I guess I have to\nhand over this Star to\nthe winner of the race.\nCongrats, Mario!"))
define_cs_dialog(DIALOG_032, 1, 5, 30, 200, ("If you get the Wing Cap,\nyou can fly! Put the cap\non, then do a Triple\nJump--jump three times\nin a row--to take off.\nYou can fly even higher\nif you blast out of a\ncannon wearing the\nWing Cap!\n\nUse the [C] Buttons to look\naround while flying, and\npress [Z] to land."))
define_cs_dialog(DIALOG_033, 1, 6, 30, 200, ("Ciao! You've reached\nPrincess Toadstool's\ncastle via a warp pipe.\nUsing the controller is a\npiece of cake. Press [A] to\njump and [B] to attack.\nPress [B] to read signs,\ntoo. Use the Control Stick\nin the center of the\ncontroller to move Mario\naround. Now, head for\nthe castle."))
define_cs_dialog(DIALOG_034, 1, 6, 30, 200, ("Good afternoon. The\nLakitu Bros., here,\nreporting live from just\noutside the Princess's\ncastle.\n\nMario has just arrived\non the scene, and we'll\nbe filming the action live\nas he enters the castle\nand pursues the missing\nPower Stars.\nAs seasoned cameramen,\nwe'll be shooting from the\nrecommended angle, but\nyou can change the\ncamera angle by pressing\nthe [C] Buttons.\nIf we can't adjust the\nview any further, we'll\nbuzz. To take a look at\nthe surroundings, stop\nand press [C]▲.\n\nPress [A] to resume play.\nSwitch camera modes with\nthe [R] Button. Signs along\nthe way will review these\ninstructions.\n\nFor now, reporting live,\nthis has been the\nLakitu Bros."))
define_cs_dialog(DIALOG_035, 1, 5, 30, 200, ("There are four camera, or\n『[C],』 Buttons. Press [C]▲\nto look around using the\nControl Stick.\n\nYou'll usually see Mario\nthrough Lakitu's camera.\nIt is the camera\nrecommended for normal\nplay.\nYou can change angles by\npressing [C]▶. If you press\n[R], the view switches to\nMario's camera, which\nis directly behind him.\nPress [R] again to return\nto Lakitu's camera. Press\n[C]▼ to see Mario from\nafar, using either\nLakitu's or Mario's view."))
define_cs_dialog(DIALOG_036, 1, 5, 30, 200, ("OBSERVATION PLATFORM\nPress [C]▲ to take a look\naround. Don't miss\nanything!\n\nPress [R] to switch to\nMario's camera. It\nalways follows Mario.\nPress [R] again to switch\nto Lakitu's camera.\nPause the game and\nswitch the mode to 『fix』\nthe camera in place while\nholding [R]. Give it a try!"))
define_cs_dialog(DIALOG_037, 1, 2, 30, 200, ("I win! You lose!\nHa ha ha ha!\nYou're no slouch, but I'm\na better sledder!\nBetter luck next time!"))
define_cs_dialog(DIALOG_038, 1, 3, 95, 200, ("Reacting to the Star\npower, the door slowly\nopens."))
define_cs_dialog(DIALOG_039, 1, 4, 30, 200, ("No visitors allowed,\nby decree of\nthe Big Bob-omb\n\nI shall never surrender my\nStars, for they hold the\npower of the castle in\ntheir glow.\nThey were a gift from\nBowser, the Koopa King\nhimself, and they lie well\nhidden within my realm.\nNot a whisper of their\nwhereabouts shall leave\nmy lips. Oh, all right,\nperhaps one hint:\nHeed the Star names at\nthe beginning of the\ncourse.\n//--The Big Bob-omb"))
define_cs_dialog(DIALOG_040, 1, 3, 30, 200, ("Warning!\nCold, Cold Crevasse\nBelow!"))
define_cs_dialog(DIALOG_041, 1, 3, 30, 200, ("I win! You lose!\nHa ha ha!\n\nThat's what you get for\nmessin' with Koopa the\nQuick.\nBetter luck next time!"))
define_cs_dialog(DIALOG_042, 1, 4, 30, 200, ("Caution! Narrow Bridge!\nCross slowly!\n\n\nYou can jump to the edge\nof the cliff and hang on,\nand you can climb off the\nedge if you move slowly.\nWhen you want to let go,\neither press [Z] or press\nthe Control Stick in the\ndirection of Mario's back.\nTo climb up, press Up on\nthe Control Stick. To\nscurry up quickly, press\nthe [A] Button."))
define_cs_dialog(DIALOG_043, 1, 5, 30, 200, ("If you jump and hold the\n[A] Button, you can hang on\nto some objects overhead.\nIt's the same as grabbing\na flying bird!"))
define_cs_dialog(DIALOG_044, 1, 5, 95, 200, ("Whooo's there? Whooo\nwoke me up? It's still\ndaylight--I should be\nsleeping!\n\nHey, as long as I'm\nawake, why not take a\nshort flight with me?\nPress and hold [A] to grab\non. Release [A] to let go.\nI'll take you wherever\nyou want to go, as long\nas my wings hold out.\nWatch my shadow, and\ngrab on."))
define_cs_dialog(DIALOG_045, 1, 6, 95, 200, ("Whew! I'm just about\nflapped out. You should\nlay off the pasta, Mario!\nThat's it for now. Press\n[A] to let go. Okay,\nbye byyyyyyeeee!"))
define_cs_dialog(DIALOG_046, 1, 5, 30, 200, ("You have to master three\nimportant jumping\ntechniques.\nFirst try the Triple Jump.\n\nRun fast, then jump three\ntimes, one, two, three.\nIf you time the jumps\nright, you'll hop, skip,\nthen jump really high.\nNext, go for distance\nwith the Long Jump. Run,\npress [Z] to crouch then [A]\nto jump really far.\n\nTo do the Wall Kick, press\n[A] to jump at a wall, then\njump again when you hit\nthe wall.\n\nGot that? Triple Jump,\nLong Jump, Wall Kick.\nPractice, practice,\npractice. You don't stand\na chance without them."))
define_cs_dialog(DIALOG_047, 1, 2, 95, 200, ("Hi! I'll prepare the\ncannon for you!"))
define_cs_dialog(DIALOG_048, 1, 4, 30, 200, ("Snow Mountain Summit\nWatch for slippery\nconditions! Please enter\nthe cottage first."))
define_cs_dialog(DIALOG_049, 1, 5, 30, 200, ("Remember that tricky Wall\nKick jump? It's a\ntechnique you'll have to\nmaster in order to reach\nhigh places.\nUse it to jump from wall\nto wall. Press the\nControl Stick in the\ndirection you want to\nbounce to gain momentum.\nPractice makes perfect!"))
define_cs_dialog(DIALOG_050, 1, 4, 30, 200, ("Hold [Z] to crouch and\nslide down a slope.\nOr press [Z] while in the\nair to Pound the Ground!\nIf you stop, crouch, then\njump, you'll do a\nBackward Somersault!\nGot that?\nThere's more. Crouch and\nthen jump to do a\nLong Jump! Or crouch and\nwalk to...never mind."))
define_cs_dialog(DIALOG_051, 1, 6, 30, 200, ("Climbing's easy! When you\njump at trees, poles or\npillars, you'll grab them\nautomatically. Press [A] to\njump off backward.\n\nTo rotate around the\nobject, press Right or\nLeft on the Control Stick.\nWhen you reach the top,\npress Up to do a\nhandstand!\nJump off from the\nhandstand for a high,\nstylin' dismount."))
define_cs_dialog(DIALOG_052, 1, 5, 30, 200, ("Stop and press [Z] to\ncrouch, then press [A]\nto do a high, Backward\nSomersault!\n\nTo perform a Side\nSomersault, run, do a\nsharp U-turn and jump.\nYou can catch lots of\nair with both jumps."))
define_cs_dialog(DIALOG_053, 1, 5, 30, 200, ("Sometimes, if you pass\nthrough a coin ring or\nfind a secret point in a\ncourse, a red number will\nappear.\nIf you trigger five red\nnumbers, a secret Star\nwill show up."))
define_cs_dialog(DIALOG_054, 1, 5, 30, 200, ("Welcome to the snow\nslide! Hop on! To speed\nup, press forward on the\nControl Stick. To slow\ndown, pull back."))
define_cs_dialog(DIALOG_055, 1, 4, 30, 200, ("Hey-ey, Mario, buddy,\nhowzit goin'? Step right\nup. You look like a fast\nsleddin' kind of guy.\nI know speed when I see\nit, yes siree--I'm the\nworld champion sledder,\nyou know. Whaddya say?\nHow about a race?\nReady...\n\n//Go//// Don't Go"))
define_cs_dialog(DIALOG_056, 1, 6, 30, 200, ("You brrrr-oke my record!\nUnbelievable! I knew\nthat you were the coolest.\nNow you've proven\nthat you're also the\nfastest!\nI can't award you a gold\nmedal, but here, take this\nStar instead. You've\nearned it!"))
define_cs_dialog(DIALOG_057, 1, 4, 30, 200, ("Egad! My baby!! Have you\nseen my baby??? She's\nthe most precious baby in\nthe whole wide world.\n(They say she has my\nbeak...) I just can't\nremember where I left\nher.\nLet's see...I stopped\nfor herring and ice cubes,\nthen I...oohh! I just\ndon't know!"))
define_cs_dialog(DIALOG_058, 1, 4, 30, 200, ("You found my precious,\nprecious baby! Where\nhave you been? How can\nI ever thank you, Mario?\nOh, I do have this...\n...Star. Here, take it\nwith my eternal\ngratitude."))
define_cs_dialog(DIALOG_059, 1, 4, 30, 200, ("That's not my baby! She\nlooks nothing like me!\nHer parents must be\nworried sick!"))
define_cs_dialog(DIALOG_060, 1, 4, 30, 200, ("ATTENTION!\nRead Before Diving In!\n\n\nIf you stay under the\nwater for too long, you'll\nrun out of oxygen.\n\nReturn to the surface for\nair or find an air bubble\nor coins to breathe while\nunderwater.\nPress [A] to swim. Hold [A]\nto swim slow and steady.\nTap [A] with smooth timing\nto gain speed.\nPress Up on the\nControl Stick and press [A]\nto dive.\n\nPress Down on the Control\nStick and press [A] to\nreturn to the surface.\n\nHold Down and press [A]\nwhile on the surface near\nthe edge of the water to\njump out."))
define_cs_dialog(DIALOG_061, 1, 4, 30, 200, ("BRRR! Frostbite Danger!\nDo not swim here.\nI'm serious.\n/--The Penguin"))
define_cs_dialog(DIALOG_062, 1, 3, 30, 200, ("Hidden inside the green\nblock is the amazing\nMetal Cap.\nWearing it, you won't\ncatch fire or be hurt\nby enemy attacks.\nYou don't even have to\nbreathe while wearing it.\n\nThe only problem:\nYou can't swim in it."))
define_cs_dialog(DIALOG_063, 1, 5, 30, 200, ("The Vanish Cap is inside\nthe blue block. Mr. I.\nwill be surprised, since\nyou'll be invisible when\nyou wear it!\nEven the Big Boo will be\nfooled--and you can walk\nthrough secret walls, too."))
define_cs_dialog(DIALOG_064, 1, 5, 30, 200, ("When you put on the Wing\nCap that comes from a\nred block, do the Triple\nJump to soar high into\nthe sky.\nUse the Control Stick to\nguide Mario. Pull back to\nto fly up, press forward\nto nose down, and press [Z]\nto land."))
define_cs_dialog(DIALOG_065, 1, 6, 30, 200, ("Swimming Lessons!\nTap [A] to do the breast\nstroke. If you time the\ntaps right, you'll swim\nfast.\n\nPress and hold [A] to do a\nslow, steady flutter kick.\nPress Up on the Control\nStick to dive, and pull\nback on the stick to head\nfor the surface.\nTo jump out of the water,\nhold Down on the Control\nStick, then press [A].\nEasy as pie, right?\n\n\nBut remember:\nMario can't breathe under\nthe water! Return to the\nsurface for air when the\nPower Meter runs low.\n\nAnd one last thing: You\ncan't open doors that\nare underwater."))
define_cs_dialog(DIALOG_066, 1, 5, 30, 200, ("Mario, it's Peach!\nPlease be careful! Bowser\nis so wicked! He will try\nto burn you with his\nhorrible flame breath.\nRun around behind and\ngrab him by the tail with\nthe [B] Button. Once you\ngrab hold, swing him\naround in great circles.\nRotate the Control Stick\nto go faster and faster.\nThe faster you swing him,\nthe farther he'll fly.\n\nUse the [C] Buttons to look\naround, Mario. You have\nto throw Bowser into one\nof the bombs in the four\ncorners.\nAim well, then press [B]\nagain to launch Bowser.\nGood luck, Mario! Our\nfate is in your hands."))
define_cs_dialog(DIALOG_067, 1, 5, 30, 200, ("Tough luck, Mario!\nPrincess Toadstool isn't\nhere...Gwa ha ha!! Go\nahead--just try to grab\nme by the tail!\nYou'll never be able to\nswing ME around! A wimp\nlike you won't throw me\nout of here! Never! Ha!"))
define_cs_dialog(DIALOG_068, 1, 5, 30, 200, ("It's Lethal Lava Land!\nIf you catch fire or fall\ninto a pool of flames,\nyou'll be hopping mad, but\ndon't lose your cool.\nYou can still control\nMario--just try to keep\ncalm!"))
define_cs_dialog(DIALOG_069, 1, 6, 30, 200, ("Sometimes you'll bump into\ninvisible walls at the\nedges of the painting\nworlds. If you hit a wall\nwhile flying, you'll bounce\nback."))
define_cs_dialog(DIALOG_070, 1, 5, 30, 200, ("You can return to the\ncastle's main hall at any\ntime from the painting\nworlds where the enemies\nlive.\nJust stop, stand still,\npress Start to pause the\ngame, then select\n『Exit Course.』\n\nYou don't have to collect\nall Power Stars in one\ncourse before going on to\nthe next.\n\nReturn later, when you're\nmore experienced, to pick\nup difficult ones.\n\n\nWhenever you find a Star,\na hint for finding the\nnext one will appear on\nthe course's start screen.\n\nYou can, however, collect\nany of the remaining\nStars next. You don't\nhave to recover the one\ndescribed by the hint."))
define_cs_dialog(DIALOG_071, 1, 3, 30, 200, ("Danger Ahead!\nBeware of the strange\ncloud! Don't inhale!\nIf you feel faint, run for\nhigher ground and fresh\nair!\nCircle: Shelter\nArrow: Entrance-Exit"))
define_cs_dialog(DIALOG_072, 1, 5, 30, 200, ("High winds ahead!\nPull your Cap down tight.\nIf it blows off, you'll\nhave to find it on this\nmountain."))
define_cs_dialog(DIALOG_073, 1, 4, 95, 200, ("Aarrgh! Ahoy, matey. I\nhave sunken treasure,\nhere, I do.\n\nBut to pluck the plunder,\nyou must open the\nTreasure Chests in the\nright order.\nWhat order is that,\nye say?\n\n\nI'll never tell!\n\n//--The Cap'n"))
define_cs_dialog(DIALOG_074, 1, 5, 30, 200, ("You can grab on to the\nedge of a cliff or ledge\nwith your fingertips and\nhang down from it.\n\nTo drop from the edge,\neither press the Control\nStick in the direction of\nMario's back or press the\n[Z] Button.\nTo get up onto the ledge,\neither press Up on the\nControl Stick or press [A]\nas soon as you grab the\nledge to climb up quickly."))
define_cs_dialog(DIALOG_075, 1, 5, 30, 200, ("Mario!! My castle is in\ngreat peril. I know that\nBowser is the cause...and\nI know that only you can\nstop him!\nThe doors in the castle\nthat have been sealed by\nBowser can be opened only\nwith Star Power.\n\nBut there are secret\npaths in the castle,\npaths that Bowser hasn't\nfound.\n\nOne of those paths is in\nthis room, and it holds\none of the castle's Secret\nStars!\n\nFind that Secret Star,\nMario! It will help you\non your quest. Please,\nMario, you have to\nhelp us!\nRetrieve all of the\nPower Stars in the castle\nand free us from this\nawful prison!\nPlease!"))
define_cs_dialog(DIALOG_076, 1, 6, 30, 200, ("Thanks to the power of\nthe Stars, life is\nreturning to the castle.\nPlease, Mario, you have\nto give Bowser the boot!\n\nHere, let me tell you a\nlittle something about the\ncastle. In the room with\nthe mirrors, look carefully\nfor anything that's not\nreflected in the mirror.\nAnd when you go to the\nwater town, you can flood\nit with a high jump into\nthe painting. Oh, by the\nway, look what I found!"))
define_cs_dialog(DIALOG_077, 1, 2, 150, 200, ("It is decreed that one\nshall pound the pillars."))
define_cs_dialog(DIALOG_078, 1, 5, 30, 200, ("Break open the Blue Coin\nBlock by Pounding the\nGround with the [Z] Button.\nOne Blue Coin is worth\nfive Yellow Coins.\nBut you have to hurry!\nThe coins will disappear\nif you're not quick to\ncollect them! Too bad."))
define_cs_dialog(DIALOG_079, 1, 4, 30, 200, ("Owwwuu! Let me go!\nUukee-kee! I was only\nteasing! Can't you take\na joke?\nI'll tell you what, let's\ntrade. If you let me go,\nI'll give you something\nreally good.\nSo, how about it?\n\n//Free him/ Hold on"))
define_cs_dialog(DIALOG_080, 1, 1, 30, 200, ("Eeeh hee hee hee!"))
define_cs_dialog(DIALOG_081, 1, 4, 30, 200, ("The mystery is of Wet\nor Dry.\nAnd where does the\nsolution lie?\nThe city welcomes visitors\nwith the depth they bring\nas they enter."))
define_cs_dialog(DIALOG_082, 1, 4, 30, 200, ("Hold on to your hat! If\nyou lose it, you'll be\ninjured easily.\n\nIf you do lose your Cap,\nyou'll have to find it in\nthe course where you\nlost it.\nOh, boy, it's not looking\ngood for Peach. She's\nstill trapped somewhere\ninside the walls.\nPlease, Mario, you have\nto help her! Did you know\nthat there are enemy\nworlds inside the walls?\nYup. It's true. Bowser's\ntroops are there, too.\nOh, here, take this. I've\nbeen keeping it for you."))
define_cs_dialog(DIALOG_083, 1, 6, 30, 200, ("There's something strange\nabout that clock. As you\njump inside, watch the\nposition of the big hand.\nOh, look what I found!\nHere, Mario, catch!"))
define_cs_dialog(DIALOG_084, 1, 3, 30, 200, ("Yeeoww! Unhand me,\nbrute! I'm late, so late,\nI must make haste!\nThis shiny thing? Mine!\nIt's mine. Finders,\nkeepers, losers...\nLate, late, late...\nOuch! Take it then! A\ngift from Bowser, it was.\nNow let me be! I have a\ndate! I cannot be late\nfor tea!"))
define_cs_dialog(DIALOG_085, 1, 5, 30, 200, ("You don't stand a ghost\nof a chance in this house.\nIf you walk out of here,\nyou deserve...\n...a Ghoul Medal..."))
define_cs_dialog(DIALOG_086, 1, 3, 30, 200, ("Running around in circles\nmakes some bad guys roll\ntheir eyes."))
define_cs_dialog(DIALOG_087, 1, 4, 30, 200, ("Santa Claus isn't the only\none who can go down a\nchimney! Come on in!\n/--Cabin Proprietor"))
define_cs_dialog(DIALOG_088, 1, 5, 30, 200, ("Work Elevator\nFor those who get off\nhere: Grab the pole to the\nleft and slide carefully\ndown."))
define_cs_dialog(DIALOG_089, 1, 5, 95, 200, ("Both ways fraught with\ndanger! Watch your feet!\nThose who can't do the\nLong Jump, tsk, tsk. Make\nyour way to the right.\nRight: Work Elevator\n/// Cloudy Maze\nLeft: Black Hole\n///Underground Lake\n\nRed Circle: Elevator 2\n//// Underground Lake\nArrow: You are here"))
define_cs_dialog(DIALOG_090, 1, 6, 30, 200, ("Bwa ha ha ha!\nYou've stepped right into\nmy trap, just as I knew\nyou would! I warn you,\n" .. ' "Friend," ' .. "watch your\nstep!"))
define_cs_dialog(DIALOG_091, 2, 2, 30, 200, ("Danger!\nStrong Gusts!\nBut the wind makes a\ncomfy ride."))
define_cs_dialog(DIALOG_092, 1, 5, 30, 200, ("Pestering me again, are\nyou, Mario? Can't you see\nthat I'm having a merry\nlittle time, making\nmischief with my minions?\nNow, return those Stars!\nMy troops in the walls\nneed them! Bwa ha ha!"))
define_cs_dialog(DIALOG_093, 1, 5, 30, 200, ("Mario! You again! Well\nthat's just fine--I've\nbeen looking for something\nto fry with my fire\nbreath!\nYour Star Power is\nuseless against me!\nYour friends are all\ntrapped within the\nwalls...\nAnd you'll never see the\nPrincess again!\nBwa ha ha ha!"))
define_cs_dialog(DIALOG_094, 1, 4, 30, 200, ("Get a good run up the\nslope! Do you remember\nthe Long Jump? Run, press\n[Z], then jump!"))
define_cs_dialog(DIALOG_095, 1, 4, 30, 200, ("To read a sign, stand in\nfront of it and press [B],\nlike you did just now.\n\nWhen you want to talk to\na Koopa Troopa or other\nanimal, stand right in\nfront of it.\nPlease recover the Stars\nthat were stolen by\nBowser in this course."))
define_cs_dialog(DIALOG_096, 1, 4, 30, 200, ("The path is narrow here.\nEasy does it! No one is\nallowed on top of the\nmountain!\nAnd if you know what's\ngood for you, you won't\nwake anyone who's\nsleeping!\nMove slowly,\ntread lightly."))
define_cs_dialog(DIALOG_097, 1, 5, 30, 200, ("Don't be a pushover!\nIf anyone tries to shove\nyou around, push back!\nIt's one-on-one, with a\nfiery finish for the loser!"))
define_cs_dialog(DIALOG_098, 1, 2, 95, 200, ("Come on in here...\n...heh, heh, heh..."))
define_cs_dialog(DIALOG_099, 1, 5, 95, 200, ("Eh he he...\nYou're mine, now, hee hee!\nI'll pass right through\nthis wall. Can you do\nthat? Heh, heh, heh!")) -- unused
define_cs_dialog(DIALOG_100, 1, 3, 95, 200, ("Ukkiki...Wakkiki...kee kee!\nHa! I snagged it!\nIt's mine! Heeheeheeee!"))
define_cs_dialog(DIALOG_101, 1, 3, 95, 200, ("Ackk! Let...go...\nYou're...choking...me...\nCough...I've been framed!\nThis Cap? Oh, all right,\ntake it. It's a cool Cap,\nbut I'll give it back.\nI think it looks better on\nme than it does on you,\nthough! Eeeee! Kee keee!"))
define_cs_dialog(DIALOG_102, 1, 5, 30, 200, ("Pssst! The Boos are super\nshy. If you look them\nin the eyes, they fade\naway, but if you turn\nyour back, they reappear.\nIt's no use trying to hit\nthem when they're fading\naway. Instead, sneak up\nbehind them and punch."))
define_cs_dialog(DIALOG_103, 1, 4, 95, 200, ("Upon four towers\none must alight...\nThen at the peak\nshall shine the light..."))
define_cs_dialog(DIALOG_104, 1, 5, 30, 200, ("The shadowy star in front\nof you is a 『Star\nMarker.』 When you collect\nall 8 Red Coins, the Star\nwill appear here."))
define_cs_dialog(DIALOG_105, 1, 3, 95, 200, ("Ready for blastoff! Come\non, hop into the cannon!\n\nYou can reach the Star on\nthe floating island by\nusing the four cannons.\nUse the Control Stick to\naim, then press [A] to fire.\n\nIf you're handy, you can\ngrab on to trees or poles\nto land."))
define_cs_dialog(DIALOG_106, 1, 2, 95, 200, ("Ready for blastoff! Come\non, hop into the cannon!"))
define_cs_dialog(DIALOG_107, 1, 3, 95, 200, ("Ghosts...\n...don't...\n...DIE!\nHeh, heh, heh!\nCan you get out of here...\n...alive?"))
define_cs_dialog(DIALOG_108, 1, 2, 95, 200, ("Boooooo-m! Here comes\nthe master of mischief,\nthe tower of terror,\nthe Big Boo!\nKa ha ha ha..."))
define_cs_dialog(DIALOG_109, 1, 4, 95, 200, ("Ooooo Nooooo!\nTalk about out-of-body\nexperiences--my body\nhas melted away!\nHave you run in to any\nheadhunters lately??\nI could sure use a new\nbody!\nBrrr! My face might\nfreeze like this!"))
define_cs_dialog(DIALOG_110, 1, 5, 95, 200, ("I need a good head on my\nshoulders. Do you know of\nanybody in need of a good\nbody? Please! I'll follow\nyou if you do!"))
define_cs_dialog(DIALOG_111, 1, 4, 95, 200, ("Perfect! What a great\nnew body! Here--this is a\npresent for you. It's sure\nto warm you up."))
define_cs_dialog(DIALOG_112, 1, 4, 30, 200, ("Collect as many coins as\npossible! They'll refill\nyour Power Meter.\n\nYou can check to see how\nmany coins you've\ncollected in each of the\n15 enemy worlds.\nYou can also recover\npower by touching the\nSpinning Heart.\n\nThe faster you run\nthrough the heart, the\nmore power you'll recover."))
define_cs_dialog(DIALOG_113, 1, 6, 30, 200, ("There are special Caps in\nthe red, green and blue\nblocks. Step on the\nswitches in the hidden\ncourses to activate the\nCap Blocks."))
define_cs_dialog(DIALOG_114, 1, 5, 95, 200, ("It makes me so mad! We\nbuild your houses, your\ncastles. We pave your\nroads, and still you\nwalk all over us.\nDo you ever say thank\nyou? No! Well, you're not\ngoing to wipe your feet\non me! I think I'll crush\nyou just for fun!\nDo you have a problem\nwith that? Just try to\npound me, wimp! Ha!"))
define_cs_dialog(DIALOG_115, 1, 5, 95, 200, ("No! Crushed again!\nI'm just a stepping stone,\nafter all. I won't gravel,\ner, grovel. Here, you win.\nTake this with you!"))
define_cs_dialog(DIALOG_116, 1, 5, 95, 200, ("Whaaa....Whaaat?\nCan it be that a\npipsqueak like you has\ndefused the Bob-omb\nking????\nYou might be fast enough\nto ground me, but you'll\nhave to pick up the pace\nif you want to take King\nBowser by the tail.\nMethinks my troops could\nlearn a lesson from you!\nHere is your Star, as I\npromised, Mario.\n\nIf you want to see me\nagain, select this Star\nfrom the menu. For now,\nfarewell."))
define_cs_dialog(DIALOG_117, 1, 1, 95, 200, ("Who...walk...here?\nWho...break...seal?\nWake..ancient..ones?\nWe no like light...\nRrrrummbbble...\nWe no like...intruders!\nNow battle...\n...hand...\n...to...\n...hand!"))
define_cs_dialog(DIALOG_118, 1, 6, 95, 200, ("Grrrrumbbble!\nWhat...happen?\nWe...crushed like pebble.\nYou so strong!\nYou rule ancient pyramid!\nFor today...\nNow, take Star of Power.\nWe...sleep...darkness."))
define_cs_dialog(DIALOG_119, 1, 6, 30, 200, ("Grrr! I was a bit\ncareless. This is not as I\nhad planned...but I still\nhold the power of the\nStars, and I still have\nPeach.\nBwa ha ha! You'll get no\nmore Stars from me! I'm\nnot finished with you yet,\nbut I'll let you go for\nnow. You'll pay for this...\nlater!"))
define_cs_dialog(DIALOG_120, 1, 4, 30, 200, ("Ooowaah! Can it be that\nI've lost??? The power of\nthe Stars has failed me...\nthis time.\nConsider this a draw.\nNext time, I'll be in\nperfect condition.\n\nNow, if you want to see\nyour precious Princess,\ncome to the top of the\ntower.\nI'll be waiting!\nGwa ha ha ha!"))
define_cs_dialog(DIALOG_121, 1, 5, 30, 200, ("Nooo! It can't be!\nYou've really beaten me,\nMario?!! I gave those\ntroops power, but now\nit's fading away!\nArrgghh! I can see peace\nreturning to the world! I\ncan't stand it! Hmmm...\nIt's not over yet...\n\nC'mon troops! Let's watch\nthe ending together!\nBwa ha ha!"))
define_cs_dialog(DIALOG_122, 1, 4, 30, 200, ("The Black Hole\nRight: Work Elevator\n/// Cloudy Maze\nLeft: Underground Lake"))
define_cs_dialog(DIALOG_123, 1, 4, 30, 200, ("Metal Cavern\nRight: To Waterfall\nLeft: Metal Cap Switch"))
define_cs_dialog(DIALOG_124, 1, 4, 30, 200, ("Work Elevator\nDanger!!\nRead instructions\nthoroughly!\nElevator continues in the\ndirection of the arrow\nactivated."))
define_cs_dialog(DIALOG_125, 1, 3, 30, 200, ("Hazy Maze-Exit\nDanger! Closed.\nTurn back now."))
define_cs_dialog(DIALOG_126, 2, 3, 30, 200, ("Up: Black Hole\nRight: Work Elevator\n/// Hazy Maze"))
define_cs_dialog(DIALOG_127, 3, 4, 30, 200, ("Underground Lake\nRight: Metal Cave\nLeft: Abandoned Mine\n///(Closed)\nA gentle sea dragon lives\nhere. Pound on his back to\nmake him lower his head.\nDon't become his lunch."))
define_cs_dialog(DIALOG_128, 1, 4, 95, 200, ("You must fight with\nhonor! It is against the\nroyal rules to throw the\nking out of the ring!"))
define_cs_dialog(DIALOG_129, 1, 5, 30, 200, ("Welcome to the Vanish\nCap Switch Course! All of\nthe blue blocks you find\nwill become solid once you\nstep on the Cap Switch.\nYou'll disappear when you\nput on the Vanish Cap, so\nyou'll be able to elude\nenemies and walk through\nmany things. Try it out!"))
define_cs_dialog(DIALOG_130, 1, 5, 30, 200, ("Welcome to the Metal Cap\nSwitch Course! Once you\nstep on the Cap Switch,\nthe green blocks will\nbecome solid.\nWhen you turn your body\ninto metal with the Metal\nCap, you can walk\nunderwater! Try it!"))
define_cs_dialog(DIALOG_131, 1, 5, 30, 200, ("Welcome to the Wing Cap\nCourse! Step on the red\nswitch at the top of the\ntower, in the center of\nthe rainbow ring.\nWhen you trigger the\nswitch, all of the red\nblocks you find will\nbecome solid.\n\nTry out the Wing Cap! Do\nthe Triple Jump to take\noff and press [Z] to land.\n\n\nPull back on the Control\nStick to go up and push\nforward to nose down,\njust as you would when\nflying an airplane."))
define_cs_dialog(DIALOG_132, 1, 4, 30, 200, ("Whoa, Mario, pal, you\naren't trying to cheat,\nare you? Shortcuts aren't\nallowed.\nNow, I know that you\nknow better. You're\ndisqualified! Next time,\nplay fair!"))
define_cs_dialog(DIALOG_133, 1, 6, 30, 200, ("Am I glad to see you! The\nPrincess...and I...and,\nwell, everybody...we're all\ntrapped inside the castle\nwalls.\n\nBowser has stolen the\ncastle's Stars, and he's\nusing their power to\ncreate his own world in\nthe paintings and walls.\n\nPlease recover the Power\nStars! As you find them,\nyou can use their power\nto open the doors that\nBowser has sealed.\n\nThere are four rooms on\nthe first floor. Start in\nthe one with the painting\nof Bob-omb inside. It's\nthe only room that Bowser\nhasn't sealed.\nWhen you collect eight\nPower Stars, you'll be\nable to open the door\nwith the big star. The\nPrincess must be inside!"))
define_cs_dialog(DIALOG_134, 1, 5, 30, 200, ("The names of the Stars\nare also hints for\nfinding them. They are\ndisplayed at the beginning\nof each course.\nYou can collect the Stars\nin any order. You won't\nfind some Stars, enemies\nor items unless you select\na specific Star.\nAfter you collect some\nStars, you can try\nanother course.\nWe're all waiting for\nyour help!"))
define_cs_dialog(DIALOG_135, 1, 5, 30, 200, ("It was Bowser who stole\nthe Stars. I saw him with\nmy own eyes!\n\n\nHe's hidden six Stars in\neach course, but you\nwon't find all of them in\nsome courses until you\npress the Cap Switches.\nThe Stars you've found\nwill show on each course's\nstarting screen.\n\n\nIf you want to see some\nof the enemies you've\nalready defeated, select\nthe Stars you recovered\nfrom them."))
define_cs_dialog(DIALOG_136, 1, 6, 30, 200, ("Wow! You've already\nrecovered that many\nStars? Way to go, Mario!\nI'll bet you'll have us out\nof here in no time!\n\nBe careful, though.\nBowser and his band\nwrote the book on 『bad.』\nTake my advice: When you\nneed to recover from\ninjuries, collect coins.\nYellow Coins refill one\npiece of the Power Meter,\nRed Coins refill two\npieces, and Blue Coins\nrefill five.\n\nTo make Blue Coins\nappear, pound on Blue\nCoin Blocks.\n\n\n\nAlso, if you fall from\nhigh places, you'll\nminimize damage if you\nPound the Ground as you\nland."))
define_cs_dialog(DIALOG_137, 1, 6, 30, 200, ("Thanks, Mario! The castle\nis recovering its energy\nas you retrieve Power\nStars, and you've chased\nBowser right out of here,\non to some area ahead.\nOh, by the by, are you\ncollecting coins? Special\nStars appear when you\ncollect 100 coins in each\nof the 15 courses!"))
define_cs_dialog(DIALOG_138, 1, 3, 30, 200, ("Down: Underground Lake\nLeft: Black Hole\nRight: Hazy Maze (Closed)"))
define_cs_dialog(DIALOG_139, 1, 6, 30, 200, ("Above: Automatic Elevator\nElevator begins\nautomatically and follows\npre-set course.\nIt disappears\nautomatically, too."))
define_cs_dialog(DIALOG_140, 1, 6, 30, 200, ("Elevator Area\nRight: Hazy Maze\n/// Entrance\nLeft: Black Hole\n///Elevator 1\nArrow: You are here"))
define_cs_dialog(DIALOG_141, 1, 5, 150, 200, ("You've recovered one of\nthe stolen Power Stars!\nNow you can open some of\nthe sealed doors in the\ncastle.\nTry the Princess's room\non the second floor and\nthe room with the\npainting of Whomp's\nFortress on Floor 1.\nBowser's troops are still\ngaining power, so you\ncan't give up. Save us,\nMario! Keep searching for\nStars!"))
define_cs_dialog(DIALOG_142, 1, 5, 150, 200, ("You've recovered three\nPower Stars! Now you can\nopen any door with a 3\non its star.\n\nYou can come and go from\nthe open courses as you\nplease. The enemies ahead\nare even meaner, so be\ncareful!"))
define_cs_dialog(DIALOG_143, 1, 6, 150, 200, ("You've recovered eight of\nthe Power Stars! Now you\ncan open the door with\nthe big Star! But Bowser\nis just ahead...can you\nhear the Princess calling?"))
define_cs_dialog(DIALOG_144, 1, 6, 150, 200, ("You've recovered 30\nPower Stars! Now you can\nopen the door with the\nbig Star! But before you\nmove on, how's it going\notherwise?\nDid you pound the two\ncolumns down? You didn't\nlose your hat, did you?\nIf you did, you'll have to\nstomp on the condor to\nget it back!\nThey say that Bowser has\nsneaked out of the sea\nand into the underground.\nHave you finally\ncornered him?"))
define_cs_dialog(DIALOG_145, 1, 6, 150, 200, ("You've recovered 50\nPower Stars! Now you can\nopen the Star Door on the\nthird floor. Bowser's\nthere, you know.\n\nOh! You've found all of\nthe Cap Switches, haven't\nyou? Red, green and blue?\nThe Caps you get from the\ncolored blocks are really\nhelpful.\nHurry along, now. The\nthird floor is just ahead."))
define_cs_dialog(DIALOG_146, 1, 6, 150, 200, ("You've found 70 Power\nStars! The mystery of the\nendless stairs is solved,\nthanks to you--and is\nBowser ever upset! Now,\non to the final bout!"))
define_cs_dialog(DIALOG_147, 1, 5, 30, 200, ("Are you using the Cap\nBlocks? You really should,\nyou know.\n\n\nTo make them solid so you\ncan break them, you have\nto press the colored Cap\nSwitches in the castle's\nhidden courses.\nYou'll find the hidden\ncourses only after\nregaining some of the\nPower Stars.\n\nThe Cap Blocks are a big\nhelp! Red for the Wing\nCap, green for the Metal\nCap, blue for the Vanish\nCap."))
define_cs_dialog(DIALOG_148, 1, 6, 30, 200, ("Snowman Mountain ahead.\nKeep out! And don't try\nthe Triple Jump over the\nice block shooter.\n\n\nIf you fall into the\nfreezing pond, your power\ndecreases quickly, and\nyou won't recover\nautomatically.\n//--The Snowman"))
define_cs_dialog(DIALOG_149, 1, 3, 30, 200, ("Welcome to\nPrincess Toadstool's\nsecret slide!\nThere's a Star hidden\nhere that Bowser couldn't\nfind.\nWhen you slide, press\nforward to speed up,\npull back to slow down.\nIf you slide really\nfast, you'll win the Star!"))
define_cs_dialog(DIALOG_150, 1, 5, 30, 200, ("Waaaa! You've flooded my\nhouse! Wh-why?? Look at\nthis mess! What am I\ngoing to do now?\n\nThe ceiling's ruined, the\nfloor is soaked...what to\ndo, what to do? Huff...\nhuff...it makes me so...\nMAD!!!\nEverything's been going\nwrong ever since I got\nthis Star...It's so shiny,\nbut it makes me feel...\nstrange..."))
define_cs_dialog(DIALOG_151, 1, 4, 30, 200, ("I can't take this\nanymore! First you get\nme all wet, then you\nstomp on me!\nNow I'm really, really,\nREALLY mad!\nWaaaaaaaaaaaaaaaaa!!!"))
define_cs_dialog(DIALOG_152, 1, 3, 30, 200, ("Owwch! Uncle! Uncle!\nOkay, I give. Take this\nStar!\nWhew! I feel better now.\nI don't really need it\nanymore, anyway--\nI can see the stars\nthrough my ceiling at\nnight.\nThey make me feel...\n...peaceful. Please, come\nback and visit anytime."))
define_cs_dialog(DIALOG_153, 1, 4, 30, 200, ("Hey! Who's there?\nWhat's climbing on me?\nIs it an ice ant?\nA snow flea?\nWhatever it is, it's\nbugging me! I think I'll\nblow it away!"))
define_cs_dialog(DIALOG_154, 1, 5, 30, 200, ("Hold on to your hat! If\nyou lose it, you'll be\neasily injured. If you\nlose it, look for it in the\ncourse where you lost it.\nSpeaking of lost, the\nPrincess is still stuck in\nthe walls somewhere.\nPlease help, Mario!\n\nOh, you know that there\nare secret worlds in the\nwalls as well as in the\npaintings, right?"))
define_cs_dialog(DIALOG_155, 1, 6, 30, 200, ("Thanks to the power of\nthe Stars, life is\nreturning to the castle.\nPlease, Mario, you have\nto give Bowser the boot!\n\nHere, let me tell you a\nlittle something about the\ncastle. In the room with\nthe mirrors, look carefully\nfor anything that's not\nreflected in the mirror.\nAnd when you go to the\nwater town, you can flood\nit with a high jump into\nthe painting."))
define_cs_dialog(DIALOG_156, 1, 5, 30, 200, ("The world inside the\nclock is so strange!\nWhen you jump inside,\nwatch the position of\nthe big hand!"))
define_cs_dialog(DIALOG_157, 1, 5, 30, 200, ("Watch out! Don't let\nyourself be swallowed by\nquicksand.\n\n\nIf you sink into the sand,\nyou won't be able to\njump, and if your head\ngoes under, you'll be\nsmothered.\nThe dark areas are\nbottomless pits."))
define_cs_dialog(DIALOG_158, 1, 6, 30, 200, ("1. If you jump repeatedly\nand time it right, you'll\njump higher and higher.\nIf you run really fast and\ntime three jumps right,\nyou can do a Triple Jump.\n2. Jump into a solid wall,\nthen jump again when you\nhit the wall. You can\nbounce to a higher level\nusing this Wall Kick."))
define_cs_dialog(DIALOG_159, 1, 6, 30, 200, ("3. If you stop, press [Z]\nto crouch, then jump, you\ncan perform a Backward\nSomersault. To do a Long\nJump, run fast, press [Z],\nthen jump."))
define_cs_dialog(DIALOG_160, 1, 4, 30, 200, ("Press [B] while running\nfast to do a Body Slide\nattack. To stand while\nsliding, press [A] or [B]."))
define_cs_dialog(DIALOG_161, 1, 4, 30, 200, ("Mario!!!\nIt that really you???\nIt has been so long since\nour last adventure!\nThey told me that I might\nsee you if I waited here,\nbut I'd just about given\nup hope!\nIs it true? Have you\nreally beaten Bowser? And\nrestored the Stars to the\ncastle?\nAnd saved the Princess?\nI knew you could do it!\nNow I have a very special\nmessage for you.\nThanks for playing Super\nMario 64! This is the\nend of the game, but not\nthe end of the fun.\nWe want you to keep on\nplaying, so we have a\nlittle something for you.\nWe hope that you like it!\nEnjoy!!!\n\nThe Super Mario 64 Team"))
define_cs_dialog(DIALOG_162, 1, 4, 30, 200, ("No, no, no! Not you\nagain! I'm in a great\nhurry, can't you see?\n\nI've no time to squabble\nover Stars. Here, have it.\nI never meant to hide it\nfrom you...\nIt's just that I'm in such\na rush. That's it, that's\nall. Now, I must be off.\nOwww! Let me go!"))
define_cs_dialog(DIALOG_163, 1, 5, 30, 200, ("Noooo! You've really\nbeaten me this time,\nMario! I can't stand\nlosing to you!\n\nMy troops...worthless!\nThey've turned over all\nthe Power Stars! What?!\nThere are 120 in all???\n\nAmazing! There were some\nin the castle that I\nmissed??!!\n\n\nNow I see peace\nreturning to the world...\nOooo! I really hate that!\nI can't watch--\nI'm outta here!\nJust you wait until next\ntime. Until then, keep\nthat Control Stick\nsmokin'!\nBuwaa ha ha!"))
define_cs_dialog(DIALOG_164, 1, 4, 30, 200, ("Mario! What's up, pal?\nI haven't been on the\nslide lately, so I'm out\nof shape.\nStill, I'm always up for a\ngood race, especially\nagainst an old sleddin'\nbuddy.\nWhaddya say?\nReady...set...\n\n//Go//// Don't Go"))
define_cs_dialog(DIALOG_165, 1, 5, 30, 200, ("I take no responsibility\nwhatsoever for those who\nget dizzy and pass out\nfrom running around\nthis post."))
define_cs_dialog(DIALOG_166, 1, 4, 30, 200, ("I'll be back soon.\nI'm out training now,\nso come back later.\n//--Koopa the Quick"))
define_cs_dialog(DIALOG_167, 1, 4, 30, 200, ("Princess Toadstool's\ncastle is just ahead.\n\n\nPress [A] to jump, [Z] to\ncrouch, and [B] to punch,\nread a sign, or grab\nsomething.\nPress [B] again to throw\nsomething you're holding."))
define_cs_dialog(DIALOG_168, 1, 5, 30, 200, ("Hey! Knock it off! That's\nthe second time you've\nnailed me. Now you're\nasking for it, linguine\nbreath!"))
define_cs_dialog(DIALOG_169, 1, 4, 30, 200, ("Keep out!\nThat means you!\nArrgghh!\n\nAnyone entering this cave\nwithout permission will\nmeet certain disaster."))

local DIALOG_NAME = "Mario"

---@param name string
function dialog_set_replace_name(name)
    DIALOG_NAME = name
end

local prevCharName = ""

local function dialog_swap(charName)
    for i = DIALOG_000, #dialogTable do
        if dialogTable[i] ~= nil then
            local dialog = dialogTable[i]
            charName = charName:gsub('"', "''")
            local replaced_dialog = dialog.str:gsub(DIALOG_NAME, charName)
            real_dialog_replace(i, dialog.unused, dialog.linesPerBox, dialog.leftOffset, dialog.width, replaced_dialog)
        end
    end
end

local function update()
    -- Query Character Swapped
    local charName = characterTable[currChar][characterTable[currChar].currAlt].name
    if prevCharName ~= charName then
        dialog_swap(charName)
        prevCharName = charName
    end
end

hook_event(HOOK_UPDATE, update)