-- name: BA Animated Spray Pack
-- description: Animated Sprays for Moi64

-- Format for Animated Spray Table
-- {"SprayName", {"TextureName", frame count, fps }}
local SPRAY_TABLE = {
  { "shurocola", { "shuro", 148, 33.3 } },
  { "yuukayaps", { "yuukayaps", 50, 20 } },
  { "mika", { "mikapoint", 16, 3 } },
  { "seia_eyes", { "seia_eyes", 39, 13 } },
  { "seia_lick", { "seia_lick", 166, 10 } },
  { "reisa_dance", { "reisa_dance", 33, 13 } },
  { "reisa_dance2nd", { "reisa_dance2nd", 9, 4 } },
  { "reisa_dance3rd", { "reisa_dance3rd", 19, 4 } },
  { "reisa_point", { "reisa_point", 123, 13 } },
  { "konoka_spin", { "konoka_spin", 4, 4 } },
  { "konoka_spin2", { "konoka_spin", 4, 12 } },
  { "junko", { "junko", 45, 10 } },
}


local function on_mods_loaded()
  if _G.sprayModExists then
    for _, spray in ipairs(SPRAY_TABLE) do
      if type(spray[2]) == "table" then
        local texs = {}
        for i = 1, spray[2][2] do
          texs[#texs+1] = get_texture_info(spray[2][1] .. tostring(i))
        end
        _G.sprayMod.create_spray(spray[1], { texs, spray[2][3] })
      else
        _G.sprayMod.create_spray(spray[1], get_texture_info(spray[2]))
      end
    end
  else
    print("Spraymod does not exist.")
  end
end


hook_event(HOOK_ON_MODS_LOADED, on_mods_loaded)
