propMenu = false

local selectedOption = 1
local menuTitle = "MODEL SELECT"

local function fake_bobomb_buddy(o, m)
    if m.playerIndex ~= 0 then
        cur_obj_push_mario_away_from_cylinder(100, 60)
    end

    o.oBehParams2ndByte = math.random(DIALOG_000, DIALOG_160)

    local animFrame = o.header.gfx.animInfo.animFrame;
    if ((animFrame == 5) or (animFrame == 16)) then
        cur_obj_play_sound_2(SOUND_OBJ_BOBOMB_WALK)
    end

    local player = nearest_player_to_object(m.marioObj);
    if (player and dist_between_objects(o, player) < 1000.0) then
        o.oMoveAngleYaw = approach_s16_symmetric(o.oMoveAngleYaw, obj_angle_to_object(o, player), 0x140)
    end
end

local function fake_small_breakable_box(o, m)

    if (m.wall and o.oBreakableBoxSmallReleased >= 1) or cur_obj_was_attacked_or_ground_pounded() ~= 0 then
        spawn_mist_particles()
        spawn_triangle_break_particles(20, 138, 0.7, 3)
        obj_spawn_yellow_coins(o, 3)
        play_sound(SOUND_GENERAL_BREAK_BOX, gGlobalSoundSource)
        network_send_object(o, true)
        play_sound(SOUND_OBJ_BOWSER_LAUGH, gMarioStates[0].marioObj.header.gfx.cameraToObject)
        gGlobalSyncTable.roundTimer = gGlobalSyncTable.roundTimer - gGlobalSyncTable.roundTimerMax * 0.1
        --network_send_include_self(true, {id = PACKET_CHANGE_TIME, param = gGlobalSyncTable.roundTimerMax * 0.1})
        ps[m.playerIndex].team = TEAM_SEEKERS
        ps[m.playerIndex].isUsingFreeCam = false
        set_mario_action(m, m.prevAction, 0)
        camera_unfreeze()
    end

    if o.oHeldState == 1 then
        local m2 = gMarioStates[network_local_index_from_global(o.oHeldBy)]
        cur_obj_disable_rendering()
        cur_obj_become_intangible()
        --local hands = m2.marioBodyState.grabPos
        o.oPosX, o.oPosY, o.oPosZ = m2.pos.x, m2.pos.y, m2.pos.z
        m.pos.x, m.pos.y, m.pos.z = m2.pos.x, m2.pos.y, m2.pos.z
        o.oMoveAngleYaw = m2.faceAngle.y
        m.faceAngle.y = o.oMoveAngleYaw
    elseif o.oHeldState >= 2 then
        cur_obj_become_tangible()
        cur_obj_enable_rendering_2()
        cur_obj_enable_rendering()
        o.header.gfx.node.flags = o.header.gfx.node.flags & ~GRAPH_RENDER_INVISIBLE
        o.oHeldState = 0
        o.oFlags = o.oFlags & ~0x08
        m.forwardVel = 40.0
        m.vel.y = 20.0
        o.oBreakableBoxSmallFramesSinceReleased = 0
        o.oBreakableBoxSmallReleased = 1
        o.activeFlags = o.activeFlags & ~ACTIVE_FLAG_UNK9
        m.pos.x, m.pos.y, m.pos.z = o.oPosX, o.oPosY, o.oPosZ
        network_send_object(o, true)

        if o.oPosY <= o.oFloorHeight then
            o.oHeldState = 0
            o.oBreakableBoxSmallReleased = 0
        end
    end
end

local function fake_baby_penguin(o, m)
    if ps[m.playerIndex].curAnimIndex <= 0 then
        play_penguin_walking_sound(0)
    end
end

categoryNames = {"Environment", "Collectibles", "Bosses", "Enemies", "Friendly"}

sFakeObjectInfo = {
    [CATE_ENVIRONMENT] = {
        models = {
            E_MODEL_BUBBLY_TREE,
            E_MODEL_COURTYARD_SPIKY_TREE,
            E_MODEL_SNOW_TREE,
            E_MODEL_PALM_TREE,
            E_MODEL_BLUE_COIN_SWITCH,
            E_MODEL_WOODEN_SIGNPOST,
            E_MODEL_EXCLAMATION_BOX,
            E_MODEL_EXCLAMATION_BOX,
            E_MODEL_EXCLAMATION_BOX,
            E_MODEL_EXCLAMATION_BOX,
            E_MODEL_BREAKABLE_BOX,
            E_MODEL_BREAKABLE_BOX_SMALL,
            E_MODEL_HEART,
            E_MODEL_WOODEN_POST,
            E_MODEL_SEAWEED,
            E_MODEL_METAL_BOX,
            E_MODEL_PURPLE_SWITCH,
        },
        modelNames = {
            "Bubbly Tree",
            "Spiky Tree",
            "Snowy Tree",
            "Palm Tree",
            "Blue Coin Switch",
            "Wooden Signpost",
            "Exclamation Box (Yellow)",
            "Exclamation Box (Red)",
            "Exclamation Box (Green)",
            "Exclamation Box (Blue)",
            "Breakable box (Big)",
            "Breakable box (Small)",
            "Recovery heart",
            "Wooden Post",
            "Seaweed",
            "Metal Box",
            "Purple Switch",
        },
        miscObjInfo = {
            {modelInfo = MODEL_BILLBOARDED, loopFunc = function (o, m) if m.playerIndex ~= 0 then bhv_pole_base_loop() end end, interactions = {int = INTERACT_POLE, radius = 80, height = 500}},
            {modelInfo = MODEL_BILLBOARDED, loopFunc = function (o, m) if m.playerIndex ~= 0 then bhv_pole_base_loop() end end, interactions = {int = INTERACT_POLE, radius = 80, height = 500}},
            {modelInfo = MODEL_BILLBOARDED, loopFunc = function (o, m) if m.playerIndex ~= 0 then bhv_pole_base_loop() end end, interactions = {int = INTERACT_POLE, radius = 80, height = 500}},
            {modelInfo = MODEL_BILLBOARDED, loopFunc = function (o, m) if m.playerIndex ~= 0 then bhv_pole_base_loop() end end, interactions = {int = INTERACT_POLE, radius = 80, height = 500}},
            {modelInfo = 0, scale = {x=3,y=3,z=3}, collision = gGlobalObjectCollisionData.blue_coin_switch_seg8_collision_08000E98},
            {modelInfo = 0, loopFunc = function (o) o.oBehParams2ndByte = math.random(DIALOG_000, DIALOG_160) end, interactions = {int = INTERACT_TEXT, intSub = INT_SUBTYPE_SIGN, radius = 150, height = 80}, collision = gGlobalObjectCollisionData.wooden_signpost_seg3_collision_0302DD80},
            {modelInfo = 0, minYOffset = 0, maxYOffset = 300, scale = {x=2,y=2,z=2}, loopFunc = function (o) o.oAnimState = 3 end},
            {modelInfo = 0, minYOffset = 0, maxYOffset = 300, scale = {x=2,y=2,z=2}, loopFunc = function (o) o.oAnimState = 0 end},
            {modelInfo = 0, minYOffset = 0, maxYOffset = 300, scale = {x=2,y=2,z=2}, loopFunc = function (o) o.oAnimState = 1 end},
            {modelInfo = 0, minYOffset = 0, maxYOffset = 300, scale = {x=2,y=2,z=2}, loopFunc = function (o) o.oAnimState = 2 end},
            {modelInfo = 0, loopFunc = function (o) o.oAnimState = 1 end, collision = gGlobalObjectCollisionData.breakable_box_seg8_collision_08012D70, interactions = {int = INTERACT_BREAKABLE, radius = 150, height = 200}},
            {modelInfo = 0, cantBeHit = false, loopFunc = function (o, m) o.oAnimState = 1 end , scale = {x=0.4,y=0.4,z=0.4}, interactions = {int = INTERACT_GRABBABLE, radius = 150, height = 250}},
            {modelInfo = MODEL_DONT_FOLLOW_YAW, minYOffset = 0, maxYOffset = 120, loopFunc = function(o) o.oMoveAngleYaw = o.oMoveAngleYaw + 400 end },
            {modelInfo = 0, scale = {x=0.5,y=0.5,z=0.5}, collision = gGlobalObjectCollisionData.poundable_pole_collision_06002490},
            {modelInfo = 0, animations = gObjectAnimations.seaweed_seg6_anims_0600A4D4, maxAnims = 1 },
            {modelInfo = 0, collision = gGlobalObjectCollisionData.metal_box_seg8_collision_08024C28, interactions = {int = INTERACT_BREAKABLE, radius = 220, height = 300}},
            {modelInfo = 0, scale = {x=1.5,y=1.5,z=1.5}, collision = gGlobalObjectCollisionData.purple_switch_seg8_collision_0800C7A8},
        }
    },
    [CATE_COLLECTIBLES] = {
        models = {
            E_MODEL_STAR,
            E_MODEL_TRANSPARENT_STAR,
            E_MODEL_1UP,
            E_MODEL_RED_COIN,
            E_MODEL_RED_COIN_NO_SHADOW,
            E_MODEL_YELLOW_COIN,
        },
        modelNames = {
            "Star (Yellow)",
            "Star (Transparent)",
            "1up",
            "Red Coin",
            "Red Coin (No Shadow)",
            "Yellow Coin",
        },
        miscObjInfo = {
            { modelInfo = MODEL_DONT_FOLLOW_YAW, minYOffset = 0, maxYOffset = 350, loopFunc = function(o) o.oMoveAngleYaw = o.oMoveAngleYaw + 0x800 end },
            { modelInfo = MODEL_DONT_FOLLOW_YAW, minYOffset = 0, maxYOffset = 350, loopFunc = function(o) o.oMoveAngleYaw = o.oMoveAngleYaw + 0x800 end },
            { minYOffset = 0, maxYOffset = 150, modelInfo = MODEL_BILLBOARDED },
            { minYOffset = 0, maxYOffset = 120, loopFunc = function (o) o.oAnimState = o.oAnimState + 1 end, modelInfo = MODEL_BILLBOARDED },
            { minYOffset = 0, maxYOffset = 120, loopFunc = function (o) o.oAnimState = o.oAnimState + 1 end, modelInfo = MODEL_BILLBOARDED },
            { minYOffset = 0, maxYOffset = 120, loopFunc = function (o) o.oAnimState = o.oAnimState - 1 if o.oAnimState < 0 then o.oAnimState = 6 end end, modelInfo = MODEL_BILLBOARDED },
        }
    },
    [CATE_BOSSES] = {
        models = {
            E_MODEL_KING_BOBOMB,
            E_MODEL_WHOMP, E_MODEL_BOO,
            E_MODEL_EYEROK_LEFT_HAND,
            E_MODEL_EYEROK_RIGHT_HAND,
            E_MODEL_BULLY_BOSS,
            E_MODEL_BOWSER
        },
        modelNames = {
            "King Bob omb",
            "King Whomp",
            "Big Boo",
            "Eyerok (left)",
            "Eyerok (right)",
            "Bully",
            "Browser"
        },
        miscObjInfo = {
            { modelInfo = 0, animations = gObjectAnimations.king_bobomb_seg5_anims_0500FE30, maxAnims = 11 },
            { modelInfo = 0, scale = {x=2,y=2,z=2}, animations = gObjectAnimations.whomp_seg6_anims_06020A04, maxAnims = 1 },
            { modelInfo = 0, scale = {x=2,y=2,z=2}, minYOffset = 0, maxYOffset = 300},
            { modelInfo = 0, scale = {x=-1,y=1,z=1}, animations = gObjectAnimations.eyerok_seg5_anims_050116E4,      maxAnims = 7 },
            { modelInfo = 0, scale = {x=1,y=1,z=1}, animations = gObjectAnimations.eyerok_seg5_anims_050116E4,      maxAnims = 7 },
            { modelInfo = 0, animations = gObjectAnimations.bully_seg5_anims_0500470C,       maxAnims = 3 },
            { modelInfo = 0, animations = gObjectAnimations.bowser_seg6_anims_06057690,      maxAnims = 26 },
        }
    },
    [CATE_ENEMIES] = {
        models = {
            E_MODEL_GOOMBA,
            E_MODEL_GOOMBA,
            E_MODEL_BLACK_BOBOMB,
            E_MODEL_SCUTTLEBUG,
            E_MODEL_KOOPA_WITHOUT_SHELL,
            E_MODEL_KOOPA_WITH_SHELL,
            E_MODEL_BULLY,
            E_MODEL_WHOMP,
            E_MODEL_MONEYBAG,
            E_MODEL_MONTY_MOLE,
            E_MODEL_CHUCKYA,
            E_MODEL_HEAVE_HO,
            E_MODEL_SPINDRIFT,
            E_MODEL_CLAM_SHELL,
            E_MODEL_BOWLING_BALL,
            E_MODEL_SKEETER,
            E_MODEL_PIRANHA_PLANT,
        },
        modelNames = {
            "Goomba",
            "Goomba (Big)",
            "Black bobomb",
            "Scuttlebug",
            "Koopa (no shell)",
            "Koopa",
            "Bully",
            "Whomp",
            "Moneybag",
            "Monty mole",
            "Chuckya",
            "Heave-ho",
            "Spindrift",
            "Clam",
            "Fire Chomp",
            "Skeeter",
            "Piranha Plant",
        },
        miscObjInfo = {
            { modelInfo = 0, scale = { x = 1.5, y = 1.5, z = 1.5 },                            animations = gObjectAnimations.goomba_seg8_anims_0801DA4C,     maxAnims = 0 },
            { modelInfo = 0, scale = { x = 3, y = 3, z = 3 },                                  animations = gObjectAnimations.goomba_seg8_anims_0801DA4C,     maxAnims = 0 },
            { modelInfo = 0, animations = gObjectAnimations.bobomb_seg8_anims_0802396C,        maxAnims = 0 },
            { modelInfo = 0, animations = gObjectAnimations.scuttlebug_seg6_anims_06015064,    maxAnims = 0 },
            { modelInfo = 0, animations = gObjectAnimations.koopa_seg6_anims_06011364,         maxAnims = 13 },
            { modelInfo = 0, animations = gObjectAnimations.koopa_seg6_anims_06011364,         maxAnims = 13 },
            { modelInfo = 0, animations = gObjectAnimations.bully_seg5_anims_0500470C,         maxAnims = 3 },
            { modelInfo = 0, animations = gObjectAnimations.whomp_seg6_anims_06020A04,         maxAnims = 1 },
            { modelInfo = 0, animations = gObjectAnimations.moneybag_seg6_anims_06005E5C,      maxAnims = 4 },
            { modelInfo = 0, scale = { x = 1.5, y = 1.5, z = 1.5 },                                                      animations = gObjectAnimations.monty_mole_seg5_anims_05007248, maxAnims = 9 },
            { modelInfo = 0, scale = { x = 2, y = 2, z = 2 },                                  animations = gObjectAnimations.chuckya_seg8_anims_0800C070,    maxAnims = 5 },
            { modelInfo = 0, scale = { x = 2, y = 2, z = 2 },                                  animations = gObjectAnimations.heave_ho_seg5_anims_0501534C,   maxAnims = 2 },
            { modelInfo = 0, animations = gObjectAnimations.spindrift_seg5_anims_05002D68,     maxAnims = 0 },
            { modelInfo = 0, scale = { x = 1, y = 1.5, z = 1 },                                animations = gObjectAnimations.clam_shell_seg5_anims_05001744, maxAnims = 1 },
            { modelInfo = MODEL_BILLBOARDED, scale = { x = 0.2, y = 0.2, z = 0.2},             minYOffset = 0, maxYOffset = 150,},
            { modelInfo = 0, animations = gObjectAnimations.skeeter_seg6_anims_06007DE0,       maxAnims = 3 },
            { modelInfo = 0, animations = gObjectAnimations.piranha_plant_seg6_anims_0601C31C, maxAnims = 10},
        }
    },
    [CATE_FRIENDLY] = {
        models = {
            --E_MODEL_TOAD,
            E_MODEL_BOBOMB_BUDDY,
            E_MODEL_PENGUIN,
            E_MODEL_PENGUIN,
            E_MODEL_KOOPA_WITH_SHELL,
        },
        modelNames = {
            --"Toad",
            "Bobomb Buddy",
            "Penguin (Big)",
            "Penguin (Baby)",
            "Koopa The Quick",
        },
        miscObjInfo = {
            --{ modelInfo = 0, animations = gObjectAnimations.toad_seg6_anims_0600FB58,    maxAnims = 7 },
            { modelInfo = 0, animations = gObjectAnimations.bobomb_seg8_anims_0802396C,  maxAnims = 1, loopFunc = fake_bobomb_buddy, interactions = {int = INTERACT_TEXT, intSub = INT_SUBTYPE_SIGN, radius = 100, height = 60}},
            { modelInfo = 0, scale = { x = 3.55, y = 3.55, z = 3.55 },                   animations = gObjectAnimations.penguin_seg5_anims_05008B74, maxAnims = 4 },
            { modelInfo = 0, animations = gObjectAnimations.penguin_seg5_anims_05008B74, maxAnims = 4, loopFunc = fake_baby_penguin},
            { modelInfo = 0, scale = { x = 3, y = 3, z = 3 },                            animations = gObjectAnimations.koopa_seg6_anims_06011364,   maxAnims = 13 },
        }
    },
}

local menuOptions = {
    {
        name = function (localOwner) return "Category : "..categoryNames[ps[localOwner].selectedCategory + 1] end,
        funcRight = function(localOwner)
            ps[localOwner].selectedModelIndex = 1
            ps[localOwner].selectedCategory = (ps[localOwner].selectedCategory + 1) % #categoryNames
        end,
        funcLeft = function(localOwner)
            ps[localOwner].selectedModelIndex = 1
            ps[localOwner].selectedCategory = (ps[localOwner].selectedCategory - 1 + #categoryNames) % #categoryNames
        end,
    },
    {
        name = function (localOwner) return "Model : "..sFakeObjectInfo[ps[localOwner].selectedCategory].modelNames[ps[localOwner].selectedModelIndex] end,
        funcRight = function(localOwner)
            ps[localOwner].selectedModelIndex = (ps[localOwner].selectedModelIndex % #sFakeObjectInfo[ps[localOwner].selectedCategory].models) + 1
        end,
        funcLeft = function(localOwner)
            ps[localOwner].selectedModelIndex = (ps[localOwner].selectedModelIndex - 2 + #sFakeObjectInfo[ps[localOwner].selectedCategory].models) % #sFakeObjectInfo[ps[localOwner].selectedCategory].models + 1
        end,
    },
    {
        name = function () return "Random Model" end,
        funcSelect = function(localOwner)
            local categories = {}
            for category in pairs(sFakeObjectInfo) do
                table.insert(categories, category)
            end
            local randomCategory = categories[math.random(#categories)]
            local models = sFakeObjectInfo[randomCategory].models
            local randomModelIndex = math.random(#models)

            ps[localOwner].selectedCategory = randomCategory
            ps[localOwner].selectedModelIndex = randomModelIndex
            ps[localOwner].model = models[randomModelIndex]

            local miscInfo = sFakeObjectInfo[randomCategory].miscObjInfo[randomModelIndex]
            ps[localOwner].modelInfo = miscInfo and miscInfo.modelInfo or 0
            ps[localOwner].validatedProp = true

            play_sound(SOUND_MENU_CLICK_FILE_SELECT, gGlobalSoundSource)
        end,
    }
}

local function obj_mark_for_deletion_on_sync(o)
    if npl[0].currAreaSyncValid then obj_mark_for_deletion(o) end
end

local function count_owned_object(bhv, index)
    local count = 0
    local o = obj_get_first_with_behavior_id(bhv)
    while o ~= nil do
        if o.oFakeObjOwner == index then
            count = count + 1
        end
        o = obj_get_next_with_same_behavior_id(o)
    end
    return count
end

function setup_stun_obj(o, owner)
    o.oFakeObjOwner = owner
    local localOwner = network_player_from_global_index(owner).localIndex

    local m = gMarioStates[localOwner]

    if ps[localOwner].team ~= TEAM_HIDERS then obj_mark_for_deletion_on_sync(o) end

    local category = o.oOldSelectedCategory
    local modelIndex = o.oOldSelectedModelIndex

    o.header.gfx.node.flags = o.header.gfx.node.flags & ~GRAPH_RENDER_BILLBOARD
    o.oAnimState = 0
    o.header.gfx.animInfo.animFrame = 0
    o.oFaceAngleRoll = 0
    o.oFaceAnglePitch = 0
    o.oAction = 0
    o.oHeldState = 0
    o.oBreakableBoxSmallReleased = 0

    local selectedModel = sFakeObjectInfo[category].models[modelIndex]
    obj_set_model_extended(o, selectedModel)

    local miscInfo = sFakeObjectInfo[category].miscObjInfo[modelIndex]
    if miscInfo then
        local scale = miscInfo.scale
        local animations = miscInfo.animations
        if animations then
            o.oAnimations = animations
        else
            o.oAnimations = gObjectAnimations.goomba_seg8_anims_0801DA4C
        end

        if scale and scale.x and scale.y and scale.z then
            obj_scale_xyz(o, scale.x, scale.y, scale.z)
        else
            obj_scale(o, 1)
        end
        local hitbox = get_temp_object_hitbox()
        local selectedInteractions = miscInfo.interactions
        if selectedInteractions then
            local interaction = selectedInteractions.int
            local subInteraction = selectedInteractions.intSub
            local radius = selectedInteractions.radius
            local height = selectedInteractions.height
        
            hitbox.interactType = interaction or 0
            o.oInteractType = interaction or 0

            hitbox.radius = radius or 0
            hitbox.height = height or 0

            o.oInteractionSubtype = subInteraction or 0
        else
            hitbox.interactType = 0
        end
        obj_set_hitbox(o, hitbox)
        local selectedCollision = miscInfo.collision
        if m.playerIndex ~= 0 and selectedCollision then
            o.collisionData = selectedCollision
        else
            o.collisionData = nil
        end 
        local unHittable = miscInfo.cantBeHit
        if unHittable then
            o.oUnHittable = 1
        else
            o.oUnHittable = 0
        end 
    else
        obj_scale(o, 1)
        o.oAnimations = gObjectAnimations.goomba_seg8_anims_0801DA4C
    end

    network_send_object(o, true)
end

function setup_fake_obj(o, owner, resetAnimIndex)
    o.oFakeObjOwner = owner
    local localOwner = network_player_from_global_index(owner).localIndex

    local m = gMarioStates[localOwner]

    if ps[localOwner].team ~= TEAM_HIDERS and m.playerIndex == 0 then
        soft_reset_camera(m.area.camera)
        camera_unfreeze()
        ps[localOwner].frozen = false
        obj_mark_for_deletion_on_sync(o)
    end

    if ps[localOwner].validatedProp then

        ps[localOwner].modelInfo = 0
        o.header.gfx.node.flags = o.header.gfx.node.flags & ~GRAPH_RENDER_BILLBOARD
        o.oAnimState = 0
        o.header.gfx.animInfo.animFrame = 0
        o.oFaceAngleRoll = 0
        o.oFaceAnglePitch = 0
        o.oAction = 0
        o.oHeldState = 0
        o.oBreakableBoxSmallReleased = 0

        if resetAnimIndex then
            ps[localOwner].curAnimIndex = 0
        end

        local selectedModel = sFakeObjectInfo[ps[localOwner].selectedCategory].models[ps[localOwner].selectedModelIndex]

        obj_set_model_extended(o, selectedModel)
        --djui_chat_message_create("current model for local player " .. localOwner .. " is " .. selectedModel)

        local miscInfo = sFakeObjectInfo[ps[localOwner].selectedCategory].miscObjInfo[ps[localOwner].selectedModelIndex]

        if miscInfo then
            local scale = miscInfo.scale
            local animations = miscInfo.animations
            if animations then
                o.oAnimations = animations
            else
                o.oAnimations = gObjectAnimations.goomba_seg8_anims_0801DA4C
            end
            local func = miscInfo.initFunc
            if func then
                func(o)
            end

            local selectedModelInfo = miscInfo.modelInfo
            ps[localOwner].model = selectedModel
            if selectedModelInfo then
                ps[localOwner].modelInfo = selectedModelInfo
            end
            if scale and scale.x and scale.y and scale.z then
                obj_scale_xyz(o, scale.x, scale.y, scale.z)
            else
                obj_scale(o, 1)
            end

            local hitbox = get_temp_object_hitbox()

            local selectedInteractions = miscInfo.interactions

            if selectedInteractions then
                local interaction = selectedInteractions.int
                local subInteraction = selectedInteractions.intSub
                local radius = selectedInteractions.radius
                local height = selectedInteractions.height
            
                hitbox.interactType = interaction or 0
                o.oInteractType = interaction or 0
                
                hitbox.radius = radius or 0
                hitbox.height = height or 0
                
                o.oInteractionSubtype = subInteraction or 0
            else
                hitbox.interactType = 0
            end

            obj_set_hitbox(o, hitbox)

            local selectedCollision = miscInfo.collision

            if m.playerIndex ~= 0 and selectedCollision then
                o.collisionData = selectedCollision
            else
                o.collisionData = nil
            end

            local unHittable = miscInfo.cantBeHit

            if unHittable then
                o.oUnHittable = 1
            else
                o.oUnHittable = 0
            end

        else
            o.oAnimations = gObjectAnimations.goomba_seg8_anims_0801DA4C
            obj_scale(o, 1)
        end
    end

    network_send_object(o, true)
end

local cooldown = 5
local cooldownCounter = 0

local function menu_controls(m, o)
    if not propMenu or m.playerIndex ~= 0 or gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT == 0 or gGlobalSyncTable.gameState ~= GAME_STATE_ACTIVE then
        return
    end

    local localOwner = network_player_from_global_index(o.oFakeObjOwner).localIndex
    local stickY = m.controller.stickY
    local stickX = m.controller.stickX
    local right = m.controller.buttonDown & R_JPAD ~= 0
    local left = m.controller.buttonDown & L_JPAD ~= 0
    local up = m.controller.buttonDown & U_JPAD ~= 0
    local down = m.controller.buttonDown & D_JPAD ~= 0

    m.freeze = 1

    -- Cooldown logic
    if cooldownCounter > 0 then
        cooldownCounter = cooldownCounter - 1
        return
    end

    -- Navigate menu
    if stickY > 60 or up then
        selectedOption = selectedOption - 1
        if selectedOption < 1 then
            selectedOption = #menuOptions
        end
        play_sound(SOUND_MENU_CHANGE_SELECT, gGlobalSoundSource)
        cooldownCounter = cooldown
    elseif stickY < -60 or down then
        selectedOption = selectedOption + 1
        if selectedOption > #menuOptions then
            selectedOption = 1
        end
        play_sound(SOUND_MENU_CHANGE_SELECT, gGlobalSoundSource)
        cooldownCounter = cooldown
    elseif stickX > 0.5 or right then
        if menuOptions[selectedOption].funcRight then
            menuOptions[selectedOption].funcRight(localOwner)
        end
        play_sound(SOUND_MENU_CHANGE_SELECT, gGlobalSoundSource)
        cooldownCounter = cooldown
    elseif stickX < -0.5 or left then
        if menuOptions[selectedOption].funcLeft then
            menuOptions[selectedOption].funcLeft(localOwner)
        end
        play_sound(SOUND_MENU_CHANGE_SELECT, gGlobalSoundSource)
        cooldownCounter = cooldown
    elseif m.controller.buttonPressed & A_BUTTON ~= 0 then
        if menuOptions[selectedOption].funcSelect then
            menuOptions[selectedOption].funcSelect(localOwner)
        else
            ps[localOwner].validatedProp = true
            local miscInfo = sFakeObjectInfo[ps[localOwner].selectedCategory].miscObjInfo[ps[localOwner].selectedModelIndex]
            ps[localOwner].model = sFakeObjectInfo[ps[localOwner].selectedCategory].models[ps[localOwner].selectedModelIndex]
            ps[localOwner].modelInfo = miscInfo and miscInfo.modelInfo or 0
            play_sound(SOUND_MENU_CLICK_FILE_SELECT, gGlobalSoundSource)
            propMenu = false
        end
        setup_fake_obj(o, o.oFakeObjOwner, true)
        network_send(true, {id = PACKET_SETUP_PROP, owner = o.oFakeObjOwner})
        network_send_object(o, true)
    elseif m.controller.buttonPressed & B_BUTTON ~= 0 or is_game_paused() then
        ps[localOwner].validatedProp = true
        local miscInfo = sFakeObjectInfo[ps[localOwner].selectedCategory].miscObjInfo[ps[localOwner].selectedModelIndex]
        ps[localOwner].model = sFakeObjectInfo[ps[localOwner].selectedCategory].models[ps[localOwner].selectedModelIndex]
        ps[localOwner].modelInfo = miscInfo and miscInfo.modelInfo or 0
        play_sound(SOUND_MENU_CLICK_FILE_SELECT, gGlobalSoundSource)
        propMenu = false
    else
        ps[localOwner].validatedProp = false
    end
end

local hud_text_elements = {
    function () return get_button_combination_string(FREEZE_BUTTON) .. " = Freeze" end,
    function () return get_button_combination_string(PROP_BUTTON) .. " = Open model selector" end,
    function () return get_button_combination_string(ANIM_RIGHT_BUTTON) .. " & " .. get_button_combination_string(ANIM_LEFT_BUTTON) .. " = Animations" end,
    function () return get_button_combination_string(VERT_UP_BUTTON) .. " = Vertical Offset" end,
    function () return get_button_combination_string(FAKE_PROP_BUTTON) .. " Button = Spawn Fake Prop" end,
}

local function hud_render()

    if gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT == 0 or ps[0].team ~= TEAM_HIDERS or gGlobalSyncTable.gameState ~= GAME_STATE_ACTIVE then return end

    djui_hud_set_resolution(RESOLUTION_N64)

    local sWidth = djui_hud_get_screen_width()
    local sHeight = djui_hud_get_screen_height()

    if not is_game_paused() then

        local num_elements = #hud_text_elements
        local element_height = 10
        local rect_height = num_elements * element_height + 10

        djui_hud_set_color(0, 0, 60, 130)
        djui_hud_render_rect(0, sHeight - rect_height, 80, rect_height)

        for i, text_func in ipairs(hud_text_elements) do
            local offsetY = sHeight - (i * element_height + 5)
            local text = text_func()
            djui_hud_print_text_with_shadow(
                text, 2, offsetY, 0.5, 0.25,
                {r = 0, g = 0, b = 0, a = 255}, {r = 255, g = 255, b = 255, a = 255}
            )
        end
    end

    djui_hud_set_font(FONT_NORMAL)

    if not propMenu then return end

    local titleX = (sWidth * 0.5) - (djui_hud_measure_text(menuTitle) * 0.5)
    local titleY = sHeight - 200

    djui_hud_set_color(0, 0, 60, 130)
    djui_hud_render_rect(0, 0, sWidth + 20, sHeight)
    djui_hud_set_color(255, 255, 255, 255)

    djui_hud_print_text_with_shadow(menuTitle, titleX, titleY, 2, 1, {r = 0, g = 0, b = 0, a = 120}, {r = 255, g = 255, b = 255, a = 255})

    for i, option in ipairs(menuOptions) do
        local optionText = option.name(0)
        local optionX = (sWidth * 0.5) - (djui_hud_measure_text(optionText) * 0.5)
        djui_hud_print_text_with_shadow(optionText, optionX, titleY + 40 * i, 2, 1, {r = 0, g = 0, b = 0, a = 120}, {r = 255, g = 255, b = 255, a = 255})

        if selectedOption == i then
            djui_hud_print_text_with_shadow(">", optionX - 20, titleY + 40 * i, 2, 1, {r = 0, g = 0, b = 0, a = 120}, {r = 255, g = 255, b = 255, a = 255})
        end
    end
end

define_custom_obj_fields({
    oFakeObjOwner = 'u32',
    oHeldBy = 'u32',
    oUnHittable = 'u32',
    oOldModel = "u32",
    oOldCurAnimIndex = "u32",
    oOldModelInfo = "u32",
    oOldSelectedCategory = "u32",
    oOldSelectedModelIndex = "u32"
})

---@param o Object
local function fake_obj_init(o)
    o.oFlags = OBJ_FLAG_HOLDABLE | OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE | OBJ_FLAG_ACTIVE_FROM_AFAR | OBJ_FLAG_COMPUTE_ANGLE_TO_MARIO | OBJ_FLAG_SET_FACE_YAW_TO_MOVE_YAW
    o.oOpacity = 255
    o.oHealth = 1
    setup_fake_obj(o, o.oFakeObjOwner, false)
    network_send(true, {id = PACKET_SETUP_PROP, owner = o.oFakeObjOwner})
    o.globalPlayerIndex = o.oFakeObjOwner
    network_init_object(o, true, { "oFakeObjOwner", "oAnimState", "oHealth", "oPosY", "oPosX", "oPosZ", "globalPlayerIndex"})
end

local sDamageActions = {
    [ACT_JUMP_KICK] = true,
    [ACT_DIVE] = true,
    [ACT_GROUND_POUND] = true,
    [ACT_SLIDE_KICK] = true,
    [ACT_BUTT_SLIDE] = true,
    [ACT_DIVE_SLIDE] = true,
    [ACT_HOLD_BUTT_SLIDE] = true,
    [ACT_HOLD_STOMACH_SLIDE] = true,
    [ACT_STOMACH_SLIDE] = true,
    [ACT_PUNCHING] = true,
    [ACT_MOVE_PUNCHING] = true,
    [ACT_RIDING_SHELL_FALL] = true,
    [ACT_RIDING_SHELL_GROUND] = true,
    [ACT_RIDING_SHELL_JUMP] = true,
    [ACT_TWIRLING] = true,
    [ACT_FLYING] = true,
    [ACT_WATER_PUNCH] = true,
}

---@param o Object
local function fake_obj_loop(o)
    local np = network_player_from_global_index(o.oFakeObjOwner)

    cur_obj_update_floor_and_walls()

    if np == nil then
        obj_mark_for_deletion_on_sync(o)
        return
    end

    local localID = np.localIndex
    local m = gMarioStates[localID]

    local seeker = nearest_team_to_object(TEAM_SEEKERS, o)

    if seeker and o.oUnHittable <= 0 and ((dist_between_objects(o, seeker.marioObj) <= 130 and sDamageActions[seeker.action]) or cur_obj_is_mario_ground_pounding_platform() ~= 0) then
        play_sound(SOUND_OBJ_BOWSER_LAUGH, gGlobalSoundSource)

        notify_caught_player(localID)

        gGlobalSyncTable.roundTimer = gGlobalSyncTable.roundTimer - gGlobalSyncTable.roundTimerMax * 0.1
        --network_send_include_self(true, {id = PACKET_CHANGE_TIME, param = gGlobalSyncTable.roundTimerMax * 0.1})
        ps[localID].team = TEAM_SEEKERS
        ps[localID].isUsingFreeCam = false
        set_mario_action(m, m.prevAction, 0)
        camera_unfreeze()
        if ps[seeker.playerIndex].isSkeltan then
            ps[localID].skeltanJumpscareTimer = 1
        end
        set_room_override(-1)

        ps[localID].time =  gGlobalSyncTable.roundTimerMax -gGlobalSyncTable.roundTimer
    end

    if not active_player(m, np) or ps[localID].team ~= TEAM_HIDERS then
        if ps[localID].team ~= TEAM_HIDERS and m.playerIndex == 0 then
            soft_reset_camera(m.area.camera)
            camera_unfreeze()
            set_room_override(-1)
        end
        ps[localID].frozen = false
        ps[localID].isUsingFreeCam = false
        obj_mark_for_deletion_on_sync(o)
        return
    end

    if m.playerIndex == 0 then
        if o.oHeldState > 0 and propMenu then
            propMenu = false
            ps[localID].validatedProp = true
            play_sound(SOUND_GENERAL_PAINTING_EJECT, gGlobalSoundSource)
            djui_chat_message_create("Can't do that while grabbed!")
        else
            menu_controls(m, o)
        end
    end

    obj_set_model_extended(o, ps[localID].model)

    local miscInfo = sFakeObjectInfo[ps[localID].selectedCategory].miscObjInfo[ps[localID].selectedModelIndex]

    if miscInfo and ps[localID].validatedProp then
        local maxAnims = miscInfo.maxAnims
        if maxAnims then
            cur_obj_init_animation_with_sound(ps[localID].curAnimIndex)
        end
        local maxYOffset = miscInfo.maxYOffset
        local minYOffset = miscInfo.minYOffset

        if minYOffset and maxYOffset then
            if ps[localID].posYOffset > maxYOffset then
                ps[localID].posYOffset = maxYOffset
            elseif ps[localID].posYOffset < minYOffset then
                ps[localID].posYOffset = minYOffset
            end

            if not propMenu or is_game_paused() then
                if m.controller.buttonDown & VERT_UP_BUTTON ~= 0 then
                    ps[localID].posYOffset = ps[localID].posYOffset + 5
                elseif m.controller.buttonDown & VERT_DOWN_BUTTON ~= 0 then
                    ps[localID].posYOffset = ps[localID].posYOffset - 5
                end
            end
        elseif not minYOffset then
            ps[localID].posYOffset = 0
            ps[localID].posYOffset = 0
        end
        local func = miscInfo.loopFunc
        if func then
            func(o, m)
        end
        local animations = miscInfo.animations
        if not animations then
            o.header.gfx.animInfo.animFrame = 0
        end
    else
        o.header.gfx.animInfo.animFrame = 0
    end

    if ps[localID].modelInfo & MODEL_BILLBOARDED ~= 0 then
        o.header.gfx.node.flags = o.header.gfx.node.flags | GRAPH_RENDER_BILLBOARD
    else
        o.header.gfx.node.flags = o.header.gfx.node.flags & ~GRAPH_RENDER_BILLBOARD
    end

    local posY = m.pos.y + ps[localID].posYOffset

    if posY > m.ceilHeight - 130 then
        posY = m.ceilHeight - 130
    end

    if not ps[localID].frozen then
        o.oPosY = posY
    end

    if ps[localID].frozen and o.oHeldState > 0 then
        ps[localID].frozen = false
        set_mario_action(m, m.prevAction, 0)
    end

    if m.controller.buttonPressed & FAKE_PROP_BUTTON ~= 0 and count_owned_object(id_bhvStunObj, o.oFakeObjOwner) < 1 and (not propMenu or is_game_paused()) and m.playerIndex == 0 then
        spawn_sync_object(id_bhvStunObj, 0, o.oPosX, o.oPosY, o.oPosZ, function (f)
            f.oFakeObjOwner = o.oFakeObjOwner
            f.oOldModel = ps[localID].model
            f.oOldCurAnimIndex = ps[localID].curAnimIndex
            f.oOldModelInfo = ps[localID].modelInfo
            f.oOldSelectedCategory = ps[localID].selectedCategory
            f.oOldSelectedModelIndex = ps[localID].selectedModelIndex
            setup_stun_obj(f, npl[localID].globalIndex, false)
            network_send(true, {id = PACKET_SETUP_STUN, owner = f.oFakeObjOwner})
        end)
    end

    if not ps[localID].frozen then
        if o.oHeldState <= 0 then
            o.oPosX = m.pos.x
            o.oPosZ = m.pos.z
            if ps[localID].modelInfo & MODEL_DONT_FOLLOW_YAW == 0 and ps[localID].validatedProp then
                o.oFaceAngleYaw = m.faceAngle.y
                o.oMoveAngleYaw = m.faceAngle.y
            end
        end

    elseif ps[localID].frozen and ps[localID].validatedProp and o.collisionData then
        load_object_collision_model()
        m.pos.x = o.oPosX
        m.pos.y = o.oPosY
        m.pos.z = o.oPosZ
    end

    o.oInteractStatus = 0
end

id_bhvFakeObj = hook_behavior(nil, OBJ_LIST_SURFACE, true, fake_obj_init, fake_obj_loop, "bhvFakeObj")

---@param o Object
local function stun_obj_init(o)
    o.oFlags = OBJ_FLAG_HOLDABLE | OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE | OBJ_FLAG_ACTIVE_FROM_AFAR | OBJ_FLAG_COMPUTE_ANGLE_TO_MARIO | OBJ_FLAG_SET_FACE_YAW_TO_MOVE_YAW
    o.oOpacity = 255
    o.oHealth = 1
    setup_stun_obj(o, o.oFakeObjOwner, false)
    network_send(true, {id = PACKET_SETUP_STUN, owner = o.oFakeObjOwner})
    network_init_object(o, true, {
        "oFakeObjOwner",
        "oAnimState",
        "oHealth",
        "oPosY",
        "oPosX",
        "oPosZ",
        "oOldModel",
        "oOldCurAnimIndex",
        "oOldModelInfo",
        "oOldSelectedCategory",
        "oOldSelectedModelIndex"
    })
end

local function stun_obj_loop(o)
    local np = network_player_from_global_index(o.oFakeObjOwner)

    cur_obj_update_floor_and_walls()

    if np == nil then
        obj_mark_for_deletion_on_sync(o)
        return
    end

    local localID = np.localIndex
    local m = gMarioStates[localID]

    local model = o.oOldModel
    local animIndex = o.oOldCurAnimIndex
    local modelInfo = o.oOldModelInfo
    local category = o.oOldSelectedCategory
    local modelIndex = o.oOldSelectedModelIndex

    obj_set_model_extended(o, model)

    local seeker = nearest_team_to_object(TEAM_SEEKERS, o)

    if seeker and o.oUnHittable <= 0 and ((dist_between_objects(o, seeker.marioObj) <= 130 and sDamageActions[seeker.action]) or cur_obj_was_attacked_or_ground_pounded() ~= 0) then
        play_sound(SOUND_GENERAL_RACE_GUN_SHOT, gGlobalSoundSource)
        set_mario_action(seeker, ACT_SHOCKED, 0)
        gGlobalSyncTable.roundTimer = gGlobalSyncTable.roundTimer + gGlobalSyncTable.roundTimerMax * 0.1
        obj_mark_for_deletion_on_sync(o)
    end

    local miscInfo = sFakeObjectInfo[category].miscObjInfo[modelIndex]

    if miscInfo then
        local maxAnims = miscInfo.maxAnims
        if maxAnims then
            cur_obj_init_animation_with_sound(animIndex)
        end

        local func = miscInfo.loopFunc
        if func then
            func(o, m)
        end
        local animations = miscInfo.animations
        if not animations then
            o.header.gfx.animInfo.animFrame = 0
        end
    else
        o.header.gfx.animInfo.animFrame = 0
    end

    if modelInfo & MODEL_BILLBOARDED ~= 0 then
        o.header.gfx.node.flags = o.header.gfx.node.flags | GRAPH_RENDER_BILLBOARD
    else
        o.header.gfx.node.flags = o.header.gfx.node.flags & ~GRAPH_RENDER_BILLBOARD
    end

    if o.collisionData then
        load_object_collision_model()
    end

    o.oInteractStatus = 0
end

id_bhvStunObj = hook_behavior(nil, OBJ_LIST_SURFACE, true, stun_obj_init, stun_obj_loop, "bhvStunObj")

local function mario_update(m)
    if gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT == 0 or gGlobalSyncTable.gameState ~= GAME_STATE_ACTIVE then return end

    local fakeObj = obj_get_nearest_object_with_behavior_id(m.marioObj, id_bhvFakeObj)

    if fakeObj and m.heldObj == fakeObj and fakeObj.oFakeObjOwner and ps[m.playerIndex].team ~= TEAM_HIDERS then
        fakeObj.oHeldBy = npl[m.playerIndex].globalIndex
    end

    if ps[m.playerIndex].team ~= TEAM_HIDERS then return end

    local miscInfo = sFakeObjectInfo[ps[m.playerIndex].selectedCategory].miscObjInfo[ps[m.playerIndex].selectedModelIndex]

    if m.playerIndex ~= 0 or ps[m.playerIndex].frozen then
        m.marioObj.header.gfx.scale.x = 0
        m.marioObj.header.gfx.scale.y = 0
        m.marioObj.header.gfx.scale.z = 0
    else
        m.marioBodyState.modelState = m.marioBodyState.modelState | MODEL_STATE_NOISE_ALPHA
        if miscInfo and ps[m.playerIndex].validatedProp then
            local scale = miscInfo.scale
            if scale and scale.x and scale.y and scale.z then
                obj_scale_xyz(m.marioObj, scale.x, scale.y, scale.z)
            end
        end
    end

    if m.playerIndex ~= 0 then return end

    if not search_for_owned_obj(id_bhvFakeObj, npl[0].globalIndex) and npl[0].currLevelSyncValid and npl[0].currAreaSyncValid then
        spawn_sync_object(id_bhvFakeObj, 0, -90000, 0, 0,

        function(o)
            setup_fake_obj(o, npl[m.playerIndex].globalIndex, false)
            network_send(true, {id = PACKET_SETUP_PROP, owner = o.oFakeObjOwner})
        end)
    end

    local maxAnims = sFakeObjectInfo[ps[0].selectedCategory].miscObjInfo[ps[0].selectedModelIndex].maxAnims

    if ps[m.playerIndex].frozen then
        if m.action ~= ACT_FROZEN then
            vec3f_copy(sCamInfo.pos, m.pos)
            sCamInfo.yaw = m.faceAngle.y
            sCamInfo.pos.y = m.pos.y + 160
            ps[0].isUsingFreeCam = true
            set_mario_action(m, ACT_FROZEN, 0)
        end
    elseif not ps[m.playerIndex].frozen then
        if m.action == ACT_FROZEN then
            set_mario_action(m, m.prevAction, 0)
        end
    end

    if not propMenu or is_game_paused() and maxAnims and ps[0].curAnimIndex then

        if m.controller.buttonPressed & ANIM_LEFT_BUTTON ~= 0 and maxAnims then
            if ps[0].curAnimIndex > 0 then
                ps[0].curAnimIndex = ps[0].curAnimIndex - 1
            else
                play_sound(SOUND_MENU_CAMERA_BUZZ, gGlobalSoundSource)
                ps[0].curAnimIndex = 0
            end
        elseif m.controller.buttonPressed & ANIM_RIGHT_BUTTON ~= 0 and maxAnims  then
            if ps[0].curAnimIndex < maxAnims then
                ps[0].curAnimIndex = ps[0].curAnimIndex + 1
            else
                play_sound(SOUND_MENU_CAMERA_BUZZ, gGlobalSoundSource)
                ps[0].curAnimIndex = 0
            end
        end
    elseif not maxAnims then
        ps[0].curAnimIndex = 0
        maxAnims = 0
    end


    if m.action ~= ACT_LAVA_BOOST then
        m.health = 0x880
    end

    local notMoving = (m.action == ACT_WATER_IDLE or m.action == ACT_CRAWLING or m.action == ACT_HOLDING_POLE or m.action == ACT_TOP_OF_POLE) or (m.vel.x == 0 and m.vel.y == 0 and m.vel.z == 0 and m.forwardVel == 0)

    if m.playerIndex == 0 then
        if notMoving and not ps[m.playerIndex].frozen then
            if m.controller.buttonPressed & FREEZE_BUTTON ~= 0 then
                set_room_override(-1)
                camera_unfreeze()
                ps[m.playerIndex].frozen = not ps[m.playerIndex].frozen
                ps[m.playerIndex].isUsingFreeCam = not ps[m.playerIndex].frozen
                m.vel.x = 0
                m.vel.y = 0
                m.vel.z = 0
                m.forwardVel = 0
            end
        elseif ps[m.playerIndex].frozen then
            if m.controller.buttonPressed & FREEZE_BUTTON ~= 0 then
                set_room_override(-1)
                ps[m.playerIndex].frozen = false
                ps[m.playerIndex].isUsingFreeCam = false
                camera_unfreeze()
            end
        end
    end

    if m.controller.buttonDown & PROP_BUTTON ~= 0 and not propMenu and not is_game_paused() then
        propMenu = true
        play_sound(SOUND_GENERAL_PAINTING_EJECT, gGlobalSoundSource)
    end
end

local function char_sound(m, sound)
    if m.playerIndex == 0 or gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT == 0 then return end
    if ps[m.playerIndex].team == TEAM_HIDERS then
        return 0
    end
end

local function allow_interact(m, o, interactType)

    if gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT ~= 0 then
        if get_id_from_behavior(o.behavior) == id_bhvMario then return false end
        if get_id_from_behavior(o.behavior) == id_bhvFakeObj then
            if ps[m.playerIndex].team == TEAM_HIDERS then
                return false
            end
        end
    end
end

local function allow_pvp()
    if gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT ~= 0 then
        return false
    end
end

local function before_phys_step(m)
    if m.playerIndex ~= 0 or not ps[0].isSlow or ps[0].team ~= TEAM_HIDERS or gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT == 0 then return end

    slowTimer = slowTimer + 1

    if slowTimer > 15 * 30 then
        ps[0].isSlow = false
        slowTimer = 0
    end

    if ps[0].isSlow then
        m.vel.x = m.vel.x * 0.5
        m.vel.z = m.vel.z * 0.5
        if m.vel.y > 0 then
            m.vel.y = m.vel.y * 0.75
        end
    end
end

local sParticlesToKill = {
    [id_bhvBubbleMaybe] = true,
    [id_bhvBubbleSplash] = true,
    [id_bhvBubbleParticleSpawner] = true,
    [id_bhvBreathParticleSpawner] = true,
    [id_bhvSmallParticleBubbles] = true,
    [id_bhvWaterMist] = true,
    [id_bhvWaterMist2] = true,
    [id_bhvIdleWaterWave] = true,
    [id_bhvObjectBubble] = true,
    [id_bhvSnowParticleSpawner] = true,
}

local function on_obj_load(o)
    if sParticlesToKill[get_id_from_behavior(o.behavior)] and gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT ~= 0 then
        obj_mark_for_deletion(o)
    end
end

hook_event(HOOK_ON_OBJECT_LOAD, on_obj_load)
hook_event(HOOK_BEFORE_PHYS_STEP, before_phys_step)
hook_event(HOOK_ALLOW_INTERACT, allow_interact)
hook_event(HOOK_ALLOW_PVP_ATTACK, allow_pvp)
hook_event(HOOK_CHARACTER_SOUND, char_sound)
--hook_event(HOOK_ON_PACKET_RECEIVE, packet_receive)
hook_event(HOOK_MARIO_UPDATE, mario_update)
--hook_event(HOOK_BEFORE_MARIO_UPDATE, before_mario_update)
hook_event(HOOK_ON_HUD_RENDER, hud_render)