if unsupported then return end

alpha = 0

-- Replace music for vanilla levels --
if game == GAME_VANILLA then
    smlua_audio_utils_replace_sequence(35, 0x2A, 65, "bob") -- Hammer Bros. Theme - Super Mario Bros. 3
    smlua_audio_utils_replace_sequence(36, 23, 90, "wf") -- Puzzle Plank Galaxy - Super Mario Galaxy 2
    smlua_audio_utils_replace_sequence(37, 37, 70, "jrb") -- Underwater - Super Mario World
    smlua_audio_utils_replace_sequence(38, 0x2A, 70, "jrb-ship") -- Underwater - Super Mario Bros. 3
    smlua_audio_utils_replace_sequence(39, 0x2A, 85, "ccm") -- Snow - Super Mario Bros.
    smlua_audio_utils_replace_sequence(40, 37, 70, "ccm-slide") -- Chai Kingdom - Super Mario Land
    smlua_audio_utils_replace_sequence(41, 29, 90, "bitdw") -- Sector X - Star Fox 64
    smlua_audio_utils_replace_sequence(42, 37, 80, "bbh") -- SMB1 Ghost House
    smlua_audio_utils_replace_sequence(43, 37, 85, "hmc") -- Freeze! - Paper Mario
    smlua_audio_utils_replace_sequence(44, 0x0C, 75, "cotmc") -- KTD Masked Dedede
    smlua_audio_utils_replace_sequence(45, 37, 120, "lll") -- Sammer's Kingdom - Super Paper Mario
    smlua_audio_utils_replace_sequence(46, 34, 100, "lll-volcano") -- Chomp Attack - Paper Mario
    smlua_audio_utils_replace_sequence(47, 0x25, 75, "ssl") -- Ruins - Super Mario Land
    smlua_audio_utils_replace_sequence(48, 37, 100, "ssl-pyramid") -- Kirby Air Ride - Sky Sands
    smlua_audio_utils_replace_sequence(49, 19, 75, "ddd") -- Egg Rocket Zone 1 - Sonic Advance
    smlua_audio_utils_replace_sequence(50, 19, 75, "ddd-sub") -- [TBD]
    smlua_audio_utils_replace_sequence(51, 26, 90, "bitfs") -- Bowser Castle - Super Mario 3D World
    smlua_audio_utils_replace_sequence(52, 26, 90, "vcutm") -- Slope - Super Mario RPG
    smlua_audio_utils_replace_sequence(53, 37, 85, "sl") -- White Glacier - Bomberman 64
    smlua_audio_utils_replace_sequence(54, 37, 100, "wdw") -- Mafland - maf464
    smlua_audio_utils_replace_sequence(55, 37, 75, "wdw-town") -- Magic Charm Lesson - Magician's Quest - Mysterious Times
    smlua_audio_utils_replace_sequence(56, 37, 75, "ttm") -- Bridge Zone - Sonic the Hedgehog (8-bit)
    smlua_audio_utils_replace_sequence(57, 42, 85, "ttm-slide") -- Kirby Super Star Mine Cart Riding
    smlua_audio_utils_replace_sequence(58, 17, 80, "thi-small") -- Overworld Theme - Super Mario Bros. 2
    smlua_audio_utils_replace_sequence(59, 42, 80, "thi") -- Stage 1 (Cappy) - Kirby's Block Ball"
    smlua_audio_utils_replace_sequence(60, 42, 90, "ttc") -- Butter Building - Kirby's Adventure
    smlua_audio_utils_replace_sequence(61, 42, 75, "rr") -- Rainbow Route - Kirby & The Amazing Mirror
    smlua_audio_utils_replace_sequence(62, 42, 70, "wmotr") -- Clouds - Super Mario Bros. 3
    smlua_audio_utils_replace_sequence(63, 26, 90, "bits") -- It's Showtime! - M&L:BIS
    smlua_audio_utils_replace_sequence(64, 0x2A, 85, "pss") -- Bonus Theme - Super Mario World
    smlua_audio_utils_replace_sequence(65, 26, 90, "cg") -- Warp - Star Fox 64
    smlua_audio_utils_replace_sequence(66, 35, 65, "cu") -- Temple (Palace) - The Legend of Zelda 2: Adventure Of Link
    smlua_audio_utils_replace_sequence(67, 37, 30, "wf2") -- Castle Lololo - Kirby's Dream Land
    smlua_audio_utils_replace_sequence(68, 37, 75, "jrb2") -- Mt. Blaze - Pokemon Mystery Dungeon: Red/Blue Rescue Team
    smlua_audio_utils_replace_sequence(69, 37, 75, "ccm2") -- Frosty Forest - Pokemon Mystery Dungeon
    smlua_audio_utils_replace_sequence(70, 26, 75, "bbh2") -- Haunted Chase - Donkey Kong Country 2
    smlua_audio_utils_replace_sequence(71, 37, 70, "hmc2") -- ChuckleHuck Woods - Mario & Luigi: Superstar Saga
    smlua_audio_utils_replace_sequence(72, 42, 125, "hmc3") -- Kirby Super Star - The Great Cave Offensive
    smlua_audio_utils_replace_sequence(73, 42, 125, "lll2") -- [TBD]
    smlua_audio_utils_replace_sequence(74, 42, 75, "thi2") -- Forest Area - Kirby's Adventure
    smlua_audio_utils_replace_sequence(75, 28, 125, "rr2") -- Never Let Up! - Mario & Luigi: Dream Team
    smlua_audio_utils_replace_sequence(76, 28, 125, "rr3") -- [TBD]
    smlua_audio_utils_replace_sequence(77, 12, 75, "lobby1") -- Putt-Putt and Pep's Balloon-O-Rama - Levels 1-10
    smlua_audio_utils_replace_sequence(78, 19, 75, "lobby2") -- DK64 Fungi Forest Lobby
    smlua_audio_utils_replace_sequence(79, 37, 75, "lobby3") -- DK64 Banana Fairy Island
    smlua_audio_utils_replace_sequence(80, 26, 75, "lobby4") -- DKC2 Disco Train
    smlua_audio_utils_replace_sequence(81, 12, 175, "lobby5") -- Last Surprise - Persona 5
    smlua_audio_utils_replace_sequence(82, 35, 75, "lobby6") -- Earthbound Onett
    smlua_audio_utils_replace_sequence(83, 0x2A, 75, "lobby7") -- TLOZ:FSA Adventure Map
    smlua_audio_utils_replace_sequence(84, 37, 75, "lobby8") -- DKC3 Stilt Village
    smlua_audio_utils_replace_sequence(85, 12, 75, "lobby9") -- Undertale Shop
    smlua_audio_utils_replace_sequence(86, 37, 75, "lobby10") -- MKW Menu
    smlua_audio_utils_replace_sequence(87, 37, 75, "lobby11") -- Mother Pollyana
    smlua_audio_utils_replace_sequence(88, 37, 75, "lobby12") -- SMS Pinna Park
    smlua_audio_utils_replace_sequence(89, 0x2A, 70, "lobby13") -- SMB3 Sky Land
    smlua_audio_utils_replace_sequence(90, 35, 75, "lobby14") -- SSBB All-Star Rest Area
    smlua_audio_utils_replace_sequence(91, 26, 75, "lobby15") -- PokéRG - Jungle Relic
    smlua_audio_utils_replace_sequence(92, 23, 150, "lobby16") -- HL2 Triage At Dawn
    smlua_audio_utils_replace_sequence(93, 37, 75, "lobby17") -- TLOZ:OOT Inside A House
    smlua_audio_utils_replace_sequence(94, 37, 75, "lobby18") -- TLOZ:OOT Zora's Domain
    smlua_audio_utils_replace_sequence(95, 37, 75, "lobby19") -- Pipe Room - Super Mario Galaxy 2
    smlua_audio_utils_replace_sequence(96, 37, 75, "lobby20") -- DKC2 Stickerbush Symphony
    smlua_audio_utils_replace_sequence(97, 35, 75, "lobby21") -- Reach for the Stars - Sonic Colors
    smlua_audio_utils_replace_sequence(98, 37, 75, "lobby22") -- Bubsy 3D - Claws of Alarm
    smlua_audio_utils_replace_sequence(99, 18, 75, "lobby23") -- SML - Muda Kingdom
    smlua_audio_utils_replace_sequence(100, 37, 75, "lobby24") -- Knight Academy - The Legend of Zelda: Skyward Sword
    smlua_audio_utils_replace_sequence(101, 12, 75, "lobby25") -- Course Select - Super Mario Galaxy
    smlua_audio_utils_replace_sequence(102, 37, 75, "lobby26") -- Crossing Guard - WarioWare: Twisted
    smlua_audio_utils_replace_sequence(103, 37, 75, "lobby27") -- Map - Plok
    smlua_audio_utils_replace_sequence(104, 17, 75, "lobby28") -- Free Play - Mario Party 9
end

gLobbySongs = {
    [1]  = { id = 77,  name = "Levels 1-10 - Putt-Putt and Pep's Balloon-O-Rama" },
    [2]  = { id = 78,  name = "Fungi Forest Lobby - Donkey Kong 64" },
    [3]  = { id = 79,  name = "Banana Fairy Island - Donkey Kong 64" },
    [4]  = { id = 80,  name = "Disco Train - Donkey Kong Country 2" },
    [5]  = { id = 81,  name = "Last Surprise - Persona 5" },
    [6]  = { id = 82,  name = "Onett - Earthbound" },
    [7]  = { id = 83,  name = "Adventure Map - The Legend Of Zelda: Four Swords Adventures" },
    [8]  = { id = 84,  name = "Stilt Village - Donkey Kong Country 3" },
    [9]  = { id = 85,  name = "Shop - Undertale" },
    [10] = { id = 86,  name = "Menu - Mario Kart Wii"},
    [11] = { id = 87,  name = "Pollyana - Mother" },
    [12] = { id = 88,  name = "Pinna Park - Super Mario Sunshine" },
    [13] = { id = 89,  name = "Sky Land - Super Mario Bros. 3" },
    [14] = { id = 90,  name = "All-Star Rest Area - Super Smash Bros. Brawl" },
    [15] = { id = 91, name = "Jungle Relic - Pokémon Ranger" },
    [16] = { id = 92, name = "Triage At Dawn - Half Life 2" },
    [17] = { id = 93, name = "Inside A House - The Legend Of Zelda: Ocarina Of Time" },
    [18] = { id = 94, name = "Zora's Domain - The Legend Of Zelda: Ocarina Of Time" },
    [19] = { id = 95, name = "Pipe Room - Super Mario Galaxy 2" },
    [20] = { id = 96, name = "Stickerbush Symphony - Donkey Kong Country 2" },
    [21] = { id = 97, name = "Reach for the Stars - Sonic Colors" },
    [22] = { id = 98, name = "Claws of Alarm - Bubsy 3D" },
    [23] = { id = 99, name = "Muda Kingdom - Super Mario Land" },
    [24] = { id = 100, name = "Knight Academy - The Legend of Zelda: Skyward Sword" },
    [25] = { id = 101, name = "Course Select - Super Mario Galaxy" },
    [26] = { id = 102, name = "Crossing Guard - WarioWare: Twisted" },
    [27] = { id = 103, name = "Map - Plok" },
    [28] = { id = 104, name = "Free Play - Mario Party 9" }
}
gGlobalSyncTable.lobbySong = math.random(#gLobbySongs)

-- Lobby Music
local function level_init()
    if game == GAME_VANILLA and gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE and eFloodVariables.customMusic == true then
        if network_is_server() then
            gGlobalSyncTable.lobbySong = math.random(#gLobbySongs)
        end
        set_background_music(0, gLobbySongs[gGlobalSyncTable.lobbySong].id, 0)
    end
    if eFloodVariables.customMusic and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        if gLevels[gGlobalSyncTable.level].music
        and gLevels[gGlobalSyncTable.level].music.id ~= nil then
            set_background_music(0, gLevels[gGlobalSyncTable.level].music.id, 0)
        end
    end
end

-- main base taken from Arena
local function hud_render()
	if eHudVariables.musicDisplay then
        if game == GAME_VANILLA and eFloodVariables.customMusic then
		    djui_hud_set_resolution(RESOLUTION_DJUI);
		    djui_hud_set_font(FONT_NORMAL);
		    local screenWidth = djui_hud_get_screen_width()
		    local screenHeight = djui_hud_get_screen_height()
		    local height = 64
		    local y = screenHeight - height
		    djui_hud_set_color(225, 225, 225, is_game_paused() and gGlobalSyncTable.roundState == ROUND_STATE_INACTIVE and 255 or alpha);
		    local musicConfig = gLevels[gGlobalSyncTable.level].music
            if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
		        if musicConfig then
		            text = "Music: " .. musicConfig.name
		        end
            else
                text = "Music: " .. gLobbySongs[gGlobalSyncTable.lobbySong].name
            end
		    if text ~= nil then
		        djui_hud_print_text(text, (screenWidth - djui_hud_measure_text(text)) / 1.02, y, 1);
		    end
        else
            djui_hud_set_resolution(RESOLUTION_DJUI);
		    djui_hud_set_font(FONT_NORMAL);
		    local screenWidth = djui_hud_get_screen_width()
		    local screenHeight = djui_hud_get_screen_height()
		    local height = 64
		    local y = screenHeight - height
		    djui_hud_set_color(225, 225, 225, alpha);
		    local musicConfig = gLevels[gGlobalSyncTable.level].music
            if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
		        if musicConfig then
		            text = "Music: " .. musicConfig.name
                end
            else
                if gLobbies[gGlobalSyncTable.lobby].music and gLobbies[gGlobalSyncTable.lobby].music.name then
                    text = "Music: " ..  gLobbies[gGlobalSyncTable.lobby].music.name
                end
            end
		    if text ~= nil then
		        djui_hud_print_text(text, (screenWidth - djui_hud_measure_text(text)) / 1.02, y, 1);
		    end
        end
	end
end

local function mario_update(m)
    if m.playerIndex ~= 0 then return end

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        if gPlayerSyncTable[0].time >= 30 then
            if alpha < 255 and gPlayerSyncTable[0].time <= 150 then
                alpha = alpha + 3
            else
                alpha = alpha - 3
            end
        else
            alpha = 0
        end
        if alpha <= -1 then
            alpha = 0
        end
    else
        if gGlobalSyncTable.roundState == ROUND_STATE_END and alpha < 255 then
            alpha = alpha + 3
        else
            alpha = alpha - 3
        end
        if alpha <= -1 then
            alpha = 0
        end
    end
end

hook_event(HOOK_ON_LEVEL_INIT, level_init)
hook_event(HOOK_ON_HUD_RENDER, hud_render)
hook_event(HOOK_MARIO_UPDATE, mario_update)