//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldMoveModelEffect_Naminori.cpp
 *	@brief  gGtFNg
 *	@author	tomoya takahashi
 *	@date		2012.10.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "FieldMoveModelEffect_Naminori.h"

namespace field{
  namespace mmodel{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

    const MoveModelEffectManager::ResourceIndex EffectNaminori::NAMINORI_ANI[ RES_ANIM_NUM ] = 
    {
      BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_LOOP_BCHMATA,
      BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_LOOP_BCHSKLA,
	    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_LOOP_BCHMDLA,
	    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_LOOP_BCHSHDR,
      BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_SPEEDUP_BCHMATA,
      BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_SPEEDUP_BCHSKLA,
	    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_SPEEDUP_BCHMDLA,
	    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_SPEEDUP_BCHSHDR,
      BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_SLOWDOWN_BCHMATA,
      BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_SLOWDOWN_BCHSKLA,
	    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_SLOWDOWN_BCHMDLA,
	    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_SLOWDOWN_BCHSHDR,
      BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_STAND_BCHMATA,
      BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_STAND_BCHSKLA,
	    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_STAND_BCHMDLA,
	    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_STAND_BCHSHDR,
    };
    
    const MoveModelEffectManager::ResourceIndex EffectNaminori::NAMINORI_MDL[ RES_MDL_NUM ] = 
    {
      BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_STAND_BCHMDL,
      BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_NAMINORI_BCHMDL,
    };

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    /**
     *	@brief  
     *
     *	@param	p_wk    [N
     */
    //-----------------------------------------------------------------------------
    void EffectNaminori::InitFunc( void* p_work, MoveModelEffectManager* p_manager, MoveModelBase* p_model, gfl::heap::NwAllocator* p_heap, gfl::heap::NwAllocator* p_device ) const
    {
      Work* p_wk = reinterpret_cast<Work*>(p_work);
      bool result;
      MoveModel* p_movemodel = static_cast<MoveModel*>(p_model);

      gfl::grp::g3d::H3dResource* p_anmres[RES_ANIM_NUM] = {NULL};
      gfl::grp::g3d::H3dResource* p_mdlres[RES_MDL_NUM] = {NULL};
      gfl::grp::g3d::Scene* p_scene = p_manager->GetGraphics()->GetScene();

      p_wk->delete_seq = 0;

      // Aj[V
      for( u32 i=0; i<RES_ANIM_NUM; ++i ){
        p_anmres[i] = p_manager->GetResource( NAMINORI_ANI[i] );

        if( p_anmres[i]->GetSkeletalAnimContentCount() > 0 ){
          p_wk->p_anmres[i] = GFL_NEW(p_heap->GetHeapBase()) gfl::grp::g3d::H3dResSkeletalAnim();
        }
        else if( p_anmres[i]->GetMaterialAnimContentCount() > 0 ){
          p_wk->p_anmres[i] = GFL_NEW(p_heap->GetHeapBase()) gfl::grp::g3d::H3dResMaterialAnim();
        }
        else if( p_anmres[i]->GetVisibilityAnimContentCount() > 0 ){
          p_wk->p_anmres[i] = GFL_NEW(p_heap->GetHeapBase()) gfl::grp::g3d::H3dResVisibilityAnim();
        }
        if(p_wk->p_anmres[i]){
          p_wk->p_anmres[i]->Create( p_heap, p_device, p_anmres[i], 0 );
        }
      }

      // f\[X擾
      xy_system::H3dShaderModel::Description description;
      description.animation_slot_num = RES_ANIM_NUM;
      description.delete_memory_control = false;

      for( u32 i=0; i<RES_MDL_NUM; ++i ){
        p_mdlres[i] = p_manager->GetResource( NAMINORI_MDL[i] );

        p_wk->p_mdl[i] = GFL_NEW(p_heap->GetHeapBase()) xy_system::H3dShaderModel;
        p_wk->p_mdl[i]->Create( p_heap, p_device, p_mdlres[i], 0, &description );

        p_scene->AddH3dModelToCalc( p_wk->p_mdl[i], 0 );
        p_scene->AddH3dModelToDraw( p_wk->p_mdl[i], 0 );

        p_wk->p_mdl[i]->SetTreeFlag(false);
      }

      InitStatus( p_wk, p_device );

    }
    

    //----------------------------------------------------------------------------
    /**
     *	@brief  XV
     *
     *	@param	p_wk    [N
     *
     *	@retval true  I
     */
    //-----------------------------------------------------------------------------
    bool EffectNaminori::UpdateFunc( void* p_work, MoveModelEffectManager* p_manager, MoveModelBase* p_model ) const
    {
      Work* p_wk = reinterpret_cast<Work*>(p_work);
      bool result;
      MoveModel* p_movemodel = static_cast<MoveModel*>(p_model);
      gfl::heap::NwAllocator* p_device = p_manager->GetDeviceAllocater();

      gfl::math::VEC3 moveway;
      gfl::math::VEC3 pos;
      bool is_move = false;

      DrawStatus draw_status = p_movemodel->GetDrawStatus();

      // ړĂ邩H
      if( mmodel::MoveModelBase::GetDrawStatusKind( draw_status ) == MoveModelBase::DRAWSTA_KIND_SWIM ){
        is_move = true;
      }

      // ړ
      p_movemodel->GetDirMoveWay( &moveway );
      p_movemodel->GetVectorPos( &pos );
      moveway.y = 0.0f;

      // wayeỶ]pɕϊ
      // +ZpxOƂB
      f32 rot_y = gfl::math::Atan2Rad( moveway.x, moveway.z );

      moveway.x = 0.0f;
      moveway.y = rot_y;
      moveway.z = 0.0f;

      UpdateStatus( p_wk, p_device, is_move, moveway, pos );

      return false;
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  Calculate̍XV
     *
     *	@param	p_wk    [N
     */
    //-----------------------------------------------------------------------------
    void EffectNaminori::UpdateCalculateAfterFunc( void* p_work, MoveModelEffectManager* p_manager, MoveModelBase* p_model ) const
    {
    }


    //----------------------------------------------------------------------------
    /**
     *	@brief  j
     *
     *	@param	p_wk    [N
     */
    //-----------------------------------------------------------------------------
    bool EffectNaminori::DeleteFunc( void* p_work, MoveModelEffectManager* p_manager, MoveModelBase* p_model ) const
    {
      Work* p_wk = reinterpret_cast<Work*>(p_work);

      gfl::grp::g3d::Scene* p_scene = p_manager->GetGraphics()->GetScene();

      switch( p_wk->delete_seq ){
      case 0:
        for( u32 i=0; i<RES_MDL_NUM; ++i ){
          p_scene->RemoveH3dModelFromCalcAndAllDraw( p_wk->p_mdl[i] );
        }
        ++p_wk->delete_seq;
        break;

      case 1:
        for( u32 i=0; i<RES_MDL_NUM; ++i ){
          if(p_wk->p_mdl[i]){
            GFL_DELETE p_wk->p_mdl[i];
            p_wk->p_mdl[i] = NULL;
          }
        }

        for( u32 i=0; i<RES_ANIM_NUM; ++i ){
          if(p_wk->p_anmres[i]){
            GFL_DELETE p_wk->p_anmres[i];
            p_wk->p_anmres[i] = NULL;
          }
        }
        return true;
      }

      return false;
    }


    //----------------------------------------------------------------------------
    /**
     *	@brief  
     */
    //-----------------------------------------------------------------------------
    void EffectNaminori::InitStatus( Work* p_wk, gfl::heap::NwAllocator* p_device )
    {
      p_wk->status = STATUS_STAND;
      p_wk->frame = 0;
      ChangeStatus( p_wk, p_device, STATUS_STAND );
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  Xe[^XύX
     */
    //-----------------------------------------------------------------------------
    void EffectNaminori::ChangeStatus( Work* p_wk, gfl::heap::NwAllocator* p_device, u32 status )
    {
      u32 last_status = p_wk->status;
      
      p_wk->status = status;
      
      switch( p_wk->status ){
      case STATUS_STAND:
        {
          static const u32 s_on_Anime[] = {
            RES_ANIM_STAND_MAT,
            RES_ANIM_STAND_SKL,
            RES_ANIM_STAND_MDLA,
            RES_ANIM_STAND_SHDR,
          };
          p_wk->p_mdl[RES_MDL_STAND]->SetTreeFlag(true);
          p_wk->p_mdl[RES_MDL_MOVE]->SetTreeFlag(false);
          for( u32 i=0; i<RES_ANIM_NUM; ++i ){
            bool is_set = false;
            for( u32 j=0; j<GFL_NELEMS(s_on_Anime); ++j ){

              if( i == s_on_Anime[j] ){
                p_wk->p_mdl[ RES_MDL_STAND ]->ChangeAnimation( p_device, p_wk->p_anmres[i], 0, i );
                p_wk->p_mdl[ RES_MDL_STAND ]->SetAnimationLoop( true, i );
                p_wk->p_mdl[ RES_MDL_STAND ]->SetAnimationStepFrame( 1.0f, i );
                is_set = true;
                break;
              }
            }
            if( is_set == false ){
              p_wk->p_mdl[ RES_MDL_STAND ]->ChangeAnimation( NULL, NULL, 0, i );
            }
          }
        }
        break;
      
      case STATUS_SPEEDUP:
        {
          f32 start_frame = 0.0f;
          if( last_status == STATUS_SPEEDDOWN ){
            f32 max_frame = p_wk->p_mdl[ RES_MDL_MOVE ]->GetAnimationEndFrame(RES_ANIM_SLOWDOWN_SKL);
            start_frame = max_frame - p_wk->p_mdl[ RES_MDL_MOVE ]->GetAnimationFrame(RES_ANIM_SLOWDOWN_SKL);
          }
          
          static const u32 s_on_Anime[] = {
            RES_ANIM_SPEEDUP_MAT,
            RES_ANIM_SPEEDUP_SKL,
            RES_ANIM_SPEEDUP_MDLA,
            RES_ANIM_SPEEDUP_SHDR,
          };
          p_wk->p_mdl[RES_MDL_STAND]->SetTreeFlag(false);
          p_wk->p_mdl[RES_MDL_MOVE]->SetTreeFlag(true);
          for( u32 i=0; i<RES_ANIM_NUM; ++i ){
            bool is_set = false;
            for( u32 j=0; j<GFL_NELEMS(s_on_Anime); ++j ){

              if( i == s_on_Anime[j] ){
                p_wk->p_mdl[ RES_MDL_MOVE ]->ChangeAnimation( p_device, p_wk->p_anmres[i], 0, i );
                p_wk->p_mdl[ RES_MDL_MOVE ]->SetAnimationLoop( false, i );
                p_wk->p_mdl[ RES_MDL_MOVE ]->SetAnimationStepFrame( 1.0f, i );
                p_wk->p_mdl[ RES_MDL_MOVE ]->SetAnimationFrame( start_frame, i );
                is_set = true;
                break;
              }
            }
            if( is_set == false ){
              p_wk->p_mdl[ RES_MDL_MOVE ]->ChangeAnimation( NULL, NULL, 0, i );
            }
          }
        }
        break;
      
      case STATUS_SPEEDDOWN:
        {
          f32 start_frame = 0.0f;
          if( last_status == STATUS_SPEEDUP ){
            f32 max_frame = p_wk->p_mdl[ RES_MDL_MOVE ]->GetAnimationEndFrame(RES_ANIM_SPEEDUP_SKL);
            start_frame = max_frame - p_wk->p_mdl[ RES_MDL_MOVE ]->GetAnimationFrame(RES_ANIM_SPEEDUP_SKL);
          }
          
          static const u32 s_on_Anime[] = {
            RES_ANIM_SLOWDOWN_MAT,
            RES_ANIM_SLOWDOWN_SKL,
            RES_ANIM_SLOWDOWN_MDLA,
            RES_ANIM_SLOWDOWN_SHDR,
          };
          p_wk->p_mdl[RES_MDL_STAND]->SetTreeFlag(false);
          p_wk->p_mdl[RES_MDL_MOVE]->SetTreeFlag(true);
          for( u32 i=0; i<RES_ANIM_NUM; ++i ){
            bool is_set = false;
            for( u32 j=0; j<GFL_NELEMS(s_on_Anime); ++j ){

              if( i == s_on_Anime[j] ){
                p_wk->p_mdl[ RES_MDL_MOVE ]->ChangeAnimation( p_device, p_wk->p_anmres[i], 0, i );
                p_wk->p_mdl[ RES_MDL_MOVE ]->SetAnimationLoop( false, i );
                p_wk->p_mdl[ RES_MDL_MOVE ]->SetAnimationStepFrame( 1.0f, i );
                p_wk->p_mdl[ RES_MDL_MOVE ]->SetAnimationFrame( start_frame, i );
                is_set = true;
                break;
              }
            }
            if( is_set == false ){
              p_wk->p_mdl[ RES_MDL_MOVE ]->ChangeAnimation( NULL, NULL, 0, i );
            }
          }
        }
        break;
      
      case STATUS_LOOP:
        {
          static const u32 s_on_Anime[] = {
            RES_ANIM_LOOP_MAT,
            RES_ANIM_LOOP_SKL,
            RES_ANIM_LOOP_MDLA,
            RES_ANIM_LOOP_SHDR,
          };
          p_wk->p_mdl[RES_MDL_STAND]->SetTreeFlag(false);
          p_wk->p_mdl[RES_MDL_MOVE]->SetTreeFlag(true);
          for( u32 i=0; i<RES_ANIM_NUM; ++i ){
            bool is_set = false;
            for( u32 j=0; j<GFL_NELEMS(s_on_Anime); ++j ){

              if( i == s_on_Anime[j] ){
                p_wk->p_mdl[ RES_MDL_MOVE ]->ChangeAnimation( p_device, p_wk->p_anmres[i], 0, i );
                p_wk->p_mdl[ RES_MDL_MOVE ]->SetAnimationLoop( true, i );
                p_wk->p_mdl[ RES_MDL_MOVE ]->SetAnimationStepFrame( 1.0f, i );
                p_wk->p_mdl[ RES_MDL_MOVE ]->SetAnimationFrame( 0.0f, i );
                is_set = true;
                break;
              }
            }
            if( is_set == false ){
              p_wk->p_mdl[ RES_MDL_MOVE ]->ChangeAnimation( NULL, NULL, 0, i );
            }
          }
        }
        break;
      }
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  gGtFNgAj[V@܂
     */
    //-----------------------------------------------------------------------------
    bool EffectNaminori::IsAnimeEndStatus( const Work* cp_wk )
    {
      switch( cp_wk->status ){
      case STATUS_STAND:
        return cp_wk->p_mdl[ RES_MDL_STAND ]->IsAnimationFrameEndFrame( RES_ANIM_STAND_MAT );
      
      case STATUS_SPEEDUP:
        return cp_wk->p_mdl[ RES_MDL_MOVE ]->IsAnimationFrameEndFrame( RES_ANIM_SPEEDUP_SKL );
      
      case STATUS_SPEEDDOWN:
        return cp_wk->p_mdl[ RES_MDL_MOVE ]->IsAnimationFrameEndFrame( RES_ANIM_SLOWDOWN_SKL );
      
      case STATUS_LOOP:
        return cp_wk->p_mdl[ RES_MDL_MOVE ]->IsAnimationFrameEndFrame( RES_ANIM_LOOP_SKL );
      }

      GFL_ASSERT(0);
      return true;
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  Xe[^XXV
     */
    //-----------------------------------------------------------------------------
    void EffectNaminori::UpdateStatus( Work* p_wk, gfl::heap::NwAllocator* p_device, bool is_move, const gfl::math::VEC3& way, const gfl::math::VEC3& pos )
    {
      for( u32 i=0; i<RES_MDL_NUM; ++i ){
        p_wk->p_mdl[i]->SetTranslate( pos );
        p_wk->p_mdl[i]->SetRotateXYZ( way );
      }
      
      switch( p_wk->status ){
      case STATUS_STAND:
        if( is_move ){
          ChangeStatus( p_wk, p_device, STATUS_SPEEDUP );
        }
        break;
      
      case STATUS_SPEEDUP:
        if( is_move ){
          // Aj[VIB
          if( IsAnimeEndStatus( p_wk ) )
          {
            ChangeStatus( p_wk, p_device, STATUS_LOOP );
          }
        }else{
          ChangeStatus( p_wk, p_device, STATUS_SPEEDDOWN );
        }
        break;
      
      case STATUS_SPEEDDOWN:
        if( is_move ){
          ChangeStatus( p_wk, p_device, STATUS_SPEEDUP );
        }else{
          // Aj[VIB
          if( IsAnimeEndStatus( p_wk ) )
          {
            ChangeStatus( p_wk, p_device, STATUS_STAND );
          }
        }
        break;
      
      case STATUS_LOOP:
        if( !is_move ){
          ChangeStatus( p_wk, p_device, STATUS_SPEEDDOWN );
        }
        break;
      }
    }

    
  } // mmodel
} // field

