//============================================================================================
/**
 * @file		bag_touchbar.h
 * @brief		obO ^b`o[
 * @author	Hiroyuki Nakamura
 * @date		12.10.10
 *
 * namespace	app::bag::
 */
//============================================================================================
#if !defined( __BAG_TOUCHBAR_H__ )
#define __BAG_TOUCHBAR_H__

#include "app/ui/UITouchBarView.h"
#include "app/ui/UITouchBarListener.h"

namespace app {
namespace bag {

class TouchBar : public app::ui::UITouchBarView, public app::ui::UITouchBarListener {
public:
	enum {
		PRM_NONE = 0,
		PRM_HOLD,
		PRM_SELECT_EXIT,
		PRM_SELECT_RETURN,
		PRM_SELECT_HISTORY,
		PRM_SELECT_SORT,
	};

public:
	TouchBar(
		app::util::Heap * heap,
		gfl::grp::GraphicsSystem * grasys,
		gfl::grp::g2d::LytSys * lytsys,
		gfl::grp::g2d::LytWk * lytwk );

	~TouchBar();

	u32 GetParam(void);
	void SelectKeyButton( u32 prm );


	virtual void Update(void);

	void SetVisible( u32 buttonID, bool flg );
	void SetActive( u32 buttonID, bool flg );

	virtual bool OnSelectedButton( u32 buttonID );
//	virtual bool OnLongPressedButton( u32 buttonID );


private:
	u32	retParam;

};

}	// bag
}	// app

#endif	// __BAG_TOUCHBAR_H__
